  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  E     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc            
Simple calculations on R, L and C.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 8   (   Syntax10b.Scn.Fnt                                          "  MODULE electronic; (**)

IMPORT
	MathL
	,complex;

PROCEDURE setR*(r:LONGREAL; VAR z:complex.T);
(*
	Create a complex impedance corrisponding to a
	resistor. This is frequency independent.
*)
BEGIN
	z.re:=r; z.im:=0.0;
END setR;

PROCEDURE setC*(c:LONGREAL; f:LONGREAL; VAR z:complex.T);
(*
	Create a complex impedance corrisponding to a
	capacitor at a given frequency.
*)
BEGIN
	z.re:=0.0; z.im:=-1.0/(2.0*MathL.pi*f*c);
END setC;

PROCEDURE setL*(l:LONGREAL; f:LONGREAL; VAR z:complex.T);
(*
	Create a complex impedance corrisponding to an
	inductor at a given frequency.
*)
BEGIN
	z.re:=0.0; z.im:=2.0*MathL.pi*f*l;
END setL;

PROCEDURE serie*(a,b:complex.T; VAR z:complex.T);
(*
	Return the composite impedance of two complex
	impedances connected in series.
*)
BEGIN
	complex.add(a,b,z);
END serie;

PROCEDURE parallel*(a,b:complex.T; VAR z:complex.T);
(*
	Return the composite impedance of two complex
	impedances connected in parallel.
*)
BEGIN
	complex.inv(a);
	complex.inv(b);
	complex.add(a,b,z);
	complex.inv(z);
END parallel;

END electronic.
