RC  Syntax10.Scn.Fnt      E  InfoElems Alloc  #   Syntax10.Scn.Fnt       "Title": Show chances of winning a memory type game. This is a simulation, I wrote to find out, which of two strategy would be the best for playing a memory game.
"Copyright": 1996, 1997 by Claudio Nieder <claudio@dial.eunet.ch>.

	This module is free software; you can redistribute it and/or modify it under the terms of the GNU
	Library General Public License as published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License along with this library;
	if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     58  FoldElems New    Syntax10.Scn.Fnt      P[  ParcElems Alloc        P[  u      P[         Syntax10b.Scn.Fnt      M        /        ,        J
   s         
	During the night hours, on german television N3 you can play some interactive games via telephone. Four players can call in via phone and using their phone keyboard participate to the game. The game board can be seen on the telly.
	
One of the games is a memory game. You have a 4x5 field of covered cards. There are 10 card sujets, each sujet is on two cards, and the goal is to find matching cards. When a player has her/his turn, she/he can uncover two cards. If they match, she/he gets a point and she/he repeats the operation again. If she/he uncovers two different cards, she/he gets no point, and it's up to the next player to continue with the game.
	
As nobody sees, what the players do at home, any player could write down what card she/he has seen, at which place, so one can assume, that each player will remember all cards already examined by her/him or other players. So I wondered, which strategy is better for winning the game when it's the own turn to play, in case the first card uncovered is one never seen:
	
a)	One chooses at random one of the not yet uncovered cards, hoping to find the match card and make a point. The disadvantage is, that if you uncover the wrong card, the other players get new information about an uptohere unknow card.
			
b)	One uncovers a card already uncovered earlier. It will definitly not be the right one, but the advantage might be, that you don't show to other players a new card.
	 
I thought, a way to find out is to simulate it. This program is the result. It will play the game over and over again. And it will do it for each combinations of player to strategy association.
	 
When you open the viewer with gameStat.Open you will just see a number. This is the count of already played rounds. With gameStat.Start you tell the background task to start playing. gameStat.Stop will obviously stop the background task and gameStat.Reset will reset the data.
	 
 After starting, a whoole bunch of bar graphs will open. The bars have two colors depending on the strategy.
	 
The red colored bars (color number 1) show wins using strategy a, i.e. pick a yet uncovered card. The blue colored bars (color number 1) show wins using strategy b, i.e. pick an already tried card.

The bar graph at the upper left with two bars shows the percentage of games won using the different strategies. Thus it gives you an overall indication of what the better strategy is, independent of which player you are, and what strategies the other players choose. For actually choosing a strategy when playing the game, this data would be useless.

The bar graph at the upper right with as many bars as there are players, show a stacked bar which tells as percentage how many games were won with either of the strategy. Thus the total length of the graph gives you the percentage of games won independently of what strategy you use.

This is an inidcation of how fair the game can be. You see this exceptionally well, if you configure the progrm for few cards and many players. Then you will see, that the players at the extreme ends have less chance as the players in the middle. This is obvious, as the first has bad luck because she/he hasn't yet seen any card, and the last player has bad luck because chance is high that players before her/him have already picked up most of the cards.

The bar is split in a red and blue portion which reflect the percentage of games won with each of the two strategies. They give you an indication on which strategy to choose, giving the fact that you don't know what the other players do. This seems to be very informative data for choosing a strategy.

The two to the power of the number of players bar graphs below, show statistics for the different combinations of strategies and players. You can see, the chance of each player to win given the strategies selected by each player. There you see, that the chances of winning do not only depend on what you choose, but also what other players choose. For example, if the first player selects the blue strategy, this can make him the winner most of the time (when 2 and 3 choose blue and 4 chooses red) or great looser (when 2,3 choose red and 4 chooses blue).

The program can be customized by four constants:

spielerZahl: The number of players in the game
paarZahl: The number of card pairs (paarZahl=10 means 20 cards).
updateRate: The number of games to occur before an update message is sent to the viewers.
delayMs: The number of milliseconds the task shall delay, until a new round is played.
	 
 8   
    8   #   Syntax10.Scn.Fnt  <    <   
	Display,Fonts,Input,MenuViewers,Oberon,TextFrames,Viewers; 8   E    8   #   Syntax10.Scn.Fnt         
	hintergrund=Display.black; rot=1; blau=3; vordergrund=Display.white;
	kartenZahl=2*paarZahl; (* muss gerade sein. *)
	strategieZahl=ASH(1,spielerZahl); spalten=ASH(1,spielerZahl DIV 2); zeilen=strategieZahl DIV spalten; 8       8   #   Syntax10.Scn.Fnt       
	Frame=POINTER TO FrameDesc;
	FrameDesc=RECORD(Display.FrameDesc)
	END;
	Gewinne=ARRAY spielerZahl OF LONGINT;
	Memory=ARRAY kartenZahl OF SHORTINT;
	Message=RECORD(Display.FrameMsg)
		clear:BOOLEAN;
	END;
	SpielerTotal=ARRAY spielerZahl OF ARRAY 2 OF LONGINT;
	Strategien=ARRAY strategieZahl OF Gewinne;
	StrategieTotal=ARRAY 2 OF LONGINT;
	StrategieWahl=ARRAY strategieZahl OF ARRAY spielerZahl OF BOOLEAN;
	Statistik=RECORD
		spiele:LONGINT;
		strategien:Strategien;
		strategieTotal:StrategieTotal;
		spielerTotal:SpielerTotal;
	END; 8       ^8   #   Syntax10.Scn.Fnt         
	alteKarteStrategie:StrategieWahl;
	font:Fonts.Font;
	running:BOOLEAN;
	statistik:Statistik;
	seed: LONGINT;
	task:Oberon.Task; 8   '    8   #   Syntax10.Scn.Fnt         
	CONST a=16807; m=2147483647; q=m DIV a; r=m MOD a;
	BEGIN
		IF max<2 THEN RETURN 0 END;
		seed:=a*(seed MOD q)-r*(seed DIV q);
		IF seed < 0 THEN seed:=seed+m END;
		RETURN SHORT(seed MOD max)
	END RND;
 8   )    .8   C   Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt             
VAR i, j: SHORTINT;
BEGIN
	FOR i:=0 TO kartenZahl-1 DO j:=SHORT(RND(i)); memory[i]:=memory[j]; memory[j]:=i MOD paarZahl; END;
END InitMemory;
 8   C    8      Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt  3    3   
	s:INTEGER;
	spieler:SHORTINT;
	strategie:INTEGER; 8          
VAR
BEGIN
	FOR strategie:=0 TO strategieZahl-1 DO
		s:=strategie;
		FOR spieler:=0 TO spielerZahl-1 DO alteKarteStrategie[strategie][spieler]:=ODD(s); s:=s DIV 2; END;
	END;
END InitStrategieWahl;
 8   S    8   w  Syntax10.Scn.Fnt      ,8  FoldElems New  #   Syntax10.Scn.Fnt         
	entfernt:SHORTINT;
	gefunden:ARRAY paarZahl OF BOOLEAN;
	i:SHORTINT;
	karte:SHORTINT;
	punkte:ARRAY spielerZahl OF SHORTINT;
	s:SHORTINT;
	spieler:SHORTINT;
	verdeckt:SHORTINT; 8     Syntax10b.Scn.Fnt      w       )        n    i    n     
VAR
BEGIN
	FOR spieler:=0 TO spielerZahl-1 DO punkte[spieler]:=0; END;
	FOR i:=0 TO paarZahl-1 DO gefunden[i]:=FALSE; END;
	entfernt:=0; spieler:=0; verdeckt:=0;
	REPEAT
		LOOP
			karte:=memory[verdeckt];
			IF gefunden[karte] THEN (* gefunden *)
				INC(verdeckt);
				INC(entfernt,2);
				INC(punkte[spieler]);
			ELSIF alteKarteStrategie[strategie,spieler] & (entfernt#verdeckt) THEN (* Zeige schon gesehene Karte. *)
				gefunden[karte]:=TRUE;
				INC(verdeckt);
				EXIT;
			ELSIF memory[verdeckt+1]=karte THEN (* Neue Karte genommen und richtig geraten. *)
				INC(verdeckt,2);
				INC(entfernt,2);
				INC(punkte[spieler]);
			ELSE (* Neue Karte genommen und falsch geraten. *)
				gefunden[karte]:=TRUE;
				INC(verdeckt);
				karte:=memory[verdeckt];
				IF ~gefunden[karte] THEN
					gefunden[karte]:=TRUE;
					INC(verdeckt);
				END;
				EXIT;
			END;
			IF verdeckt=kartenZahl THEN EXIT; END; (* Spiel-Ende *)
		END; (* loop *)
		spieler:=(spieler+1) MOD spielerZahl;
	UNTIL verdeckt=kartenZahl;
	ASSERT(verdeckt=entfernt);
	s:=0; FOR i:=0 TO spielerZahl-1 DO s:=s+punkte[i]; END; ASSERT(s=paarZahl);
	(* Ermittle Gewinner und trage Statistik nach. *)
	spieler:=0;
	FOR i:=1 TO spielerZahl-1 DO
		IF punkte[i]>punkte[spieler] THEN spieler:=i; END;
	END;
	INC(statistik.strategien[strategie][spieler]);
	IF alteKarteStrategie[strategie][spieler] THEN i:=1; ELSE i:=0; END;
	INC(statistik.strategieTotal[i]);
	INC(statistik.spielerTotal[spieler][i]);
END SpieleMemory;
 8   2    f8   #   Syntax10.Scn.Fnt  x   x  
VAR
	i:SHORTINT;
	spieler:SHORTINT;
	strategie:INTEGER;
BEGIN
	statistik.spiele:=0;
	FOR strategie:=0 TO strategieZahl-1 DO
		FOR spieler:=0 TO spielerZahl-1 DO statistik.strategien[strategie][spieler]:=0; END;
	END;
	FOR i:=0 TO 1 DO
		statistik.strategieTotal[i]:=0;
		FOR spieler:=0 TO spielerZahl-1 DO statistik.spielerTotal[spieler][i]:=0; END;
	END;
END InitStatistik;
 8       s8   #   Syntax10.Scn.Fnt  k   k  
VAR
	memory:Memory;
	message:Message;
	strategie:INTEGER;
BEGIN
	INC(Oberon.CurTask.time,(delayMs*1000) DIV Input.TimeUnit DIV updateRate);
	InitMemory(memory);
	INC(statistik.spiele);
	FOR strategie:=0 TO strategieZahl-1 DO
		SpieleMemory(memory,strategie,statistik);
	END;
	IF (statistik.spiele MOD updateRate)=0 THEN Viewers.Broadcast(message); END;
END Task; 8   :    8   #   Syntax10.Scn.Fnt       
CONST
	digits=8;
VAR
	ch,cw,cx,cy,dx:INTEGER;
	i,j:INTEGER;
	p:Display.Pattern;
	s:ARRAY digits+1 OF CHAR;
BEGIN
	x:=x+frame.X;
	y:=y+frame.Y;
	Display.ReplConstC(frame,hintergrund,x-5,y-3,font.maxX*digits,font.height,Display.replace);
	i:=digits;
	REPEAT
		DEC(i);
		s[i]:=CHR(ORD('0')+n MOD 10);
		n:=n DIV 10;
	UNTIL n=0;
	FOR j:=i TO digits-1 DO
		Display.GetChar(font.raster,s[j],dx,cx,cy,cw,ch,p);
		Display.CopyPatternC(frame,vordergrund,p,x+cx,y+cy,Display.replace);
		INC(x,dx);
	END;
END WriteNum;
 8   N    {8   #   Syntax10.Scn.Fnt  c   c  
BEGIN
	x:=x+frame.X;
	y:=y+frame.Y;
	Display.ReplConstC(
		frame,farbe,x,y,breite,h,Display.replace
	);
	Display.ReplConstC(
		frame,hintergrund,x+breite,y,ganzeBreite-breite,h,Display.replace
	);
	Display.ReplConstC(frame,vordergrund,x,y,1,h,Display.replace);
	Display.ReplConstC(frame,vordergrund,x,y,ganzeBreite,1,Display.replace);
END ZeichneBalken;
 8   e    8   #   Syntax10.Scn.Fnt       
BEGIN
	x:=x+frame.X;
	y:=y+frame.Y;
	Display.ReplConstC(
		frame,farbe1,x,y,breite1,h,Display.replace
	);
	Display.ReplConstC(
		frame,farbe2,x+breite1,y,breite2,h,Display.replace
	);
	Display.ReplConstC(
		frame,hintergrund,x+breite1+breite2,y,ganzeBreite-breite1-breite2,h,Display.replace
	);
	Display.ReplConstC(frame,vordergrund,x,y,1,h,Display.replace);
	Display.ReplConstC(frame,vordergrund,x,y,ganzeBreite,1,Display.replace);
END ZeichneDoppelBalken;
 8   K    n8   #   Syntax10.Scn.Fnt  p   p  
VAR
	h2:INTEGER;
	farbe:SHORTINT;
	spieler:SHORTINT;
BEGIN
	h2:=h DIV spielerZahl;
	FOR spieler:=0 TO spielerZahl-1 DO
		IF alteKarteStrategie[strategie][spieler] THEN farbe:=blau; ELSE farbe:=rot; END;
		ZeichneBalken(
			frame,farbe,x,y-(spieler+1)*h2,SHORT(LONG(w)*statistik.strategien[strategie][spieler] DIV statistik.spiele),w,h2
		);
	END;
END ZeigeStrategie;
 8   -    8     Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt  
    
   
	rand=10; 8       8   #   Syntax10.Scn.Fnt         
	i,j:INTEGER;
	h,w:INTEGER;
	hStrategie:INTEGER;
	kopf:INTEGER;
	n:LONGINT;
	strategie:INTEGER;
	top:INTEGER;
	wStrategie:INTEGER;
	xStrategie:ARRAY spalten OF INTEGER;
	yStrategie:ARRAY zeilen OF INTEGER;
	x,y:INTEGER; 8      E        X  
CONST
VAR
BEGIN
	kopf:=10*spielerZahl; IF kopf<40 THEN kopf:=40; END;
	top:=frame.H-TextFrames.menuH;
	wStrategie:=SHORT((frame.W-(spalten+1)*rand) DIV spalten);
	IF wStrategie<10 THEN wStrategie:=10; END;
	FOR i:=0 TO spalten-1 DO xStrategie[i]:=rand+i*(wStrategie+rand); END;
	hStrategie:=spielerZahl*((top-(zeilen+2)*rand-kopf) DIV (zeilen*spielerZahl)); 
	IF hStrategie<20 THEN hStrategie:=20; END;
	FOR i:=0 TO zeilen-1 DO yStrategie[i]:=top-rand-kopf-i*(hStrategie+rand); END;
	Oberon.FadeCursor(Oberon.Mouse);
	IF redraw THEN Display.ReplConstC(frame,hintergrund,frame.X,frame.Y,frame.W,frame.H,Display.replace); END;

	IF statistik.spiele>0 THEN
		h:=kopf DIV 4;
		w:=(frame.W-3*rand) DIV 2;
		n:=strategieZahl*statistik.spiele;
	
		x:=rand;
		ASSERT(n=statistik.strategieTotal[0]+statistik.strategieTotal[1]);
		ZeichneBalken(frame,rot,x,top-rand-2*h,SHORT(LONG(w)*statistik.strategieTotal[0] DIV n),w,h);
		ZeichneBalken(frame,blau,x,top-rand-3*h,SHORT(LONG(w)*statistik.strategieTotal[1] DIV n),w,h);
	
		h:=kopf DIV spielerZahl;
		x:=frame.W DIV 2+frame.X+rand DIV 2;
		FOR i:=0 TO spielerZahl-1 DO
			ZeichneDoppelBalken(frame,rot,blau,x,top-rand-i*h
				,SHORT(LONG(w)*statistik.spielerTotal[i][0] DIV n),SHORT(LONG(w)*statistik.spielerTotal[i][1] DIV n),w,h
			);
		END;
		
		FOR i:=0 TO zeilen-1 DO
			y:=yStrategie[i];
			FOR j:=0 TO spalten-1 DO
				strategie:=SHORT(SHORT(i*spalten+j));
				x:=xStrategie[j];
				IF (y>0) & (x<frame.W) THEN
					ZeigeStrategie(frame,x,y,wStrategie,hStrategie,strategie);
				END;
			END;
		END;
	END;
	WriteNum(frame,rand,top-rand DIV 2,statistik.spiele);
END Show;
 8   B    8      Syntax10.Scn.Fnt                                                                                 !    V  
VAR
	newFrame:Frame;
BEGIN
	WITH frame:Frame DO
		IF msg IS Message THEN
			Show(frame,msg(Message).clear);
		ELSIF msg IS Oberon.CopyMsg THEN
			NEW(newFrame);
			newFrame^:=frame^;
			msg(Oberon.CopyMsg).F:=newFrame;
		ELSIF msg IS MenuViewers.ModifyMsg THEN
			WITH msg:MenuViewers.ModifyMsg DO
				frame.Y:=msg.Y;
				frame.H:=msg.H;
				IF msg.H>TextFrames.menuH THEN Show(frame,TRUE); END;
			END;
		ELSIF msg IS Oberon.InputMsg THEN
			WITH msg:Oberon.InputMsg DO
				IF msg.id=Oberon.track THEN Oberon.DrawCursor(Oberon.Mouse,Oberon.Arrow,msg.X,msg.Y) END
			END;
		END;
	END;
END Handler; 8      Syntax10b.Scn.Fnt          Q8   #   Syntax10.Scn.Fnt       
VAR
	dummyV:Viewers.Viewer;
	mainFrame:Frame;
	menuFrame:TextFrames.Frame;
	x,y:INTEGER;
BEGIN
	Oberon.AllocateUserViewer(Oberon.Par.vwr.X,x,y);
	menuFrame:=TextFrames.NewMenu("GameStat","System.Close gameStat.Start gameStat.Stop gameStat.Reset System.Grow System.Copy  ");
	NEW(mainFrame);
	mainFrame.handle:=Handler;
	dummyV:=MenuViewers.New(menuFrame,mainFrame,TextFrames.menuH,x,y);
END Open; 8               N8   #   Syntax10.Scn.Fnt         
VAR
	message:Message;
BEGIN
	IF ~running THEN
		InitStatistik(statistik);
		message.clear:=TRUE;
		Viewers.Broadcast(message);
	END;
END Reset; 8               C8   #   Syntax10.Scn.Fnt         
VAR
	message:Message;
BEGIN
	Oberon.Remove(task);
	IF running THEN
		running:=FALSE;
		message.clear:=FALSE;
		Viewers.Broadcast(message);
	END;
END Stop; 8               ;8   #   Syntax10.Scn.Fnt         
BEGIN
	IF ~running THEN
		NEW(task);
		task.safe:=FALSE;
		task.handle:=Task;
		task.time:=Input.Time();
		Oberon.Install(task);
		running:=TRUE;
	END;
END Start; 8       98   #   Syntax10.Scn.Fnt         
	ASSERT(~ODD(kartenZahl));
	font:=Fonts.This("Syntax14.Scn.Fnt");
	running:=FALSE;
	seed:=65539;
	InitStrategieWahl(alteKarteStrategie);
	InitStatistik(statistik);
 8   
      MODULE gameStat; 
(**)

IMPORT

CONST
	spielerZahl=4; paarZahl=10;	updateRate=1; delayMs=50;

CONST
		
TYPE
	
VAR

PROCEDURE RND(max: INTEGER): INTEGER;
PROCEDURE InitMemory(VAR memory:Memory);
PROCEDURE InitStrategieWahl(VAR alteKarteStrategie:StrategieWahl);
PROCEDURE SpieleMemory(memory:Memory; strategie:INTEGER; VAR statistik:Statistik);
PROCEDURE InitStatistik(VAR statistik:Statistik);	

PROCEDURE Task;

PROCEDURE WriteNum(frame:Frame; x,y:INTEGER; n:LONGINT);
PROCEDURE ZeichneBalken(frame:Frame; farbe,x,y,breite,ganzeBreite,h:INTEGER);
PROCEDURE ZeichneDoppelBalken(frame:Frame; farbe1,farbe2,x,y,breite1,breite2,ganzeBreite,h:INTEGER);
PROCEDURE ZeigeStrategie(frame:Frame; x,y,w,h:INTEGER; strategie:INTEGER);
PROCEDURE Show(frame:Frame; redraw:BOOLEAN);
PROCEDURE Handler(frame:Display.Frame; VAR msg:Display.FrameMsg);

PROCEDURE Open*;

PROCEDURE Reset*;

PROCEDURE Stop*;

PROCEDURE Start*;

BEGINEND gameStat.