A  Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt  S  InfoElems Alloc  #   Syntax10.Scn.Fnt       "Title": A program which renders a reflecting ball over a plane. I use this program, which is a rough translation of a basic source, as a benchmark.
"Copyright": 1996, 1997 by Claudio Nieder <claudio@dial.eunet.ch>.

	This module is free software; you can redistribute it and/or modify it under the terms of the GNU
	Library General Public License as published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License along with this library;
	if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   HistoryElems Alloc History #   Syntax10.Scn.Fnt  4    4   "1997-09-02	claudio@dial.eunet.ch"
	First release.

     s  ParcElems Alloc  
  O   Courier10.Scn.Fnt  !    "    !        #    "    !        $    &    '    &    %        !    +    !                 $                i       $                T               |                   	    U                  ;  MODULE kugel; 
(*
kugel.zeichne	Display on		Display off		Display part

Amiga 25 MHz 68030+68882:	20    s	 1	14.1  s	 1	 5.9  s	 1
Asus 133MHz Pentium, Linux 1.12.13	 0.39 s	51	 0.28 s	50	 0.11 s	54
Compaq MHz Pentium:	 1.1  s	18	 0.4  s	35	 0.7  s	 8.4
Decstation 5000/33, ?? Mhz R3000:	 1.4  s	14	 1.0  s	14	 0.4  s	15
HP 712/80 80MHz PA7100LC:	 0.64 s   31	 0.45 s	31	 0.19 s	31	
Mac Powerbook 170, 25MHz 68030+68882:	41    s	 0.48	14.4  s	 1	26.9  s	 0.22
Mac Powerbook 3400c, 200MHz PPC 604e:	 2.95 s	 6.8	 0.28 s	50	 2.67 s	 2.2
SGI Indy 100 MHZ R4600+R4610:	 0.65 s	30	 0.5  s	28	 0.15 s	39
SGI Indy 100 MHZ R4600+R4610 (Float=REAL):	 0.53 s	38	 0.38 s	37	 0.15 s	39
*)
IMPORT
	Display, Texts, Input, Oberon, Log, Math:=MathL;
	
CONST
	display=TRUE;
	log=FALSE;
	toRad = Math.pi/180;
	BildBreite=400;
	BildHoehe=300;

TYPE
	Float=LONGREAL;
		
TYPE
	Coord = ARRAY 3 OF Float;
	Coord2 = ARRAY 2 OF Float;
	Coord2I = ARRAY 2 OF LONGINT;

VAR
	blick, kamera, kugel, lampe: Coord;
	zeile, reflexion: Coord;
	projA, projB, lampeKugel, kameraKugel, kugelReflexion: Coord;
	oeffnung: Coord2;
	ausschnitt, eckeLU, eckeRO: Coord2I;
	cc, cd, ce, cf: Float;
	a, b, c, d, e, f: Float;
	ma, mb, mc: Float;
	keineKugel, randLinks, randRechts, f3, f4, keinSchatten: BOOLEAN;
	g: Float;
	h: Float;
	i: Float;
	j: Float;
	k: Float;
	l: Float;
	m: Float;
	n: Float;
	o: Float;
	p: Float;
	q: Float;
	r, kugelRadiusQ: Float;
	s, s1, s2, s3, s4, sq, sr: LONGINT;
	t,               (* y-Koordinate auf Projektionsflche *)
	tt:LONGINT;              (* y-Koordinate auf Bildschirm *)
	u: Float;
	v: Float;
	w: Float;
	x: Float;
	y: Float;
	z: Float;


PROCEDURE Line(x1, y1, x2, y2: LONGINT);
	VAR t: LONGINT;
	BEGIN
		IF x1>x2 THEN t:=x1; x1:=x2; x2:=t END;
		IF y1>y2 THEN t:=y1; y1:=y2; y2:=t END;
		IF display THEN Display.ReplConst(Display.white, SHORT(x1), SHORT(y1), SHORT(x2-x1+1), SHORT(y2-y1+1), Display.replace) END;
	END Line;

PROCEDURE WriteReal(r: Float);
	VAR w: Texts.Writer;
	BEGIN
		Texts.OpenWriter(w);
		Texts.WriteLongReal(w, r, 7);
		Texts.Append(Oberon.Log, w.buf);
	END WriteReal;

PROCEDURE Sgn(x: Float): Float;
	BEGIN
		IF x>0.0 THEN RETURN 1.0
		ELSIF x<0.0 THEN RETURN -1.0
		ELSE RETURN 0.0
		END
	END Sgn;

PROCEDURE SgnI(x: LONGINT): LONGINT;
	BEGIN
		IF x>0 THEN RETURN 1
		ELSIF x<0 THEN RETURN -1
		ELSE RETURN 0
		END
	END SgnI;

PROCEDURE Tan(x: Float): Float;
	BEGIN RETURN Math.sin(x)/Math.cos(x) END Tan;

PROCEDURE FloorI(x: Float): LONGINT;
	(* FloorI(2.7)=2; Floor(-2.7)=-3 *)
	BEGIN
		RETURN ENTIER(x)
	END FloorI;

PROCEDURE WriteCoord(p: Coord);
	BEGIN
		Log.Ch('('); WriteReal(p[0]);
		Log.Str(' /'); WriteReal(p[1]);
		Log.Str(' /'); WriteReal(p[2]); Log.Ch(')');
	END WriteCoord;

PROCEDURE WriteCoord2(p: Coord2);
	VAR i: LONGINT;
	BEGIN
		FOR i:=0 TO 1 DO WriteReal(p[i]) END
	END WriteCoord2;

PROCEDURE WriteCoord2I(p: Coord2I);
	VAR i: LONGINT;
	BEGIN
		FOR i:=0 TO 1 DO Log.Int(p[i]) END;
	END WriteCoord2I;

PROCEDURE VProd(VAR c: Coord; a, b: Coord);
	VAR
		i: LONGINT;
		lr1, lr2:Float;
	BEGIN
		FOR i:=0 TO 2 DO
			lr1:=a[(i+1) MOD 3]*b[(i+2) MOD 3];
			lr2:=a[(i+2) MOD 3]*b[(i+1) MOD 3];
			c[i]:=lr1-lr2
		END
	END VProd;

PROCEDURE SProd(a, b: Coord): Float;
	BEGIN
		RETURN a[0]*b[0] + a[1]*b[1] + a[2]*b[2]
	END SProd;

PROCEDURE Betrag(a: Coord): Float;
	BEGIN
		RETURN Math.sqrt(SProd(a, a));
	END Betrag;

PROCEDURE Muster;
	(* input: s, tt, reflexion *)
	VAR b: BOOLEAN;
	BEGIN
		b:=ODD(FloorI(reflexion[0]));
		IF b=ODD(FloorI(reflexion[1])) THEN
			IF display THEN Display.Dot(Display.white, SHORT(s-eckeLU[0]), SHORT(tt), Display.replace); END;
		END;
	END Muster;

(*
PROCEDURE Muster;
	(* input: s, tt, reflexion *)
	VAR b: BOOLEAN;
		r,x,y:Float;
	BEGIN
		x:=reflexion[0]-FloorI(reflexion[0])-0.5;
		y:=reflexion[1]-FloorI(reflexion[1])-0.5;
		r:=x*x+y*y;
		b:=(0.1<r) & (r<0.2);
		IF b THEN
			IF display THEN Display.Dot(Display.white, SHORT(s-eckeLU[0]), SHORT(tt), Display.replace); END;
		END;
	END Muster;
*)

PROCEDURE P400(so, sp: LONGINT);
	BEGIN
		FOR s:=so TO sp DO
			reflexion[0]:=cc*s + cd;
			reflexion[1]:=ce*s + cf;
			Muster;
		END;
	END P400;

PROCEDURE KugelRand;
	(* input variable: t 
	    Konstanten: a, b, c, d, e, f
	    output variable: s1, s2, randRechts, randLinks, keineKugel
	*)
	VAR
		di: Float;
		sr1, sr2, tr, temp1, temp2, temp3: Float;
	BEGIN
		tr:=t; (* tr is Float *)
		temp1:=c*tr + d;
		di:=temp1*temp1-a*((b*tr + e)*tr + f);
		IF di<0.0 THEN keineKugel:=TRUE; RETURN END;
		
		temp2:=Math.sqrt(di)*Sgn(a);
		sr1:=(temp1-temp2)/a; sr2:=(temp1+temp2)/a;
		temp3:=mb*tr + mc;
		randLinks:=(sr1*ma + temp3)>0.0;
		randRechts:=(sr2*ma + temp3)>0.0;
		s1:=FloorI(sr1+0.5);
		s2:=FloorI(sr2+0.5);
		IF ~(randLinks & randRechts) THEN
			IF ~randLinks THEN
				IF ~randRechts THEN keineKugel:=TRUE
				ELSIF s2>ausschnitt[0] THEN keineKugel:=TRUE
				ELSIF s2<eckeLU[0] THEN
					s1:=eckeLU[0]; s2:=ausschnitt[0]; keineKugel:=FALSE;
					randLinks:=FALSE; randRechts:=FALSE
				ELSE
					s1:=s2; s2:=ausschnitt[0]; keineKugel:=FALSE;
					randLinks:=TRUE; randRechts:=FALSE
				END
			ELSIF s1<eckeLU[0] THEN keineKugel:=TRUE
			ELSIF s1>ausschnitt[0] THEN
				s1:=eckeLU[0]; s2:=ausschnitt[0]; keineKugel:=FALSE;
				randRechts:=FALSE; randLinks:=FALSE
			ELSE
				s2:=s1; s1:=eckeLU[0]; keineKugel:=FALSE;
				randRechts:=TRUE; randLinks:=FALSE
			END
		ELSIF (s1>ausschnitt[0]) OR (s2<eckeLU[0]) THEN keineKugel:=TRUE
		ELSIF s1<eckeLU[0] THEN s1:=eckeLU[0]; randLinks:=FALSE
		ELSIF s2>ausschnitt[0] THEN s2:=ausschnitt[0]; randRechts:=FALSE
		ELSE keineKugel:=FALSE
		END
	END KugelRand;


PROCEDURE SchattenRand;
	(* input variable: t 
	    Konstanten: n, o, p, q, r, u
	    output variable: s3, s4, randRechts, randLinks, keinSchatten
	*)
	VAR
		di: Float;
		temp1, temp2, temp3, sr3, sr4, tr: Float;
	BEGIN
		tr:=t;
		temp1:=p*tr + q;
		di:=temp1*temp1-n*((o*tr + r)*tr + u);
		IF di<0.0 THEN keinSchatten:=TRUE; RETURN END;
		
		temp2:=Math.sqrt(di)*Sgn(n);
		sr3:=(temp1-temp2)/n; sr4:=(temp1+temp2)/n; temp3:=w*tr + x;
		randLinks:=(sr3*v + temp3)<0.0;
		randRechts:=(sr4*v + temp3)<0.0;
		s3:=FloorI(sr3+0.5);
		s4:=FloorI(sr4+0.5);
		IF ~(randLinks & randRechts) THEN
			IF ~randLinks THEN
				IF     ~randRechts       THEN keinSchatten:=TRUE;
				ELSIF s4>ausschnitt[0] THEN keinSchatten:=TRUE;
				ELSIF s4<eckeLU[0]    THEN keinSchatten:=FALSE; s3:=eckeLU[0]; s4:=ausschnitt[0]
				ELSE s3:=s4; s4:=ausschnitt[0]; keinSchatten:=FALSE;
				END;
			ELSIF s3<eckeLU[0]     THEN keinSchatten:=TRUE;
			ELSIF s3>ausschnitt[0] THEN keinSchatten:=FALSE; s3:=eckeLU[0]; s4:=ausschnitt[0]
			ELSE s4:=s3; s3:=eckeLU[0]; keinSchatten:=FALSE;
			END;
		ELSIF (s3>ausschnitt[0]) OR (s4<eckeLU[0]) THEN keinSchatten:=TRUE;
		ELSE
			IF s3<eckeLU[0]    THEN s3:=eckeLU[0] END;
			IF s4>ausschnitt[0] THEN s4:=ausschnitt[0] END;
			keinSchatten:=FALSE
		END
	END SchattenRand;


PROCEDURE P720;
	BEGIN
		IF s3>eckeLU[0] THEN P400(eckeLU[0], s3-1) END
	END P720;

PROCEDURE P740;
	BEGIN
		IF s1>eckeLU[0] THEN P400(eckeLU[0], s1-1) END
	END P740;

PROCEDURE P760;
	BEGIN
		IF s4<ausschnitt[0] THEN P400(s4+1, ausschnitt[0]) END
	END P760;

PROCEDURE P780;
	BEGIN
		IF s2<ausschnitt[0] THEN P400(s2+1, ausschnitt[0]) END
	END P780;

PROCEDURE InitGraph;
	BEGIN
		(* Clear display, Set fg color *)
		Oberon.RemoveMarks(0,0,BildBreite,BildHoehe);
		IF display THEN Display.ReplConst(Display.black,0,0,BildBreite,BildHoehe,Display.replace); END;
	END InitGraph;

PROCEDURE Zeichnung;
	VAR
		zz, mz, zr2, temp, sreal, tr: Float;
	BEGIN
		InitGraph;
		t:=eckeLU[1]-1; KugelRand;
		f4:=~keineKugel; f3:=keineKugel;
		FOR t:=eckeLU[1] TO ausschnitt[1] DO
			tr:=t; tt:=t-eckeLU[1];
			sq:=s1; sr:=s2; KugelRand;
			IF ~ keineKugel THEN
				f4:=TRUE;
				IF f3 THEN
					Line(s1-eckeLU[0],tt, s2-eckeLU[0],tt);
					f3:=FALSE;
				ELSE
					IF ~(s2-s1<2) THEN
						(*  Kugelinnere *)
						FOR s:=s1+1 TO s2-1 DO
							sreal:=s;
							zeile[0]:=sreal*projA[0]+tr*projB[0]+blick[0];
							zeile[1]:=sreal*projA[1]+tr*projB[1]+blick[1];
							zeile[2]:=                    tr*projB[2]+blick[2];
							zz:=zeile[0]*zeile[0]+zeile[1]*zeile[1]+zeile[2]*zeile[2];
							mz:=SProd(kameraKugel, zeile);
							j:=(mz-Math.sqrt(mz*mz-zz*y))/zz;
							reflexion[0]:=j*zeile[0]+kamera[0];
							reflexion[1]:=j*zeile[1]+kamera[1];
							reflexion[2]:=j*zeile[2]+kamera[2];
							kugelReflexion[0]:=reflexion[0]-kugel[0];
							kugelReflexion[1]:=reflexion[1]-kugel[1];
							kugelReflexion[2]:=reflexion[2]-kugel[2];
							zr2:=2.0*(zeile[0]*kugelReflexion[0]+zeile[1]*kugelReflexion[1]
								+zeile[2]*kugelReflexion[2])/kugelRadiusQ;
							zeile[0]:=zeile[0]-zr2*kugelReflexion[0];
							zeile[1]:=zeile[1]-zr2*kugelReflexion[1];
							zeile[2]:=zeile[2]-zr2*kugelReflexion[2];
							IF zeile[2]<0.0 THEN
								j:=-reflexion[2]/zeile[2];
								reflexion[0]:=reflexion[0]+j*zeile[0];
								reflexion[1]:=reflexion[1]+j*zeile[1];
								IF (reflexion[0]*lampeKugel[0]+reflexion[1]*lampeKugel[1])<z THEN
									Muster
								ELSIF reflexion[0]*reflexion[0]*g
									+reflexion[1]*reflexion[1]*h
									+reflexion[0]*reflexion[1]*i
									+reflexion[0]*k+reflexion[1]*l+m<0.0 THEN
									Muster
								ELSE
									IF display THEN Display.Dot(Display.white, SHORT(s-eckeLU[0]),SHORT(tt), Display.replace); END;
								END
							END
						END  (* FOR s *)
					END;
					
					(* Kugelrand *)
					IF sq#s1 THEN
						Line(sq+SgnI(s1-sq)-eckeLU[0],tt, s1-eckeLU[0],tt);
					ELSIF randLinks THEN
						IF display THEN Display.Dot(Display.white, SHORT(s1-eckeLU[0]),SHORT(tt), Display.replace); END;
					END;
					IF sr#s2 THEN
						Line(sr+SgnI(s2-sr)-eckeLU[0],tt,s2-eckeLU[0],tt);
					ELSIF randRechts THEN
						IF display THEN Display.Dot(Display.white,SHORT(s2-eckeLU[0]),SHORT(tt),Display.replace); END;
					END;
				END; (* IF f3 *)
			ELSE
				IF f4 THEN
					Line(sq-eckeLU[0],tt,sr-eckeLU[0],tt);
					f4:=FALSE;
				END;
			END;
			IF tr<(-blick[2]/projB[2]) THEN
				(* Die Ebene direkt gesehen *)
				temp:=tr*projB[2]+blick[2];
				cc:=-kamera[2]*projA[0]/temp;
				cd:=(kamera[0]-kamera[2]*(tr*projB[0]+blick[0])/temp);
				ce:=-kamera[2]*projA[1]/temp;
				cf:=(kamera[1]-kamera[2]*(tr*projB[1]+blick[1])/temp);
				SchattenRand;
				IF keineKugel & keinSchatten THEN
					P400(eckeLU[0], ausschnitt[0])
				ELSIF keineKugel THEN
					P720; P760;
					Line(s3-eckeLU[0],tt,s4-eckeLU[0],tt)
				ELSIF keinSchatten THEN
					P740; P780
				ELSIF s4<s1-1 THEN
					P720; P400(s4+1, s1-1); P780;
					Line(s3-eckeLU[0],tt, s4-eckeLU[0],tt)
				ELSIF s3>s2+1 THEN
					P740; P400(s2+1, s3-1); P760;
					Line(s3-eckeLU[0],tt,s4-eckeLU[0],tt)
				ELSE
					IF s1>s3 THEN
						P720;
						Line(s3-eckeLU[0],tt,s1-eckeLU[0],tt)
					ELSE
						P740
					END;
					IF s4>s2 THEN
						Line(s2-eckeLU[0],tt, s4-eckeLU[0],tt); P760
					ELSE
						P780
					END
				END
			END
		END  (* FOR t *)
	END Zeichnung;


PROCEDURE Eingabe;
	BEGIN
		kugel[0]:=0.0; kugel[1]:=0.0; kugel[2]:=1.0;
		IF log THEN Log.Str('Kugelmittelpunkt   '); WriteCoord(kugel); Log.Ln; END;
		
		kugelRadiusQ:=1.0;
		IF log THEN Log.Str('  Radius            '); WriteReal(kugelRadiusQ); Log.Ln; END;
		kugelRadiusQ:=kugelRadiusQ*kugelRadiusQ;
		
		lampe[0]:=35.0; lampe[1]:=45.0; lampe[2]:=6.5;
		IF log THEN Log.Str('Lampe                 '); WriteCoord(lampe); Log.Ln; END;
		
		kamera[0]:=-7.0; kamera[1]:=-7.0; kamera[2]:=1.7;
		IF log THEN Log.Str('Blickpunkt            '); WriteCoord(kamera); Log.Ln; END;
		
		blick[0]:=7.0; blick[1]:=6.5; blick[2]:=-0.88;
		IF log THEN Log.Str('  Richtung            '); WriteCoord(blick); Log.Ln; END;
		
		oeffnung[0]:=10.8; oeffnung[1]:=7.5;
		IF log THEN Log.Str('  Winkel            '); WriteCoord2(oeffnung); Log.Ln; END;
		oeffnung[0]:=oeffnung[0]*toRad; oeffnung[1]:=oeffnung[1]*toRad;
		
		ausschnitt[0]:=BildBreite-1; ausschnitt[1]:=BildHoehe-1;
		IF log THEN Log.Str('Bildschirmgroesse '); WriteCoord2I(ausschnitt); Log.Ln; END;
		
		eckeRO[0]:=(BildBreite DIV 2)-1; eckeRO[1]:=(BildHoehe DIV 2)-1;
		IF log THEN Log.Str('  rechts oben       '); WriteCoord2I(eckeRO); Log.Ln; END;
		
		eckeLU[0]:=-BildBreite DIV 2; eckeLU[1]:=-BildHoehe DIV 2;
		IF log THEN Log.Str('  links unten      '); WriteCoord2I(eckeLU); Log.Ln; END;
		
		ausschnitt[0]:=ausschnitt[0]+eckeLU[0];
		ausschnitt[1]:=ausschnitt[1]+eckeLU[1];
	END Eingabe;


PROCEDURE BildEbene;
	VAR
		skal: Float;
		i: LONGINT;
	BEGIN
		(* a parallel zu x-y ebene, senkrecht zu blick. *)
		projA[0]:=blick[1]; projA[1]:=-blick[0]; projA[2]:=0.0;
		(* b=a x blick. *)
		VProd(projB,projA,blick);
		(* a und b skalieren. *)
		skal:=Betrag(blick)/eckeRO[0]*Tan(oeffnung[0])/Betrag(projA);
		FOR i:=0 TO 1 DO projA[i]:=skal*projA[i]; END;
		skal:=Betrag(blick)/eckeRO[1]*Tan(oeffnung[1])/Betrag(projB);
		FOR i:=0 TO 2 DO projB[i]:=skal*projB[i]; END;
	END BildEbene;

PROCEDURE HilfsVektoren;
	VAR
		i: LONGINT;
		lr:Float;
	BEGIN
		FOR i:=0 TO 2 DO
			lr:=kugel[i];
			lampeKugel[i]:=lr-lampe[i];
			kameraKugel[i]:=lr-kamera[i];
		END;
		IF log THEN
			Log.Str('Lampe -> Kugel    '); WriteCoord(lampeKugel); Log.Ln;
			Log.Str('Kamera -> Kugel   '); WriteCoord(kameraKugel); Log.Ln;
		END;
	END HilfsVektoren;


PROCEDURE Koeffizienten;
	VAR
		temp, temp1, temp2: Float;
	BEGIN
		ma:=SProd(kameraKugel, projA);
		mb:=SProd(kameraKugel, projB);
		mc:=SProd(kameraKugel, blick);
		y:=SProd(kameraKugel, kameraKugel)-kugelRadiusQ;
		a:=ma*ma-y*SProd(projA, projA);
		b:=mb*mb-y*SProd(projB, projB);
		c:=-ma*mb;
		d:=-ma*mc;
		e:=2.0*mb*mc;
		f:=mc*mc-y*SProd(blick, blick);
		
		z:=SProd(lampeKugel,lampe);
		temp:=SProd(lampeKugel,lampeKugel)-kugelRadiusQ;
		g:=lampeKugel[0]*lampeKugel[0]-temp;
		h:=lampeKugel[1]*lampeKugel[1]-temp;
		i:=2.0*lampeKugel[0]*lampeKugel[1];
		k:=2.0*lampe[0]*temp-2.0*z*lampeKugel[0];
		l:=2.0*lampe[1]*temp-2.0*z*lampeKugel[1];
		m:=z*z-temp*SProd(lampe,lampe);
		
		temp1:=-projA[0]*kamera[2];
		temp2:=projB[2]*kamera[0]-projB[0]*kamera[2];
		cc:=blick[2]*kamera[0]-blick[0]*kamera[2];
		cd:=-projA[1]*kamera[2];
		ce:=projB[2]*kamera[1]-projB[1]*kamera[2];
		cf:=blick[2]*kamera[1]-blick[1]*kamera[2];
		n:=g*temp1*temp1+h*cd*cd+i*temp1*cd;
		o:=g*temp2*temp2+h*ce*ce+i*temp2*ce+k*temp2*projB[2];
		p:=g*2.0*temp1*temp2+h*2.0*cd*ce+i*(temp1*ce+temp2*cd)+k*temp1*projB[2];
		q:=g*2.0*temp1*cc+h*2.0*cd*cf+i*(temp1*cf+cc*cd)+k*temp1*blick[2];
		r:=g*2.0*temp2*cc+h*2.0*ce*cf+i*(temp2*cf+cc*ce)+k*(temp2*blick[2]+cc*projB[2]);
		u:=g*cc*cc+h*cf*cf+i*cc*cf+k*cc*blick[2];
		o:=o+l*ce*projB[2];
		p:=p+l*cd*projB[2];
		q:=q+l*cd*blick[2];
		r:=r+l*(ce*blick[2]+cf*projB[2])+m*projB[2]*blick[2]*2.0;
		u:=u+l*cf*blick[2]+m*blick[2]*blick[2];
		p:=-0.5*p;
		q:=-0.5*q;
		v:=temp1*lampeKugel[0]+cd*lampeKugel[1];
		w:=temp2*lampeKugel[0]+ce*lampeKugel[1]-projB[2]*z;
		x:=cc*lampeKugel[0]+cf*lampeKugel[1]-blick[2]*z;
	END Koeffizienten;

PROCEDURE zeichne*;
VAR
	t1,t2:LONGINT;
BEGIN
	t1:=Input.Time();
	Eingabe;
	HilfsVektoren;
	BildEbene;
	Koeffizienten;
	Zeichnung;
	t2:=Input.Time();
	Log.Int(((t2-t1)*1000) DIV Input.TimeUnit); Log.Str(" ms"); Log.Ln;
END zeichne;

END kugel.
