R  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  S     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc            
Circular doubly linked list with a mark element.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 8   
    8   #   Syntax10.Scn.Fnt         
	Files
	,persistent; 8   s    8      Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      
                        
        
                               
	Priority*=SHORTINT;
	NodePtr*=POINTER TO Node;
	Node*=RECORD (persistent.Object)
		previous-:NodePtr;
		next-:NodePtr;
		priority-:SHORTINT;
	END;

	List*=RECORD (Node)
	END;
	ListPtr*=POINTER TO List; 8      Syntax10b.Scn.Fnt      6    ^8   #   Syntax10.Scn.Fnt         

	Read in a node and recursively its predecessors and successors,
	thus reads in the whole list.
	
	Space: O(1).
	Time: O(n).

 8       8   #   Syntax10.Scn.Fnt       
VAR
	temp:LONGINT;
BEGIN
	(*
		Read in elements of superclass, by using its read method.
	*)
	node.read^(rider,err);
	IF err=persistent.none THEN
		(*
			Read in own elements.
		*)
		Files.ReadNum(rider,temp); node.priority:=SHORT(SHORT(temp));
		IF err=persistent.none THEN persistent.readObject(rider,node.previous(persistent.ObjectPtr),err); END;
		IF err=persistent.none THEN persistent.readObject(rider,node.next(persistent.ObjectPtr),err); END;
	END;
END read; 8               b8   #   Syntax10.Scn.Fnt  |    |   

	Write a node and recursively its predecessors and successors,
	thus writes the whole list.
	
	Space: O(1).
	Time: O(n).

 8       8   #   Syntax10.Scn.Fnt       
BEGIN
	(*
		Write elements of superclass, by using its read method.
	*)
	node.write^(rider);
	(*
		Write own elements.
	*)
	Files.WriteNum(rider,node.priority);
	persistent.writeObject(rider,node.previous);
	persistent.writeObject(rider,node.next);
END write; 8           6    8   #   Syntax10.Scn.Fnt  1    1   

	Read in a list.
	
	Space: O(1).
	Time: O(n).

 8       D8   #   Syntax10.Scn.Fnt         
VAR
	temp:LONGINT;
BEGIN
	(*
		Read in elements of superclass, by using its read method.
	*)
	list.read^(rider,err);
	(*
		No own elements.
	*)
END read; 8               8   #   Syntax10.Scn.Fnt  /    /   

	Write a list.
	
	Space: O(1).
	Time: O(n).

 8       [8   #   Syntax10.Scn.Fnt         
BEGIN
	(*
		Write elements of superclass, by using its read method.
	*)
	list.write^(rider);
	(*
		No own elements.
	*)
END write; 8               8   #   Syntax10.Scn.Fnt  C    C   

	Add a node in front of the list.
	
	Space: O(1).
	Time: O(1).
	
 8       e8   #   Syntax10.Scn.Fnt  y    y   
BEGIN
	new.previous:=list;
	new.next:=new.previous.next;
	new.previous.next:=new;
	new.next.previous:=new;
END addHead;
 8               8   #   Syntax10.Scn.Fnt  E    E   

	Add a node at the end of the list.
	
	Space: O(1).
	Time: O(1).
	
 8       e8   #   Syntax10.Scn.Fnt  y    y   
BEGIN
	new.next:=list;
	new.previous:=new.next.previous;
	new.previous.next:=new;
	new.next.previous:=new;
END addTail;
 8               8   #   Syntax10.Scn.Fnt  K    K   

	Count the number of elements in the list.
	
	Space: O(1).
	Time: O(n).

 8       B8   #   Syntax10.Scn.Fnt         
VAR
	count:LONGINT;
	node:NodePtr;
BEGIN
	count:=0;
	node:=list.next;
	WHILE node#list DO
		INC(count);
		node:=node.next;
	END;
	RETURN count;
END count;
 8           $    8   #   Syntax10.Scn.Fnt         
	
	Add a node to the list, so that the priority of the
	added node is greater than the priority of all following
	nodes and less than or equal all the preceeding nodes.
	
	Space: O(1).
	Time: O(n).

 8       8   #   Syntax10.Scn.Fnt  8   8  
VAR
	predecessor:NodePtr;
BEGIN
	new.priority:=priority;
	predecessor:=list.previous;
	WHILE (predecessor#list) & (predecessor.priority<priority) DO
		predecessor:=predecessor.previous;
	END;
	new.next:=predecessor.next;
	new.previous:=predecessor;
	predecessor.next:=new;
	new.next.previous:=new;
END enqueue;
 8               8   #   Syntax10.Scn.Fnt  <    <   

	Initialize list as empty.
	
	Space: O(1).
	Time: O(1).
	
 8       8   #   Syntax10.Scn.Fnt  9    9   
BEGIN
	list.next:=list;
	list.previous:=list;
END init;
 8               8   #   Syntax10.Scn.Fnt  9    9   

	Test if list is empty.
	
	Space: O(1).
	Time: O(1).
	
 8       8   #   Syntax10.Scn.Fnt  ,    ,   
BEGIN
	RETURN list.next=list;
END isEmpty;
 8               8   #   Syntax10.Scn.Fnt  ?    ?   

	Remove a node from the list.
	
	Space: O(1).
	Time: O(1).
	
 8       8   #   Syntax10.Scn.Fnt  W    W   
BEGIN
	node.previous.next:=node.next;
	node.next.previous:=node.previous;
END remove;
 8       
        r8   #   Syntax10.Scn.Fnt  l    l   

	Return the frontmost node in the list, after
	removing it from the list..
	
	Space: O(1).
	Time: O(1).
	
 8       Q8   #   Syntax10.Scn.Fnt         
VAR
	node:NodePtr;
BEGIN
	IF list.isEmpty() THEN
		node:=NIL;
	ELSE
		node:=list.next;
		node.remove();
	END;
	RETURN node;
END removeHead;
 8         MODULE list; (**)

IMPORT
(*
	Circular doubly linked list with a mark element (sentinel). The mark element is
	the List type itself.
*)
TYPE

PROCEDURE (node:NodePtr) read*(VAR rider:Files.Rider; VAR err:persistent.Error); (**)

PROCEDURE (node:NodePtr) write*(VAR rider:Files.Rider); (**)

PROCEDURE (list:ListPtr) read*(VAR rider:Files.Rider; VAR err:persistent.Error); (**)

PROCEDURE (list:ListPtr) write*(VAR rider:Files.Rider); (**)

	
PROCEDURE (list:ListPtr) addHead*(new:NodePtr);(**)
PROCEDURE (list:ListPtr) addTail*(new:NodePtr);(**)
PROCEDURE (list:ListPtr) count*():LONGINT; (**)
PROCEDURE (list:ListPtr) enqueue*(new:NodePtr; priority:Priority);(**)
PROCEDURE (list:ListPtr) init*();(**)
PROCEDURE (list:ListPtr) isEmpty*():BOOLEAN;(**)
PROCEDURE (VAR node:Node) remove*();(**)
PROCEDURE (list:ListPtr) removeHead*():NodePtr;(**)

END list.