(  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt        StyleElems Alloc   Paragraph  :        Paragraph          Paragraph          Paragraph      s  ParcElems Alloc            
Simple pop menu module.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 8      8   ,    8   S    8      Syntax10b.Scn.Fnt                                      
        
                        
            8       8   #   Syntax10.Scn.Fnt  /    /   
	fontRaster:Display.Font;
	lineHeight:INTEGER; 8   P    8       8   #   Syntax10.Scn.Fnt  >    >   
	topMargin=0;
	bottomMargin=6;
	leftMargin=3;
	rightMargin=3; 8       8   #   Syntax10.Scn.Fnt  "   "  
	backup:bitmap.BitmapPtr;
	dummy:INTEGER;
	currentX:INTEGER;
	currentY:INTEGER;
	dx:INTEGER;
	keys:SET;
	height:INTEGER;
	i:INTEGER;
	item:INTEGER;
	j:LONGINT;
	lastMarkedY:INTEGER;
	markedY:INTEGER;
	numberOfItems:INTEGER;
	pattern:LONGINT;
	pressedKeys:SET;
	width:INTEGER;
	x,y:INTEGER; 8      8                 MODULE menu; (**)
(*
	You wonder, why the hell this menu is fixed to max. 10 items and
	max. 40 characters per item. Well I first tried to use open arrays,
	but somehow they caused misterious bus errors and messages about
	something not properly aligned. As it was more important to mee, to 
	be able to continue work on the program, I changed that to fixed
	arrays, I'll analyze the problems with variable arrays at a later time.
*)

IMPORT
	Display,Fonts,Input
	,bitmap,mouse,string;

CONST
	backgroundColor=14;
	borderColor=10;
	textColor=3;
	markerColor=1;
		
TYPE
	Code*=LONGINT;
	Text*=ARRAY 40 OF CHAR;
	MenuPtr*=POINTER TO Menu;
	MenuItem*=RECORD
		code*:Code;
		subMenu*:MenuPtr;
		text*:Text;
	END;
	Menu*=RECORD
		length*:INTEGER;
		items*:ARRAY 10 OF MenuItem;
	END;

VAR

PROCEDURE display2*(menu:MenuPtr; sx,sy:INTEGER; wait:BOOLEAN; VAR code:Code);
CONST
VAR
BEGIN
	numberOfItems:=menu.length;
	height:=lineHeight*numberOfItems+topMargin+bottomMargin;
	width:=0;
	FOR i:=0 TO numberOfItems-1 DO
		currentX:=0;
		FOR j:=0 TO string.length(menu.items[i].text)-1 DO
			Display.GetChar(fontRaster,menu.items[i].text[j],dx,x,y,dummy,dummy,pattern);
			INC(currentX,dx);
		END;
		IF currentX>width THEN width:=currentX; END;
	END;
	INC(width,leftMargin+rightMargin);
	bitmap.new(backup,width,height);
	bitmap.get(backup,sx,sy-height,width,height);
	Display.ReplConst(backgroundColor,sx,sy-height,width,height,Display.replace);
	Display.ReplConst(borderColor,sx,sy-1,width,1,Display.paint);
	Display.ReplConst(borderColor,sx,sy-height,1,height,Display.paint);
	Display.ReplConst(borderColor,sx,sy-height,width,1,Display.paint);
	Display.ReplConst(borderColor,sx+width-1,sy-height,1,height,Display.paint);
	currentY:=sy-lineHeight-topMargin;
	FOR i:=0 TO numberOfItems-1 DO
		currentX:=sx+leftMargin;
		FOR j:=0 TO string.length(menu.items[i].text)-1 DO
			Display.GetChar(fontRaster,menu.items[i].text[j],dx,x,y,dummy,dummy,pattern);
			Display.CopyPattern(textColor,pattern,currentX+x,currentY+y,Display.paint);
			INC(currentX,dx);
		END;
		DEC(currentY,lineHeight);
	END;
	pressedKeys:={};
	lastMarkedY:=-1;
	code:=0;
	REPEAT
		Input.Mouse(keys,x,y);
		item:=((sy-y+lineHeight DIV 2) DIV lineHeight);
		IF (1<=item) & (item<=numberOfItems) & (sx<=x) & (x<=sx+width) THEN
			markedY:=item*lineHeight+2;
		ELSE
			markedY:=-1;
		END;
		IF markedY#lastMarkedY THEN
			IF lastMarkedY>=0 THEN
				Display.ReplConst(markerColor,sx+1,sy-lastMarkedY,width-2,lineHeight,Display.invert);
			END;	
			lastMarkedY:=markedY;
			IF lastMarkedY>=0 THEN
				Display.ReplConst(markerColor,sx+1,sy-lastMarkedY,width-2,lineHeight,Display.invert);
			END;
		END;
		IF (1<=item) & (item<=numberOfItems) & (sx+width DIV 2<x) & (menu.items[item-1].subMenu#NIL) THEN
			display2(menu.items[item-1].subMenu,sx+width DIV 2,(sy-markedY)+lineHeight,FALSE,code);
		END;
		pressedKeys:=pressedKeys+keys;
	UNTIL (keys={}) OR (~wait & (x<sx));
	IF (code=0) & (1<=item) & (item<=numberOfItems) THEN
		code:=menu.items[item-1].code;
	END;
	bitmap.put(backup,sx,sy-height);
	bitmap.free(backup);
END display2;

PROCEDURE display*(menu:MenuPtr; sx,sy:INTEGER; VAR code:Code);
BEGIN
	display2(menu,sx,sy,TRUE,code);
END display;

BEGIN
	fontRaster:=Fonts.Default.raster;
	lineHeight:=Fonts.Default.height+2;
END menu.