E  Syntax10.Scn.Fnt      8  FoldElems New      0 StyleElems Alloc   Paragraph  A   0   Paragraph      0   Paragraph      0   Paragraph       ParcElems Alloc      8   8   g   Syntax10b.Scn.Fnt           a8   #   Syntax10.Scn.Fnt  }    }   
	colors=6;
	configs=3;
	maxWallHeight=10;
	maxWallWidth=20;
	menu="System.Close";
	scoreHeight=40;
	textColor=Display.white; 8       8   #   Syntax10.Scn.Fnt       
	BrickColor=INTEGER;
	Mode=ARRAY 10 OF CHAR;	(* name of the play mode, e.g. tiny, small, standard *)
	Config=RECORD	(* store width, height and bonus for each color count of a mode *)
		mode:Mode;
		height,width:INTEGER;
		bonus:ARRAY colors OF INTEGER;
	END;
	WallDesc=ARRAY maxWallWidth,maxWallHeight OF BrickColor;	(* The wall content *)
	Wall=POINTER TO WallDesc;
	
	FrameDesc=RECORD (Display.FrameDesc)	(* descriptor for a sameGame frame *)
		brickHeight,brickWidth:INTEGER;	(* actual width and height of the single brick *)
		bricks:LONGINT;	(* Number of bricks on the board *)
		bonus:INTEGER;	(* bonus points to add, if all blocks are removed in this game *)
		colors:INTEGER;	(* number of colors used in this game *)
		height,width:INTEGER;	(* actual width and height of the board *) 
		mode:Mode;	(* name of the play mode used in this game *)
		score:LONGINT;	(* current score *)
		viewer:MenuViewers.Viewer;	(* used viewer *)
		wall:Wall;	(* storage for the board *)
	END;
	Frame=POINTER TO FrameDesc;
	
	UserName=ARRAY 30 OF CHAR; 8       8   #   Syntax10.Scn.Fnt  I   I  
	config:ARRAY configs OF Config;	(* all possible configurations *)
	font:Fonts.Font;
	color:ARRAY colors OF SHORTINT;	(* map brick number to color number *)
	pattern:ARRAY colors OF Display.Pattern;	(* patterns for b/w Oberon *)
	seed:LONGINT;	(* seed for the random generator *)
	userName:UserName;	(* name of current player *) 8       1   *    8   C   Syntax10.Scn.Fnt  7   Syntax10b.Scn.Fnt          <    returns a non-negative pseudo-random number less than len.  8       08   #   Syntax10.Scn.Fnt         

CONST
	a=16807; m=2147483647; q=m DIV a; r=m MOD a;
BEGIN
	seed:=a*(seed MOD q)-r*(seed DIV q);
	IF seed<=0 THEN INC(seed,m); END;
	RETURN SHORT(seed MOD len);
END random;
 8   >    H8   #   Syntax10.Scn.Fnt         

	Remove the area, to which the brick at brick-coordinate (x,y) belongs, from
	the board. Return the number of bricks which belonged to that area.
	
 8       8   #   Syntax10.Scn.Fnt  *   *  
VAR
	col:BrickColor;	(* color of the area *)
	sp:INTEGER;	(* stack pointer *)
	stack:ARRAY maxWallHeight*maxWallWidth OF RECORD x,y:INTEGER; END;	(* coordinate stack *)
	
	PROCEDURE pop(VAR x,y:INTEGER);	(* pop a coordinate from the stack for brick removal *)
	BEGIN
		DEC(sp);
		x:=stack[sp].x;
		y:=stack[sp].y;
	END pop;
	
	PROCEDURE push(x,y:INTEGER);	(* push a coordinate to the stack for brick removal *)
	BEGIN
		f.wall[x,y]:=-col;	(* invert the color to mark brick as removed. *)
		INC(removed);	(* increment counter of removed bricks. *)
		stack[sp].x:=x;
		stack[sp].y:=y;
		INC(sp);
	END push;
	
	PROCEDURE ok(self:Frame; x,y:INTEGER):BOOLEAN;
	(*
		test whether the brick-coordinates (x,y) are valid and contain a brick of the
		correct color, i.e. the same color of the brick to which the user pointed with
		the mouse.
	*)
	BEGIN
		RETURN (0<=x) & (x<self.width) & (0<=y) & (y<self.height) & (f.wall[x,y]=col);
	END ok;
	
BEGIN
	sp:=0;
	removed:=0;
	col:=f.wall[x,y];	(* remember color of brick=area to be removed *)
	IF col#0 THEN	(* user pointed to a spot with a valid brick *)	
		push(x,y);	(* push brick coordinate to stack for later removal. *)
		WHILE sp>0 DO
			pop(x,y);	(* fetch a brick for removal. *)
			(*
				Push the coordinates of each neighbour, which has the same color,
				to the stack for later removal.
			*)
			IF ok(f,x-1,y) THEN push(x-1,y); END;
			IF ok(f,x+1,y) THEN push(x+1,y); END;
			IF ok(f,x,y-1) THEN push(x,y-1); END;
			IF ok(f,x,y+1) THEN push(x,y+1); END;
		END;
		(*
			It is not allowed to remove a single brick. But the algorithm above
			starts marking bricks as remove from the very first one. So in this special
			case, we have to restore the brick to its original value.
		*)
		IF removed=1 THEN
			f.wall[x,y]:=col;
		ELSE
			DEC(f.bricks,removed);
		END;
	END;
END kill;
 8   F    8   #   Syntax10.Scn.Fnt         
VAR
	dx, i, h, w, x0, y0: INTEGER;
	p: LONGINT;
BEGIN
	i:=0;
	WHILE s[i]#0X DO
		Display.GetChar(font.raster,s[i],dx,x0,y0,w,h,p);
		Display.CopyPatternC(f,textColor,p,x+x0,y+y0,Display.replace); 
		INC(x,dx);
		INC(i);
	END;
END writeString;
 8       8   #   Syntax10.Scn.Fnt  &    &   

	Map brick number to color number.

 8       s8   #   Syntax10.Scn.Fnt  k    k   
BEGIN
	color[0]:=0;
	color[1]:=1;
	color[2]:=4;
	color[3]:=7;
	color[4]:=9;
	color[5]:=10;
END initColors; 8       8   #   Syntax10.Scn.Fnt  !    !   

	Map brick number to pattern.

 8       {8   #   Syntax10.Scn.Fnt  c   c  
(* Mac: the width must be 8. PC: width and height must be 8. So, I'm really forced to
	specify all 12 patterns in 8x8 matrix!! *)
VAR s: ARRAY 9 OF SET;
BEGIN
	s[8]:={};
	s[7]:={};
	s[6]:={};
	s[5]:={};
	s[4]:={0..7};
	s[3]:={};
	s[2]:={};
	s[1]:={};
	pattern[1]:=Display.NewPattern(s, 8, 8);
	s[8]:={4};
	s[7]:={4};
	s[6]:={4};
	s[5]:={4};
	s[4]:={4};
	s[3]:={4};
	s[2]:={4};
	s[1]:={4};
	pattern[2]:=Display.NewPattern(s, 8, 8);
	s[8]:={7};
	s[7]:={6};
	s[6]:={5};
	s[5]:={4};
	s[4]:={3};
	s[3]:={2};
	s[2]:={1};
	s[1]:={0};
	pattern[3]:=Display.NewPattern(s, 8, 8);
	s[8]:={0};
	s[7]:={1};
	s[6]:={2};
	s[5]:={3};
	s[4]:={4};
	s[3]:={5};
	s[2]:={6};
	s[1]:={7};
	pattern[4]:=Display.NewPattern(s, 8, 8);
	s[8]:={4};
	s[7]:={4};
	s[6]:={4};
	s[5]:={4};
	s[4]:={0..7};
	s[3]:={4};
	s[2]:={4};
	s[1]:={4};
	pattern[5]:=Display.NewPattern(s, 8, 8);
END initPatterns;
 8   /    8   #   Syntax10.Scn.Fnt  :   :  
BEGIN
	IF col=0 THEN
		Display.ReplConst(
			color[0],f.X+x*f.brickWidth,f.Y+y*f.brickHeight,f.brickWidth-2,f.brickHeight-2,Display.replace
		);
	ELSE
		Display.ReplPattern(
			color[col],pattern[col],f.X+x*f.brickWidth,f.Y+y*f.brickHeight,f.brickWidth-2,f.brickHeight-2,Display.replace
		);
	END;
END drawBrick;
 8       28   #   Syntax10.Scn.Fnt       
VAR
	i:INTEGER;
	num:LONGINT;
	s:ARRAY 40 OF CHAR;
BEGIN
	Display.ReplConst(color[0],f.X,f.Y+f.H-scoreHeight,f.W,scoreHeight,Display.replace);
	s:="Score:t+00000";
	num:=f.score;
	s[6]:=09X;
	IF num<0 THEN
		s[7]:="-"; num:=-num;
	ELSE
		s[7]:='+';
	END;
	FOR i:=12 TO 8 BY -1 DO
		IF (num=0) & (i<12) THEN
			s[i]:=' ';
		ELSE 
			s[i]:=CHR(ORD('0')+num MOD 10);
			num:=num DIV 10;
		END;
	END;
	writeString(f,f.X+20,f.Y+f.H-30,s);
	s:="Bricks left:t000";
	num:=f.bricks;
	s[12]:=09X;
	FOR i:=15 TO 13 BY -1 DO
		IF (num=0) & (i<15) THEN
			s[i]:=' ';
		ELSE 
			s[i]:=CHR(ORD('0')+num MOD 10);
			num:=num DIV 10;
		END;
	END;
	writeString(f,f.X+250,f.Y+f.H-30,s);
END drawScore;
 8       g8   #   Syntax10.Scn.Fnt  w    w   
	
	Totally refreshes the display. For simplicity, we haven't yet
	implemented a fine grained update of the display.
	
 8       <8   #   Syntax10.Scn.Fnt       
VAR
	col:INTEGER;
	i:INTEGER;
	s:ARRAY 40 OF CHAR;
	score:LONGINT;
	x,y:INTEGER;
BEGIN
	drawScore(f);
	Display.ReplConst(color[0],f.X,f.Y,f.W,f.H-scoreHeight,Display.replace);
	IF f.brickHeight*f.brickWidth#0 THEN	(* only if the frame is large enough *)
		FOR x:=0 TO f.width-1 DO
			FOR y:=0 TO f.height-1 DO
				col:=f.wall[x,y];
				IF col>0 THEN
					drawBrick(f,x,y,col);
				END;
			END;
		END;
	END;
END draw;
 8   !    X8   #   Syntax10.Scn.Fnt       
	
	After the removing of bricks, the gaps have to be filled.
	
	First bricks are compressed vertically, so that there are
	no bricks floating in the air. If there are completly empty
	columns at the left of some non-empty columns, than
	they are removed by moveing the non-empty columns
	toward the left. You dind't understand this.. well then
	play the game and you'll see what I mean.
	
 8       P8   #   Syntax10.Scn.Fnt       
VAR
	x,y,xDst,yDst:INTEGER;
	col:BrickColor;
BEGIN
	FOR x:=0 TO f.width-1 DO	(* for all columns *)
		(*
			yDst goes in single step from bottom to top.
			y jumps from a visible brick to the next skipping empty brick slots.
			bricks are copied from y to yDst.
		*)
		y:=0;
		FOR yDst:=0 TO f.height-1 DO
			WHILE (y<f.height) & (f.wall[x,y]<=0) DO INC(y); END;
			IF y#yDst THEN	(* copying needed only if y diverges from yDst *)
				IF y>=f.height THEN col:=0; ELSE col:=f.wall[x, y]; END;
				f.wall[x,yDst]:=col;
				drawBrick(f,x,yDst,col);
			END;
			INC(y);
		END
	END;
	(*
		xDst goes in single step from left to right.
		x jumps from a non-empty column to the next skipping empty columns.
		columns are copied from x to xDst.
	*)
	x:=0;
	FOR xDst:=0 TO f.width-1 DO
		(*
			Note: a column is empty <=> the lowest brick of the column is empty
		*)
		WHILE (x<f.width) & (f.wall[x,0]<=0) DO INC(x); END;
		IF x#xDst THEN	(* copying needed only if x diverges from xDst *)
			FOR y:=0 TO f.height-1 DO
				IF x>=f.width THEN col:=0; ELSE col:=f.wall[x, y]; END;
				f.wall[xDst,y]:=col;
				drawBrick(f,xDst,y,col);
			END;
		END;
		INC(x);
	END;
END compress;
 8   A    8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt            

	This procedure does two things at the same time. Its original purpose was
	to determine, if the game can continue, i.e. if there are two adjacent bricks
	with the same color. This situation is returned as a TRUE value in the
	parameter hasRemovableAreas.

 8       G8      Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      /                :        P    	    l        p    1  
VAR
	col,col0:BrickColor;
	hasColumnAtRight:BOOLEAN;
	x,y:INTEGER;
BEGIN
	hasRemovableAreas:=FALSE;
	x:=0;
	LOOP
		IF x=f.width THEN	(* no more columns *)
			EXIT;
		END;
		col0:=f.wall[x,0];
		IF col0=0 THEN EXIT; END;	(* no more colums with bricks *)
		hasColumnAtRight:=x<f.width-1;
		y:=0;
		LOOP
			IF hasColumnAtRight & (col0=f.wall[x+1,y]) THEN	(* brick at right has same color as this one *)
				hasRemovableAreas:=TRUE;
				RETURN;
			END;
			IF y=f.height-1 THEN	(* topmost brick *)
				EXIT;
			END;
			col:=f.wall[x,y+1];
			IF col=0 THEN	(* no more bricks in column *)
				EXIT;
			END;
			IF col0=col THEN	(* brick above has same color as this one *)
				hasRemovableAreas:=TRUE;
				RETURN;
			END;
			(* go to brick above this one. *)
			col0:=col;
			INC(y);
		END;
		INC(x);
	END;
END canContinue;
 8   V    8   #   Syntax10.Scn.Fnt       
TYPE
	Score=RECORD
		userName:UserName;
		score:LONGINT;
	END;
VAR
	f:Files.File;
	filename:ARRAY 80 OF CHAR;
	i:INTEGER;
	list:ARRAY 10 OF Score;
	r:Files.Rider;
	s:ARRAY 2 OF CHAR;
BEGIN
	(* Build filename as SameGameScore_<Modename><NumberOfColors> *)
	filename:="SameGame_";
	string.append(filename,mode);
	s[0]:=CHR(ORD('0')+colors); s[1]:=0X;
	string.append(filename,s);
	string.append(filename,".Score");
	f:=Files.Old(filename);
	IF f=NIL THEN	(* create new list. *)
		FOR i:=0 TO 9 DO
			list[i].userName:="";
			list[i].score:=0;
		END;
	ELSE	(* read list from file. *)
		Files.Set(r,f,0);
		FOR i:=0 TO 9 DO
			Files.ReadString(r,list[i].userName);
			Files.ReadLInt(r,list[i].score);
		END;
	END;
	(*
		Insert new score at right place.
	*)
	i:=10;
	WHILE (i>0) & (score>list[i-1].score) DO
		IF i<10 THEN list[i]:=list[i-1]; END;
		DEC(i); 
	END;
	IF i<10 THEN
		list[i].userName:=userName;
		list[i].score:=score;
	END;
	(*
		Write high score list to file and to the system log.
	*)
	f:=Files.New(filename);
	IF f=NIL THEN
		Log.Str("Error creating high score list "); Log.Str(filename); Log.Ln;
	ELSE
		Files.Set(r,f,0);
		Log.Str("High scores for the "); Log.Str(mode); Log.Str(" board with");
		Log.Int(colors); Log.Str(" colors"); Log.Ln;
		FOR i:=0 TO 9 DO
			Files.WriteString(r,list[i].userName);
			Files.WriteLInt(r,list[i].score);
			IF list[i].score>0 THEN
				Log.Int(i+1); Log.Str(". "); Log.Str(list[i].userName);
				Log.Int(list[i].score); Log.Ln;
			END;
		END;
		Files.Register(f);
	END;
END addHighScore;
 8   
        +     8   #   Syntax10.Scn.Fnt       
VAR
	hasRemovableAreas:BOOLEAN;
	keys:SET;
	removed:LONGINT;
	self:Frame;
	x,y:INTEGER;
BEGIN
	self:=f(Frame);
	WITH  m:Oberon.InputMsg DO
		IF m.id = Oberon.track THEN
			Oberon.DrawCursor(Oberon.Mouse,Oberon.Arrow,m.X,m.Y);
			Input.Mouse(keys,m.X,m.Y);
			IF (keys#{}) & (self.brickHeight*self.brickWidth#0) THEN	(* mouse click, and field visible *)
				(* wait for mouse release *)
				REPEAT
					Input.Mouse(keys,m.X,m.Y);
					Oberon.DrawCursor(Oberon.Mouse,Oberon.Arrow,m.X,m.Y);
				UNTIL keys={};
				(* compute brick coordinates *)
				x:=(m.X-f.X) DIV self.brickWidth;
				y:=(m.Y-f.Y) DIV self.brickHeight;
				(* remove bricks *)
				kill(self,x,y,removed);
				IF removed>1 THEN	(* bricks were really removed *)
					(* Adjust score *)
					INC(self.score,(removed-2)*(removed-2));
					(* Redraw board with missing bricks, wait, compress *)
					draw(self);
					fallDelay;
					compress(self);
					(* see if game came to an end. *)
					canContinue(self,hasRemovableAreas);
					drawScore(self);
					IF ~hasRemovableAreas THEN
						IF self.bricks=0 THEN
							Log.Str("Bonus for clearing the board"); Log.Int(self.bonus); Log.Ln;
							self.score:=self.score+self.bonus;
						ELSE
							Log.Str("Sorry no more moves."); Log.Ln;
							Log.Str("You left"); Log.Int(self.bricks); Log.Str(" bricks."); Log.Ln;
							self.score:=self.score-self.bricks;
						END;
						drawScore(self);
						addHighScore(self.mode,self.colors,userName,self.score);
					END;
				END;
				Oberon.PassFocus(self.viewer);
			END;
		END;
	| m:MenuViewers.ModifyMsg DO
		f.Y:=m.Y; f.H:=m.H;
		self.brickHeight:=(f.H-scoreHeight) DIV self.height;
		self.brickWidth:=f.W DIV self.width;
		draw(self);
	ELSE
	END;
END handler;
 8   #    38   #   Syntax10.Scn.Fnt         
VAR
	x,y:INTEGER;
BEGIN
	NEW(self.wall);
	FOR x:=0 TO self.width-1 DO 
		FOR y:=0 TO self.height-1 DO
			self.wall[x,y]:=1+random(self.colors);
		END;
	END;
END newWall;
 8   '    -8   Q   Syntax10.Scn.Fnt  R   Syntax10b.Scn.Fnt                     
VAR
	i:INTEGER;
BEGIN
	FOR i:=0 TO configs-1 DO
		IF mode=config[i].mode THEN
			RETURN i;
		END;
	END;
	RETURN -1;
END getBoard;
 8               P8   #   Syntax10.Scn.Fnt         
VAR
	arg:arguments.T;
	valid:BOOLEAN;
BEGIN
	arguments.oneName(arg,valid);
	IF valid THEN
		COPY(arg.scanner.s,userName);
	END;
END setName;
 8               98   _   Syntax10.Scn.Fnt    Syntax10b.Scn.Fnt      6        7        G   i  
VAR
	arg:arguments.T;
	f:Frame;
	index:INTEGER;
	mode:Mode;
	x,y:INTEGER;
BEGIN
	IF (userName="") THEN
		Log.Str("Please set your name first, using"); Log.Ln;
		Log.Str("the sameGame.setName command."); Log.Ln;
	ELSE
		arguments.init(arg);
		REPEAT arguments.next(arg); UNTIL arg.type#arguments.arrow;
		IF arg.type=arguments.end THEN
			Log.Str("Missing board size name."); Log.Ln;
		ELSIF arg.scanner.class#Texts.Name THEN
			Log.Str("Board size should be one of ."); Log.Ln;
		ELSE
			COPY(arg.scanner.s,mode);
			index:=getBoard(mode);
			IF index<0 THEN
				Log.Str("Board size name unknown. Must be one of");
				FOR index:=0 TO configs-1 DO
					IF config[index].mode[0]#0X THEN Log.Ch(' '); Log.Str(config[index].mode); END;
				END;
				Log.Ln; 
			ELSE
				arguments.next(arg);
				IF arg.type=arguments.end THEN
					Log.Str("Missing color count."); Log.Ln;
				ELSIF arg.scanner.class#Texts.Int THEN
					Log.Str("Color count should be an integer."); Log.Ln;
				ELSIF (arg.scanner.i<2) OR (5<arg.scanner.i) THEN
					Log.Str("Number of colors has to be in the range 2..5."); Log.Ln;
				ELSE
					NEW(f); 
					f.handle:=handler; 
					f.height:=config[index].height;
					ASSERT(f.height#0);
					f.width:=config[index].width;
					ASSERT(f.width#0);
					f.colors:=SHORT(arg.scanner.i);
					ASSERT(f.colors#0);
					f.mode:=mode;
					f.bonus:=config[index].bonus[arg.scanner.i];
					f.bricks:=f.width*f.height;
					newWall(f);
					Oberon.AllocateUserViewer(Oberon.Mouse.X, x, y);
					f.viewer:=MenuViewers.New(TextFrames.NewMenu("SameGame",menu),f,TextFrames.menuH,x,y);
				END;		
			END;
		END;		
	END;		
END newGame; 8       8   Q   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      %              
VAR
	i,n:INTEGER;
BEGIN
	config[0].mode:="tiny"; config[0].height:=5; config[0].width:=5;
	config[1].mode:="small"; config[1].height:=6; config[1].width:=12;
	config[2].mode:="standard"; config[2].height:=10; config[2].width:=20;
	FOR n:=0 TO 2 DO
		ASSERT(config[n].height<=maxWallHeight);
		ASSERT(config[n].width<=maxWallWidth);
		FOR i:=2 TO 5 DO
			config[n].bonus[i]:=5*config[n].height*config[n].width;
		END;
	END;
	seed:=Oberon.Time();
	userName:="";
	initColors;
	initPatterns;
	font:=Fonts.This("Syntax24b.Scn.Fnt");
END init; 8       2  MODULE sameGame; (*
A little game.
Jrg Straube got a game called "samegame" for his MacIntosh, and wanted
to program it himself in Oberon. I helped him a little bit, but you owe
him the existence of the game, as he thought up the whole source.

The game consists of a board of differently colored (2-5 colors) blocks.
You can remove contiguous areas of same colored blocks. The larger the
area, the more points you get [(n-2)*(n-2) where n is the number of
blocks in the area]. For to blocks to be part of the same area, they have
to lie in the same row or same column. You cannot eliminate single blocks.
If you manage to eliminate all blocks you get bonus points (5 times the
board size). If you can't eliminate all blocks, your score is diminuished
by one point for each remaining block.

Implementation Note:

There is one system dependent procedure. It is called fallDelay, and as its
name implies, delays the course of the program, so that you can see the
area of bricks removed. In my implementation I use Unix.select to perform
the delay, and also included an X11.Flush, to make sure, that you actually
see an up to date picture. On other implementations you will have to
change or omit the Flush, and either use whatever delay possibility your
OS offers, or simply some long FOR loop.

Enjoy the game!  

Copyright (C) 1996 Jrg Straube & Claudio Nieder.
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	The implementation of procedure fallDelay is Unix specific. It's main purpose is to generate a delay, so that you see
	the area of bricks removed. Additionally it performs a X11.Flush, to make sure, that the display is really up to date.
	If you are not on a Unix Oberon, you have to change or omit the flush, and use you OS approved way of generating a
	delay, or simply use a long enough FOR loop.
	
	If you want to change either the patterns of the bricks, or the colors assigned to them, you can do it by modifying
	the procedures initPatterns and initColors.
	
*)

IMPORT
	SYSTEM,arguments,Display,Files,Fonts,Input,Log,MenuViewers,Oberon,string,TextFrames,Texts
	,Unix,X11 (* system dependent *)
	;
	
CONST

TYPE

VAR

PROCEDURE fallDelay;	(* system dependent. Please adapt for non-Unix Oberon *)
VAR
	dummyRc:LONGINT;
	tm:Unix.Timeval;
BEGIN
	X11.DoFlush;	(* without this, the display is not up to date *)
	tm.sec:=0;
	tm.usec:=300000;
	dummyRc:=Unix.Select(0,0,0,0,SYSTEM.ADR(tm));	(* delay for 300 msec *)
END fallDelay;

PROCEDURE random(len:INTEGER):INTEGER; (**)
PROCEDURE kill(f:Frame; x,y:INTEGER; VAR removed:LONGINT); (**)
PROCEDURE writeString(f:Display.Frame; x,y:INTEGER; s:ARRAY OF CHAR);

PROCEDURE initColors; (**)

PROCEDURE initPatterns; (**)
PROCEDURE drawBrick(f:Frame; x,y,col:INTEGER);
PROCEDURE drawScore(f:Frame);
PROCEDURE draw(f:Frame);(**)	
PROCEDURE compress(f: Frame);(**)
PROCEDURE canContinue(f:Frame; VAR hasRemovableAreas:BOOLEAN);(**)

PROCEDURE addHighScore(mode:Mode; colors:INTEGER; userName:UserName; score:LONGINT);
	
PROCEDURE handler*(f:Display.Frame; VAR m:Display.FrameMsg);
PROCEDURE newWall(VAR self:Frame);
PROCEDURE getBoard(mode:Mode):INTEGER;
PROCEDURE setName*;
PROCEDURE newGame*;

PROCEDURE init;

BEGIN
	init;
END sameGame.
