  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  O     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc            
TCP via Unix socket (SGI IRIX 5.3 specific).
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 8       8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt             
	SYSTEM
	,Oberon,Unix
	,list; 8       8   #   Syntax10.Scn.Fnt  _   _  
	(* Values for first parameter of Unix.Socket. *)
	inetFamily=2;	(* TCP/UDP *)
	rawFamily=18;
	
	(* Values for second parameter of Unix.Socket. *)
	datagramSocket=1;	(* UDP *)
	streamSocket=2;	(* TCP *)
	rawSocket=4;
	
	(* Values for third parameter of Unix.Socket. *)
	ipProtocol=0;
	icmpProtocol=1;
	igmpProtocol=2;
	tcpProtocol=6;
	udpProtocol=17; 8       "8   _   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt  
            ,    
          
	IPAddress=RECORD
		family:INTEGER;
		port:INTEGER;
		address:ARRAY 4 OF CHAR;
		unused:ARRAY 8 OF CHAR;
	END;
	Socket=LONGINT;
	ConnectionPtr*=POINTER TO Connection;
	ReceiveProcedure*=PROCEDURE(VAR connection:ConnectionPtr);
	Connection*=RECORD (list.Node)
		socket:Socket;
		receiver:ReceiveProcedure;
	END;
	ConnectionList=list.List;
	ConnectionListPtr=POINTER TO ConnectionList; 8       8   #   Syntax10.Scn.Fnt  >    >   
	callbackTask:Oberon.Task;
	connectionList:ConnectionListPtr; 8   O    8   #   Syntax10.Scn.Fnt         
BEGIN
	ipAddress.family:=inetFamily;
	ipAddress.port:=port;
	ipAddress.address[0]:=CHR(a);
	ipAddress.address[1]:=CHR(b);
	ipAddress.address[2]:=CHR(c);
	ipAddress.address[3]:=CHR(h);
END setAddress; 8   
   Syntax10b.Scn.Fnt      ]    8   #   Syntax10.Scn.Fnt  $   $  

	Build a TCP connection to the specified port of the host with IP-Address a.b.c.h.
	receiver is a procedure which is called out of the Oberon Loop, whenever there is
	some incoming data. The receiver should either read the data itself, or signal a
	waiting coroutine, that it can proceed.

 8       8   {   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt              B        N                      
VAR
	done:BOOLEAN;
	errno:LONGINT;
	ipAddress:IPAddress;
	socket:Socket;
BEGIN
	socket:=Unix.Socket(inetFamily,streamSocket,tcpProtocol);
	errno:=Unix.Result();
	done:=Unix.Done();
	ASSERT(socket>=0);
	ASSERT(done);
	setAddress(ipAddress,a,b,c,h,port);
	Unix.Connect(socket,SYSTEM.ADR(ipAddress),SIZE(IPAddress));
	errno:=Unix.Result();
	done:=Unix.Done();
	ASSERT(errno=0);
	ASSERT(done);
	NEW(connection);
	connection.socket:=socket;
	connection.receiver:=receiver;
	connectionList.addTail(connection);
END connect; 8           J    8   _   Syntax10.Scn.Fnt  H   Syntax10b.Scn.Fnt      B                       
VAR
	done:BOOLEAN;
	errno:LONGINT;
BEGIN
	Unix.Write(connection.socket,SYSTEM.ADR(buffer),length);
	errno:=Unix.Result();
	done:=Unix.Done();
	ASSERT(errno=0);
	ASSERT(done);
END send; 8           ^    8   _   Syntax10.Scn.Fnt  O   Syntax10b.Scn.Fnt      +                       
VAR
	done:BOOLEAN;
	errno:LONGINT;
BEGIN
	actual:=Unix.Read(connection.socket,SYSTEM.ADR(buffer),length);
	done:=Unix.Done();
	ASSERT(actual>=0);
	ASSERT(done);
END read; 8       
         8   Q   Syntax10.Scn.Fnt  v   Syntax10b.Scn.Fnt              ?       
VAR
	done:BOOLEAN;
	errno:LONGINT;
BEGIN
	Unix.Close(connection.socket);
	errno:=Unix.Result();
	done:=Unix.Done();
	ASSERT(errno=0);
	ASSERT(done);
	connection.remove();
	connection:=NIL;
END disconnect; 8   (    8   #   Syntax10.Scn.Fnt  [    [   
VAR
	i:INTEGER;
BEGIN
	FOR i:=0 TO Unix.FdSetSize DIV 32-1 DO set[i]:=0; END;
END zeroSet; 8   :    N8   C   Syntax10.Scn.Fnt  J   Syntax10b.Scn.Fnt           p   
VAR
	i,j:LONGINT;
BEGIN
	i:=bitNumber DIV 32; j:=bitNumber MOD 32;
	INCL(SYSTEM.VAL(SET,set[i]),j);
END setBit; 8   <    L8   C   Syntax10.Scn.Fnt  J   Syntax10b.Scn.Fnt      "    r   
VAR
	i,j:LONGINT;
BEGIN
	i:=bitNumber DIV 32; j:=bitNumber MOD 32;
	INCL(SYSTEM.VAL(SET,set[i]),j);
END clearBit; 8       e8   #   Syntax10.Scn.Fnt  y    y   

	Go through the list of open connections and for each, for which there
	is incoming data call the receiver procedure.

 8       "8   _   Syntax10.Scn.Fnt    Syntax10b.Scn.Fnt              )              
VAR
	done:BOOLEAN;
	node:list.NodePtr;
	exceptionSet:Unix.FdSet;
	readSet:Unix.FdSet;
	readyCount:LONGINT;
	timeout:Unix.Timeval;
	writeSet:Unix.FdSet;
BEGIN
	node:=connectionList.next;
	WHILE node#connectionList DO
		WITH node:ConnectionPtr DO
			zeroSet(readSet);
			setBit(readSet,node.socket);
			(*
				timeout=0 => polling, sigh :-(
			*)
			timeout.sec:=0; timeout.usec:=0;
			readyCount:=Unix.Select(node.socket+1,SYSTEM.ADR(readSet),0,0,SYSTEM.ADR(timeout));
			done:=Unix.Done();
			ASSERT(done);
			IF readyCount>0 THEN
				node(ConnectionPtr).receiver(node(ConnectionPtr));
			END;
		END;
		node:=node.next;
	END;
END callBack; 8               K8   #   Syntax10.Scn.Fnt         

	This procedure is called by sys.free before freeing the module.
	It closes all connections and removes the task installed in the
	Oberon loop.

 8       8   #   Syntax10.Scn.Fnt         
VAR
	connection:ConnectionPtr;
BEGIN
	Oberon.Remove(callbackTask);
	callbackTask:=NIL;
	WHILE connectionList.next#connectionList DO
		connection:=connectionList.next(ConnectionPtr);
		disconnect(connection);
	END;
END expunge; 8   	    8   #   Syntax10.Scn.Fnt         NEW(connectionList);
	connectionList.init();
	NEW(callbackTask);
	callbackTask.safe:=FALSE;
	callbackTask.time:=0; (* as often as possible *)
	callbackTask.handle:=callBack;
	Oberon.Install(callbackTask); 8         MODULE socket; (**)

IMPORT 

CONST

TYPE

VAR

PROCEDURE setAddress(VAR ipAddress:IPAddress; a,b,c,h:INTEGER; port:INTEGER);
	
PROCEDURE connect*(VAR connection:ConnectionPtr; a,b,c,h:INTEGER; port:INTEGER; receiver:ReceiveProcedure); (**)

PROCEDURE send*(VAR connection:ConnectionPtr; VAR buffer:ARRAY OF CHAR; length:LONGINT);

PROCEDURE read*(VAR connection:ConnectionPtr; VAR buffer:ARRAY OF CHAR; length:LONGINT; VAR actual:LONGINT);

PROCEDURE disconnect*(VAR connection:ConnectionPtr);

PROCEDURE zeroSet(VAR set:Unix.FdSet);

PROCEDURE setBit(VAR set:Unix.FdSet; bitNumber:LONGINT);

PROCEDURE clearBit(VAR set:Unix.FdSet; bitNumber:LONGINT);

PROCEDURE callBack; (**)

PROCEDURE expunge*; (**)

BEGIN
	
END socket.