8  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  Z     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc          	  
Several string manipulating procedures.
Copyright (C) 1996 Claudio Nieder & Jrg Straube.
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
 8   :   Syntax10b.Scn.Fnt                          
    X       Courier10.Scn.Fnt          	                    
                        	            
            8   #   Syntax10.Scn.Fnt  '    '   

	Returns the length of the string.
	
 8       u8   #   Syntax10.Scn.Fnt  i    i   
VAR
	i:LONGINT;
BEGIN
	i:=0;
	WHILE (i<LEN(str)-1) & (str[i]#0X) DO INC(i); END;
	RETURN i;
END length;
 8                Q8   #   Syntax10.Scn.Fnt         

	Appends string in src to string dst. If dst doesn't have enough
	space to hold all characters of src, the appended string is trunctated.

 8       8   #   Syntax10.Scn.Fnt         
VAR
	i,j:LONGINT;
BEGIN
	i:=0;
	WHILE (i<LEN(dst)-1) & (dst[i]#0X) DO INC(i); END;
	j:=0;
	WHILE (i<LEN(dst)-1) & (j<LEN(src)-1) & (src[j]#0X) DO
		dst[i]:=src[j];
		INC(i); INC(j);
	END;
	dst[i]:=0X;
END append;
 8           !    8   #   Syntax10.Scn.Fnt  ?    ?   

	Returns, whether the passed character is contained in set.

 8       *8   C   Syntax10.Scn.Fnt  X   Syntax10b.Scn.Fnt      6       
VAR
	i:LONGINT;
BEGIN
	i:=0;
	WHILE (i<LEN(set)-1) & (set[i]#0X) DO
		IF ch=set[i]THEN RETURN TRUE; END;
		INC(i);
	END;
	RETURN FALSE;
END charOf; 8           0    8   #   Syntax10.Scn.Fnt  0    0   

	Convert Oberon Codes to ANSI (ISO latin1).
	
 8       78   *   Syntax10.Scn.Fnt           
BEGIN
	IF ch<80X THEN	(* no conversion needed. *)
		convertError:=noConversion;
	ELSE
		convertError:=converted;
		CASE ch OF
		| "": ch:=0C4X;
		| "": ch:=0D6X;
		| "": ch:=0DCX;
		| "": ch:=0E4X;
		| "": ch:=0EBX;
		| "": ch:=0EFX;
		| "": ch:=0F6X;
		| "": ch:=0FCX;
		| "": ch:=0E2X;
		| "": ch:=0EAX;
		| "": ch:=0EEX;
		| "": ch:=0F4X;
		| "": ch:=0FBX;
		| "": ch:=0E0X;
		| "": ch:=0E8X;
		| "": ch:=0ECX;
		| "": ch:=0F2X;
		| "": ch:=0F9X;
		| "": ch:=0E1X;
		| "": ch:=0E9X;
		| "": ch:=0E7X;
		| "": ch:=0F1X;
		| "": ch:=0DFX;
		ELSE	(* no conversion known. *)
			convertError:=conversionUnknown;
		END;
	END;
END convertOberonToAnsi;
 8           0    8   #   Syntax10.Scn.Fnt  0    0   

	Convert Oberon Codes to ANSI (ISO latin1).
	
 8       78   *   Syntax10.Scn.Fnt           
BEGIN
	IF ch<0A0X THEN	(* no conversion needed. *)
		convertError:=noConversion;
	ELSE
		convertError:=converted;
		CASE ch OF
		| 0C4X: ch:="";
		| 0D6X: ch:="";
		| 0DCX: ch:="";
		| 0E4X: ch:="";
		| 0EBX: ch:="";
		| 0EFX: ch:="";
		| 0F6X: ch:="";
		| 0FCX: ch:="";
		| 0E2X: ch:="";
		| 0EAX: ch:="";
		| 0EEX: ch:="";
		| 0F4X: ch:="";
		| 0FBX: ch:="";
		| 0E0X: ch:="";
		| 0E8X: ch:="";
		| 0ECX: ch:="";
		| 0F2X: ch:="";
		| 0F9X: ch:="";
		| 0E1X: ch:="";
		| 0E9X: ch:="";
		| 0E7X: ch:="";
		| 0F1X: ch:="";
		| 0DFX: ch:="";
		ELSE	(* no conversion known. *)
			convertError:=conversionUnknown;
		END;
	END;
END convertAnsiToOberon; 8           F    8   #   Syntax10.Scn.Fnt  -    -   

	Copy a part of string src to string dst.

 8       8   X   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt                  v       
VAR
	i,j:LONGINT;
BEGIN
	ASSERT(stretchLength<=LEN(dst));
	ASSERT(start+stretchLength<=LEN(src));
	j:=start;
	FOR i:=0 TO stretchLength-1 DO
		dst[i]:=src[j];
		INC(j);
	END;
	dst[stretchLength]:=0X;
END copyPart;
 8           :    8   #   Syntax10.Scn.Fnt  !    !   

	Remove characters from str..

 8       8   C   Syntax10.Scn.Fnt  ;   Syntax10b.Scn.Fnt             
VAR
	i,j:LONGINT;
	len:LONGINT;
BEGIN
	len:=length(str);
	ASSERT(start+stretchLength<len);
	j:=start;
	FOR i:=start+stretchLength TO len DO	(* copies also 0X *)
		str[j]:=str[i];
		INC(j);
	END;
END delete;
 8           #    8   #   Syntax10.Scn.Fnt  E    E   

	Allocates dst with enough space to hold src and copy src to dst.

 8       8   #   Syntax10.Scn.Fnt  W    W   
VAR
	len:LONGINT;
BEGIN
	len:=length(src);
	NEW(dst,len+1);
	COPY(src,dst^);
END dup;
 8           /    Q8   #   Syntax10.Scn.Fnt         

	Appends string in src to string dst. If dst doesn't have enough
	space to hold all characters of src, the appended string is trunctated.

 8       U8   Q   Syntax10.Scn.Fnt  ^   Syntax10b.Scn.Fnt                  [  
VAR
	i,j:LONGINT;
	lenDst,lenSrc:LONGINT;
BEGIN
	lenSrc:=length(src);
	lenDst:=length(dst);
	ASSERT(lenSrc+lenDst<LEN(dst));
	ASSERT(start+lenSrc<LEN(dst));
	j:=lenDst+lenSrc;
	FOR i:=lenDst TO start BY -1 DO	(* copies also 0X *)
		dst[j]:=dst[i];
		DEC(j);
	END;
	j:=start;
	FOR i:=0 TO lenSrc-1 DO
		dst[j]:=src[i];
		INC(j);
	END;
END insert;
 8               8   #   Syntax10.Scn.Fnt  _    _   

	Converts characters 'A' to 'Z' to its lowercase
	equivalent. Leaves all others unchanged.
	
 8       8   #   Syntax10.Scn.Fnt  N    N   
BEGIN
	IF ('A'<=ch) & (ch<='Z') THEN
		ch:=CHR(ORD(ch)+32);
	END;
END lower;
 8           )    8   {   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt                      #        -               

	If the length of str is longer than n, it is reduced to the left n characters.
	If it is longer than n, it is extended at the right with character pad.	

 8       B8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      \    |   
VAR
	i,k:LONGINT;
BEGIN
	ASSERT(LEN(str)>n);
	k:=length(str);
	FOR i:=k TO n-1 DO str[i]:=pad; END;
	str[n]:=0X;
END left;
 8           X    e8   {   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt                                          !  

	Compares a part of length characters each of string1 and string2. start1 and start2 define the
	first character of the stretch of characters to compare. This procedure assumes, that the two
	stretches are define correctly, i.e. do not extend beyond the logical end (0X) of the string.

 8       8   {   Syntax10.Scn.Fnt  ]   Syntax10b.Scn.Fnt      !        x        -                    z  
VAR
	end1,end2:LONGINT;
	i,j:LONGINT;
BEGIN
	end1:=length(string1); end2:=length(string2);
	ASSERT(start1+stretchLength<=end1+1);
	ASSERT(start2+stretchLength<=end2+1);
	j:=start2;
	FOR i:=start1 TO start1+stretchLength-1 DO
		IF string1[i]>string2[j] THEN RETURN greater;
		ELSIF string1[i]<string2[j] THEN RETURN less;
		END;
		INC(j);
	END;
	RETURN equal;
END compareParts;
 8           *    8   Q   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt                  "   

	Compares string1 and string2.

 8       8   _   Syntax10.Scn.Fnt  D   Syntax10b.Scn.Fnt      -        !        ,       
VAR
	i:LONGINT;
BEGIN
	i:=0;
	LOOP
		IF string1[i]>string2[i] THEN RETURN greater;
		ELSIF string1[i]<string2[i] THEN RETURN less;
		ELSIF string1[i]=0X THEN RETURN equal;
		END;
		INC(i);
	END;
END compare;
 8       
    $    Q8   Q   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt              @    _   

	Tries to locate ch in string. Returns position if found, or length of string if not found.

 8       L8   C   Syntax10.Scn.Fnt  V   Syntax10b.Scn.Fnt          r   
VAR
	i:LONGINT;
BEGIN
	i:=0;
	WHILE (string[i]#0X) & (string[i]#ch) DO INC(i); END;
	RETURN i;
END findCharacter; 8           3    Q8   Q   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt              @    _   

	Tries to locate ch in string. Returns position if found, or length of string if not found.

 8       8   Q   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      [               
VAR
	i:LONGINT;
BEGIN
	ASSERT(start<length(string));
	i:=start;
	WHILE (string[i]#0X) & (string[i]#ch) DO INC(i); END;
	RETURN i;
END findCharacterAfter;
 8   T        !    O8   #   Syntax10.Scn.Fnt         

	Test if a word matches a pattern. Wherever a '*' is part of the
	pattern, every sequence of 0, 1 or more letter of the word will 
	match.
	
 8       8      Syntax10.Scn.Fnt  `  Syntax10b.Scn.Fnt      W                M        /                              ~        T    8
  
CONST
	wildcardCharacter='*';
VAR
	stretchLength:LONGINT;
	patternStart:LONGINT;
	patternStop:LONGINT;
	wildcardPosition:LONGINT;
	wordStart:LONGINT;
	wordStop:LONGINT;
	
BEGIN
	wordStop:=length(word); patternStop:=length(pattern);
	(*
		First make sure, that last non-wildcard part of pattern matches end
		of word.
	*)
	LOOP
		IF patternStop=0 THEN RETURN wordStop=0; END;
		DEC(patternStop);
		IF pattern[patternStop]=wildcardCharacter THEN EXIT; END;
		IF wordStop=0 THEN RETURN FALSE; END;
		DEC(wordStop);
		IF word[wordStop]#pattern[patternStop] THEN  RETURN FALSE; END;
	END;
	(*
		wordStop points to the first character of the just matched part, i.e. the
		first character after the not yet matched part, i.e. it contains the length
		of the yet unmatched part.
		
		patternStop points to the wildcard character.
	*)
	(*
		Now test, that any non-wildcard part at the beginning of the
		pattern matches the beginning of the word.
	*)
	wildcardPosition:=findCharacterAfter(pattern,wildcardCharacter,0);
	IF wildcardPosition>wordStop THEN	(* can't match, because pattern prefix longer than unmatched word prefix. *)
		RETURN FALSE;
	END;
	IF (wildcardPosition>0) & (compareParts(word,pattern,0,0,wildcardPosition)#equal) THEN	(* prefix didn't match *)
		RETURN FALSE;
	END;
	(*
		Finally, after we got rid of any part before the first, or after the last wildcard character, we can just
		take all stretches of characters enclosed between successive wildcard characters and search them in
		in the word which has to match. If they occur there in the same sequence, then the word matches the
		pattern.
	*)
	patternStart:=wildcardPosition+1;
	wordStart:=wildcardPosition;
	WHILE patternStart<patternStop DO	(* Loop over all strectches of letters enclosed by wildcard characters within the pattern *)
		wildcardPosition:=findCharacterAfter(pattern,wildcardCharacter,patternStart);
		(*
			patternStart points to start of letter block before the just found wildcard character.
			wildcardPosition points to the wildcard character.
			
			The stretch word[patternStart..wildcardPosition-1] has to be found in the word for
			matching.
		*)
		stretchLength:=wildcardPosition-patternStart;
		LOOP
			IF wordStart>wordStop-stretchLength THEN RETURN FALSE; END;	(* no match possible because of lack of characters. *)
			IF compareParts(word,pattern,wordStart,patternStart,stretchLength)=equal THEN EXIT; END;	(* match *)
			INC(wordStart);
		END;
		wordStart:=wordStart+stretchLength;
		patternStart:=wildcardPosition+1;
	END;
	RETURN TRUE;	(* A match was found for all non-wildcard parts of the pattern. *)
END match; 8   e            O8   #   Syntax10.Scn.Fnt         

	Test if a word matches a pattern. Wherever a '*' is part of the
	pattern, every sequence of 0, 1 or more letter of the word will 
	match.
	
 8       8     Syntax10.Scn.Fnt  _    8  FoldElems New     Syntax10.Scn.Fnt  [   Syntax10b.Scn.Fnt      7        @        c        e        7                T        N            Q  
	VAR
		res:SHORTINT;
	BEGIN
		LOOP								(* exact match *)
			IF p[pi]='*' THEN INC(pi); EXIT;	(* go to wildcard match *)
			ELSIF p[pi]#s[si] THEN RETURN wordMismatch;	(* no match found here *)
			ELSIF p[pi]=0X THEN RETURN matched;	(* reached end of both strings *)
			END;
			INC(si); INC(pi);
		END;
		IF p[pi]=0X THEN RETURN matched; END;	(* wildcard at end, no need to compare further. *)
		LOOP								(* wildcard match *)
			res:=M(si,pi);	(* Let's see if the rest matches too. *)
			IF res=matched THEN RETURN matched;	(* it matched, so we are through it. *)
			ELSIF res=patternMismatch THEN RETURN patternMismatch;	(* it can't match, so we give up. *)
			ELSIF s[si]=0X THEN RETURN patternMismatch;	(* no more characters for matching, give up. *)
			END;
			INC(si);	(* didn't match at this position, maybe at next one. *)
		END
	END M; 8   	    8   #   Syntax10.Scn.Fnt         
	RETURN M(0,0)=matched; 8       w   

	CONST
		matched=0; wordMismatch=1; patternMismatch=2;

	PROCEDURE M(si,pi:LONGINT):SHORTINT;
		
BEGIN
END match; 8   
      MODULE string; (**)

(*enum: CompareResult=(less,equal,greater); *)
CONST
	less*=0; equal*=1; greater*=2;
TYPE
	CompareResult*=SHORTINT;

(*enum:  ConvertError=(noConversion,converted,conversionUnknown) *)
CONST
	noConversion*=0; converted*=1; conversionUnknown*=2;
TYPE
	ConvertError*=SHORTINT;
			
TYPE
	String*=ARRAY OF CHAR;
	StringPtr*=POINTER TO String;

PROCEDURE length*(VAR str:String):LONGINT;(**)
PROCEDURE append*(VAR dst:String; src:String);(**)
PROCEDURE charOf*(ch:CHAR; set:String):BOOLEAN;(**)
PROCEDURE convertOberonToAnsi*(VAR ch:CHAR; VAR convertError:ConvertError);(**)
PROCEDURE convertAnsiToOberon*(VAR ch:CHAR; VAR convertError:ConvertError);(**)
PROCEDURE copyPart*(VAR dst:String; src:String; start:LONGINT; stretchLength:LONGINT);(**)
PROCEDURE delete*(VAR str:String; start:LONGINT; stretchLength:LONGINT);(**)
PROCEDURE dup*(VAR dst:StringPtr; src:String);(**)
PROCEDURE insert*(VAR dst:String; src:String; start:LONGINT);(**)
PROCEDURE lower*(VAR ch:CHAR);(**)

PROCEDURE left*(VAR str:String; n:INTEGER; pad:CHAR);(**)

PROCEDURE compareParts*(string1,string2:String; start1,start2:LONGINT; stretchLength:LONGINT):CompareResult;(**)
PROCEDURE compare*(string1,string2:String):CompareResult;(**)
PROCEDURE findCharacter*(string:String; ch:CHAR):LONGINT;(**)
PROCEDURE findCharacterAfter*(string:String; ch:CHAR; start:LONGINT):LONGINT;(**)

(*
	My variant of the simple pattern matching routine. Non-recursiv.
	
	PROCEDURE match*(word,pattern:String):BOOLEAN;(**)
*)

(*
	Jrg Straube's version of the simple pattern matching routine. Recursiv. Nice.
*)
PROCEDURE match*(s,p:String):BOOLEAN;(**)

END string.