(  Syntax10.Scn.Fnt      j8  FoldElems New  ?  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  y     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc      2   X  
Procedures helping with the usual task needed to open a viewer and write text into it.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	A lot of oberon programs I've seen, have a global writer variable, into which they produce whatever
	later has to be transferred to a text. This module maintains a global writer. It contains procedure which
	uses corresponding Texts procedures to write into this global writer. append and insert can then be used
	to append the writer contents to a text, or insert it at a given place.
	
	OpenViewer opens a viewer with a menu which is either fetched from a file, or set to a fixed
	string. OpenSysViewer is the same, but opens the viewer in the system track.
 8       8   Z        8       8   Q   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt                     
	tab*=09X; cr*=0DX; 8       [8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      `    c   
	w*:Texts.Writer; (* Global writer variable. Always reuse the same. Needed to produce any text. *) 8   .    8   #   Syntax10.Scn.Fnt  [    [   
BEGIN
	IF h>9 THEN ch:=CHR(h-10+ORD('A'));
	ELSE ch:=CHR(h+ORD('0'));
	END;
END hexDigit;
 8   $    8   #   Syntax10.Scn.Fnt  \    \   
VAR
	i:LONGINT;
BEGIN
	i:=0; 
	WHILE n>0 DO n:=n DIV 16; INC(i); END;
	RETURN i;
END log16; 8       u8   #   Syntax10.Scn.Fnt  i   i  
VAR
	menuFrame:TextFrames.Frame;
	writer:Texts.Writer;
	x,y:INTEGER;
BEGIN
	IF system THEN
		Oberon.AllocateSystemViewer(Oberon.Par.vwr.X,x,y);
	ELSE
		Oberon.AllocateUserViewer(Oberon.Par.vwr.X,x,y);
	END;
	menuFrame:=TextFrames.NewMenu(viewerName,defaultMenu);
	IF Files.Old(menuFileName)#NIL THEN
		Texts.OpenWriter(writer);
		Texts.Open(menuFrame.text,menuFileName);
		Texts.SetFont(w,Fonts.Default);
		Texts.WriteString(writer,viewerName);
		Texts.WriteString(writer," | ");
		Texts.Insert(menuFrame.text, 0, writer.buf)
	END;
	RETURN MenuViewers.New(menuFrame,mainFrame,TextFrames.menuH,x,y);
END openViewer2;
 8   ~    28   #   Syntax10.Scn.Fnt         
VAR
	mainFrame:TextFrames.Frame;
BEGIN
	mainFrame:=TextFrames.NewText(text,0);
	RETURN openViewer2(system,viewerName,menuFileName,defaultMenu,mainFrame);
END openViewer1;
 8      Syntax10b.Scn.Fnt  
    [    8   #   Syntax10.Scn.Fnt  6   6  

	Open a menu viewer and initialise it with a text.

		viewerName
			Name of the viewer placed on the left of the | separator in the menu.

		menuFileName
			Name of the text file containing a menu.

		defaultMenu
			Menu to be used, if the menu file was not found.

		text
			Text to be shown in the viewer.
 8       b8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      M    \   
BEGIN
	RETURN openViewer1(FALSE,viewerName,menuFileName,defaultMenu,text);
END openViewer;
 8       
    [    8   #   Syntax10.Scn.Fnt  6   6  

	Open a menu viewer and initialise it with a text.

		viewerName
			Name of the viewer placed on the left of the | separator in the menu.

		menuFileName
			Name of the text file containing a menu.

		defaultMenu
			Menu to be used, if the menu file was not found.

		text
			Text to be shown in the viewer.
 8       `8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      O    ^   
BEGIN
	RETURN openViewer1(TRUE,viewerName,menuFileName,defaultMenu,text);
END openSysViewer;
 8           _    8   #   Syntax10.Scn.Fnt  C   C  

	Open a menu viewer and initialise it with a text.

		viewerName
			Name of the viewer placed on the left of the | separator in the menu.

		menuFileName
			Name of the text file containing a menu.

		defaultMenu
			Menu to be used, if the menu file was not found.

		frame
			Frame for the main part of the menu viewer.
 8       Y8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      V    e   
BEGIN
	RETURN openViewer2(FALSE,viewerName,menuFileName,defaultMenu,frame);
END openViewerOwnFrame;
 8           _    8   #   Syntax10.Scn.Fnt  C   C  

	Open a menu viewer and initialise it with a text.

		viewerName
			Name of the viewer placed on the left of the | separator in the menu.

		menuFileName
			Name of the text file containing a menu.

		defaultMenu
			Menu to be used, if the menu file was not found.

		frame
			Frame for the main part of the menu viewer.
 8       W8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      X    g   
BEGIN
	RETURN openViewer2(TRUE,viewerName,menuFileName,defaultMenu,frame);
END openSysViewerOwnFrame;
 8       
   Courier10.Scn.Fnt      i    N8   #   Syntax10.Scn.Fnt       
VAR
	bak:types.FileName;
	ch:CHAR;
	err:string.ConvertError;
	f:Files.File;
	fr:Files.Rider;
	r:Texts.Reader;
	res:INTEGER;
BEGIN
	f:=Files.New(name);
	Files.Set(fr,f,0);
	Texts.OpenReader(r,text,0);
	Texts.Read(r,ch);
	hadError:=FALSE;
	WHILE ~r.eot DO
		IF ch=0DX THEN ch:=0AX; END;
		IF (ch=09X) & convertTab THEN ch:=' '; END;
		IF ch#Texts.ElemChar THEN
			string.convertOberonToAnsi(ch,err);
			IF err=string.conversionUnknown THEN hadError:=TRUE; END;
			Files.Write(fr,ch); 
		END;
		Texts.Read(r,ch);
	END;
	COPY(name,bak);
	string.append(bak,".Bak");
	Files.Rename(name,bak,res);
	Files.Register(f);
	charWritten:=Files.Pos(fr);
END storeAscii;
 8       	        8   #   Syntax10.Scn.Fnt  >    >   

	Create a copy of an element by sending it a copy message.

 8       8   #   Syntax10.Scn.Fnt  _    _   
VAR
	msg:Texts.CopyMsg;
BEGIN
	msg.e := NIL;
	e.handle(e, msg);
	RETURN msg.e;
END cloneElem;
 8               8   #   Syntax10.Scn.Fnt  1    1   

	Get a parc element by cloning Texts.defParc.

 8       v8   #   Syntax10.Scn.Fnt  h    h   
VAR
	el:Texts.Elem;
BEGIN
	el:=cloneElem(TextFrames.defParc);
	RETURN el(TextFrames.Parc);
END newParc; 8       8   #   Syntax10.Scn.Fnt  
   
  
	The following procedure, with one exception, just call the equivalent Texts procedure
	with the global writer w as its first argument.
	
	setFont is slightly more complex than Texts.SetFont, as it asks for a font name and 
	additionally does the loading of the font.
 8               8   #   Syntax10.Scn.Fnt  +    +   
BEGIN
	Texts.Append(t,w.buf);
END append;
 8               8   #   Syntax10.Scn.Fnt  #    #   
BEGIN
	Texts.Write(w,ch);
END ch;
 8               8   #   Syntax10.Scn.Fnt  -    -   

	Reset the font back to the default font.

 8       8   #   Syntax10.Scn.Fnt  9    9   
BEGIN
	Texts.SetFont(w,Fonts.Default);
END defaultFont;
 8               8   #   Syntax10.Scn.Fnt  (    (   
BEGIN
	Texts.WriteElem(w,e);
END elem;
 8           
    8   #   Syntax10.Scn.Fnt  &    &   
BEGIN
	Texts.WriteHex(w,x);
END hex;
 8               8   #   Syntax10.Scn.Fnt         
VAR
	l:LONGINT;
	s:ARRAY 9 OF CHAR;
BEGIN
	l:=log16(x);
	IF l<n THEN l:=n; END;
	IF l=0 THEN l:=1; END;
	s[l]:=0X;
	REPEAT
		DEC(l);
		hexDigit(x MOD 16,s[l]);
		x:=x DIV 16;
	UNTIL l=0;
	Texts.WriteString(w,s);
END hexFix;
 8               8   #   Syntax10.Scn.Fnt  (    (   
BEGIN
	Texts.WriteInt(w,x,n);
END int;
 8               8   #   Syntax10.Scn.Fnt  /    /   
BEGIN
	Texts.Insert(t,pos,w.buf);
END insert;
 8               8   #   Syntax10.Scn.Fnt  "    "   
BEGIN
	Texts.WriteLn(w);
END ln;
 8               8   #   Syntax10.Scn.Fnt  2    2   
BEGIN
	Texts.WriteLongReal(w,x,n);
END longReal;
 8               8   #   Syntax10.Scn.Fnt  6    6   
BEGIN
	Texts.WriteLongRealHex(w,x);
END longRealHex;
 8               8   #   Syntax10.Scn.Fnt  *    *   
BEGIN
	Texts.WriteReal(w,x,n);
END real;
 8               8   #   Syntax10.Scn.Fnt  2    2   
BEGIN
	Texts.WriteRealFix(w,x,n,k);
END realFix;
 8           
    8   #   Syntax10.Scn.Fnt  .    .   
BEGIN
	Texts.WriteRealHex(w,x);
END realHex;
 8               8   #   Syntax10.Scn.Fnt  0    0   

	Open the named font and call Texts.SetFont.

 8       m8   #   Syntax10.Scn.Fnt  q    q   
VAR
	font:Fonts.Font;
BEGIN
	font:=Fonts.This(name);
	IF font#NIL THEN Texts.SetFont(w,font); END;
END setFont;
 8           !    8   #   Syntax10.Scn.Fnt  /    /   
BEGIN
	Texts.Save(t,beg,end,w.buf);
END save;
 8               8   #   Syntax10.Scn.Fnt  (    (   
BEGIN
	Texts.WriteString(w,s);
END str; 8               8   #   Syntax10.Scn.Fnt         
	Texts.OpenWriter(w); 8       U  MODULE w; (**) 

IMPORT
	Display,Files,Fonts,MenuViewers,Oberon,Reals,TextFrames,Texts,Viewers
	,dataTypes,string;
	
CONST
	
VAR
	
PROCEDURE hexDigit(h:LONGINT; VAR ch:CHAR);
PROCEDURE log16(n:LONGINT):LONGINT;

PROCEDURE openViewer2(system:BOOLEAN; viewerName,menuFileName,defaultMenu:ARRAY OF CHAR; mainFrame:Display.Frame):MenuViewers.Viewer;
PROCEDURE openViewer1(system:BOOLEAN; viewerName,menuFileName,defaultMenu:ARRAY OF CHAR; text:Texts.Text):MenuViewers.Viewer;

PROCEDURE openViewer*(viewerName,menuFileName,defaultMenu:ARRAY OF CHAR; text:Texts.Text):MenuViewers.Viewer;(**)
PROCEDURE openSysViewer*(viewerName,menuFileName,defaultMenu:ARRAY OF CHAR; text:Texts.Text):MenuViewers.Viewer;(**)

PROCEDURE openViewerOwnFrame*(viewerName,menuFileName,defaultMenu:ARRAY OF CHAR; frame:Display.Frame):MenuViewers.Viewer;(**)
PROCEDURE openSysViewerOwnFrame*(viewerName,menuFileName,defaultMenu:ARRAY OF CHAR; frame:Display.Frame):MenuViewers.Viewer;(**)

PROCEDURE storeAscii*(text:Texts.Text; name:ARRAY OF CHAR; convertTab:BOOLEAN; VAR charWritten:LONGINT; VAR hadError:BOOLEAN);

PROCEDURE cloneElem*(e:Texts.Elem):Texts.Elem;(**)
PROCEDURE newParc*():TextFrames.Parc;(**)

(**)

PROCEDURE append*(t:Texts.Text);
PROCEDURE ch*(ch:CHAR);
PROCEDURE defaultFont*;(**)
PROCEDURE elem*(e:Texts.Elem);
PROCEDURE hex*(x:LONGINT);
PROCEDURE hexFix*(x,n:LONGINT);
PROCEDURE int*(x,n:LONGINT);
PROCEDURE insert*(t:Texts.Text; pos:LONGINT);
PROCEDURE ln*;
PROCEDURE longReal*(x:LONGREAL; n:INTEGER);
PROCEDURE longRealHex*(x:LONGREAL);
PROCEDURE real*(x:REAL; n:INTEGER);
PROCEDURE realFix*(x:REAL; n,k:INTEGER);

PROCEDURE realHex*(x:REAL);
PROCEDURE setFont*(name:ARRAY OF CHAR);(**)
PROCEDURE save*(t:Texts.Text; beg,end:LONGINT);
PROCEDURE str*(s:ARRAY OF CHAR);
PROCEDURE longRealFix*(x:LONGREAL; n,k:INTEGER);
CONST
	maxD=16;
	maxExp=2047; midExp=1023;
VAR
	d:ARRAY maxD OF CHAR;
	e:INTEGER;
	i:INTEGER;
	sign:CHAR;
	x0:LONGREAL;

	PROCEDURE seq(c:CHAR; n:INTEGER);
	BEGIN
		WHILE n>0 DO ch(c); DEC(n); END;
	END seq;

	PROCEDURE dig(n:INTEGER);
	BEGIN
		WHILE n>0 DO
			DEC(i); ch(d[i]); DEC(n);
		END
	END dig;
	
	PROCEDURE log2(i:INTEGER):INTEGER;
	BEGIN
		RETURN SHORT(LONG(i)*1233 DIV 4096);
	END log2;
	
BEGIN
	e:=Reals.ExpoL(x);
	IF k<0 THEN k:=0 END;
	IF e=0 THEN
		seq(" ",n-k-2); ch("0"); seq(" ",k+1);
	ELSIF e=maxExp THEN
		str(" NaN"); seq(" ",n-4);
	ELSE
		e:=log2(e-midExp);
		IF x<0 THEN
			sign:="-"; x:=-x;
		ELSE
			sign:=" ";
		END;
		IF e>=0 THEN  (*x>=1.0, 77/256=log 2*)
			x:=x/Reals.TenL(e);
		ELSE (*x<1.0*)
			x:=Reals.TenL(-e)*x;
		END;
		IF x>=10.0D0 THEN x:=0.1D0*x; INC(e); END;
		(* 1 <= x<10 *)
		IF k+e>=maxD-1 THEN
			k:=maxD-1-e;
		ELSIF k+e<0 THEN
			k:=-e; x:=0.0D0;
		END;
		x0:=Reals.TenL(k+e); x:=x0*x+0.5D0;
		IF x>=10.0D0*x0 THEN INC(e); END;
		(*e=no. of digits before decimal point*)
		INC(e); i:=k+e; Reals.ConvertL(x,i,d);
		IF e>0 THEN
			seq(" ",n-e-k-2); ch(sign); dig(e);
			ch("."); dig(k);
		ELSE
			seq(" ",n-k-3);
			ch(sign); ch("0"); ch(".");
			seq("0",-e); dig(k+e);
		END;
	END;
END longRealFix;

BEGIN
END w.