/* $Id: buffer.h,v 1.3 1999/06/16 23:20:07 levitte Exp $ */

#ifndef BUFFER_H
#define BUFFER_H

#include <openssl/bn.h>

typedef struct genbuf {
    void *bytes;
    unsigned int amount;
    unsigned int space;
    unsigned char is_static;
} general_buffer;

general_buffer *buf_init(unsigned int n);
general_buffer *buf_init_static(general_buffer *buf, void *b, unsigned int n);
void buf_destroy(general_buffer *buf);

int buf_expand_by(general_buffer *buf, unsigned int n);
int buf_expand_to(general_buffer *buf, unsigned int n);

void buf_adjust_amount_by(general_buffer *buf, unsigned int n);
void buf_adjust_amount_to(general_buffer *buf, unsigned int n);

unsigned char *buf_chars_noadjust(general_buffer *buf);
char *buf_chars(general_buffer *buf);
void *buf_bytes(general_buffer *buf);
unsigned int buf_amount(general_buffer *buf);
unsigned int buf_remaining(general_buffer *buf);

int buf_append_bytes(general_buffer *buf, void *b, int n);
int buf_append_chars(general_buffer *buf, char *b);
int buf_append_chars_nocount(general_buffer *buf, char *b);
int buf_append_int(general_buffer *buf, unsigned long b);
int buf_append_word(general_buffer *buf, unsigned short b);
int buf_append_bn(general_buffer *buf, BIGNUM *b);
int buf_chop_at(general_buffer *buf, unsigned int n);

typedef struct gbread {
    general_buffer *buf;
    unsigned int pos;
    unsigned char is_static;
} general_buffer_reader;

general_buffer_reader *bufread_init(general_buffer *buf);
general_buffer_reader *bufread_init_static(general_buffer_reader *br,
					   general_buffer *buf);
void bufread_destroy(general_buffer_reader *br);

unsigned char *bufread_chars_noadjust(general_buffer_reader *br);
general_buffer *bufread_buffer(general_buffer_reader *br);
unsigned int bufread_remaining(general_buffer_reader *br);
unsigned int bufread_position(general_buffer_reader *br);

int bufread_int(general_buffer_reader *br, unsigned long *l);
int bufread_word(general_buffer_reader *br, unsigned short *l);
int bufread_bytes(general_buffer_reader *br, void *b, int n);
int bufread_strdup(general_buffer_reader *br, char **result);
int bufread_bn(general_buffer_reader *br, BIGNUM **bn);
int bufread_glob(general_buffer_reader *br, unsigned int n);

#endif

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
