/* $Id: des.c,v 1.6 1999/06/16 23:41:51 levitte Exp $ */

#include "gnu_extras.h"

#include <openssl/des.h>
#include <openssl/opensslv.h>
#include "des_hack.h"
#include "Pilot.h"
#include "ssh.h"
#include "util.h"
#include "fishmsg.h"

typedef struct {
    des_key_schedule k;
    des_cblock ivec;
} Tdes_state;

void ssh_des_encrypt(unsigned char *in, unsigned char *out, long len,
    void *encryptstate_)
{
    Tdes_state *encryptstate = encryptstate_;

    des_ncbc_encrypt(des_cblock_arg(in), des_cblock_arg(out), len,
		     encryptstate->k, des_cblock_ivec((encryptstate->ivec)),
		     DES_ENCRYPT);
}

void ssh_des_decrypt(unsigned char *in, unsigned char *out, long len,
    void *decryptstate_)
{
    Tdes_state *decryptstate = decryptstate_;

    des_ncbc_encrypt(des_cblock_arg(out), des_cblock_arg(out), len,
		     decryptstate->k, des_cblock_ivec((decryptstate->ivec)),
		     DES_DECRYPT);
}

void ssh_des_clean(ssh_state *state)
{
    xfree(state->encryptstate);
    xfree(state->decryptstate);
    state->encrypt = NULL;
    state->decrypt = NULL;
    state->cryptclean = NULL;
}

void *ssh_des_encryptstate(ssh_state *state, int keylen, Erf erf, void *erfp)
{
    Tdes_state *encryptstate = xmalloc(sizeof(Tdes_state));
    des_cblock k;

    if (!encryptstate) {
	ssh_F_memfull();
	return NULL;
    }
    memcpy(k,state->sesskey,sizeof(k));

    des_set_key(des_cblock_set_arg(k),encryptstate->k);

    memset(encryptstate->ivec, 0, 8);

    return encryptstate;
}

void *ssh_des_decryptstate(ssh_state *state, int keylen, Erf erf, void *erfp)
{
    return ssh_des_encryptstate(state, keylen, erf, erfp);
}

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
