! $Id: descrip.mms,v 1.52 1999/06/16 23:21:38 levitte Exp $

! DESCRIP.MMS for FISH, a VMS SSH client.
!
!   Copyright (c) 1998, Christer Weinigel <wingel@ctrl-c.liu.se>
!   Copyright (c) 1998, Richard Levitte <richard@levitte.org>
!
!   See the file COPYRIGHT. for further information
!
!--------------------------------------------------------------
! The zlib dist currently used
ZLIB = zlib-1_1_3
!--------------------------------------------------------------
!
!	User macros.  Change at will.
!
! We need a few files from SSLeay.  YOU PROBABLY NEED TO CHANGE THIS!
SSLINCLUDEDIR = SSLINCLUDE:
SSLLIBDIR = SSLLIB:
SSLLIBRARYNAME = LIBCRYPTO.OLB

.ifdef GNUC
CC = GCC /nocase_hack
CFLAGS = /include=('SSLinclude',[-.$(ZLIB)]) 'debug_cflags' 'internal_cflags'
LDFLAGS = 'debug_ldflags' 'internal_ldflags' /SYSEXE
.else
CC = cc /decc /warning=(disable=(PREOPTW)) $(CC_DEBUG)
CFLAGS = /include=('SSLinclude',[-.$(ZLIB)]) /prefix=all 'debug_cflags' 'internal_cflags'
LDFLAGS = 'debug_ldflags' 'internal_ldflags'
.endif

!--------------------------------------------------------------
!
!	Internal macro definitions.  Please do not change
!
EXE = fish.exe
LIBRARYMODULES = fish, ssh, packet, crc32, 3des, idea, rc4, blowfish, des, -
		 fish_internal, util, log, vms, user_info, fish-keygen, -
		 compress, fishmsg, buffer, userkey
LIBRARIES = fishlib.olb($(LIBRARYMODULES)) 
SOURCEDIR = [-.SRC]

! All the source we distribute
DISTFILES = *.txt copyright.* *.com [.src]*.com [.src]*.c [.src]*.h -
	    [.src]*.cld [.src]*.msg [.src]*.mms [.src]*.rnh [.src]*.opt -
	    [.$(ZLIB)...]*.*
! Some binaries we also distribute
ZIPDISTEXTRA = [.bin-*]*.*

! And the SSLeay library and include files, if they exist.
SSLLIBDIST = [.ssllib-*]*.*
SSLINCDIST = [.sslinclude]*.*

! Things not to include in a dist.
DISTEXCEPTIONS = -x wish-*.* fishmsg.h

! include version.opt, since that gives us information like version number.
.include version.opt

!--------------------------------------------------------------
!
!	On to the building part
!
.FIRST :
	@ debug_cflags = "/nodebug /optimize"
	@ debug_ldflags = "/nodebug /notraceback"
	@ ZLIB_DEBUG = ""
	@ ZLIB_DEFS = ""
	@ CPU := VAX
	@ if f$getsyi("CPU") .ge. 128 then CPU := AXP
	@ if f$parse("[-.BIN-''CPU']") .eqs. "" then -
		create/dir [-.BIN-'CPU']
	@ ! Look for the SSL library
	@ write sys$output "[Determining where the crypto library is]"
	@ SSLlibrary := $(SSLLIBDIR)LIBCRYPTO.OLB
	@ if f$search(SSLlibrary) .eqs. "" then -
		SSLlibrary := $(SSLLIBDIR)$(SSLLIBRARYNAME)
	@ ! Fallback
	@ if f$search(SSLlibrary) .eqs. "" then -
		SSLlibrary := [-.SSLLIB-'CPU']LIBCRYPTO.OLB
	@ if f$search(SSLlibrary) .eqs. "" then -
		SSLlibrary :=
	@ if SSLlibrary .eqs. "" then -
		write sys$error "I can't find the OpenSSL library in $(SSLLIBDIR)"
	@ if SSLlibrary .eqs. "" then exit
	@ ! Look for the SSL include directory
	@ SSLinclude := $(SSLINCLUDEDIR)
	@ ! Fallback
	@ if f$search(SSLinclude + "RAND.H") .eqs. "" then -
		SSLinclude := [-.SSLINCLUDE]
	@ if f$search(SSLinclude + "RAND.H") .eqs. "" then -
		SSLinclude :=
	@ if SSLinclude .eqs. "" then -
		write sys$error "I can't find the OpenSSL include file RAND.H in $(SSLINCLUDEDIR)"
	@ if SSLinclude .eqs. "" then exit
	@ ! OpenSSL 0.9.3 includes files as <openssl/foo.h>.  This software
	@ ! has addapted to that, so if an earlier OpenSSL or SSLeay is used,
	@ ! define the OPENSSL logical name so we will have no problems.
	@ if f$trnlnm("OPENSSL") .nes. SSLinclude then -
		define openssl 'SSLinclude'
	@ ! Check if we need the VAX C RTL.
	@ write sys$output "[Determining if the VAX C RTL will be needed]"
	@ crypto_decc := yes
	@ pid = f$getjpi("","PID")
	@ if CPU .eqs. "VAX" then library/cross=symbol/output=libcrypto.crf_'pid' 'SSLlibrary'
	@ if CPU .eqs. "VAX" then sear/output=search.result_'pid' libcrypto.crf_'pid' decc$fopen
	@ if CPU .eqs. "VAX" then if f$file("search.result_''pid'","eof") .eq. 0 then crypto_decc := no
	@ if CPU .eqs. "VAX" then delete/nolog libcrypto.crf_'pid';*,search.result_'pid';*
	@ internal_cflags = "/define=FISH_VERSION=""""""" + ($(IDENT) - "V") + """"""""
	@ internal_ldflags :=
	@ if .not. crypto_decc then internal_ldflags = ",vaxcrtl.opt/opt"
	@ write sys$output "[Resulting symbols]"
	SHOW SYMBOL SSLinclude
	SHOW SYMBOL SSLlibrary
	SHOW SYMBOL INTERNAL_*
	SHOW SYMBOL DEBUG_*

all : [-]$(EXE) fish.hlp
	@ !

debug : setup-debug all
	@ !

setup-debug :
	debug_cflags = "/DEBUG/NOOPT"
	debug_ldflags = "/DEBUG/TRACEBACK"
	ZLIB_DEBUG = "/DEBUG"

make_portable :
	! This is probably paranoid and overly redundant, but that's much
	! better than skiping it all...
	internal_cflags = "/define=(__VMS_VER=60000000,__CRTL_VER=60000000,_VMS_V6_SOURCE=1,_DECC_V4_SOURCE=1,FISH_VERSION=""""""" + ($(IDENT) - "V") + """"""")"
	ZLIB_DEFS = "/define=(__VMS_VER=60000000,__CRTL_VER=60000000,_VMS_V6_SOURCE=1,_DECC_V4_SOURCE=1)/warning=disable=PREOPTW"

[-]$(EXE) :  $(LIBRARIES) fish.opt zlib
	set default [-]
	copy [.src]fishlib.olb [.BIN-'CPU']
	copy [.$(ZLIB)]libz.olb [.BIN-'CPU']
	- link /exec=$(EXE) [.BIN-'CPU']fishlib/lib /include=(fish),[.src]fish.opt/opt,[.src]version.opt/opt $(LDFLAGS)
	set default [.src]

fish.hlp : fish.rnh
	runoff fish.rnh
	copy fish.hlp [-]

.ifdef GNUC
fish.opt : descrip.mms
	open/write fish_opt fish.opt
	write fish_opt "[.BIN-''CPU']LIBZ.OLB/LIB"
	write fish_opt SSLlibrary,"/LIB"
	write fish_opt "NETLIB_SHRXFR/SHARE"
	write fish_opt "GNU_CC_LIBRARY:libgcc.olb/lib"
	write fish_opt "sys$library:vaxcrtl.olb/lib"
	write fish_opt "GNU_CC_LIBRARY:crt0.obj"
	close fish_opt
.else
fish.opt : descrip.mms
	open/write fish_opt fish.opt
	write fish_opt "[.$(ZLIB)]LIBZ.OLB/LIB"
	write fish_opt SSLlibrary,"/LIB"
	write fish_opt "NETLIB_SHRXFR/SHARE"
	if internal_ldflags - ",VAXCRTL.OPT/OPT" .nes. internal_ldflags then -
		write fish_opt "SYS$SHARE:VAXCRTL/SHARE"
	close fish_opt
.endif

zlib :
	set default [-.$(ZLIB)]
	$(MMS) $(MMS$QUALIFIERS) /MACRO=(__DECC__=1,C_DEB="''ZLIB_DEBUG'",CC_DEFS="''ZLIB_DEFS'") -
		libz.olb
	set default [-.src]

fishmsg.obj : fish.msg
	message fish.msg /object=fishmsg.obj

fishmsg.h : fish.msg genmsghdr.com
	@genmsghdr fish.msg fishmsg.h

almostclean :
	- purge/log [-...]
	- delete/log *.obj;*
	- delete/log [-.$(ZLIB)]*.obj;*
	- delete/log *.exe;*,[-]*.exe;*

olbclean : 
	- delete/log *.olb;*
	- delete/log [-.$(ZLIB)]*.olb;*

clean : almostclean
	- delete/log [-.BIN-'CPU']fishlib.olb;*
	- delete/log [-.BIN-'CPU']libz.olb;*

optclean :
	- delete/log fish.opt;*

distclean : clean optclean olbclean
	@ !

.ifdef GNUC
.else
depend : fishmsg.h
	open/write dep_f dependencies.mms
	write dep_f "! This file was generated automagically with $(MMS) DEPEND"
	@loop.com "$(CC) $(CFLAGS) /MMS=(FILE=dep_f:,NOSYS)" "$(LIBRARYMODULES)" ".C"
	close dep_f
	@hackpaths.com dependencies.mms 'f$env("default")' "f$edit(line - f$element(0,"":"",line) - "":"",""trim"")"
.endif
! Start with cleaning it all, then do a complete rebuild WITH PORTABILITY
! FLAGS ALL SET, then clean all you don't need, then build the distribution.
! If you think it's rough, well...
dist :  distclean make_portable all -
		almostclean optclean olbclean -
		versions zip.comment copy-openssl
	set default [-]
	- delete fish'vmsver'.zip;*
	- define/user sys$input zip.comment
	- define/user sys$output zip.log
	- zip -"Vz" fish'vmsver'.zip $(DISTFILES) $(ZIPDISTEXTRA) $(SSLLIBDIST) $(SSLINCDIST) $(DISTEXCEPTIONS)

dist-nossllib : distclean make_portable all -
		almostclean optclean olbclean -
		versions zip.comment
	set default [-]
	- delete fish'vmsver'.zip;*
	- define/user sys$input zip.comment
	- define/user sys$output zip.log
	- zip -"Vz" fish'vmsver'.zip $(DISTFILES) $(ZIPDISTEXTRA) $(DISTEXCEPTIONS) link.com

distsrc : versions copy-openssl
	set default [-]
	- delete fish'vmsver'_src.zip;*
	- define/user sys$output zip.log
	- zip -"V" fish'vmsver'_src.zip $(DISTFILES) $(SSLLIBDIST) $(SSLINCDIST) $(DISTEXCEPTIONS) link.com

distsrc-nossllib : versions
	set default [-]
	- delete fish'vmsver'_src.zip;*
	- define/user sys$output zip.log
	- zip -"V" fish'vmsver'_src.zip $(DISTFILES) $(DISTEXCEPTIONS) link.com

versions : version.opt FRC
	version = f$element(0," ",f$extract(1,10,$(IDENT)))
	major = f$element(0,".",version)
	minor = f$element(0,"-",f$element(1,".",version))
	update = f$element(1,"-",version)
	vmsver = "0''major'''minor'"
	if major .gt. 9 then vmsver = "''major'''minor'"
	if update .nes. "-" then vmsver = "U''update'"+vmsver
	
zip.comment : version.opt descrip.mms
	- open/write foo [-]zip.comment
	- write foo ""
	- write foo "FISH ''version' -- an SSH client for VMS"
	- write foo ""
	- write foo "Runs on both OpenVMS/VAX and OpenVMS/AXP."
	- write foo ""
	- write foo "To get the executable, just do @LINK after you extracted"
	- write foo "the files."
	- write foo ""
	- close foo

copy-openssl :
	if f$parse("[-.SSLLIB-''CPU']") .eqs. "" then -
		create/dir [-.SSLLIB-'CPU']
	copy_files := NO
	copy_from := 'SSLlibrary'
	copy_to := [-.SSLLIB-'CPU']LIBCRYPTO.OLB
	if f$search(copy_to) .eqs. "" then copy_files := YES
	if .not. copy_files then -
		if f$file(copy_from,"FID") .nes. f$file(copy_to,"FID") then -
			copy_files := YES
	if copy_files then copy 'SSLlibrary' [-.SSLLIB-'CPU']LIBCRYPTO.OLB
	if f$parse("[-.SSLINCLUDE]") .eqs. "" then -
		create/dir [-.SSLINCLUDE]
	copy_files := NO
	copy_from := 'SSLinclude'rand.h
	copy_to := [-.SSLINCLUDE]rand.h
	if f$search(copy_to) .eqs. "" then copy_files := YES
	if .not. copy_files then -
		if f$file(copy_from,"FID") .nes. f$file(copy_to,"FID") then -
			copy_files := YES
	if copy_files then copy 'SSLinclude'*.* [-.SSLINCLUDE]
	purge [-.SSL*]

FRC :
	@ ! This clause is to force other clauses to happen.

!--------------------------------------------------------------
!
!	Source dependencies
!
.include dependencies.mms
