/* $Id: rc4.c,v 1.6 1999/06/16 23:41:52 levitte Exp $ */

#include "gnu_extras.h"

#include <openssl/rc4.h>
#include "Pilot.h"
#include "ssh.h"
#include "util.h"
#include "fishmsg.h"

typedef struct {
    RC4_KEY rc4_key;
} Trc4_state;

void ssh_rc4_encrypt(unsigned char *in, unsigned char *out, long len,
		     void *encryptstate_)
{
    Trc4_state *encryptstate = encryptstate_;

    RC4(&encryptstate->rc4_key, len, in, out);
}

void ssh_rc4_decrypt(unsigned char *in, unsigned char *out, long len,
		     void *decryptstate_)
{
    Trc4_state *decryptstate = decryptstate_;

    RC4(&decryptstate->rc4_key, len, in, out);
}

void ssh_rc4_clean(ssh_state *state)
{
    xfree(state->encryptstate);
    xfree(state->decryptstate);
    state->encrypt = NULL;
    state->decrypt = NULL;
    state->cryptclean = NULL;
}

void *ssh_rc4_encryptstate(ssh_state *state, int keylen, Erf erf, void *erfp)
{
    Trc4_state *encryptstate = xmalloc(sizeof(Trc4_state));
    if (!encryptstate) {
	ssh_F_memfull();
	return NULL;
    }
    RC4_set_key(&encryptstate->rc4_key, 16, state->sesskey + 16);

    return encryptstate;
}

void *ssh_rc4_decryptstate(ssh_state *state, int keylen, Erf erf, void *erfp)
{
    Trc4_state *decryptstate = xmalloc(sizeof(Trc4_state));
    if (!decryptstate) {
	ssh_F_memfull();
	return NULL;
    }
    RC4_set_key(&decryptstate->rc4_key, 16, state->sesskey);

    return decryptstate;
}

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
