/* $Id: sock.h,v 1.2 1999/04/15 13:16:03 levitte Exp $ */
#ifndef __SOCK_H__
#define __SOCK_H__

#include "erf.h"

typedef struct sock_state_s {
    void (*up_dispatch)(unsigned char *data, long len, void *dispatchstate,
			Erf,void*);
    void (*up_setconnid)(char *connid, void *state, Erf,void*);
    void *up_state;

    char *connid;
    int fd;
} sock_state;

void *sock_init(const char *host, int port, int *fd,Erf,void*);
long sock_write(unsigned char *data, long amt, void *state, Erf,void*);
void sock_dispatch(unsigned char *data, long amt, void *state, Erf,void*);
void sock_set_dispatch(
	void (*up_dispatch)(unsigned char *,long,void *,Erf,void*),
	void *up_state, void *state, Erf,void*);
void sock_set_setconnid(void (*up_setconnid)(char *, void *, Erf,void*),
	void *state, Erf,void*);

#endif

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
