/* $Id: userkey.h,v 1.3 1999/06/17 02:37:11 levitte Exp $ */

#ifndef USERKEY_H
#define USERKEY_H

#include "buffer.h"

typedef struct userkey {
    unsigned char cipher_type;
    unsigned long bits;
    RSA *key;
    char *comment;
    unsigned char *encrypted_data;
    unsigned long encrypted_len;
} userkey;

userkey *userkey_init(void);
void userkey_init_static(userkey *uk);
void userkey_destroy(userkey *uk);
void userkey_destroy_static(userkey *uk);
int userkey_decode_buffer(userkey *uk, general_buffer *buf);
int userkey_encode_buffer(userkey *uk, general_buffer **buf);
int userkey_decrypt_private_part(userkey *uk, general_buffer *passphrase);
int userkey_encrypt_private_part(userkey *uk, general_buffer *passphrase);
int userkey_read_keyfile(userkey *uk, char *filename, unsigned long uic);
#if 0 /* NYI */
int userkey_write_keyfile(userkey *uk, char *filename, unsigned long uic);
#endif

#endif

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
