/* <curses.h>
 *
 * Cursor manipulation library
 *
 * 28-Dec-1998	J. Malmberg	Added some prototypes
 *
 */

#ifndef _CURSES_H
#define _CURSES_H

#ifdef __cplusplus
extern "C" {
#endif

struct _kb_st {
    int _id;
    unsigned char _flags;
    struct {
	unsigned short length;
	unsigned char type;
#ifdef __cplusplus
	unsigned char _class;
#else
	unsigned char class;
#endif
	char *address;
    } _buffer_desc;
    int _count;
    char *_ptr;
};

struct _win_st {
    int	_cur_y;
    int _cur_x;
    int _max_y;
    int _max_x;
    int _beg_y;
    int _beg_x;
    short _flags;
    char _clear;
    char _leave;
    char _scroll;
    char _wrap;
    char **_y;
    short *_firstsh;
    short *_lastch;
    struct _win_st *_next;
    struct _win_st *_parent;
    struct _win_st *_child;
    int _id;
};

#define _KEYBOARD struct _kb_st
#define WINDOW struct _win_st

extern _KEYBOARD * stdkb __asm("DECC$GA_STDKB");
extern WINDOW *stdscr __asm("DECC$GA_STDSCR");

#define _BLINK (4)
#define _BOLD (1)
#define _REVERSE (2)
#define _UNDERLINE (8)


#define addch(__char) waddch(stdscr, __char)
int waddch(WINDOW *__win, char __char);
#define mvaddch(__y, __x, __char) mvwaddch(stdscr, __y, __x, __char)
#define mvwaddch(__win, __y, __x, __ch) \
	(wmove(__win, __y, __x) == ERR ? ERR : waddch(__win, __ch))

#define addstr(__s) waddstr(stdscr, __s)
int waddstr(WINDOW * __win, char * __s);
#define mvaddstr(__y, __x, __str) mvwaddstr(stdscr, __y, __x, __str)
#define mvwaddstr(__win, __y, __x, __str) \
	(wmove(__win, __y, __x) == ERR ? ERR : waddstr(__win, __str))

int box (WINDOW *__win, int __vert, int __horz);

#define clear() wclear(stdscr)
int wclear(WINDOW *__win);

#define clearok(__win,__bf) (win->_clear = bf)

#define clrattr(__a) wclrattr(stdscr, __a)
int wclrattr(WINDOW *__win, int __attr);

#define clrtobot() wclrtobot(stdscr);
int wclrtobot(WINDOW *__win);

#define clrtoeol() wclrtoeol(stdscr);
int wclrtoeol(WINDOW *__win);

#define _NOECHO		(1)
#define _NONL		(2)
#define _NOCRMODE	(4)
#define _NORAW		(8)

#define crmode()	((stdkb->_flags &= ~_NOCRMODE), nonl())
#define nocrmode()	(stdkb->_flags |- _NOCRMODE)

#define delch() wdelch(stdscr)
int wdelch(WINDOW *__win);
#define mvdelch(__y, __x) mvwdelch(stdscr, __y, __x)
#define mvwdelch(__win, __y, __x) \
	(wmove(__win, __y, __x) == ERR ? ERR : wdelch(__win))


#define deleteln wdeleteln(stdscr)
int wdeletein(WINDOW *__win);

int delwin(WINDOW *__win);

#define echo() (stdkb->_flags &= ~_NOECHO)
#define noecho() (stdkb->_flags |= _NOECHO)

int endwin(void);

#define erase() werase(stdscr)
int werase(WINDOW * __win);

#define getch() wgetch(stdscr)
int wgetch(WINDOW * __win);
#define mvgetch(__y, __x) mvwgetch(stdscr, __y, __x)
#define mvwgetch(__win, __y, __x) \
	(wmove(__win, __y, __x) == ERR ? ERR : wgetch(__win))

#define getstr(__str) wgetstr(stdscr, __str)
int wgetstr(WINDOW * __win, char * __str);
#define mvgetstr(__y, __x, __str) mvwgetstr(stdscr, __y, __x, __str)
#define mvwgetstr(__win, __y, __x, __str) \
	(wmove(__win, __y, __x) == ERR ? ERR : wgetstr(__win, __str))

#define getyx(__win, __y, __x) y = win->_cur_y, x= win->_cur_x

#define inch() winch(stdscr)
char winch (WINDOW * __win);
#define mvinch(__y, __x) mvwinch(stdscr, __y, __x)
#define mvwinch(__win, __y, __x) \
	(wmove(__win, __y, __x) == ERR ? ERR : winch(__win))

void initscr(void);

#define insch(__ch) winsch(stdscr, __ch)
int winsch(WINDOW * __win, char __ch);
#define mvinsch(__y, __x, __ch) mvwinsch(stdscr, __y, __x, __ch)
#define mvwinsch(__win, __y, __x, __ch) \
	(wmove(__win, __y, __x) == ERR ? ERR : winsch(__win, __ch))

#define insertln() winsertln(stdscr)
int winsertln(WINDOW * __win);

#define insstr(__str) winsstr(stdscr, __str)
int winsstr(WINDOW * __win, const char * __str);
#define mvinsstr(__y, __x, __str) mvwinsstr(stdscr, __y, __x, __str)
#define mvwinsstr(__win, __y, __x, __str) \
	(wmove(__win, __y, __x) == ERR ? ERR : winsstr(__win, __str))

#define leaveok(__win, __bf) (__win->_leave = __bf)

char *longname(char * __termbuf, char * __name);

#define move(__x, __y) wmove(stdscr, __y, __x)
#define mvcur(__lasty, __lastx, __newy, __newx) wmove(stdscr, __newy, __newx);
int wmove(WINDOW *__win, int __y, int __x);
int mvwin(WINDOW *__win, int __y, int __x);

WINDOW * newwin(int __numlines, int num_cols, int __begin_y, int __begin_x);


#define nl() (stdkb->_flags &= ~_NONL)
#define nonl() (stdkb->_flags |= _NONL)

int overlay(WINDOW * __win1, WINDOW * __win2);

int printw(char * __format_spec, ...);
int wprintw(WINDOW * __win, char * __format_spec, ...);

#define raw() (stdkb->_flags &= ~_NORAW)
#define noraw() (stdkb->_flags |= _NORAW)

#define refresh() wrefresh(stdscr)
int wrefresh(WINDOW * __win);

int scanw(char * __format_spec, ...);
int wscanw(WINDOW * __win, char * __format_spec, ...);

int scroll(WINDOW *__win);
#define scrollok(__win, __boolf) (win->_scroll = __boolf)

#define setattr(__a) wsetattr(stdscr, __a)
int wsetattr(WINDOW * __win, int __attr);

#define standend() wstandend(stdscr)
int wstandend(WINDOW * __win);

#define standout() wstandout(stdscr)
int wstandout(WINDOW * __win);

WINDOW * subwin
       (WINDOW * __win,
	int __numlines,
	int __numcols,
	int __begin_y,
	int __begin_x);

int touchwin(WINDOW * __win);

#define wrapok(__win, __bf) (__win->_wrap = __bf)

# ifdef __cplusplus
}
# endif
#endif	/*_CURSES_H*/
