/* File: DIRENT.H
**
** From the GCC 2.5.8 Distribution
**
** 28-May-1998	J. Malmberg	Minor modifications
** 27-Jun-1998	J. Malmberg	Added include of descrip.h
** 15-Dec-1998	J. Malmberg	Wrapped define of rewinddir
** 23-Dec-1998	J. Malmberg	Adjusted dirent to match DEC C RTL
** 28-Dec-1998	J. Malmberg	Minor adjustments for DEC C and X/OPEN
****************************************************************************/

#ifndef _DIRENT_H_
#define _DIRENT_H_

#include <sys/types.h>

#ifndef NAME_MAX
#define NAME_MAX (256)
#endif

#define MAXVERS	20

#ifndef _GNU_DIRECTORY_

#ifndef _DESCRIP_H
#include <descrip.h>
#endif

struct dirent
	{
	  char	d_name[100];
	  int	vms_verscount;
	  int	vms_versions[MAXVERS];
	};

typedef struct _dirdesc
        {
          long				context;
          int				vms_wantversions;
          char				*pattern;
          struct dirent			entry;
          struct dsc$descriptor_s	pat;
        } DIR;

#else
	 /* DEC C RTL definition */
	/*----------------------*/

typedef struct _dirdesc DIR;	/* Internals Unknown */

struct dirent
	{
	  char d_name[NAME_MAX];
#ifdef UNIX_INO_T
	  ino_t d_ino;
	  unsigned short d_ino_rvn;	/* Relative Volume Number */
#else
#ifdef FIXED_INO_T
	  ino_t d_ino;
#else
	  ino_t d_ino[3];
#endif
#endif
	}
#endif



#ifdef __cpluspus
extern "C"
  {
#endif
   DIR			*opendir(const char * __dirname);
   struct dirent	*readdir(DIR * __dirptr);
   long			 telldir(DIR * __dirptr);
   void			 seekdir(DIR * __dirptr, long __pos);
   int			 closedir(DIR * __dirptr);

    /* vmsreaddirversions() is not in DEC C RTL */
   /*------------------------------------------*/
   void			 vmsreaddirversions();

    /* readdir_r is not documented in DEC C RTL yet */
   /*----------------------------------------------*/
   int			 readdir_r
			       (DIR * __dirptr,
				struct dirent * __dir1,
				struct dirent * __dir2[]);

    /* rewinddir may be aliased for an alternate RTL */
   /*-----------------------------------------------*/
#ifndef rewinddir
#define rewinddir(dirp)	seekdir((dirp), 0L)
#endif

void (rewinddir)(DIR * __dirptr);

#ifdef __cpluspus
  }
#endif


#endif _DIRENT_H_
