/* File: GRP.H
 *  group.h   iBCS compatable header file
 *
 *  28-Jun-1998	J. Malmberg	Adapted from LINUX distribution
 */

#ifndef _GRP_H
#define _GRP_H

#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif

struct group {
  char * gr_name;	/* the name of the group */
  gid_t  gr_gid;	/* numerical group id */
  char   **gr_mem;	/* pointer to a null terminated array of */
			/*  character pointers to member names */
#ifdef GNU_GROUP
  char * gr_passwd;	/* Useless for VMS, Some UN*X programs may want */
#endif
};

# ifdef __cplusplus
extern "C" {
# endif

struct group	*getgrgid(gid_t __gid);
struct group	*getgrnam(char * __name);
int		 getgrid_r
		       (gid_t __gid,
			struct group * __group,
			char *,
			size_t,
			struct group **);
int		 getgrname_r
		       (const char * __grpnam,
			struct group *,
			char *,
			size_t,
			struct group **);
struct group	*getgrent(void);
void		 endgrent(void);
void		 setgrent(void);

# ifdef __cplusplus
}
# endif

#endif /* _GRP_H */
