 /* File: inttypes.h  ** ** X/OPEN Integer types  **6 ** This header file is required by ANSI Working Draft,# **	1997-11-21, WG14/N794 J11/97-158  **E ** 28-Dec-1998	J. Malmberg  as known to X/OPEN Single Unix Spec. V 2.  **L ***************************************************************************/   #ifndef _INTTYPES_H  #define _INTTYPES_H    #ifdef __cplusplus extern "C" { #endif   typedef char		int8_t;  typedef short		int16_t;  typedef long		int32_t;7 /* typedef struct { long __p1; long __p2; } int64_t; */  typedef long long	int64_t;   typedef unsigned char	uint8_t;  typedef unsigned short	uint16_t; typedef unsigned long	uint32_t; I /* typedef struct {unsigned long __p1; unsigned long __p2; } uint64_t; */ $ typedef unsigned long long uint64_t;   typedef char		int_least8_t;  typedef short		int_least16_t;  typedef long		int_least32_t; typedef int64_t		int_least64_t;   $ typedef unsigned char	uint_least8_t;& typedef unsigned short	uint_least16_t;% typedef unsigned long	uint_least32_t;   typedef uint64_t	uint_least64_t;   typedef char		int_fast8_t; typedef short		int_fast16_t; typedef int		int_fast32_t; typedef int64_t		int_fast64_t;  # typedef unsigned char	uint_fast8_t; % typedef unsigned short	uint_fast16_t; # typedef unsigned int	uint_fast32_t;  typedef uint64_t	uint_fast64_t;      typedef int32_t		intptr_t; typedef uint32_t	uintptr_t;    typedef int		intmax_t; typedef unsigned	uintmax_t;    #if !defined(__cplusplus) || \7 	(defined(__cplusplus) && defined(__STDC_LIMIT_MACROS))    #define INT8_MIN	(-127)  #define INT16_MIN	(-32768)# #define INT32_MIN	(-2147483647 - 1) 1 #define INT64_MIN	(-92233720368554775807LL - 1LL)    #define INT8_MAX	(128) #define INT16_MAX	(32767)  #define INT32_MAX	(2147483647)* #define INT64_MAX	(92233720368554775807LL)   #define UINT8_MAX	(256)  #define UINT16_MAX	(65535U)   #define UINT32_MAX	(4294967295U)    #define INT_LEAST8_MIN		INT8_MIN" #define INT_LEAST16_MIN		INT16_MIN" #define INT_LEAST32_MIN		INT32_MIN" #define INT_LEAST64_MIN		INT64_MIN    #define INT_LEAST8_MAX		INT8_MAX" #define INT_LEAST16_MAX		INT16_MAX" #define INT_LEAST32_MAX		INT32_MAX" #define INT_LEAST64_MAX		INT64_MAX  " #define UINT_LEAST8_MAX		UINT8_MAX# #define UINT_LEAST16_MAX	UINT16_MAX # #define UINT_LEAST32_MAX	UINT32_MAX # #define UINT_LEAST64_MAX	UINT64_MAX    #define INT_FAST8_MIN		INT8_MIN ! #define INT_FAST16_MIN		INT16_MIN ! #define INT_FAST32_MIN		INT32_MIN ! #define INT_FAST64_MIN		INT64_MIN    #define INT_FAST8_MAX		INT8_MAX ! #define INT_FAST16_MAX		INT16_MAX ! #define INT_FAST32_MAX		INT32_MAX ! #define INT_FAST64_MAX		INT64_MAX   ! #define UINT_FAST8_MAX		UINT8_MAX # #define UINT_FAST16_MAX		UINT16_MAX # #define UINT_FAST32_MAX		UINT32_MAX # #define UINT_FAST64_MAX		UINT64_MAX    #define INTPTR_MIN	INT32_MIN #define INTPTR_MAX	INT32_MAX #define UINTPTR_MAX	UINT32_MAX   #define INTMAX_MIN	INT64_MIN #define INTMAX_MAX	INT64_MAX #define UINTMAX_MAX	UINT64_MAX   #endif#  /* Macros for Integer Constants */ " /*------------------------------*/ #if !defined(__cplusplus) || \: 	(defined(__cplusplus) && defined(__STDC_CONSTANT_MACROS))  ! #define INT8_C(__value)	(__value) " #define INT16_C(__value) (__value)' #define INT32_C(__value) (__value ## L) ( #define INT64_C(__value) (__value ## LL)  ' #define UINT8_C(__value) (__value ## U) ( #define UINT16_C(__value) (__value ## U)) #define UINT32_C(__value) (__value ## UL) * #define UINT64_C(__value) (__value ## ULL)  ) #define INTMAX_C(__value) (__value ## LL) + #define UINTMAX_C(__value) (__value ## ULL)    #endif  #  /* Macros for Format specifiers */ " /*------------------------------*/ #if !defined(__cplusplus) || \8 	(defined(__cplusplus) && defined(__STDC_FORMAT_MACROS))  )  /* fprintf macros for signed integers */ ( /*------------------------------------*/ #define PRId8		"hd"  #define PRIdLEAST8	PRId8 #define PRIdFAST8	PRId8    #define PRId16		"hd" #define PRIdLEAST16	PRId16 #define PRIdFAST16	PRId16    #define PRId32		"d"  #define PRIdLEAST32	PRId32 #define PRIdFAST32	PRId32    #define PRId64		"lld"  #define PRIdLEAST64	PRId64 #define PRIdFAST64	PRId64    #define PRIdMAX		"lld"   #define PRIdPTR		"d"   #define PRIi8		"hi"  #define PRIiLEAST8	PRIi8 #define PRIiFAST8	PRIi8    #define PRIi16		"hi" #define PRIiLEAST16	PRIi16 #define PRIiFAST16	PRIi16    #define PRIi32		"i"  #define PRIiLEAST32	PRIi32 #define PRIiFAST32	PRIi32    #define PRIi64		"lli"  #define PRIiLEAST64	PRIi64 #define PRIiFAST64	PRIi64    #define PRIiMAX		"lli"   #define PRIiPTR		"i"    +  /* fprintf macros for unsigned integers */ ( /*------------------------------------*/ #define PRIo8		"ho"  #define PRIoLEAST8	PRIo8 #define PRIoFAST8	PRIo8    #define PRIo16		"ho" #define PRIoLEAST16	PRIo16 #define PRIoFAST16	PRIo16    #define PRIo32		"o"  #define PRIoLEAST32	PRIo32 #define PRIoFAST32	PRIo32    #define PRIo64		"llo"  #define PRIoLEAST64	PRIo64 #define PRIoFAST64	PRIo64    #define PRIoMAX		"llo"   #define PRIoPTR		"o"     #define PRIu8		"hu"  #define PRIuLEAST8	PRIu8 #define PRIuFAST8	PRIu8    #define PRIu16		"hu" #define PRIuLEAST16	PRIu16 #define PRIuFAST16	PRIu16    #define PRIu32		"u"  #define PRIuLEAST32	PRIu32 #define PRIuFAST32	PRIu32    #define PRIu64		"llu"  #define PRIuLEAST64	PRIu64 #define PRIuFAST64	PRIu64    #define PRIuMAX		"llu"   #define PRIuPTR		"u"   #define PRIx8		"hx"  #define PRIxLEAST8	PRIx8 #define PRIxFAST8	PRIx8    #define PRIx16		"hx" #define PRIxLEAST16	PRIx16 #define PRIxFAST16	PRIx16    #define PRIx32		"x"  #define PRIxLEAST32	PRIx32 #define PRIxFAST32	PRIx32    #define PRIx64		"llx"  #define PRIxLEAST64	PRIx64 #define PRIxFAST64	PRIx64    #define PRIxMAX		"llx"   #define PRIxPTR		"x"   #define PRIX8		"hX"  #define PRIXLEAST8	PRIX8 #define PRIXFAST8	PRIX8    #define PRIX16		"hX" #define PRIXLEAST16	PRIX16 #define PRIXFAST16	PRIX16    #define PRIX32		"X"  #define PRIXLEAST32	PRIX32 #define PRIXFAST32	PRIX32    #define PRIX64		"llX"  #define PRIXLEAST64	PRIX64 #define PRIXFAST64	PRIX64    #define PRIXMAX		"llX"   #define PRIXPTR		"X"  (  /* fscanf macros for signed integers */' /*-----------------------------------*/  #define SCNd8		"hd"  #define SCNdLEAST8	SCNd8 #define SCNdFAST8	SCNd8    #define SCNd16		"hd" #define SCNdLEAST16	SCNd16 #define SCNdFAST16	SCNd16    #define SCNd32		"d"  #define SCNdLEAST32	SCNd32 #define SCNdFAST32	SCNd32    #define SCNd64		"lld"  #define SCNdLEAST64	SCNd64 #define SCNdFAST64	SCNd64    #define SCNdMAX		"lld"   #define SCNdPTR		"d"   #define SCNi8		"hi"  #define SCNiLEAST8	SCNi8 #define SCNiFAST8	SCNi8    #define SCNi16		"hi" #define SCNiLEAST16	SCNi16 #define SCNiFAST16	SCNi16    #define SCNi32		"i"  #define SCNiLEAST32	SCNi32 #define SCNiFAST32	SCNi32    #define SCNi64		"lli"  #define SCNiLEAST64	SCNi64 #define SCNiFAST64	SCNi64    #define SCNiMAX		"lli"   #define SCNiPTR		"i"    *  /* fscanf macros for unsigned integers */) /*-------------------------------------*/  #define SCNo8		"ho"  #define SCNoLEAST8	SCNo8 #define SCNoFAST8	SCNo8    #define SCNo16		"ho" #define SCNoLEAST16	SCNo16 #define SCNoFAST16	SCNo16    #define SCNo32		"o"  #define SCNoLEAST32	SCNo32 #define SCNoFAST32	SCNo32    #define SCNo64		"llo"  #define SCNoLEAST64	SCNo64 #define SCNoFAST64	SCNo64    #define SCNoMAX		"llo"   #define SCNoPTR		"o"   #define SCNu8		"hu"  #define SCNuLEAST8	SCNu8 #define SCNuFAST8	SCNu8    #define SCNu16		"hu" #define SCNuLEAST16	SCNu16 #define SCNuFAST16	SCNu16    #define SCNu32		"u"  #define SCNuLEAST32	SCNu32 #define SCNuFAST32	SCNu32    #define SCNu64		"llu"  #define SCNuLEAST64	SCNu64 #define SCNuFAST64	SCNu64    #define SCNuMAX    #define SCNuPTR    #define SCNx8		"hx"  #define SCNxLEAST8	SCNx8 #define SCNxFAST8	SCNx8    #define SCNx16		"hx" #define SCNxLEAST16	SCNx16 #define SCNxFAST16	SCNx16    #define SCNx32		"x"  #define SCNxLEAST32	SCNx32 #define SCNxFAST32	SCNx32    #define SCNx64		"llx"  #define SCNxLEAST64	SCNx64 #define SCNxFAST64	SCNx64    #define SCNxMAX		"llx"   #define SCNxPTR		"x"  $  /* Limits of other integer types */# /*-------------------------------*/  #define PTRDIFF_MIN	INT32_MIN  #define PTRDIFF_MAX	INT32_MAX     #define SIG_ATOMIC_MIN	INT32_MIN  #define SIG_ATOMIC_MAX	INT32_MAX   #define WCHAR_MAX	UINT32_MAX #define WCHAR_MIN	0    #define WINT_MAX	INT32_MAX #define WINT_MIN	INT32_MIN  B  /* The restrict type modifier does not appear to be in GCC yet */ #define restrict  /  /* None of these functions are in DEC C RTL */  intmax_t	 strtoimax % 		       (const char * restrict nptr,  			char ** restrict endptr, 
 			int base);    uintmax_t	 strtoumax% 		       (const char * restrict nptr,  			char ** restrict endptr, 
 			int base);   - #if !defined(__WCHAR_T) && !defined(_WCHAR_T)  typedef unsigned int wchar_t;  #endif #define _WCHAR_T_  #define __WCHAR_T    intmax_t	 wcstrtoimax ( 		       (const wchar_t * restrict nptr, 			wchar_t ** restrict endptr,
 			int base);    uintmax_t	 wcstrtoumax( 		       (const wchar_t * restrict nptr, 			wchar_t ** restrict endptr,
 			int base);    #endif   #ifdef __cplusplus }  #endif   #endif /* _INTTYPES_H */