/* <limits.h>
 *
 *	LIMITS - Definitions of platform's max & min integral values.
 *
 * 28-Dec-1998	J. Malmberg	Updated to match ANSI Working Draft,
 *				1997-11-21, WG14/N794 J11/97-158
 */
#ifndef _LIMITS_H
#define _LIMITS_H

/* 8-bit bytes */
#define CHAR_BIT	(8)

#define SCHAR_MAX	(127)
#define SCHAR_MIN	(-128)
#define UCHAR_MAX	(255U)

/* for VAX/VMS, we've got signed chars by default */
#define CHAR_MAX	SCHAR_MAX
#define CHAR_MIN	SCHAR_MIN

/* ANSI Working Draft, 1997-11-21, WG14/N794 J11/97-158 */
/* The minimum number of bytes in a multibyte character, */
/* for any supported locale */
#if __CRTL_VER < 60200000
#define MB_LEN_MAX	(1)
#else
#define MB_LEN_MAX	(8)
#endif

/* sizeof short == 2 */
#define SHRT_MAX	(32767)
#define SHRT_MIN	(-32768)
#define USHRT_MAX	(65535U)

/* sizeof int == 4 */
#define INT_MAX		(2147483647)
#define INT_MIN		(-2147483647-1)
#define UINT_MAX	(4294967295U)

/* sizeof long == 4 */
#define LONG_MAX	(2147483647L)
#define LONG_MIN	(-2147483647L-1L)
#define ULONG_MAX	(4294967295UL)

/* ANSI Working Draft, 1997-11-21, WG14/N794 J11/97-158 */
#define LLONG_MIN	(-9223372036854775807LL-1LL)
#define LLONG_MAX	(+9223372036854775807LL)
#define ULLONG_MAX	(18446744073709551615ULL)

#endif	/*_LIMITS_H*/
