/* <math.h>
 *
 *	Run-time library math functions.
 *
 * 28-Dec-1998	J. Malmberg	Fixed some conflicts with EDOM/ERANGE
 */
#ifndef _MATH_H
#define _MATH_H
# ifdef __cplusplus
extern "C" {
# endif

#ifdef __GFLOAT__
# define HUGE_VAL (8.988465674311578540726371186585e+307)
#else
# define HUGE_VAL (1.70141183460469229e+38)
#endif

#ifndef M_PI
#define M_PI   3.14159265358979323846
#endif

/* these are also defined in <errno.h> */
#ifndef EDOM
#define EDOM	33	/* Argument too large */
#endif
#ifndef ERANGE
#define ERANGE	34	/* Result too large */
#endif

/* alternate representation of doubles requires different library routines */
#ifdef __GFLOAT__
# define acos	vaxc$gacos
# define asin	vaxc$gasin
# define atan	vaxc$gatan
# define atan2	vaxc$gatan2
# define ceil	vaxc$gceil
# define cos	vaxc$gcos
# define cosh	vaxc$gcosh
# define exp	vaxc$gexp
# define fabs	vaxc$gfabs
# define floor	vaxc$gfloor
# define fmod	vaxc$gfmod
# define frexp	vaxc$gfrexp
# define ldexp	vaxc$gldexp
# define log	vaxc$glog
# define log10	vaxc$glog10
# define modf	vaxc$gmodf
# define pow	vaxc$gpow
# define sin	vaxc$gsin
# define sinh	vaxc$gsinh
# define sqrt	vaxc$gsqrt
# define tan	vaxc$gtan
# define tanh	vaxc$gtanh

# define cabs	vaxc$gcabs
# define hypot	vaxc$ghypot
#endif	/*__GFLOAT__*/

/* these are routines in VAXCRTL listed by K&R2's ANSI <math.h> description */
double	acos(double);
double	asin(double);
double	atan(double);
double	atan2(double,double);
double	ceil(double);
double	cos(double);
double	cosh(double);
double	exp(double);
double	fabs(double);
double	floor(double);
double	fmod(double,double);
double	frexp(double,int *);
double	ldexp(double,int);
double	log(double);
double	log10(double);
double	modf(double,double *);
double	pow(double,double);
double	sin(double);
double	sinh(double);
double	sqrt(double);
double	tan(double);
double	tanh(double);

/* these two are in VAX C's <math.h> (and VAXCRTL) */
#ifndef _CABS_T
#define _CABS_T
typedef struct CABS_T { double real, imag; } cabs_t;
#endif	/*_CABS_T*/
double	cabs(cabs_t);			/* sqrt(.real*.real + .imag*.imag) */
double	hypot(double,double);		/* sqrt(d1*d1 + d2*d2) */

# ifdef __cplusplus
}
# endif
#endif	/*_MATH_H*/
