/* <stdlib.h>
 *
 *	ANSI-C Standard Library definitions
 */
/*
 * 20-Dec-1998	J. Malmberg	Added brk(), rand48, multibyte functions
 *		    *		X/OPEN update.
 *
 *	Some of these routines are not present in DEC C RTL or VAX C RTL.
 *	The prototypes are here to assist in porting programs.  Look in the
 *	GNU LIBERTY library for some.
 */
#ifndef _STDLIB_H
#define _STDLIB_H
# ifdef __cplusplus
extern "C" {
# endif
			/* note: no !defined(__STDC__) handling, deliberately */

#ifndef _STDDEF_H
#include <stddef.h>	/* get size_t, NULL */
#endif

/*
   These exit macro values work with either exit() or return from main(),
   and avoid unnecessary warnings from the DCL command intrepretor.  They
   don't match VAX C's <stdlib.h>, which has 0 and 2 respectively.  Using 0
   for success works with VAXCRTL's exit() but requires additional compiler
   support in main() (which VAX C neglects to provide).  2 always provokes
   "%NONAME-E-NOMSG, Message number 00000002"; similarly for unfixed 0.
 */
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS (1)		/* SS$_NORMAL, STS$K_SUCCESS */
#endif
#ifndef EXIT_FAILURE
#define EXIT_FAILURE (0x10000002)	/* (STS$K_ERROR | STS$M_INHIB_MSG) */
#endif

#define RAND_MAX (2147483647)	/* 0x7FFFFFFF */

 /* MB_CUR_MAX depends on what DEC C RTL version is in use.  6.2 is changed */

#ifdef __CRTL_VER
#if __CRTL_VER < 60200000
#define MB_CUR_MAX (1)
#else
    extern int decc$$gl___mb_cur_max;
#define MB_CUR_MAX (decc$$gl___mb_cur_max);
#endif
#else
#define MB_CUR_MAX (1)
#endif


#ifdef GCC_QSORT
/*
   N.B.:  as of V5.5, VAXCRTL's qsort() is still buggy!
   Do not use it to sort something whose size is not a multiple of 4
   after having previously sorted something that is a multiple of 4.
   Othewise, it will sort incorrectly and can also corrupt the data.

   Link with GNU_CC:[000000]GNULIB.OLB/LIB _in front of_ VAXCRTL.OLB so that
   the reliable version in there will be used.	However, if you link with
   VAXCRTL.EXE, you're out of luck; the linker will take that one instead of
   the object library one regardless of the order they're presented to it.

   Defining GCC_QSORT will force use of the working routine regardless of
   how the program gets linked.

   J. E. Malmberg.  Two other options, The DEC C RTL can be linked in
   with the AACRTL060 kit or the "backport" library for older VMS systems.
   At this time I have not tested either of these alternatives, so YMMV.
 */
#define qsort	gcc_qsort
#endif	/*GCC_QSORT*/


/* math related routines */
#ifndef _DIV_T
#define _DIV_T
typedef struct DIV_T { int quot, rem; } div_t;
#endif
#ifndef _LDIV_T
#define _LDIV_T
typedef struct LDIV_T { long quot, rem; } ldiv_t;
#endif

/* check for alternate representation of doubles */
#ifdef __GFLOAT__
# define atof	vaxc$gatof
# define strtod vaxc$gstrtod
#endif

long	 a64l(const char *);	/* Not documented in DEC C RTL */
void	 abort(void);	/* note: deliberately executes illegel instruction */
int	 abs(int);
int 	 atexit(void (*)(void));
double	 atof(const char *);
int	 atoi(const char *);
long	 atol(const char *);
#if 0
void	*brk(void * __addr);	/* DECC RTL defines it here !X/OPEN */
#else
int	brk(void * __addr);	/* Match malloc and unistd */
#endif
void	*bsearch
	       (const void *,
		const void *,
		size_t,
		size_t,
		int (*)(const void *, const void *));
div_t	 div(int,int);
double	 drand48(void);
char	*ecvt(double, int, int *, int *);
double	 erand48(unsigned short __xsubi[3]);
void	 exit(int);
void	_exit(int);
char	*gcvt(double, int, char *);
char	*getenv(const char *);	/* also declared in VAX C's <unixlib.h> */

int	 getsubopt		/* Not documented in DEC C RTL */
	       (char **, char * const *, char **);

int	 grantpt(int);		/* Not documented in DEC C RTL */

char	*initstate(unsigned __seed, char * __state, int __size);
long	 jrand48(unsigned short __xsubi[3]);

char	*l64a(long);		/* Not documented in DEC C RTL */
long	 labs(long);
void	 lcong48(unsigned short __param[7]);
ldiv_t	 ldiv(long,long);
long	 lrand48(void);
int	 mblen(const char * __s, size_t __n);
size_t	 mbstowcs(wchar_t * __pwcs, const char * __s, size_t __n);
int	 mbtowc(wchar_t * __pwd, const char * __s, size_t __n);
char	*mktemp(char *);
int	 mkstemp(char * __template);
long	 mrand48(void);
long	 nrand48(unsigned short __xsubi[3]);

char	*ptsname(int);		/* Not documented in DEC C RTL */

int	 putenv(const char * string);

void	 qsort(void *, size_t, size_t, int (*)(const void *, const void *));

int	 rand(void);
int	*rand_r(unsigned *);		/* Not documented in DEC C RTL */
long	 random(void);

char	*realpath(const char *, char *);	    /* Not documented in DEC C RTL */

unsigned short * seed48(unsigned short __seed16v[3]);

		/* setenv is not here according to X/OPEN */
int setenv(const char * __name, const char * __value, int __overwrite);

void	 setkey(const char *);		/* Not documented in DEC C RTL */
char	*setstate(const char *);
int	 srand(int);		/* routine to initialize rand() */
void	 srand48(long  __seedval);
int	 srandom(unsigned __seed);

double	 strtod(const char *, char **);
long	 strtol(const char *, char **,int);
unsigned long strtoul(const char *, char **,int);

int	 system(const char *);	/* also declared in VAX C's <processes.h> */

int	 ttyslot(void);		/* Legacy, Not documented in DEC C RTL */

int	 unlockpt(void);		/* Not documented in DEC C RTL */

		/* unsetenv is not here according to X/OPEN */
void	 unsetenv(const char * __name);

size_t	 wcstombs(char * __s, const wchar_t * __pwcs, size_t __n);

int	 wctomb(char * __s, const wchar_t * __wchar);


/* memory manipulation routines; note: cfree() is gone; see also <malloc.h> */
void	*malloc(size_t);
void	*calloc(size_t, size_t);
void	*realloc(void *, size_t);
void	 free(void *);



# ifdef __cplusplus
}
# endif
#endif	/*_STDLIB_H*/
