/* File: sys/resource.h
**
** Definitions for XSI resource operations
**
** 22-Dec-1998	J. Malmberg	Values guessed from LINUX.
**				The DEC C RTL only uses struct rusage
**
** 28-Dec-1998	J. Malmberg	Updated for X/OPEN
***************************************************************************/

#ifndef _SYS_RESOURCE_H
#define _SYS_RESOURCE_H

#include <sys/time.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _ID_T
#define _ID_T
    typedef unsigned int id_t;		/* Process ID type */
#endif

#ifndef _RLIM_T
#define _RLIM_T
    typedef unsigned long rlim_t;	/* Unsigned integral type used for */
					/* limit values	*/
#endif

#define PRIO_PROCESS	(0)	/* Identifies who argument as a process ID */
#define PRIO_PGRP	(1)	/* Identifies who argument as a process */
				/*  group ID */
#define PRIO_USER	(2)	/* Identifies who argument as a user ID */

#define RLIM_INFINITY	(0x7FFFFFFF)	/* A value of rlim_t indicating */
					/*  no limit */
#define RLIM_SAVED_MAX	RLIM_INFINITY	/* unrepresentable saved hard limit */
#define RLIM_SAVED_CUR	RLIM_INFINITY	/* unrepresentable saved soft limit */

#define RUSAGE_SELF	 (0)	/* Returns information about the current */
				/*   process */
#define RUSAGE_CHILDREN (-1)	/* Returns information about children of */
				/*   the current process */

struct rlimit {
    rlim_t	rlim_cur;	/* user time used */
    rlim_t	rlim_max;	/* system time used */
};

struct rusage {
    struct timeval ru_utime;	/* user time used */
    struct timeval ru_stime;	/* system time used */
    };

#define RLIMIT_CORE	(4)	/* Limit on size of Core Dump File */
#define RLIMIT_CPU	(0)	/* Limit on CPU time per process */
#define RLIMIT_DATA	(2)	/* Limit on data segment size */
#define RLIMIT_FSIZE	(1)	/* Limit on file size */
#define RLIMIT_NOFILE	(8)	/* Limit on number of open files */
#define RLIMIT_STACK	(3)	/* Limit on stack size */
#define RLIMIT_AS	(5)	/* Limit on address space size (not in LINUX) */

int	 getpriority(int, id_t);
int	 getrlimit(int, struct rlimit *);
int	 getrusage(int, struct rusage *);
int	 setpriority(int, id_t, int);
int	 setrlimit(int, const struct rlimit *);

#ifdef __cplusplus
}
#endif

#endif /* _SYS_RESOURCE_H */
