 /* File: sys/socket.h  **" ** X/Open Internet Protocol Family **" ** Found in the LINUX Distribution **- ** 16-Jun-1998	J. Malmberg	GNUC - VMS version E ** 28-Dec-1998	J. Malmberg	Added routines from DEC C RTL and fixed to  **				match X/OPEN **M ****************************************************************************/    #ifndef _SYS_SOCKET_H  #define _SYS_SOCKET_H    #ifndef _SOCKET_H  #define _SOCKET_H  #endif  !  /* Linux has this, not X/OPEN */   /*----------------------------*/8 #include <sys/sockios.h>		/* the SIOCxxx I/O controls	*/   #ifdef __cplusplus     extern "C" { #endif  A #if !defined(_SIZE_T) && !defined(_SIZE_T_) && !defined(__SIZE_T)  typedef unsigned int size_t;) #endif				/* Used for sizes of objects */  #ifndef _SIZE_T  #define _SIZE_T  #endif #ifndef _SIZE_T_ #define _SIZE_T_ #endif #ifndef __SIZE_T #define __SIZE_T 1 #endif   #ifndef _SSIZE_T #define _SSIZE_T6 typedef int ssize_t;		/* Used for count of bytes or	*/ 				/* an error indicatation	*/  #endif     #ifndef _SOCKLEN_T #define _SOCKLEN_T$     typedef unsigned long socklen_t; #endif   #ifndef __SA_FAMILY_T  #define __SA_FAMILY_T 1 #ifdef _SOCKADDR_LEN	/* BSD 4.4 Socket package */ &     typedef unsigned char sa_family_t; #else '     typedef unsigned short sa_family_t;  #endif #endif   struct sockaddr {  #ifdef _SOCKADDR_LEN-     unsigned char	sa_len;		/* total length */  #endif8     sa_family_t		sa_family;	/* address family, AF_xxx	*/9     char		sa_data[14];	/* 14 bytes of protocol address	*/      };   /* XOPEN_SOURCE_EXTENDED */  struct msghdr { ,     void	 *msg_name;		/* optional address */3     socklen_t	  msg_namelen;		/* size of address */ 6     struct iovec *msg_iov;		/* scatter/gather array */0     int		  msg_iovlen;		/* members in msg_iov */.     void	 *msg_control;		/* ancilliary data */@     socklen_t	  msg_controllen;	/* ancilliary data buffer len */6     int		  msg_flags;		/* flags on received message */ };      /* Match the UCX manual */  /*----------------------*/" #define msg_accrights		msg_control' #define msg_accrightslen	msg_controllen    struct cmsghdr {E     socklen_t	 cmsg_len;	/* data byte count, including the cmsghdr */ 0     int		 cmsg_level;	/* originating protocol */1     int		 cmsg_type;	/* protocol-specific type */  };  C #define SCM_RIGHTS	(1)	/* Indicates that the data array contains */ 4 				/*   the access rights to be sent or received */  L   /* If __cmsg is a pointer to a cmsghdr structure, this macro returns an */8  /*  unsigned character pointer to the data array.			 */J /*----------------------------------------------------------------------*/; #define CMSG_DATA(__cmsg) ((unsigned char *)((__cmsg) + 1))   L       /* If __mhdr is a pointer to a msghdr structure and __cmsg is a	    */M      /*  pointer to a cmsghdr structure in the ancilliary data, pointed to */ J     /*	 by the msg_control field of that msghdr structure, this macro	  */E    /*	 returns a pointer to the next cmsghdr structure, or a null	 */ G   /*	 pointer if this structure is the last msghdr in the ancilliary */   /*	 data.							       */H /*--------------------------------------------------------------------*/% #define CMSG_NXTHDR(__mhdr, __cmsg) \ H 	((((caddr_t)(__cmsg)) + (__cmsg)->cmsg_len + sizeof(struct cmsghdr) > \E 	  ((caddr_t)((__mhdr)->msg_control)) + (__mhdr)->msg_controllen) ? \  	   (struct cmsghdr *) 0 : \B 	   (struct cmsghdr *) ((caddr_t)(__cmsg)) + (__cmsg)->cmsg_len)))  D       /* If __mhdr is a pointer to a msghdr structure, this macro	*/I      /*	 returns a pointer to the first cmsghdr structure in the       */ H     /*   ancilliary data associated with this msghdr structure, or a  */E    /*	 null pointer if there is no ancilliary data associated with */ %   /*	 the msghdr stucture.					    */ E  /*----------------------------------------------------------------*/ G #define CMSG_FIRSTHDR(__mhdr)	((struct cmsghdr *)(__mhdr)->msg_control)      struct linger { &   int 			l_onoff;	/* Linger active		*/.   int			l_linger;	/* How long to linger for	*/ };   /* Socket types. */ 9 #define SOCK_STREAM	(1)		/* stream (connection) socket	*/ 9 #define SOCK_DGRAM	(2)		/* datagram (conn.less) socket	*/ ( #define SOCK_RAW	(3)		/* raw socket			*/6 #define SOCK_RDM	(4)		/* reliably-delivered message	*/: #define SOCK_SEQPACKET	(5)		/* sequential packet socket	*/  ! /* Supported address families. */ ' #define AF_UNSPEC	(0)	/* Unspecified */ . #define AF_UNIX		(1)	/* UN*X domain sockets */2 #define AF_INET		(2)	/* Internet domain sockets */ /* Not right for SVr4 */ #if 0 4 #define AF_AX25		3		/* Amateur Radio Packet Stuff */ #define AF_IPX		4  #endif  > #define SHUT_RD		(0)	/* Disables further receive operations */; #define SHUT_RW		(1)	/* Disables further send operations */ D #define SHUT_RDRW	(2)	/* Disables further send and rcv operations */  2 /* Protocol families, same as address families. */ #define PF_UNIX		AF_UNIX #define PF_INET		AF_INET #if 0  #define PF_AX25		AF_AX25 #define PF_IPX		AF_IPX #endif  + /* Flags we can use with send/ and recv. */ / #define MSG_MAXIOVLEN	(16)		/* Not in X/OPEN */   , #define MSG_OOB		(1)		/* Out-of-band data */8 #define MSG_PEEK	(2)		/* Leave received data in queue */A #define MSG_DONTROUT	(4)		/* Send without using routing tables */ 3 #define MSG_EOR		(8)		/* Terminates a record (if */ & 					/*   supported by the protocol */  5 #define MSG_TRUNC	(0x10)		/* Normal data truncated */ 7 #define MSG_CTRUNC	(0x20)		/* Control data truncated */ ; #define MSG_WAITALL	(0x40)		/* Wait for complete message */    	/* Not in X/Open */@ #define MSG_DONTWAIT	(0x80)		/* message should be nonblocking */   /*Setsockoptions(2) level. */  #define SOL_SOCKET	(0xffff)    #if 0  #define SOL_IP		2  #define SOL_IPX		3 #define SOL_AX25	4 #define SOL_TCP		5 #endif   /* For setsockoptions(2) */ 0 #define SO_DEBUG	(0x01)		/* Turn on Debugging */C #define SO_ACCEPTCONN	(0x02)		/* Socket is accepting connections */ 6 #define SO_REUSEADDR	(0x04)		/* Reuse local address */9 #define SO_KEEPALIVE	(0x08)		/* Keep connections alive */ 8 #define SO_DONTROUTE	(0x10)		/* bypass normal routing */3 #define SO_BROADCAST	(0x20)		/* permit broadcast */ 7 #define SO_LINGER	(0x80)		/* Socket lingers on close */ C #define SO_OOBINLINE	(0x100)		/* Out-of-band data is transmitted */  					/*  in line */   1 #define SO_SNDBUF	(0x1001)	/* Send buffer size */ 4 #define SO_RCVBUF	(0x1002)	/* receive buffer size */8 #define SO_SNDLOWAT	(0x1003)	/* send "low water mark" */; #define SO_RCVLOWAT	(0x1004)	/* receive "low water mark" */ / #define SO_SNDTIMEO	(0x1005)	/* send timeout */ 2 #define SO_RCVTIMEO	(0x1006)	/* receive timeout */3 #define SO_ERROR	(0x1007)	/* Socket error status */ + #define SO_TYPE		(0x1008)	/* Socket type */    /* IP options */ #if 0  #define IP_TOS		1  #define	IPTOS_LOWDELAY		0x10 #define	IPTOS_THROUGHPUT	0x08  #define	IPTOS_RELIABILITY	0x04 #define IP_TTL		2    /* IPX options */  #define IPX_TYPE	1   /* AX.25 options*/ #define AX25_WINDOW	1    /* TCP options */  #define TCP_MSS		1 #define TCP_NODELAY	2    /* The various priorities. */  #define SOPRI_INTERACTIVE	0  #define SOPRI_NORMAL		1  #define SOPRI_BACKGROUND	2 #endif    ; /* Create a new socket of type TYPE in domain DOMAIN, using    protocol PROTOCOL.4   If PROTOCOL is zero, one is chosen  automatically.  /   Returns a file descriptor for the new socket,     or -1 for errors. */  6 int socket (int __family, int __type, int __protocol);    B /* Create two new sockets, of type TYPE in domain DOMAIN and usingE    protocol PROTOCOL, which are connected to each other, and put file C    descriptors for them in FDS[0] and FDS[1].  If PROTOCOL is zero, >    one will be chosen automatically.  Returns 0 on success, -1    for errors. */  9 int socketpair (int __family, int __type, int __protocol,  		int __sockvec[2]);    J /* Give the socket FD the local address ADDR (which is LEN bytes long). */  I int bind (int __sockfd, struct sockaddr *__my_addr, socklen_t __addrlen);     B /* Open a connection on socket FD to peer at ADDR (which LEN bytes?    long). For connectionless socket types, just set the default ?    address to send to and the only address from which to accept 6    transmissions.  Return 0 on success, -1 for errors. */  8 int connect (int __sockfd, struct sockaddr *__serv_addr, 	     socklen_t __addrlen);     . /* Prepare to accept connections on socket FD.C    N connection requests will be queued before further requests are 0    refused. Returns 0 on success, -1 for errors. */  # int listen (int __sockfd, int __n);     # /* Await a connection on socket FD. G    When a connection arrives, open a new socket to communicate with it, B    set *ADDR (which is *ADDR_LEN bytes long) to the address of theD    connecting peer and *ADDR_LEN to the address's actual length, and8    return the new socket's descriptor, or -1 for errors. */  J int accept (int __sockfd, struct sockaddr *__peer, socklen_t *__paddrlen);  C /* Put the current value for socket FD's option OPTNAME at protocol A    level LEVEL into OPTVAL (which is *OPTLEN bytes long), and set E    *OPTLEN to the value's actual length. Returns 0 on success, -1 for 
    errors. */  4 int getsockopt (int __s, int __level, int __optname,' 		void *__optval, socklen_t *__optlen);   9 /* Set socket FD's option OPTNAME at protocol level LEVEL +    to *OPTVAL (which is OPTLEN bytes long). '    Returns 0 on success, -1 for errors.  */  4 int setsockopt (int __s, int __level, int __optname,, 		__const void *__optval, socklen_t optlen);    E /* Put the local address of FD into *ADDR and its length in *LEN.  */   O int getsockname (int __sockfd, struct sockaddr *__addr, socklen_t *__paddrlen);     @ /* Put the address of the peer connected to socket FD into *ADDR?    (which is *LEN bytes long), and its actual length into *LEN.  */  O int getpeername (int __sockfd, struct sockaddr *__peer, socklen_t *__paddrlen);     F /* Send N bytes of BUF to socket FD. Returns the number sent or -1. */  M ssize_t send (int __sockfd, __const void *__buff, size_t __len, int __flags);     ( /* Read N bytes into BUF from socket FD.,    Returns the number read or -1 for errors. */  D ssize_t recv(int __sockfd, void *__buff, size_t __len, int __flags);    E /* Send N bytes of BUF on socket FD to peer at address ADDR (which is D    ADDR_LEN bytes long).  Returns the number sent, or -1 for errors. */  A ssize_t sendto (int __sockfd, __const void *__buff, size_t __len, D 	    int __flags, __const struct sockaddr *__to, socklen_t __tolen);    + /* Read N bytes into BUF through socket FD. F    If ADDR is not NULL, fill in *ADDR_LEN bytes of it with tha address=    of the sender, and store the actual size of the address in @    *ADDR_LEN. Returns the number of bytes read or -1 for errors. */   ssize_t recvfrom        (int __sockfd,  	void *__buff, 	size_t __len,
 	int __flags,  	struct sockaddr *__from,  	socklen_t *__fromlen);     = /* Shut down all or part of the connection open on socket FD. $    HOW determines what to shut down:3 	0 = No more receptions;	1 = No more transmissions; ) 	2 = No more receptions or transmissions. '    Returns 0 on success, -1 for errors.  */  ' int shutdown (int __sockfd, int __how);       /* belongs here or elsewhere? */  2 int rcmd (char **__ahost, unsigned short __inport,4 	  __const char *__locuser, __const char *__remuser,% 	  __const char *__cmd, int *__fd2p);    int rresvport (int *__port);  4 int ruserok (__const char *__rhost, int __superuser,4 	     __const char *__ruser, __const char *__luser);  > int rexec (char **__ahost, int __inport, __const char *__user,0 	   __const char *__passwd, __const char *__cmd, 	   int *__fd2p);     short int decc$get_sdc(int __s);  short int vaxc$get_sdc(int __s);   int gethostaddr(char *__addr);  , int gethostname(char * __name, int namelen);    = ssize_t recvmsg(int __s, struct msghdr * __msg, int __flags);     C ssize_t sendmsg(int __sd, const struct msghdr *__msg, int __flags);    int socket_fd(int __channel);    #ifdef __cplusplus     }  #endif   #endif /*_SOCKET_H */ 