/* <unistd.h>
 *
 *	This is mostly just a placeholder, without the POSIX stuff.
 *
 *  28-Jun-1998	J. Malmberg	Make the definiton of NULL consistent with
 *				the other headers. so it does not matter
 *				what order the headers are called in.
 *
 * 22-Dec-1998	J. Malmberg	Added additional routines from DECC RTL
 *
 * 28-Dec-1998	J. Malmberg	Adjusted to match X/OPEN
 */
#ifndef _UNISTD_H
#define _UNISTD_H

#include <sys/types.h>
#include <inttypes.h>
#include <unixlib.h>	/* Not an X/OPEN header */
#include <unixio.h>	/* Not an X/OPEN header */


 /* X/OPEN version test macros (Best match for the DECC BACKPORT library) */
/*----------------------------*/
#define _POSIX_VERSION_			199506L	/* IEEE Std 1003.1c-1995 */
#define _POSIX2_VERSION_		199209L /* POSIX.2 standard	 */
#define _POSIX2_C_VERSION_		199209L /* IEEE Std 1003.2-1992	 */

    /* X/OPEN says that _XOPEN_VERSION_ is currently 500 */
#define _XOPEN_VERSION_			(4)	/* XPG4			 */


#define _XOPEN_XCU_VERSION		(-1)

 /* The use of chown requires privilege */
/*-------------------------------------*/
#define _POSIX_CHOWN_RESTRICTED	(-1)

#ifndef _POSIX_THREADS
#define _POSIX_THREADS			/* 1003.4a (pthreads) conformant */
#endif

/* The Implementation supports the thread stack size attribute option */
#ifndef _POSIX_THREAD_ATTR_STACKSIZE
#define _POSIX_THREAD_ATTR_STACKSIZE
#endif

/* The Implementation supports the thread exececution scheduling option */
#define _POSIX_THREAD_PRIORITY_SCHEDULING

#ifndef NULL
#if !defined(__cplusplus) || defined(__GNUC__)
#define NULL ((void*)0)
#else
#define NULL (0)
#endif
#endif

#ifndef _USECONDS_T
#define _USECONDS_T
    typedef unsigned int useconds_t;
#endif

#ifdef __cplusplus
extern "C" {
#endif


#ifndef _CS_PATH
#define _CS_PATH (0)
#endif

#include <processes.h>

int		 access(const char *, int);	/* VAX C UNIXIO */

			/* ISO POSIX 1 now says alarm is unsigned */
unsigned int	 alarm(unsigned int);
int		 brk(void *);			/* VAX C UNIXLIB */
int		 chdir(const char *);		/* VAX C UNIXLIB */

int		 chroot(const char *);	/* Legacy, not in DEC C RTL */

int		 chown(const char *, unsigned, unsigned); /* VAX C UNIXLIB */
int		 close(int);			/* VAX C UNIXIO */

size_t		 confstr
		       (int __name,
			char * __buf,
			size_t __len);

char		*crypt(const char *, const char *); /* Not in DEC C RTL */

char		*ctermid(char *);		/* VAX C UNIXLIB */
char		*cuserid(char * s); /* Legacy */ /* VAX C UNIXLIB */

int		 dup(int);			/* VAX C UNIXIO */
int		 dup2(int, int);		/* VAX C UNIXIO */

void		 encrypt(char[64], int);		/* Not in DEC C RTL */

/* execl and execv functions in <process.h>	*/

void		_exit(int);			/* VAX C STDLIB */

int		 fchown(int, uid_t, gid_t);	/* Not in DEC C RTL */
int		 fchdir(int);			/* Not in DEC C RTL */
int		 fdatasync(int);		/* Not in DEC C RTL */
pid_t		 fork(void);			/* Not in DEC C RTL */

long		 fpathconf(int __filedes, int __name);

int		 fsync(int __fd);		/* DEC C UNIXIO */
int		 ftruncate(int __filedesc, off_t __length);

char		*getcwd(char *, size_t, ...);	/* VAX C UNIXLIB */
int		 getdtablesize(void);   /* LEGACY */

gid_t		 getegid(void);			/* VAX C UNIXLIB */
uid_t		 geteuid(void);			/* VAX C UNIXLIB */
gid_t		 getgid(void);			/* VAX C UNIXLIB */

int		 getgroups(int, gid_t[]);	/* Not in DEC C RTL */
long		 gethostid(void);		/* Not in DEC C RTL */

char		*getlogin(void);

int		 getlogin_r(char *, size_t);	/* Not in DEC C RTL */
int		 getopt(int, char * const [], const char *); /* VAX C STDIO */

int		 getpagesize(void);	/* Legacy */

char		*getpass(const char *); /* Legacy, Not in DEC C RTL */
pid_t		 getpgid(pid_t);		/* Not in DEC C RTL */
pid_t		 getpgrp(void);			/* Not in DEC C RTL */

pid_t		 getpid(void);			/* VAX C UNIXLIB */
pid_t		 getppid(void);			/* VAX C UNIXLIB */

pid_t		 getsid(void);			/* Not in DEC C RTL */

uid_t		 getuid(void);			/* VAX C UNIXLIB */

char		*getwd(char *);			/* Not in DEC C RTL */
int		 isatty(int);			/* VAX C UNIXIO */

int		 lchown(const char *);		/* Not in DEC C RTL */
int		 link(const char *, const char *); /* Not in DEC C RTL */
int		 lockf(int, int, off_t);	/* Not in DEC C RTL */

off_t		 lseek(int, off_t, int);	/* VAX C UNIXIO */

int		 nice(int);			/* VAX C processes.h */

long		 pathconf(const char __path, int __name);

int		 pause(void);			/* VAX C signal.h */
int		 pipe(int[2], ...);		/* VAX C processes.h */

ssize_t		 pread				/* Not in DEC C RTL */
		       (int,
			void *,
			size_t,
			off_t);
int		 pthread_atfork			/* Not in DEC C RTL */
		       (void (*)(void),
			void (*)(void),
			void (*)(void));
ssize_t		 pwrite				/* Not in DEC C RTL */
		       (int,
			const void *,
			size_t,
			off_t);

ssize_t		 read(int, void *, size_t);

int		 readlink			/* Not in DEC C RTL */
		       (const char *,
			char *,
			size_t);

int		 rmdir(const char * __path);

void		*sbrk(intptr_t);		/* VAX C UNIXLIB */
int		 setgid(gid_t);			/* VAX C UNIXLIB */

int		 setpgid(pid_t, pid_t);		/* Not in DEC C RTL */
pid_t		 setpgrp(void);			/* Not in DEC C RTL */
int		 setregid(gid_t, gid_t);	/* Not in DEC C RTL */
int		 setreuid(uid_t, uid_t);	/* Not in DEC C RTL */
pid_t		 setsid(void);			/* Not in DEC C RTL */

int		 setuid(uid_t);			/* VAC C UNIXLIB */

unsigned int	 sleep(unsigned int);		/* VAX C SIGNAL */

void		 swab
		    (const void * __src,
		     void * __dst,
		     ssize_t __nbytes);

void		 sync(void);			/* Not in DEC C RTL */

long		 sysconf(int __name);

pid_t		 tcgetpgrp(int);		/* Not in DEC C RTL */
int		 tcsetpgrp(int, pid_t);		/* Not in DEC C RTL */

int		 truncate(const char __path, off_t);

char		*ttyname(int);			/* VAX C UNIXIO */

int		 ttyname_r			/* Not in DEC C RTL */
		       (int,
			char *,
			size_t);

useconds_t	 ualarm
		       (useconds_t __mseconds,
			useconds_t __interval);

int		 unlink(const char *);

int		 usleep(unsigned __mseconds);

int		 vfork(void);			/* VAX C PROCESSES */

ssize_t		 write				/* VAX C UNIXIO */
		       (int,
			const void *,
			size_t);

 /* External variables for getopt */
/*-------------------------------*/
extern char *optarg;
extern int   optind;
extern int   opterr;
extern int   optopt;


 /* ISO POSIX-1 */
/*-------------*/
#define _SC_ARG_MAX (100)
#define _SC_CHILD_MAX (101)
#define _SC_CLK_TCK (102)
#define _SC_NGROUPS_MAX (103)
#define _SC_OPEN_MAX (104)
#define _SC_STREAM_MAX (105)
#define _SC_TZNAME_MAX (106)
#define _SC_JOB_CONTROL (107)
#define _SC_SAVED_IDS (108)
#define _SC_VERSION (109)

 /* ISO POSIX-2 */
/*-------------*/
#define _SC_BC_BASE_MAX (121)
#define _SC_BC_DIM_MAX (122)
#define _SC_BC_SCALE_MAX (123)
#define _SC_BC_STRING_MAX (124)
#define _SC_COLL_WEIGHTS_MAX (125)
#define _SC_EXPR_NEST_MAX (126)
#define _SC_LINE_MAX (127)
#define _SC_RE_DUP_MAX (128)
#define _SC_2_CHAR_TERM (137)
#define _SC_2_C_BIND (130)
#define _SC_2_C_DEV (131)
#define _SC_2_VERSION (129)
#define _SC_2_C_VERSION _SC_2_VERSION
#define _SC_2_FORT_DEV (132)
#define _SC_2_FORT_RUN (134)
#define _SC_2_LOCALDEF (135)
#define _SC_2_SW_DEV (133)
#define _SC_2_UPE (136)

 /* POSIX 1003.1c-1995 */
/*--------------------*/
#define _SC_THREADS (145)
#define _SC_THREADS_ATTR_STACKSIZE (146)
#define _SC_THREAD_PRIORITY_SCHEDULING (147)
#define _SC_THREAD_SAFE_FUNCTIONS (144)
#define _SC_THREAD_DESTRUCTOR_ITERATIONS (140)
#define _SC_THREAD_KEYS_MAX (141)
#define _SC_THREAD_STACK_MIN (142)
#define _SC_THREAD_THREADS_MAX (143)

 /* X/OPEN */
/*--------*/
#define _SC_XOPEN_VERSION (110)
#define _SC_PASS_MAX (111)		/* LEGACY */
#define _SC_XOPEN_CRYPT (118)
#define _SC_XOPEN_ENH_I18N (119)
#define _SC_XOPEN_SHM (120)


 /* X/OPEN Extended */
/*-----------------*/
#define _SC_ATEXIT_MAX (138)
#define _SC_PAGESIZE (117)
#define _SC_PAGE_SIZE SC_PAGESIZE
#define _SC_IOV_MAX (139)
#define _SC_XOPEN_UNIX (148)

 /* DEC C claims not yet implemented */
/*----------------------------------*/
#define _SC_DELAYTIMER_MAX (112)
#define _SC_FSYNC (115)
#define _SC_MAPPED_FILES (114)
#define _SC_TIMERS (116)
#define _SC_TIMER_MAX (113)


 /* X/OPEN Unknown */
/*----------------*/
/*	_SC_AIO_LISTIO_MAX	??	*/
/*	_SC_AIO_MAX		??	*/
/*	_SC_AIO_PRIO-DELTA_MAX	??	*/
/*	_SC_ASYNCHRONOUS_IO	??	*/
/*	_SC_GETGR_R_SIZE_MAX	??	*/
/*	_SC_GETPW_R_SIZE_MAX	??	*/
/*	_SC_LOGIN_NAME_MAX	??	*/
/*	_SC_MEMLOCK		??	*/
/*	_SC_MEMLOCK_RANGE	??	*/
/*	_SC_MEMORY_PROTECTION	??	*/
/*	_SC_MESSAGE_PASSING	??	*/
/*	_SC_MQ_OPEN_MAX		??	*/
/*	_SC_MQ_PRIO_MAX		??	*/
/*	_SC_PRIORITIZED_IO	??	*/
/*	_SC_PRIORITY_SCHEDULING	??	*/
/*	_SC_REALTIME_SIGNALS	??	*/
/*	_SC_RTSIG_MAX		??	*/
/*	_SC_SEMAPHORE		??	*/
/*	_SC_SEM_NSEMS_MAX	??	*/
/*	_SC_SEM_VALUE_MAX	??	*/
/*	_SC_SHARED_MEMORY_OBJECTS ??	*/
/*	_SC_SIGQUEUE_MAX	??	*/
/*	_SC_SYNCHRONIZED_IO	??	*/
/*	_SC_THREAD_ATTR_STACKADDR ??	*/
/*	_SC_THREAD_PRIO_INHERIT ??	*/
/*	_SC_THREAD_PRIO_PROTECT ??	*/
/*	_SC_THREAD_PROCESS_SHARED ??	*/
/*	_SC_TTY_NAME_MAX	??	*/
/*	_SC_XOPEN_XCU_VERSION	??	*/
/*	_SC_XOPEN_LEGACY	??	*/
/*	_SC_XOPEN_REALTIME	??	*/
/*	_SC_XOPEN_REALTIME_THREADS ??	*/
/*	_SC_XBS5_ILP32_OFF32	??	*/
/*	_SC_XBS5_ILP32_OFFBIG	??	*/
/*	_SC_XBS5_IP64_OFF64	??	*/
/*	_SC_XBS5_LPBIG_OFFBIG	??	*/



#define _PC_CHOWN_RESTRICTED	 (0)
#define _PC_LINK_MAX		 (1)
#define _PC_MAX_CANON		 (2)
#define _PC_MAX_INPUT		 (3)
#define _PC_NAME_MAX		 (4)
#define _PC_NO_TRUNC		 (5)
#define _PC_PATH_MAX		 (6)
#define _PC_PIPE_BUF		 (7)
#define _PC_VDISABLE		 (8)
#define _PC_ASYNC_IO		 (9)
#define _PC_PRIO_IO		(10)
#define _PC_SYNC_IO		(11)

/*	_PC_FILESIZEBITS	?? */


#ifdef __cplusplus
}
#endif


#define STDIN_FILENO	(0)
#define STDOUT_FILENO	(1)
#define STDERR_FILENO	(2)

/* these are also in <stdio.h> */
#ifndef SEEK_SET
#define SEEK_SET (0)
#endif
#ifndef SEEK_CUR
#define SEEK_CUR (1)
#endif
#ifndef SEEK_END
#define SEEK_END (2)
#endif

/* these are also in <file.h> */
#define F_OK	(0)	/* test whether file exists */
#define X_OK	(1)	/* test execute access */
#define W_OK	(2)	/* test write access */
#define R_OK	(4)	/* test read access */

/*	F_LOCK	?	*/ /* Lock a section for exclusive use */
/*	F_ULOCK ?	*/ /* Unlock a locked section */
/*	F_TEST  ?	*/ /* Test section for locks by other processes */
/*	F_TLOCK ?	*/ /* Test and lock a section for exclusive use. */


#endif	/*_UNISTD_H*/
