/* <unixio.h>
 *
 *	Unix "section 2"-style I/O routines available in VAXCRTL.
 */
/*
** 17-Dec-1998	J. Malmberg	Added fsync() now in DECC RTL
*
*  28-Dec-1998	J. Malmberg	This header is not in X/OPEN.  <unistd.h>
*				should be used instead.
*/
#ifndef _UNIXIO_H
#define _UNIXIO_H
# ifdef __cplusplus
extern "C" {
# endif

/* Need size_t, mode_t, off_t, ... */
#include <sys/types.h>

#ifdef __STDC__

/* creat() and open() take optional string args specifying RMS file options */
int	 access(const char *, int);
#if !VMS
int	 delete(const char (*));		/* identical to remove() */
#endif
int	 close(int);
int	 creat(const char*, mode_t, ...);
int	 dup(int);
int	 dup2(int,int);
int	fsync(int __fd);
char	*getname(int,char *,...); /* optional 3rd arg is int: VMS(1) vs Unix(0) format */
int	 isapipe(int);			/* isapipe & isatty are not boolean */
int	 isatty(int);		/*  1 => yes, 0 => no, -1 => error  */
off_t	 lseek(int, off_t, int);
char	*mktemp(char *);
int	 open(const char *,int,...);	/* optional mode and misc strings */
int	 read(int,void *,unsigned);
int	 rename(const char *,const char *);
char	*ttyname(int);			/* argument ignored; 0 always used */
int	 write(int,const void *,unsigned);


#if 0	/* these are in VAX C's <unixio.h>, but belong in <stat.h> */
int	 fstat(int,stat_t *);
int	 stat(const char *,stat_t *);
#endif

#else	/*!__STDC__ => -traditional */

int	 creat(), open(), close(), read(), write();
int	 access(), delete(), rename(), dup(), dup2(), isapipe(), isatty();
char	*getname(), *mktemp(), *ttyname();
long	 lseek();
int	 fstat(), stat();

#endif	/*?__STDC__*/

# ifdef __cplusplus
}
# endif
#endif	/*_UNIXIO_H*/
