/* <unixlib.h>
 *
 *	Various Unix compatibility routines available in VAXCRTL.
 */
/* 04-Jul-1998	J. Malmberg	Fixed prototype of mkdir function
 *
 * 22-Dec-1998	J. Malmberg	Added DEC C RTL routines
 *
 * 28-Dec-1998	J. Malmberg	This header is not in X/OPEN, it is provided
 *				for compatability with existing programs.
 *
 *				The X/OPEN header to use is <unistd.h>
 */
#ifndef _UNIXLIB_H
#define _UNIXLIB_H
# ifdef __cplusplus
extern "C" {
# endif
	/*( limited substitute for VAX C V3.x's <unixlib.h> )*/

 /* special type definitions */
/*--------------------------*/
#include <inttypes.h>
#include <sys/types.h>

/* declare the global environ[] array */
#ifdef __GNUC__
extern char **environ	__asm("_$$PsectAttributes_NOSHR$$environ");
#else	/* assume VAXC */
extern char noshare **environ;
#endif

/* check for alternate representation of doubles */
#ifdef __GFLOAT__
# define ecvt	vaxc$ecvt
# define fcvt	vaxc$fcvt
# define gcvt	vaxc$gcvt
#endif

#ifdef __STDC__		/* these aren't standard, but use their prototypes */

/* miscellaneous emulation routines */
char	*getenv(const char *);

	/* optional arg is VMS vs shell name format */
char	*getcwd(char *, size_t, ...);

char	*ecvt(double,int,int *,int *);
char	*fcvt(double,int,int *,int *);
char	*gcvt(double,int,char *);

int	 getpid(void), getppid(void);

gid_t	 getgid(void);
uid_t	 getuid(void);
gid_t	 getegid(void);
uid_t	 geteuid(void);
int	 setgid(gid_t), setuid(uid_t);	/* no-ops */

/* note: none of the following are declared in any VAX C header file */
#if 0
void	* brk(void * __addr);			/* also in our <malloc.h> -*/
#else
int	brk(void * __addr);
#endif
#if 0
void	*sbrk(void *);		/*+  which is deprecated.  */
#else
void	*sbrk(intptr_t);			/* X/OPEN */
#endif
int	 chdir(const char *);
int	 chmod(const char *, mode_t);
int	 chown(const char *,unsigned, unsigned);
char	*ctermid(char *);
char	*cuserid(char *);
/* int	 mkdir(const char *,int,...); */
int mkdir (const char * __dirspec, mode_t __mode, ...);
int	 nice(int);			/* also in our <processes.h> */
mode_t	 umask(mode_t);
/* end of "missing" prototypes */

unsigned decc$fix_time(void * vms_time);
int decc$from_vms
       (const char vms_filespec,
	int (* action_rtn)(char * name),
	int wild_flag);
int decc$match_wild(char test_string, char string_pattern);
int decc$to_vms
       (const char __unixfile,
	int (* action_rtn)(char * __unixfile, int * file_type),
	int allow_wild,
	int no_directory);
char * decc$translate_vms(const char * vmsfile);

#else	/*!__STDC__ => -traditional */

char	*getenv(), *getcwd(), *ecvt(), *fcvt(), *gcvt();
int	 getpid(), getppid(), setgid(), setuid();
unsigned getgid(), getuid(), getegid(), geteuid();
char	*sbrk();
int	 brk(), chdir(), chmod(), chown();
char	*ctermid(), *cuserid();
int	 mkdir(), nice(), umask();

#endif	/*?__STDC__*/

# ifdef __cplusplus
}
# endif
#endif	/*_UNIXLIB_H*/
