-----------------------------------------------------------------------------
--                                                                         --
--                             P L O O K U P                               --
--                                                                         --
--                         P L I P S   S p e c s                           --
--                                                                         --
--                        $ReleaseVersion: -----  $                         --
--                                                                         --
--  Copyright (C) 1999   Mr G. A. Craig Carey, Auckland, New Zealand.      --
--                                                                         --
--   Plookup is free software; you can  redistribute  it  and/or  modify   --
--   it  under terms of the GNU  General  Public License as published by   --
--   the Free Software Foundation; either version 0, or (at your option)   --
--   any later version.   Plookup is distributed  in the  hope  that  it   --
--   will be useful, but WITHOUT ANY  WARRANTY; without even the implied   --
--   warranty of MERCHANTABILITY  or FITNESS FOR  A PARTICULAR PURPOSE.    --
--   See the GNU General Public  License  for more details.  You  should   --
--   have received a copy of the  GNU General Public License distributed   --
--   with Plookup; see   file COPYING.  If  not,  write  to  the Free      --
--   Software  Foundation, 59   Temple Place -   Suite  330,  Boston, MA   --
--   02111-1307, USA.                                                      --
--                                                                         --
--   As a special exception, if  other  files instantiate generics  from   --
--   this unit, or  you link this  unit with other  files to produce  an   --
--   executable,  this  unit does  not  by  itself cause  the  resulting   --
--   executable to be  covered by the  GNU General Public License.  This   --
--   exception does  not  however invalidate any  other reasons  why the   --
--   executable file might be covered by the GNU Public License.           --
--                                                                         --
--   The author of the software is Mr Craig Carey. The homepage of the     --
--   author is located at:                                                 --
--       http://home.clear.net.nz/pages/research/                          --
--   Dated 8 March 1999                                                    --
--                                                                         --
-----------------------------------------------------------------------------

   --  Program By Mr Craig Carey, Auckland city, research@clear.net.nz
   --   http://home.clear.net.nz/pages/research/

--  pragma Source_File_Name (UNIT_NAME => PlIPs, BODY_FILE_NAME => "plips.ads");

--  pragma Normalize_Scalars;   --  Set uninitialized scalar objects out of range

with Ada.Finalization;

with PlPre;         use PlPre;


package PlIPs is

   PH_LHS_comment : Ustr;

   package AF renames Ada.Finalization;

   type IP_Name_Convert_Direction_etype is (From_Name_to_IP, From_IP, None);

   type Measure_type is new Long_Integer;
   No_quality : Measure_type := 0;

   type NameIPs_rec is record
      id         : Ustr := PlPre.Null_Ustr;
      quality    : Measure_type := No_quality;
      failed_msg : Ustr := PlPre.Null_Ustr;
   end record;

   subtype NameIPs_Natural is Natural;
   subtype NameIPs_Positive is NameIPs_Natural range 1 .. NameIPs_Natural'Last;
   type NameIPs_array is array (NameIPs_Positive range <>) of NameIPs_rec;

   type NameIPs_array_access is access NameIPs_array;

   type NameIPs_AFtype is new AF.Controlled with record
      Reference : NameIPs_array_access := null;
   end record;


   function Clean_IP_Number (IPNum : Ustr) return Ustr;

   function Is_List_of_Numbers (
               Source, Divider : String;
               UB_Nums         : Long_Integer)
             return Boolean;

   function Is_IP_Address (Source : String) return Boolean;

   function Is_IP_Address (Source : Ustr) return Boolean;

   function is_No_Bad_Hostname_Chars (Source : Ustr) return Boolean;


   procedure IP_of_ID (
               Host                   : Ustr;
               Convert_Direction      : IP_Name_Convert_Direction_etype;
               pIDs                   : out NameIPs_AFtype;
               Find_Only_One_Hostname : Boolean;
               Was_Already_Converted_No_F_msg  : out Boolean);

   package PHSocket is   -- From J. v. Dyke's site, about Mar 1999

      WSAEINTR           : exception; --  The (blocking) call was canceled
      WSAEFAULT          : exception; --  A namelen parameter is too small
      WSAEINVAL          : exception; --  Socket version not supported by DLL
      WSANO_DATA         : exception; --  Valid name, no data record
      WSAENETDOWN        : exception; --  Network subsystem failed
      WSATRY_AGAIN       : exception; --  Non-Authoritative Host not found
      WSAEINPROGRESS     : exception; --  Blocking sockets operation active
      WSASYSNOTREADY     : exception; --  Network not ready for communication
      WSANO_RECOVERY     : exception; --  Unrecoverable FORMERR, REFUSED, NOTIMP
      WSANOTINITIALISED  : exception; --  Sockets are not initialized
      WSAHOST_NOT_FOUND  : exception; --  Authoritative Answer Host not found
      WSAVERNOTSUPPORTED : exception; --  Application socket version unsupported

      UNKNOWN_SOCKETS_ERROR : exception;  --  Catch all others exception

      procedure Start_Sockets;
      procedure Finishup_Sockets;

   end PHSocket;



private          --  Set up auto deallocation
   type IDs_access is access all NameIPs_array;

   procedure Initialize (Object : in out NameIPs_AFtype);
   procedure Adjust     (Object : in out NameIPs_AFtype);
   procedure Finalize   (Object : in out NameIPs_AFtype);

end PlIPs;

