-----------------------------------------------------------------------------
--                                                                         --
--                             P L O O K U P                               --
--                                                                         --
--                         P L P R E   S p e c s                           --
--                                                                         --
--                        $ReleaseVersion: -----  $                         --
--                                                                         --
--  Copyright (C) 1999   Mr G. A. Craig Carey, Auckland, New Zealand.      --
--                                                                         --
--   Plookup is free software; you can  redistribute  it  and/or  modify   --
--   it  under terms of the GNU  General  Public License as published by   --
--   the Free Software Foundation; either version 0, or (at your option)   --
--   any later version.   Plookup is distributed  in the  hope  that  it   --
--   will be useful, but WITHOUT ANY  WARRANTY; without even the implied   --
--   warranty of MERCHANTABILITY  or FITNESS FOR  A PARTICULAR PURPOSE.    --
--   See the GNU General Public  License  for more details.  You  should   --
--   have received a copy of the  GNU General Public License distributed   --
--   with Plookup; see   file COPYING.  If  not,  write  to  the Free      --
--   Software  Foundation, 59   Temple Place -   Suite  330,  Boston, MA   --
--   02111-1307, USA.                                                      --
--                                                                         --
--   As a special exception, if  other  files instantiate generics  from   --
--   this unit, or  you link this  unit with other  files to produce  an   --
--   executable,  this  unit does  not  by  itself cause  the  resulting   --
--   executable to be  covered by the  GNU General Public License.  This   --
--   exception does  not  however invalidate any  other reasons  why the   --
--   executable file might be covered by the GNU Public License.           --
--                                                                         --
--   The author of the software is Mr Craig Carey. The homepage of the     --
--   author is located at:                                                 --
--       http://home.clear.net.nz/pages/research/                          --
--   Dated 8 March 1999                                                    --
--                                                                         --
-----------------------------------------------------------------------------

   --  Program By Mr Craig Carey, Auckland city, research@clear.net.nz
   --   http://home.clear.net.nz/pages/research/

--  pragma Source_File_Name (UNIT_NAME => PlPre, BODY_FILE_NAME => "plpre.ads");

--  pragma Normalize_Scalars;   --  Set uninitialized scalar objects out of range


with Ada.Text_IO;
with Ada.Strings.Unbounded; --  no " unconstrained subtype not allowed (need initialization)" msg
with Ada.Strings.Fixed;
with Ada.Strings.Maps;
with Ada.Strings.Maps.Constants;
with Ada.Strings;  --  type 'Both' for SU.Trim
with Ada.Exceptions;


package PlPre is

   dbg           : Boolean;  --  debug

   --    Generic; if Move'Access then "subprogram must not be deeper than access type" error

   generic
      type Sort_Natural is range <>;
      with procedure Move (From, To : Sort_Natural);
      with function Lt (J1, J2 : Sort_Natural) return Boolean;
   package Sort is
      procedure Sort_Up (LB, UB : Sort_Natural);
   end Sort;

   package tio renames Ada.Text_IO;
   package SU renames Ada.Strings.Unbounded;   --  A.4.5
   package SF renames Ada.Strings.Fixed;       --  A.4.3
   package SM renames Ada.Strings.Maps;        --  A.4.2
   package SMC renames Ada.Strings.Maps.Constants; --  A.4.5

   subtype Ustr is SU.Unbounded_String;

   Null_Ustr : constant Ustr := SU.Null_Unbounded_String;

   --  Long_Int_UB : constant Long_Integer := (2**31)-1; --  (Long_Integer 3.5.4)
   --  subtype L_Integer is Long_Integer range -Long_Int_UB .. Long_Int_UB;
   subtype L_Integer is Long_Integer;
   subtype L_Natural is L_Integer range 0 .. L_Integer'Last;
   subtype L_Positive is L_Integer range 1 .. L_Integer'Last;

   WhiteSpace   : constant String := String'(
            1 => Character'Val (9),
            2 => Character'Val (10),
            3 => Character'Val (13),
            4 => Character'Val (160));

   WhiteSpace_mapping  : constant SM.Character_Mapping := SM.To_Mapping (
            From => WhiteSpace,
            To   => String'(1 .. WhiteSpace'Length => ' '));

   Lowercase_NoWhiteSpace_mapping  : constant SM.Character_Mapping := SM.To_Mapping (
            From => "ABCDEFGHIJKLMNOPQRSTUVWXYZ" & WhiteSpace,
            To   => "abcdefghijklmnopqrstuvwxyz" & String'(1 .. WhiteSpace'Length => ' '));

   function us (Source : String) return Ustr renames SU.To_Unbounded_String;
   function fs (Source : Ustr) return String renames SU.To_String;

   subtype Trim_End is Ada.Strings.Trim_End;    --   = (Left, Right, Both)

      --    type Trim_End    is (Left, Right, Both);
      --    type Membership is (Inside, Outside);
      --    type Direction  is (Forward, Backward);

   Left      : constant Trim_End := Ada.Strings.Left;
   Right     : constant Trim_End := Ada.Strings.Right;
   Both      : constant Trim_End := Ada.Strings.Both;
   Inside    : constant Ada.Strings.Membership := Ada.Strings.Inside;
   Outside   : constant Ada.Strings.Membership := Ada.Strings.Outside;
   Forward   : constant Ada.Strings.Direction := Ada.Strings.Forward;
   Backward  : constant Ada.Strings.Direction := Ada.Strings.Backward;

   ---------------------------------------------------------------------------

   procedure Put_Line (Item : in String) renames tio.Put_Line;
   procedure Put_Line (Item : in Ustr);

   Pre   : String := " |PK: ";

   procedure PutL (line : Ustr);

   procedure PutL (line : String);

   ----------------------------------------------------------------------------

   function toLowerCase (Source : in String) return String;

   function toLowerCase (Source : in Ustr) return Ustr;

   function toUpperCase (Source : in Ustr) return Ustr;

   function Clean_WhiteSpace (Source : in Ustr) return Ustr;

   pragma Inline (toLowerCase, toUpperCase, Clean_WhiteSpace);


   function pqIFq (p : String; q : Ustr) return Ustr;

   function pqIFp (p : String; q : Ustr) return Ustr;

   function ifelse (b : Boolean; p, q : String) return String;

   function ifelse (b : Boolean; p, q : Ustr) return Ustr;

   function ifelse (b : Boolean; p, q : Integer) return Integer;

   function "*" (p : String; b : Boolean) return String;

   function "*" (p : Ustr; b : Boolean) return Ustr;

      --  pragma Inline (PutL);  -- Removed, was causing a GNAT bug
               --   to appear. It was reported to ACT on 8-Apr-99 with
               --   name saying bug with generics and pragma Inline.
               --  If pragma is not commented program should print an
               --   error message saying some looked-up aliases not printed

   pragma Inline (pqIFp);

      --  pragma Inline (ifelse);  --  No pragma, mustn't fail

   pragma Inline ("*");

   ----------------------------------------------------------------------------

   Halt_Without_Err_Msg    : exception;

   procedure Raise_Msg (
          whaterr : String;
          X       : Ada.Exceptions.Exception_Occurrence);


   ----------------------------------------------------------------------------


   function Index_L (Source : Ustr; Pat : String) return Positive;

   type Split_Mode is (Remove_Pattern, Keep_Pattern);

   procedure Split (Source   : Ustr;
                    Pat      : String;
                    R1, R2   : out Ustr;
                    Mode     : Split_Mode := Remove_Pattern);

   procedure Split (Source : Ustr; From : Positive; Gap : Natural; R1, R2 : out Ustr);


   ----------------------------------------------------------------------------


   generic                 --   "generic" allows copies of package, ie. of
   package IO is           --    it's variables to be made (eg. "package Inp is
   ----------              --    new NGsm1.IO").

      subtype L_Natural  is L_Integer range 0 .. L_Integer'Last;

      Fname       : Ustr := Null_Ustr;    --  Set this to a filename 1st
      File_Opened : Boolean := False;
      Linenum     : L_Natural := 0;
      File        : tio.File_Type;

      procedure Read_Next_Line (Line : out Ustr);

      procedure Close_File;
      --------------------

   end IO;



end PlPre;