-----------------------------------------------------------------------------
--                       Another Craig Carey product                       --
--            This is just a proxy that prints what it proxies             --
--         And it can have one connection & no remote connection           --
--              It crashes when used: tasks are not recycled               --
--                                 4 June 1999                             --
--                                                                         --
--                                                                         --
--                                                                         --
--                         ADASOCKETS COMPONENTS                           --
--                                                                         --
--                            T C P R E L A Y                              --
--                                                                         --
--                                B o d y                                  --
--                                                                         --
--                         ReleaseVersion: 0.1.2                           --
--                                                                         --
--  Copyright (C) 1998  Ecole Nationale Superieure des Telecommunications  --
--                                                                         --
--   AdaSockets is free software; you can  redistribute it and/or modify   --
--   it  under terms of the GNU  General  Public License as published by   --
--   the Free Software Foundation; either version 2, or (at your option)   --
--   any later version.   AdaSockets is distributed  in the hope that it   --
--   will be useful, but WITHOUT ANY  WARRANTY; without even the implied   --
--   warranty of MERCHANTABILITY   or FITNESS FOR  A PARTICULAR PURPOSE.   --
--   See the GNU General Public  License  for more details.  You  should   --
--   have received a copy of the  GNU General Public License distributed   --
--   with AdaSockets; see   file COPYING.  If  not,  write  to  the Free   --
--   Software  Foundation, 59   Temple Place -   Suite  330,  Boston, MA   --
--   02111-1307, USA.                                                      --
--                                                                         --
--   As a special exception, if  other  files instantiate generics  from   --
--   this unit, or  you link this  unit with other  files to produce  an   --
--   executable,  this  unit does  not  by  itself cause  the  resulting   --
--   executable to be  covered by the  GNU General Public License.  This   --
--   exception does  not  however invalidate any  other reasons  why the   --
--   executable file might be covered by the GNU Public License.           --
--                                                                         --
--   The main repository for this software is located at:                  --
--       http://www-inf.enst.fr/ANC/                                       --
--                                                                         --
-----------------------------------------------------------------------------

with Ada.Command_Line;
with Ada.Exceptions;
with Ada.Text_IO;
with Sockets;          use Sockets;
with Sockets.Naming;
with Ada.Streams;
with PlPre;            use PlPre;

procedure ptunnel is      -- was called tcprelay, $tcprelay

   --  Usage: tcprelay localport remotehost remoteport
   --  Example: tcprelay 5000 localhost 25,
   --  then telnet localhost 5000

   package tio renames Ada.Text_IO;
   package stm renames Ada.Streams;

   package SocketsN renames Sockets.Naming;

   use type Ustr;


   subtype T_num is Long_Integer;

   Task_Num : T_num := 0;


   function Inf (Task_Num2 : T_Num) return String is
   begin
      return T_num'Image (Task_Num2) & " ";
   end Inf;


   function Inf return String is
   begin
      return Inf (Task_Num);
   end Inf;



   procedure Tap_Print (Data  : in stm.Stream_Element_Array)
   is
      --  Index : Stream_Element_Offset := Data'First;
      --  Rest  : Stream_Element_Count  := Data'Length;
      --  Count : int;
      H    : Integer;
      Len  : String := SF.Trim (Integer'Image(Data'Length), Left);
   begin
      tio.New_Line;
      tio.Put ("(" & Len & ":");
      for K in Data'Range loop
         H := stm.Stream_Element'Pos (Data (K));
         begin
            tio.Put (Character'Val (H));
         exception
            when others => tio.Put ("(?)");
         end;
      end loop;
      tio.Put_Line (":" & Len & ")");
   end Tap_Print;


   task type Relay is
      entry Start (From, To : Socket_FD; Task_Num : T_num; Outgoing : Boolean);
   end Relay;

   task body Relay
   is
      From_FD, To_FD : Socket_FD;
      TaskNumber : T_num := 0;
      Send_Out   : Boolean;
      crashed    : Boolean;

      procedure Finish_Up is
      begin
         crashed := false;
         tio.Put (Inf (TaskNumber) & "Closing near connection...");
         begin
            Shutdown (From_FD, Receive);
         exception
            when others => crashed := true;
         end;
         if crashed then tio.Put ("Crashed"); else tio.Put ("OK"); end if;
         if Send_Out then
            crashed := false;
            tio.Put (Inf (TaskNumber) & "Closing remote connection...");
            begin
               Shutdown (To_FD, Send);
            exception
               when others => crashed := true;
            end;
            if crashed then tio.Put ("Crashed"); else tio.Put ("OK"); end if;
         end if;
      end Finish_Up;


   begin
      select
         accept Start (From, To : Socket_FD; Task_Num : T_num; Outgoing : Boolean) do
            From_FD := From;
            Send_Out := Outgoing;
            if Send_Out then To_FD := To; end if;
            TaskNumber := Task_Num;
         end Start;
      or
         terminate;
      end select;

      loop
         declare
            Data : Ada.Streams.Stream_Element_Array := Receive (From_FD);
         begin
            Tap_Print (Data);
            if Send_Out then Send (To_FD, Data); end if;
         end;
      end loop;

   exception
      when Connection_Closed =>
         Finish_Up;

      when others =>
         tio.Put_Line (Inf (TaskNumber) & "CRASHED");  -- Add details later
         Finish_Up;

   end Relay;


   Is_Near, Is_Far : Boolean := false;   --  Two half-a-proxy modes: sump data and still print it.
   type Relay_Access is access Relay;

   --  Colon_To_Blank_mapping  : constant SM.Character_Mapping := SM.To_Mapping (
   --           From => ":", To   => " ");

   package CL renames Ada.Command_Line;

   near_port, far_address, far_port : Ustr := Null_Ustr;
   R1, R2, s  : Ustr;

   Accepting_Socket  : Socket_FD;


begin

   if CL.Argument_Count >= 1 then near_port   := us (CL.Argument(1)); end if;
   if CL.Argument_Count >= 2 then far_address := us (CL.Argument(2)); end if;
   if CL.Argument_Count >= 3 then far_port    := us (CL.Argument(3)); end if;

   Split (far_address, ":", R1, R2);
   if R2 /= "" then                      --  E.g. args = "84 128.0.0.1:83"
      far_address := R1;
      far_port := R2;
   end if;

   if far_port = "" then                 --  E.g. args = "84 83"
      far_port := far_address;
      far_address := Null_Ustr;
   end if;

   if far_address = "" and far_port /= "" then
      far_address := us ("127.0.0.1");
   end if;

   Is_Near := (near_port /= "-");
   Is_Far  := (far_port /= "" and far_port /= "-");

   if not Is_Near then near_port := Null_Ustr; end if;
   if not Is_Far then far_port := Null_Ustr; far_address := Null_Ustr; end if;

   if not (Is_Near or Is_Far) or CL.Argument_Count >= 4 or
         near_port = "-h" or near_port = "--help" or
         (far_address = "") /= (far_port = "")
   then
      tio.Put_Line ("Usage: " & CL.Command_Name & "  (v0.32)");
      tio.Put_Line ("   localport [remote_IP_Address]:port");
      tio.Put_Line ("A hyphen ('-') may be used for the localport if there is none.");
      tio.Put_Line ("The remote IP address and port may be omitted. A ' ' may replace the ':'.");
      tio.Put_Line ("(Author: C Carey, research@clear.net.nz)");
   else

      if Is_Far and then not SocketsN.Is_IP_Address (Something => fs (far_address)) then
         tio.Put(" Hostname of " & fs (far_address) & " = ");
         tio.Flush;
         s := us (SocketsN.Image (SocketsN.Address_Of (Something => fs (far_address))));
         far_address := s;
         tio.Put_Line (fs (s));
      end if;

      if Is_Near then
         Accepting_Socket := Socket (AF_INET, SOCK_STREAM);
         Setsockopt (Accepting_Socket, SOL_SOCKET, SO_REUSEADDR, 1);
         Bind (Accepting_Socket, Positive'Value ( fs(near_port)));
         Listen (Accepting_Socket);
      end if;

      ----------------------------------------------------

      loop
         declare
            Dummy1, Dummy2    : Relay_Access;
            Incoming_Socket   : Socket_FD;
            Outgoing_Socket   : Socket_FD;
         begin
            Task_Num := Task_Num + 1;
            if Is_Near then
               tio.Put (Inf & "Waiting for new connection...");
               Incoming_Socket := Accept_Socket (Accepting_Socket);
               tio.Put_Line ("OK");
            end if;

            if Is_Far then
               Outgoing_Socket := Socket (AF_INET, SOCK_STREAM);

               tio.Put(Inf & "Connecting to remote host...");
               Connect (Outgoing_Socket, fs (far_address), Positive'Value ( fs(far_port)));
               tio.Put_Line ("OK");
            end if;

            if Is_Near and Is_Far then
               Dummy1 := new Relay;
               Dummy1.Start (Incoming_Socket, Outgoing_Socket, Task_Num, true);
               Dummy2 := new Relay;
               Dummy2.Start (Outgoing_Socket, Incoming_Socket, Task_Num, true);
            elsif Is_Near and not Is_Far then
               Dummy1 := new Relay;
               Dummy1.Start (Incoming_Socket, Incoming_Socket, Task_Num, false);
            elsif Is_Far and not Is_Near then
               Dummy2 := new Relay;
               Dummy2.Start (Outgoing_Socket, Outgoing_Socket, Task_Num, false);
            else
               exit;
            end if;
         end;
      end loop;
   end if;
end ptunnel;
