-----------------------------------------------------------------------------
--                                                                         --
--                         ADASOCKETS COMPONENTS                           --
--                                                                         --
--                        S O C K E T S . T H I N                          --
--                                                                         --
--                                S p e c                                  --
--                                                                         --
--                         ReleaseVersion: 0.1.2                           --
--                                                                         --
--            Copyright (C) 1996-1998 Free Software Foundation             --
--                                                                         --
--   AdaSockets is free software; you can  redistribute it and/or modify   --
--   it  under terms of the GNU  General  Public License as published by   --
--   the Free Software Foundation; either version 2, or (at your option)   --
--   any later version.   AdaSockets is distributed  in the hope that it   --
--   will be useful, but WITHOUT ANY  WARRANTY; without even the implied   --
--   warranty of MERCHANTABILITY   or FITNESS FOR  A PARTICULAR PURPOSE.   --
--   See the GNU General Public  License  for more details.  You  should   --
--   have received a copy of the  GNU General Public License distributed   --
--   with AdaSockets; see   file COPYING.  If  not,  write  to  the Free   --
--   Software  Foundation, 59   Temple Place -   Suite  330,  Boston, MA   --
--   02111-1307, USA.                                                      --
--                                                                         --
--   As a special exception, if  other  files instantiate generics  from   --
--   this unit, or  you link this  unit with other  files to produce  an   --
--   executable,  this  unit does  not  by  itself cause  the  resulting   --
--   executable to be  covered by the  GNU General Public License.  This   --
--   exception does  not  however invalidate any  other reasons  why the   --
--   executable file might be covered by the GNU Public License.           --
--                                                                         --
--   The main repository for this software is located at:                  --
--       http://www-inf.enst.fr/ANC/                                       --
--                                                                         --
-----------------------------------------------------------------------------
--                                                                         --
--   Adapted to the Win32 and WinSock 1.1 environment                      --
--                                                                         --
--   Rev:  0.2                                                             --
--   Date: 05-may-1998                                                     --
--                                                                         --
--   Jerry van Dijk                                                        --
--   Billie Holidaystraat 28                                               --
--   2324 LK  LEIDEN                                                       --
--   THE NETHERLANDS                                                       --
--   tel int +31 (0)71 531 43 65                                           --
--   email jdijk@acm.org                                                   --
--                                                                         --
--   The main repository for this software is located at:                  --
--       http://stad.dsl.nl/~jvandyk                                       --
--                                                                         --
-----------------------------------------------------------------------------

with System;
with Interfaces.C.Pointers;
with Ada.Unchecked_Deallocation;

with Interfaces;            use Interfaces;
with Interfaces.C;          use Interfaces.C;
with Interfaces.C.Strings;  use Interfaces.C.Strings;

package Sockets.Thin is     -- **CC** private removed

   type In_Addr is record
      S_B1, S_B2, S_B3, S_B4 : unsigned_char;
   end record;
   pragma Convention (C, In_Addr);
   --  Internet address

   type In_Addr_Access is access all In_Addr;
   pragma Convention (C, In_Addr_Access);
   --  Access to internet address

   Inaddr_Any : aliased constant In_Addr := (others => 0);
   --  Any internet address (all the interfaces)

   type Sockaddr_In is record
      Sin_Family : unsigned_short;
      Sin_Port   : unsigned_short      := 0;
      Sin_Addr   : In_Addr             := Inaddr_Any;
      Sin_Zero   : char_array (1 .. 8) := (others => char'Val (0));
   end record;
   pragma Convention (C, Sockaddr_In);
   --  Internet socket address

   type Sockaddr_In_Access is access all Sockaddr_In;
   pragma Convention (C, Sockaddr_In_Access);
   --  Access to internet socket address

   type Chars_Ptr_Array is array (C.size_t range <>) of
     aliased Strings.chars_ptr;

   package Chars_Ptr_Pointers is
      new Pointers (size_t, chars_ptr, Chars_Ptr_Array, Null_Ptr);
   --  Arrays of C (char *)

   type In_Addr_Access_Array is array (Positive range <>)
     of aliased In_Addr_Access;
   pragma Convention (C, In_Addr_Access_Array);

   package In_Addr_Access_Pointers is
     new Pointers (Positive, In_Addr_Access, In_Addr_Access_Array,
                   null);
   --  Array of internet addresses

   type Hostent is record
      H_Name      : chars_ptr;
      H_Aliases   : Chars_Ptr_Pointers.Pointer;
      H_Addrtype  : Short_Integer;
      H_Length    : Short_Integer;
      H_Addr_List : In_Addr_Access_Pointers.Pointer;
   end record;
   pragma Convention (C, Hostent);
   --  Host entry

   type Hostent_Access is access all Hostent;
   pragma Convention (C, Hostent_Access);
   --  Access to host entry

   type WSADATA is
      record
         wVersion       : unsigned_16;
         wHighVersion   : unsigned_16;
         szDescription  : char_array (1 .. 129);
         szSystemStatus : char_array (1 .. 257);
         iMaxSockets    : unsigned_16;
         iMaxUdpDg      : unsigned_16;
         lpVendorInfo   : chars_ptr;
      end record;
   pragma Convention (C, WSADATA);

   type LPWSADATA is access all WSADATA;
   pragma Convention (C, LPWSADATA);

   procedure Free is new Ada.Unchecked_Deallocation (WSADATA, LPWSADATA);

   function C_Inet_Addr (Cp : chars_ptr) return Unsigned_32;

   -- ---------------------------------------------------------------
   -- **CC**

   package C renames Interfaces.C;
   package Strings renames Interfaces.C.Strings;

   function C_Gethostbyaddr
     (Addr     : Strings.chars_ptr;
      Length   : C.int;
      Typ      : C.int)
      return Hostent_Access;

   -- ---------------------------------------------------------------

   function C_Socket (Domain, Typ, Protocol : int) return int;

   function C_Gethostbyname (Name : chars_ptr) return Hostent_Access;

   function C_Connect (S : int; Name : System.Address; Namelen : int)
     return int;

   function C_Bind (S : int; Name : System.Address; Namelen : int)
     return int;

   function C_Listen (S, Backlog : int) return int;

   function C_Setsockopt
     (S       : int;
      Level   : int;
      Optname : int;
      Optval  : System.Address;
      Optlen  : int)
     return int;

   function C_Accept (S : int; Addr : System.Address; Addrlen : access int)
     return int;

   function C_Send
     (Sock  : int;
      Buf   : System.Address;
      Nbyte : int;
      Flags : int)
     return int;

   function C_Recv (S : int; Buf : System.Address; Len, Flags : int) return int;

   procedure C_Shutdown (S : in int; How : in int);

   function WSAStartup (VersionRequested : Short_Integer;
                        WSAData          : LPWSADATA) return Integer;

private

   pragma Import (Convention => StdCall, C_Socket, "socket");
   pragma Import (Convention => StdCall, C_Inet_Addr, "inet_addr");
   pragma Import (Convention => StdCall, C_Gethostbyaddr, "gethostbyaddr");
   pragma Import (Convention => StdCall, C_Gethostbyname, "gethostbyname");
   pragma Import (Convention => StdCall, C_Connect, "connect");
   pragma Import (Convention => StdCall, C_Bind, "bind");
   pragma Import (Convention => StdCall, C_Listen, "listen");
   pragma Import (Convention => StdCall, C_Setsockopt, "setsockopt");
   pragma Import (Convention => StdCall, C_Accept, "accept");
   pragma Import (Convention => StdCall, C_Send, "send");
   pragma Import (Convention => StdCall, C_Recv, "recv");
   pragma Import (Convention => StdCall, C_Shutdown, "shutdown");
   pragma Import (Convention => StdCall, WSAStartup, "WSAStartup");

end Sockets.Thin;
