-----------------------------------------------------------------------------
--                                                                         --
--                         ADASOCKETS COMPONENTS                           --
--                                                                         --
--                       S O C K E T S . U T I L S                         --
--                                                                         --
--                                B o d y                                  --
--                                                                         --
--                         ReleaseVersion: 0.1.2                           --
--                                                                         --
--  Copyright (C) 1998  Ecole Nationale Superieure des Telecommunications  --
--                                                                         --
--   AdaSockets is free software; you can  redistribute it and/or modify   --
--   it  under terms of the GNU  General  Public License as published by   --
--   the Free Software Foundation; either version 2, or (at your option)   --
--   any later version.   AdaSockets is distributed  in the hope that it   --
--   will be useful, but WITHOUT ANY  WARRANTY; without even the implied   --
--   warranty of MERCHANTABILITY   or FITNESS FOR  A PARTICULAR PURPOSE.   --
--   See the GNU General Public  License  for more details.  You  should   --
--   have received a copy of the  GNU General Public License distributed   --
--   with AdaSockets; see   file COPYING.  If  not,  write  to  the Free   --
--   Software  Foundation, 59   Temple Place -   Suite  330,  Boston, MA   --
--   02111-1307, USA.                                                      --
--                                                                         --
--   As a special exception, if  other  files instantiate generics  from   --
--   this unit, or  you link this  unit with other  files to produce  an   --
--   executable,  this  unit does  not  by  itself cause  the  resulting   --
--   executable to be  covered by the  GNU General Public License.  This   --
--   exception does  not  however invalidate any  other reasons  why the   --
--   executable file might be covered by the GNU Public License.           --
--                                                                         --
--   The main repository for this software is located at:                  --
--       http://www-inf.enst.fr/ANC/                                       --
--                                                                         --
-----------------------------------------------------------------------------
--                                                                         --
--   Adapted to the Win32 and WinSock 1.1 environment                      --
--                                                                         --
--   Rev:  0.2                                                             --
--   Date: 05-may-1998                                                     --
--                                                                         --
--   Jerry van Dijk                                                        --
--   Billie Holidaystraat 28                                               --
--   2324 LK  LEIDEN                                                       --
--   THE NETHERLANDS                                                       --
--   tel int +31 (0)71 531 43 65                                           --
--   email jdijk@acm.org                                                   --
--                                                                         --
--   The main repository for this software is located at:                  --
--       http://stad.dsl.nl/~jvandyk                                       --
--                                                                         --
-----------------------------------------------------------------------------

with Ada.Exceptions; use Ada.Exceptions;

package body Sockets.Utils is

   ------------------------
   -- Raise_With_Message --
   ------------------------

   procedure Raise_With_Message (Message : in String) is
   begin
      Raise_Exception (Constraint_Error'Identity, Message);

      --  The following line works around a bug in GNAT that does not
      --  recognize Ada.Exceptions.Raise_Exception as raising an exception,
      --  even if it can compute statically that the occurrence cannot
      --  be Null_Occurrence ???

      raise Program_Error;
   end Raise_With_Message;

end Sockets.Utils;
