/* Configuration header file.
   Copyright (C) 1995, 1996, 1997, 1998 Free Software Foundation, Inc.

This file is part of Wget.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef CONFIG_H
#define CONFIG_H

/* Define if you have the <alloca.h> header file.  */
#undef HAVE_ALLOCA_H

/* AIX requires this to be the first thing in the file.  */
#ifdef __GNUC__
# define alloca __builtin_alloca
#else
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
 #pragma alloca
#  else

#   ifdef VMS
 #include <builtins.h>
 #define alloca( x) __ALLOCA( x)
#   else

#    ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#    endif
#   endif
#  endif
# endif
#endif

/* Define if on AIX 3.
   System headers sometimes define this.
   We just want to avoid a redefinition error message.  */
#ifndef _ALL_SOURCE
#undef _ALL_SOURCE
#endif

/* Define to empty if the keyword does not work.  */
#undef const

/* Define to `unsigned' if <sys/types.h> doesn't define.  */
#undef size_t

/* Define to `int' if <sys/types.h> doesn't define.  */
#undef pid_t

/* Define if you have the ANSI C header files.  */
#undef STDC_HEADERS
#define STDC_HEADERS

/* Define as the return type of signal handlers (int or void).  */
#undef RETSIGTYPE
#define RETSIGTYPE void

/* Define if your architecture is big endian (with the most
   significant byte first).  */
#undef WORDS_BIGENDIAN

/* Define this if you want the NLS support.  */
#undef HAVE_NLS

/* Define if you want the FTP support for Opie compiled in.  */
#undef USE_OPIE

/* Define if you want the HTTP Digest Authorization compiled in.  */
#undef USE_DIGEST

/* Define if you want the debug output support compiled in.  */
#undef DEBUG

/* Define if you have sys/time.h header.  */
#undef HAVE_SYS_TIME_H

/* Define if you can safely include both <sys/time.h> and <time.h>.  */
#undef TIME_WITH_SYS_TIME

/* Define if you have struct utimbuf.  */
/* #undef HAVE_STRUCT_UTIMBUF */
#define HAVE_STRUCT_UTIMBUF

/* Define if you have the uname function.  */
#undef HAVE_UNAME
#define HAVE_UNAME

/* Define if you have the gethostname function.  */
#undef HAVE_GETHOSTNAME
#define HAVE_GETHOSTNAME

/* Define if you have the select function.  */
#undef HAVE_SELECT
#define HAVE_SELECT

/* Define if you have the gettimeofday function.  */
#undef HAVE_GETTIMEOFDAY
#define HAVE_GETTIMEOFDAY

/* Define if you have the strdup function.  */
#undef HAVE_STRDUP
#define HAVE_STRDUP

/* Define if you have the sys/utsname.h header.  */
#undef HAVE_SYS_UTSNAME_H
#define HAVE_SYS_UTSNAME_H

/* Define if you have the strerror function.  */
#undef HAVE_STRERROR
#define HAVE_STRERROR

/* Define if you have the vsnprintf function.  */
#undef HAVE_VSNPRINTF

/* Define if you have the strstr function.  */
#undef HAVE_STRSTR
#define HAVE_STRSTR

/* Define if you have the strcasecmp function.  */
#undef HAVE_STRCASECMP
#define HAVE_STRCASECMP

/* Define if you have the strncasecmp function.  */
#undef HAVE_STRNCASECMP
#define HAVE_STRNCASECMP

/* Define if you have the strptime function.  */
#undef HAVE_STRPTIME
#define HAVE_STRPTIME

/* Define if you have the mktime function.  */
#undef HAVE_MKTIME
#define HAVE_MKTIME

/* Define if you have the symlink function.  */
#undef HAVE_SYMLINK

/* Define if you have the access function.  */
#undef HAVE_ACCESS
#define HAVE_ACCESS

/* Define if you have the isatty function.  */
#undef HAVE_ISATTY
#define HAVE_ISATTY

/* Define if you have the signal function.  */
#undef HAVE_SIGNAL
#define HAVE_SIGNAL

/* Define if you have the gettext function.  */
#undef HAVE_GETTEXT

/* Define if you have the <string.h> header file.  */
#undef HAVE_STRING_H
#define HAVE_STRING_H

/* Define if you have the <stdarg.h> header file.  */
#undef HAVE_STDARG_H
#define HAVE_STDARG_H

/* Define if you have the <unistd.h> header file.  */
#undef HAVE_UNISTD_H
#define HAVE_UNISTD_H

/* Define if you have the <utime.h> header file.  */
#undef HAVE_UTIME_H

/* Define if you have the <sys/utime.h> header file.  */
#undef HAVE_SYS_UTIME_H

/* Define if you have the <sys/select.h> header file.  */
#undef HAVE_SYS_SELECT_H

/* Define if you have the <pwd.h> header file.  */
#undef HAVE_PWD_H
#define HAVE_PWD_H

/* Define if you have the <signal.h> header file.  */
#undef HAVE_SIGNAL_H
#define HAVE_SIGNAL_H

/* Define if you have the <libintl.h> header file.  */
#undef HAVE_LIBINTL_H

/* Define if you have the <locale.h> header file.  */
#undef HAVE_LOCALE_H
#define HAVE_LOCALE_H

/* Define to be the name of the operating system.  */
#undef OS_TYPE

/* Define if you wish to compile with socks support.  */
#undef HAVE_SOCKS

/* Define to 1 if ANSI function prototypes are usable.  */
#undef PROTOTYPES
#define PROTOTYPES 1

#endif /* CONFIG_H */
