#if defined( INC_ALL ) || defined( INC_CHILD )
  #include "ec_vlong.h"
  #include "ec_curve.h"
#else
  #include "crypt/ec_vlong.h"
  #include "crypt/ec_curve.h"
#endif /* Compiler-specific includes */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#if GF_M == 24

const order_t prime_order = {
	 0x0002U, 0x15cfU, 0x0001U
}; /* prime_order (17 bits) */

const ecPoint curve_point = {
	{0x0003U, 0x009bU, 0x00a1U, 0x005cU},
	{0x0003U, 0x0066U, 0x00b9U, 0x0085U}
}; /* curve_point */

#elif GF_M == 30

const order_t prime_order = {
	 0x0002U, 0xc993U, 0x0010U
}; /* prime_order (21 bits) */

const ecPoint curve_point = {
	{0x0003U, 0x0246U, 0x03b0U, 0x0298U},
	{0x0003U, 0x00d5U, 0x03e4U, 0x012fU}
}; /* curve_point */

#elif GF_M == 33

const order_t prime_order = {
	 0x0002U, 0xbc8fU, 0x0042U
}; /* prime_order (23 bits) */

const ecPoint curve_point = {
	{0x0003U, 0x03e1U, 0x07fdU, 0x01f0U},
	{0x0003U, 0x0385U, 0x0542U, 0x0209U}
}; /* curve_point */

#elif GF_M == 39

const order_t prime_order = {
	 0x0002U, 0x00afU, 0x0417U
}; /* prime_order (27 bits) */

const ecPoint curve_point = {
	{0x0003U, 0x1f69U, 0x1b67U, 0x0a9bU},
	{0x0003U, 0x0298U, 0x120cU, 0x0d58U}
}; /* curve_point */

#elif GF_M == 40

const order_t prime_order = {
	 0x0002U, 0xb927U, 0x193eU
}; /* prime_order (29 bits) */

const ecPoint curve_point = {
	{0x0005U, 0x008cU, 0x006cU, 0x0073U, 0x0097U, 0x0050U},
	{0x0005U, 0x0053U, 0x0066U, 0x00e6U, 0x0082U, 0x00c5U}
}; /* curve_point */

#elif GF_M == 42

const order_t prime_order = {
	 0x0002U, 0xdc57U, 0x103bU
}; /* prime_order (29 bits) */

const ecPoint curve_point = {
	{0x0003U, 0x3d5aU, 0x23a1U, 0x01a5U},
	{0x0003U, 0x1b1fU, 0x2794U, 0x3009U}
}; /* curve_point */

#elif GF_M == 45

const order_t prime_order = {
	 0x0003U, 0xcbadU, 0xa680U, 0x0010U
}; /* prime_order (37 bits) */

const ecPoint curve_point = {
	{0x0005U, 0x0132U, 0x00a4U, 0x01b3U, 0x01b6U, 0x0010U},
	{0x0005U, 0x0199U, 0x00c0U, 0x0057U, 0x007aU, 0x0188U}
}; /* curve_point */

#elif GF_M == 48

const order_t prime_order = {
	 0x0003U, 0xd66fU, 0x01f7U, 0x0001U
}; /* prime_order (33 bits) */

const ecPoint curve_point = {
	{0x0003U, 0x4628U, 0xcaa3U, 0xb4f0U},
	{0x0003U, 0x0597U, 0x9405U, 0xb98dU}
}; /* curve_point */

#elif GF_M == 55

const order_t prime_order = {
	 0x0003U, 0x6525U, 0x810cU, 0x10a6U
}; /* prime_order (45 bits) */

const ecPoint curve_point = {
	{0x0005U, 0x01edU, 0x0205U, 0x001dU, 0x0604U, 0x0044U},
	{0x0005U, 0x06a4U, 0x019dU, 0x03f8U, 0x0367U, 0x0139U}
}; /* curve_point */

#elif GF_M == 56

const order_t prime_order = {
	 0x0004U, 0xe7f3U, 0x1502U, 0x0c97U, 0x0001U
}; /* prime_order (49 bits) */

const ecPoint curve_point = {
	{0x0007U, 0x00dcU, 0x00dcU, 0x00afU, 0x00f2U, 0x0029U, 0x0049U, 0x000fU},
	{0x0007U, 0x0073U, 0x006eU, 0x0099U, 0x0009U, 0x000cU, 0x0011U, 0x00baU}
}; /* curve_point */

#elif GF_M == 60

const order_t prime_order = {
	 0x0004U, 0x26cdU, 0x0a48U, 0x0668U, 0x0001U
}; /* prime_order (49 bits) */

const ecPoint curve_point = {
	{0x0005U, 0x0324U, 0x0e80U, 0x0272U, 0x01e1U, 0x061fU},
	{0x0005U, 0x0aaeU, 0x007cU, 0x0a3aU, 0x0449U, 0x0511U}
}; /* curve_point */

#elif GF_M == 63

const order_t prime_order = {
	 0x0004U, 0xad67U, 0x3ccbU, 0x3c3cU, 0x003cU
}; /* prime_order (54 bits) */

const ecPoint curve_point = {
	{0x0007U, 0x00e5U, 0x011bU, 0x01dcU, 0x001fU, 0x0168U, 0x0055U, 0x003cU},
	{0x0007U, 0x00a5U, 0x01eaU, 0x0134U, 0x0124U, 0x0010U, 0x01f8U, 0x00cfU}
}; /* curve_point */

#elif GF_M == 65

const order_t prime_order = {
	 0x0004U, 0x8715U, 0x3bbfU, 0x55c2U, 0x0010U
}; /* prime_order (53 bits) */

const ecPoint curve_point = {
	{0x0005U, 0x07c9U, 0x1f85U, 0x0137U, 0x193aU, 0x0e6aU},
	{0x0005U, 0x11bbU, 0x1918U, 0x1d96U, 0x091fU, 0x04dbU}
}; /* curve_point */

#elif GF_M == 70

const order_t prime_order = {
	 0x0004U, 0x244bU, 0x1227U, 0x1010U, 0x1010U
}; /* prime_order (61 bits) */

const ecPoint curve_point = {
	{0x0007U, 0x0034U, 0x01bcU, 0x027cU, 0x00faU, 0x021cU, 0x0007U, 0x016eU},
	{0x0007U, 0x02c0U, 0x036bU, 0x025eU, 0x0166U, 0x00b1U, 0x0379U, 0x01b4U}
}; /* curve_point */

#elif GF_M == 77

const order_t prime_order = {
	 0x0005U, 0x0393U, 0x9247U, 0xa81cU, 0x167bU, 0x0004U
}; /* prime_order (67 bits) */

const ecPoint curve_point = {
	{0x0007U, 0x062dU, 0x0041U, 0x0750U, 0x05a2U, 0x01a1U, 0x0572U, 0x01b2U},
	{0x0007U, 0x067cU, 0x0490U, 0x0725U, 0x03b8U, 0x0591U, 0x00baU, 0x0448U}
}; /* curve_point */

#elif GF_M == 80

const order_t prime_order = {
	 0x0005U, 0x648dU, 0xdef3U, 0x239aU, 0x01c7U, 0x0001U
}; /* prime_order (65 bits) */

const ecPoint curve_point = {
	{0x0005U, 0x0f0cU, 0xc7d1U, 0xdec7U, 0x650aU, 0x18eaU},
	{0x0005U, 0x06fcU, 0x1e65U, 0xea6dU, 0x3c9fU, 0xbbe7U}
}; /* curve_point */

#elif GF_M == 84

const order_t prime_order = {
	 0x0005U, 0xeed3U, 0x7809U, 0xe029U, 0xeecbU, 0x0106U
}; /* prime_order (73 bits) */

const ecPoint curve_point = {
	{0x0007U, 0x05d0U, 0x04ecU, 0x0785U, 0x0b2cU, 0x0de2U, 0x0035U, 0x083dU},
	{0x0007U, 0x0b62U, 0x030aU, 0x0264U, 0x0068U, 0x030fU, 0x0662U, 0x04f5U}
}; /* curve_point */

#elif GF_M == 91

const order_t prime_order = {
	 0x0005U, 0xf53fU, 0xec61U, 0xac33U, 0xbf4cU, 0x4135U
}; /* prime_order (79 bits) */

const ecPoint curve_point = {
	{0x0007U, 0x1227U, 0x1b5dU, 0x0773U, 0x1ea7U, 0x1d03U, 0x0fc3U, 0x1cafU},
	{0x0007U, 0x1908U, 0x0a79U, 0x1f90U, 0x1262U, 0x0e9dU, 0x1dd4U, 0x14aaU}
}; /* curve_point */

#elif GF_M == 99

const order_t prime_order = {
	 0x0006U, 0x4cffU, 0xfc97U, 0xfc24U, 0x3f80U, 0x0fe0U, 0x03f8U
}; /* prime_order (90 bits) */

const ecPoint curve_point = {
	{0x000bU, 0x0004U, 0x005bU, 0x007fU, 0x0059U, 0x013eU, 0x0059U, 0x01d2U,
	 0x016fU, 0x0068U, 0x013dU, 0x0010U},
	{0x000bU, 0x01cbU, 0x0015U, 0x0088U, 0x00beU, 0x01c2U, 0x00e1U, 0x00b5U,
	 0x0045U, 0x01beU, 0x0056U, 0x006dU}
}; /* curve_point */

#elif GF_M == 105

const order_t prime_order = {
	 0x0006U, 0xdcebU, 0x8de4U, 0x0251U, 0xea16U, 0x3500U, 0x0409U
}; /* prime_order (91 bits) */

const ecPoint curve_point = {
	{0x0007U, 0x0cc2U, 0x6bdaU, 0x049cU, 0x4a7aU, 0x15cfU, 0x207aU, 0x65d0U},
	{0x0007U, 0x1a84U, 0x32a4U, 0x6e90U, 0x48eaU, 0x1a91U, 0x41a5U, 0x3393U}
}; /* curve_point */

#elif GF_M == 110

const order_t prime_order = {
	 0x0007U, 0xecffU, 0x1655U, 0xd09eU, 0xf00fU, 0xf00fU, 0xf00fU, 0x000fU
}; /* prime_order (100 bits) */

const ecPoint curve_point = {
	{0x000bU, 0x027fU, 0x00d2U, 0x0304U, 0x0125U, 0x0195U, 0x00a3U, 0x02f6U,
	 0x01c5U, 0x02deU, 0x0351U, 0x014dU},
	{0x000bU, 0x027fU, 0x0084U, 0x0072U, 0x0250U, 0x01c2U, 0x015eU, 0x0317U,
	 0x01c5U, 0x001bU, 0x0074U, 0x039dU}
}; /* curve_point */

#elif GF_M == 112

const order_t prime_order = {
	 0x0007U, 0x817bU, 0xa972U, 0x3605U, 0x032eU, 0xd812U, 0x01f7U, 0x0001U
}; /* prime_order (97 bits) */

const ecPoint curve_point = {
	{0x0007U, 0x50a5U, 0x7366U, 0x6311U, 0xe5a2U, 0x43eaU, 0x385dU, 0x1db1U},
	{0x0007U, 0x1331U, 0x03d1U, 0xf8e8U, 0xfc64U, 0xa20cU, 0xc629U, 0x9c3eU}
}; /* curve_point */

#elif GF_M == 132

const order_t prime_order = {
	 0x0008U, 0xacffU, 0x9515U, 0x65adU, 0x0fdbU, 0xffc0U, 0xfc00U, 0xc00fU,
	 0x00ffU
}; /* prime_order (120 bits) */

const ecPoint curve_point = {
	{0x000bU, 0x0a5aU, 0x088cU, 0x0363U, 0x04ecU, 0x0c27U, 0x0d03U, 0x0529U,
	 0x0f89U, 0x099cU, 0x0af2U, 0x021dU},
	{0x000bU, 0x095fU, 0x0251U, 0x0c5cU, 0x0fa5U, 0x0575U, 0x0eabU, 0x0088U,
	 0x06feU, 0x0e19U, 0x0840U, 0x0857U}
}; /* curve_point */

#elif GF_M == 136

const order_t prime_order = {
	 0x0008U, 0x0df1U, 0xc7b9U, 0xf23eU, 0x1e34U, 0xd730U, 0xcc0eU, 0x03b5U,
	 0xed73U
}; /* prime_order (128 bits) */

const ecPoint curve_point = {
	{0x0011U, 0x00dbU, 0x003dU, 0x00ddU, 0x0015U, 0x00afU, 0x0000U, 0x004fU,
	 0x0007U, 0x00b2U, 0x0092U, 0x00a9U, 0x005fU, 0x00e9U, 0x00beU, 0x0053U,
	 0x00fcU, 0x00f4U},
	{0x0011U, 0x00bfU, 0x007dU, 0x009cU, 0x0004U, 0x00dfU, 0x00beU, 0x00aeU,
	 0x0064U, 0x0074U, 0x005aU, 0x00cfU, 0x00a8U, 0x0019U, 0x0083U, 0x0052U,
	 0x0078U, 0x0081U}
}; /* curve_point */

#elif GF_M == 143

const order_t prime_order = {
	 0x0009U, 0x166bU, 0xfca0U, 0xc676U, 0x79dbU, 0x0519U, 0xcd01U, 0xfdf5U,
	 0x1465U, 0x0004U
}; /* prime_order (131 bits) */

const ecPoint curve_point = {
	{0x000bU, 0x17e7U, 0x0ddeU, 0x1f1bU, 0x011eU, 0x1783U, 0x1b6bU, 0x122aU,
	 0x0463U, 0x0080U, 0x1673U, 0x1751U},
	{0x000bU, 0x0441U, 0x150bU, 0x1784U, 0x00c9U, 0x07f0U, 0x0b66U, 0x176fU,
	 0x10baU, 0x1321U, 0x112bU, 0x1e9eU}
}; /* curve_point */

#elif GF_M == 153

const order_t prime_order = {
	 0x000aU, 0xebf1U, 0x8c89U, 0x0bfbU, 0xb9c4U, 0xc8caU, 0xbe76U, 0x1a9fU,
	 0xdd2fU, 0x0624U, 0x0001U
}; /* prime_order (145 bits) */

const ecPoint curve_point = {
	{0x0011U, 0x0042U, 0x011aU, 0x0065U, 0x010cU, 0x00a3U, 0x0080U, 0x0106U,
	 0x004cU, 0x0116U, 0x00ddU, 0x0189U, 0x0046U, 0x00a6U, 0x0122U, 0x00d7U,
	 0x01a0U, 0x0150U},
	{0x0011U, 0x014aU, 0x000bU, 0x014dU, 0x01d8U, 0x0021U, 0x0114U, 0x01c1U,
	 0x00f5U, 0x01e4U, 0x00eaU, 0x00b0U, 0x0028U, 0x01b6U, 0x00dfU, 0x00e2U,
	 0x0066U, 0x01d1U}
}; /* curve_point */

#elif GF_M == 154

const order_t prime_order = {
	 0x0009U, 0x02dbU, 0xff59U, 0xb9c0U, 0x6974U, 0x16bfU, 0xbf4eU, 0x5cffU,
	 0x7a50U, 0x102cU
}; /* prime_order (141 bits) */

const ecPoint curve_point = {
	{0x000bU, 0x0ee5U, 0x36fbU, 0x3e4aU, 0x3fc8U, 0x2388U, 0x2d66U, 0x34d8U,
	 0x3d57U, 0x2e5bU, 0x36adU, 0x3b21U},
	{0x000bU, 0x34dbU, 0x1737U, 0x0390U, 0x0632U, 0x0ecbU, 0x22beU, 0x0fcdU,
	 0x1a1cU, 0x2a45U, 0x2f59U, 0x2211U}
}; /* curve_point */

#elif GF_M == 165

const order_t prime_order = {
	 0x000aU, 0xda93U, 0x7a13U, 0xb07dU, 0x8189U, 0xf045U, 0xdc5aU, 0xc0f5U,
	 0x1508U, 0x7cf2U, 0x0040U
}; /* prime_order (151 bits) */

const ecPoint curve_point = {
	{0x000bU, 0x589eU, 0x0e0aU, 0x7ed6U, 0x2cbbU, 0x2e3bU, 0x5181U, 0x0246U,
	 0x7cb5U, 0x71acU, 0x753aU, 0x0024U},
	{0x000bU, 0x43f8U, 0x5c74U, 0x1e72U, 0x01bcU, 0x53d1U, 0x62b1U, 0x3298U,
	 0x4e11U, 0x39c2U, 0x6000U, 0x4a3bU}
}; /* curve_point */

#elif GF_M == 170

const order_t prime_order = {
	 0x000bU, 0x0a51U, 0x0183U, 0xa054U, 0x6f71U, 0x0537U, 0x0408U, 0x8102U,
	 0x2040U, 0x0810U, 0x0204U, 0x0001U
}; /* prime_order (161 bits) */

const ecPoint curve_point = {
	{0x0011U, 0x0019U, 0x037dU, 0x032aU, 0x0078U, 0x024aU, 0x0234U, 0x0083U,
	 0x00bdU, 0x03a1U, 0x023fU, 0x03e3U, 0x03dcU, 0x0362U, 0x01e9U, 0x03e7U,
	 0x0013U, 0x0106U},
	{0x0011U, 0x032fU, 0x00feU, 0x0325U, 0x02edU, 0x0142U, 0x0378U, 0x0098U,
	 0x0222U, 0x03c7U, 0x0088U, 0x0317U, 0x0069U, 0x02adU, 0x0292U, 0x03acU,
	 0x03a7U, 0x00f7U}
}; /* curve_point */

#elif GF_M == 176

const order_t prime_order = {
	 0x000aU, 0x248bU, 0xaa3dU, 0x27e5U, 0x4c74U, 0x7f80U, 0x00ffU, 0x03feU,
	 0x0ff8U, 0x3fe0U, 0xff80U
}; /* prime_order (160 bits) */

const ecPoint curve_point = {
	{0x000bU, 0x2dfbU, 0xe60aU, 0xc14dU, 0x7ffaU, 0xecc1U, 0xd118U, 0xd3b4U,
	 0x2007U, 0x7bceU, 0x93b5U, 0x5199U},
	{0x000bU, 0x8dc0U, 0xe32fU, 0xc4d7U, 0x84e1U, 0xbcddU, 0xa9ccU, 0xe4b1U,
	 0x3264U, 0x9ee9U, 0xb533U, 0x9cffU}
}; /* curve_point */

#elif GF_M == 187

const order_t prime_order = {
	 0x000cU, 0x97d1U, 0x83b1U, 0x4cf8U, 0xd837U, 0x4987U, 0x41d6U, 0xadc0U,
	 0x66cfU, 0x7f7cU, 0x60a4U, 0x0732U, 0x0001U
}; /* prime_order (177 bits) */

const ecPoint curve_point = {
	{0x0011U, 0x01baU, 0x013bU, 0x0404U, 0x05aaU, 0x02cbU, 0x01caU, 0x0773U,
	 0x05b5U, 0x05adU, 0x00b0U, 0x04a3U, 0x0695U, 0x02e0U, 0x078cU, 0x026bU,
	 0x0479U, 0x066bU},
	{0x0011U, 0x03a3U, 0x073bU, 0x02c4U, 0x030cU, 0x0080U, 0x0109U, 0x051bU,
	 0x0708U, 0x031fU, 0x00f4U, 0x0041U, 0x05c9U, 0x0189U, 0x00b6U, 0x06e3U,
	 0x01c7U, 0x0444U}
}; /* curve_point */

#elif GF_M == 204

const order_t prime_order = {
	 0x000dU, 0x3cb1U, 0x2ff6U, 0xb1f4U, 0x8500U, 0x9c40U, 0x597dU, 0x1024U,
	 0x8e40U, 0x2594U, 0xdb2dU, 0x1b7dU, 0x0245U, 0x0001U
}; /* prime_order (193 bits) */

const ecPoint curve_point = {
	{0x0011U, 0x068dU, 0x0b8fU, 0x0943U, 0x04acU, 0x063eU, 0x0779U, 0x05afU,
	 0x0888U, 0x0f68U, 0x0f48U, 0x04ceU, 0x09f2U, 0x0cc8U, 0x0d1bU, 0x0d5bU,
	 0x089eU, 0x0420U},
	{0x0011U, 0x02e9U, 0x0281U, 0x06fbU, 0x0f09U, 0x0a49U, 0x0db1U, 0x082aU,
	 0x0e7fU, 0x08daU, 0x0c90U, 0x0e93U, 0x015cU, 0x0150U, 0x0905U, 0x0866U,
	 0x06cdU, 0x0e94U}
}; /* curve_point */

#elif GF_M == 207

const order_t prime_order = {
	 0x000dU, 0x4373U, 0x9656U, 0xecf2U, 0x2b0eU, 0xb7edU, 0x6849U, 0xdc7eU,
	 0xbcbaU, 0x8e03U, 0x0d14U, 0xc7f1U, 0xcbadU, 0x003bU
}; /* prime_order (198 bits) */

const ecPoint curve_point = {
	{0x0017U, 0x00abU, 0x01a1U, 0x01deU, 0x01a6U, 0x0099U, 0x0015U, 0x004eU,
	 0x00ebU, 0x01f2U, 0x0092U, 0x009dU, 0x01daU, 0x00c4U, 0x0010U, 0x01e8U,
	 0x0187U, 0x0159U, 0x005bU, 0x01d3U, 0x01aaU, 0x0022U, 0x00ceU, 0x0036U},
	{0x0017U, 0x0049U, 0x0043U, 0x002bU, 0x00f2U, 0x012cU, 0x0056U, 0x01fcU,
	 0x0062U, 0x0048U, 0x00ddU, 0x004bU, 0x004cU, 0x00f0U, 0x0024U, 0x01b0U,
	 0x00b9U, 0x0133U, 0x0193U, 0x01caU, 0x0123U, 0x00e8U, 0x00cdU, 0x01e9U}
}; /* curve_point */

#elif GF_M == 221

const order_t prime_order = {
	 0x000eU, 0x1511U, 0x34f5U, 0x8f68U, 0x03ceU, 0x6e17U, 0xd598U, 0x1052U,
	 0x5cd0U, 0x5fdfU, 0x4146U, 0x7340U, 0x7f7dU, 0x0519U, 0x0001U
}; /* prime_order (209 bits) */

const ecPoint curve_point = {
	{0x0011U, 0x1c94U, 0x0200U, 0x0d12U, 0x08d6U, 0x0678U, 0x0a70U, 0x1083U,
	 0x0948U, 0x0dd3U, 0x1de8U, 0x0089U, 0x0bdaU, 0x0d0dU, 0x09e6U, 0x0c57U,
	 0x12cdU, 0x0054U},
	{0x0011U, 0x0fd4U, 0x0e73U, 0x092fU, 0x1f9aU, 0x16d1U, 0x166cU, 0x1c9bU,
	 0x0723U, 0x123fU, 0x13b4U, 0x12dcU, 0x1683U, 0x1d33U, 0x1009U, 0x0db7U,
	 0x1069U, 0x0c0eU}
}; /* curve_point */

#elif GF_M == 230

const order_t prime_order = {
	 0x000eU, 0xe175U, 0xb20aU, 0xb9d2U, 0x6444U, 0xff64U, 0xfda8U, 0x41b9U,
	 0x9880U, 0xd21bU, 0x8c0fU, 0x10ffU, 0xe793U, 0xeab6U, 0x001eU
}; /* prime_order (213 bits) */

const ecPoint curve_point = {
	{0x0017U, 0x027fU, 0x0068U, 0x0146U, 0x01e2U, 0x019dU, 0x00d9U, 0x032eU,
	 0x003dU, 0x016dU, 0x03a4U, 0x00aaU, 0x02feU, 0x022fU, 0x02f9U, 0x0130U,
	 0x0092U, 0x0215U, 0x01fdU, 0x038aU, 0x01c7U, 0x014aU, 0x0190U, 0x0318U},
	{0x0017U, 0x03f2U, 0x02e9U, 0x00ebU, 0x0337U, 0x032dU, 0x02d1U, 0x0197U,
	 0x02dbU, 0x029eU, 0x0012U, 0x016cU, 0x00ffU, 0x01ebU, 0x00bcU, 0x01e9U,
	 0x003bU, 0x01a7U, 0x0290U, 0x029eU, 0x00cfU, 0x021cU, 0x0394U, 0x0283U}
}; /* curve_point */

#elif GF_M == 238

const order_t prime_order = {
	 0x000fU, 0xed51U, 0x6a0cU, 0x869aU, 0x74c5U, 0xb871U, 0x7242U, 0x520dU,
	 0x03adU, 0xa801U, 0x5451U, 0x03adU, 0xa801U, 0x5451U, 0x03adU, 0x0001U
}; /* prime_order (225 bits) */

const ecPoint curve_point = {
	{0x0011U, 0x383dU, 0x3febU, 0x39acU, 0x3e22U, 0x032cU, 0x1ab7U, 0x2d23U,
	 0x3931U, 0x2210U, 0x38f3U, 0x21cfU, 0x1981U, 0x34cdU, 0x1d37U, 0x1eacU,
	 0x106eU, 0x043dU},
	{0x0011U, 0x0ad0U, 0x272dU, 0x308aU, 0x1139U, 0x3912U, 0x1bb9U, 0x20d3U,
	 0x06afU, 0x16f4U, 0x157eU, 0x10b2U, 0x0d9eU, 0x3188U, 0x3941U, 0x0a61U,
	 0x3681U, 0x07daU}
}; /* curve_point */

#elif GF_M == 253

const order_t prime_order = {
	 0x0010U, 0xd063U, 0x1418U, 0x6207U, 0x8752U, 0xfc4fU, 0xe1c3U, 0x440eU,
	 0xf972U, 0x8b50U, 0x0507U, 0x1eaeU, 0xd4bfU, 0x5e8dU, 0x0d94U, 0x0609U,
	 0x0004U
}; /* prime_order (243 bits) */

const ecPoint curve_point = {
	{0x0017U, 0x004eU, 0x07daU, 0x046eU, 0x03d9U, 0x07e6U, 0x032aU, 0x0704U,
	 0x042bU, 0x01c0U, 0x040eU, 0x00f3U, 0x0193U, 0x0365U, 0x0653U, 0x00fdU,
	 0x05fdU, 0x07c0U, 0x07e2U, 0x01afU, 0x03b4U, 0x051cU, 0x052cU, 0x01caU},
	{0x0017U, 0x007bU, 0x0783U, 0x0521U, 0x0629U, 0x0002U, 0x02d4U, 0x02beU,
	 0x07fbU, 0x07a5U, 0x02abU, 0x023cU, 0x0073U, 0x067eU, 0x056fU, 0x054fU,
	 0x01bdU, 0x0119U, 0x042dU, 0x02bfU, 0x0405U, 0x023aU, 0x02acU, 0x03caU}
}; /* curve_point */

#elif GF_M == 255

const order_t prime_order = {
	 0x0010U, 0xcd31U, 0x42bbU, 0x2584U, 0x5e0dU, 0x2d8bU, 0x4bf7U, 0x840eU,
	 0x0547U, 0xbec3U, 0xed9bU, 0x691cU, 0x2314U, 0x81b8U, 0xd850U, 0x026dU,
	 0x0001U
}; /* prime_order (241 bits) */

const ecPoint curve_point = {
	{0x0011U, 0x38ccU, 0x052fU, 0x2510U, 0x45aaU, 0x1b89U, 0x4468U, 0x4882U,
	 0x0d67U, 0x4febU, 0x55ceU, 0x0025U, 0x4cb7U, 0x0cc2U, 0x59dcU, 0x289eU,
	 0x65e3U, 0x56fdU},
	{0x0011U, 0x31a7U, 0x65f2U, 0x18c4U, 0x3412U, 0x7388U, 0x54c1U, 0x539bU,
	 0x4a02U, 0x4d07U, 0x12d6U, 0x7911U, 0x3b5eU, 0x4f0eU, 0x216fU, 0x2bf2U,
	 0x1974U, 0x20daU}
}; /* curve_point */

#elif GF_M == 261

const order_t prime_order = {
	 0x0010U, 0x3d7dU, 0xc797U, 0x7169U, 0xa6e6U, 0x01baU, 0x7b9dU, 0xc572U,
	 0x89e1U, 0x4210U, 0x2108U, 0x1084U, 0x0842U, 0x8421U, 0x4210U, 0x2108U,
	 0x1084U
}; /* prime_order (253 bits) */

const ecPoint curve_point = {
	{0x001dU, 0x01dbU, 0x00a5U, 0x013cU, 0x01d5U, 0x0016U, 0x0197U, 0x0156U,
	 0x0082U, 0x01abU, 0x0054U, 0x003bU, 0x01c9U, 0x001aU, 0x019eU, 0x014fU,
	 0x00b0U, 0x0174U, 0x017eU, 0x00dfU, 0x01b2U, 0x0154U, 0x01e0U, 0x007dU,
	 0x00b7U, 0x011bU, 0x013aU, 0x0116U, 0x01baU, 0x010aU},
	{0x001dU, 0x0101U, 0x0099U, 0x01bcU, 0x0190U, 0x00deU, 0x00d8U, 0x00feU,
	 0x0165U, 0x0039U, 0x019eU, 0x0015U, 0x0163U, 0x0013U, 0x012aU, 0x0066U,
	 0x010eU, 0x01e8U, 0x0198U, 0x00b3U, 0x009aU, 0x0131U, 0x01f0U, 0x0111U,
	 0x018dU, 0x0050U, 0x004aU, 0x0105U, 0x01b7U, 0x001cU}
}; /* curve_point */

#elif GF_M == 272

const order_t prime_order = {
	 0x0011U, 0x9031U, 0x70a3U, 0x11efU, 0x5fc9U, 0x9cb2U, 0xf93aU, 0x8065U,
	 0xd8daU, 0x5572U, 0x951fU, 0x0389U, 0x30cdU, 0x49a0U, 0x64efU, 0x8184U,
	 0x0196U, 0x0001U
}; /* prime_order (257 bits) */

const ecPoint curve_point = {
	{0x0011U, 0xaa1bU, 0x1e51U, 0xb27cU, 0xff54U, 0x9015U, 0x2edeU, 0x10cbU,
	 0xaff9U, 0x3e6dU, 0xfbe2U, 0x29aaU, 0x6f2aU, 0xe04fU, 0xdf90U, 0xaf7cU,
	 0x92e6U, 0x4588U},
	{0x0011U, 0xd77bU, 0x475fU, 0xdce6U, 0x67b5U, 0xb46cU, 0x60b3U, 0xc8c4U,
	 0x71fbU, 0x1707U, 0x9cccU, 0x91baU, 0x31d1U, 0x0669U, 0xdc66U, 0xe3cfU,
	 0xcb7cU, 0x1db1U}
}; /* curve_point */

#elif GF_M == 276

const order_t prime_order = {
	 0x0011U, 0x957fU, 0x50baU, 0xc50fU, 0xd807U, 0x39b6U, 0x529fU, 0xfd7cU,
	 0x2106U, 0x8335U, 0x53daU, 0xb87aU, 0x62a6U, 0xd908U, 0xdd78U, 0xb409U,
	 0x8c15U, 0x00fcU
}; /* prime_order (264 bits) */

const ecPoint curve_point = {
	{0x0017U, 0x0036U, 0x0dbaU, 0x05f2U, 0x058aU, 0x0533U, 0x07dcU, 0x02afU,
	 0x0797U, 0x009dU, 0x07caU, 0x0f84U, 0x09e0U, 0x0d30U, 0x00f0U, 0x0d78U,
	 0x01c7U, 0x06a5U, 0x08c1U, 0x0eb5U, 0x038aU, 0x08edU, 0x039dU, 0x08bbU},
	{0x0017U, 0x0a32U, 0x0e5dU, 0x0800U, 0x0457U, 0x0172U, 0x0e3aU, 0x067dU,
	 0x07afU, 0x0c0fU, 0x05f6U, 0x09a8U, 0x0e1aU, 0x0883U, 0x0369U, 0x0c3dU,
	 0x0d12U, 0x0969U, 0x0e8aU, 0x052fU, 0x0406U, 0x0ac6U, 0x0dd4U, 0x0cadU}
}; /* curve_point */

#elif GF_M == 279

const order_t prime_order = {
	 0x0011U, 0x6737U, 0xbec4U, 0x6538U, 0xa6ddU, 0xdb34U, 0x3cc6U, 0x5032U,
	 0x5ecbU, 0x03aeU, 0xed73U, 0x5cc0U, 0x303bU, 0x0ed7U, 0xb5ccU, 0x7303U,
	 0xc0edU, 0x3b5cU
}; /* prime_order (270 bits) */

const ecPoint curve_point = {
	{0x001fU, 0x01afU, 0x00b0U, 0x015cU, 0x0122U, 0x00c1U, 0x003aU, 0x010eU,
	 0x019eU, 0x01ebU, 0x019eU, 0x012bU, 0x0193U, 0x0177U, 0x017dU, 0x004eU,
	 0x00c1U, 0x003dU, 0x0124U, 0x002fU, 0x003fU, 0x0165U, 0x01dfU, 0x00f7U,
	 0x00f3U, 0x00abU, 0x01a8U, 0x01e2U, 0x0121U, 0x007fU, 0x0175U, 0x00beU},
	{0x001fU, 0x010fU, 0x006dU, 0x01e1U, 0x0166U, 0x00c0U, 0x00e2U, 0x0036U,
	 0x001dU, 0x010dU, 0x00f7U, 0x014bU, 0x0149U, 0x0169U, 0x00b1U, 0x01c1U,
	 0x0135U, 0x00bbU, 0x0162U, 0x0068U, 0x009fU, 0x015fU, 0x002dU, 0x012aU,
	 0x00a6U, 0x01dcU, 0x012dU, 0x004aU, 0x0052U, 0x000eU, 0x016dU, 0x001eU}
}; /* curve_point */

#elif GF_M == 290

const order_t prime_order = {
	 0x0012U, 0xee3dU, 0x8177U, 0x73f8U, 0x82ffU, 0xdf70U, 0x401eU, 0x91d4U,
	 0x2cb6U, 0x14d2U, 0x0c97U, 0x3ac1U, 0xbcdaU, 0x714fU, 0x10c9U, 0xa3acU,
	 0xfbcdU, 0x9714U, 0x010cU
}; /* prime_order (281 bits) */

const ecPoint curve_point = {
	{0x001dU, 0x018eU, 0x0379U, 0x00dbU, 0x0072U, 0x0072U, 0x0334U, 0x007aU,
	 0x0237U, 0x0297U, 0x032dU, 0x0085U, 0x00adU, 0x03c1U, 0x00e6U, 0x03a7U,
	 0x00d2U, 0x005dU, 0x00d0U, 0x03f6U, 0x009fU, 0x02c7U, 0x009eU, 0x00d5U,
	 0x0036U, 0x0303U, 0x006aU, 0x01d6U, 0x01ecU, 0x0394U},
	{0x001dU, 0x02ddU, 0x00e5U, 0x0224U, 0x0002U, 0x03e6U, 0x0383U, 0x0241U,
	 0x0140U, 0x0221U, 0x0186U, 0x02e5U, 0x0106U, 0x02c3U, 0x0020U, 0x007bU,
	 0x000bU, 0x0354U, 0x01b0U, 0x03feU, 0x03feU, 0x0213U, 0x03c5U, 0x023fU,
	 0x036dU, 0x00b7U, 0x0388U, 0x003dU, 0x023eU, 0x02f5U}
}; /* curve_point */

#elif GF_M == 299

const order_t prime_order = {
	 0x0012U, 0x8183U, 0xb4e4U, 0x59efU, 0x802eU, 0xd67dU, 0x7f7bU, 0xa1f2U,
	 0x6d5bU, 0x4f91U, 0x5486U, 0xd6c2U, 0xc8b6U, 0xfc6cU, 0x49abU, 0xad43U,
	 0x8467U, 0x60a7U, 0x415fU
}; /* prime_order (287 bits) */

const ecPoint curve_point = {
	{0x0017U, 0x1d54U, 0x1f34U, 0x062dU, 0x0fdeU, 0x0413U, 0x034dU, 0x1e9dU,
	 0x0046U, 0x0176U, 0x1767U, 0x0ebbU, 0x042cU, 0x1e7aU, 0x0a42U, 0x0988U,
	 0x003fU, 0x1577U, 0x1c97U, 0x129aU, 0x05f0U, 0x05d2U, 0x0408U, 0x159bU},
	{0x0017U, 0x04a9U, 0x136bU, 0x1d0eU, 0x1411U, 0x08d0U, 0x036eU, 0x021aU,
	 0x0c69U, 0x09f7U, 0x1be7U, 0x13d6U, 0x0093U, 0x0d35U, 0x0de1U, 0x17fcU,
	 0x0b67U, 0x02b0U, 0x0652U, 0x191cU, 0x0b9dU, 0x0561U, 0x1bd5U, 0x0051U}
}; /* curve_point */

#elif GF_M == 310

const order_t prime_order = {
	 0x0013U, 0x381fU, 0x62a9U, 0x4a53U, 0x49e2U, 0x0e97U, 0x1f69U, 0x6f63U,
	 0x53f6U, 0xdcd9U, 0x0001U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x1000U
}; /* prime_order (301 bits) */

const ecPoint curve_point = {
	{0x001fU, 0x0341U, 0x0201U, 0x01dcU, 0x00ecU, 0x0347U, 0x0120U, 0x03bcU,
	 0x009aU, 0x0334U, 0x0040U, 0x035eU, 0x0091U, 0x03c9U, 0x0117U, 0x0215U,
	 0x01bfU, 0x0380U, 0x0221U, 0x017fU, 0x0023U, 0x02b8U, 0x02a5U, 0x02f7U,
	 0x0028U, 0x0273U, 0x005aU, 0x0052U, 0x0089U, 0x03cbU, 0x034cU, 0x02b0U},
	{0x001fU, 0x03e6U, 0x01d5U, 0x035eU, 0x005eU, 0x0022U, 0x0264U, 0x03a2U,
	 0x033fU, 0x0052U, 0x024bU, 0x00b7U, 0x0059U, 0x01c5U, 0x03b3U, 0x0322U,
	 0x0158U, 0x00b9U, 0x0086U, 0x01a2U, 0x010aU, 0x014eU, 0x034bU, 0x02d7U,
	 0x0201U, 0x032bU, 0x0097U, 0x02b6U, 0x018bU, 0x0337U, 0x0208U, 0x0399U}
}; /* curve_point */

#elif GF_M == 319

const order_t prime_order = {
	 0x0014U, 0x1c6dU, 0xc9acU, 0x4b53U, 0xf808U, 0xd57bU, 0xdc1cU, 0x9b47U,
	 0xc522U, 0x6303U, 0xb6dcU, 0x9b3eU, 0xfdf1U, 0x8291U, 0x1cc9U, 0xdc04U,
	 0x6cfaU, 0xf7c6U, 0x0a47U, 0x7326U, 0x0010U
}; /* prime_order (309 bits) */

const ecPoint curve_point = {
	{0x001dU, 0x0621U, 0x0002U, 0x0535U, 0x06fdU, 0x03eeU, 0x04c5U, 0x05a4U,
	 0x0344U, 0x03c7U, 0x073cU, 0x054cU, 0x0727U, 0x0654U, 0x06f9U, 0x068aU,
	 0x0138U, 0x0489U, 0x04e1U, 0x0701U, 0x02aeU, 0x0274U, 0x01aeU, 0x04ecU,
	 0x064aU, 0x02b9U, 0x025aU, 0x0697U, 0x0371U, 0x0333U},
	{0x001dU, 0x0614U, 0x02f4U, 0x0611U, 0x06ddU, 0x0357U, 0x051cU, 0x030fU,
	 0x07fdU, 0x00ccU, 0x0043U, 0x0566U, 0x010aU, 0x011bU, 0x0119U, 0x04b5U,
	 0x007cU, 0x03cdU, 0x053fU, 0x0063U, 0x013bU, 0x0575U, 0x02a3U, 0x0504U,
	 0x02d6U, 0x01e6U, 0x06d7U, 0x071dU, 0x0022U, 0x0525U}
}; /* curve_point */

#elif GF_M == 322

const order_t prime_order = {
	 0x0014U, 0xa89bU, 0x0ff6U, 0x451fU, 0xc812U, 0xf73fU, 0x12f9U, 0xb532U,
	 0x4e6bU, 0x651bU, 0xc553U, 0x7946U, 0x6799U, 0x2c41U, 0x4075U, 0x5fb5U,
	 0x240cU, 0xdbc3U, 0x1ff1U, 0x296aU, 0x0010U
}; /* prime_order (309 bits) */

const ecPoint curve_point = {
	{0x0017U, 0x0e6fU, 0x3f66U, 0x22e0U, 0x137fU, 0x28f3U, 0x3aa4U, 0x0a83U,
	 0x3791U, 0x3f5bU, 0x3410U, 0x2082U, 0x3e3aU, 0x1f53U, 0x1bc7U, 0x248eU,
	 0x17f8U, 0x3628U, 0x2741U, 0x0a3aU, 0x2b64U, 0x25e1U, 0x1aceU, 0x354dU},
	{0x0017U, 0x3023U, 0x2305U, 0x123bU, 0x2e93U, 0x2462U, 0x3d6dU, 0x1077U,
	 0x0fb6U, 0x1f4fU, 0x379dU, 0x078fU, 0x2123U, 0x1d3cU, 0x0dccU, 0x063eU,
	 0x2069U, 0x0059U, 0x21d1U, 0x237aU, 0x3492U, 0x20f9U, 0x2c32U, 0x3ac9U}
}; /* curve_point */

#elif GF_M == 341

const order_t prime_order = {
	 0x0015U, 0xc86fU, 0xd2f1U, 0x44beU, 0x8078U, 0x27cbU, 0x913dU, 0x3be1U,
	 0xecd6U, 0xe814U, 0xeb6eU, 0x0429U, 0x429aU, 0x29a0U, 0x9a04U, 0xa042U,
	 0x0429U, 0x429aU, 0x29a0U, 0x9a04U, 0xa042U, 0x0429U
}; /* prime_order (331 bits) */

const ecPoint curve_point = {
	{0x001fU, 0x02cdU, 0x0631U, 0x00fdU, 0x060dU, 0x0609U, 0x00d6U, 0x04e9U,
	 0x0758U, 0x0518U, 0x01efU, 0x0388U, 0x00bcU, 0x02d6U, 0x059eU, 0x02cdU,
	 0x0308U, 0x01cbU, 0x0189U, 0x05ffU, 0x059aU, 0x0282U, 0x05d0U, 0x0020U,
	 0x03c4U, 0x00b8U, 0x0601U, 0x02c5U, 0x0652U, 0x06aeU, 0x04f8U, 0x05e5U},
	{0x001fU, 0x05dbU, 0x05c4U, 0x035bU, 0x033dU, 0x00caU, 0x0228U, 0x070bU,
	 0x0246U, 0x07d3U, 0x0573U, 0x05beU, 0x0702U, 0x0702U, 0x01ebU, 0x07a1U,
	 0x02fbU, 0x01cfU, 0x027eU, 0x02d8U, 0x03e2U, 0x067bU, 0x055fU, 0x011dU,
	 0x03d7U, 0x0410U, 0x04ddU, 0x0332U, 0x0235U, 0x0278U, 0x05beU, 0x0152U}
}; /* curve_point */

#elif GF_M == 345

const order_t prime_order = {
	 0x0015U, 0x56c3U, 0x934aU, 0x93d9U, 0x29e1U, 0x0142U, 0x3661U, 0xd250U,
	 0xb553U, 0xc67bU, 0xd487U, 0x3a9bU, 0xb772U, 0x7c0cU, 0x74dfU, 0xbc73U,
	 0x1af9U, 0x657bU, 0x3448U, 0x40a7U, 0x6db2U, 0x0407U
}; /* prime_order (331 bits) */

const ecPoint curve_point = {
	{0x0017U, 0x4a6aU, 0x1ca0U, 0x4752U, 0x785fU, 0x1f4aU, 0x4e52U, 0x17a4U,
	 0x1167U, 0x6fefU, 0x7419U, 0x1af7U, 0x52dfU, 0x4d16U, 0x38b3U, 0x5c09U,
	 0x7e1fU, 0x0d5fU, 0x704dU, 0x3f01U, 0x4f1cU, 0x514bU, 0x2839U, 0x738cU},
	{0x0017U, 0x7e28U, 0x06f6U, 0x45d3U, 0x0d86U, 0x5fbcU, 0x60adU, 0x2acdU,
	 0x29a4U, 0x4f3dU, 0x69c3U, 0x4412U, 0x7dc1U, 0x091aU, 0x7a50U, 0x4a17U,
	 0x7999U, 0x3afdU, 0x262fU, 0x5b54U, 0x7fb6U, 0x43c3U, 0x00a4U, 0x1a05U}
}; /* curve_point */

#elif GF_M == 348

const order_t prime_order = {
	 0x0016U, 0x023dU, 0x1275U, 0xe6c9U, 0x6e8dU, 0x7d6fU, 0xe973U, 0x9703U,
	 0xff9fU, 0xc9ceU, 0xa8e4U, 0x93c2U, 0xd786U, 0x6d47U, 0x0c24U, 0xac04U,
	 0x2f8eU, 0xcc65U, 0xa4eeU, 0xf5e1U, 0x1b51U, 0x0309U, 0x0001U
}; /* prime_order (337 bits) */

const ecPoint curve_point = {
	{0x001dU, 0x0666U, 0x0ed5U, 0x078bU, 0x0542U, 0x00c9U, 0x0b1fU, 0x0117U,
	 0x0abcU, 0x0bccU, 0x0eecU, 0x08c4U, 0x0602U, 0x0ad6U, 0x09a3U, 0x0f35U,
	 0x0f73U, 0x0401U, 0x0b38U, 0x0b81U, 0x05cfU, 0x0991U, 0x0278U, 0x0378U,
	 0x042cU, 0x0cb7U, 0x023eU, 0x0ea3U, 0x06cfU, 0x0cdbU},
	{0x001dU, 0x039aU, 0x0f7dU, 0x066dU, 0x0815U, 0x0013U, 0x0461U, 0x07d8U,
	 0x0745U, 0x062aU, 0x0dbaU, 0x0339U, 0x01e7U, 0x05ecU, 0x059dU, 0x066cU,
	 0x0bdeU, 0x06c3U, 0x0c60U, 0x0e25U, 0x0b02U, 0x08a8U, 0x0719U, 0x09b5U,
	 0x0a12U, 0x0a7dU, 0x0398U, 0x07f7U, 0x0406U, 0x03feU}
}; /* curve_point */

#elif GF_M == 368

const order_t prime_order = {
	 0x0017U, 0x2f33U, 0x6cf8U, 0x9e8cU, 0xc232U, 0x3a50U, 0x5b28U, 0x51ccU,
	 0x3b9eU, 0x9b23U, 0x3612U, 0xc822U, 0x7fa1U, 0x61a3U, 0xe316U, 0xd525U,
	 0x622fU, 0xe4bbU, 0xda14U, 0x70fcU, 0x1122U, 0x5f4aU, 0x009cU, 0x0001U
}; /* prime_order (353 bits) */

const ecPoint curve_point = {
	{0x0017U, 0x38f4U, 0x7ea8U, 0x0d76U, 0x0dc7U, 0x9b57U, 0x38ceU, 0x0c25U,
	 0x90e9U, 0xfe2cU, 0x53f9U, 0xc553U, 0x3824U, 0xe034U, 0x855eU, 0x6ee6U,
	 0x3559U, 0xfb5cU, 0xc78dU, 0x676bU, 0x0789U, 0x397cU, 0x8241U, 0xbdbbU},
	{0x0017U, 0x0a61U, 0x2ff6U, 0xb85eU, 0xc5e0U, 0x0e80U, 0xe205U, 0x01aaU,
	 0xf872U, 0x7cdeU, 0x8017U, 0x99f7U, 0x00b7U, 0x909aU, 0x7db5U, 0x0faeU,
	 0x62caU, 0x58f8U, 0x957fU, 0x376cU, 0xf54eU, 0x97b5U, 0x3065U, 0xe7beU}
}; /* curve_point */

#elif GF_M == 372

const order_t prime_order = {
	 0x0017U, 0x445fU, 0xbf36U, 0xad84U, 0x4b25U, 0xefc2U, 0xac11U, 0x43caU,
	 0xf27aU, 0xc1ceU, 0x4e5bU, 0xe360U, 0x040fU, 0x1041U, 0x4104U, 0x0410U,
	 0x1041U, 0x4104U, 0x0410U, 0x1041U, 0x4104U, 0x0410U, 0x1041U, 0x0104U
}; /* prime_order (361 bits) */

const ecPoint curve_point = {
	{0x001fU, 0x0075U, 0x0a32U, 0x028dU, 0x05e9U, 0x0ba5U, 0x0c77U, 0x0bddU,
	 0x0276U, 0x0452U, 0x05c8U, 0x01adU, 0x0eb0U, 0x081aU, 0x0aa9U, 0x0da3U,
	 0x038aU, 0x027aU, 0x06e9U, 0x01f8U, 0x0fd9U, 0x0d0dU, 0x0cb2U, 0x0430U,
	 0x0aa5U, 0x0345U, 0x013aU, 0x0e54U, 0x0cbcU, 0x0011U, 0x0e54U, 0x04b6U},
	{0x001fU, 0x0e8aU, 0x03f4U, 0x05a7U, 0x0efbU, 0x0180U, 0x09a9U, 0x03b8U,
	 0x0ea8U, 0x023aU, 0x08d0U, 0x083fU, 0x0295U, 0x0b49U, 0x0772U, 0x0f00U,
	 0x08ceU, 0x0c9cU, 0x0a34U, 0x0702U, 0x0817U, 0x0ac4U, 0x07f5U, 0x06afU,
	 0x07ebU, 0x0663U, 0x0311U, 0x0b5eU, 0x08abU, 0x00bbU, 0x0eb6U, 0x0706U}
}; /* curve_point */

#elif GF_M == 377

const order_t prime_order = {
	 0x0017U, 0x3515U, 0xf89cU, 0x0ec0U, 0x36a5U, 0x61a6U, 0x8f45U, 0xb212U,
	 0xdc91U, 0x05c4U, 0x2feaU, 0x7420U, 0xbdb4U, 0x80d1U, 0xd21eU, 0x0953U,
	 0xf5aaU, 0x42cdU, 0x62f2U, 0x5b01U, 0x17b2U, 0xd0fcU, 0x48daU, 0x1022U
}; /* prime_order (365 bits) */

const ecPoint curve_point = {
	{0x001dU, 0x0bc8U, 0x1ecdU, 0x1006U, 0x13a6U, 0x1592U, 0x1beeU, 0x1b41U,
	 0x104bU, 0x083eU, 0x149cU, 0x1d0cU, 0x0157U, 0x1bfeU, 0x0979U, 0x1e4bU,
	 0x1934U, 0x00b6U, 0x0dcdU, 0x1dd6U, 0x0d0fU, 0x1fdcU, 0x1116U, 0x0e18U,
	 0x1119U, 0x0dfdU, 0x1fcdU, 0x0806U, 0x0553U, 0x0809U},
	{0x001dU, 0x0735U, 0x0c2aU, 0x1076U, 0x0540U, 0x01eeU, 0x132fU, 0x1e3aU,
	 0x1003U, 0x0d20U, 0x1d1fU, 0x1c3fU, 0x0171U, 0x0e01U, 0x1c9dU, 0x0fc2U,
	 0x15ddU, 0x11d6U, 0x1315U, 0x13c2U, 0x1ffbU, 0x1e30U, 0x0143U, 0x10b9U,
	 0x1baaU, 0x1e56U, 0x0f5aU, 0x068cU, 0x1216U, 0x06b6U}
}; /* curve_point */

#elif GF_M == 403

const order_t prime_order = {
	 0x0019U, 0xf3f7U, 0x92b7U, 0xd516U, 0x1729U, 0xbd30U, 0xd804U, 0x1150U,
	 0xadc3U, 0x5c30U, 0x6c3dU, 0xfe41U, 0x6213U, 0xd267U, 0xc31eU, 0xf4caU,
	 0x135bU, 0xb004U, 0x72e1U, 0x3991U, 0xb3d6U, 0x2676U, 0x31edU, 0x4cacU,
	 0x35bfU, 0x0041U
}; /* prime_order (391 bits) */

const ecPoint curve_point = {
	{0x001fU, 0x1769U, 0x10b0U, 0x1d14U, 0x1c4cU, 0x051bU, 0x1d01U, 0x1122U,
	 0x0274U, 0x0d03U, 0x03dfU, 0x1f07U, 0x1fe6U, 0x086bU, 0x09b1U, 0x19daU,
	 0x1e24U, 0x0761U, 0x00e3U, 0x01e0U, 0x1600U, 0x1795U, 0x12d7U, 0x13ceU,
	 0x0f88U, 0x075fU, 0x04aaU, 0x0e4aU, 0x12ccU, 0x04f1U, 0x0355U, 0x16b5U},
	{0x001fU, 0x1fb0U, 0x16ceU, 0x0f84U, 0x1c0aU, 0x17b9U, 0x1f51U, 0x1524U,
	 0x00c9U, 0x11edU, 0x002fU, 0x0dd7U, 0x159bU, 0x0ac6U, 0x1e4eU, 0x14a4U,
	 0x04f2U, 0x01a8U, 0x1082U, 0x1a54U, 0x1a64U, 0x0d10U, 0x1492U, 0x1521U,
	 0x0f65U, 0x111eU, 0x0e5fU, 0x05b5U, 0x1592U, 0x0f31U, 0x011aU, 0x0c7dU}
}; /* curve_point */

#elif GF_M == 406

const order_t prime_order = {
	 0x0019U, 0x5cedU, 0x6ac6U, 0xd6d6U, 0xd8ddU, 0xc1d8U, 0x365aU, 0x5150U,
	 0x9d55U, 0x5940U, 0xf7c9U, 0xead1U, 0x583bU, 0xc0ebU, 0xfc10U, 0x07feU,
	 0x73e1U, 0x4e4fU, 0xd477U, 0x5036U, 0x8e88U, 0x7b3dU, 0x2ed5U, 0x146fU,
	 0xef3fU, 0x0103U
}; /* prime_order (393 bits) */

const ecPoint curve_point = {
	{0x001dU, 0x229fU, 0x2701U, 0x3692U, 0x17f3U, 0x0599U, 0x0b3fU, 0x1748U,
	 0x3ac0U, 0x3d0eU, 0x3d87U, 0x0d8bU, 0x19e9U, 0x1142U, 0x3800U, 0x37b2U,
	 0x322bU, 0x0117U, 0x360eU, 0x2f26U, 0x3611U, 0x0069U, 0x1620U, 0x04fdU,
	 0x021cU, 0x181cU, 0x2cdbU, 0x2509U, 0x29e4U, 0x2e2dU},
	{0x001dU, 0x315aU, 0x105dU, 0x16d9U, 0x27ebU, 0x38a2U, 0x3b0eU, 0x38f4U,
	 0x1010U, 0x2935U, 0x3587U, 0x0217U, 0x2ba7U, 0x13b5U, 0x3f67U, 0x1f69U,
	 0x15b9U, 0x1be4U, 0x2b45U, 0x256bU, 0x36f4U, 0x1d11U, 0x36d2U, 0x38a1U,
	 0x34bdU, 0x16e9U, 0x2491U, 0x3acaU, 0x3adbU, 0x0d79U}
}; /* curve_point */

#elif GF_M == 410

const order_t prime_order = {
	 0x001aU, 0xe9f9U, 0x0b54U, 0x2f27U, 0x9a0fU, 0x8a40U, 0xd28eU, 0x183bU,
	 0xeb37U, 0xcf08U, 0x20d5U, 0xf9a9U, 0x446eU, 0x00f6U, 0xf5cdU, 0x65fdU,
	 0x0414U, 0xd734U, 0x97f7U, 0x1051U, 0x5cd0U, 0x5fdfU, 0x4146U, 0x7340U,
	 0x7f7dU, 0x0519U, 0x0001U
}; /* prime_order (401 bits) */

const ecPoint curve_point = {
	{0x0029U, 0x0239U, 0x0312U, 0x0037U, 0x020eU, 0x0368U, 0x0386U, 0x02e8U,
	 0x005eU, 0x0164U, 0x02a5U, 0x0067U, 0x024bU, 0x030cU, 0x003aU, 0x039eU,
	 0x0299U, 0x000cU, 0x0089U, 0x0144U, 0x00ebU, 0x034bU, 0x02eaU, 0x00a3U,
	 0x0354U, 0x0376U, 0x02a5U, 0x0387U, 0x0301U, 0x00e0U, 0x033fU, 0x02d4U,
	 0x02f0U, 0x00e8U, 0x03f6U, 0x0172U, 0x0111U, 0x0069U, 0x0255U, 0x0233U,
	 0x01f6U, 0x0243U},
	{0x0029U, 0x0225U, 0x0287U, 0x02e5U, 0x0060U, 0x0068U, 0x023bU, 0x02a2U,
	 0x00baU, 0x034bU, 0x026aU, 0x0275U, 0x0230U, 0x000fU, 0x00a2U, 0x0289U,
	 0x000dU, 0x0239U, 0x02cbU, 0x0355U, 0x015bU, 0x01b7U, 0x03f0U, 0x03abU,
	 0x013cU, 0x015eU, 0x0309U, 0x0130U, 0x0164U, 0x025cU, 0x030dU, 0x038fU,
	 0x02b7U, 0x0133U, 0x0035U, 0x0007U, 0x0133U, 0x0270U, 0x0013U, 0x00d9U,
	 0x03adU, 0x0313U}
}; /* curve_point */

#elif GF_M == 423

const order_t prime_order = {
	 0x001aU, 0x1db3U, 0x4ea4U, 0x9b32U, 0x2546U, 0x7dcaU, 0xd80eU, 0x9856U,
	 0x2d0dU, 0x7c4bU, 0x8352U, 0x43fbU, 0x92faU, 0xf00dU, 0xf82eU, 0x38abU,
	 0x2521U, 0x32cfU, 0x0fa2U, 0x8ea8U, 0xb5bdU, 0x9a61U, 0xe0bbU, 0xe2afU,
	 0x9484U, 0xcb3cU, 0x3e88U
}; /* prime_order (414 bits) */

const ecPoint curve_point = {
	{0x002fU, 0x0098U, 0x0040U, 0x0094U, 0x004fU, 0x00dbU, 0x011cU, 0x00cfU,
	 0x007fU, 0x0090U, 0x01f1U, 0x0052U, 0x0136U, 0x01faU, 0x00ebU, 0x0126U,
	 0x0144U, 0x0101U, 0x0196U, 0x0188U, 0x0099U, 0x0047U, 0x0193U, 0x0006U,
	 0x01fbU, 0x01a5U, 0x00f9U, 0x0103U, 0x00d6U, 0x012dU, 0x017dU, 0x0059U,
	 0x0021U, 0x013bU, 0x0078U, 0x01aaU, 0x01a9U, 0x00ccU, 0x00ffU, 0x003cU,
	 0x012eU, 0x0129U, 0x019bU, 0x0019U, 0x0126U, 0x00a0U, 0x0086U, 0x0045U},
	{0x002fU, 0x00b6U, 0x00e6U, 0x00baU, 0x014bU, 0x01baU, 0x0066U, 0x016aU,
	 0x01fdU, 0x00a8U, 0x0064U, 0x0008U, 0x0067U, 0x004bU, 0x013cU, 0x00b8U,
	 0x00efU, 0x016fU, 0x0073U, 0x01aaU, 0x019cU, 0x0084U, 0x01bfU, 0x003bU,
	 0x01fbU, 0x0035U, 0x0070U, 0x014cU, 0x0183U, 0x0070U, 0x01d0U, 0x0199U,
	 0x01c0U, 0x0132U, 0x003aU, 0x0013U, 0x0147U, 0x016dU, 0x0130U, 0x00d9U,
	 0x017dU, 0x0151U, 0x0177U, 0x00b3U, 0x00b0U, 0x00b8U, 0x015dU, 0x005eU}
}; /* curve_point */

#elif GF_M == 434

const order_t prime_order = {
	 0x001bU, 0x34e7U, 0xecaeU, 0x49edU, 0xf778U, 0x3859U, 0x5ae9U, 0x8d9eU,
	 0x2bbdU, 0x48ceU, 0x9eccU, 0x141aU, 0x07a0U, 0x2456U, 0x9ccdU, 0xb31cU,
	 0xd1bdU, 0x1e80U, 0x53d2U, 0xaa09U, 0xcdf5U, 0xf242U, 0x0162U, 0xb25bU,
	 0xfc17U, 0xdad0U, 0x2248U, 0x0010U
}; /* prime_order (421 bits) */

const ecPoint curve_point = {
	{0x001fU, 0x39bdU, 0x21d4U, 0x0719U, 0x25e2U, 0x3befU, 0x0c20U, 0x1aa8U,
	 0x2e56U, 0x1ca9U, 0x1cc0U, 0x3687U, 0x12b3U, 0x05ceU, 0x2d91U, 0x1a17U,
	 0x1326U, 0x1256U, 0x0f7dU, 0x023eU, 0x016cU, 0x2fbeU, 0x228aU, 0x2a58U,
	 0x325bU, 0x0ec7U, 0x3c39U, 0x1391U, 0x2a90U, 0x11f1U, 0x1d4cU, 0x07d7U},
	{0x001fU, 0x3f90U, 0x2c3aU, 0x3bb7U, 0x23caU, 0x3ab8U, 0x14b4U, 0x3032U,
	 0x3874U, 0x0ec0U, 0x084fU, 0x2823U, 0x1559U, 0x18f0U, 0x10f0U, 0x3874U,
	 0x038cU, 0x1ce9U, 0x1d03U, 0x0eeeU, 0x05eeU, 0x0979U, 0x3db4U, 0x2a3eU,
	 0x09f8U, 0x099fU, 0x20b6U, 0x195bU, 0x2970U, 0x07ecU, 0x021dU, 0x1ee6U}
}; /* curve_point */

#elif GF_M == 435

const order_t prime_order = {
	 0x001bU, 0xad8dU, 0xfb38U, 0xd72fU, 0x1187U, 0x80e8U, 0x8649U, 0xe221U,
	 0x3dfaU, 0x503dU, 0x74abU, 0x7e1bU, 0xdd62U, 0xe1daU, 0x70daU, 0xc2fbU,
	 0xc69aU, 0xbbdcU, 0xa6c0U, 0xdc86U, 0x2b67U, 0x99c3U, 0x8776U, 0x0d2dU,
	 0x050fU, 0x8fe5U, 0xfd00U, 0x000fU
}; /* prime_order (420 bits) */

const ecPoint curve_point = {
	{0x001dU, 0x7f5dU, 0x1ca9U, 0x1f5dU, 0x7b0dU, 0x692cU, 0x27a8U, 0x56b3U,
	 0x1e9fU, 0x14d1U, 0x0617U, 0x48ffU, 0x4437U, 0x7c89U, 0x1baeU, 0x70dbU,
	 0x26d3U, 0x6134U, 0x3340U, 0x7f61U, 0x7474U, 0x71e3U, 0x0964U, 0x740bU,
	 0x66ddU, 0x0ebfU, 0x525eU, 0x7508U, 0x4b91U, 0x770dU},
	{0x001dU, 0x0b21U, 0x1f3aU, 0x30e6U, 0x70bdU, 0x02baU, 0x1c8bU, 0x7333U,
	 0x1f66U, 0x27a3U, 0x26b1U, 0x2c2eU, 0x5f9bU, 0x500eU, 0x04cfU, 0x3ae6U,
	 0x34fbU, 0x5620U, 0x326fU, 0x5663U, 0x3b2cU, 0x5ebfU, 0x4c6fU, 0x384dU,
	 0x1a7eU, 0x5de5U, 0x7b71U, 0x0f2aU, 0x3198U, 0x695eU}
}; /* curve_point */

#elif GF_M == 451

const order_t prime_order = {
	 0x001cU, 0xeb53U, 0xcd44U, 0xc6aaU, 0x8c4dU, 0x4c1eU, 0x8250U, 0xa8b4U,
	 0x5965U, 0xd0b5U, 0x7c86U, 0xb61aU, 0xce53U, 0x8c42U, 0x7e56U, 0xf648U,
	 0x1cfcU, 0x9f22U, 0xc68eU, 0xbdb2U, 0xea74U, 0xb93eU, 0x91b4U, 0x6eebU,
	 0x498fU, 0xf4e4U, 0x1140U, 0xf7e8U, 0x0002U
}; /* prime_order (434 bits) */

const ecPoint curve_point = {
	{0x0029U, 0x007eU, 0x046cU, 0x0108U, 0x05b1U, 0x012eU, 0x0063U, 0x03b2U,
	 0x0677U, 0x07d5U, 0x05c8U, 0x0777U, 0x00f5U, 0x012bU, 0x0088U, 0x0262U,
	 0x0010U, 0x0415U, 0x056cU, 0x0636U, 0x03ffU, 0x0155U, 0x05fdU, 0x00ecU,
	 0x023bU, 0x0438U, 0x03f7U, 0x00c6U, 0x0155U, 0x07dbU, 0x0368U, 0x04bfU,
	 0x0078U, 0x0678U, 0x0699U, 0x0231U, 0x0723U, 0x0512U, 0x014fU, 0x008aU,
	 0x0219U, 0x0229U},
	{0x0029U, 0x0251U, 0x03d1U, 0x0061U, 0x001dU, 0x032dU, 0x06ecU, 0x0640U,
	 0x006dU, 0x07bdU, 0x0594U, 0x01cbU, 0x074bU, 0x03b5U, 0x0635U, 0x01aaU,
	 0x0478U, 0x0087U, 0x055aU, 0x01a4U, 0x0231U, 0x04cbU, 0x0533U, 0x069aU,
	 0x045dU, 0x02daU, 0x0400U, 0x0224U, 0x0304U, 0x0357U, 0x070fU, 0x017bU,
	 0x0631U, 0x052bU, 0x06c4U, 0x04c6U, 0x04dfU, 0x00fbU, 0x07d7U, 0x07ecU,
	 0x0061U, 0x01efU}
}; /* curve_point */

#elif GF_M == 464

const order_t prime_order = {
	 0x001dU, 0xeb15U, 0x5e0fU, 0xe45aU, 0xd87fU, 0xfda5U, 0xdd99U, 0xbd8aU,
	 0xc433U, 0x517bU, 0xc94cU, 0x7a48U, 0xe95bU, 0x89a2U, 0x6575U, 0xb9ffU,
	 0xa5b5U, 0xc869U, 0xd06bU, 0x2109U, 0x6eb8U, 0xe31bU, 0x87cfU, 0x23f9U,
	 0x4803U, 0xb2caU, 0x905aU, 0x9c19U, 0x0145U, 0x0001U
}; /* prime_order (449 bits) */

const ecPoint curve_point = {
	{0x001dU, 0x3f6cU, 0xeb5eU, 0x4f7cU, 0xe62cU, 0x6e23U, 0xdeb7U, 0xa91fU,
	 0x669eU, 0x842eU, 0xe75eU, 0xe537U, 0x191cU, 0xa01eU, 0x2577U, 0x1296U,
	 0x64d4U, 0xc972U, 0xf6d7U, 0x3c5aU, 0x77bfU, 0x0748U, 0x2c1dU, 0x8797U,
	 0x9a68U, 0x9799U, 0xd75aU, 0x78c2U, 0x6a5aU, 0x97eeU},
	{0x001dU, 0x91e7U, 0x5421U, 0x4679U, 0x2019U, 0xedffU, 0xd4acU, 0x8637U,
	 0x84b4U, 0x611eU, 0x3ee9U, 0x2457U, 0x80faU, 0xdf30U, 0xd2bbU, 0xff8bU,
	 0x08c9U, 0xa554U, 0x43a7U, 0x442dU, 0xd234U, 0x2c55U, 0xcdc1U, 0x8392U,
	 0xf874U, 0xbc18U, 0x2804U, 0xc112U, 0xd399U, 0xecc9U}
}; /* curve_point */

#elif GF_M == 465

const order_t prime_order = {
	 0x001dU, 0xe03bU, 0xe46eU, 0xda7fU, 0x58f5U, 0xd97fU, 0x511eU, 0x09deU,
	 0x73b2U, 0xe2ceU, 0x5b39U, 0x22e1U, 0xb6bbU, 0x8dbcU, 0x8045U, 0x692eU,
	 0x68b5U, 0xbbe8U, 0xb612U, 0x0d87U, 0x1ae7U, 0xa6dfU, 0xa121U, 0xb4bfU,
	 0xc349U, 0x0a90U, 0x688dU, 0x2cf9U, 0x0976U, 0x0004U
}; /* prime_order (451 bits) */

const ecPoint curve_point = {
	{0x001fU, 0x0876U, 0x7acbU, 0x2f5aU, 0x6b6cU, 0x719fU, 0x2275U, 0x03dcU,
	 0x783fU, 0x7ff5U, 0x1a06U, 0x4d51U, 0x4759U, 0x570fU, 0x4d97U, 0x031dU,
	 0x1f2cU, 0x67f0U, 0x3473U, 0x669cU, 0x36f9U, 0x295fU, 0x0108U, 0x0dc0U,
	 0x00c8U, 0x1defU, 0x5399U, 0x02fdU, 0x6cf4U, 0x670bU, 0x778eU, 0x4fcdU},
	{0x001fU, 0x6c94U, 0x6f01U, 0x0e33U, 0x278cU, 0x6010U, 0x3bc5U, 0x2a51U,
	 0x23d0U, 0x6ee9U, 0x48bfU, 0x0848U, 0x7a84U, 0x6e2cU, 0x60b3U, 0x6f69U,
	 0x7d23U, 0x3380U, 0x74a8U, 0x22ceU, 0x4ea0U, 0x729cU, 0x2c17U, 0x70ebU,
	 0x4fd9U, 0x35d7U, 0x1861U, 0x4438U, 0x6fb4U, 0x4dfcU, 0x16f3U, 0x1f57U}
}; /* curve_point */

#elif GF_M == 470

const order_t prime_order = {
	 0x001dU, 0xc2d7U, 0x3119U, 0xcdb1U, 0xecf3U, 0x2d66U, 0x83faU, 0x6199U,
	 0xb55eU, 0x235fU, 0x63f5U, 0x90ecU, 0xfb9eU, 0xc7a3U, 0x086eU, 0x0a6cU,
	 0xa681U, 0x6810U, 0x810aU, 0x10a6U, 0x0a68U, 0xa681U, 0x6810U, 0x810aU,
	 0x10a6U, 0x0a68U, 0xa681U, 0x6810U, 0x810aU, 0x10a6U
}; /* prime_order (461 bits) */

const ecPoint curve_point = {
	{0x002fU, 0x0379U, 0x004bU, 0x0359U, 0x00d6U, 0x027bU, 0x017fU, 0x0135U,
	 0x001aU, 0x013bU, 0x024dU, 0x03acU, 0x01c9U, 0x01a9U, 0x0217U, 0x01dfU,
	 0x0375U, 0x03e7U, 0x02b6U, 0x03b1U, 0x0161U, 0x0166U, 0x0032U, 0x034eU,
	 0x00a8U, 0x0201U, 0x0179U, 0x00f0U, 0x016bU, 0x03bbU, 0x03a0U, 0x0272U,
	 0x01d8U, 0x02a1U, 0x0186U, 0x035bU, 0x002aU, 0x0395U, 0x00e7U, 0x023bU,
	 0x0356U, 0x029bU, 0x019aU, 0x02fcU, 0x03b9U, 0x0067U, 0x01a5U, 0x03b4U},
	{0x002fU, 0x0264U, 0x002fU, 0x0075U, 0x0143U, 0x0384U, 0x010cU, 0x012bU,
	 0x007bU, 0x001eU, 0x0310U, 0x0351U, 0x00f9U, 0x017aU, 0x0048U, 0x0262U,
	 0x016cU, 0x033fU, 0x02e7U, 0x0231U, 0x03b0U, 0x0298U, 0x02a4U, 0x0133U,
	 0x00baU, 0x01afU, 0x0352U, 0x01daU, 0x03f6U, 0x034bU, 0x03ffU, 0x00a2U,
	 0x0050U, 0x003cU, 0x0124U, 0x0081U, 0x02b7U, 0x02a6U, 0x02bdU, 0x003fU,
	 0x01c8U, 0x01d6U, 0x0175U, 0x01d9U, 0x0259U, 0x003fU, 0x0188U, 0x0001U}
}; /* curve_point */

#elif GF_M == 492

const order_t prime_order = {
	 0x001fU, 0x35f9U, 0x5907U, 0x2940U, 0x34b1U, 0x7eacU, 0x5c73U, 0xf0c0U,
	 0x6037U, 0x72a8U, 0xac93U, 0xa88eU, 0x417cU, 0x26a9U, 0x1bdfU, 0xe639U,
	 0x3987U, 0xe761U, 0xd185U, 0x7bdaU, 0x3ac9U, 0x1b62U, 0x0749U, 0xc739U,
	 0x6b05U, 0xb522U, 0xb15dU, 0x155aU, 0x7411U, 0x91f6U, 0x0141U, 0x0001U
}; /* prime_order (481 bits) */

const ecPoint curve_point = {
	{0x0029U, 0x0455U, 0x07c8U, 0x05cdU, 0x00e1U, 0x0919U, 0x0438U, 0x05f4U,
	 0x0dbbU, 0x0ecaU, 0x092dU, 0x0bb1U, 0x0475U, 0x0d53U, 0x0f4eU, 0x0bf5U,
	 0x0842U, 0x078eU, 0x0458U, 0x094fU, 0x043dU, 0x03cfU, 0x09bdU, 0x048dU,
	 0x093aU, 0x0f66U, 0x0034U, 0x08c0U, 0x0dc2U, 0x0806U, 0x0c7fU, 0x0b98U,
	 0x06a2U, 0x00e1U, 0x0947U, 0x0d8eU, 0x06f3U, 0x0d0eU, 0x0c47U, 0x09f7U,
	 0x0347U, 0x0b6aU},
	{0x0029U, 0x021bU, 0x0c1dU, 0x0b4fU, 0x0092U, 0x086eU, 0x0cc8U, 0x00caU,
	 0x0504U, 0x0cf9U, 0x07feU, 0x0122U, 0x0f74U, 0x0f3dU, 0x00dfU, 0x0ba5U,
	 0x02e9U, 0x00c7U, 0x0d4eU, 0x025aU, 0x0604U, 0x0c91U, 0x0ec5U, 0x087bU,
	 0x0965U, 0x0a23U, 0x05fbU, 0x03fcU, 0x0c02U, 0x0670U, 0x0608U, 0x0e29U,
	 0x03faU, 0x0a1dU, 0x0ba7U, 0x0584U, 0x0983U, 0x0394U, 0x0ca1U, 0x0444U,
	 0x0c59U, 0x0752U}
}; /* curve_point */

#elif GF_M == 496

const order_t prime_order = {
	 0x001fU, 0x6d33U, 0x44a9U, 0xfc5cU, 0xacf5U, 0x36fdU, 0xcce9U, 0x3306U,
	 0x4a76U, 0x926dU, 0x9913U, 0x6746U, 0xec24U, 0xce63U, 0xea7fU, 0x1ee3U,
	 0x3d13U, 0x30c3U, 0x6c01U, 0x0557U, 0x2d4dU, 0x6a6cU, 0x2f7aU, 0xebffU,
	 0x174aU, 0x7537U, 0x8ec3U, 0xd20aU, 0x7979U, 0x6953U, 0x00a4U, 0x0001U
}; /* prime_order (481 bits) */

const ecPoint curve_point = {
	{0x001fU, 0xbe65U, 0xaec6U, 0x6f34U, 0xa157U, 0x6f7cU, 0xe28bU, 0x5803U,
	 0x97daU, 0x40e9U, 0xa8b3U, 0x93fbU, 0x0898U, 0x8673U, 0x675aU, 0xc6b6U,
	 0xb79fU, 0x7b14U, 0xc024U, 0xd6edU, 0x1ebeU, 0x50e3U, 0x748fU, 0xee51U,
	 0xcda5U, 0x93f0U, 0x5f50U, 0x03a4U, 0xd710U, 0x200eU, 0x9b1aU, 0xd0dfU},
	{0x001fU, 0xa832U, 0x0cd1U, 0x3edeU, 0xec04U, 0x1c78U, 0x4170U, 0xdef5U,
	 0xe1f2U, 0x56a8U, 0x5cd9U, 0xb200U, 0x5f64U, 0x021aU, 0xbc49U, 0x9ce0U,
	 0x6bc0U, 0x1227U, 0xc9c5U, 0x151cU, 0xd40bU, 0x3ac8U, 0x0784U, 0x47cfU,
	 0x5a0dU, 0x9b11U, 0xce70U, 0x287eU, 0xcaa4U, 0xa22aU, 0x0646U, 0xbb52U}
}; /* curve_point */

#elif GF_M == 517

const order_t prime_order = {
	 0x0020U, 0xe011U, 0xdf0eU, 0x7d1aU, 0x5766U, 0x342dU, 0x2340U, 0xafbeU,
	 0x7141U, 0x6df1U, 0x764fU, 0x167fU, 0x94d9U, 0xfab4U, 0x1fdfU, 0xfbf9U,
	 0xd52eU, 0xdfdaU, 0x6c90U, 0x0720U, 0xbb2cU, 0x0678U, 0xb4c7U, 0xbbdbU,
	 0x3deeU, 0x7cd9U, 0x13caU, 0x8c22U, 0xfe54U, 0xae71U, 0xd360U, 0xc200U,
	 0x0003U
}; /* prime_order (498 bits) */

const ecPoint curve_point = {
	{0x002fU, 0x040cU, 0x064bU, 0x0326U, 0x00c1U, 0x01caU, 0x02dfU, 0x06b9U,
	 0x0171U, 0x06c3U, 0x07f5U, 0x039fU, 0x0568U, 0x00f5U, 0x05a2U, 0x0675U,
	 0x0705U, 0x0661U, 0x0780U, 0x0627U, 0x0419U, 0x00ceU, 0x035eU, 0x0599U,
	 0x02edU, 0x0047U, 0x02c6U, 0x0245U, 0x06e6U, 0x0084U, 0x047aU, 0x01dcU,
	 0x024eU, 0x005aU, 0x035bU, 0x0283U, 0x0625U, 0x0559U, 0x03baU, 0x0068U,
	 0x07e3U, 0x0161U, 0x0776U, 0x00c6U, 0x0443U, 0x0663U, 0x056bU, 0x02cfU},
	{0x002fU, 0x01a4U, 0x02adU, 0x0145U, 0x06e3U, 0x031aU, 0x0511U, 0x02ebU,
	 0x0207U, 0x0366U, 0x00c4U, 0x0013U, 0x0122U, 0x00efU, 0x06caU, 0x05c1U,
	 0x0116U, 0x0395U, 0x0753U, 0x0101U, 0x015eU, 0x00d2U, 0x0761U, 0x0014U,
	 0x0511U, 0x05a7U, 0x0436U, 0x047fU, 0x023fU, 0x0282U, 0x0267U, 0x017aU,
	 0x02e0U, 0x0518U, 0x0445U, 0x0673U, 0x0618U, 0x07f6U, 0x05d7U, 0x0102U,
	 0x009eU, 0x045cU, 0x073bU, 0x0636U, 0x05f4U, 0x0616U, 0x0273U, 0x0654U}
}; /* curve_point */

#elif GF_M == 533

const order_t prime_order = {
	 0x0021U, 0xafa9U, 0x2955U, 0xb234U, 0x8a3bU, 0x57d0U, 0xcd22U, 0xfdafU,
	 0x1553U, 0xdd42U, 0xfa2bU, 0x6170U, 0x88abU, 0xe001U, 0x48f7U, 0xe50fU,
	 0x872bU, 0x0fb1U, 0xc330U, 0xaba5U, 0x06ddU, 0x8565U, 0xfb18U, 0x3300U,
	 0xba5cU, 0x6ddaU, 0x5650U, 0xb188U, 0x300fU, 0xa5c3U, 0xddabU, 0x6506U,
	 0x1885U, 0x00fbU
}; /* prime_order (520 bits) */

const ecPoint curve_point = {
	{0x0029U, 0x1464U, 0x08ddU, 0x09a7U, 0x060dU, 0x13c1U, 0x17d1U, 0x00b4U,
	 0x1d04U, 0x1bc4U, 0x1a95U, 0x04eeU, 0x086fU, 0x16bfU, 0x142bU, 0x1aa5U,
	 0x1b89U, 0x18beU, 0x1677U, 0x05d6U, 0x048dU, 0x045aU, 0x112fU, 0x1d5eU,
	 0x1830U, 0x112fU, 0x0302U, 0x016fU, 0x1296U, 0x130dU, 0x013dU, 0x07ceU,
	 0x0469U, 0x1053U, 0x196bU, 0x046aU, 0x1626U, 0x1bc8U, 0x005bU, 0x1518U,
	 0x0faaU, 0x0ffdU},
	{0x0029U, 0x1575U, 0x1930U, 0x1dc1U, 0x1493U, 0x1e9cU, 0x10ddU, 0x0bcdU,
	 0x0697U, 0x0530U, 0x0802U, 0x0dfdU, 0x0fb7U, 0x0596U, 0x1373U, 0x0b0dU,
	 0x0fe9U, 0x05ddU, 0x10ccU, 0x08bbU, 0x1f7eU, 0x057cU, 0x0aa7U, 0x1483U,
	 0x12b9U, 0x1c18U, 0x103fU, 0x17ccU, 0x0792U, 0x138cU, 0x185eU, 0x1a5bU,
	 0x094fU, 0x0519U, 0x0e51U, 0x1810U, 0x1d56U, 0x1468U, 0x1e82U, 0x08beU,
	 0x065fU, 0x02e7U}
}; /* curve_point */

#elif GF_M == 564

const order_t prime_order = {
	 0x0023U, 0x6483U, 0x9b35U, 0x2e07U, 0xab3aU, 0xa1b2U, 0xb08cU, 0xd4e5U,
	 0x1375U, 0x0011U, 0xef72U, 0xf4afU, 0x5f4fU, 0x0be8U, 0xcbebU, 0x4579U,
	 0x63a7U, 0xcecbU, 0x79b7U, 0xa6ceU, 0x35f5U, 0x858bU, 0x99feU, 0xee81U,
	 0xa848U, 0xb45bU, 0x3c9cU, 0x3e56U, 0x51cdU, 0x520cU, 0xe71dU, 0x304aU,
	 0x2104U, 0x06e6U, 0x4ddcU, 0x00fcU
}; /* prime_order (552 bits) */

const ecPoint curve_point = {
	{0x002fU, 0x0296U, 0x0f47U, 0x0793U, 0x012dU, 0x010bU, 0x07baU, 0x06c2U,
	 0x07cfU, 0x0979U, 0x0c8dU, 0x0b53U, 0x0429U, 0x046fU, 0x09c5U, 0x02c1U,
	 0x07edU, 0x0bb6U, 0x0d67U, 0x0c8aU, 0x091eU, 0x0f8fU, 0x000fU, 0x0c79U,
	 0x081fU, 0x08c3U, 0x0cf7U, 0x0a1aU, 0x077dU, 0x0b56U, 0x041cU, 0x0492U,
	 0x05baU, 0x08a3U, 0x00cfU, 0x0316U, 0x0775U, 0x0d8bU, 0x0f40U, 0x07a9U,
	 0x01b6U, 0x0104U, 0x06c8U, 0x0c5aU, 0x0fb8U, 0x01b4U, 0x0999U, 0x0effU},
	{0x002fU, 0x0d8aU, 0x09b7U, 0x0ef9U, 0x0b22U, 0x04fdU, 0x0d2bU, 0x06f6U,
	 0x08d3U, 0x0a89U, 0x0d2eU, 0x0373U, 0x0dc6U, 0x0934U, 0x07d6U, 0x0e55U,
	 0x0696U, 0x0a43U, 0x0ae6U, 0x0098U, 0x0e09U, 0x01cfU, 0x05b3U, 0x0074U,
	 0x0226U, 0x007dU, 0x01a4U, 0x0bb2U, 0x0826U, 0x094dU, 0x0ffdU, 0x082eU,
	 0x068dU, 0x063cU, 0x0768U, 0x0f81U, 0x0c09U, 0x0f5eU, 0x075dU, 0x0257U,
	 0x0343U, 0x0b10U, 0x02dbU, 0x039cU, 0x0963U, 0x017dU, 0x0f1cU, 0x022dU}
}; /* curve_point */

#elif GF_M == 568

const order_t prime_order = {
	 0x0023U, 0xa413U, 0x94b8U, 0x151aU, 0x0ba9U, 0xdb08U, 0x8f7bU, 0xab37U,
	 0x88b3U, 0x486dU, 0xbd62U, 0xe3afU, 0x0127U, 0xb864U, 0xcbe5U, 0x8a88U,
	 0x015aU, 0x945dU, 0x72e8U, 0xc0edU, 0x3b5cU, 0xd730U, 0xcc0eU, 0x03b5U,
	 0xed73U, 0x5cc0U, 0x303bU, 0x0ed7U, 0xb5ccU, 0x7303U, 0xc0edU, 0x3b5cU,
	 0xd730U, 0xcc0eU, 0x03b5U, 0xed73U
}; /* prime_order (560 bits) */

const ecPoint curve_point = {
	{0x0047U, 0x002cU, 0x00a8U, 0x003aU, 0x005dU, 0x00ddU, 0x0065U, 0x0076U,
	 0x00e5U, 0x0064U, 0x004cU, 0x006bU, 0x00c2U, 0x00ceU, 0x0029U, 0x0005U,
	 0x006bU, 0x00a4U, 0x000fU, 0x0029U, 0x000cU, 0x00f8U, 0x0007U, 0x0058U,
	 0x005eU, 0x0055U, 0x0013U, 0x00a0U, 0x0052U, 0x0078U, 0x00f9U, 0x0067U,
	 0x00d8U, 0x0024U, 0x003bU, 0x003fU, 0x0093U, 0x00bbU, 0x000cU, 0x00c7U,
	 0x008bU, 0x00d1U, 0x0059U, 0x00edU, 0x0099U, 0x0035U, 0x008cU, 0x00fbU,
	 0x0061U, 0x007fU, 0x007bU, 0x00b3U, 0x0096U, 0x0012U, 0x0067U, 0x00f6U,
	 0x0068U, 0x0084U, 0x00daU, 0x009dU, 0x003aU, 0x00b3U, 0x00d7U, 0x0015U,
	 0x00ebU, 0x0028U, 0x00e8U, 0x0036U, 0x0051U, 0x0062U, 0x00bbU, 0x00dbU},
	{0x0047U, 0x00e3U, 0x0016U, 0x00f0U, 0x00dfU, 0x00d3U, 0x00ddU, 0x0047U,
	 0x007dU, 0x009fU, 0x00ecU, 0x005aU, 0x008bU, 0x0061U, 0x0096U, 0x00c2U,
	 0x00bdU, 0x00baU, 0x00feU, 0x00e7U, 0x00d9U, 0x0048U, 0x0067U, 0x00b0U,
	 0x00dcU, 0x003dU, 0x008bU, 0x0011U, 0x00bbU, 0x00b2U, 0x0069U, 0x00d4U,
	 0x0012U, 0x0021U, 0x00fcU, 0x0042U, 0x000aU, 0x0080U, 0x0039U, 0x0016U,
	 0x0043U, 0x00d1U, 0x0098U, 0x0081U, 0x0074U, 0x0021U, 0x00d9U, 0x0092U,
	 0x001fU, 0x00f9U, 0x005cU, 0x00fbU, 0x00beU, 0x0073U, 0x0000U, 0x0048U,
	 0x000bU, 0x0046U, 0x00baU, 0x00f2U, 0x00acU, 0x00fdU, 0x0004U, 0x0035U,
	 0x006bU, 0x008aU, 0x00c4U, 0x0087U, 0x00f3U, 0x00ffU, 0x0086U, 0x0042U}
}; /* curve_point */

#elif GF_M == 574

const order_t prime_order = {
	 0x0023U, 0x9d69U, 0xce66U, 0x355aU, 0x190fU, 0xde7bU, 0x5ecdU, 0xd3a9U,
	 0xff23U, 0x96b6U, 0x72c9U, 0xc93eU, 0xabc1U, 0xa238U, 0xe3d0U, 0xc52dU,
	 0x41e0U, 0xc13fU, 0xae8cU, 0x7277U, 0xe175U, 0x0aecU, 0xd48cU, 0x8418U,
	 0x4fb4U, 0xb189U, 0x7de3U, 0x6293U, 0x4f35U, 0x04f7U, 0xbdb4U, 0x81dcU,
	 0xc723U, 0x50b2U, 0x0aadU, 0xfe43U
}; /* prime_order (560 bits) */

const ecPoint curve_point = {
	{0x0029U, 0x2cf7U, 0x16e0U, 0x0c82U, 0x2809U, 0x07bfU, 0x049fU, 0x161bU,
	 0x0e47U, 0x2da9U, 0x1aa8U, 0x257eU, 0x29e5U, 0x16e2U, 0x1069U, 0x3c84U,
	 0x0111U, 0x1b51U, 0x2e03U, 0x3d76U, 0x37c0U, 0x0d4aU, 0x0e96U, 0x2f36U,
	 0x11e8U, 0x18e1U, 0x352dU, 0x39a1U, 0x0d77U, 0x06bbU, 0x3ad7U, 0x2254U,
	 0x07bdU, 0x193fU, 0x104bU, 0x1439U, 0x3d67U, 0x3a6cU, 0x0ba8U, 0x1b36U,
	 0x0736U, 0x2f63U},
	{0x0029U, 0x2175U, 0x0cb9U, 0x0a12U, 0x3720U, 0x3b60U, 0x2260U, 0x3974U,
	 0x0cf6U, 0x373fU, 0x2aacU, 0x23b6U, 0x026aU, 0x107dU, 0x2c6bU, 0x001fU,
	 0x31efU, 0x04dfU, 0x172aU, 0x0b19U, 0x2342U, 0x3180U, 0x32a2U, 0x1615U,
	 0x0d99U, 0x1842U, 0x025cU, 0x03edU, 0x1a1aU, 0x20e4U, 0x12abU, 0x3dbbU,
	 0x1be5U, 0x18cdU, 0x3b22U, 0x31b9U, 0x1c22U, 0x0cd6U, 0x038dU, 0x1a73U,
	 0x0d50U, 0x312aU}
}; /* curve_point */

#elif GF_M == 611

const order_t prime_order = {
	 0x0026U, 0x2abfU, 0x8517U, 0x7122U, 0x6839U, 0xd3d1U, 0x4a9fU, 0x80d7U,
	 0x122dU, 0xdb9dU, 0x3923U, 0xa03eU, 0x0f93U, 0x975cU, 0x8691U, 0xbc87U,
	 0xd722U, 0x74c6U, 0x9b68U, 0x1fe4U, 0x8040U, 0x0100U, 0x0402U, 0x1008U,
	 0x4020U, 0x0080U, 0x0201U, 0x0804U, 0x2010U, 0x8040U, 0x0100U, 0x0402U,
	 0x1008U, 0x4020U, 0x0080U, 0x0201U, 0x0804U, 0x2010U, 0x0040U
}; /* prime_order (599 bits) */

const ecPoint curve_point = {
	{0x002fU, 0x0a97U, 0x0543U, 0x0a05U, 0x04c5U, 0x0b2eU, 0x1678U, 0x14d3U,
	 0x1da3U, 0x0560U, 0x0a2fU, 0x0f6fU, 0x154fU, 0x1b9fU, 0x0ef7U, 0x110aU,
	 0x1e73U, 0x1009U, 0x0504U, 0x1692U, 0x0143U, 0x1056U, 0x1db5U, 0x11cbU,
	 0x074eU, 0x0fedU, 0x0972U, 0x0174U, 0x0364U, 0x060cU, 0x13e2U, 0x14dfU,
	 0x1ab1U, 0x0576U, 0x15c1U, 0x05ebU, 0x1a44U, 0x10ebU, 0x1e82U, 0x1870U,
	 0x0fe5U, 0x11a6U, 0x0033U, 0x183aU, 0x1b24U, 0x150eU, 0x14acU, 0x0f5cU},
	{0x002fU, 0x0431U, 0x0966U, 0x1a66U, 0x1716U, 0x1af1U, 0x12b1U, 0x1a88U,
	 0x1581U, 0x00b6U, 0x1a9aU, 0x00f7U, 0x0f83U, 0x13aeU, 0x1f50U, 0x092bU,
	 0x0531U, 0x17b7U, 0x1547U, 0x018aU, 0x1454U, 0x04a4U, 0x06c0U, 0x1143U,
	 0x0349U, 0x17f9U, 0x1c1dU, 0x06cbU, 0x1706U, 0x0237U, 0x1e92U, 0x0844U,
	 0x1b2aU, 0x1e94U, 0x05aeU, 0x0f3bU, 0x1f17U, 0x0f89U, 0x0bbeU, 0x0805U,
	 0x125aU, 0x0bf9U, 0x1c68U, 0x1333U, 0x1399U, 0x0ad4U, 0x0fc7U, 0x0cb3U}
}; /* curve_point */

#elif GF_M == 615

const order_t prime_order = {
	 0x0026U, 0x0e49U, 0xc80aU, 0xf59dU, 0x1d22U, 0xc79bU, 0x89d8U, 0x9f9fU,
	 0x50f4U, 0x1e62U, 0x2391U, 0x34fbU, 0x5588U, 0x0f17U, 0x0a1dU, 0x873cU,
	 0x5359U, 0xa847U, 0x3aaaU, 0x105bU, 0xa500U, 0xffdfU, 0x40b5U, 0x9400U,
	 0xff7eU, 0x02d7U, 0x5001U, 0xfdfaU, 0x0b5fU, 0x4004U, 0xf7e9U, 0x2d7fU,
	 0x0010U, 0xdfa5U, 0xb5ffU, 0x0040U, 0x7e94U, 0xd7ffU, 0x0102U
}; /* prime_order (601 bits) */

const ecPoint curve_point = {
	{0x0029U, 0x7380U, 0x1e1bU, 0x58b1U, 0x3cd2U, 0x1c62U, 0x169bU, 0x5cf3U,
	 0x021dU, 0x02e8U, 0x4fc9U, 0x331bU, 0x4797U, 0x3cc2U, 0x4c11U, 0x090eU,
	 0x66beU, 0x3693U, 0x004bU, 0x2c60U, 0x20fcU, 0x5e28U, 0x579aU, 0x12e1U,
	 0x1508U, 0x0b32U, 0x0597U, 0x27eaU, 0x5534U, 0x0d21U, 0x1936U, 0x2fd0U,
	 0x5bf6U, 0x336eU, 0x7773U, 0x6e04U, 0x5e82U, 0x2f17U, 0x58f9U, 0x2740U,
	 0x4b32U, 0x2f02U},
	{0x0029U, 0x0ecdU, 0x41c2U, 0x46d4U, 0x5c38U, 0x142dU, 0x2cb4U, 0x714fU,
	 0x5f28U, 0x1f96U, 0x143eU, 0x5e56U, 0x5817U, 0x0e30U, 0x6db5U, 0x0beaU,
	 0x2e00U, 0x1a26U, 0x5fbfU, 0x4fb6U, 0x6dcdU, 0x463dU, 0x790cU, 0x57ffU,
	 0x2360U, 0x36a0U, 0x504dU, 0x2710U, 0x7ecbU, 0x1c8fU, 0x3203U, 0x3e16U,
	 0x6372U, 0x10b9U, 0x64e5U, 0x0203U, 0x2e7cU, 0x4df5U, 0x2968U, 0x5946U,
	 0x189dU, 0x1d1fU}
}; /* curve_point */

#elif GF_M == 639

const order_t prime_order = {
	 0x0028U, 0x9cabU, 0x5928U, 0x9f6cU, 0x80dfU, 0xec67U, 0x3b0dU, 0x1641U,
	 0xbcf8U, 0x8a72U, 0x9f2fU, 0xd18cU, 0x676dU, 0xbbe8U, 0x8834U, 0xbc40U,
	 0xbf7eU, 0xc0c3U, 0x702fU, 0x3146U, 0x4425U, 0xd720U, 0x2044U, 0x44d7U,
	 0xd720U, 0x2044U, 0x44d7U, 0xd720U, 0x2044U, 0x44d7U, 0xd720U, 0x2044U,
	 0x44d7U, 0xd720U, 0x2044U, 0x44d7U, 0xd720U, 0x2044U, 0x44d7U, 0xd720U,
	 0x0044U
}; /* prime_order (631 bits) */

const ecPoint curve_point = {
	{0x0047U, 0x01d2U, 0x0054U, 0x0176U, 0x0075U, 0x015eU, 0x017dU, 0x00dfU,
	 0x00dcU, 0x00d9U, 0x01d3U, 0x001fU, 0x00fbU, 0x0162U, 0x0116U, 0x00bbU,
	 0x013eU, 0x0137U, 0x013bU, 0x0154U, 0x019dU, 0x01c4U, 0x00f9U, 0x0065U,
	 0x000cU, 0x015eU, 0x0138U, 0x01e1U, 0x018eU, 0x00d0U, 0x01b9U, 0x0135U,
	 0x00c8U, 0x0169U, 0x00fdU, 0x01ceU, 0x013fU, 0x013eU, 0x008eU, 0x01c9U,
	 0x0014U, 0x01bcU, 0x0028U, 0x01abU, 0x00fcU, 0x000cU, 0x009cU, 0x016dU,
	 0x0031U, 0x0109U, 0x0085U, 0x00f7U, 0x00d0U, 0x0140U, 0x0010U, 0x010eU,
	 0x0083U, 0x0098U, 0x0184U, 0x0077U, 0x0182U, 0x0040U, 0x00bcU, 0x0031U,
	 0x0157U, 0x0117U, 0x01ebU, 0x01b7U, 0x01deU, 0x010aU, 0x00efU, 0x01bdU},
	{0x0047U, 0x00e6U, 0x0177U, 0x0001U, 0x00eaU, 0x0137U, 0x01aeU, 0x012bU,
	 0x01fdU, 0x0003U, 0x007fU, 0x00a8U, 0x0082U, 0x003dU, 0x0020U, 0x0047U,
	 0x0171U, 0x008dU, 0x01b5U, 0x0055U, 0x013dU, 0x0007U, 0x0005U, 0x00a0U,
	 0x0051U, 0x0037U, 0x0052U, 0x0112U, 0x0169U, 0x0153U, 0x015fU, 0x01bdU,
	 0x0115U, 0x01c5U, 0x01baU, 0x007dU, 0x01deU, 0x00a2U, 0x00dfU, 0x007cU,
	 0x014aU, 0x0173U, 0x00b8U, 0x00ebU, 0x00e9U, 0x00ebU, 0x0183U, 0x01cdU,
	 0x0098U, 0x01ccU, 0x0155U, 0x01b2U, 0x0053U, 0x00bbU, 0x0027U, 0x0049U,
	 0x0182U, 0x01e6U, 0x0173U, 0x00f9U, 0x016dU, 0x01ddU, 0x01ccU, 0x0069U,
	 0x0108U, 0x004eU, 0x000aU, 0x017eU, 0x00adU, 0x0134U, 0x01ceU, 0x01daU}
}; /* curve_point */

#elif GF_M == 656

const order_t prime_order = {
	 0x0029U, 0xb9c9U, 0x2e71U, 0x79acU, 0x566bU, 0x09ebU, 0x34acU, 0x0ff0U,
	 0xe2cbU, 0x764eU, 0xf762U, 0x916eU, 0xb2aaU, 0x08f0U, 0x6c08U, 0x3bffU,
	 0x66c4U, 0x5e23U, 0x0240U, 0x4051U, 0x0bb0U, 0xaf30U, 0x35b7U, 0x9603U,
	 0x5997U, 0x1617U, 0x7caeU, 0x374aU, 0x53c5U, 0xf196U, 0xe3e5U, 0x0a9aU,
	 0x79d9U, 0x4820U, 0xa894U, 0xb255U, 0xb13bU, 0xc600U, 0xf534U, 0x31f0U,
	 0x01cbU, 0x0001U
}; /* prime_order (641 bits) */

const ecPoint curve_point = {
	{0x0029U, 0xebd3U, 0x9af7U, 0x83ceU, 0x013cU, 0xb0eaU, 0x5c78U, 0x7d18U,
	 0x9b9cU, 0xfc8dU, 0xb350U, 0x3837U, 0x0b1bU, 0xeef9U, 0x9cd6U, 0x7586U,
	 0xb6d7U, 0x44e9U, 0xf094U, 0xf993U, 0xf14eU, 0xa307U, 0x60afU, 0x9aa8U,
	 0x87bcU, 0xad16U, 0x1b42U, 0x1aafU, 0x2112U, 0xdc92U, 0xf898U, 0x846bU,
	 0x14c5U, 0xdba4U, 0x508eU, 0x885aU, 0xbe9aU, 0x73d9U, 0x8d18U, 0xca76U,
	 0x6487U, 0x0185U},
	{0x0029U, 0x1249U, 0xf540U, 0x9d0cU, 0xc31cU, 0xb7edU, 0x4be9U, 0x3228U,
	 0x1d26U, 0x1591U, 0xad27U, 0x48e7U, 0xca77U, 0xb0a2U, 0x3bcbU, 0x6d5fU,
	 0x892dU, 0x709bU, 0xac2bU, 0x7b4bU, 0x2d65U, 0x653aU, 0x2a1eU, 0xd8a4U,
	 0x1580U, 0x8568U, 0x14b0U, 0xc29bU, 0x1183U, 0x98b9U, 0x5588U, 0xb838U,
	 0x2da2U, 0xd52fU, 0x2ca1U, 0xb21dU, 0x8d47U, 0x7ed5U, 0x2c28U, 0x6c02U,
	 0x5336U, 0x537bU}
}; /* curve_point */

#elif GF_M == 657

const order_t prime_order = {
	 0x0029U, 0x2499U, 0x6387U, 0xe069U, 0xa693U, 0x6610U, 0xef76U, 0xd4b4U,
	 0x2ecdU, 0xf5b9U, 0x11ecU, 0xeddaU, 0x03e5U, 0x4539U, 0xf663U, 0x393eU,
	 0xe20dU, 0x3f32U, 0x6a81U, 0x5497U, 0x744aU, 0x135bU, 0x5c81U, 0x8113U,
	 0x135cU, 0x5c81U, 0x8113U, 0x135cU, 0x5c81U, 0x8113U, 0x135cU, 0x5c81U,
	 0x8113U, 0x135cU, 0x5c81U, 0x8113U, 0x135cU, 0x5c81U, 0x8113U, 0x135cU,
	 0x5c81U, 0x0113U
}; /* prime_order (649 bits) */

const ecPoint curve_point = {
	{0x0049U, 0x01bbU, 0x007eU, 0x01d2U, 0x01b9U, 0x0059U, 0x00c9U, 0x0170U,
	 0x003fU, 0x00eaU, 0x01faU, 0x01e8U, 0x01d2U, 0x00b8U, 0x0006U, 0x00b0U,
	 0x00beU, 0x003aU, 0x0081U, 0x001bU, 0x00a2U, 0x0122U, 0x0149U, 0x001eU,
	 0x002bU, 0x0079U, 0x0011U, 0x018cU, 0x0026U, 0x0148U, 0x0015U, 0x0044U,
	 0x01e7U, 0x00f5U, 0x004aU, 0x00dfU, 0x002fU, 0x01f9U, 0x017fU, 0x00d3U,
	 0x0115U, 0x00a6U, 0x00b3U, 0x0167U, 0x00f9U, 0x012fU, 0x00c5U, 0x00ccU,
	 0x0172U, 0x004cU, 0x00c4U, 0x01a2U, 0x0176U, 0x00c5U, 0x000aU, 0x01ecU,
	 0x001aU, 0x009aU, 0x0153U, 0x005eU, 0x015bU, 0x014bU, 0x019bU, 0x009dU,
	 0x019bU, 0x0118U, 0x002dU, 0x017bU, 0x00faU, 0x018aU, 0x01c5U, 0x0057U,
	 0x0098U, 0x00c5U},
	{0x0049U, 0x011bU, 0x0044U, 0x003dU, 0x00d1U, 0x003aU, 0x00f0U, 0x0062U,
	 0x00ebU, 0x0033U, 0x006fU, 0x01b6U, 0x0037U, 0x0003U, 0x011aU, 0x014dU,
	 0x01deU, 0x0125U, 0x0164U, 0x01d0U, 0x0017U, 0x000aU, 0x0094U, 0x017dU,
	 0x01c5U, 0x00beU, 0x0098U, 0x005bU, 0x00cbU, 0x014cU, 0x008bU, 0x0097U,
	 0x0127U, 0x007dU, 0x0106U, 0x0193U, 0x01eeU, 0x01e6U, 0x0015U, 0x01c9U,
	 0x01d6U, 0x0057U, 0x0101U, 0x019cU, 0x00fbU, 0x005cU, 0x018fU, 0x0056U,
	 0x005cU, 0x0064U, 0x0056U, 0x01a3U, 0x00dcU, 0x00d7U, 0x00bdU, 0x010dU,
	 0x01a8U, 0x0153U, 0x0170U, 0x016dU, 0x0123U, 0x008eU, 0x0153U, 0x00e3U,
	 0x0118U, 0x0126U, 0x0185U, 0x0196U, 0x016aU, 0x01bbU, 0x0126U, 0x00a6U,
	 0x012fU, 0x00bcU}
}; /* curve_point */

#elif GF_M == 705

const order_t prime_order = {
	 0x002cU, 0x7327U, 0x3151U, 0x116aU, 0x9422U, 0x2148U, 0x0fe0U, 0x3c83U,
	 0x26f6U, 0x9eafU, 0x42a7U, 0xa6a8U, 0x6af5U, 0xf46dU, 0x05a9U, 0xcbadU,
	 0x8588U, 0x27f3U, 0xfde2U, 0x5a9aU, 0x2879U, 0x7eb5U, 0xef3aU, 0xaa49U,
	 0x6370U, 0xb875U, 0x526fU, 0x3343U, 0xbf12U, 0xb0e6U, 0xc1e7U, 0x4719U,
	 0xda77U, 0x5cd3U, 0x59feU, 0xc3cbU, 0xab3bU, 0x9581U, 0x15faU, 0xaf03U,
	 0x5dc5U, 0x8c0fU, 0x2150U, 0x07cfU, 0x0004U
}; /* prime_order (691 bits) */

const ecPoint curve_point = {
	{0x002fU, 0x1646U, 0x2994U, 0x0170U, 0x3ef9U, 0x438bU, 0x058cU, 0x4236U,
	 0x47a4U, 0x27dcU, 0x057bU, 0x7e76U, 0x57b6U, 0x37cbU, 0x54cfU, 0x6e8dU,
	 0x4ba1U, 0x2723U, 0x1fa0U, 0x744eU, 0x28e8U, 0x523fU, 0x0015U, 0x7843U,
	 0x6383U, 0x4b4fU, 0x7336U, 0x4ba9U, 0x3ff8U, 0x305dU, 0x2036U, 0x7f49U,
	 0x598aU, 0x0b8cU, 0x4b34U, 0x3fd5U, 0x0e77U, 0x2490U, 0x7a48U, 0x26f5U,
	 0x2058U, 0x2871U, 0x0704U, 0x372bU, 0x0fdbU, 0x01fcU, 0x7ea5U, 0x364dU},
	{0x002fU, 0x44d6U, 0x5d84U, 0x2ab7U, 0x4e02U, 0x3d20U, 0x2575U, 0x65c2U,
	 0x6da3U, 0x4458U, 0x5ef0U, 0x145eU, 0x7718U, 0x22f6U, 0x436aU, 0x6c33U,
	 0x7d7eU, 0x0dccU, 0x24fcU, 0x24bfU, 0x778aU, 0x5521U, 0x3042U, 0x62beU,
	 0x312eU, 0x0992U, 0x2457U, 0x7ce9U, 0x4fa6U, 0x559dU, 0x2c9aU, 0x289aU,
	 0x3a4fU, 0x66d6U, 0x2b54U, 0x7242U, 0x7399U, 0x06edU, 0x1458U, 0x34b8U,
	 0x7728U, 0x554cU, 0x250bU, 0x7c61U, 0x59b3U, 0x36cdU, 0x3534U, 0x5011U}
}; /* curve_point */

#elif GF_M == 730

const order_t prime_order = {
	 0x002dU, 0xcfedU, 0xba58U, 0xeb2aU, 0xddddU, 0x07d0U, 0xe317U, 0x483eU,
	 0x29d8U, 0xaf9eU, 0x64d6U, 0x69e6U, 0x7aedU, 0x74d8U, 0xa218U, 0xc3c8U,
	 0x7894U, 0x83c4U, 0x30afU, 0x0b6cU, 0x626dU, 0x783dU, 0x53beU, 0x01e0U,
	 0xd39aU, 0x1882U, 0x8ab8U, 0x5e9eU, 0xf5d7U, 0x2eb8U, 0xf928U, 0x9308U,
	 0x4dd2U, 0x5ed5U, 0x9937U, 0xd958U, 0x6124U, 0xb0acU, 0x2c6fU, 0xd716U,
	 0x337eU, 0xe676U, 0x3212U, 0x4e08U, 0x0423U, 0x0049U
}; /* prime_order (711 bits) */

const ecPoint curve_point = {
	{0x0049U, 0x0127U, 0x02d4U, 0x0166U, 0x035fU, 0x02d6U, 0x0251U, 0x0013U,
	 0x020aU, 0x03e4U, 0x0007U, 0x022dU, 0x0071U, 0x0354U, 0x0041U, 0x027aU,
	 0x0125U, 0x00e1U, 0x00d1U, 0x019dU, 0x02bbU, 0x0192U, 0x035cU, 0x01b4U,
	 0x0145U, 0x00b9U, 0x0262U, 0x0017U, 0x01a2U, 0x0209U, 0x0178U, 0x00bbU,
	 0x0335U, 0x0315U, 0x018aU, 0x0299U, 0x031eU, 0x0359U, 0x001aU, 0x0080U,
	 0x0313U, 0x002aU, 0x02e7U, 0x035aU, 0x031aU, 0x0255U, 0x006cU, 0x0212U,
	 0x0088U, 0x021eU, 0x00d2U, 0x009fU, 0x02e0U, 0x0303U, 0x0317U, 0x02caU,
	 0x014cU, 0x0044U, 0x03ebU, 0x0251U, 0x02b3U, 0x0138U, 0x03bfU, 0x03f0U,
	 0x0139U, 0x033bU, 0x01eeU, 0x013aU, 0x03c4U, 0x0369U, 0x0329U, 0x018fU,
	 0x000dU, 0x0236U},
	{0x0049U, 0x0138U, 0x013bU, 0x010eU, 0x00edU, 0x0051U, 0x024cU, 0x008fU,
	 0x0205U, 0x00bfU, 0x0043U, 0x03e1U, 0x03f3U, 0x0377U, 0x0207U, 0x0164U,
	 0x0315U, 0x0379U, 0x03b7U, 0x0085U, 0x010bU, 0x00e3U, 0x0082U, 0x0066U,
	 0x01feU, 0x038eU, 0x013dU, 0x02d2U, 0x02c0U, 0x00dfU, 0x00c0U, 0x033bU,
	 0x03f5U, 0x00eaU, 0x0097U, 0x037eU, 0x007aU, 0x0057U, 0x0174U, 0x02e7U,
	 0x02ccU, 0x0190U, 0x02aaU, 0x03cbU, 0x00d0U, 0x0143U, 0x03d9U, 0x0175U,
	 0x0164U, 0x02ceU, 0x02fbU, 0x0347U, 0x0133U, 0x020dU, 0x00ebU, 0x0331U,
	 0x009fU, 0x01bcU, 0x0006U, 0x02c7U, 0x03baU, 0x01a4U, 0x00deU, 0x0350U,
	 0x023eU, 0x01ceU, 0x006cU, 0x0169U, 0x01cfU, 0x02cbU, 0x03f7U, 0x00a0U,
	 0x00c5U, 0x0151U}
}; /* curve_point */

#elif GF_M == 752

const order_t prime_order = {
	 0x002fU, 0xce2bU, 0xdd3eU, 0xe0feU, 0x4b37U, 0xce3cU, 0xe78aU, 0x774fU,
	 0x9760U, 0xfb05U, 0x3fd7U, 0x8989U, 0x2dd6U, 0xcd3cU, 0xfc27U, 0x845fU,
	 0xc144U, 0x4bfcU, 0x052aU, 0xbd71U, 0x8454U, 0x4250U, 0x15a4U, 0x7ff1U,
	 0xeef3U, 0x944bU, 0xffbfU, 0x3bcfU, 0xc751U, 0xe0c3U, 0x2039U, 0x0443U,
	 0x1aedU, 0x0010U, 0xb10cU, 0x0e2bU, 0x87cfU, 0x37f1U, 0xbeefU, 0xf944U,
	 0xfffbU, 0x13bcU, 0x3c75U, 0x9e0cU, 0x3203U, 0xd044U, 0x01aeU, 0x0001U
}; /* prime_order (737 bits) */

const ecPoint curve_point = {
	{0x002fU, 0xbbd6U, 0xc102U, 0x81fcU, 0xa350U, 0x0c91U, 0x7bacU, 0x35bfU,
	 0x6f60U, 0x476eU, 0x2694U, 0xd0f2U, 0x5e69U, 0x41b6U, 0xe240U, 0x0199U,
	 0x38fdU, 0x9b51U, 0xa093U, 0xfa0cU, 0x2849U, 0xd943U, 0xaf5eU, 0xb151U,
	 0x3d8fU, 0x35b3U, 0x300fU, 0x84c6U, 0xe0c8U, 0xe394U, 0x546eU, 0x2503U,
	 0xbe81U, 0xb23cU, 0x80e2U, 0x87cbU, 0xb2b4U, 0xa1a7U, 0x71d6U, 0x39c3U,
	 0xe147U, 0xc056U, 0x4263U, 0x85acU, 0x00bdU, 0x02acU, 0xb5ceU, 0xcaadU},
	{0x002fU, 0x6e81U, 0x413dU, 0x8a4cU, 0x424dU, 0x5a53U, 0x5f4bU, 0xd234U,
	 0xa271U, 0x1c83U, 0x978aU, 0xbdecU, 0x1e03U, 0xc481U, 0xb61aU, 0x035dU,
	 0xa7c5U, 0x3e1eU, 0x8dc1U, 0xb19fU, 0xc4d6U, 0xd65fU, 0xe0a0U, 0x137eU,
	 0x754aU, 0xf2e3U, 0x52afU, 0xf2e1U, 0xf484U, 0xbe01U, 0x862fU, 0x8120U,
	 0x822dU, 0x1a81U, 0xc690U, 0xccb1U, 0x054dU, 0xd8c1U, 0xf909U, 0x81a3U,
	 0x2e6fU, 0x0a45U, 0xa311U, 0x7346U, 0x8116U, 0xc0e3U, 0xcd4aU, 0xfc76U}
}; /* curve_point */

#elif GF_M == 781

const order_t prime_order = {
	 0x0031U, 0x7613U, 0xf992U, 0x4488U, 0x3bacU, 0x1de8U, 0x3631U, 0xfda8U,
	 0xd3c0U, 0x8a4fU, 0x3b1cU, 0x20cdU, 0x2459U, 0xb031U, 0x7077U, 0xd53aU,
	 0xc9beU, 0xa65fU, 0x7861U, 0x7e30U, 0xf8a6U, 0xd6b8U, 0x3f71U, 0x1f56U,
	 0xcb15U, 0x6a75U, 0xddd5U, 0x1940U, 0x8929U, 0x202fU, 0xd1f3U, 0x9c78U,
	 0x6af4U, 0x6308U, 0x0fd8U, 0xa660U, 0xd2f0U, 0xa6deU, 0x5823U, 0x9d76U,
	 0x755aU, 0x5037U, 0x4a46U, 0x0be2U, 0x7cc8U, 0x1e34U, 0xbd27U, 0xc21aU,
	 0xf618U, 0x0003U
}; /* prime_order (770 bits) */

const ecPoint curve_point = {
	{0x0047U, 0x04a5U, 0x0682U, 0x018cU, 0x0193U, 0x05b5U, 0x0400U, 0x0253U,
	 0x053bU, 0x01ebU, 0x06edU, 0x0368U, 0x07c3U, 0x025dU, 0x07e4U, 0x00c0U,
	 0x0234U, 0x05cdU, 0x0261U, 0x0459U, 0x04afU, 0x018fU, 0x02e8U, 0x02c7U,
	 0x0019U, 0x02c8U, 0x06efU, 0x0624U, 0x0394U, 0x0685U, 0x063cU, 0x0649U,
	 0x0082U, 0x00abU, 0x0216U, 0x04b9U, 0x06f4U, 0x02baU, 0x0444U, 0x0735U,
	 0x067fU, 0x0592U, 0x03efU, 0x01d0U, 0x0540U, 0x0406U, 0x016fU, 0x0562U,
	 0x05b8U, 0x029aU, 0x008eU, 0x07eeU, 0x035eU, 0x0082U, 0x056aU, 0x0211U,
	 0x03eaU, 0x05beU, 0x06bcU, 0x00edU, 0x0222U, 0x0015U, 0x0442U, 0x051cU,
	 0x050dU, 0x049fU, 0x01cdU, 0x046eU, 0x0157U, 0x0238U, 0x00dfU, 0x010cU},
	{0x0047U, 0x04f0U, 0x0114U, 0x069cU, 0x00cdU, 0x06c8U, 0x06aeU, 0x0644U,
	 0x064aU, 0x0748U, 0x07b5U, 0x0471U, 0x0776U, 0x04ecU, 0x01f3U, 0x00e1U,
	 0x07a7U, 0x0013U, 0x019bU, 0x01cfU, 0x04aaU, 0x05e9U, 0x04b9U, 0x01b2U,
	 0x05d1U, 0x0638U, 0x0211U, 0x074dU, 0x072aU, 0x07d4U, 0x072cU, 0x041bU,
	 0x03b6U, 0x02cbU, 0x023eU, 0x0033U, 0x01f3U, 0x0482U, 0x060eU, 0x0041U,
	 0x07efU, 0x01aaU, 0x04e3U, 0x06a7U, 0x036eU, 0x00a6U, 0x0239U, 0x025cU,
	 0x00c0U, 0x05caU, 0x038eU, 0x00a8U, 0x0410U, 0x0220U, 0x04f6U, 0x07d9U,
	 0x0562U, 0x06e6U, 0x0032U, 0x0070U, 0x0707U, 0x0626U, 0x0028U, 0x0046U,
	 0x0500U, 0x03bdU, 0x064cU, 0x027fU, 0x0110U, 0x0301U, 0x00a9U, 0x02b9U}
}; /* curve_point */

#elif GF_M == 904

const order_t prime_order = {
	 0x0039U, 0x80b1U, 0x81a3U, 0x3280U, 0x35ccU, 0x907bU, 0x11a3U, 0x75caU,
	 0x47afU, 0x3a7eU, 0x72ecU, 0x2d4bU, 0x78c2U, 0xfd0eU, 0x8b50U, 0x562cU,
	 0x0c5cU, 0x2fb7U, 0x4174U, 0xb279U, 0x832fU, 0x58f2U, 0x862cU, 0xf0bfU,
	 0x9eb8U, 0x8885U, 0x0f8fU, 0xf0e5U, 0x0157U, 0xb961U, 0x11a7U, 0x7b96U,
	 0x611aU, 0xa7b9U, 0x9611U, 0x1a7bU, 0xb961U, 0x11a7U, 0x7b96U, 0x611aU,
	 0xa7b9U, 0x9611U, 0x1a7bU, 0xb961U, 0x11a7U, 0x7b96U, 0x611aU, 0xa7b9U,
	 0x9611U, 0x1a7bU, 0xb961U, 0x11a7U, 0x7b96U, 0x611aU, 0xa7b9U, 0x9611U,
	 0x1a7bU, 0x0001U
}; /* prime_order (897 bits) */

const ecPoint curve_point = {
	{0x0071U, 0x0049U, 0x0058U, 0x00cfU, 0x0026U, 0x00f5U, 0x00ddU, 0x0069U,
	 0x00e3U, 0x00fdU, 0x00d1U, 0x00a3U, 0x0098U, 0x007eU, 0x00a5U, 0x0085U,
	 0x007fU, 0x0056U, 0x00c2U, 0x0062U, 0x006aU, 0x009bU, 0x0047U, 0x005cU,
	 0x0037U, 0x0093U, 0x00dfU, 0x0095U, 0x00d2U, 0x008bU, 0x0010U, 0x0090U,
	 0x0061U, 0x0026U, 0x0036U, 0x0048U, 0x008eU, 0x005aU, 0x00d9U, 0x0067U,
	 0x00cfU, 0x0047U, 0x00bbU, 0x008aU, 0x00edU, 0x00e6U, 0x000aU, 0x0094U,
	 0x0040U, 0x00efU, 0x0023U, 0x008bU, 0x00c1U, 0x0071U, 0x0012U, 0x00cbU,
	 0x000bU, 0x002fU, 0x0004U, 0x00dcU, 0x0062U, 0x007dU, 0x00deU, 0x00bfU,
	 0x0086U, 0x008fU, 0x0033U, 0x0022U, 0x00f0U, 0x00beU, 0x00dbU, 0x0048U,
	 0x0001U, 0x0021U, 0x00f7U, 0x00c4U, 0x0055U, 0x0066U, 0x00abU, 0x0030U,
	 0x00feU, 0x0031U, 0x0079U, 0x0047U, 0x00ebU, 0x00f3U, 0x00e1U, 0x00b5U,
	 0x00edU, 0x00d0U, 0x0085U, 0x007cU, 0x00d0U, 0x006fU, 0x0099U, 0x008fU,
	 0x005aU, 0x00b5U, 0x0026U, 0x0052U, 0x0075U, 0x0063U, 0x005eU, 0x00e2U,
	 0x00f7U, 0x00deU, 0x00dbU, 0x00d6U, 0x008dU, 0x006dU, 0x005fU, 0x0067U,
	 0x00fcU, 0x00c3U},
	{0x0071U, 0x00c4U, 0x00ffU, 0x00fdU, 0x0070U, 0x0034U, 0x000dU, 0x0041U,
	 0x00a1U, 0x0051U, 0x0049U, 0x00e4U, 0x0079U, 0x0030U, 0x0047U, 0x00bfU,
	 0x00a5U, 0x0071U, 0x004cU, 0x006fU, 0x0086U, 0x00b2U, 0x00cdU, 0x0028U,
	 0x00bfU, 0x0037U, 0x00c7U, 0x00d1U, 0x000fU, 0x0093U, 0x006eU, 0x0041U,
	 0x0004U, 0x00f7U, 0x000fU, 0x00c8U, 0x00dfU, 0x00f1U, 0x002eU, 0x00e7U,
	 0x0055U, 0x00b6U, 0x0083U, 0x007aU, 0x00fdU, 0x0031U, 0x0043U, 0x008eU,
	 0x00deU, 0x00b7U, 0x0006U, 0x007dU, 0x0057U, 0x000fU, 0x00e9U, 0x0056U,
	 0x005cU, 0x0017U, 0x001aU, 0x0055U, 0x00d3U, 0x0040U, 0x0038U, 0x00ebU,
	 0x00f3U, 0x0097U, 0x00beU, 0x0028U, 0x00e0U, 0x00d6U, 0x0031U, 0x0055U,
	 0x003fU, 0x00e8U, 0x00c4U, 0x005fU, 0x0036U, 0x00afU, 0x005bU, 0x00cbU,
	 0x00b3U, 0x00daU, 0x00ccU, 0x0040U, 0x002cU, 0x000fU, 0x00c1U, 0x0078U,
	 0x00baU, 0x007dU, 0x0086U, 0x00acU, 0x0090U, 0x0012U, 0x0053U, 0x00feU,
	 0x0044U, 0x00a0U, 0x006bU, 0x008aU, 0x0070U, 0x00acU, 0x004eU, 0x0082U,
	 0x00dbU, 0x0002U, 0x0001U, 0x0010U, 0x00f0U, 0x00c6U, 0x00f9U, 0x0064U,
	 0x00bdU, 0x00fdU}
}; /* curve_point */

#elif GF_M == 927

const order_t prime_order = {
	 0x003aU, 0xc467U, 0x6a33U, 0xd774U, 0xde89U, 0x81c2U, 0x5b34U, 0x63a8U,
	 0xcd4bU, 0x6d9bU, 0xbe94U, 0xfaafU, 0x8ce8U, 0x528bU, 0xef9fU, 0x6d07U,
	 0x8073U, 0x2d82U, 0xda84U, 0xe18fU, 0x83cfU, 0xb431U, 0x8a03U, 0x9696U,
	 0x6f98U, 0xa472U, 0x9f56U, 0x27d4U, 0xd21fU, 0x0089U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0040U
}; /* prime_order (919 bits) */

const ecPoint curve_point = {
	{0x0067U, 0x00a3U, 0x018fU, 0x0102U, 0x0015U, 0x00b6U, 0x0130U, 0x00cbU,
	 0x01d3U, 0x0095U, 0x00d0U, 0x0038U, 0x0086U, 0x0073U, 0x0181U, 0x00a6U,
	 0x0083U, 0x00edU, 0x0190U, 0x005aU, 0x0006U, 0x0140U, 0x0104U, 0x0025U,
	 0x019aU, 0x0092U, 0x0037U, 0x009cU, 0x0192U, 0x00a4U, 0x00ebU, 0x0081U,
	 0x008aU, 0x0018U, 0x0122U, 0x0111U, 0x00e7U, 0x01cbU, 0x0040U, 0x000eU,
	 0x0138U, 0x00d9U, 0x01b5U, 0x011fU, 0x00efU, 0x00ddU, 0x00a4U, 0x01e6U,
	 0x00d4U, 0x0190U, 0x01a8U, 0x0100U, 0x01fbU, 0x01a0U, 0x0193U, 0x0115U,
	 0x0081U, 0x01f4U, 0x01eeU, 0x0061U, 0x018cU, 0x01c7U, 0x003bU, 0x008cU,
	 0x0168U, 0x01b4U, 0x00f7U, 0x015eU, 0x0050U, 0x010cU, 0x00cdU, 0x0013U,
	 0x0148U, 0x01deU, 0x004cU, 0x004dU, 0x0007U, 0x0195U, 0x0061U, 0x0130U,
	 0x00a2U, 0x0075U, 0x0198U, 0x0096U, 0x00f3U, 0x005fU, 0x0102U, 0x00c3U,
	 0x01a6U, 0x0062U, 0x0064U, 0x0079U, 0x00c2U, 0x00adU, 0x0102U, 0x0074U,
	 0x0145U, 0x0156U, 0x01fcU, 0x0033U, 0x0126U, 0x01a8U, 0x01fbU, 0x016eU},
	{0x0067U, 0x006cU, 0x0065U, 0x001fU, 0x012fU, 0x00b2U, 0x003fU, 0x0018U,
	 0x01b3U, 0x0179U, 0x013cU, 0x00bdU, 0x000cU, 0x01a5U, 0x015aU, 0x0159U,
	 0x01d3U, 0x008aU, 0x005aU, 0x00ecU, 0x00b3U, 0x0050U, 0x01e5U, 0x0005U,
	 0x0011U, 0x00d4U, 0x003dU, 0x00feU, 0x00b1U, 0x0007U, 0x01a1U, 0x00b3U,
	 0x01c0U, 0x015eU, 0x0015U, 0x0047U, 0x0133U, 0x014bU, 0x0166U, 0x0108U,
	 0x017eU, 0x002dU, 0x0170U, 0x00e1U, 0x01d0U, 0x002cU, 0x006fU, 0x013bU,
	 0x01f2U, 0x00e1U, 0x0000U, 0x00adU, 0x0131U, 0x00aaU, 0x0120U, 0x009bU,
	 0x0013U, 0x0165U, 0x0130U, 0x0086U, 0x018aU, 0x0088U, 0x017cU, 0x0035U,
	 0x011bU, 0x016eU, 0x001cU, 0x00ceU, 0x019cU, 0x0123U, 0x00b3U, 0x0017U,
	 0x00d7U, 0x00efU, 0x003bU, 0x003aU, 0x012aU, 0x004cU, 0x0181U, 0x00caU,
	 0x012fU, 0x0147U, 0x0151U, 0x01faU, 0x002bU, 0x01f5U, 0x00eeU, 0x0135U,
	 0x01cbU, 0x00e3U, 0x0070U, 0x011eU, 0x0065U, 0x01dbU, 0x010bU, 0x013dU,
	 0x001bU, 0x0028U, 0x00eaU, 0x00cbU, 0x01c2U, 0x0111U, 0x0090U, 0x01d7U}
}; /* curve_point */

#elif GF_M == 948

const order_t prime_order = {
	 0x003bU, 0x604fU, 0x7244U, 0x6ffdU, 0xa751U, 0x4ff3U, 0xf208U, 0x7437U,
	 0x65e9U, 0xb652U, 0x04c5U, 0x9b20U, 0xfe04U, 0x8d6dU, 0x0abeU, 0xf130U,
	 0x0027U, 0x141cU, 0x54ceU, 0xc0dfU, 0xb5e0U, 0x4abaU, 0xec77U, 0x715cU,
	 0xba97U, 0xa690U, 0x4bcfU, 0xe356U, 0x7217U, 0x4a14U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0100U
}; /* prime_order (937 bits) */

const ecPoint curve_point = {
	{0x004fU, 0x0569U, 0x0caeU, 0x0fabU, 0x0438U, 0x0981U, 0x0036U, 0x0055U,
	 0x065eU, 0x095bU, 0x0b50U, 0x0a3eU, 0x0a54U, 0x0a31U, 0x0aa2U, 0x04f5U,
	 0x071bU, 0x06a6U, 0x08baU, 0x0877U, 0x0adcU, 0x0848U, 0x0602U, 0x0367U,
	 0x0c29U, 0x06bfU, 0x0c60U, 0x0ff4U, 0x0c81U, 0x025aU, 0x0acdU, 0x07faU,
	 0x0840U, 0x0d0cU, 0x023aU, 0x03d3U, 0x07cbU, 0x0bedU, 0x0cbeU, 0x02f1U,
	 0x01bfU, 0x00feU, 0x02fcU, 0x0c8fU, 0x0886U, 0x0750U, 0x08bbU, 0x0ffdU,
	 0x0d8dU, 0x0b59U, 0x02f2U, 0x0634U, 0x0a89U, 0x0209U, 0x0228U, 0x0604U,
	 0x0d95U, 0x07bdU, 0x083dU, 0x0f3bU, 0x0995U, 0x0223U, 0x02a9U, 0x0780U,
	 0x0321U, 0x037cU, 0x0e13U, 0x019eU, 0x0a9dU, 0x0356U, 0x0339U, 0x00fbU,
	 0x0ffbU, 0x0881U, 0x0f84U, 0x0a7aU, 0x0d4dU, 0x07f4U, 0x0077U, 0x0860U},
	{0x004fU, 0x07e0U, 0x032eU, 0x0414U, 0x022cU, 0x0c98U, 0x0167U, 0x0ef1U,
	 0x0e68U, 0x067eU, 0x0cd7U, 0x0fc8U, 0x00d3U, 0x0f13U, 0x0995U, 0x0e9dU,
	 0x0bd1U, 0x0791U, 0x01a2U, 0x0e93U, 0x002bU, 0x0fc1U, 0x0ce6U, 0x0426U,
	 0x0b1fU, 0x03ddU, 0x0bf9U, 0x08c4U, 0x091bU, 0x0bc4U, 0x087cU, 0x0008U,
	 0x0bc4U, 0x0204U, 0x03ecU, 0x04ddU, 0x0a5eU, 0x08a0U, 0x020cU, 0x02aaU,
	 0x03b5U, 0x0065U, 0x094cU, 0x0fd3U, 0x0fcaU, 0x016bU, 0x0565U, 0x07aeU,
	 0x0c85U, 0x0931U, 0x0b35U, 0x048eU, 0x015eU, 0x0d9cU, 0x00baU, 0x0daaU,
	 0x0b1dU, 0x0e02U, 0x09d3U, 0x0125U, 0x035cU, 0x0e5aU, 0x0506U, 0x0059U,
	 0x0b22U, 0x0d50U, 0x0a31U, 0x02c3U, 0x0f64U, 0x0e46U, 0x09eaU, 0x0f35U,
	 0x0498U, 0x0c5eU, 0x0bb7U, 0x08a7U, 0x0519U, 0x0e13U, 0x026dU, 0x0a88U}
}; /* curve_point */

#elif GF_M == 949

const order_t prime_order = {
	 0x003bU, 0xc249U, 0x06b2U, 0x6d40U, 0xd341U, 0x7f91U, 0x75bcU, 0x0ee8U,
	 0x0fbdU, 0x25bfU, 0xdcc3U, 0xe4d2U, 0xe676U, 0x25b4U, 0x1472U, 0x579bU,
	 0x4407U, 0x5c21U, 0x8576U, 0x382dU, 0x4006U, 0x0285U, 0x2e6bU, 0x2383U,
	 0x03c5U, 0x249cU, 0xf120U, 0x1a93U, 0xeadeU, 0xe724U, 0x040fU, 0x1041U,
	 0x4104U, 0x0410U, 0x1041U, 0x4104U, 0x0410U, 0x1041U, 0x4104U, 0x0410U,
	 0x1041U, 0x4104U, 0x0410U, 0x1041U, 0x4104U, 0x0410U, 0x1041U, 0x4104U,
	 0x0410U, 0x1041U, 0x4104U, 0x0410U, 0x1041U, 0x4104U, 0x0410U, 0x1041U,
	 0x4104U, 0x0410U, 0x1041U, 0x0104U
}; /* prime_order (937 bits) */

const ecPoint curve_point = {
	{0x0049U, 0x1bc7U, 0x1701U, 0x0a18U, 0x11d4U, 0x073cU, 0x1afaU, 0x006dU,
	 0x1ce6U, 0x0535U, 0x10e0U, 0x0a86U, 0x0e9cU, 0x0b2fU, 0x1c19U, 0x0c1bU,
	 0x1958U, 0x1b7cU, 0x1a95U, 0x08bbU, 0x0f2aU, 0x1954U, 0x0a8aU, 0x0a9dU,
	 0x0ae9U, 0x1cd8U, 0x0cd6U, 0x06b1U, 0x0083U, 0x1507U, 0x0f0eU, 0x06e4U,
	 0x1693U, 0x179fU, 0x11cfU, 0x0462U, 0x00b5U, 0x1a3dU, 0x0c3aU, 0x120cU,
	 0x1d2aU, 0x1fdaU, 0x1884U, 0x1ab5U, 0x17a2U, 0x0517U, 0x130cU, 0x15a1U,
	 0x0d34U, 0x0d92U, 0x070cU, 0x19f3U, 0x1bfeU, 0x0e30U, 0x1154U, 0x07d5U,
	 0x0580U, 0x0468U, 0x133fU, 0x0b71U, 0x002eU, 0x037dU, 0x100fU, 0x11eeU,
	 0x1095U, 0x04c3U, 0x1c76U, 0x080dU, 0x14beU, 0x1f4aU, 0x1ba8U, 0x0dcdU,
	 0x1241U, 0x0488U},
	{0x0049U, 0x1c19U, 0x1992U, 0x07ceU, 0x07b5U, 0x1d89U, 0x1c1cU, 0x04e8U,
	 0x1187U, 0x19cbU, 0x1e50U, 0x1b77U, 0x10a5U, 0x116bU, 0x13c3U, 0x1a1fU,
	 0x0469U, 0x03f7U, 0x154dU, 0x0059U, 0x11c9U, 0x17e0U, 0x0aa6U, 0x07adU,
	 0x1287U, 0x0d95U, 0x040bU, 0x1f96U, 0x1c5aU, 0x1088U, 0x1ab7U, 0x1e4bU,
	 0x1223U, 0x1af2U, 0x06f0U, 0x06d5U, 0x04f3U, 0x0963U, 0x1f6dU, 0x03ebU,
	 0x0677U, 0x0b8fU, 0x14c1U, 0x1af7U, 0x0aedU, 0x1278U, 0x04d1U, 0x1b15U,
	 0x1b09U, 0x0defU, 0x1447U, 0x0ca8U, 0x0352U, 0x0438U, 0x0743U, 0x108dU,
	 0x0e37U, 0x0d0fU, 0x10f4U, 0x0b98U, 0x18f5U, 0x17e9U, 0x04bfU, 0x0143U,
	 0x11fcU, 0x0e6aU, 0x0fc2U, 0x0095U, 0x000fU, 0x0e12U, 0x179cU, 0x1559U,
	 0x1ed2U, 0x0417U}
}; /* curve_point */

#elif GF_M == 979

const order_t prime_order = {
	 0x003dU, 0x4873U, 0xeb4fU, 0x7c1fU, 0x1b50U, 0xe95fU, 0x8a92U, 0x5472U,
	 0xfaa2U, 0x8e25U, 0x9cf4U, 0x0725U, 0xc3c4U, 0x9c28U, 0xe793U, 0x11daU,
	 0x1dc2U, 0xe8b0U, 0x386dU, 0x370dU, 0x88efU, 0x0539U, 0x490cU, 0xd006U,
	 0x2ed6U, 0xa44dU, 0xe75bU, 0xac03U, 0x7687U, 0xa951U, 0x2839U, 0xcc78U,
	 0x10fbU, 0xf0fcU, 0x4bcdU, 0x6f93U, 0x12aeU, 0x1461U, 0x37c6U, 0x23beU,
	 0xd7e9U, 0x9d23U, 0x25e6U, 0x1407U, 0x0450U, 0x30b7U, 0xc44aU, 0x62adU,
	 0xb154U, 0x5e58U, 0x8bfaU, 0x53aaU, 0x44a7U, 0xd7faU, 0x519bU, 0x173dU,
	 0xdad0U, 0x70f8U, 0x09f7U, 0xc253U, 0x6d68U, 0x0001U
}; /* prime_order (961 bits) */

const ecPoint curve_point = {
	{0x0059U, 0x0466U, 0x0684U, 0x05dcU, 0x063aU, 0x05a8U, 0x039fU, 0x06adU,
	 0x04d5U, 0x04eaU, 0x04a7U, 0x01cbU, 0x01f9U, 0x021eU, 0x03c3U, 0x0309U,
	 0x0005U, 0x046fU, 0x01ddU, 0x0364U, 0x0188U, 0x0542U, 0x061dU, 0x0406U,
	 0x0139U, 0x0479U, 0x0216U, 0x0446U, 0x049fU, 0x068fU, 0x0737U, 0x0364U,
	 0x0039U, 0x06a1U, 0x0610U, 0x07caU, 0x03edU, 0x05e2U, 0x00afU, 0x0799U,
	 0x0349U, 0x05d1U, 0x03b6U, 0x07c7U, 0x02afU, 0x05deU, 0x060eU, 0x0023U,
	 0x0121U, 0x0467U, 0x0188U, 0x0244U, 0x0335U, 0x03a8U, 0x0483U, 0x011cU,
	 0x0089U, 0x03d8U, 0x0746U, 0x0316U, 0x05d3U, 0x0227U, 0x04b6U, 0x0088U,
	 0x001aU, 0x039aU, 0x002cU, 0x0606U, 0x078eU, 0x0617U, 0x0495U, 0x0084U,
	 0x0148U, 0x06f2U, 0x05d9U, 0x049fU, 0x05e9U, 0x06c0U, 0x0271U, 0x0119U,
	 0x06c8U, 0x04e5U, 0x031dU, 0x0345U, 0x02b3U, 0x065eU, 0x036dU, 0x048aU,
	 0x0409U, 0x06ecU},
	{0x0059U, 0x04d0U, 0x0153U, 0x010fU, 0x0682U, 0x065dU, 0x0513U, 0x04a7U,
	 0x00b5U, 0x03d6U, 0x06a2U, 0x01e8U, 0x03afU, 0x0541U, 0x0438U, 0x0489U,
	 0x0152U, 0x0701U, 0x0593U, 0x0702U, 0x0739U, 0x031eU, 0x0524U, 0x061bU,
	 0x0618U, 0x01a8U, 0x074aU, 0x0349U, 0x0128U, 0x01faU, 0x05a5U, 0x04c4U,
	 0x0551U, 0x0689U, 0x033cU, 0x071eU, 0x01eeU, 0x0540U, 0x066cU, 0x0045U,
	 0x0642U, 0x0297U, 0x06f8U, 0x021cU, 0x0115U, 0x00b7U, 0x0721U, 0x0757U,
	 0x0504U, 0x02d2U, 0x05a6U, 0x02ddU, 0x0759U, 0x05c5U, 0x03ceU, 0x00bbU,
	 0x0598U, 0x04b1U, 0x0504U, 0x017cU, 0x065bU, 0x02eeU, 0x02a4U, 0x0370U,
	 0x044cU, 0x0653U, 0x07c9U, 0x03afU, 0x01caU, 0x022fU, 0x06c9U, 0x0363U,
	 0x05acU, 0x0226U, 0x0334U, 0x053dU, 0x03bfU, 0x07a8U, 0x0252U, 0x0618U,
	 0x0581U, 0x00eeU, 0x05a9U, 0x01b8U, 0x0543U, 0x0769U, 0x0082U, 0x0548U,
	 0x018bU, 0x05a6U}
}; /* curve_point */

#elif GF_M == 994

const order_t prime_order = {
	 0x003eU, 0x304bU, 0x8ffeU, 0xba34U, 0x3d16U, 0x2ce2U, 0x3992U, 0xe23dU,
	 0xbb9bU, 0xf6fcU, 0x7834U, 0x4500U, 0x6414U, 0x5d52U, 0xeb24U, 0x68f7U,
	 0x0cfeU, 0xe532U, 0xc824U, 0xeb39U, 0x7e92U, 0x59e5U, 0x7fefU, 0x78c6U,
	 0x506eU, 0x3618U, 0xf004U, 0xa94fU, 0xd501U, 0xe0f9U, 0x9dc3U, 0x144dU,
	 0x3013U, 0xd11eU, 0x40c4U, 0xcb88U, 0xecfbU, 0xe2c0U, 0x494dU, 0x4b90U,
	 0x6d74U, 0x69d0U, 0x3336U, 0x0030U, 0x02d3U, 0x2a5dU, 0x7b73U, 0x3bbfU,
	 0x8038U, 0x834bU, 0xb16cU, 0x655bU, 0xf05fU, 0x1596U, 0x43d8U, 0xf9a9U,
	 0xa0eaU, 0x6dc4U, 0x6e85U, 0x79d1U, 0x2345U, 0x1112U, 0x0010U
}; /* prime_order (981 bits) */

const ecPoint curve_point = {
	{0x0047U, 0x2338U, 0x373bU, 0x37b2U, 0x2d45U, 0x295eU, 0x3c3dU, 0x0f41U,
	 0x3560U, 0x0005U, 0x0081U, 0x32e3U, 0x3a0fU, 0x0953U, 0x0a1fU, 0x374aU,
	 0x32a6U, 0x20f1U, 0x2140U, 0x2888U, 0x2aa3U, 0x0784U, 0x1843U, 0x1f19U,
	 0x023cU, 0x257dU, 0x3f4aU, 0x1612U, 0x195bU, 0x02daU, 0x2364U, 0x0728U,
	 0x1520U, 0x358aU, 0x3be6U, 0x1a01U, 0x2c2eU, 0x0121U, 0x11e7U, 0x1097U,
	 0x26c4U, 0x36c2U, 0x0ffcU, 0x18fcU, 0x111bU, 0x2c6bU, 0x17d2U, 0x00d9U,
	 0x06ebU, 0x170aU, 0x2114U, 0x17baU, 0x14c7U, 0x0290U, 0x1d92U, 0x38c8U,
	 0x3c02U, 0x24a3U, 0x27a4U, 0x1fd9U, 0x3d39U, 0x0833U, 0x3848U, 0x117fU,
	 0x2df5U, 0x0e4aU, 0x2870U, 0x3fb4U, 0x3676U, 0x189eU, 0x1d11U, 0x08adU},
	{0x0047U, 0x1b9aU, 0x0ad0U, 0x3527U, 0x07a9U, 0x1cb8U, 0x1dbcU, 0x33bdU,
	 0x1952U, 0x185eU, 0x1a87U, 0x3b45U, 0x39cdU, 0x00a2U, 0x205aU, 0x250bU,
	 0x0ff2U, 0x1b27U, 0x06d6U, 0x348bU, 0x14aeU, 0x0eb0U, 0x3f25U, 0x2bd3U,
	 0x1afaU, 0x0671U, 0x360bU, 0x0f8fU, 0x190eU, 0x05d7U, 0x192eU, 0x1a61U,
	 0x043fU, 0x1578U, 0x35b1U, 0x2018U, 0x1198U, 0x363aU, 0x08c7U, 0x33ccU,
	 0x1631U, 0x0ff1U, 0x0fbcU, 0x02deU, 0x1df6U, 0x3dc2U, 0x25a5U, 0x1ae9U,
	 0x2c79U, 0x09faU, 0x1764U, 0x30acU, 0x02a5U, 0x232eU, 0x24d4U, 0x19d8U,
	 0x2a5aU, 0x25a7U, 0x2e72U, 0x0402U, 0x1370U, 0x1cfbU, 0x05b2U, 0x17baU,
	 0x1f7eU, 0x3d1fU, 0x1621U, 0x3724U, 0x06d5U, 0x0112U, 0x2004U, 0x1118U}
}; /* curve_point */

#elif GF_M == 1022

const order_t prime_order = {
	 0x0040U, 0x1ee9U, 0x8634U, 0xbf09U, 0xd9fdU, 0x3339U, 0xefb7U, 0xbcf5U,
	 0x0319U, 0xb752U, 0xb11dU, 0x9e5dU, 0x72a5U, 0xca1eU, 0xc2efU, 0x592cU,
	 0x9c68U, 0xb397U, 0x1015U, 0x9216U, 0x11baU, 0xbd73U, 0xd3ddU, 0xed3cU,
	 0xe215U, 0xdb9bU, 0x6c50U, 0xd8faU, 0x9046U, 0x5140U, 0xb3b4U, 0xb5dbU,
	 0x544dU, 0x03adU, 0xa801U, 0x5451U, 0x03adU, 0xa801U, 0x5451U, 0x03adU,
	 0xa801U, 0x5451U, 0x03adU, 0xa801U, 0x5451U, 0x03adU, 0xa801U, 0x5451U,
	 0x03adU, 0xa801U, 0x5451U, 0x03adU, 0xa801U, 0x5451U, 0x03adU, 0xa801U,
	 0x5451U, 0x03adU, 0xa801U, 0x5451U, 0x03adU, 0xa801U, 0x5451U, 0x03adU,
	 0x0001U
}; /* prime_order (1009 bits) */

const ecPoint curve_point = {
	{0x0049U, 0x3ddbU, 0x066fU, 0x1d9aU, 0x3da1U, 0x1ca3U, 0x2ec2U, 0x0f0bU,
	 0x145aU, 0x0edfU, 0x1651U, 0x0d7fU, 0x26c2U, 0x213aU, 0x16b6U, 0x183aU,
	 0x09abU, 0x1572U, 0x3450U, 0x08a9U, 0x0ff7U, 0x0686U, 0x39c4U, 0x199bU,
	 0x17e8U, 0x1e74U, 0x04cfU, 0x321cU, 0x1b4fU, 0x1067U, 0x2ccbU, 0x0579U,
	 0x0c64U, 0x378dU, 0x06fbU, 0x1c7eU, 0x3246U, 0x2402U, 0x39ecU, 0x0663U,
	 0x3c9bU, 0x208eU, 0x25d7U, 0x0cbeU, 0x22eeU, 0x1c42U, 0x1509U, 0x0f85U,
	 0x23abU, 0x393dU, 0x3780U, 0x19c8U, 0x0d16U, 0x3ceaU, 0x2531U, 0x3ed7U,
	 0x3d32U, 0x03abU, 0x1b03U, 0x3447U, 0x3d9cU, 0x27ddU, 0x299dU, 0x3f4fU,
	 0x20faU, 0x16c1U, 0x30d2U, 0x21edU, 0x16f5U, 0x0c58U, 0x2d8fU, 0x0ca8U,
	 0x207dU, 0x17caU},
	{0x0049U, 0x39f0U, 0x10e5U, 0x052eU, 0x17a2U, 0x1d5bU, 0x1388U, 0x163cU,
	 0x173dU, 0x2845U, 0x1f77U, 0x2120U, 0x289cU, 0x3f7aU, 0x124dU, 0x1bfbU,
	 0x044cU, 0x2bebU, 0x274fU, 0x139aU, 0x288eU, 0x3589U, 0x37e9U, 0x13ccU,
	 0x098eU, 0x0fd5U, 0x1ab0U, 0x08e2U, 0x0438U, 0x2768U, 0x0cb2U, 0x2c24U,
	 0x226eU, 0x37f0U, 0x1757U, 0x2d91U, 0x1f86U, 0x0ffeU, 0x222cU, 0x2cd5U,
	 0x390aU, 0x3d8aU, 0x1816U, 0x2bd6U, 0x181aU, 0x0ec3U, 0x0666U, 0x02c0U,
	 0x35a7U, 0x1fbeU, 0x2eb0U, 0x244bU, 0x0762U, 0x1754U, 0x1842U, 0x24d7U,
	 0x0717U, 0x2c1dU, 0x284dU, 0x1918U, 0x1d10U, 0x2791U, 0x3196U, 0x359bU,
	 0x1073U, 0x153fU, 0x0878U, 0x0ed1U, 0x0a59U, 0x1297U, 0x2e7fU, 0x06f3U,
	 0x3598U, 0x1b6bU}
}; /* curve_point */

#elif GF_M == 1027

const order_t prime_order = {
	 0x0040U, 0x9bdbU, 0xff11U, 0xa14dU, 0xe6ceU, 0x635aU, 0x83f8U, 0xbddfU,
	 0xafd1U, 0xa986U, 0xa061U, 0x69cbU, 0xaf39U, 0xfd8aU, 0xbd68U, 0x0882U,
	 0x0539U, 0xb7faU, 0x3e10U, 0xfe1bU, 0xf5fdU, 0x191dU, 0xa915U, 0x73d7U,
	 0x70d9U, 0xb51bU, 0xcff5U, 0x9407U, 0xdbacU, 0xb308U, 0xec3aU, 0x4bb1U,
	 0xc1d8U, 0xe2f7U, 0x336bU, 0xba9eU, 0xebb3U, 0xd804U, 0x44a4U, 0xfb92U,
	 0x6ba3U, 0x95f5U, 0x1f9dU, 0xa31fU, 0x5892U, 0x9730U, 0x48d3U, 0x87b0U,
	 0x4191U, 0x148bU, 0x3039U, 0x4f78U, 0x663aU, 0xe0a1U, 0x651eU, 0x3b8aU,
	 0xca9cU, 0x0371U, 0x7364U, 0x1996U, 0x5930U, 0x2bcbU, 0xbb1cU, 0xfc2fU,
	 0x003eU
}; /* prime_order (1014 bits) */

const ecPoint curve_point = {
	{0x004fU, 0x0874U, 0x1ee0U, 0x008aU, 0x1d68U, 0x1e01U, 0x1542U, 0x17c0U,
	 0x12a9U, 0x0888U, 0x0df0U, 0x1256U, 0x1e69U, 0x1d7dU, 0x08b5U, 0x075eU,
	 0x0fceU, 0x0460U, 0x0988U, 0x0602U, 0x197fU, 0x1f11U, 0x148aU, 0x1a70U,
	 0x19daU, 0x1525U, 0x0fbbU, 0x11c8U, 0x1d3fU, 0x013aU, 0x11c2U, 0x0be1U,
	 0x045aU, 0x07c1U, 0x027cU, 0x1ebcU, 0x18b7U, 0x14f4U, 0x0df8U, 0x1fdaU,
	 0x0281U, 0x1633U, 0x1369U, 0x01ecU, 0x1f09U, 0x09a9U, 0x0a87U, 0x0b63U,
	 0x1402U, 0x1969U, 0x1e51U, 0x1dbeU, 0x15c0U, 0x0f59U, 0x0fe5U, 0x1cc7U,
	 0x1f33U, 0x0887U, 0x165aU, 0x056dU, 0x0207U, 0x150dU, 0x1991U, 0x0921U,
	 0x1072U, 0x07c1U, 0x0e1cU, 0x195cU, 0x16aaU, 0x1c45U, 0x19a4U, 0x1076U,
	 0x1004U, 0x1f00U, 0x15efU, 0x17f8U, 0x0d3dU, 0x0669U, 0x167dU, 0x0c67U},
	{0x004fU, 0x06ffU, 0x182eU, 0x15ccU, 0x19f1U, 0x094aU, 0x0d04U, 0x164dU,
	 0x1cbfU, 0x05a8U, 0x01a3U, 0x15a9U, 0x0805U, 0x040cU, 0x12f6U, 0x0dd7U,
	 0x19d3U, 0x009cU, 0x087dU, 0x0bdfU, 0x18edU, 0x1369U, 0x09e0U, 0x1966U,
	 0x1565U, 0x0c28U, 0x1034U, 0x150cU, 0x172aU, 0x0815U, 0x0ffcU, 0x154bU,
	 0x150dU, 0x0ae0U, 0x03e6U, 0x1d94U, 0x0055U, 0x0c14U, 0x09c4U, 0x1a47U,
	 0x015aU, 0x16abU, 0x0682U, 0x0df9U, 0x0685U, 0x1b27U, 0x1f22U, 0x0366U,
	 0x0a3aU, 0x0652U, 0x01d2U, 0x0e51U, 0x0bf3U, 0x09e1U, 0x0fa8U, 0x0409U,
	 0x0054U, 0x0aa9U, 0x0d96U, 0x1314U, 0x17d6U, 0x1b01U, 0x1b2fU, 0x0c8fU,
	 0x1f83U, 0x1220U, 0x0c80U, 0x0fcdU, 0x15acU, 0x0b7fU, 0x068fU, 0x09d0U,
	 0x05e3U, 0x0bb7U, 0x16d8U, 0x019cU, 0x06aeU, 0x0018U, 0x1253U, 0x1e94U}
}; /* curve_point */

#elif GF_M == 1067

const order_t prime_order = {
	 0x0042U, 0xc56dU, 0x08feU, 0x4866U, 0x8d55U, 0x4179U, 0x107bU, 0x6021U,
	 0xf8beU, 0x0f77U, 0x5e56U, 0xdc18U, 0x055eU, 0x468cU, 0xdd2fU, 0x7f1dU,
	 0x2396U, 0xf66eU, 0x4d5cU, 0x80d2U, 0x8056U, 0x118eU, 0xbd7cU, 0x0cfcU,
	 0x9169U, 0x0fefU, 0x6cabU, 0x3885U, 0xa1bcU, 0x976aU, 0x08f3U, 0x4db1U,
	 0x1678U, 0xf5dfU, 0x354eU, 0xa059U, 0xd4a0U, 0x46c4U, 0x367eU, 0xb0c7U,
	 0xa0b5U, 0xf34aU, 0xc220U, 0x3f6dU, 0x6a5dU, 0x7d9aU, 0x483fU, 0x213fU,
	 0x7fcbU, 0xf5a1U, 0x4674U, 0xd631U, 0x97b1U, 0xdecfU, 0x818eU, 0x77b8U,
	 0x0d54U, 0xc6c3U, 0x5d49U, 0x15caU, 0x96b1U, 0x7991U, 0xbde1U, 0xd17cU,
	 0xc612U, 0x900eU, 0x00a5U
}; /* prime_order (1048 bits) */

const ecPoint curve_point = {
	{0x0061U, 0x0623U, 0x02b5U, 0x0411U, 0x0093U, 0x0096U, 0x0326U, 0x02b7U,
	 0x055dU, 0x02b3U, 0x04d6U, 0x0623U, 0x02bbU, 0x034aU, 0x00d1U, 0x042bU,
	 0x01f2U, 0x05e1U, 0x04aeU, 0x0336U, 0x07faU, 0x0685U, 0x04aeU, 0x02a3U,
	 0x07bcU, 0x039eU, 0x04a8U, 0x02e8U, 0x032cU, 0x02e5U, 0x00adU, 0x0643U,
	 0x0070U, 0x03d4U, 0x0351U, 0x055dU, 0x038bU, 0x01d1U, 0x072bU, 0x03bcU,
	 0x07c4U, 0x0071U, 0x0772U, 0x0604U, 0x0572U, 0x0032U, 0x0320U, 0x062bU,
	 0x0314U, 0x049dU, 0x0095U, 0x001dU, 0x0590U, 0x0527U, 0x021aU, 0x02d3U,
	 0x01e0U, 0x052fU, 0x0670U, 0x058aU, 0x06eaU, 0x05b4U, 0x040cU, 0x06d1U,
	 0x06f7U, 0x037eU, 0x06c0U, 0x03c5U, 0x0590U, 0x075bU, 0x07a2U, 0x0634U,
	 0x026aU, 0x0739U, 0x0737U, 0x02f2U, 0x009dU, 0x030fU, 0x05edU, 0x07cfU,
	 0x0685U, 0x0459U, 0x04fdU, 0x012eU, 0x0585U, 0x07b0U, 0x0047U, 0x077cU,
	 0x06ebU, 0x06eeU, 0x061cU, 0x075fU, 0x03b3U, 0x0545U, 0x046eU, 0x06c0U,
	 0x0047U, 0x070aU},
	{0x0061U, 0x00f5U, 0x05b3U, 0x047fU, 0x0705U, 0x01a8U, 0x0660U, 0x02daU,
	 0x035bU, 0x01f8U, 0x07faU, 0x0024U, 0x07d6U, 0x07e3U, 0x043dU, 0x03b9U,
	 0x02dcU, 0x069eU, 0x05e0U, 0x0545U, 0x01c9U, 0x01afU, 0x050fU, 0x009dU,
	 0x06f5U, 0x0106U, 0x0222U, 0x019bU, 0x075dU, 0x0491U, 0x065fU, 0x01b3U,
	 0x0239U, 0x0056U, 0x06b9U, 0x05c0U, 0x0367U, 0x03edU, 0x047cU, 0x06abU,
	 0x056eU, 0x039dU, 0x048cU, 0x005bU, 0x0236U, 0x0656U, 0x0065U, 0x0077U,
	 0x07e9U, 0x07bdU, 0x0627U, 0x0718U, 0x01a7U, 0x0015U, 0x07a1U, 0x03a2U,
	 0x03ddU, 0x0673U, 0x0002U, 0x0442U, 0x000eU, 0x072eU, 0x063aU, 0x02dcU,
	 0x056fU, 0x0274U, 0x0287U, 0x029eU, 0x00fcU, 0x0194U, 0x0294U, 0x01ebU,
	 0x0050U, 0x03deU, 0x052fU, 0x067fU, 0x05dfU, 0x02baU, 0x0078U, 0x03a9U,
	 0x0436U, 0x03b4U, 0x009aU, 0x000dU, 0x000dU, 0x001fU, 0x069aU, 0x00c8U,
	 0x03c7U, 0x01f0U, 0x0638U, 0x07c6U, 0x0140U, 0x04e7U, 0x060eU, 0x06a2U,
	 0x06c3U, 0x07b2U}
}; /* curve_point */

#elif GF_M == 1095

const order_t prime_order = {
	 0x0043U, 0x12edU, 0x4b16U, 0x046aU, 0xeee9U, 0x84d4U, 0x3b4cU, 0x201aU,
	 0xb8e0U, 0x2ecaU, 0xa0ccU, 0x9783U, 0xce42U, 0xfab9U, 0x5c9cU, 0x01b5U,
	 0xf93eU, 0xe997U, 0x781dU, 0x3afeU, 0x8992U, 0xa655U, 0xc9f0U, 0x8dddU,
	 0x37c0U, 0xf07fU, 0x3418U, 0x83d6U, 0x3327U, 0x10d3U, 0x2991U, 0x8ca0U,
	 0x77f0U, 0xa2eaU, 0x050fU, 0xc9f2U, 0xe436U, 0xb45dU, 0x2164U, 0x2cc7U,
	 0x7057U, 0x5affU, 0xa68eU, 0x80d2U, 0xc5abU, 0x62b7U, 0x3df7U, 0x3730U,
	 0x36a6U, 0xc7b9U, 0x07d5U, 0xef78U, 0xca5fU, 0xca7eU, 0xa33bU, 0x129bU,
	 0xfb28U, 0x422aU, 0x4d17U, 0xba17U, 0xdad2U, 0xf0f9U, 0x2bf9U, 0x0862U,
	 0x0bd8U, 0xe8a2U, 0x7dbfU, 0x49f3U
}; /* prime_order (1071 bits) */

const ecPoint curve_point = {
	{0x0049U, 0x5852U, 0x14cdU, 0x19b1U, 0x5065U, 0x369eU, 0x15f7U, 0x396bU,
	 0x58f4U, 0x279eU, 0x3ad4U, 0x0e76U, 0x0fd6U, 0x66cbU, 0x05e7U, 0x66acU,
	 0x7a5aU, 0x5c0cU, 0x2077U, 0x3c43U, 0x0659U, 0x7fa4U, 0x3a62U, 0x3a41U,
	 0x3516U, 0x3dcbU, 0x786fU, 0x470cU, 0x6faeU, 0x5070U, 0x0abaU, 0x606eU,
	 0x124cU, 0x5976U, 0x5a46U, 0x3483U, 0x4652U, 0x3c1dU, 0x1310U, 0x0a65U,
	 0x79d0U, 0x55a7U, 0x7364U, 0x2c05U, 0x439fU, 0x0984U, 0x669bU, 0x5c59U,
	 0x41ffU, 0x506dU, 0x07c5U, 0x70ddU, 0x0471U, 0x085aU, 0x3fa5U, 0x4c3aU,
	 0x5489U, 0x3a5cU, 0x66ccU, 0x4314U, 0x462dU, 0x3fb9U, 0x72dcU, 0x6334U,
	 0x4ec8U, 0x3c4eU, 0x2663U, 0x5561U, 0x3d8eU, 0x7d7cU, 0x0d11U, 0x48aeU,
	 0x59f1U, 0x1cb4U},
	{0x0049U, 0x6cb2U, 0x0235U, 0x6cfdU, 0x0200U, 0x6e5aU, 0x2b6eU, 0x3c8cU,
	 0x6522U, 0x0826U, 0x317dU, 0x5ebaU, 0x4a79U, 0x671fU, 0x3997U, 0x1a8fU,
	 0x50d9U, 0x45e1U, 0x57f4U, 0x0ca6U, 0x501bU, 0x3c95U, 0x1817U, 0x1bf2U,
	 0x1515U, 0x0a31U, 0x4eacU, 0x3b02U, 0x7d5cU, 0x0d81U, 0x3a87U, 0x7379U,
	 0x5f59U, 0x2ed6U, 0x64f6U, 0x4648U, 0x1adbU, 0x4a94U, 0x0180U, 0x0f32U,
	 0x6c84U, 0x7506U, 0x1560U, 0x71a0U, 0x342cU, 0x446cU, 0x64b9U, 0x30f4U,
	 0x40f9U, 0x17b0U, 0x6758U, 0x0c53U, 0x1f52U, 0x1e71U, 0x2257U, 0x0d30U,
	 0x259bU, 0x5aa8U, 0x534bU, 0x12f5U, 0x1acaU, 0x7b0eU, 0x4b62U, 0x6cf0U,
	 0x3d1eU, 0x022dU, 0x4ccfU, 0x343bU, 0x2943U, 0x3598U, 0x7a1aU, 0x36b1U,
	 0x481dU, 0x540bU}
}; /* curve_point */

#elif GF_M == 1136

const order_t prime_order = {
	 0x0046U, 0x4417U, 0x217dU, 0xe57fU, 0x4459U, 0xe880U, 0xeb2fU, 0x32ccU,
	 0xed46U, 0xd11dU, 0xd49bU, 0xd2b4U, 0x2bf8U, 0x8adaU, 0x644aU, 0x211fU,
	 0x2d06U, 0xbb62U, 0xc26bU, 0x5a5fU, 0xc6afU, 0x074cU, 0xb242U, 0xc78bU,
	 0xa867U, 0xd59cU, 0xfb21U, 0x7156U, 0xdf5bU, 0xe150U, 0x6e77U, 0xcc9aU,
	 0xbb09U, 0x6539U, 0x3ed4U, 0x2fe9U, 0xa8b6U, 0x2310U, 0x4442U, 0x83f6U,
	 0xc11bU, 0x008fU, 0xb491U, 0x953eU, 0x5a18U, 0x63c4U, 0xa5f7U, 0x3e84U,
	 0x31baU, 0x3d45U, 0x8406U, 0x6364U, 0xd841U, 0x305aU, 0x4affU, 0xfac2U,
	 0xc00bU, 0x39b6U, 0x61c5U, 0x5cd7U, 0x4850U, 0xb87fU, 0x8535U, 0x6ecfU,
	 0xda70U, 0x6055U, 0xc848U, 0xe75aU, 0x995cU, 0x30eaU, 0xff90U
}; /* prime_order (1120 bits) */

const ecPoint curve_point = {
	{0x0047U, 0x4324U, 0xd7b2U, 0x0c5aU, 0x5c48U, 0xf44eU, 0x7a6dU, 0xc291U,
	 0x1a8bU, 0xe1fdU, 0x36c1U, 0xb340U, 0x1639U, 0xa345U, 0x52c4U, 0xf592U,
	 0xbc8fU, 0x0e42U, 0x0b3eU, 0x7fe1U, 0x1d17U, 0xd2deU, 0x5117U, 0xee4fU,
	 0x9146U, 0x8679U, 0x2392U, 0xaea0U, 0x4679U, 0x6b56U, 0x8bd0U, 0x307aU,
	 0xaaafU, 0x7e5eU, 0xa42dU, 0x21daU, 0xec1dU, 0x26d1U, 0x53b8U, 0xb8efU,
	 0x861eU, 0xb36aU, 0x6c09U, 0x7beaU, 0xd904U, 0xd63bU, 0x39aaU, 0x416cU,
	 0x3222U, 0x476dU, 0xe8b9U, 0xab15U, 0xca76U, 0xe148U, 0x984cU, 0x4083U,
	 0x6312U, 0xde90U, 0xe882U, 0xd9cbU, 0x6459U, 0x60fdU, 0xa243U, 0xca24U,
	 0x1578U, 0x25efU, 0x97b5U, 0x43ffU, 0x4d3eU, 0x9278U, 0x6109U, 0x99d5U},
	{0x0047U, 0xbf52U, 0x0455U, 0x54e8U, 0x9522U, 0xaf34U, 0xb50eU, 0xb526U,
	 0x5ca2U, 0xb649U, 0xc0f0U, 0x2812U, 0x4eabU, 0x02b2U, 0x1fd2U, 0x8800U,
	 0x4d4dU, 0x2253U, 0x58a5U, 0x3351U, 0xb88bU, 0xcc64U, 0x5623U, 0x5c4eU,
	 0x497cU, 0x77b5U, 0xf895U, 0x4343U, 0xe0bdU, 0xc74fU, 0x6797U, 0x9e66U,
	 0x9b5fU, 0x14e7U, 0x574aU, 0xa732U, 0x2d5bU, 0x6231U, 0xa6c0U, 0x4001U,
	 0x8b0dU, 0xeac0U, 0x0afaU, 0x853fU, 0xc22eU, 0x285dU, 0x9d17U, 0x1ba7U,
	 0xb783U, 0xa139U, 0x70c4U, 0x5954U, 0xae53U, 0xb779U, 0x9f42U, 0xe2e5U,
	 0xb8f8U, 0x7d42U, 0xf283U, 0x455aU, 0x98a3U, 0xf0c2U, 0xc838U, 0xc496U,
	 0xcce4U, 0xe621U, 0x4451U, 0xd10fU, 0xbcffU, 0x5a6cU, 0x752dU, 0x103eU}
}; /* curve_point */

#elif GF_M == 1168

const order_t prime_order = {
	 0x0049U, 0xe799U, 0xacd3U, 0x25fbU, 0x96c7U, 0x9d13U, 0x03e5U, 0xc2dfU,
	 0xa430U, 0x2e80U, 0x1782U, 0xe483U, 0x74cdU, 0x035dU, 0x5defU, 0x5148U,
	 0x33b3U, 0x4f8eU, 0x31daU, 0x8041U, 0x5718U, 0xe527U, 0xf9d7U, 0x51daU,
	 0x83afU, 0x967eU, 0x0291U, 0x57b4U, 0x208eU, 0x6154U, 0x0cccU, 0x6767U,
	 0x343fU, 0x9efbU, 0x1562U, 0xc85fU, 0x3058U, 0xb611U, 0x96cdU, 0x1997U,
	 0xd5a5U, 0xb237U, 0x84d0U, 0x3876U, 0x0d1aU, 0xc512U, 0x9900U, 0x6d03U,
	 0xe893U, 0x6df4U, 0xc32fU, 0xe3c8U, 0x815bU, 0x6c3aU, 0x5d11U, 0x0bc4U,
	 0xa4b5U, 0xf214U, 0x9f99U, 0x6747U, 0x215eU, 0xa12cU, 0x7e4bU, 0xe5bfU,
	 0xde20U, 0x61b3U, 0xa943U, 0xe806U, 0xd919U, 0x7e73U, 0x34d9U, 0xf1c4U,
	 0x0165U, 0x0001U
}; /* prime_order (1153 bits) */

const ecPoint curve_point = {
	{0x0049U, 0xa8eaU, 0x1fafU, 0x6412U, 0xc14fU, 0x944eU, 0x5c85U, 0xe1aaU,
	 0xe8adU, 0x4de4U, 0x15d3U, 0xac0eU, 0x0eb8U, 0x96b1U, 0x60ddU, 0x9499U,
	 0x4ddaU, 0x9ba3U, 0xffb1U, 0x1b1aU, 0x08ecU, 0xdbaaU, 0x4765U, 0xf54aU,
	 0x6048U, 0x67bfU, 0x57c3U, 0x3a72U, 0x3b0dU, 0x4c8eU, 0x9577U, 0x4370U,
	 0x667bU, 0xcc62U, 0xf55cU, 0x2c94U, 0x132dU, 0x6030U, 0x8964U, 0xd52cU,
	 0x594fU, 0x59ebU, 0x379cU, 0x36ecU, 0x7e39U, 0xe0f4U, 0x27daU, 0xd2bdU,
	 0x8136U, 0x3eaeU, 0x7af0U, 0x3cd7U, 0xef3dU, 0x0a52U, 0xb855U, 0xba3bU,
	 0xf47dU, 0xf82aU, 0x2473U, 0x0b72U, 0x9868U, 0x9fb6U, 0x71f5U, 0xbef6U,
	 0xcaaaU, 0xa728U, 0x0d74U, 0x2932U, 0x10dbU, 0xaadfU, 0xc3dfU, 0x0d21U,
	 0x3a97U, 0xcce9U},
	{0x0049U, 0xaceeU, 0x0531U, 0xc863U, 0x671eU, 0xb5e4U, 0x55a0U, 0x4775U,
	 0x69caU, 0x6393U, 0xab78U, 0x794fU, 0x2840U, 0x15c7U, 0x882aU, 0xb1adU,
	 0x780cU, 0x1118U, 0x3f7dU, 0xd747U, 0xf193U, 0x28b3U, 0xb461U, 0x1617U,
	 0x0b92U, 0x05a8U, 0xd7d4U, 0x6074U, 0x6687U, 0x5649U, 0xa734U, 0x38c8U,
	 0x15f9U, 0x6313U, 0x8268U, 0x289eU, 0x3ff3U, 0xd184U, 0x03d6U, 0x94bfU,
	 0xa277U, 0xdc74U, 0xa69eU, 0x44f3U, 0xa777U, 0x3870U, 0xae99U, 0x5b2aU,
	 0xa0b7U, 0xc8bfU, 0x4240U, 0xd0d7U, 0x670aU, 0xe738U, 0x76b7U, 0x5c6aU,
	 0x3682U, 0xb101U, 0xfdaeU, 0x1b1fU, 0xa918U, 0xff56U, 0x75baU, 0x9f20U,
	 0x526bU, 0x6b2fU, 0x3332U, 0xb605U, 0x7298U, 0xe89cU, 0xee15U, 0xd051U,
	 0x7e6eU, 0xd83cU}
}; /* curve_point */

#elif GF_M == 1185

const order_t prime_order = {
	 0x004aU, 0x2be3U, 0x8f8fU, 0xab9dU, 0x03b0U, 0xe771U, 0x8e4fU, 0xbaf5U,
	 0x83b2U, 0x6870U, 0x61f0U, 0x13b9U, 0xb2d7U, 0x29a1U, 0x3ae6U, 0x2982U,
	 0xb8edU, 0x113aU, 0x2fb3U, 0xb836U, 0xedd8U, 0xad21U, 0xcaebU, 0x53cfU,
	 0x4a5eU, 0x0f9eU, 0xf8eaU, 0x55b6U, 0x92a9U, 0x6d8aU, 0x8990U, 0x0c01U,
	 0x2a13U, 0x2af5U, 0x317cU, 0xc845U, 0x14ddU, 0xd727U, 0x7aabU, 0x819eU,
	 0xce0bU, 0x16baU, 0x3643U, 0x911eU, 0x7888U, 0x6a1aU, 0xcb5fU, 0xf955U,
	 0xf2ebU, 0xac5fU, 0xa45bU, 0x4c2cU, 0x8227U, 0xd3ecU, 0x5765U, 0xfd9cU,
	 0x21f3U, 0xb1b8U, 0xdf25U, 0xd2daU, 0x4ba3U, 0x7c46U, 0x9341U, 0x900cU,
	 0x6cc6U, 0xe8c4U, 0x3cacU, 0xd7aaU, 0x808cU, 0xc249U, 0x9564U, 0xa790U,
	 0x6f72U, 0x0629U, 0x0004U
}; /* prime_order (1171 bits) */

const ecPoint curve_point = {
	{0x004fU, 0x4152U, 0x43c8U, 0x190dU, 0x56e4U, 0x725aU, 0x3815U, 0x1056U,
	 0x00e7U, 0x0b76U, 0x078fU, 0x2ab6U, 0x4b01U, 0x3cc2U, 0x35f0U, 0x011cU,
	 0x1ad8U, 0x1533U, 0x6ba2U, 0x7a51U, 0x1654U, 0x48a8U, 0x0432U, 0x556bU,
	 0x680cU, 0x4077U, 0x5194U, 0x44b7U, 0x6084U, 0x4ea6U, 0x7660U, 0x7929U,
	 0x757bU, 0x456bU, 0x7388U, 0x41a2U, 0x4875U, 0x2b64U, 0x6deeU, 0x0701U,
	 0x31fcU, 0x537fU, 0x00b1U, 0x695fU, 0x31c3U, 0x7654U, 0x7bfaU, 0x43a3U,
	 0x6ec4U, 0x732eU, 0x25d9U, 0x296fU, 0x7d5fU, 0x6a99U, 0x1001U, 0x105cU,
	 0x3e50U, 0x3a47U, 0x1997U, 0x2c33U, 0x450cU, 0x24b5U, 0x1018U, 0x3625U,
	 0x68b3U, 0x19ccU, 0x0b9fU, 0x0c15U, 0x5a0aU, 0x2307U, 0x24baU, 0x535cU,
	 0x600eU, 0x687fU, 0x0cc9U, 0x4f04U, 0x439cU, 0x72baU, 0x243aU, 0x19f1U},
	{0x004fU, 0x12b8U, 0x3197U, 0x6312U, 0x73c7U, 0x2142U, 0x2a5cU, 0x5c04U,
	 0x6d55U, 0x6b64U, 0x5932U, 0x343cU, 0x1145U, 0x2759U, 0x06c2U, 0x6901U,
	 0x25e7U, 0x1a11U, 0x6bf4U, 0x7540U, 0x37b0U, 0x7c37U, 0x5d35U, 0x379dU,
	 0x421cU, 0x5464U, 0x0aafU, 0x2a6fU, 0x673aU, 0x337eU, 0x6102U, 0x3110U,
	 0x0413U, 0x20d8U, 0x3842U, 0x0bf3U, 0x34a3U, 0x6886U, 0x3575U, 0x138dU,
	 0x056fU, 0x44f8U, 0x6c15U, 0x3159U, 0x1aecU, 0x1aebU, 0x1aaaU, 0x41cdU,
	 0x5a47U, 0x1f3cU, 0x3480U, 0x4260U, 0x6964U, 0x4d8fU, 0x7a3aU, 0x3ecaU,
	 0x210cU, 0x64afU, 0x311cU, 0x549fU, 0x479eU, 0x69c3U, 0x72edU, 0x2470U,
	 0x795aU, 0x2c84U, 0x3ef5U, 0x3facU, 0x445bU, 0x3eb0U, 0x5485U, 0x45eaU,
	 0x726bU, 0x16daU, 0x6c89U, 0x4691U, 0x7d83U, 0x208bU, 0x1d42U, 0x60dcU}
}; /* curve_point */

#elif GF_M == 1236

const order_t prime_order = {
	 0x004dU, 0x14f7U, 0xc5f4U, 0x5595U, 0xa399U, 0x104cU, 0x3721U, 0xc1fdU,
	 0xbb44U, 0xb4fcU, 0x470cU, 0xdf56U, 0x8a3cU, 0x88bcU, 0x753aU, 0xc9fcU,
	 0xeb49U, 0x9923U, 0x2453U, 0xd1a8U, 0x62a2U, 0x70c7U, 0x55ecU, 0x6f84U,
	 0x9e2aU, 0x5ce0U, 0xc7a2U, 0x216bU, 0xb0c2U, 0xe831U, 0xb64dU, 0xf540U,
	 0x74a0U, 0xe9f2U, 0x6e90U, 0x5f4bU, 0x87f2U, 0xc0a3U, 0x0137U, 0x051aU,
	 0xcd01U, 0xfdf5U, 0x1465U, 0x3404U, 0xf7d7U, 0x5197U, 0xd010U, 0xdf5cU,
	 0x465fU, 0x4041U, 0x7d73U, 0x197fU, 0x0105U, 0xf5cdU, 0x65fdU, 0x0414U,
	 0xd734U, 0x97f7U, 0x1051U, 0x5cd0U, 0x5fdfU, 0x4146U, 0x7340U, 0x7f7dU,
	 0x0519U, 0xcd01U, 0xfdf5U, 0x1465U, 0x3404U, 0xf7d7U, 0x5197U, 0xd010U,
	 0xdf5cU, 0x465fU, 0x4041U, 0x7d73U, 0x197fU, 0x0105U
}; /* prime_order (1225 bits) */

const ecPoint curve_point = {
	{0x0067U, 0x00d0U, 0x0e1fU, 0x003aU, 0x023cU, 0x0718U, 0x01d7U, 0x0656U,
	 0x0ca8U, 0x05b7U, 0x0212U, 0x0cdbU, 0x060eU, 0x088fU, 0x0a57U, 0x01a4U,
	 0x0e23U, 0x05aaU, 0x09a3U, 0x09c6U, 0x0f2bU, 0x0f8dU, 0x0cdaU, 0x064aU,
	 0x0787U, 0x03cbU, 0x09f6U, 0x02acU, 0x0667U, 0x07ebU, 0x0c93U, 0x03e1U,
	 0x05c7U, 0x0185U, 0x0564U, 0x0e94U, 0x0f30U, 0x0367U, 0x0196U, 0x049cU,
	 0x083bU, 0x0dc0U, 0x0028U, 0x0e02U, 0x0fa6U, 0x0aaaU, 0x0029U, 0x0df5U,
	 0x0ad1U, 0x018fU, 0x0220U, 0x0db2U, 0x0788U, 0x0ec4U, 0x0771U, 0x0102U,
	 0x0bbfU, 0x0722U, 0x031bU, 0x03b9U, 0x0284U, 0x0e90U, 0x0486U, 0x0cf9U,
	 0x0793U, 0x018aU, 0x0814U, 0x07f9U, 0x0b31U, 0x0bc6U, 0x0c0dU, 0x037eU,
	 0x05f5U, 0x09e8U, 0x0f00U, 0x0783U, 0x055fU, 0x0c11U, 0x06c8U, 0x0e30U,
	 0x0cc0U, 0x09beU, 0x0165U, 0x0360U, 0x03f9U, 0x0857U, 0x0e26U, 0x0c5dU,
	 0x03d9U, 0x0f12U, 0x02daU, 0x0da4U, 0x0165U, 0x01d1U, 0x01efU, 0x005aU,
	 0x0d9cU, 0x0e26U, 0x0b35U, 0x09ddU, 0x094aU, 0x0acaU, 0x0c53U, 0x07f1U},
	{0x0067U, 0x03f3U, 0x0e6cU, 0x05e4U, 0x07a3U, 0x006bU, 0x092bU, 0x0567U,
	 0x0341U, 0x08d3U, 0x0aa1U, 0x0411U, 0x006eU, 0x089cU, 0x00f8U, 0x0556U,
	 0x0fc2U, 0x0441U, 0x046eU, 0x0d22U, 0x0ae1U, 0x05c0U, 0x0972U, 0x0097U,
	 0x0679U, 0x0ef8U, 0x036dU, 0x0097U, 0x093dU, 0x033aU, 0x0e83U, 0x0d69U,
	 0x0d98U, 0x0e96U, 0x0b78U, 0x0d40U, 0x0118U, 0x0c2fU, 0x0f87U, 0x09d8U,
	 0x0ee6U, 0x05bbU, 0x0917U, 0x00fcU, 0x0a67U, 0x0773U, 0x01acU, 0x058eU,
	 0x0cabU, 0x06f9U, 0x0b70U, 0x045bU, 0x0c54U, 0x0f3fU, 0x038cU, 0x078aU,
	 0x02b6U, 0x089bU, 0x01f2U, 0x0814U, 0x0e48U, 0x057aU, 0x0fe3U, 0x04c2U,
	 0x0c4fU, 0x0cc9U, 0x0feaU, 0x0f3bU, 0x02caU, 0x075cU, 0x08c3U, 0x0230U,
	 0x084eU, 0x0552U, 0x0c4eU, 0x0497U, 0x096cU, 0x0b16U, 0x0433U, 0x0738U,
	 0x030bU, 0x03ebU, 0x0371U, 0x063aU, 0x0bb4U, 0x0df2U, 0x08b5U, 0x0546U,
	 0x0375U, 0x0361U, 0x0732U, 0x0a4eU, 0x07ddU, 0x0c8aU, 0x05deU, 0x0017U,
	 0x0d65U, 0x0749U, 0x0590U, 0x0687U, 0x06d3U, 0x02f6U, 0x06d1U, 0x0b1dU}
}; /* curve_point */

#elif GF_M == 1246

const order_t prime_order = {
	 0x004dU, 0xa809U, 0x286cU, 0x3654U, 0x878eU, 0x21ffU, 0xcb7fU, 0xe1f3U,
	 0x3b0cU, 0x8504U, 0x54adU, 0xa76eU, 0x5f27U, 0x6a29U, 0x72b2U, 0x4284U,
	 0x3b1fU, 0xfcf0U, 0xe2e3U, 0x48e3U, 0xaaa1U, 0x02e0U, 0x781dU, 0x38fcU,
	 0x7b9fU, 0xc789U, 0x868aU, 0x665aU, 0xe074U, 0x51dfU, 0xc84fU, 0x7694U,
	 0xe682U, 0x81dcU, 0x3c01U, 0x942eU, 0xbd89U, 0x0899U, 0x9eb3U, 0x26f5U,
	 0xe9faU, 0x5955U, 0x108cU, 0x9ff2U, 0x72d7U, 0x014eU, 0x3bc9U, 0xe0a5U,
	 0x6527U, 0xf082U, 0x8442U, 0x73c6U, 0x99b9U, 0x2563U, 0x969dU, 0x7ea9U,
	 0xe144U, 0x2019U, 0xe194U, 0xfd92U, 0xda1cU, 0x3a3aU, 0x8d48U, 0x8a7bU,
	 0xc13aU, 0x046aU, 0xe283U, 0x95fdU, 0xc3b7U, 0xf032U, 0xa6c9U, 0x7b3dU,
	 0x5d11U, 0x7238U, 0x465cU, 0x4ab7U, 0x6755U, 0xfed1U
}; /* prime_order (1232 bits) */

const ecPoint curve_point = {
	{0x0059U, 0x172dU, 0x0153U, 0x118fU, 0x0566U, 0x0985U, 0x0f4cU, 0x3da3U,
	 0x05caU, 0x1967U, 0x34c6U, 0x1c9dU, 0x0ab4U, 0x2c1dU, 0x2653U, 0x18e9U,
	 0x15caU, 0x2c1dU, 0x0c47U, 0x179eU, 0x0291U, 0x3a15U, 0x0122U, 0x3634U,
	 0x0d75U, 0x26efU, 0x20d8U, 0x3eb2U, 0x3261U, 0x130bU, 0x11e1U, 0x189eU,
	 0x1c54U, 0x0eecU, 0x1a2eU, 0x07a0U, 0x3684U, 0x3c4cU, 0x0cd3U, 0x0e60U,
	 0x32b5U, 0x1cebU, 0x295cU, 0x1669U, 0x2776U, 0x31dfU, 0x137bU, 0x0384U,
	 0x129bU, 0x1e3eU, 0x0f12U, 0x235dU, 0x1956U, 0x19d6U, 0x1ec7U, 0x16f7U,
	 0x0d4cU, 0x09a9U, 0x26d7U, 0x0b32U, 0x0170U, 0x2637U, 0x25d3U, 0x3a47U,
	 0x3685U, 0x35d5U, 0x03edU, 0x2418U, 0x3c03U, 0x14c5U, 0x2858U, 0x3bdcU,
	 0x2c1fU, 0x248bU, 0x39a2U, 0x3ff8U, 0x30a6U, 0x383dU, 0x2dd0U, 0x34cdU,
	 0x083fU, 0x3ab2U, 0x09a4U, 0x22afU, 0x3607U, 0x2b23U, 0x1ea2U, 0x1c7bU,
	 0x0a99U, 0x3613U},
	{0x0059U, 0x16e1U, 0x2a10U, 0x2294U, 0x0396U, 0x081cU, 0x1f68U, 0x111bU,
	 0x30fbU, 0x2766U, 0x1921U, 0x11acU, 0x33a5U, 0x32afU, 0x28d0U, 0x0601U,
	 0x2e10U, 0x2ab8U, 0x3845U, 0x02ecU, 0x1922U, 0x2b46U, 0x1fd2U, 0x2e53U,
	 0x0fedU, 0x2e08U, 0x1da3U, 0x3ed7U, 0x2148U, 0x354bU, 0x2495U, 0x35a1U,
	 0x08ebU, 0x224cU, 0x0f8dU, 0x3408U, 0x3686U, 0x1d70U, 0x1119U, 0x3313U,
	 0x1191U, 0x267cU, 0x0fbfU, 0x04e5U, 0x2aa9U, 0x1e6dU, 0x37c2U, 0x14a8U,
	 0x3af4U, 0x2a9dU, 0x1975U, 0x2a61U, 0x3e3aU, 0x1e9fU, 0x1388U, 0x2862U,
	 0x38b5U, 0x1c72U, 0x0a86U, 0x2ed7U, 0x1bb8U, 0x2c37U, 0x037dU, 0x3d9bU,
	 0x3275U, 0x0f3aU, 0x34c3U, 0x37c2U, 0x2800U, 0x0bc3U, 0x1007U, 0x0a14U,
	 0x3cd7U, 0x043dU, 0x2668U, 0x2747U, 0x382cU, 0x0943U, 0x333fU, 0x120bU,
	 0x3aa2U, 0x0330U, 0x099bU, 0x277dU, 0x226cU, 0x1dc1U, 0x0766U, 0x026cU,
	 0x0c26U, 0x2774U}
}; /* curve_point */

#elif GF_M == 1261

const order_t prime_order = {
	 0x004eU, 0x8a03U, 0xafcfU, 0x56f1U, 0x4f95U, 0x0f1bU, 0x92f5U, 0x5ea8U,
	 0x0f0fU, 0xb0bdU, 0x5e45U, 0x840fU, 0x3eecU, 0x156dU, 0xb550U, 0xffd7U,
	 0x132dU, 0x25f0U, 0xd53bU, 0x6b6cU, 0xdc80U, 0xc7c4U, 0x808cU, 0x6a56U,
	 0x47d2U, 0x3131U, 0x9130U, 0xadebU, 0x3d3eU, 0xcf79U, 0x50f9U, 0x402dU,
	 0x75f7U, 0x785fU, 0x588dU, 0x5414U, 0xeecdU, 0xb287U, 0x1e80U, 0x137aU,
	 0xabaeU, 0x4059U, 0xdcccU, 0x9e45U, 0xa1bdU, 0x5644U, 0x8af7U, 0xe3e3U,
	 0xabffU, 0x6262U, 0x1f99U, 0x630eU, 0x62c6U, 0x1889U, 0x99ebU, 0x1886U,
	 0x06b6U, 0xcabdU, 0x7ad3U, 0x246dU, 0xd5b8U, 0xefa3U, 0x39feU, 0x5160U,
	 0x70f2U, 0x8f69U, 0x7bcaU, 0xdcd2U, 0x6dd4U, 0xa52bU, 0x21a0U, 0xa9daU,
	 0xb6f0U, 0x2224U, 0x143eU, 0x2049U, 0x7a5bU, 0xe41fU, 0x0043U
}; /* prime_order (1239 bits) */

const ecPoint curve_point = {
	{0x0061U, 0x1da9U, 0x0af4U, 0x13c2U, 0x028fU, 0x1903U, 0x1659U, 0x1b62U,
	 0x139dU, 0x04fcU, 0x1208U, 0x0987U, 0x03f7U, 0x1d9aU, 0x0e9dU, 0x0615U,
	 0x1620U, 0x1722U, 0x0b8eU, 0x00aaU, 0x15cbU, 0x0cc9U, 0x187bU, 0x12dcU,
	 0x1cc6U, 0x1f1aU, 0x0d71U, 0x1c85U, 0x05c8U, 0x1de4U, 0x18ecU, 0x191bU,
	 0x0190U, 0x1588U, 0x1f60U, 0x0042U, 0x0ba3U, 0x06d7U, 0x0264U, 0x0ce8U,
	 0x06eaU, 0x04f8U, 0x07b3U, 0x1facU, 0x0977U, 0x058bU, 0x1bf5U, 0x01ceU,
	 0x11c3U, 0x0857U, 0x11e8U, 0x0d40U, 0x1ea7U, 0x0454U, 0x014cU, 0x0dffU,
	 0x0f9eU, 0x1be5U, 0x01bbU, 0x1a19U, 0x0fefU, 0x0398U, 0x0769U, 0x08e3U,
	 0x1642U, 0x06f2U, 0x0455U, 0x1a83U, 0x0199U, 0x01efU, 0x16f6U, 0x0a62U,
	 0x111aU, 0x1edeU, 0x1b30U, 0x0530U, 0x098cU, 0x0186U, 0x0e76U, 0x18e7U,
	 0x03f4U, 0x174dU, 0x1c3fU, 0x157dU, 0x0785U, 0x1d15U, 0x0ffaU, 0x1174U,
	 0x0868U, 0x1c7aU, 0x18f2U, 0x152bU, 0x09ebU, 0x0887U, 0x00deU, 0x19d3U,
	 0x1dc0U, 0x0719U},
	{0x0061U, 0x0d83U, 0x08a0U, 0x197fU, 0x03a5U, 0x0d47U, 0x104fU, 0x0e57U,
	 0x0e28U, 0x1019U, 0x0820U, 0x0bceU, 0x1aadU, 0x01f6U, 0x098bU, 0x1f87U,
	 0x106fU, 0x1ae9U, 0x1880U, 0x0006U, 0x1ae3U, 0x06b7U, 0x11baU, 0x0066U,
	 0x1790U, 0x1db5U, 0x1957U, 0x1807U, 0x0378U, 0x0b1fU, 0x09eaU, 0x0dc9U,
	 0x10d8U, 0x01fdU, 0x09c3U, 0x1e0bU, 0x1f4eU, 0x1432U, 0x06f5U, 0x0b66U,
	 0x1243U, 0x0e19U, 0x054fU, 0x0042U, 0x1c9bU, 0x19e9U, 0x162bU, 0x0553U,
	 0x1d17U, 0x1447U, 0x1e88U, 0x1a2dU, 0x07bcU, 0x19c6U, 0x1786U, 0x1411U,
	 0x06e5U, 0x0528U, 0x1341U, 0x0b85U, 0x1e7bU, 0x0bbcU, 0x08b1U, 0x02b2U,
	 0x0422U, 0x123eU, 0x1203U, 0x0d29U, 0x1b22U, 0x1dbeU, 0x08aeU, 0x0864U,
	 0x0ee0U, 0x0fcfU, 0x1445U, 0x16bdU, 0x0385U, 0x01b1U, 0x0660U, 0x02d0U,
	 0x019aU, 0x15e9U, 0x1807U, 0x0265U, 0x012bU, 0x1f50U, 0x1ff1U, 0x0d9dU,
	 0x0244U, 0x12b0U, 0x0285U, 0x09bbU, 0x1967U, 0x05f7U, 0x0226U, 0x0fdfU,
	 0x145eU, 0x0b3bU}
}; /* curve_point */

#elif GF_M == 1264

const order_t prime_order = {
	 0x004fU, 0xcbcbU, 0xf8f6U, 0xf239U, 0x4b2dU, 0x53a1U, 0x6882U, 0x28ecU,
	 0x7ba3U, 0xa68aU, 0x3ec0U, 0x8d07U, 0x4770U, 0xb75eU, 0x0bfcU, 0xb58aU,
	 0xeff4U, 0xd051U, 0x48e9U, 0x1ca3U, 0x5cb0U, 0xd31aU, 0x999aU, 0x929dU,
	 0xc05fU, 0x0601U, 0x2fbeU, 0x0f77U, 0x1cb6U, 0x7362U, 0xa8e2U, 0x3a80U,
	 0x2b58U, 0x5abbU, 0xca60U, 0xf075U, 0x8afbU, 0x9c14U, 0x86f6U, 0x1befU,
	 0x2176U, 0xc2aeU, 0xf135U, 0xbfdcU, 0x9bd9U, 0x3f12U, 0x771aU, 0x18ceU,
	 0x6fa3U, 0x8367U, 0x2724U, 0xbb9fU, 0x01bcU, 0x4e3dU, 0x2905U, 0xf487U,
	 0x5798U, 0x1167U, 0x4288U, 0xf981U, 0xbb32U, 0x41bbU, 0xc7b8U, 0xbd1bU,
	 0xaec9U, 0x7ce0U, 0xae31U, 0x9e0eU, 0x9b89U, 0x3596U, 0xbe20U, 0x4d9cU,
	 0x160dU, 0x8293U, 0xc135U, 0x5e3bU, 0x40dfU, 0x2da3U, 0x006cU, 0x0001U
}; /* prime_order (1249 bits) */

const ecPoint curve_point = {
	{0x004fU, 0x2d5aU, 0xa6f8U, 0x8ce6U, 0xb5b0U, 0x148dU, 0xc653U, 0x18eaU,
	 0x50bdU, 0x3090U, 0xb35fU, 0x45d9U, 0xd104U, 0x53c5U, 0xa365U, 0xdaa8U,
	 0xe7e2U, 0x9d9dU, 0xd01bU, 0xc2a9U, 0x8893U, 0xa2a9U, 0x6bebU, 0x1073U,
	 0x6b06U, 0xafe1U, 0xc562U, 0xfa43U, 0x7231U, 0x9085U, 0x15e5U, 0x219dU,
	 0x2a80U, 0xef33U, 0xc68cU, 0x0b64U, 0x80c0U, 0xa571U, 0xbe26U, 0x1ed1U,
	 0x0ef4U, 0x39a0U, 0xd435U, 0xc39eU, 0xeb0fU, 0xc324U, 0x25acU, 0x7032U,
	 0xc300U, 0x6439U, 0xe447U, 0x4fe4U, 0xea31U, 0x1f96U, 0x2dc5U, 0x901eU,
	 0x3c4eU, 0x9d11U, 0x4f49U, 0x8a44U, 0x0388U, 0x0b41U, 0x1564U, 0xeb06U,
	 0xe540U, 0x2238U, 0x0693U, 0x2865U, 0xc63dU, 0xc20fU, 0xff89U, 0xeccbU,
	 0xc455U, 0xd5ccU, 0x0782U, 0xa528U, 0x4540U, 0x5965U, 0x4d63U, 0xe364U},
	{0x004fU, 0xa20eU, 0x52baU, 0x45bdU, 0x3bbdU, 0x61f9U, 0x2dbbU, 0x24d4U,
	 0xc28fU, 0x1ffdU, 0xbae2U, 0x9ff9U, 0x75b1U, 0x2a0cU, 0xd6f0U, 0xf418U,
	 0x5ac6U, 0x7416U, 0xc083U, 0x9c10U, 0x6044U, 0x8309U, 0xff6fU, 0xe325U,
	 0xcd01U, 0x3edfU, 0x50e8U, 0x4ea6U, 0x60a1U, 0x8f0dU, 0x7fb5U, 0xd869U,
	 0x68f3U, 0xe279U, 0xb1b2U, 0xd6bcU, 0x7b43U, 0xb58dU, 0xa171U, 0xd841U,
	 0x287bU, 0xdfc6U, 0x79f7U, 0x302cU, 0xeb9fU, 0x47caU, 0x8355U, 0xf344U,
	 0x2c6cU, 0xb695U, 0xd8d7U, 0x79e2U, 0xbf62U, 0xa615U, 0xe6a5U, 0xbb27U,
	 0xb331U, 0x7975U, 0x9637U, 0x3588U, 0x7ac5U, 0x2ef4U, 0xfb5cU, 0xd476U,
	 0x8a97U, 0x272cU, 0x3fffU, 0x1c36U, 0x20eaU, 0x5cd8U, 0x9873U, 0x646aU,
	 0x56e5U, 0x9aedU, 0x2014U, 0x6638U, 0x129fU, 0x3fefU, 0x5f21U, 0x5ad9U}
}; /* curve_point */

#elif GF_M == 1335

const order_t prime_order = {
	 0x0053U, 0x8de9U, 0x1594U, 0x496fU, 0x2feeU, 0xf599U, 0x0cebU, 0xedceU,
	 0xd8caU, 0x2995U, 0x1dd7U, 0x7da1U, 0x83a5U, 0x7200U, 0xd29cU, 0xafd6U,
	 0x5d37U, 0xf125U, 0xc1a5U, 0xc48eU, 0x5717U, 0xa390U, 0x71b7U, 0x173fU,
	 0x469bU, 0x961bU, 0x64acU, 0x1366U, 0x7b2eU, 0xcdd9U, 0x86b7U, 0x5789U,
	 0x4bd6U, 0x3c82U, 0xe431U, 0xa300U, 0x8c23U, 0x2bc5U, 0x5479U, 0xb593U,
	 0x295eU, 0xcaa2U, 0xcea7U, 0xabe5U, 0x1345U, 0x342bU, 0x16e7U, 0x0a0eU,
	 0x3c9cU, 0x2d57U, 0x26a3U, 0xfe3bU, 0xe000U, 0xc63eU, 0xc76cU, 0x3216U,
	 0x0342U, 0x7e4fU, 0x5ceaU, 0x5abeU, 0xb134U, 0x7342U, 0xe16eU, 0xc0a0U,
	 0x73c9U, 0x32d5U, 0xb26aU, 0x0fe3U, 0xee00U, 0xcc63U, 0x6c76U, 0x2321U,
	 0xf034U, 0xa7e4U, 0xe5ceU, 0x45abU, 0x2b13U, 0xe734U, 0x0e16U, 0x9c0aU,
	 0x573cU, 0xa32dU, 0x3b26U, 0x00feU
}; /* prime_order (1320 bits) */

const ecPoint curve_point = {
	{0x0059U, 0x385dU, 0x5a7eU, 0x6bb0U, 0x489bU, 0x6fdbU, 0x650aU, 0x6ee7U,
	 0x2a2fU, 0x1a47U, 0x29a7U, 0x556fU, 0x11e6U, 0x79ddU, 0x706cU, 0x50a1U,
	 0x6a77U, 0x4b30U, 0x6776U, 0x508cU, 0x5241U, 0x4ff9U, 0x631dU, 0x1e7eU,
	 0x56f1U, 0x124dU, 0x3fb8U, 0x3904U, 0x38a4U, 0x004fU, 0x640fU, 0x6481U,
	 0x3b2cU, 0x6940U, 0x558dU, 0x7704U, 0x73e8U, 0x7febU, 0x7b9eU, 0x283bU,
	 0x51a6U, 0x3d02U, 0x2351U, 0x3cd9U, 0x4e6bU, 0x3affU, 0x16f0U, 0x7073U,
	 0x1e4fU, 0x59d2U, 0x39cdU, 0x2e3aU, 0x6313U, 0x5ea1U, 0x67c0U, 0x1d06U,
	 0x7802U, 0x38b5U, 0x04dbU, 0x7144U, 0x0b19U, 0x365fU, 0x00a8U, 0x720bU,
	 0x531bU, 0x15dbU, 0x7d16U, 0x4db6U, 0x5b89U, 0x12e9U, 0x563dU, 0x1b49U,
	 0x6039U, 0x1f51U, 0x1925U, 0x4247U, 0x7b87U, 0x0005U, 0x5ddfU, 0x636eU,
	 0x2ef4U, 0x5400U, 0x0e2cU, 0x1b68U, 0x0a6dU, 0x6cdcU, 0x37dbU, 0x51d3U,
	 0x5f07U, 0x7a7bU},
	{0x0059U, 0x77daU, 0x2703U, 0x0894U, 0x6178U, 0x11dbU, 0x45bbU, 0x77c4U,
	 0x466bU, 0x63eaU, 0x4dc1U, 0x2f10U, 0x53f1U, 0x71d8U, 0x53b7U, 0x556cU,
	 0x0130U, 0x355dU, 0x7d66U, 0x391aU, 0x29b5U, 0x7438U, 0x25b7U, 0x3057U,
	 0x3540U, 0x7400U, 0x38ffU, 0x301cU, 0x1a30U, 0x5b07U, 0x76c1U, 0x13a9U,
	 0x64ceU, 0x74faU, 0x3e7eU, 0x7f0cU, 0x1b92U, 0x346eU, 0x0e60U, 0x2b32U,
	 0x31ebU, 0x1797U, 0x3af3U, 0x2d22U, 0x738cU, 0x2f2dU, 0x4e6eU, 0x169fU,
	 0x55bcU, 0x64b9U, 0x0d54U, 0x61a7U, 0x76d0U, 0x2eceU, 0x6086U, 0x1629U,
	 0x6418U, 0x1cebU, 0x0695U, 0x7e40U, 0x5200U, 0x0e4cU, 0x1bbdU, 0x35a7U,
	 0x5603U, 0x2789U, 0x6490U, 0x18efU, 0x52d5U, 0x1244U, 0x30dfU, 0x5a15U,
	 0x6772U, 0x30c0U, 0x3b87U, 0x50ecU, 0x2c4aU, 0x5a96U, 0x2d1aU, 0x2a77U,
	 0x3636U, 0x0a6dU, 0x21c0U, 0x6f69U, 0x6a48U, 0x0393U, 0x47b7U, 0x58bfU,
	 0x2400U, 0x0d88U}
}; /* curve_point */

#elif GF_M == 1339

const order_t prime_order = {
	 0x0053U, 0x34f7U, 0x4a73U, 0x3588U, 0x6cdaU, 0xaf8cU, 0x05bfU, 0x1a7dU,
	 0xa7b4U, 0xad4fU, 0x76a9U, 0x5fd6U, 0x5703U, 0xffcfU, 0x8e2dU, 0x4236U,
	 0x1a4eU, 0xf030U, 0x8f48U, 0x3b97U, 0x9a24U, 0xdc4cU, 0x4c1aU, 0x8c67U,
	 0x586bU, 0xdf20U, 0x79f4U, 0x415dU, 0xf9eaU, 0xd153U, 0xe34bU, 0xb471U,
	 0xcff7U, 0xbc96U, 0xd1a5U, 0x325bU, 0x3a46U, 0xab3bU, 0xf5a7U, 0xca4cU,
	 0xaa47U, 0xe242U, 0xdca5U, 0x93f1U, 0x40a1U, 0x6680U, 0x6c8fU, 0xde2bU,
	 0xf058U, 0x452cU, 0x7bb5U, 0x7a31U, 0x1dcaU, 0x193fU, 0x040aU, 0xf668U,
	 0xb6c8U, 0x8de2U, 0xcf05U, 0x5452U, 0x17bbU, 0xa7a3U, 0xf1dcU, 0xa193U,
	 0x8040U, 0x8f66U, 0x2b6cU, 0x58deU, 0x2cf0U, 0xb545U, 0x317bU, 0xca7aU,
	 0x3f1dU, 0x0a19U, 0x6804U, 0xc8f6U, 0xe2b6U, 0x058dU, 0x52cfU, 0xbb54U,
	 0xa317U, 0xdca7U, 0x93f1U, 0x40a1U
}; /* prime_order (1327 bits) */

const ecPoint curve_point = {
	{0x0067U, 0x1d18U, 0x1627U, 0x15b4U, 0x0182U, 0x12ddU, 0x0ac4U, 0x12dcU,
	 0x08f0U, 0x173aU, 0x1c2cU, 0x0668U, 0x1635U, 0x03a0U, 0x0da5U, 0x0f05U,
	 0x1a3eU, 0x0158U, 0x1d9cU, 0x1ef4U, 0x1305U, 0x1cf7U, 0x0c30U, 0x1ea9U,
	 0x1fe5U, 0x1b10U, 0x0f02U, 0x1ec4U, 0x19d6U, 0x0c15U, 0x01ddU, 0x16e6U,
	 0x17feU, 0x09f0U, 0x16eaU, 0x1e03U, 0x1d9bU, 0x1771U, 0x0f72U, 0x13b2U,
	 0x0e04U, 0x18f9U, 0x1cb9U, 0x0f96U, 0x13f8U, 0x1ba8U, 0x197cU, 0x0862U,
	 0x022aU, 0x1db7U, 0x09e4U, 0x1535U, 0x0080U, 0x02b3U, 0x13c4U, 0x1fc8U,
	 0x09c6U, 0x0e89U, 0x02a0U, 0x00bfU, 0x08abU, 0x166bU, 0x1145U, 0x0cffU,
	 0x1dcaU, 0x021bU, 0x0ad0U, 0x1e2eU, 0x05f8U, 0x1849U, 0x0edaU, 0x1b59U,
	 0x0a0aU, 0x0d6dU, 0x1f2dU, 0x0d37U, 0x0d91U, 0x1660U, 0x14b5U, 0x01ecU,
	 0x04f3U, 0x16b7U, 0x08b1U, 0x1ce3U, 0x167eU, 0x09eeU, 0x09edU, 0x1766U,
	 0x1e6cU, 0x1a30U, 0x0999U, 0x10a6U, 0x0664U, 0x0bbcU, 0x0f6aU, 0x0f08U,
	 0x0ce1U, 0x0950U, 0x04c5U, 0x1020U, 0x0d2bU, 0x00a9U, 0x133fU, 0x00a5U},
	{0x0067U, 0x0064U, 0x16c3U, 0x135cU, 0x137cU, 0x1d9eU, 0x11c6U, 0x1e45U,
	 0x17c2U, 0x0672U, 0x1b69U, 0x1a8cU, 0x0d5cU, 0x17fbU, 0x0cd5U, 0x10c7U,
	 0x1ad8U, 0x1b71U, 0x033bU, 0x0531U, 0x1888U, 0x0975U, 0x1574U, 0x1499U,
	 0x1209U, 0x1b9dU, 0x017aU, 0x05b1U, 0x0224U, 0x1c20U, 0x12deU, 0x17beU,
	 0x1d0dU, 0x1c9eU, 0x0410U, 0x18b8U, 0x0555U, 0x15fbU, 0x0f92U, 0x16c3U,
	 0x1bc3U, 0x06dcU, 0x16d4U, 0x00b5U, 0x0314U, 0x159fU, 0x0d21U, 0x0e00U,
	 0x1fb0U, 0x0b14U, 0x0d8fU, 0x0256U, 0x0898U, 0x0196U, 0x1a78U, 0x11d5U,
	 0x1db3U, 0x02fbU, 0x072fU, 0x06f9U, 0x1129U, 0x075bU, 0x01a1U, 0x1e4aU,
	 0x1a03U, 0x089bU, 0x00d4U, 0x07dcU, 0x0c07U, 0x1508U, 0x0dcfU, 0x1de3U,
	 0x0ee8U, 0x189dU, 0x1e87U, 0x0437U, 0x1fb7U, 0x1517U, 0x034dU, 0x050aU,
	 0x1fc5U, 0x0e55U, 0x1916U, 0x04c1U, 0x1c60U, 0x1707U, 0x0475U, 0x16e7U,
	 0x02cbU, 0x0a5eU, 0x16f0U, 0x168dU, 0x1840U, 0x0bd6U, 0x0196U, 0x0c9aU,
	 0x1c3cU, 0x153bU, 0x1a64U, 0x1f20U, 0x1ccbU, 0x0131U, 0x01b4U, 0x0dcaU}
}; /* curve_point */

#elif GF_M == 1358

const order_t prime_order = {
	 0x0055U, 0x9921U, 0x1681U, 0xea4dU, 0xd721U, 0xeb02U, 0x4afeU, 0x5ce2U,
	 0xbde5U, 0xb365U, 0xe81aU, 0xd4b8U, 0xf57cU, 0xfd4bU, 0x8c75U, 0x1ae0U,
	 0x663eU, 0xfa6bU, 0x613cU, 0x4b7fU, 0xe709U, 0x066dU, 0xda06U, 0xbae3U,
	 0x0899U, 0xca11U, 0x7935U, 0x9e1fU, 0x487aU, 0x7fdcU, 0x57fbU, 0xa8beU,
	 0x7115U, 0xa370U, 0x387fU, 0xb531U, 0x4eaaU, 0xfa9dU, 0x7d2cU, 0xf8deU,
	 0x2f9aU, 0x7d86U, 0xf5e7U, 0x0654U, 0x5354U, 0x5d14U, 0x6286U, 0x5844U,
	 0x41eaU, 0x77edU, 0xe28eU, 0x4952U, 0xcf2eU, 0x02a8U, 0x18c2U, 0x5a4bU,
	 0x858aU, 0xc8e9U, 0x9171U, 0xd635U, 0x0d3bU, 0x99adU, 0xa8efU, 0x863cU,
	 0x8028U, 0xb548U, 0xc253U, 0xb5a9U, 0x0f01U, 0x54d9U, 0x8fccU, 0xdf43U,
	 0x5b6eU, 0x6b94U, 0xa677U, 0x13d1U, 0x7575U, 0x7023U, 0x3e9fU, 0x8a09U,
	 0x7ef4U, 0xed21U, 0xca3dU, 0x1dd2U, 0x035bU, 0x0001U
}; /* prime_order (1345 bits) */

const ecPoint curve_point = {
	{0x0061U, 0x27a8U, 0x2854U, 0x0efeU, 0x17e1U, 0x2cbaU, 0x30a8U, 0x0d1cU,
	 0x0afbU, 0x3006U, 0x22e9U, 0x0836U, 0x1c34U, 0x2db4U, 0x0df7U, 0x33ccU,
	 0x10c9U, 0x3b21U, 0x00ebU, 0x2157U, 0x3b67U, 0x0d22U, 0x09e8U, 0x3ad9U,
	 0x1ce8U, 0x190aU, 0x0204U, 0x1e98U, 0x37ccU, 0x3e80U, 0x1e20U, 0x0084U,
	 0x3513U, 0x31a7U, 0x3fa7U, 0x1b26U, 0x2b39U, 0x2639U, 0x29b6U, 0x104fU,
	 0x1c8dU, 0x1177U, 0x0463U, 0x037aU, 0x2733U, 0x1696U, 0x33b0U, 0x0f28U,
	 0x1bd1U, 0x0883U, 0x11d7U, 0x34b0U, 0x1334U, 0x1580U, 0x2d0bU, 0x3d3fU,
	 0x234bU, 0x3062U, 0x28f2U, 0x086fU, 0x060bU, 0x0408U, 0x18cfU, 0x2392U,
	 0x3924U, 0x1780U, 0x064aU, 0x32edU, 0x2648U, 0x0e2cU, 0x2cabU, 0x0b81U,
	 0x1eb0U, 0x059dU, 0x2ec6U, 0x3843U, 0x2773U, 0x1865U, 0x1307U, 0x2fa2U,
	 0x2946U, 0x33bdU, 0x091cU, 0x1b0cU, 0x19caU, 0x1f82U, 0x11fbU, 0x12e5U,
	 0x0d7cU, 0x3d95U, 0x3abcU, 0x1812U, 0x2d79U, 0x103aU, 0x3437U, 0x0648U,
	 0x1031U, 0x3b3bU},
	{0x0061U, 0x3962U, 0x3685U, 0x2f75U, 0x3a76U, 0x0cd8U, 0x3f2dU, 0x3629U,
	 0x2911U, 0x1fdfU, 0x39e4U, 0x0809U, 0x321aU, 0x217cU, 0x35b1U, 0x3885U,
	 0x1edeU, 0x19a8U, 0x0dffU, 0x3dddU, 0x256cU, 0x1c3aU, 0x2437U, 0x111bU,
	 0x010eU, 0x2603U, 0x11f4U, 0x1693U, 0x3190U, 0x121aU, 0x0fa9U, 0x1399U,
	 0x04ffU, 0x2036U, 0x2835U, 0x08ffU, 0x3063U, 0x07e5U, 0x01efU, 0x2e68U,
	 0x3b6eU, 0x061aU, 0x295aU, 0x18abU, 0x208aU, 0x0347U, 0x1614U, 0x3ed4U,
	 0x153dU, 0x116bU, 0x2fe1U, 0x2a2eU, 0x372eU, 0x13cfU, 0x1c60U, 0x3686U,
	 0x383bU, 0x3c07U, 0x3e76U, 0x1065U, 0x31e2U, 0x1c19U, 0x3439U, 0x2e8fU,
	 0x03dbU, 0x3a37U, 0x2559U, 0x1b64U, 0x06d8U, 0x2fb1U, 0x1a8eU, 0x2300U,
	 0x2fb6U, 0x2d8aU, 0x199bU, 0x1434U, 0x3e81U, 0x26bfU, 0x16f5U, 0x3082U,
	 0x359cU, 0x2c48U, 0x30b6U, 0x3779U, 0x10d9U, 0x15c2U, 0x0dc2U, 0x0a47U,
	 0x27a1U, 0x1c5dU, 0x0056U, 0x27f3U, 0x018bU, 0x3c4eU, 0x0104U, 0x0cc7U,
	 0x1ec6U, 0x0fd0U}
}; /* curve_point */

#elif GF_M == 1424

const order_t prime_order = {
	 0x0058U, 0xdea1U, 0xb297U, 0xf308U, 0x42e3U, 0x8126U, 0x5181U, 0x8edcU,
	 0x3fbeU, 0xd7ebU, 0xa76dU, 0x6864U, 0x9d11U, 0x88b5U, 0x5c01U, 0x4a95U,
	 0x4b4aU, 0x9711U, 0x350fU, 0x9792U, 0x462eU, 0x2223U, 0x1d23U, 0x0c7eU,
	 0x415eU, 0xbe4cU, 0xefb5U, 0x6d34U, 0xd056U, 0x7c0bU, 0x0977U, 0x41adU,
	 0x7d67U, 0xb282U, 0x325aU, 0x8b4dU, 0x1adcU, 0x40a6U, 0xb01cU, 0x2aaeU,
	 0x397aU, 0x45a6U, 0x0b6eU, 0xfb10U, 0x7bf0U, 0x56bcU, 0x1fe4U, 0x1265U,
	 0x8f58U, 0x56c0U, 0xba7aU, 0x1843U, 0x700cU, 0x8e68U, 0xda21U, 0xc9baU,
	 0x0ae4U, 0xa7b5U, 0x288aU, 0x59efU, 0xdb39U, 0xed0aU, 0x2b22U, 0xdc1eU,
	 0x4ef3U, 0xca84U, 0x93a5U, 0xb816U, 0x003dU, 0x3466U, 0xf332U, 0x2911U,
	 0x6c81U, 0x0dbaU, 0x7d1bU, 0xb09cU, 0x0b1cU, 0xe66bU, 0xa830U, 0xeec8U,
	 0x36a6U, 0x9c49U, 0xf8aeU, 0x1e7eU, 0x2c86U, 0xf625U, 0x5efeU, 0x0b23U,
	 0x0002U
}; /* prime_order (1394 bits) */

const ecPoint curve_point = {
	{0x0059U, 0x9998U, 0x8263U, 0xbd22U, 0xb6a2U, 0x04dbU, 0x54ccU, 0xe9ffU,
	 0xd5e2U, 0x14ceU, 0x5e0dU, 0xa05fU, 0x3910U, 0x2fcdU, 0xa28eU, 0xb53eU,
	 0x850eU, 0x68faU, 0xa84eU, 0xac6eU, 0x4150U, 0x7b01U, 0x8b03U, 0x721cU,
	 0x8ca1U, 0xb4fdU, 0x4069U, 0xc6adU, 0x5860U, 0xf3fcU, 0x35b4U, 0xeb67U,
	 0xe36fU, 0xc962U, 0x1834U, 0xa2baU, 0xc51bU, 0xd31bU, 0x36a8U, 0xa04dU,
	 0xf1f3U, 0x7f72U, 0x46f1U, 0x0327U, 0x7ee4U, 0x5a34U, 0xd6e2U, 0x70c2U,
	 0xfd41U, 0x35f2U, 0xd917U, 0x27fdU, 0xe137U, 0xe1abU, 0x3c71U, 0x02d3U,
	 0x7af0U, 0xa4a2U, 0xd6c8U, 0xb327U, 0x2aa0U, 0xa609U, 0x5579U, 0xb1a1U,
	 0xa5f8U, 0xd9baU, 0x5548U, 0xa87fU, 0x7fb7U, 0x0c82U, 0xb1a6U, 0xc82bU,
	 0x4895U, 0x6e81U, 0xb407U, 0x58f4U, 0x2569U, 0x91dfU, 0xf0deU, 0x4089U,
	 0x5e83U, 0x5fa5U, 0x5117U, 0xb901U, 0x1b02U, 0x7761U, 0xbb18U, 0xc47aU,
	 0x6094U, 0x9d9aU},
	{0x0059U, 0x79a6U, 0x3071U, 0xbf43U, 0x7c3bU, 0x6c69U, 0x97b4U, 0x54edU,
	 0x71efU, 0x33afU, 0x98d0U, 0x25c2U, 0x5a97U, 0x7f7dU, 0xdb8eU, 0xeab2U,
	 0xfc17U, 0xfc17U, 0x89d5U, 0x02e5U, 0x8f54U, 0x4a54U, 0xe0e7U, 0x86cbU,
	 0x2bb3U, 0x77fbU, 0xe9ffU, 0xf227U, 0xbca2U, 0x473eU, 0xb503U, 0xb008U,
	 0x0406U, 0xa558U, 0x6982U, 0x8965U, 0x4d19U, 0xf8b0U, 0xc937U, 0x7afbU,
	 0xbae6U, 0xb3a4U, 0xda71U, 0x6a82U, 0x7d32U, 0x5f1fU, 0x18c5U, 0xc7afU,
	 0x91caU, 0x1f64U, 0x8746U, 0xa694U, 0xf495U, 0x1544U, 0xbea0U, 0x61e8U,
	 0xf684U, 0xa03cU, 0xdecdU, 0xc81cU, 0xa8dcU, 0xc17eU, 0x3375U, 0x0f8cU,
	 0x492bU, 0xdc08U, 0x2d0aU, 0x17ffU, 0xb011U, 0xa869U, 0xb732U, 0xda97U,
	 0x4aadU, 0xe569U, 0x351aU, 0x1297U, 0xcf87U, 0xc7d1U, 0x8da4U, 0x0419U,
	 0xd682U, 0xcebbU, 0x55d6U, 0x9d59U, 0x4cccU, 0xa567U, 0x4e8bU, 0xd5e1U,
	 0x5c78U, 0x7154U}
}; /* curve_point */

#elif GF_M == 1455

const order_t prime_order = {
	 0x005bU, 0x93a1U, 0x1085U, 0x9fd1U, 0xcf80U, 0x2f7aU, 0xdaa3U, 0xdb37U,
	 0x1ee9U, 0xfad2U, 0xb8b9U, 0xa20aU, 0x1fd0U, 0xcdaeU, 0x1b00U, 0xa543U,
	 0xb35bU, 0xdad6U, 0x4ec8U, 0x73bcU, 0xf02eU, 0xc009U, 0x11b6U, 0x550eU,
	 0x1b70U, 0xc59cU, 0x0980U, 0x2d9bU, 0x1e6cU, 0xc829U, 0x5a9dU, 0xeab1U,
	 0x2522U, 0x4decU, 0xaed7U, 0x5ebeU, 0x9076U, 0xa179U, 0xf6d8U, 0x18a5U,
	 0xfd1aU, 0x3873U, 0x1820U, 0x5c11U, 0x91e6U, 0x239eU, 0x942cU, 0x9bf8U,
	 0xbf20U, 0x934aU, 0xa884U, 0xcc55U, 0xd716U, 0xe268U, 0xd360U, 0x72b6U,
	 0x78c0U, 0xb500U, 0xa394U, 0x4066U, 0xd800U, 0xf0d7U, 0x3369U, 0x5111U,
	 0xb3a6U, 0x1b6bU, 0xe6f8U, 0x1b8bU, 0x52e4U, 0xd084U, 0xdb7dU, 0xa3acU,
	 0x9157U, 0x1fbaU, 0x574bU, 0x91c8U, 0x9974U, 0x50b0U, 0x6fe2U, 0xfc82U,
	 0x4d2aU, 0xa212U, 0x3156U, 0x5c5bU, 0x89a3U, 0x4d83U, 0xcadbU, 0xe301U,
	 0xd401U, 0x8e52U, 0x019aU, 0x0001U
}; /* prime_order (1441 bits) */

const ecPoint curve_point = {
	{0x0061U, 0x09f9U, 0x39aaU, 0x277cU, 0x5f81U, 0x22e0U, 0x6907U, 0x3e3dU,
	 0x2a17U, 0x77f2U, 0x6904U, 0x4cbeU, 0x3a3cU, 0x4b65U, 0x6d73U, 0x5548U,
	 0x41a9U, 0x2e77U, 0x1361U, 0x17bbU, 0x6ac2U, 0x5676U, 0x4dd0U, 0x3abeU,
	 0x4256U, 0x5410U, 0x2efeU, 0x6608U, 0x78f6U, 0x7964U, 0x1535U, 0x5068U,
	 0x1652U, 0x5587U, 0x483aU, 0x67a3U, 0x1629U, 0x3253U, 0x28c9U, 0x3166U,
	 0x4eb8U, 0x6862U, 0x1919U, 0x2111U, 0x127fU, 0x4366U, 0x1301U, 0x1f8aU,
	 0x6d23U, 0x6aeeU, 0x39e6U, 0x5b47U, 0x65a8U, 0x044fU, 0x3351U, 0x561aU,
	 0x2051U, 0x1df4U, 0x5b34U, 0x2c5bU, 0x2178U, 0x32eeU, 0x7fc7U, 0x0e18U,
	 0x4b7fU, 0x13ddU, 0x1282U, 0x5c47U, 0x6a88U, 0x565aU, 0x2393U, 0x104dU,
	 0x7634U, 0x67e2U, 0x7e64U, 0x1b51U, 0x3f01U, 0x03a5U, 0x5671U, 0x2e01U,
	 0x27afU, 0x605fU, 0x50e2U, 0x4549U, 0x5c47U, 0x342cU, 0x424aU, 0x6516U,
	 0x0311U, 0x25e1U, 0x63fdU, 0x12baU, 0x7c57U, 0x347fU, 0x4913U, 0x7b45U,
	 0x7cdbU, 0x50e6U},
	{0x0061U, 0x0b53U, 0x76abU, 0x0d02U, 0x0668U, 0x3d89U, 0x72ecU, 0x74f6U,
	 0x206cU, 0x112dU, 0x17a3U, 0x0d91U, 0x6130U, 0x2844U, 0x7753U, 0x3ed5U,
	 0x25c2U, 0x595fU, 0x5777U, 0x63a6U, 0x3958U, 0x224aU, 0x0626U, 0x0715U,
	 0x22ecU, 0x72f2U, 0x619aU, 0x107cU, 0x526eU, 0x2dd8U, 0x10fdU, 0x79e3U,
	 0x329fU, 0x3a20U, 0x6481U, 0x2160U, 0x6137U, 0x644bU, 0x7a7fU, 0x798eU,
	 0x4757U, 0x5b52U, 0x6d78U, 0x4645U, 0x37a9U, 0x30daU, 0x1553U, 0x6e07U,
	 0x6cbcU, 0x75efU, 0x50c2U, 0x6b05U, 0x240aU, 0x2219U, 0x4719U, 0x7cb1U,
	 0x532bU, 0x5c0fU, 0x3021U, 0x2792U, 0x5351U, 0x73c9U, 0x394aU, 0x245eU,
	 0x0850U, 0x68b0U, 0x1112U, 0x3f9cU, 0x08c2U, 0x7fb2U, 0x71c7U, 0x15b1U,
	 0x5fb7U, 0x6577U, 0x48bcU, 0x13d2U, 0x168cU, 0x49d9U, 0x6723U, 0x297eU,
	 0x766aU, 0x1abfU, 0x440aU, 0x050cU, 0x4843U, 0x11d9U, 0x25ffU, 0x4d38U,
	 0x6bf1U, 0x3f76U, 0x79c7U, 0x7a18U, 0x1ee2U, 0x65aaU, 0x769bU, 0x779fU,
	 0x5aa1U, 0x1517U}
}; /* curve_point */

#elif GF_M == 1469

const order_t prime_order = {
	 0x005bU, 0x247bU, 0xcd2fU, 0xaca8U, 0x8bc0U, 0xe781U, 0x3320U, 0x585bU,
	 0xebebU, 0xbb9bU, 0x89caU, 0xbec3U, 0x278fU, 0x9336U, 0x4291U, 0xd284U,
	 0x6c6aU, 0xccf1U, 0xb3deU, 0x7969U, 0x585fU, 0x5837U, 0xbc4bU, 0x1c8cU,
	 0x6f24U, 0xa977U, 0xe0b5U, 0x4f0fU, 0x7727U, 0x88e1U, 0xb7f0U, 0x3128U,
	 0x38deU, 0x2586U, 0x933dU, 0x346fU, 0x9cefU, 0x8514U, 0xadabU, 0xc488U,
	 0xa9f9U, 0xa385U, 0x4be1U, 0x96e5U, 0x3cdeU, 0xa127U, 0xaea9U, 0x21ffU,
	 0x4abeU, 0x3cacU, 0x7464U, 0x14b6U, 0x491aU, 0xfeadU, 0x03deU, 0xe330U,
	 0x6a3cU, 0x6aaeU, 0x51ecU, 0xa0c4U, 0xde95U, 0x4454U, 0x9cc3U, 0x9c6cU,
	 0x0f3dU, 0x6c56U, 0x9260U, 0xa0beU, 0x410dU, 0xc533U, 0x1b40U, 0x32d1U,
	 0x31a6U, 0x3206U, 0x5f32U, 0x10b0U, 0x9d1aU, 0x9a58U, 0xc21fU, 0x5cbbU,
	 0x19d9U, 0xcc60U, 0x17f6U, 0xfd3aU, 0x80e3U, 0xab48U, 0x058bU, 0x8d7bU,
	 0x9974U, 0xde78U, 0x4f32U, 0x0126U
}; /* prime_order (1449 bits) */

const ecPoint curve_point = {
	{0x0071U, 0x0cfcU, 0x1814U, 0x07d3U, 0x180dU, 0x0351U, 0x0743U, 0x13e6U,
	 0x0beaU, 0x1e29U, 0x1999U, 0x046fU, 0x0190U, 0x0041U, 0x0ee6U, 0x192fU,
	 0x0edfU, 0x117fU, 0x1230U, 0x094aU, 0x14daU, 0x1592U, 0x0c83U, 0x0e0dU,
	 0x0f79U, 0x0249U, 0x17e6U, 0x169cU, 0x0775U, 0x1cb5U, 0x0027U, 0x1737U,
	 0x0b92U, 0x0f07U, 0x08deU, 0x161aU, 0x19c9U, 0x1f4bU, 0x1c3aU, 0x1d7eU,
	 0x1cddU, 0x13bbU, 0x00d1U, 0x0301U, 0x0f04U, 0x19b8U, 0x1d06U, 0x0197U,
	 0x022aU, 0x1932U, 0x1f74U, 0x1a1bU, 0x06bbU, 0x0132U, 0x0057U, 0x13bbU,
	 0x04e6U, 0x14c3U, 0x1659U, 0x1811U, 0x0d72U, 0x02edU, 0x0231U, 0x1284U,
	 0x0ce2U, 0x18c8U, 0x02b0U, 0x070bU, 0x0160U, 0x11a7U, 0x191dU, 0x1499U,
	 0x1168U, 0x1b39U, 0x18f1U, 0x004fU, 0x0b0cU, 0x10fcU, 0x1aa6U, 0x1aa3U,
	 0x122dU, 0x0f11U, 0x0d54U, 0x1b64U, 0x0b95U, 0x0d9fU, 0x1d3cU, 0x10dbU,
	 0x0553U, 0x0a8cU, 0x1b4dU, 0x143cU, 0x0268U, 0x10c2U, 0x0606U, 0x14edU,
	 0x0a21U, 0x0472U, 0x132cU, 0x0ae8U, 0x1dd6U, 0x112bU, 0x1c4cU, 0x1209U,
	 0x1669U, 0x1ac2U, 0x16b2U, 0x0b30U, 0x0248U, 0x0598U, 0x08afU, 0x1f1fU,
	 0x040aU, 0x1172U},
	{0x0071U, 0x1717U, 0x018cU, 0x044fU, 0x1696U, 0x1ef6U, 0x0612U, 0x0878U,
	 0x0671U, 0x04c8U, 0x1099U, 0x0a42U, 0x198fU, 0x0edeU, 0x0500U, 0x097dU,
	 0x08f0U, 0x1110U, 0x1f1aU, 0x1548U, 0x0f7dU, 0x184dU, 0x0b0aU, 0x1488U,
	 0x10e0U, 0x1b9dU, 0x0454U, 0x1b7aU, 0x10f9U, 0x006fU, 0x0631U, 0x0756U,
	 0x0442U, 0x0280U, 0x0e9eU, 0x1c38U, 0x0431U, 0x14bcU, 0x1081U, 0x06fdU,
	 0x0a89U, 0x0364U, 0x126dU, 0x1dbeU, 0x1fd3U, 0x107cU, 0x00ecU, 0x1b4aU,
	 0x1368U, 0x0f2eU, 0x0c6aU, 0x1f28U, 0x1b56U, 0x1ad2U, 0x16efU, 0x0ff8U,
	 0x1ff3U, 0x02a8U, 0x1e6eU, 0x0c72U, 0x1948U, 0x0c2dU, 0x0597U, 0x192cU,
	 0x11faU, 0x00c5U, 0x05a2U, 0x1368U, 0x1e94U, 0x1512U, 0x1d81U, 0x089bU,
	 0x148eU, 0x139fU, 0x0a50U, 0x1eceU, 0x162eU, 0x1a01U, 0x1b53U, 0x006eU,
	 0x122dU, 0x08c3U, 0x1a1cU, 0x1dfeU, 0x0a92U, 0x1fccU, 0x1b42U, 0x1982U,
	 0x01f2U, 0x12ffU, 0x10bdU, 0x04a2U, 0x0296U, 0x1815U, 0x135cU, 0x0a1bU,
	 0x0894U, 0x0a8bU, 0x00ceU, 0x0aaeU, 0x1035U, 0x1c38U, 0x14d7U, 0x10eaU,
	 0x0880U, 0x1dc9U, 0x042aU, 0x142dU, 0x068bU, 0x0edbU, 0x1f35U, 0x14dbU,
	 0x1b65U, 0x1840U}
}; /* curve_point */

#elif GF_M == 1507

const order_t prime_order = {
	 0x005dU, 0x813fU, 0xbb06U, 0x9925U, 0xeb0eU, 0xb02aU, 0x3b9eU, 0xffb7U,
	 0x5ed1U, 0xbcf8U, 0xcea3U, 0xe3c5U, 0x2be1U, 0xedd4U, 0xb67fU, 0xb442U,
	 0xa22cU, 0x7696U, 0x6861U, 0x05cdU, 0xcfd3U, 0x6dadU, 0xf154U, 0x7db2U,
	 0xe41dU, 0x63daU, 0x5e27U, 0x29daU, 0xe395U, 0xe757U, 0x677aU, 0x31c4U,
	 0x20a8U, 0x1769U, 0x5871U, 0xd0c4U, 0xad2cU, 0x948eU, 0x7ef6U, 0xbf01U,
	 0xe366U, 0x7439U, 0x229dU, 0x05b6U, 0xb0d6U, 0xd121U, 0xa6c8U, 0xc73cU,
	 0xa4f0U, 0xffbaU, 0x6022U, 0x71dbU, 0xb265U, 0xae45U, 0xf3e8U, 0x802cU,
	 0x8d8aU, 0xb176U, 0x15daU, 0x0a4eU, 0xca35U, 0x7408U, 0xc0b4U, 0x7a03U,
	 0x9c80U, 0x665bU, 0xbf4fU, 0x1d16U, 0x6b65U, 0xf349U, 0xc53aU, 0x9c78U,
	 0x3826U, 0xaf84U, 0x69ccU, 0x6250U, 0x802aU, 0x7e23U, 0x56ddU, 0xda17U,
	 0xb1f1U, 0xf92aU, 0x0700U, 0xfed6U, 0x0553U, 0xf2a5U, 0xeb7aU, 0xf634U,
	 0x474fU, 0x9875U, 0x2736U, 0x205cU, 0x088fU, 0x5233U
}; /* prime_order (1487 bits) */

const ecPoint curve_point = {
	{0x0089U, 0x00ceU, 0x00daU, 0x03d6U, 0x03b1U, 0x05abU, 0x02a5U, 0x050aU,
	 0x0096U, 0x03a0U, 0x040cU, 0x0470U, 0x0174U, 0x0100U, 0x0768U, 0x06aeU,
	 0x061eU, 0x0121U, 0x01b8U, 0x06baU, 0x01d6U, 0x017cU, 0x0394U, 0x02daU,
	 0x017cU, 0x07a6U, 0x0328U, 0x01cbU, 0x040bU, 0x06a6U, 0x0006U, 0x0298U,
	 0x01a8U, 0x0674U, 0x043aU, 0x013cU, 0x04d7U, 0x0370U, 0x00daU, 0x06e5U,
	 0x020bU, 0x01a3U, 0x03daU, 0x01f4U, 0x03a5U, 0x0603U, 0x066aU, 0x0450U,
	 0x00a5U, 0x0360U, 0x032aU, 0x0502U, 0x0790U, 0x0016U, 0x06d7U, 0x042cU,
	 0x057bU, 0x0577U, 0x0693U, 0x029fU, 0x02d7U, 0x02e6U, 0x0163U, 0x02ecU,
	 0x0752U, 0x02c5U, 0x0262U, 0x02ebU, 0x0358U, 0x02d6U, 0x0630U, 0x070dU,
	 0x005aU, 0x04d5U, 0x058cU, 0x0790U, 0x0392U, 0x0527U, 0x05eeU, 0x00b1U,
	 0x0585U, 0x0212U, 0x0470U, 0x026cU, 0x012aU, 0x04caU, 0x042fU, 0x077aU,
	 0x0387U, 0x0561U, 0x023cU, 0x0778U, 0x01daU, 0x041cU, 0x01c8U, 0x071dU,
	 0x048cU, 0x03abU, 0x019fU, 0x031fU, 0x03eaU, 0x004eU, 0x02a3U, 0x06d8U,
	 0x0061U, 0x0145U, 0x03b7U, 0x0176U, 0x0609U, 0x049aU, 0x020fU, 0x077cU,
	 0x0465U, 0x0310U, 0x05feU, 0x009dU, 0x004fU, 0x0504U, 0x042bU, 0x0106U,
	 0x0493U, 0x040cU, 0x0733U, 0x003eU, 0x0394U, 0x03d6U, 0x0786U, 0x06a2U,
	 0x073cU, 0x0085U, 0x0322U, 0x0667U, 0x02b1U, 0x0045U, 0x0215U, 0x0077U,
	 0x0060U, 0x024bU},
	{0x0089U, 0x07cbU, 0x017aU, 0x0619U, 0x0189U, 0x00efU, 0x0752U, 0x0394U,
	 0x0116U, 0x0652U, 0x005cU, 0x06ceU, 0x044eU, 0x0702U, 0x021fU, 0x01a8U,
	 0x04d6U, 0x0367U, 0x0127U, 0x0050U, 0x064fU, 0x0127U, 0x0526U, 0x0260U,
	 0x07cdU, 0x028eU, 0x05ceU, 0x011eU, 0x033aU, 0x0016U, 0x048eU, 0x0528U,
	 0x01a7U, 0x0149U, 0x02a7U, 0x0589U, 0x0620U, 0x044eU, 0x02c3U, 0x0364U,
	 0x00f3U, 0x06eaU, 0x027fU, 0x005bU, 0x0750U, 0x06d5U, 0x01a0U, 0x0621U,
	 0x0204U, 0x07acU, 0x03d1U, 0x0543U, 0x0123U, 0x065bU, 0x0729U, 0x0121U,
	 0x0708U, 0x03ecU, 0x0782U, 0x06e7U, 0x0589U, 0x02d2U, 0x052aU, 0x07a7U,
	 0x066aU, 0x0083U, 0x05fdU, 0x0167U, 0x0249U, 0x0678U, 0x0123U, 0x0151U,
	 0x006bU, 0x0110U, 0x02c1U, 0x00f8U, 0x055cU, 0x020eU, 0x0378U, 0x04eeU,
	 0x0182U, 0x024fU, 0x07bcU, 0x042eU, 0x0245U, 0x051eU, 0x0079U, 0x0681U,
	 0x0003U, 0x01e0U, 0x06f5U, 0x01dcU, 0x04a0U, 0x04aeU, 0x057bU, 0x055eU,
	 0x0159U, 0x0446U, 0x0292U, 0x03b6U, 0x017cU, 0x07e4U, 0x0304U, 0x00b8U,
	 0x00b4U, 0x01c4U, 0x0778U, 0x019bU, 0x046bU, 0x07a3U, 0x0153U, 0x01d4U,
	 0x045bU, 0x0570U, 0x0601U, 0x057eU, 0x065cU, 0x028bU, 0x03f8U, 0x0433U,
	 0x07d0U, 0x076cU, 0x02a3U, 0x079eU, 0x0444U, 0x05e8U, 0x0337U, 0x060cU,
	 0x07edU, 0x0193U, 0x0652U, 0x0683U, 0x0219U, 0x0237U, 0x018eU, 0x0227U,
	 0x05e6U, 0x02c1U}
}; /* curve_point */

#elif GF_M == 1510

const order_t prime_order = {
	 0x005eU, 0x6897U, 0xdd41U, 0xba06U, 0xc5f4U, 0xb5bbU, 0x84abU, 0x6a9aU,
	 0xc87dU, 0xaaf4U, 0xf43eU, 0xdc02U, 0x7e24U, 0x184fU, 0x5254U, 0xe6f9U,
	 0x967dU, 0xeae1U, 0xf5a0U, 0xcf0fU, 0x9645U, 0x5c0fU, 0xfc57U, 0x3800U,
	 0xb6e1U, 0xf27aU, 0x6732U, 0x69edU, 0x30ffU, 0x9f23U, 0x0d23U, 0xb5ceU,
	 0x7c08U, 0x564bU, 0x6286U, 0xbe3eU, 0xac9bU, 0xdf51U, 0x9493U, 0xe792U,
	 0x92c1U, 0xd204U, 0x2f7bU, 0xfd0eU, 0xe878U, 0x1033U, 0xb375U, 0x02d1U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U,
	 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x0000U, 0x1000U
}; /* prime_order (1501 bits) */

const ecPoint curve_point = {
	{0x0097U, 0x001cU, 0x032aU, 0x020fU, 0x02aeU, 0x0244U, 0x01e1U, 0x03e0U,
	 0x017eU, 0x01c8U, 0x0159U, 0x0372U, 0x023fU, 0x01beU, 0x0228U, 0x022eU,
	 0x023bU, 0x01ccU, 0x011cU, 0x0105U, 0x015eU, 0x01bbU, 0x0372U, 0x01f7U,
	 0x0172U, 0x007dU, 0x028fU, 0x0216U, 0x0247U, 0x03d1U, 0x003fU, 0x02bbU,
	 0x0198U, 0x02ccU, 0x0043U, 0x0149U, 0x0225U, 0x0173U, 0x03a9U, 0x0324U,
	 0x030bU, 0x02ccU, 0x00f8U, 0x02f6U, 0x0151U, 0x0271U, 0x0351U, 0x006cU,
	 0x01daU, 0x029dU, 0x03e4U, 0x0326U, 0x0103U, 0x02b8U, 0x031dU, 0x0007U,
	 0x00dbU, 0x01dbU, 0x01caU, 0x03b7U, 0x03a0U, 0x03dcU, 0x01caU, 0x00ecU,
	 0x01f6U, 0x020fU, 0x0100U, 0x02e2U, 0x02c9U, 0x02c1U, 0x039aU, 0x0312U,
	 0x01caU, 0x00eeU, 0x03edU, 0x0224U, 0x0218U, 0x010dU, 0x0336U, 0x0359U,
	 0x0138U, 0x0310U, 0x0030U, 0x0026U, 0x0166U, 0x0330U, 0x0075U, 0x00f1U,
	 0x025cU, 0x004dU, 0x01bbU, 0x01ceU, 0x0188U, 0x00aaU, 0x0324U, 0x0263U,
	 0x0287U, 0x00cdU, 0x0177U, 0x0027U, 0x014eU, 0x02edU, 0x0135U, 0x01e2U,
	 0x01bdU, 0x0245U, 0x0382U, 0x02e0U, 0x017fU, 0x0398U, 0x0286U, 0x023bU,
	 0x03c4U, 0x016bU, 0x0021U, 0x026bU, 0x01c6U, 0x0077U, 0x0365U, 0x00d3U,
	 0x0307U, 0x03bbU, 0x003cU, 0x0282U, 0x0122U, 0x0285U, 0x020aU, 0x03fbU,
	 0x01cdU, 0x00f5U, 0x02c1U, 0x0012U, 0x0205U, 0x02ccU, 0x03f4U, 0x00f5U,
	 0x015bU, 0x0198U, 0x0117U, 0x0212U, 0x0386U, 0x02ebU, 0x03a3U, 0x0223U,
	 0x00f5U, 0x0030U, 0x0230U, 0x0134U, 0x01a1U, 0x0124U, 0x01f4U, 0x0064U},
	{0x0097U, 0x02f0U, 0x0326U, 0x01ceU, 0x00d6U, 0x0152U, 0x0247U, 0x03cdU,
	 0x00f4U, 0x01f9U, 0x01b8U, 0x00baU, 0x01b6U, 0x0081U, 0x013aU, 0x0117U,
	 0x02b7U, 0x0107U, 0x027cU, 0x0085U, 0x00b3U, 0x0333U, 0x009cU, 0x004dU,
	 0x01b0U, 0x0374U, 0x0383U, 0x0392U, 0x014aU, 0x03e3U, 0x014cU, 0x00e1U,
	 0x017aU, 0x0014U, 0x0154U, 0x03b5U, 0x0207U, 0x02baU, 0x036cU, 0x0118U,
	 0x0166U, 0x000fU, 0x0302U, 0x00dbU, 0x0124U, 0x01cfU, 0x02baU, 0x00b8U,
	 0x030dU, 0x034bU, 0x0036U, 0x026dU, 0x01f1U, 0x0002U, 0x03adU, 0x0141U,
	 0x0281U, 0x0226U, 0x0147U, 0x0167U, 0x01c5U, 0x02d5U, 0x036eU, 0x0060U,
	 0x0161U, 0x0315U, 0x00cbU, 0x0281U, 0x0151U, 0x00a3U, 0x0392U, 0x01e4U,
	 0x0022U, 0x0021U, 0x0377U, 0x003dU, 0x00e0U, 0x02d8U, 0x03f3U, 0x00ebU,
	 0x0006U, 0x03caU, 0x026eU, 0x03b1U, 0x0331U, 0x038dU, 0x00edU, 0x03cfU,
	 0x021dU, 0x0371U, 0x00d3U, 0x0023U, 0x02d3U, 0x01a5U, 0x0244U, 0x0347U,
	 0x00f4U, 0x0347U, 0x0141U, 0x0364U, 0x0284U, 0x01dbU, 0x0083U, 0x0353U,
	 0x0077U, 0x018eU, 0x0339U, 0x0058U, 0x0136U, 0x0072U, 0x0148U, 0x01f7U,
	 0x0382U, 0x00f4U, 0x008fU, 0x00faU, 0x0155U, 0x02a7U, 0x016bU, 0x01a5U,
	 0x0152U, 0x011fU, 0x002bU, 0x0249U, 0x011cU, 0x0184U, 0x00abU, 0x0117U,
	 0x00b6U, 0x01e5U, 0x0377U, 0x032cU, 0x0046U, 0x017fU, 0x00e3U, 0x03e4U,
	 0x030cU, 0x012dU, 0x00f2U, 0x0312U, 0x036aU, 0x0145U, 0x0103U, 0x0002U,
	 0x0254U, 0x0345U, 0x0311U, 0x02c9U, 0x0343U, 0x025dU, 0x017cU, 0x030fU}
}; /* curve_point */

#elif GF_M == 1528

const order_t prime_order = {
	 0x0060U, 0x1797U, 0xe2e2U, 0x03d5U, 0xe9bfU, 0x1d3cU, 0x0c95U, 0xdfa3U,
	 0x7eb6U, 0x2e81U, 0x6a3cU, 0x73a2U, 0x80ebU, 0x1a84U, 0x572dU, 0xbecdU,
	 0x73ecU, 0xa884U, 0x40b3U, 0x2f31U, 0x0c26U, 0x3d85U, 0xded9U, 0xeaf3U,
	 0x1cd9U, 0x8112U, 0xcf38U, 0x0cbaU, 0x2bc0U, 0x201bU, 0x4fd6U, 0xa012U,
	 0x72bbU, 0x274eU, 0x2942U, 0xe8eeU, 0x3a61U, 0xaf7aU, 0xda48U, 0x04bfU,
	 0xee95U, 0x493fU, 0x4109U, 0x60deU, 0x06c1U, 0xca11U, 0x3ad9U, 0xff1cU,
	 0x11caU, 0x7b96U, 0x611aU, 0xa7b9U, 0x9611U, 0x1a7bU, 0xb961U, 0x11a7U,
	 0x7b96U, 0x611aU, 0xa7b9U, 0x9611U, 0x1a7bU, 0xb961U, 0x11a7U, 0x7b96U,
	 0x611aU, 0xa7b9U, 0x9611U, 0x1a7bU, 0xb961U, 0x11a7U, 0x7b96U, 0x611aU,
	 0xa7b9U, 0x9611U, 0x1a7bU, 0xb961U, 0x11a7U, 0x7b96U, 0x611aU, 0xa7b9U,
	 0x9611U, 0x1a7bU, 0xb961U, 0x11a7U, 0x7b96U, 0x611aU, 0xa7b9U, 0x9611U,
	 0x1a7bU, 0xb961U, 0x11a7U, 0x7b96U, 0x611aU, 0xa7b9U, 0x9611U, 0x1a7bU,
	 0x0001U
}; /* prime_order (1521 bits) */

const ecPoint curve_point = {
	{0x00bfU, 0x000aU, 0x001fU, 0x009aU, 0x0083U, 0x002fU, 0x00eeU, 0x006eU,
	 0x00f8U, 0x0037U, 0x00f8U, 0x00daU, 0x0084U, 0x00abU, 0x00c7U, 0x00dfU,
	 0x0005U, 0x006dU, 0x00e0U, 0x0014U, 0x001cU, 0x00f3U, 0x0004U, 0x0051U,
	 0x0019U, 0x00f3U, 0x000aU, 0x0072U, 0x005bU, 0x00c8U, 0x00f9U, 0x0030U,
	 0x00c9U, 0x006dU, 0x00c7U, 0x0094U, 0x00cfU, 0x0003U, 0x00f3U, 0x00b8U,
	 0x002dU, 0x00d5U, 0x003cU, 0x0011U, 0x00f7U, 0x0056U, 0x0063U, 0x0013U,
	 0x0083U, 0x0091U, 0x00a7U, 0x00dbU, 0x003dU, 0x00bdU, 0x000bU, 0x00d0U,
	 0x002eU, 0x0060U, 0x0099U, 0x00b2U, 0x005fU, 0x00a2U, 0x00e0U, 0x00eeU,
	 0x008dU, 0x0060U, 0x0011U, 0x0000U, 0x0089U, 0x0039U, 0x00e5U, 0x00baU,
	 0x0008U, 0x0030U, 0x0074U, 0x0083U, 0x00a5U, 0x00e5U, 0x00c0U, 0x0049U,
	 0x0081U, 0x0082U, 0x000fU, 0x00e1U, 0x002bU, 0x0087U, 0x0083U, 0x000dU,
	 0x00ebU, 0x00e2U, 0x00efU, 0x00acU, 0x00d5U, 0x0099U, 0x0007U, 0x00cdU,
	 0x00f0U, 0x0083U, 0x003eU, 0x005fU, 0x003bU, 0x002eU, 0x004dU, 0x0002U,
	 0x00faU, 0x0039U, 0x00caU, 0x004eU, 0x00feU, 0x0080U, 0x0003U, 0x0029U,
	 0x004dU, 0x0002U, 0x0036U, 0x0082U, 0x0005U, 0x00cfU, 0x00f8U, 0x00a2U,
	 0x00eaU, 0x0053U, 0x0065U, 0x00c8U, 0x00ebU, 0x00dcU, 0x00e5U, 0x0045U,
	 0x00bcU, 0x0060U, 0x009cU, 0x00cfU, 0x0032U, 0x00d8U, 0x003bU, 0x003aU,
	 0x006bU, 0x002fU, 0x0028U, 0x0052U, 0x0030U, 0x0029U, 0x001aU, 0x0065U,
	 0x0053U, 0x00f5U, 0x0062U, 0x00b7U, 0x002bU, 0x006eU, 0x00ddU, 0x0011U,
	 0x00bcU, 0x00bdU, 0x009cU, 0x00afU, 0x0007U, 0x00c7U, 0x000eU, 0x008bU,
	 0x00bdU, 0x00f9U, 0x003eU, 0x00d8U, 0x00deU, 0x00e2U, 0x0070U, 0x0064U,
	 0x008aU, 0x009eU, 0x008aU, 0x00b6U, 0x00c3U, 0x0080U, 0x005eU, 0x0008U,
	 0x00f6U, 0x00f0U, 0x0071U, 0x004bU, 0x00a0U, 0x00ceU, 0x00c3U, 0x0086U,
	 0x004eU, 0x00f8U, 0x005dU, 0x0044U, 0x003cU, 0x0086U, 0x002bU, 0x0027U},
	{0x00bfU, 0x0099U, 0x00e4U, 0x0098U, 0x00c7U, 0x00f5U, 0x00c9U, 0x00fdU,
	 0x00c3U, 0x0017U, 0x00ecU, 0x007fU, 0x00cfU, 0x0041U, 0x0062U, 0x004aU,
	 0x00b4U, 0x00b1U, 0x00cdU, 0x001eU, 0x00a6U, 0x004dU, 0x00ffU, 0x0090U,
	 0x007fU, 0x0037U, 0x005fU, 0x009cU, 0x00e8U, 0x00a3U, 0x00d3U, 0x00c0U,
	 0x00c8U, 0x00e5U, 0x008eU, 0x0071U, 0x0062U, 0x0003U, 0x0008U, 0x0093U,
	 0x0001U, 0x0078U, 0x00a1U, 0x0000U, 0x0028U, 0x0097U, 0x004eU, 0x00faU,
	 0x0045U, 0x00c8U, 0x00beU, 0x0025U, 0x0075U, 0x0090U, 0x00cbU, 0x008cU,
	 0x009fU, 0x001aU, 0x005dU, 0x0037U, 0x00c5U, 0x008dU, 0x0027U, 0x004fU,
	 0x00a9U, 0x00aeU, 0x00a1U, 0x0020U, 0x0009U, 0x000aU, 0x0029U, 0x000cU,
	 0x003dU, 0x0042U, 0x0061U, 0x00ceU, 0x00ebU, 0x00a3U, 0x0097U, 0x00d1U,
	 0x00c0U, 0x00c2U, 0x00d5U, 0x0082U, 0x0014U, 0x0007U, 0x0045U, 0x00ffU,
	 0x0052U, 0x0038U, 0x0037U, 0x000bU, 0x003eU, 0x0057U, 0x0070U, 0x00e9U,
	 0x0060U, 0x0022U, 0x00edU, 0x00ebU, 0x007dU, 0x00d5U, 0x00b9U, 0x0054U,
	 0x00c6U, 0x00aeU, 0x002eU, 0x0026U, 0x00d7U, 0x00ecU, 0x0009U, 0x008cU,
	 0x00caU, 0x00bcU, 0x00d3U, 0x006fU, 0x0014U, 0x006fU, 0x006dU, 0x00bdU,
	 0x0010U, 0x0033U, 0x00daU, 0x001bU, 0x005dU, 0x0065U, 0x0005U, 0x0099U,
	 0x00f9U, 0x004eU, 0x00e2U, 0x00b6U, 0x00adU, 0x0040U, 0x0049U, 0x0026U,
	 0x00d6U, 0x00e0U, 0x0037U, 0x00f2U, 0x009cU, 0x00d3U, 0x00f6U, 0x00bfU,
	 0x006eU, 0x00cbU, 0x0011U, 0x00acU, 0x00feU, 0x0000U, 0x0054U, 0x00c2U,
	 0x004fU, 0x001bU, 0x00cdU, 0x00beU, 0x0061U, 0x00dbU, 0x00b9U, 0x00c3U,
	 0x0096U, 0x003aU, 0x0001U, 0x00c4U, 0x00efU, 0x00ebU, 0x00c9U, 0x00f8U,
	 0x0007U, 0x000eU, 0x0036U, 0x0012U, 0x000bU, 0x0043U, 0x0096U, 0x0032U,
	 0x0020U, 0x0079U, 0x0053U, 0x0072U, 0x000cU, 0x0006U, 0x0034U, 0x00aeU,
	 0x000bU, 0x008bU, 0x00c8U, 0x0072U, 0x00efU, 0x0096U, 0x0015U, 0x00afU}
}; /* curve_point */

#elif GF_M == 1545

const order_t prime_order = {
	 0x0060U, 0x0cafU, 0x7497U, 0xdcefU, 0x1bb6U, 0xd3b7U, 0xa574U, 0x12fbU,
	 0x89c7U, 0xdeb8U, 0xb686U, 0x9f47U, 0x28efU, 0x94e7U, 0xe8f4U, 0x468bU,
	 0x2f8dU, 0x5d76U, 0x9c26U, 0x677fU, 0xf86fU, 0xa88dU, 0xd0aaU, 0x5d66U,
	 0xd9a3U, 0xb604U, 0x7208U, 0x0930U, 0x2836U, 0xc931U, 0x203cU, 0x5222U,
	 0x9c7dU, 0x37fcU, 0x79e1U, 0x8798U, 0x8bc1U, 0xfddeU, 0xd48eU, 0x29e5U,
	 0xb71cU, 0xdbd4U, 0x1150U, 0xbba3U, 0x4391U, 0xc10cU, 0x25a7U, 0x3751U,
	 0x408cU, 0x2ea7U, 0x2f07U, 0x8f05U, 0x725aU, 0x42f3U, 0x53f0U, 0xfe40U,
	 0xeab3U, 0x85c6U, 0xdd36U, 0x060eU, 0xe535U, 0xb08eU, 0x81a7U, 0xbd4cU,
	 0x4163U, 0xeea3U, 0xf5b1U, 0x3036U, 0x9454U, 0x9793U, 0x2cd7U, 0x3466U,
	 0x9993U, 0xd777U, 0x9b82U, 0x9cc2U, 0x8766U, 0x27d8U, 0x89d6U, 0x17cbU,
	 0x4f81U, 0x63adU, 0xbdecU, 0x36b5U, 0xbedcU, 0xa6b0U, 0xf731U, 0xb02eU,
	 0x21a9U, 0xd9f7U, 0x70caU, 0xdda6U, 0x4b61U, 0x43c3U, 0xf941U, 0x4023U,
	 0x03ffU
}; /* prime_order (1530 bits) */

const ecPoint curve_point = {
	{0x0067U, 0x7cd6U, 0x58cdU, 0x31afU, 0x5f38U, 0x483cU, 0x03fbU, 0x0d40U,
	 0x28e8U, 0x49a3U, 0x28daU, 0x0479U, 0x02aeU, 0x0800U, 0x5f2aU, 0x483aU,
	 0x37b2U, 0x1a92U, 0x334fU, 0x217cU, 0x7f87U, 0x1310U, 0x0addU, 0x3b79U,
	 0x094cU, 0x7d04U, 0x6b80U, 0x55a9U, 0x2c4aU, 0x2311U, 0x53d9U, 0x48f5U,
	 0x4a2fU, 0x14c1U, 0x726eU, 0x779eU, 0x527dU, 0x5283U, 0x717dU, 0x1c47U,
	 0x4190U, 0x0257U, 0x5dc0U, 0x6750U, 0x648bU, 0x5ca6U, 0x04c3U, 0x25c7U,
	 0x218dU, 0x40d8U, 0x6d35U, 0x615cU, 0x74f9U, 0x4495U, 0x10e1U, 0x66fbU,
	 0x068fU, 0x2f7fU, 0x2af8U, 0x279fU, 0x7126U, 0x7460U, 0x1cbbU, 0x1f98U,
	 0x7e0fU, 0x4536U, 0x0d4fU, 0x7207U, 0x3186U, 0x7419U, 0x7146U, 0x4a4dU,
	 0x2777U, 0x2c09U, 0x3df3U, 0x411cU, 0x20c3U, 0x26d9U, 0x705eU, 0x722fU,
	 0x0923U, 0x7f49U, 0x3ea5U, 0x7595U, 0x043eU, 0x14ebU, 0x6a63U, 0x5e10U,
	 0x6dd6U, 0x6d9fU, 0x6d89U, 0x4581U, 0x36beU, 0x7288U, 0x57e9U, 0x4167U,
	 0x7cbeU, 0x42cbU, 0x146cU, 0x4190U, 0x3808U, 0x1621U, 0x7e44U, 0x60b5U},
	{0x0067U, 0x7dcfU, 0x0ae9U, 0x4806U, 0x70bdU, 0x6059U, 0x4909U, 0x0b33U,
	 0x5d49U, 0x50c0U, 0x35d6U, 0x5179U, 0x536fU, 0x76b5U, 0x7ed3U, 0x3ff8U,
	 0x0939U, 0x1108U, 0x7237U, 0x0277U, 0x6be5U, 0x4ae2U, 0x5dc6U, 0x09c4U,
	 0x6f85U, 0x679cU, 0x5bb4U, 0x1d00U, 0x4eeaU, 0x03ccU, 0x1119U, 0x5747U,
	 0x2b79U, 0x2e8aU, 0x61bfU, 0x1fe2U, 0x02b6U, 0x7889U, 0x14f4U, 0x3bf7U,
	 0x758dU, 0x5c58U, 0x05f7U, 0x0bbbU, 0x1b4cU, 0x7d3bU, 0x74d6U, 0x3999U,
	 0x6cd6U, 0x6157U, 0x2234U, 0x0e28U, 0x7dc3U, 0x0f74U, 0x158aU, 0x0cd2U,
	 0x3febU, 0x2349U, 0x25b1U, 0x6496U, 0x7d12U, 0x3026U, 0x791bU, 0x45efU,
	 0x02adU, 0x5a66U, 0x4d2fU, 0x2b78U, 0x15deU, 0x1c23U, 0x33c2U, 0x1074U,
	 0x012eU, 0x0a82U, 0x0221U, 0x202dU, 0x6b02U, 0x4258U, 0x672cU, 0x43d1U,
	 0x2f76U, 0x6755U, 0x1dd1U, 0x727bU, 0x73b6U, 0x327eU, 0x691aU, 0x7614U,
	 0x5aa8U, 0x5096U, 0x5e7dU, 0x673aU, 0x1d6cU, 0x6a19U, 0x299fU, 0x1301U,
	 0x2778U, 0x4c24U, 0x5b05U, 0x3adcU, 0x3230U, 0x44b4U, 0x1802U, 0x3da8U}
}; /* curve_point */

#elif GF_M == 1552

const order_t prime_order = {
	 0x0060U, 0xe861U, 0x5da3U, 0xc3f7U, 0x8f9dU, 0xaebaU, 0x86f7U, 0xffcaU,
	 0xb055U, 0x1b41U, 0xe7e3U, 0x7817U, 0xff84U, 0xa49eU, 0x5fbeU, 0x0a35U,
	 0x3a8dU, 0x63d4U, 0x145fU, 0x06a0U, 0xca85U, 0xd538U, 0xa8a2U, 0x8093U,
	 0x812bU, 0x673eU, 0xbc07U, 0x5173U, 0x4f1bU, 0x1969U, 0xcbfaU, 0xefd8U,
	 0x3963U, 0x4f6cU, 0x9e60U, 0x98d1U, 0x9427U, 0xe759U, 0x9a17U, 0x4fa5U,
	 0x0b0bU, 0x0de7U, 0x3fa2U, 0x757aU, 0x4b08U, 0x17baU, 0xf85bU, 0xf479U,
	 0x0288U, 0x0ff8U, 0x3fe0U, 0xff80U, 0xfe00U, 0xf803U, 0xe00fU, 0x803fU,
	 0x00ffU, 0x03feU, 0x0ff8U, 0x3fe0U, 0xff80U, 0xfe00U, 0xf803U, 0xe00fU,
	 0x803fU, 0x00ffU, 0x03feU, 0x0ff8U, 0x3fe0U, 0xff80U, 0xfe00U, 0xf803U,
	 0xe00fU, 0x803fU, 0x00ffU, 0x03feU, 0x0ff8U, 0x3fe0U, 0xff80U, 0xfe00U,
	 0xf803U, 0xe00fU, 0x803fU, 0x00ffU, 0x03feU, 0x0ff8U, 0x3fe0U, 0xff80U,
	 0xfe00U, 0xf803U, 0xe00fU, 0x803fU, 0x00ffU, 0x03feU, 0x0ff8U, 0x3fe0U,
	 0xff80U
}; /* prime_order (1536 bits) */

const ecPoint curve_point = {
	{0x0061U, 0x1f97U, 0x9af8U, 0xcc9aU, 0xcb02U, 0x167fU, 0x2dedU, 0xcc1bU,
	 0x3452U, 0x0fa9U, 0x8543U, 0x360cU, 0x013aU, 0x9934U, 0x87a6U, 0x1441U,
	 0x0798U, 0x02c9U, 0xb2dfU, 0x17e8U, 0x584fU, 0xea9bU, 0x9a16U, 0xb0a7U,
	 0xc326U, 0x755aU, 0x3624U, 0x0dc8U, 0x74fdU, 0xa813U, 0xca40U, 0xb524U,
	 0x5ecaU, 0x7672U, 0x5142U, 0xe084U, 0x2c1cU, 0x8d9bU, 0x46cfU, 0x5e5dU,
	 0x4efaU, 0x4c52U, 0x0ef6U, 0xe7b5U, 0x5b73U, 0x9328U, 0x1f0dU, 0xab6bU,
	 0xd733U, 0x4019U, 0xa6d9U, 0x8556U, 0xe437U, 0xe84cU, 0xa733U, 0xd344U,
	 0x70d8U, 0x71cdU, 0xb22fU, 0xcd74U, 0xddc8U, 0xf2f7U, 0x3f61U, 0xe3bcU,
	 0x395dU, 0x2270U, 0x855fU, 0x6c1cU, 0x180cU, 0xd54cU, 0x10ccU, 0x0584U,
	 0x0525U, 0x7400U, 0x3007U, 0xa21fU, 0x9fa1U, 0xd43aU, 0xf751U, 0x57e8U,
	 0xb117U, 0x1331U, 0x010fU, 0x3d30U, 0x5318U, 0xeafeU, 0x0f7dU, 0x1755U,
	 0xa217U, 0x2030U, 0xc03fU, 0xa02eU, 0x095aU, 0xacdcU, 0xc551U, 0x0669U,
	 0x0961U, 0x2f3eU},
	{0x0061U, 0x1220U, 0x90ffU, 0x52bbU, 0x79fdU, 0x629cU, 0x9b80U, 0xe3b3U,
	 0x58daU, 0xf48aU, 0xb80bU, 0xe93cU, 0xbfcaU, 0x4b7dU, 0x3cd2U, 0x0e1cU,
	 0xca31U, 0x3fa2U, 0x27b5U, 0x726cU, 0xe6dfU, 0xbb79U, 0x2d7aU, 0x4b0bU,
	 0xbf0fU, 0x50fcU, 0x9355U, 0xf3b5U, 0x2c19U, 0x2ce4U, 0xd4a0U, 0x08ccU,
	 0xa62aU, 0x1372U, 0x84f3U, 0xd119U, 0x0281U, 0x0627U, 0xc082U, 0x0c9cU,
	 0xc672U, 0x9015U, 0xe85dU, 0x5f01U, 0x9f05U, 0x5fadU, 0xe6c0U, 0xadcfU,
	 0x758bU, 0x1bd9U, 0x3cadU, 0xe92aU, 0x4238U, 0x609aU, 0x70dfU, 0xe9baU,
	 0x49e1U, 0x6133U, 0x424dU, 0x44a2U, 0xbfc7U, 0xad23U, 0x0b62U, 0xddddU,
	 0xa98fU, 0xa089U, 0x8389U, 0xac3fU, 0xd119U, 0xb0d1U, 0x25e7U, 0xb7e9U,
	 0xa4ccU, 0xa74dU, 0x8e27U, 0xdd07U, 0x7573U, 0xbd53U, 0x9acfU, 0xfecaU,
	 0xf4e1U, 0x30a8U, 0xed1fU, 0x86a7U, 0xf4ecU, 0x2e3cU, 0x9ed3U, 0x5412U,
	 0x620eU, 0xb76bU, 0xca49U, 0x4bf7U, 0x8b3cU, 0x76ebU, 0x80cdU, 0x4b6bU,
	 0x3e67U, 0x98c6U}
}; /* curve_point */

#elif GF_M == 1582

const order_t prime_order = {
	 0x0062U, 0xd1b1U, 0xf337U, 0x602eU, 0x0609U, 0x79dbU, 0x5744U, 0xd083U,
	 0xbf5cU, 0xbba5U, 0x11dfU, 0x63f1U, 0x67a0U, 0xf43aU, 0xead8U, 0x40b1U,
	 0x9d7aU, 0x2585U, 0xccfcU, 0x7434U, 0x9fe4U, 0xf5d6U, 0xf43fU, 0x3165U,
	 0x9103U, 0x4c70U, 0x8429U, 0xcad9U, 0x65d3U, 0xc41aU, 0x3b13U, 0x801bU,
	 0xf64dU, 0xd7f6U, 0x245aU, 0xf2cbU, 0xde61U, 0x6cfaU, 0xe154U, 0x5129U,
	 0x4aecU, 0x094dU, 0x02b2U, 0x9f87U, 0xa264U, 0xdfd4U, 0xc111U, 0x6b4dU,
	 0xdf33U, 0xa836U, 0x9a1fU, 0xd23cU, 0x61e2U, 0xc763U, 0x838dU, 0xb72dU,
	 0xf3a7U, 0x5b46U, 0x45d4U, 0x7f90U, 0x50cdU, 0xd918U, 0xd9d7U, 0xbd09U,
	 0x9204U, 0x8a49U, 0xb3efU, 0x7079U, 0x15b2U, 0xbcaaU, 0x206bU, 0x1fccU,
	 0xb7cdU, 0x5ba6U, 0xb76dU, 0xea0dU, 0x4cefU, 0xedebU, 0x381cU, 0x8fa6U,
	 0x6580U, 0xbc2aU, 0x339fU, 0x3c7aU, 0x679fU, 0xea8dU, 0x39bbU, 0xd13dU,
	 0x884aU, 0x00bfU, 0xe332U, 0xd4faU, 0xf844U, 0x29a5U, 0xbc8aU, 0xa538U,
	 0xa6f7U, 0x63c1U, 0xff60U
}; /* prime_order (1568 bits) */

const ecPoint curve_point = {
	{0x0071U, 0x1abaU, 0x30deU, 0x29fbU, 0x0021U, 0x33e2U, 0x390aU, 0x2136U,
	 0x25f1U, 0x2350U, 0x0e74U, 0x1583U, 0x3a18U, 0x21e0U, 0x1b53U, 0x0757U,
	 0x1930U, 0x357eU, 0x011bU, 0x32dcU, 0x21dbU, 0x0049U, 0x0d17U, 0x193bU,
	 0x398dU, 0x3793U, 0x23dcU, 0x3a26U, 0x34f1U, 0x2637U, 0x2a6eU, 0x1b0dU,
	 0x1c93U, 0x3c69U, 0x1ff8U, 0x12b2U, 0x152aU, 0x3d2aU, 0x1255U, 0x33fbU,
	 0x2559U, 0x3caaU, 0x2064U, 0x0448U, 0x0f20U, 0x0412U, 0x0d1fU, 0x2997U,
	 0x065fU, 0x2472U, 0x111fU, 0x3d7eU, 0x3163U, 0x2ec1U, 0x2e48U, 0x0b6dU,
	 0x0d7fU, 0x0029U, 0x3391U, 0x26a3U, 0x0225U, 0x162cU, 0x05c4U, 0x1a6cU,
	 0x0fa2U, 0x129bU, 0x17bfU, 0x1da5U, 0x24e0U, 0x124cU, 0x3903U, 0x31dfU,
	 0x04dfU, 0x174fU, 0x02ecU, 0x36b8U, 0x380eU, 0x2d2dU, 0x30deU, 0x3b8cU,
	 0x3e4cU, 0x156eU, 0x015bU, 0x32e4U, 0x2d62U, 0x1d76U, 0x1d96U, 0x2859U,
	 0x3568U, 0x0d3cU, 0x3102U, 0x144dU, 0x2650U, 0x188fU, 0x0969U, 0x1bf7U,
	 0x233dU, 0x1558U, 0x02cdU, 0x089aU, 0x01f9U, 0x1acaU, 0x1d62U, 0x237aU,
	 0x1915U, 0x1a95U, 0x158bU, 0x2d13U, 0x08ecU, 0x143fU, 0x3f19U, 0x26aeU,
	 0x193fU, 0x3faeU},
	{0x0071U, 0x0ee0U, 0x31caU, 0x372bU, 0x0cbbU, 0x173fU, 0x3f6fU, 0x296aU,
	 0x0e8aU, 0x1e75U, 0x2f25U, 0x2410U, 0x2c06U, 0x3e91U, 0x0c73U, 0x1eacU,
	 0x2014U, 0x302cU, 0x2842U, 0x05beU, 0x17c6U, 0x1d47U, 0x395dU, 0x3487U,
	 0x33a7U, 0x286dU, 0x257aU, 0x34c7U, 0x242fU, 0x3391U, 0x3d3bU, 0x0dc6U,
	 0x3d74U, 0x1ac2U, 0x320cU, 0x08c4U, 0x0ee2U, 0x021dU, 0x383bU, 0x052fU,
	 0x0ed2U, 0x2041U, 0x1b35U, 0x0f8dU, 0x0985U, 0x0cfcU, 0x1fccU, 0x2a6fU,
	 0x3dd2U, 0x2e0fU, 0x3fbdU, 0x0d4fU, 0x24a1U, 0x2e37U, 0x218cU, 0x18fbU,
	 0x1f49U, 0x333eU, 0x1066U, 0x14d5U, 0x1d37U, 0x097dU, 0x0814U, 0x34feU,
	 0x3838U, 0x26ccU, 0x0381U, 0x0b35U, 0x20f1U, 0x36abU, 0x24d6U, 0x3528U,
	 0x1228U, 0x3f07U, 0x0678U, 0x2c4dU, 0x271dU, 0x1815U, 0x226aU, 0x17f8U,
	 0x09b7U, 0x0763U, 0x301bU, 0x1824U, 0x1deeU, 0x3263U, 0x2ce1U, 0x1a5fU,
	 0x2367U, 0x3cc8U, 0x00f6U, 0x272bU, 0x2aeeU, 0x0b78U, 0x1b00U, 0x2a5cU,
	 0x0204U, 0x0d4eU, 0x3f41U, 0x2bfeU, 0x2075U, 0x30e3U, 0x1ee1U, 0x37d6U,
	 0x209cU, 0x2e9bU, 0x25bdU, 0x329aU, 0x0173U, 0x119eU, 0x14b1U, 0x25a6U,
	 0x3adcU, 0x12eaU}
}; /* curve_point */

#elif GF_M == 1648

const order_t prime_order = {
	 0x0067U, 0xcd9bU, 0x5482U, 0x18e9U, 0x781eU, 0x2ec3U, 0x6e35U, 0xbd1bU,
	 0x07d0U, 0x64f7U, 0x97c7U, 0xc760U, 0x98b0U, 0x626bU, 0xfbe0U, 0x9ea7U,
	 0x7b15U, 0x06a3U, 0xe52aU, 0xa7f6U, 0xf429U, 0xd23fU, 0xfab3U, 0x1d2bU,
	 0xabe4U, 0x45cbU, 0xeb3cU, 0x9096U, 0xa313U, 0xd37cU, 0xcc1fU, 0x1ff4U,
	 0xd982U, 0x0e0aU, 0xfed5U, 0xd77fU, 0xb344U, 0xea47U, 0x83d4U, 0x3bcfU,
	 0x125fU, 0xda18U, 0x6474U, 0x4c7eU, 0x81eaU, 0x3f42U, 0x31c7U, 0x1c95U,
	 0x2b84U, 0x7260U, 0x771cU, 0x0d8cU, 0x1c2fU, 0x6156U, 0x679eU, 0x7b99U,
	 0xb372U, 0xa2a9U, 0xfbb7U, 0x9dafU, 0xd4cbU, 0xd4e7U, 0xe2baU, 0xcd40U,
	 0xfe5cU, 0xe977U, 0xd15cU, 0x6f85U, 0xed47U, 0x8ab6U, 0xd232U, 0xb39eU,
	 0x93d0U, 0x231cU, 0x0f6eU, 0x8f64U, 0x414fU, 0xdb44U, 0x92deU, 0xd130U,
	 0x7e5eU, 0xc5e2U, 0x18f8U, 0x179aU, 0x4737U, 0x9b47U, 0x5d7eU, 0x3c9aU,
	 0xfa7dU, 0x4cc9U, 0x31d1U, 0x688cU, 0x14b0U, 0xb54aU, 0x1c02U, 0x702fU,
	 0x4039U, 0x09dbU, 0xf8daU, 0x3641U, 0x032eU, 0xd812U, 0x01f7U, 0x0001U
}; /* prime_order (1633 bits) */

const ecPoint curve_point = {
	{0x0067U, 0xbb9aU, 0xeb77U, 0x6e07U, 0x84beU, 0x1aa5U, 0x0371U, 0x5ad4U,
	 0x631aU, 0xc115U, 0x8aa1U, 0x651bU, 0x260eU, 0x7e4fU, 0x6ef9U, 0xc824U,
	 0xe4fdU, 0x1debU, 0xbc47U, 0x9529U, 0x1a0fU, 0x3389U, 0xd40cU, 0x0101U,
	 0x0afdU, 0xf04cU, 0xec30U, 0x1bbcU, 0x9730U, 0xae6dU, 0x98fdU, 0xfbacU,
	 0xae61U, 0xf5b1U, 0xcb61U, 0x71e7U, 0xe38eU, 0xa7f7U, 0x7198U, 0x5441U,
	 0x6297U, 0xfa33U, 0xd029U, 0xc2f6U, 0x02d5U, 0xe373U, 0x6d95U, 0xc77dU,
	 0x71d1U, 0x3640U, 0xb022U, 0xf535U, 0x5761U, 0x814fU, 0xe529U, 0x450dU,
	 0x8744U, 0x4f4aU, 0x3d2cU, 0x328aU, 0x21bcU, 0x9a90U, 0x1fb2U, 0x530cU,
	 0x5259U, 0x930eU, 0x9af3U, 0x0b8aU, 0x21e0U, 0x5809U, 0xc34fU, 0x8e12U,
	 0x7677U, 0x5a72U, 0x69f5U, 0x6765U, 0xc1f8U, 0x2811U, 0x4fb5U, 0xa954U,
	 0xbbf4U, 0x8e3eU, 0xc516U, 0xd42cU, 0x58f9U, 0x88f7U, 0xf877U, 0x83b8U,
	 0x9e12U, 0x0b73U, 0x96bdU, 0x2221U, 0x9dc6U, 0x8520U, 0x5cbaU, 0x0f4dU,
	 0x3da3U, 0x0c5aU, 0xcfc2U, 0xb5b3U, 0xb141U, 0xde99U, 0x9638U, 0x7fafU},
	{0x0067U, 0xc5b3U, 0xde33U, 0x9b26U, 0x5034U, 0x20a7U, 0x09b5U, 0xe076U,
	 0xf81aU, 0xd6ecU, 0xdd21U, 0x5219U, 0x751bU, 0x335fU, 0x2c1fU, 0xdf68U,
	 0x03e8U, 0x7d34U, 0xc8f4U, 0xa716U, 0x81beU, 0x3e75U, 0x697dU, 0xdee1U,
	 0x9bcbU, 0xe20bU, 0x70cdU, 0x7c56U, 0x0fb3U, 0x3136U, 0xb760U, 0x9470U,
	 0x5e84U, 0x06e8U, 0x94e5U, 0xdf91U, 0x6484U, 0x3451U, 0x0e62U, 0x05f2U,
	 0x6d8dU, 0x88b1U, 0x7dc7U, 0x7583U, 0xb34fU, 0x1937U, 0x4e24U, 0xc2c2U,
	 0x9bf2U, 0xe180U, 0xaec7U, 0x479eU, 0x38c4U, 0xa2b8U, 0x1d1fU, 0xd129U,
	 0x2fb3U, 0x1293U, 0x3f34U, 0x2458U, 0xf5abU, 0x001dU, 0x86b4U, 0x63e2U,
	 0xc9e3U, 0x89aaU, 0x3505U, 0xb31eU, 0xe185U, 0x9b87U, 0x8fe7U, 0xbf38U,
	 0x127eU, 0xab66U, 0x6e9cU, 0x493eU, 0xd24fU, 0xd90fU, 0xeaddU, 0x7851U,
	 0x733dU, 0x818dU, 0x924fU, 0x2305U, 0x98bbU, 0x4908U, 0x5d70U, 0x64eaU,
	 0x65e1U, 0x2528U, 0xce16U, 0x3ae0U, 0xc34eU, 0x3ae1U, 0x0991U, 0x326fU,
	 0x78dcU, 0xbed7U, 0x6729U, 0x5452U, 0x9de9U, 0x61a3U, 0x20efU, 0x949fU}
}; /* curve_point */

#elif GF_M == 1651

const order_t prime_order = {
	 0x0067U, 0x545fU, 0xb508U, 0x0a4fU, 0x626bU, 0xb554U, 0xe4fdU, 0x7b79U,
	 0x73f1U, 0x997eU, 0xdb43U, 0x3d44U, 0xab5eU, 0xeadeU, 0xae26U, 0x014fU,
	 0x43d9U, 0xc0f0U, 0x98ecU, 0x16f6U, 0x82d7U, 0xacd1U, 0x951cU, 0x2b06U,
	 0xec36U, 0x0424U, 0xc529U, 0x756fU, 0x2c2cU, 0x5574U, 0x0addU, 0x201dU,
	 0x4ff7U, 0x2beaU, 0x4bb6U, 0xf05aU, 0x5ddeU, 0xa0f4U, 0xe1baU, 0x8d3cU,
	 0x8037U, 0x5d4eU, 0xcbf2U, 0x92beU, 0x08c4U, 0xbca9U, 0xab89U, 0xed2aU,
	 0x5c9eU, 0x1306U, 0xed1eU, 0xba35U, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU,
	 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU,
	 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU,
	 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU,
	 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU,
	 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU,
	 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0xc03fU, 0x003fU
}; /* prime_order (1638 bits) */

const ecPoint curve_point = {
	{0x007fU, 0x02f3U, 0x0d4eU, 0x02efU, 0x1269U, 0x0645U, 0x0c01U, 0x1600U,
	 0x0db8U, 0x0dd3U, 0x1378U, 0x1e98U, 0x190dU, 0x1a28U, 0x0121U, 0x18ebU,
	 0x0ba0U, 0x0a68U, 0x07e9U, 0x106dU, 0x179bU, 0x0ca2U, 0x01f5U, 0x030cU,
	 0x110cU, 0x014bU, 0x02a5U, 0x1005U, 0x0c33U, 0x0b47U, 0x129dU, 0x1e43U,
	 0x1a19U, 0x0db4U, 0x1a1cU, 0x0232U, 0x1c3cU, 0x19acU, 0x18d5U, 0x107dU,
	 0x10c4U, 0x05b0U, 0x0c91U, 0x05baU, 0x0695U, 0x05c9U, 0x0b81U, 0x09b3U,
	 0x038cU, 0x0564U, 0x0972U, 0x033cU, 0x1bf6U, 0x1c5cU, 0x117aU, 0x091bU,
	 0x018fU, 0x16c5U, 0x0515U, 0x0e7eU, 0x1f70U, 0x1fddU, 0x0458U, 0x1955U,
	 0x1f56U, 0x0a47U, 0x1433U, 0x12b9U, 0x14ffU, 0x114bU, 0x055aU, 0x0827U,
	 0x14bdU, 0x1cf5U, 0x050eU, 0x1837U, 0x0127U, 0x1bc3U, 0x17cbU, 0x0158U,
	 0x1136U, 0x04a8U, 0x12e0U, 0x0937U, 0x0b69U, 0x04fdU, 0x0888U, 0x0766U,
	 0x1035U, 0x053fU, 0x0813U, 0x1efcU, 0x1519U, 0x06eeU, 0x003dU, 0x15d8U,
	 0x1c07U, 0x1395U, 0x012aU, 0x09a1U, 0x1642U, 0x0b6dU, 0x10b5U, 0x0d1bU,
	 0x14c9U, 0x12c7U, 0x17ddU, 0x1149U, 0x09b0U, 0x15c2U, 0x1373U, 0x0bc2U,
	 0x01b0U, 0x1bf1U, 0x135eU, 0x0470U, 0x089fU, 0x03a9U, 0x0778U, 0x0e39U,
	 0x0a66U, 0x128eU, 0x152eU, 0x0f75U, 0x056aU, 0x1204U, 0x0affU, 0x0bedU},
	{0x007fU, 0x132eU, 0x0664U, 0x1c43U, 0x0692U, 0x1533U, 0x10aaU, 0x1b13U,
	 0x166cU, 0x142aU, 0x056eU, 0x09dbU, 0x02abU, 0x0025U, 0x05f4U, 0x03fbU,
	 0x11f1U, 0x1f57U, 0x09b8U, 0x16c6U, 0x1267U, 0x1a09U, 0x1d33U, 0x12faU,
	 0x03c5U, 0x0d72U, 0x199bU, 0x0e98U, 0x0860U, 0x00e6U, 0x143eU, 0x01f7U,
	 0x04e7U, 0x06e5U, 0x0f62U, 0x0172U, 0x124cU, 0x1e14U, 0x129eU, 0x0a4aU,
	 0x18d4U, 0x0a28U, 0x1590U, 0x063dU, 0x10beU, 0x0dc5U, 0x0e00U, 0x16b1U,
	 0x097eU, 0x1c32U, 0x1acfU, 0x1b5aU, 0x1c6cU, 0x003bU, 0x1f20U, 0x1960U,
	 0x0dd0U, 0x0e86U, 0x0d76U, 0x1398U, 0x0be8U, 0x070bU, 0x136fU, 0x0230U,
	 0x172cU, 0x1ec2U, 0x1c46U, 0x021dU, 0x02cfU, 0x0679U, 0x1fbeU, 0x04fbU,
	 0x0a97U, 0x1432U, 0x18a4U, 0x0c78U, 0x038bU, 0x0210U, 0x0d16U, 0x0fe6U,
	 0x0a9fU, 0x1740U, 0x1efaU, 0x1dfaU, 0x0deeU, 0x16d7U, 0x143eU, 0x050aU,
	 0x195aU, 0x11f8U, 0x1c4eU, 0x00a6U, 0x0808U, 0x1eb4U, 0x1834U, 0x1d82U,
	 0x0663U, 0x0e49U, 0x11f2U, 0x1e05U, 0x16d5U, 0x17a5U, 0x1867U, 0x0c3aU,
	 0x106cU, 0x05d4U, 0x1a5aU, 0x0497U, 0x1678U, 0x1eaaU, 0x1431U, 0x16dcU,
	 0x1abbU, 0x1abaU, 0x0ca3U, 0x05afU, 0x13fcU, 0x128cU, 0x1234U, 0x08eaU,
	 0x0960U, 0x1378U, 0x1f47U, 0x1e11U, 0x09c3U, 0x1b01U, 0x041fU, 0x09b5U}
}; /* curve_point */

#elif GF_M == 1695

const order_t prime_order = {
	 0x0069U, 0x82f1U, 0x6decU, 0x6d65U, 0x5193U, 0x6cc9U, 0x3872U, 0x2298U,
	 0x3335U, 0xc770U, 0x106fU, 0x4befU, 0x2ffaU, 0xa7b8U, 0xb995U, 0x08d6U,
	 0xcf98U, 0x2786U, 0x21a0U, 0xd15eU, 0x0686U, 0x736eU, 0xfc01U, 0x9727U,
	 0x4620U, 0x85ebU, 0x871aU, 0x5ef0U, 0xeecfU, 0xe176U, 0x956cU, 0x1a70U,
	 0xf4eeU, 0xdde1U, 0x8819U, 0xf170U, 0xc9a3U, 0xa615U, 0x6448U, 0xb2c4U,
	 0xd2e3U, 0x44e2U, 0x8ff5U, 0xa36dU, 0xff43U, 0x7c35U, 0x484cU, 0x54feU,
	 0x9165U, 0x0427U, 0xf4efU, 0xd273U, 0xe67fU, 0xba8fU, 0x482aU, 0x22e7U,
	 0x11c3U, 0xb7f5U, 0x5653U, 0x1f2dU, 0xdcd9U, 0xfbc6U, 0xe629U, 0x800fU,
	 0x3c9dU, 0x1878U, 0x4a67U, 0xa90dU, 0x82abU, 0x2e74U, 0x1c32U, 0x7f51U,
	 0x653bU, 0xf2d5U, 0xcd91U, 0xbc6dU, 0x629fU, 0x00feU, 0xc9d8U, 0x8783U,
	 0xa671U, 0x90d4U, 0x2abaU, 0xe748U, 0xc322U, 0xf511U, 0x53b7U, 0x2d56U,
	 0xd91fU, 0xc6dcU, 0x29fbU, 0x0fe6U, 0x9d80U, 0x783cU, 0x6718U, 0x0d4aU,
	 0xaba9U, 0x7482U, 0x322eU, 0x511cU, 0x3b7fU, 0xd565U, 0x91f2U, 0x6dcdU,
	 0x9fbcU, 0xfe62U
}; /* prime_order (1680 bits) */

const ecPoint curve_point = {
	{0x0071U, 0x7a02U, 0x0038U, 0x2411U, 0x2d08U, 0x11b6U, 0x5f03U, 0x3211U,
	 0x4b51U, 0x2a74U, 0x468dU, 0x21ebU, 0x2cc6U, 0x163bU, 0x6a1eU, 0x4904U,
	 0x5208U, 0x6a27U, 0x2b4cU, 0x0384U, 0x0200U, 0x4aa6U, 0x6587U, 0x210eU,
	 0x244bU, 0x4babU, 0x067fU, 0x0252U, 0x4dd2U, 0x7c02U, 0x1aa9U, 0x73b8U,
	 0x2497U, 0x28bfU, 0x0ddfU, 0x32bdU, 0x5b7dU, 0x3f93U, 0x66fdU, 0x42e9U,
	 0x27d1U, 0x2c59U, 0x6b0cU, 0x46e9U, 0x2421U, 0x0173U, 0x5032U, 0x2488U,
	 0x33a1U, 0x063eU, 0x4238U, 0x24edU, 0x4ff6U, 0x0253U, 0x60ffU, 0x0994U,
	 0x1127U, 0x5fc5U, 0x3e0eU, 0x70faU, 0x42c6U, 0x4c46U, 0x4fe2U, 0x1b82U,
	 0x2b42U, 0x726eU, 0x2e25U, 0x4a68U, 0x0adfU, 0x7febU, 0x0dceU, 0x79abU,
	 0x1e70U, 0x66f8U, 0x5dbcU, 0x620aU, 0x7a21U, 0x11aaU, 0x1799U, 0x602fU,
	 0x03e2U, 0x44c5U, 0x00abU, 0x2e2eU, 0x28a6U, 0x2b4eU, 0x54b5U, 0x3f6cU,
	 0x4430U, 0x4318U, 0x70f6U, 0x24f8U, 0x301aU, 0x560cU, 0x4993U, 0x27f1U,
	 0x176fU, 0x59a3U, 0x6b73U, 0x5a7cU, 0x4717U, 0x5728U, 0x753eU, 0x0a07U,
	 0x295eU, 0x7b47U, 0x42d2U, 0x2298U, 0x348bU, 0x6136U, 0x01beU, 0x413eU,
	 0x57a7U, 0x235aU},
	{0x0071U, 0x18c7U, 0x457bU, 0x146fU, 0x6716U, 0x7d1dU, 0x7d8fU, 0x410cU,
	 0x517cU, 0x55b2U, 0x7ae0U, 0x32d0U, 0x183bU, 0x4490U, 0x604eU, 0x6057U,
	 0x7a0cU, 0x7218U, 0x497bU, 0x7c5cU, 0x2d97U, 0x0b69U, 0x3381U, 0x4932U,
	 0x7a85U, 0x2866U, 0x1654U, 0x0869U, 0x0e1dU, 0x149dU, 0x3b6fU, 0x004fU,
	 0x01f4U, 0x17b5U, 0x7606U, 0x2cf4U, 0x1d5aU, 0x09a1U, 0x62acU, 0x5ae0U,
	 0x65f8U, 0x56c0U, 0x2b5aU, 0x750bU, 0x64e9U, 0x03e2U, 0x4e73U, 0x3e46U,
	 0x4c19U, 0x3c7cU, 0x17b7U, 0x496aU, 0x5aeeU, 0x15dbU, 0x4753U, 0x3122U,
	 0x3c8aU, 0x6ab0U, 0x4144U, 0x46bcU, 0x1793U, 0x7fd7U, 0x7725U, 0x1f2eU,
	 0x3c37U, 0x2282U, 0x5abbU, 0x0f25U, 0x0665U, 0x3c33U, 0x0ab6U, 0x71b0U,
	 0x5c37U, 0x565aU, 0x30c4U, 0x7541U, 0x1560U, 0x66baU, 0x7878U, 0x37c7U,
	 0x30a0U, 0x51bbU, 0x5d37U, 0x04cbU, 0x2ba5U, 0x048fU, 0x6aecU, 0x54e5U,
	 0x379fU, 0x6660U, 0x1d1eU, 0x79f2U, 0x60aaU, 0x1f1dU, 0x724aU, 0x6deeU,
	 0x6e0aU, 0x3870U, 0x6494U, 0x62ffU, 0x46f0U, 0x63d2U, 0x52bcU, 0x431aU,
	 0x789dU, 0x605eU, 0x43c1U, 0x6174U, 0x0252U, 0x7fc9U, 0x277dU, 0x6238U,
	 0x346aU, 0x11acU}
}; /* curve_point */

#elif GF_M == 1737

const order_t prime_order = {
	 0x006cU, 0xe7c1U, 0x5723U, 0xc406U, 0x6ea2U, 0xe69bU, 0x79f7U, 0xdceaU,
	 0x4e8dU, 0xa54eU, 0x3386U, 0x257eU, 0x2f41U, 0xbd31U, 0x6a00U, 0xdfb2U,
	 0x6960U, 0x4308U, 0x424fU, 0x6e4cU, 0x4cffU, 0x8b68U, 0xb754U, 0x9b33U,
	 0x7439U, 0x1caaU, 0x4e37U, 0x2bf7U, 0x0789U, 0x5ba5U, 0xcc12U, 0xf882U,
	 0x0352U, 0x0af5U, 0xf0c8U, 0x8904U, 0x0941U, 0x0653U, 0x356eU, 0x2dc0U,
	 0x0949U, 0x2a15U, 0xa7b9U, 0xf798U, 0x5d21U, 0xe989U, 0x0e5fU, 0xf413U,
	 0xc38aU, 0x4344U, 0x6e22U, 0xb297U, 0x5d5bU, 0x2fe7U, 0xe5f7U, 0x0fc0U,
	 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU,
	 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU,
	 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U,
	 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU,
	 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU,
	 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU, 0x0fc0U,
	 0xc0fcU, 0xfc0fU, 0x0fc0U, 0xc0fcU, 0xfc0fU
}; /* prime_order (1728 bits) */

const ecPoint curve_point = {
	{0x00c1U, 0x0082U, 0x0019U, 0x01e4U, 0x009eU, 0x0112U, 0x0017U, 0x005dU,
	 0x00fcU, 0x01f0U, 0x0029U, 0x01fcU, 0x019cU, 0x01aeU, 0x010cU, 0x01daU,
	 0x00edU, 0x014bU, 0x01b3U, 0x00e1U, 0x0122U, 0x00e5U, 0x016cU, 0x010fU,
	 0x005bU, 0x012fU, 0x0130U, 0x01a8U, 0x0031U, 0x00c8U, 0x011dU, 0x0059U,
	 0x0130U, 0x00c6U, 0x01cfU, 0x018dU, 0x01b6U, 0x0043U, 0x00bfU, 0x01adU,
	 0x0075U, 0x01cfU, 0x0168U, 0x01f4U, 0x01b2U, 0x01b8U, 0x014eU, 0x0179U,
	 0x018dU, 0x0014U, 0x0056U, 0x0023U, 0x012aU, 0x004eU, 0x0162U, 0x0184U,
	 0x0149U, 0x0122U, 0x0072U, 0x0181U, 0x0074U, 0x011eU, 0x0133U, 0x00c2U,
	 0x01ccU, 0x0108U, 0x00adU, 0x00d3U, 0x017dU, 0x0151U, 0x0157U, 0x001aU,
	 0x017dU, 0x00beU, 0x00e2U, 0x01d2U, 0x0088U, 0x014dU, 0x00beU, 0x0035U,
	 0x015aU, 0x0090U, 0x0094U, 0x00cbU, 0x0125U, 0x0126U, 0x00aeU, 0x004aU,
	 0x00abU, 0x00fdU, 0x0125U, 0x009fU, 0x00a2U, 0x00dcU, 0x0050U, 0x0188U,
	 0x0118U, 0x0189U, 0x0198U, 0x0048U, 0x01b5U, 0x0135U, 0x012cU, 0x01bfU,
	 0x0039U, 0x009bU, 0x00c6U, 0x01b9U, 0x018fU, 0x0060U, 0x00c7U, 0x0021U,
	 0x01e3U, 0x002fU, 0x01cbU, 0x00faU, 0x0037U, 0x01e8U, 0x00acU, 0x00f2U,
	 0x005aU, 0x00abU, 0x0195U, 0x00f6U, 0x0133U, 0x002aU, 0x007dU, 0x005aU,
	 0x00a4U, 0x00e4U, 0x0140U, 0x00acU, 0x007bU, 0x0078U, 0x0103U, 0x01afU,
	 0x007aU, 0x00d8U, 0x011eU, 0x0121U, 0x01e9U, 0x0046U, 0x016dU, 0x000cU,
	 0x0101U, 0x006aU, 0x0001U, 0x01a5U, 0x0063U, 0x006cU, 0x00dfU, 0x01d7U,
	 0x00adU, 0x019bU, 0x01b3U, 0x01f8U, 0x017bU, 0x0179U, 0x001fU, 0x01aeU,
	 0x001dU, 0x007cU, 0x017eU, 0x0035U, 0x0150U, 0x0093U, 0x00ceU, 0x0063U,
	 0x00bfU, 0x0038U, 0x0152U, 0x00c4U, 0x006dU, 0x01dbU, 0x0021U, 0x00cbU,
	 0x01b8U, 0x005dU, 0x0173U, 0x017eU, 0x01e5U, 0x011cU, 0x01e3U, 0x008bU,
	 0x01c4U, 0x0103U, 0x007eU, 0x0071U, 0x01baU, 0x01d7U, 0x00e2U, 0x0101U,
	 0x01e9U, 0x00e7U},
	{0x00c1U, 0x00a1U, 0x0096U, 0x00e9U, 0x0045U, 0x0162U, 0x0125U, 0x008dU,
	 0x016aU, 0x0012U, 0x00a9U, 0x0019U, 0x0050U, 0x016dU, 0x00faU, 0x01b1U,
	 0x00f0U, 0x010eU, 0x0152U, 0x012eU, 0x000aU, 0x0156U, 0x0045U, 0x00caU,
	 0x0037U, 0x01dfU, 0x00ecU, 0x0100U, 0x01a1U, 0x0194U, 0x001fU, 0x002cU,
	 0x00f2U, 0x019fU, 0x00e6U, 0x01a9U, 0x00baU, 0x0062U, 0x011eU, 0x017fU,
	 0x0055U, 0x01fcU, 0x0084U, 0x00bdU, 0x0183U, 0x0178U, 0x00e0U, 0x008dU,
	 0x008fU, 0x00ceU, 0x01e9U, 0x00e5U, 0x00c4U, 0x004fU, 0x006eU, 0x0026U,
	 0x0058U, 0x0173U, 0x0164U, 0x006dU, 0x0092U, 0x0052U, 0x00e5U, 0x008aU,
	 0x00fdU, 0x00a8U, 0x00d0U, 0x0009U, 0x0089U, 0x013bU, 0x00ddU, 0x00cdU,
	 0x0133U, 0x01aaU, 0x01feU, 0x002cU, 0x0127U, 0x011bU, 0x01eeU, 0x00b0U,
	 0x01f9U, 0x00cfU, 0x0026U, 0x0071U, 0x00deU, 0x01daU, 0x01fdU, 0x000cU,
	 0x0026U, 0x0178U, 0x0154U, 0x009cU, 0x0053U, 0x01c0U, 0x004cU, 0x01d9U,
	 0x0036U, 0x0072U, 0x00b3U, 0x01d7U, 0x0137U, 0x00efU, 0x0114U, 0x0018U,
	 0x01ccU, 0x00a1U, 0x00e3U, 0x00a7U, 0x01c4U, 0x000fU, 0x002aU, 0x0071U,
	 0x0160U, 0x00b5U, 0x0105U, 0x016cU, 0x0194U, 0x00e4U, 0x01cbU, 0x00a5U,
	 0x009dU, 0x01a1U, 0x008dU, 0x002fU, 0x00beU, 0x0187U, 0x0013U, 0x00faU,
	 0x00c3U, 0x0164U, 0x0097U, 0x017aU, 0x00c9U, 0x0111U, 0x01f6U, 0x0007U,
	 0x00cbU, 0x00e5U, 0x0157U, 0x01a0U, 0x0010U, 0x00adU, 0x0048U, 0x002aU,
	 0x0122U, 0x0074U, 0x00f6U, 0x01fcU, 0x003eU, 0x00d6U, 0x006aU, 0x0150U,
	 0x0076U, 0x00c1U, 0x0130U, 0x01dbU, 0x01e0U, 0x005eU, 0x013eU, 0x01a8U,
	 0x0130U, 0x0001U, 0x01a8U, 0x0110U, 0x01bbU, 0x00bfU, 0x0131U, 0x0048U,
	 0x01c3U, 0x0182U, 0x0049U, 0x01a6U, 0x0092U, 0x0070U, 0x0145U, 0x0063U,
	 0x0166U, 0x017eU, 0x01cbU, 0x0025U, 0x014dU, 0x01d0U, 0x0117U, 0x01f6U,
	 0x0167U, 0x0081U, 0x01c3U, 0x0124U, 0x0095U, 0x01ecU, 0x00f1U, 0x008dU,
	 0x01b0U, 0x0037U}
}; /* curve_point */

#elif GF_M == 1778

const order_t prime_order = {
	 0x006fU, 0x5537U, 0x4d43U, 0xbd99U, 0x6f8aU, 0x6c41U, 0x5055U, 0x21a3U,
	 0xa08fU, 0xea74U, 0xb5eaU, 0xf3edU, 0x79d0U, 0xc6e3U, 0xab83U, 0xd422U,
	 0xfa26U, 0x293aU, 0x98e8U, 0xc614U, 0x0747U, 0x58abU, 0x6976U, 0x29b5U,
	 0xffd9U, 0x8117U, 0x5283U, 0xa582U, 0xaa63U, 0x9d44U, 0x23a1U, 0x9d72U,
	 0x87f7U, 0x7746U, 0x9342U, 0xa05bU, 0xed9eU, 0xf153U, 0x05c2U, 0x6107U,
	 0x1d62U, 0x03f3U, 0xe610U, 0x8a21U, 0xee03U, 0xbbe0U, 0x2a51U, 0xb93cU,
	 0x4d90U, 0xbcfeU, 0x4204U, 0xd1feU, 0x626bU, 0xf4e6U, 0xd5b9U, 0x13eaU,
	 0xb90dU, 0x0c0eU, 0xefc1U, 0x107fU, 0xf73eU, 0x74e4U, 0x6d47U, 0x8503U,
	 0xd8e8U, 0x57b3U, 0xf2edU, 0xf146U, 0x3ef3U, 0x8010U, 0xc1efU, 0x1b08U,
	 0xb88bU, 0xfc92U, 0x177aU, 0x4c27U, 0x12a8U, 0xb90dU, 0x0c0eU, 0xefc1U,
	 0x107fU, 0xf73eU, 0x74e4U, 0x6d47U, 0x8503U, 0xd8e8U, 0x57b3U, 0xf2edU,
	 0xf146U, 0x3ef3U, 0x8010U, 0xc1efU, 0x1b08U, 0xb88bU, 0xfc92U, 0x177aU,
	 0x4c27U, 0x12a8U, 0xb90dU, 0x0c0eU, 0xefc1U, 0x107fU, 0xf73eU, 0x74e4U,
	 0x6d47U, 0x8503U, 0xd8e8U, 0x57b3U, 0xf2edU, 0xf146U, 0x3ef3U, 0x0010U
}; /* prime_order (1765 bits) */

const ecPoint curve_point = {
	{0x007fU, 0x2669U, 0x3791U, 0x104bU, 0x1947U, 0x0f47U, 0x0590U, 0x0891U,
	 0x1434U, 0x00c7U, 0x3665U, 0x28e1U, 0x0d97U, 0x3de5U, 0x3d1eU, 0x3974U,
	 0x00eaU, 0x2780U, 0x0515U, 0x23d4U, 0x2f84U, 0x0cb9U, 0x0a76U, 0x0604U,
	 0x0674U, 0x3699U, 0x2dd0U, 0x1c6eU, 0x36b2U, 0x2812U, 0x0ff6U, 0x0a0cU,
	 0x1c1dU, 0x3039U, 0x3873U, 0x33afU, 0x3343U, 0x3031U, 0x0a49U, 0x0042U,
	 0x0f28U, 0x0285U, 0x1140U, 0x1d10U, 0x321eU, 0x0d88U, 0x2cf6U, 0x0bd7U,
	 0x0a07U, 0x3975U, 0x205eU, 0x2476U, 0x127bU, 0x157fU, 0x185eU, 0x368aU,
	 0x202eU, 0x301cU, 0x1e49U, 0x134eU, 0x0879U, 0x0662U, 0x3be8U, 0x1113U,
	 0x2977U, 0x1b1eU, 0x0bffU, 0x0fc9U, 0x1981U, 0x35f2U, 0x171dU, 0x21ffU,
	 0x2c1dU, 0x364eU, 0x28b0U, 0x19dcU, 0x0effU, 0x224cU, 0x0689U, 0x384dU,
	 0x225eU, 0x0f89U, 0x3b2aU, 0x1623U, 0x1e26U, 0x042eU, 0x37c6U, 0x259aU,
	 0x2d4dU, 0x230bU, 0x3afdU, 0x122eU, 0x2584U, 0x308eU, 0x2cf7U, 0x05c0U,
	 0x192cU, 0x3db5U, 0x19a9U, 0x339eU, 0x0ae7U, 0x2ec6U, 0x0cbaU, 0x07f5U,
	 0x1f57U, 0x253aU, 0x167fU, 0x0d29U, 0x04abU, 0x2150U, 0x2ea7U, 0x3d4eU,
	 0x0e45U, 0x0f69U, 0x2099U, 0x2d10U, 0x002cU, 0x3408U, 0x002eU, 0x1814U,
	 0x388bU, 0x1097U, 0x2030U, 0x057fU, 0x055aU, 0x2360U, 0x2a11U, 0x204dU},
	{0x007fU, 0x1721U, 0x3412U, 0x1d31U, 0x0241U, 0x2252U, 0x2082U, 0x3944U,
	 0x0ae6U, 0x147bU, 0x3f77U, 0x03e0U, 0x1ccdU, 0x207bU, 0x3f80U, 0x2308U,
	 0x2c12U, 0x17b0U, 0x295bU, 0x3a5eU, 0x0532U, 0x1cd8U, 0x1a22U, 0x0181U,
	 0x1adbU, 0x2f06U, 0x0ef5U, 0x2ca1U, 0x0ee5U, 0x3376U, 0x1d1aU, 0x0975U,
	 0x28f9U, 0x27efU, 0x144bU, 0x2c96U, 0x219aU, 0x1620U, 0x3193U, 0x026aU,
	 0x36abU, 0x29d3U, 0x29c9U, 0x2ba4U, 0x14ddU, 0x304eU, 0x02bbU, 0x35a6U,
	 0x3eccU, 0x37abU, 0x011aU, 0x3072U, 0x3ef6U, 0x10fbU, 0x3ab8U, 0x0413U,
	 0x35b5U, 0x2e89U, 0x1993U, 0x1880U, 0x0646U, 0x3b91U, 0x07ddU, 0x347cU,
	 0x3f27U, 0x248cU, 0x3444U, 0x08b2U, 0x3539U, 0x08bbU, 0x02ccU, 0x0090U,
	 0x0425U, 0x32dfU, 0x237cU, 0x00e8U, 0x2504U, 0x32ddU, 0x135eU, 0x1262U,
	 0x2b64U, 0x0718U, 0x1c78U, 0x1267U, 0x178aU, 0x3c1cU, 0x2914U, 0x1a27U,
	 0x31c7U, 0x24efU, 0x1679U, 0x0cfaU, 0x15d6U, 0x0893U, 0x3251U, 0x148aU,
	 0x1ce9U, 0x156bU, 0x1691U, 0x0bb7U, 0x02d8U, 0x0cadU, 0x2267U, 0x07b9U,
	 0x0ca5U, 0x3c03U, 0x397aU, 0x2dedU, 0x0c18U, 0x2465U, 0x02d9U, 0x2184U,
	 0x3c0bU, 0x206bU, 0x35a5U, 0x0fceU, 0x1561U, 0x0ec9U, 0x29baU, 0x0795U,
	 0x1fa0U, 0x0b55U, 0x378cU, 0x259fU, 0x2c59U, 0x2709U, 0x1b65U, 0x30e4U}
}; /* curve_point */

#elif GF_M == 1781

const order_t prime_order = {
	 0x006fU, 0x61c9U, 0xb50dU, 0x252bU, 0xfd84U, 0x781cU, 0x0eacU, 0x5e68U,
	 0xef10U, 0x39a0U, 0x1cb4U, 0xff0eU, 0x310eU, 0x026fU, 0x2b3dU, 0x7f38U,
	 0xc13dU, 0x8a26U, 0x130bU, 0x8bc6U, 0xca33U, 0x074dU, 0x11bfU, 0x49b8U,
	 0x1bd3U, 0x0a42U, 0x769cU, 0x4231U, 0xe82aU, 0x4e69U, 0x109fU, 0x8cb4U,
	 0xeb88U, 0x61e1U, 0x8690U, 0xb0e8U, 0xc94fU, 0x5f74U, 0x01d0U, 0x30d7U,
	 0x5aa2U, 0x1c7eU, 0xa6e3U, 0xe724U, 0x6ca5U, 0x1334U, 0xc0d8U, 0x84b5U,
	 0x8a7dU, 0x0ea6U, 0x4a87U, 0xa589U, 0x5fb4U, 0x7f86U, 0x491eU, 0x6ecbU,
	 0x037aU, 0x7353U, 0xa508U, 0x823cU, 0x00feU, 0x8eaaU, 0x784bU, 0x6e5aU,
	 0xdbb6U, 0x28c2U, 0xd93aU, 0x4419U, 0xac7dU, 0x3037U, 0x8735U, 0xca50U,
	 0xe823U, 0xa00fU, 0xb8eaU, 0xa784U, 0x66e5U, 0x2dbbU, 0xa28cU, 0x9d93U,
	 0xd441U, 0x7ac7U, 0x5303U, 0x0873U, 0x3ca5U, 0xfe82U, 0xaa00U, 0x4b8eU,
	 0x5a78U, 0xb66eU, 0xc2dbU, 0x3a28U, 0x19d9U, 0x7d44U, 0x37acU, 0x3530U,
	 0x5087U, 0x23caU, 0x0fe8U, 0xeaa0U, 0x84b8U, 0xe5a7U, 0xbb66U, 0x8c2dU,
	 0x93a2U, 0x419dU, 0xc7d4U, 0x037aU, 0x7353U, 0xa508U, 0x823cU, 0x00feU
}; /* prime_order (1768 bits) */

const ecPoint curve_point = {
	{0x0089U, 0x12dfU, 0x01b5U, 0x1311U, 0x15efU, 0x1dd6U, 0x1c1cU, 0x19e5U,
	 0x1d5aU, 0x0d80U, 0x1171U, 0x18efU, 0x0081U, 0x15c8U, 0x0fb8U, 0x1f9dU,
	 0x1d30U, 0x1ca5U, 0x16f8U, 0x0ce0U, 0x0c58U, 0x127cU, 0x1e22U, 0x1337U,
	 0x0aaaU, 0x11b3U, 0x1cc1U, 0x030bU, 0x07f8U, 0x1d55U, 0x1bb6U, 0x1621U,
	 0x0dabU, 0x11fdU, 0x095dU, 0x1df1U, 0x03ebU, 0x1010U, 0x1d9fU, 0x1b79U,
	 0x1b58U, 0x0177U, 0x0124U, 0x1456U, 0x048aU, 0x0a63U, 0x0378U, 0x070bU,
	 0x197cU, 0x1318U, 0x1a1eU, 0x12cdU, 0x12cbU, 0x135bU, 0x0218U, 0x0b09U,
	 0x0c55U, 0x1739U, 0x1663U, 0x0115U, 0x0221U, 0x1f19U, 0x0ddeU, 0x14faU,
	 0x1ea5U, 0x0781U, 0x16bbU, 0x18b3U, 0x198aU, 0x10cdU, 0x11f4U, 0x014eU,
	 0x1b82U, 0x12cbU, 0x0d49U, 0x0fd1U, 0x09f5U, 0x0f08U, 0x1030U, 0x1cf1U,
	 0x15b0U, 0x0202U, 0x04f5U, 0x0455U, 0x0b77U, 0x0083U, 0x055dU, 0x1680U,
	 0x0c4aU, 0x1385U, 0x0873U, 0x1112U, 0x112aU, 0x0c09U, 0x0a12U, 0x1d3aU,
	 0x0741U, 0x0fa2U, 0x0d74U, 0x1276U, 0x0f37U, 0x12fbU, 0x1672U, 0x04d0U,
	 0x0566U, 0x0521U, 0x1d3aU, 0x0810U, 0x0a2aU, 0x0937U, 0x0deaU, 0x0181U,
	 0x1f3fU, 0x02a3U, 0x148fU, 0x131cU, 0x07c9U, 0x1e2aU, 0x19d2U, 0x135bU,
	 0x153aU, 0x01baU, 0x17e5U, 0x0c14U, 0x1589U, 0x080bU, 0x0439U, 0x0ba6U,
	 0x136fU, 0x138cU, 0x1a86U, 0x1a06U, 0x069fU, 0x0392U, 0x0611U, 0x0e16U,
	 0x1b92U, 0x1a8cU},
	{0x0089U, 0x082dU, 0x0997U, 0x1e4bU, 0x1386U, 0x095cU, 0x1355U, 0x0218U,
	 0x0f16U, 0x1747U, 0x1266U, 0x0b82U, 0x0baaU, 0x03e8U, 0x13e1U, 0x0215U,
	 0x024eU, 0x11a4U, 0x17b4U, 0x1422U, 0x1e21U, 0x154aU, 0x1942U, 0x1a1aU,
	 0x138dU, 0x124cU, 0x09c9U, 0x0f30U, 0x1123U, 0x11acU, 0x1611U, 0x009dU,
	 0x0933U, 0x1616U, 0x0127U, 0x1fb0U, 0x1fb9U, 0x190dU, 0x0c50U, 0x0d06U,
	 0x0609U, 0x188cU, 0x1128U, 0x1e15U, 0x10a1U, 0x05b1U, 0x0a10U, 0x0b1fU,
	 0x15ffU, 0x0b37U, 0x113cU, 0x1244U, 0x0f61U, 0x18e4U, 0x057dU, 0x0cb5U,
	 0x04e0U, 0x0364U, 0x01a9U, 0x1dd9U, 0x0029U, 0x04caU, 0x1764U, 0x1f96U,
	 0x1587U, 0x0045U, 0x08acU, 0x071dU, 0x05c6U, 0x13c9U, 0x14feU, 0x1723U,
	 0x1c9aU, 0x0430U, 0x1c16U, 0x08e0U, 0x1d2fU, 0x15c0U, 0x164bU, 0x08adU,
	 0x02d2U, 0x143fU, 0x1403U, 0x1b6eU, 0x0220U, 0x0a9aU, 0x1878U, 0x00feU,
	 0x1bdaU, 0x12a1U, 0x09dfU, 0x15c4U, 0x18b1U, 0x12abU, 0x0df0U, 0x1f3cU,
	 0x10d2U, 0x0869U, 0x104fU, 0x0b03U, 0x1ff7U, 0x0461U, 0x01beU, 0x0ca3U,
	 0x0a05U, 0x1c2dU, 0x122dU, 0x08eeU, 0x03cbU, 0x130aU, 0x1014U, 0x0b79U,
	 0x08d8U, 0x176bU, 0x1a56U, 0x1033U, 0x0de7U, 0x1765U, 0x1318U, 0x00ceU,
	 0x19a4U, 0x14e2U, 0x005fU, 0x13e1U, 0x1fd6U, 0x1366U, 0x0b24U, 0x07e9U,
	 0x1562U, 0x05dbU, 0x1d78U, 0x169bU, 0x0214U, 0x0d40U, 0x0a65U, 0x0c9cU,
	 0x03e9U, 0x11e5U}
}; /* curve_point */

#elif GF_M == 1808

const order_t prime_order = {
	 0x0070U, 0x78b1U, 0x4fe1U, 0xc0c1U, 0xc81eU, 0xd1ecU, 0xf365U, 0x932cU,
	 0xe03eU, 0x3ea6U, 0xa50fU, 0x16d7U, 0x8f9bU, 0x3e9bU, 0x81ffU, 0x98f0U,
	 0x0a6cU, 0x6498U, 0x4051U, 0x028aU, 0x2d9cU, 0xacdbU, 0x178aU, 0x36bcU,
	 0x4410U, 0xfca2U, 0xa9c6U, 0x767aU, 0xe812U, 0xfc76U, 0x323aU, 0xf599U,
	 0x4743U, 0x629bU, 0x0f37U, 0xf806U, 0xced9U, 0xe825U, 0x2a28U, 0xe41bU,
	 0x2adeU, 0x9bcfU, 0x3173U, 0xdeb5U, 0x0968U, 0xa487U, 0x552eU, 0xd7e6U,
	 0x235fU, 0x665dU, 0xe929U, 0x3e55U, 0x5c72U, 0x0786U, 0x1c30U, 0xc42cU,
	 0x8203U, 0x0fffU, 0xfe00U, 0x003fU, 0xfff8U, 0xe000U, 0x03ffU, 0xff80U,
	 0x000fU, 0x3ffeU, 0xf800U, 0x00ffU, 0xffe0U, 0x8003U, 0x0fffU, 0xfe00U,
	 0x003fU, 0xfff8U, 0xe000U, 0x03ffU, 0xff80U, 0x000fU, 0x3ffeU, 0xf800U,
	 0x00ffU, 0xffe0U, 0x8003U, 0x0fffU, 0xfe00U, 0x003fU, 0xfff8U, 0xe000U,
	 0x03ffU, 0xff80U, 0x000fU, 0x3ffeU, 0xf800U, 0x00ffU, 0xffe0U, 0x8003U,
	 0x0fffU, 0xfe00U, 0x003fU, 0xfff8U, 0xe000U, 0x03ffU, 0xff80U, 0x000fU,
	 0x3ffeU, 0xf800U, 0x00ffU, 0xffe0U, 0x8003U, 0x0fffU, 0xfe00U, 0x003fU,
	 0xfff8U
}; /* prime_order (1792 bits) */

const ecPoint curve_point = {
	{0x0071U, 0x7e45U, 0x11dbU, 0xcef3U, 0x4711U, 0x797bU, 0xfd99U, 0x880fU,
	 0x1953U, 0x8e11U, 0xb542U, 0x1f7cU, 0x4219U, 0x4a7bU, 0x1eadU, 0xdb9eU,
	 0xbea1U, 0x5362U, 0x106eU, 0xcc63U, 0xea9dU, 0x2c78U, 0x0af9U, 0xbe54U,
	 0x9054U, 0x77d8U, 0xad16U, 0xf422U, 0x2c62U, 0x6e67U, 0x97e4U, 0x69f1U,
	 0x23edU, 0x2ed1U, 0xd3ddU, 0x00eaU, 0x0790U, 0x61e9U, 0xcbb1U, 0xe6c2U,
	 0xeddfU, 0xc903U, 0xc0ccU, 0xd526U, 0x060bU, 0x7494U, 0xcd97U, 0xb46bU,
	 0xd01cU, 0xb735U, 0xab00U, 0x10b7U, 0x7d3bU, 0xfa9fU, 0x01f6U, 0x063eU,
	 0xc864U, 0xae03U, 0x5378U, 0x44ffU, 0xd940U, 0xea20U, 0x6f62U, 0xee7cU,
	 0x36a9U, 0x6ae7U, 0x26faU, 0xf03eU, 0xd035U, 0x274eU, 0xbf9dU, 0x96abU,
	 0x8774U, 0x6084U, 0x3d08U, 0x9796U, 0x0fc2U, 0x3646U, 0x27e7U, 0x8bd0U,
	 0x2e9fU, 0xdc40U, 0xf817U, 0xfaf5U, 0xd949U, 0x2dd9U, 0xada6U, 0x05acU,
	 0x7cf1U, 0x5aebU, 0xb1f1U, 0x0d25U, 0x74a3U, 0xccd6U, 0xc9e6U, 0xbf48U,
	 0xd3adU, 0xdc74U, 0x56a5U, 0x8d8aU, 0x4595U, 0x1538U, 0x885bU, 0x107dU,
	 0x09bdU, 0xc744U, 0x1c49U, 0x3949U, 0x35ddU, 0x6e4bU, 0x4b0cU, 0xbe0fU,
	 0xa6adU, 0x25b7U},
	{0x0071U, 0xd154U, 0x6a8cU, 0xa120U, 0xfcdbU, 0xbabbU, 0x5877U, 0x1e93U,
	 0x51b9U, 0x9aebU, 0xd7f1U, 0x1888U, 0x2b6fU, 0x3f5dU, 0x7a6cU, 0xd6c2U,
	 0x1df0U, 0xb756U, 0xe3a7U, 0xf594U, 0xbf19U, 0x3521U, 0xa559U, 0xa9ffU,
	 0x7bdeU, 0x1da7U, 0x817cU, 0x2188U, 0xa32dU, 0x1c97U, 0x43ebU, 0x342aU,
	 0xe082U, 0xe037U, 0xa454U, 0x7f14U, 0xcd1aU, 0xdf0dU, 0x2925U, 0x68abU,
	 0xe013U, 0x4575U, 0xd5c0U, 0x97a2U, 0xab3aU, 0x2ddfU, 0x8851U, 0xb127U,
	 0xea8fU, 0x2762U, 0x61e8U, 0xe0d6U, 0xb09dU, 0x97e3U, 0xc256U, 0xb979U,
	 0x1c59U, 0x0afeU, 0x6efeU, 0x040aU, 0x1e6eU, 0xf89cU, 0xe51aU, 0xacf0U,
	 0x3aaeU, 0x55ceU, 0x02d7U, 0xd019U, 0x4ea9U, 0x99b3U, 0x2838U, 0x2b22U,
	 0x8256U, 0xaa13U, 0xd180U, 0x99e9U, 0x9b74U, 0xad37U, 0x5a8aU, 0x231cU,
	 0x431bU, 0xa60cU, 0xb52cU, 0xc56dU, 0xb50cU, 0x3f4dU, 0x9f85U, 0xbc34U,
	 0x387cU, 0x7df6U, 0xbe70U, 0x8189U, 0x81f7U, 0xef87U, 0x93e5U, 0xb67dU,
	 0xf589U, 0x9fdbU, 0x6be0U, 0x69deU, 0xbe6dU, 0xdfc8U, 0x752fU, 0x7973U,
	 0xd889U, 0x49b9U, 0xafbcU, 0xca24U, 0x2cc9U, 0x79b3U, 0x6e0aU, 0x22b0U,
	 0xa629U, 0xf5aeU}
}; /* curve_point */

#elif GF_M == 1837

const order_t prime_order = {
	 0x0073U, 0x5373U, 0x8709U, 0x6e5eU, 0x922aU, 0x52a9U, 0x04dcU, 0x970eU,
	 0x13aaU, 0xe699U, 0x9cf2U, 0x18d2U, 0x501bU, 0xff6fU, 0xab94U, 0x4092U,
	 0x62adU, 0xad91U, 0xba80U, 0x1fc2U, 0x3158U, 0x9e03U, 0x209cU, 0xe09cU,
	 0xc879U, 0x0d7dU, 0xf671U, 0x14a5U, 0xd07eU, 0x511aU, 0x42f5U, 0x412dU,
	 0x419aU, 0xc20fU, 0xfad6U, 0xf15fU, 0x423aU, 0xc8d8U, 0x1695U, 0xaaecU,
	 0x9e96U, 0x7b3eU, 0x9a2dU, 0x8a70U, 0x0e8aU, 0x6e84U, 0xf28bU, 0x65f7U,
	 0xa653U, 0xe808U, 0x8ecfU, 0x4374U, 0x7397U, 0x4880U, 0xa3e2U, 0x9d96U,
	 0x9e7aU, 0x8bdaU, 0x3d7aU, 0x6180U, 0xf0a1U, 0xa79fU, 0x03d7U, 0x1618U,
	 0xff0aU, 0x7a79U, 0x803dU, 0xa161U, 0x9ff0U, 0xd7a7U, 0x1803U, 0x0a16U,
	 0x79ffU, 0x3d7aU, 0x6180U, 0xf0a1U, 0xa79fU, 0x03d7U, 0x1618U, 0xff0aU,
	 0x7a79U, 0x803dU, 0xa161U, 0x9ff0U, 0xd7a7U, 0x1803U, 0x0a16U, 0x79ffU,
	 0x3d7aU, 0x6180U, 0xf0a1U, 0xa79fU, 0x03d7U, 0x1618U, 0xff0aU, 0x7a79U,
	 0x803dU, 0xa161U, 0x9ff0U, 0xd7a7U, 0x1803U, 0x0a16U, 0x79ffU, 0x3d7aU,
	 0x6180U, 0xf0a1U, 0xa79fU, 0x03d7U, 0x1618U, 0xff0aU, 0x7a79U, 0x803dU,
	 0xa161U, 0x9ff0U, 0xd7a7U, 0x0003U
}; /* prime_order (1826 bits) */

const ecPoint curve_point = {
	{0x00a7U, 0x0599U, 0x045fU, 0x02b0U, 0x07dbU, 0x04deU, 0x0039U, 0x0567U,
	 0x048bU, 0x04baU, 0x0375U, 0x055fU, 0x009dU, 0x03adU, 0x020aU, 0x0150U,
	 0x0032U, 0x0777U, 0x0775U, 0x00d3U, 0x02a6U, 0x012fU, 0x031dU, 0x06fbU,
	 0x06c1U, 0x042eU, 0x0379U, 0x00e1U, 0x0739U, 0x0351U, 0x016cU, 0x02d7U,
	 0x0781U, 0x03fcU, 0x0785U, 0x0567U, 0x0571U, 0x0156U, 0x02c3U, 0x073aU,
	 0x02c8U, 0x0659U, 0x0120U, 0x03f2U, 0x06b5U, 0x071bU, 0x0507U, 0x03efU,
	 0x0159U, 0x044cU, 0x0486U, 0x066fU, 0x04f2U, 0x061cU, 0x02f6U, 0x03daU,
	 0x05adU, 0x072cU, 0x07f5U, 0x0566U, 0x0697U, 0x065bU, 0x0682U, 0x07e6U,
	 0x0329U, 0x02f6U, 0x077eU, 0x034bU, 0x0238U, 0x04c3U, 0x02f9U, 0x04beU,
	 0x06b2U, 0x03faU, 0x05a0U, 0x0078U, 0x03edU, 0x0604U, 0x02e1U, 0x021fU,
	 0x0626U, 0x06a0U, 0x01f8U, 0x06d3U, 0x0145U, 0x0152U, 0x03e8U, 0x0648U,
	 0x04f0U, 0x02a0U, 0x002fU, 0x03b1U, 0x0683U, 0x0046U, 0x001cU, 0x06c5U,
	 0x0371U, 0x03b7U, 0x029cU, 0x06c5U, 0x055dU, 0x040aU, 0x0192U, 0x05dbU,
	 0x0044U, 0x018fU, 0x039bU, 0x0379U, 0x03f5U, 0x0565U, 0x059eU, 0x032eU,
	 0x02d5U, 0x06ccU, 0x07ceU, 0x04cfU, 0x01bbU, 0x0248U, 0x055dU, 0x05b4U,
	 0x04e5U, 0x04a7U, 0x0250U, 0x07d7U, 0x0048U, 0x031dU, 0x044aU, 0x04d2U,
	 0x017aU, 0x0792U, 0x0799U, 0x05aaU, 0x00cfU, 0x0740U, 0x04b3U, 0x0053U,
	 0x0649U, 0x012aU, 0x03e4U, 0x0214U, 0x044cU, 0x01aeU, 0x0691U, 0x0283U,
	 0x071dU, 0x069bU, 0x01d8U, 0x011bU, 0x0430U, 0x0766U, 0x002dU, 0x070fU,
	 0x038aU, 0x06e0U, 0x0462U, 0x06adU, 0x0370U, 0x0175U, 0x03adU, 0x02fcU,
	 0x01e8U, 0x0161U, 0x0618U, 0x00beU, 0x044cU, 0x058fU, 0x0214U, 0x032bU},
	{0x00a7U, 0x0711U, 0x012fU, 0x0024U, 0x0335U, 0x04feU, 0x04d4U, 0x04b3U,
	 0x02e3U, 0x0757U, 0x0108U, 0x07d9U, 0x0537U, 0x07b9U, 0x07dcU, 0x06fcU,
	 0x012eU, 0x006cU, 0x062fU, 0x05ddU, 0x0709U, 0x07e4U, 0x023cU, 0x0541U,
	 0x05eaU, 0x0478U, 0x0128U, 0x06b8U, 0x007cU, 0x0337U, 0x01d8U, 0x0406U,
	 0x068eU, 0x048eU, 0x06aaU, 0x00c6U, 0x0720U, 0x05feU, 0x00deU, 0x063cU,
	 0x0756U, 0x025cU, 0x038aU, 0x0095U, 0x0019U, 0x0031U, 0x0666U, 0x0401U,
	 0x0079U, 0x0284U, 0x0624U, 0x00d4U, 0x022bU, 0x0764U, 0x014dU, 0x020eU,
	 0x0191U, 0x05feU, 0x05a7U, 0x0394U, 0x0623U, 0x0167U, 0x0239U, 0x0351U,
	 0x03f6U, 0x010aU, 0x0500U, 0x0475U, 0x06ebU, 0x0687U, 0x0204U, 0x0222U,
	 0x04aeU, 0x0494U, 0x05d4U, 0x0759U, 0x04aeU, 0x041aU, 0x05c7U, 0x03fbU,
	 0x0171U, 0x01c8U, 0x01a8U, 0x070cU, 0x03b4U, 0x07c8U, 0x0013U, 0x02bbU,
	 0x0056U, 0x05b0U, 0x07f7U, 0x0163U, 0x0602U, 0x062cU, 0x0295U, 0x000bU,
	 0x05d2U, 0x00e9U, 0x05caU, 0x07d3U, 0x07a5U, 0x0039U, 0x0176U, 0x012cU,
	 0x0015U, 0x0295U, 0x027eU, 0x054cU, 0x00b8U, 0x061bU, 0x079dU, 0x038fU,
	 0x0514U, 0x0118U, 0x01f3U, 0x07c0U, 0x0200U, 0x0123U, 0x01d4U, 0x0246U,
	 0x0682U, 0x078fU, 0x0767U, 0x0691U, 0x0619U, 0x0471U, 0x00c6U, 0x043bU,
	 0x0006U, 0x0602U, 0x01d6U, 0x0604U, 0x0452U, 0x00b1U, 0x0033U, 0x07fbU,
	 0x06b6U, 0x0141U, 0x03cdU, 0x008fU, 0x06b2U, 0x04e8U, 0x02d0U, 0x024bU,
	 0x04d9U, 0x0724U, 0x0407U, 0x0783U, 0x05bbU, 0x06e4U, 0x01c5U, 0x0700U,
	 0x01e5U, 0x0462U, 0x059cU, 0x073bU, 0x067fU, 0x020cU, 0x0633U, 0x0514U,
	 0x04a0U, 0x05adU, 0x018cU, 0x03a3U, 0x0070U, 0x009fU, 0x01d5U, 0x03bdU}
}; /* curve_point */

#elif GF_M == 1905

const order_t prime_order = {
	 0x0077U, 0x0ad7U, 0x5899U, 0xf003U, 0xc40dU, 0x6fb6U, 0x4c1fU, 0x2556U,
	 0x22fdU, 0x948aU, 0xdd89U, 0x1f30U, 0x3372U, 0x4f1eU, 0x0747U, 0xc713U,
	 0x53abU, 0xa1b4U, 0x28ddU, 0x179aU, 0xf8eeU, 0xe7fbU, 0xe203U, 0xffb3U,
	 0x543dU, 0x131fU, 0x79eeU, 0xee5dU, 0xafabU, 0xb63eU, 0x0995U, 0x4fe1U,
	 0x0990U, 0xdd19U, 0x35c7U, 0x0559U, 0xa98aU, 0x56f9U, 0xebaaU, 0x5817U,
	 0x4433U, 0x47deU, 0xc2daU, 0x9915U, 0xb3d0U, 0x14b0U, 0x384dU, 0x6c53U,
	 0x2f65U, 0x17c6U, 0x7d2cU, 0xd7f1U, 0xa41cU, 0x7c76U, 0x5c2aU, 0xb9ffU,
	 0x8b3aU, 0x32baU, 0xc64fU, 0x1031U, 0xabdcU, 0x5aabU, 0x404cU, 0x6c00U,
	 0x6568U, 0x7055U, 0xaeafU, 0x316aU, 0x0101U, 0xa1b0U, 0x5595U, 0xbdc1U,
	 0xaabaU, 0x04c5U, 0xc004U, 0x5686U, 0x0556U, 0xeaf7U, 0x16aaU, 0x1013U,
	 0x1b00U, 0x595aU, 0xdc15U, 0xababU, 0x4c5aU, 0x0040U, 0x686cU, 0x5565U,
	 0xaf70U, 0x6aaeU, 0x0131U, 0xb001U, 0x95a1U, 0xc155U, 0xbabdU, 0xc5aaU,
	 0x0404U, 0x86c0U, 0x5656U, 0xf705U, 0xaaeaU, 0x1316U, 0x0010U, 0x5a1bU,
	 0x1559U, 0xabdcU, 0x5aabU, 0x404cU, 0x6c00U, 0x6568U, 0x7055U, 0xaeafU,
	 0x316aU, 0x0101U, 0xa1b0U, 0x5595U, 0xbdc1U, 0xaabaU, 0x04c5U, 0x0004U
}; /* prime_order (1891 bits) */

const ecPoint curve_point = {
	{0x007fU, 0x59a6U, 0x7f08U, 0x16c2U, 0x64aaU, 0x53deU, 0x4dfbU, 0x4ea7U,
	 0x398aU, 0x5600U, 0x3f08U, 0x14aaU, 0x16a0U, 0x77fdU, 0x61acU, 0x76fdU,
	 0x2435U, 0x3972U, 0x7e46U, 0x7c3fU, 0x0084U, 0x6a6eU, 0x2493U, 0x0522U,
	 0x2d88U, 0x26daU, 0x7f0dU, 0x601dU, 0x55fdU, 0x3f8aU, 0x3290U, 0x108fU,
	 0x694dU, 0x3b3bU, 0x639cU, 0x2adaU, 0x269eU, 0x3f42U, 0x2592U, 0x5386U,
	 0x48cdU, 0x2ee1U, 0x6b70U, 0x5cadU, 0x5bfeU, 0x7c1dU, 0x180bU, 0x0203U,
	 0x2a6bU, 0x6078U, 0x7194U, 0x57c6U, 0x4196U, 0x4b2cU, 0x0442U, 0x2869U,
	 0x5534U, 0x7745U, 0x4fe2U, 0x5dc5U, 0x43adU, 0x596dU, 0x6181U, 0x7874U,
	 0x0a07U, 0x05c3U, 0x15aaU, 0x6c88U, 0x59baU, 0x630cU, 0x5a0aU, 0x7c31U,
	 0x0c5eU, 0x07f6U, 0x139fU, 0x05acU, 0x6c6cU, 0x5ad6U, 0x14caU, 0x28aaU,
	 0x45ecU, 0x0fa8U, 0x1c6aU, 0x4815U, 0x2056U, 0x4855U, 0x50ffU, 0x1827U,
	 0x137dU, 0x7c40U, 0x544fU, 0x33bfU, 0x01f8U, 0x207eU, 0x18f8U, 0x56a4U,
	 0x6357U, 0x7228U, 0x060bU, 0x6f3aU, 0x4b7fU, 0x2e0cU, 0x5e55U, 0x44cdU,
	 0x6cd9U, 0x7cfcU, 0x5d1eU, 0x0071U, 0x4c05U, 0x2fd7U, 0x2944U, 0x0d4bU,
	 0x1ae6U, 0x6db1U, 0x4310U, 0x127fU, 0x713dU, 0x7cb9U, 0x0d59U, 0x4bafU,
	 0x2b2cU, 0x02b3U, 0x16faU, 0x4b07U, 0x7a6dU, 0x4b52U, 0x76ffU, 0x204fU},
	{0x007fU, 0x6b7cU, 0x5574U, 0x4b3fU, 0x1e71U, 0x73f1U, 0x7996U, 0x5b02U,
	 0x5290U, 0x037bU, 0x562bU, 0x609cU, 0x193aU, 0x0507U, 0x0eb2U, 0x4cb6U,
	 0x7e4dU, 0x36d5U, 0x2b18U, 0x3f21U, 0x5919U, 0x0c2cU, 0x0341U, 0x3774U,
	 0x56d9U, 0x7837U, 0x5367U, 0x1a80U, 0x39bfU, 0x026eU, 0x357dU, 0x738cU,
	 0x6f80U, 0x19d6U, 0x3287U, 0x555eU, 0x4b7eU, 0x030eU, 0x3d8fU, 0x4d75U,
	 0x6e7bU, 0x453bU, 0x4c38U, 0x1018U, 0x5da2U, 0x6e93U, 0x24eaU, 0x7662U,
	 0x0657U, 0x33ddU, 0x7ce4U, 0x6a96U, 0x1cd6U, 0x58e5U, 0x13b2U, 0x2cf2U,
	 0x4055U, 0x1fd7U, 0x4e78U, 0x04c0U, 0x1f8bU, 0x3249U, 0x1733U, 0x6b47U,
	 0x6fd0U, 0x5faeU, 0x72acU, 0x1016U, 0x0fbaU, 0x648eU, 0x2e77U, 0x4877U,
	 0x236eU, 0x263fU, 0x51acU, 0x68d6U, 0x0d8bU, 0x5597U, 0x1bc0U, 0x54b9U,
	 0x2c4dU, 0x7a81U, 0x707fU, 0x5b0aU, 0x53acU, 0x39b5U, 0x5595U, 0x2de9U,
	 0x1e43U, 0x378aU, 0x074bU, 0x1c18U, 0x6681U, 0x317bU, 0x2262U, 0x3b2aU,
	 0x563cU, 0x09d8U, 0x141cU, 0x2000U, 0x5759U, 0x63beU, 0x5298U, 0x7da9U,
	 0x6d7bU, 0x47d6U, 0x51cdU, 0x6856U, 0x671aU, 0x0a1fU, 0x6617U, 0x1b03U,
	 0x00d2U, 0x1516U, 0x2f1dU, 0x7105U, 0x7251U, 0x2bc6U, 0x2815U, 0x6b29U,
	 0x6513U, 0x1d6bU, 0x6375U, 0x65e7U, 0x008bU, 0x1f7aU, 0x184aU, 0x550dU}
}; /* curve_point */

#elif GF_M == 1910

const order_t prime_order = {
	 0x0077U, 0x083bU, 0x9cb5U, 0xa099U, 0xfbf7U, 0xbaa6U, 0xa791U, 0x2d64U,
	 0x2387U, 0x6073U, 0xbacbU, 0x8302U, 0xbc23U, 0xe44aU, 0xc49bU, 0x12d5U,
	 0xd796U, 0x768bU, 0x79ddU, 0xfc12U, 0xca33U, 0xe8b2U, 0xa4afU, 0x79eaU,
	 0x70ecU, 0xcb33U, 0x9bb7U, 0x908dU, 0x5764U, 0x36c9U, 0xa334U, 0x1568U,
	 0x9b39U, 0x8450U, 0x9458U, 0x9577U, 0xd9b6U, 0x43d2U, 0xb417U, 0x559fU,
	 0x0504U, 0x8604U, 0x12b5U, 0x3b14U, 0x6599U, 0x0cd6U, 0xad90U, 0x3dc5U,
	 0xf305U, 0x3ec2U, 0x92a6U, 0x0506U, 0xa43bU, 0x6a3dU, 0xa19aU, 0xb12fU,
	 0x6135U, 0x8a6dU, 0xc455U, 0xf08bU, 0x317bU, 0x13fcU, 0x16d7U, 0xf588U,
	 0xcf76U, 0x363eU, 0x8723U, 0x2cbaU, 0xa0d5U, 0x00f3U, 0x4a3bU, 0x9dfaU,
	 0x2242U, 0x704cU, 0x3732U, 0xd15eU, 0xcab4U, 0xc317U, 0x713fU, 0x816dU,
	 0x6f58U, 0xecf7U, 0x3363U, 0xa872U, 0x52cbU, 0x3a0dU, 0xb00fU, 0xa4a3U,
	 0x29dfU, 0xc224U, 0x2704U, 0xe373U, 0x4d15U, 0x7cabU, 0xfc31U, 0xd713U,
	 0x8816U, 0x76f5U, 0x3ecfU, 0x2336U, 0xba87U, 0xd52cU, 0xf3a0U, 0x3b00U,
	 0xfa4aU, 0x429dU, 0x4c22U, 0x3270U, 0x5e37U, 0xb4d1U, 0x17caU, 0x3fc3U,
	 0x6d71U, 0x5881U, 0xf76fU, 0x63ecU, 0x7233U, 0xcba8U, 0x0d52U, 0x0f3aU
}; /* prime_order (1900 bits) */

const ecPoint curve_point = {
	{0x00bfU, 0x0230U, 0x0111U, 0x0077U, 0x01dbU, 0x0356U, 0x011eU, 0x02d9U,
	 0x02f9U, 0x0252U, 0x009bU, 0x0041U, 0x02a2U, 0x03b5U, 0x03f0U, 0x02deU,
	 0x01f4U, 0x017eU, 0x036fU, 0x01cbU, 0x0159U, 0x0060U, 0x0110U, 0x038dU,
	 0x0151U, 0x0049U, 0x0160U, 0x0161U, 0x03eeU, 0x020bU, 0x00d2U, 0x01fdU,
	 0x0292U, 0x03d9U, 0x01cdU, 0x035bU, 0x00fbU, 0x02a1U, 0x0376U, 0x0181U,
	 0x029bU, 0x017cU, 0x0214U, 0x0167U, 0x0160U, 0x023cU, 0x0243U, 0x0158U,
	 0x01a2U, 0x027bU, 0x0099U, 0x01b3U, 0x017eU, 0x01e1U, 0x019bU, 0x0046U,
	 0x00bbU, 0x038cU, 0x01d4U, 0x03e1U, 0x038eU, 0x033cU, 0x0067U, 0x0214U,
	 0x02f9U, 0x03e4U, 0x0029U, 0x02f2U, 0x0114U, 0x03edU, 0x0135U, 0x00f0U,
	 0x0034U, 0x00bfU, 0x0160U, 0x009eU, 0x03cfU, 0x02bbU, 0x01f5U, 0x018dU,
	 0x020fU, 0x0031U, 0x029cU, 0x035eU, 0x00d4U, 0x0367U, 0x0258U, 0x0223U,
	 0x0389U, 0x0321U, 0x03cfU, 0x0171U, 0x0128U, 0x002fU, 0x0047U, 0x0343U,
	 0x0282U, 0x01a7U, 0x02fdU, 0x02e2U, 0x0342U, 0x03b3U, 0x015aU, 0x01bbU,
	 0x011bU, 0x01daU, 0x035cU, 0x0021U, 0x001bU, 0x0106U, 0x0195U, 0x039cU,
	 0x004cU, 0x033dU, 0x03c0U, 0x039dU, 0x0035U, 0x03bcU, 0x0248U, 0x0060U,
	 0x02a9U, 0x0080U, 0x02fcU, 0x0272U, 0x0050U, 0x0355U, 0x0239U, 0x02edU,
	 0x038bU, 0x02bfU, 0x01a8U, 0x0250U, 0x0178U, 0x0232U, 0x020fU, 0x03fcU,
	 0x03edU, 0x02a8U, 0x0097U, 0x02fdU, 0x00c0U, 0x029fU, 0x0198U, 0x01b1U,
	 0x03eeU, 0x03deU, 0x029dU, 0x0147U, 0x009cU, 0x014eU, 0x00f8U, 0x004eU,
	 0x01feU, 0x013eU, 0x019eU, 0x03fcU, 0x036aU, 0x0172U, 0x011dU, 0x011fU,
	 0x0304U, 0x019dU, 0x0379U, 0x02b1U, 0x03b7U, 0x0154U, 0x00bdU, 0x000aU,
	 0x0055U, 0x026dU, 0x030dU, 0x0011U, 0x0125U, 0x01d5U, 0x0300U, 0x010fU,
	 0x02f2U, 0x00f3U, 0x03baU, 0x021bU, 0x00d6U, 0x0009U, 0x0162U, 0x0290U,
	 0x01faU, 0x029aU, 0x0077U, 0x01ecU, 0x037bU, 0x004dU, 0x028fU, 0x0191U},
	{0x00bfU, 0x03f5U, 0x01ccU, 0x00e0U, 0x03e2U, 0x0036U, 0x01b5U, 0x0232U,
	 0x00b7U, 0x02dcU, 0x0058U, 0x02d6U, 0x02acU, 0x00a6U, 0x001eU, 0x014bU,
	 0x0393U, 0x00a8U, 0x0061U, 0x02deU, 0x00d8U, 0x0154U, 0x000cU, 0x01feU,
	 0x0144U, 0x0189U, 0x03feU, 0x0284U, 0x006bU, 0x0265U, 0x025fU, 0x01a2U,
	 0x03e2U, 0x03e9U, 0x005eU, 0x002dU, 0x0012U, 0x0052U, 0x02e2U, 0x006aU,
	 0x0128U, 0x0361U, 0x0043U, 0x0310U, 0x02ccU, 0x0266U, 0x0128U, 0x00ceU,
	 0x03c2U, 0x03c1U, 0x00deU, 0x0146U, 0x03e9U, 0x00baU, 0x036fU, 0x03e9U,
	 0x00a5U, 0x010bU, 0x03e2U, 0x0261U, 0x0386U, 0x0267U, 0x01ceU, 0x03d1U,
	 0x00f1U, 0x02c5U, 0x0297U, 0x018eU, 0x035eU, 0x032bU, 0x010fU, 0x0115U,
	 0x026fU, 0x017eU, 0x0166U, 0x0114U, 0x00d6U, 0x005cU, 0x01d2U, 0x017aU,
	 0x010cU, 0x0058U, 0x01c9U, 0x02f3U, 0x00b3U, 0x017eU, 0x0070U, 0x01a2U,
	 0x0084U, 0x01a0U, 0x0279U, 0x0006U, 0x0199U, 0x03fcU, 0x0127U, 0x0136U,
	 0x0138U, 0x006cU, 0x00d5U, 0x00f5U, 0x039fU, 0x0036U, 0x0336U, 0x03c2U,
	 0x013fU, 0x0183U, 0x0239U, 0x0327U, 0x0291U, 0x02bdU, 0x035bU, 0x00dcU,
	 0x0168U, 0x00bfU, 0x0235U, 0x0329U, 0x0119U, 0x0037U, 0x0259U, 0x024cU,
	 0x025fU, 0x03b7U, 0x02dbU, 0x0103U, 0x0197U, 0x02f7U, 0x02a3U, 0x01bbU,
	 0x0379U, 0x00c1U, 0x02ddU, 0x01ffU, 0x0078U, 0x03f0U, 0x0237U, 0x00c9U,
	 0x01f0U, 0x018bU, 0x006fU, 0x022bU, 0x02e5U, 0x0269U, 0x0002U, 0x03e6U,
	 0x01b1U, 0x011eU, 0x0071U, 0x034eU, 0x0016U, 0x01faU, 0x03b8U, 0x02fdU,
	 0x0206U, 0x025cU, 0x03ceU, 0x0028U, 0x005fU, 0x00a4U, 0x03a1U, 0x0139U,
	 0x021bU, 0x02d2U, 0x01ffU, 0x0072U, 0x0293U, 0x0008U, 0x00e5U, 0x03d5U,
	 0x0161U, 0x0269U, 0x02b8U, 0x01d4U, 0x02eaU, 0x03bdU, 0x02f1U, 0x02d3U,
	 0x01c9U, 0x0283U, 0x0045U, 0x02a6U, 0x01d2U, 0x02bfU, 0x01e8U, 0x0143U,
	 0x011aU, 0x01f7U, 0x0052U, 0x02cdU, 0x0026U, 0x002dU, 0x013bU, 0x03f2U}
}; /* curve_point */

#elif GF_M == 1918

const order_t prime_order = {
	 0x0078U, 0xeae9U, 0xd797U, 0xe06cU, 0xe9e5U, 0xe66dU, 0x330dU, 0x61dcU,
	 0x475aU, 0x0adaU, 0x2e3eU, 0x3589U, 0x8007U, 0xa83dU, 0xa51dU, 0xf15eU,
	 0xcee7U, 0x7b33U, 0xeac1U, 0x982eU, 0x5026U, 0xe882U, 0xbcc9U, 0xd421U,
	 0x6877U, 0x29b8U, 0x55c7U, 0xc07aU, 0xc9fbU, 0xe57bU, 0x684cU, 0x3f11U,
	 0x66b6U, 0xc418U, 0xada5U, 0xa769U, 0x9ffdU, 0x4a9bU, 0x0be3U, 0x7ad6U,
	 0x97f7U, 0xf4fdU, 0x08e2U, 0xd8f2U, 0x4dffU, 0x0ebaU, 0xc975U, 0x1dafU,
	 0xd253U, 0xf822U, 0x5599U, 0x0b92U, 0x8f25U, 0xb13cU, 0x1388U, 0x4891U,
	 0x78c6U, 0xe774U, 0xe248U, 0xc0f4U, 0xc9e8U, 0x7f6fU, 0xfbfeU, 0xaa9fU,
	 0x8471U, 0xe6b6U, 0x8511U, 0x240dU, 0x0060U, 0x5801U, 0xe395U, 0x525eU,
	 0xbb86U, 0xfc9eU, 0xe7f6U, 0xffbfU, 0x1aa9U, 0x6847U, 0x1e6bU, 0xd851U,
	 0x0240U, 0x1006U, 0x5580U, 0xee39U, 0x6525U, 0xebb8U, 0x6fc9U, 0xfe7fU,
	 0x9ffbU, 0x71aaU, 0xb684U, 0x11e6U, 0x0d85U, 0x6024U, 0x0100U, 0x9558U,
	 0x5ee3U, 0x8652U, 0x9ebbU, 0xf6fcU, 0xbfe7U, 0xa9ffU, 0x471aU, 0x6b68U,
	 0x511eU, 0x40d8U, 0x0602U, 0x8010U, 0x3955U, 0x25eeU, 0xb865U, 0xc9ebU,
	 0x7f6fU, 0xfbfeU, 0xaa9fU, 0x8471U, 0xe6b6U, 0x8511U, 0x240dU, 0x0060U,
	 0x0001U
}; /* prime_order (1905 bits) */

const ecPoint curve_point = {
	{0x0089U, 0x1484U, 0x087fU, 0x0c1eU, 0x155bU, 0x02f3U, 0x15b6U, 0x2a90U,
	 0x1e45U, 0x2abbU, 0x1fe1U, 0x2239U, 0x3d23U, 0x216aU, 0x0619U, 0x2bedU,
	 0x2067U, 0x2b19U, 0x3589U, 0x19c2U, 0x1831U, 0x179eU, 0x125aU, 0x1350U,
	 0x36edU, 0x28d4U, 0x0b33U, 0x15a9U, 0x1e7aU, 0x281dU, 0x219fU, 0x06b0U,
	 0x017fU, 0x0191U, 0x1d67U, 0x2b67U, 0x3adcU, 0x3f35U, 0x1169U, 0x3202U,
	 0x08f7U, 0x0f0dU, 0x03d3U, 0x07abU, 0x29d7U, 0x1f07U, 0x26b7U, 0x067fU,
	 0x3a23U, 0x2767U, 0x0ffdU, 0x388aU, 0x1c63U, 0x10f4U, 0x19d2U, 0x3736U,
	 0x236eU, 0x2428U, 0x2b58U, 0x3a25U, 0x148aU, 0x38fdU, 0x3d16U, 0x2c3cU,
	 0x06afU, 0x0e54U, 0x0524U, 0x2b3aU, 0x10c6U, 0x3ac0U, 0x2a6dU, 0x3f6dU,
	 0x07b0U, 0x32b5U, 0x3845U, 0x3d3cU, 0x2428U, 0x2abdU, 0x1ea0U, 0x32a0U,
	 0x16f8U, 0x1a35U, 0x2edaU, 0x1579U, 0x3e8bU, 0x16cdU, 0x1727U, 0x1eefU,
	 0x2163U, 0x1f87U, 0x2f08U, 0x0918U, 0x0704U, 0x253bU, 0x2c10U, 0x3ae9U,
	 0x1588U, 0x0015U, 0x3024U, 0x14d2U, 0x0c04U, 0x3f52U, 0x0530U, 0x32d8U,
	 0x101bU, 0x346fU, 0x1b5dU, 0x0704U, 0x047bU, 0x0bf4U, 0x2e71U, 0x2d65U,
	 0x3cb8U, 0x0c0eU, 0x255fU, 0x0ad9U, 0x1a83U, 0x23a3U, 0x30d7U, 0x040aU,
	 0x2397U, 0x0d94U, 0x0a65U, 0x1a18U, 0x28bdU, 0x2d00U, 0x2ee8U, 0x061fU,
	 0x3bd9U, 0x000bU, 0x1278U, 0x3a61U, 0x013dU, 0x053dU, 0x1edcU, 0x17c7U,
	 0x083aU, 0x24acU},
	{0x0089U, 0x306bU, 0x01cbU, 0x3971U, 0x0b40U, 0x2595U, 0x014bU, 0x021aU,
	 0x253aU, 0x286fU, 0x27ceU, 0x263fU, 0x1e4bU, 0x236eU, 0x39e0U, 0x1ac0U,
	 0x22beU, 0x2cf3U, 0x1c47U, 0x0badU, 0x16fbU, 0x3097U, 0x1c5bU, 0x3532U,
	 0x1f30U, 0x08fdU, 0x0e0aU, 0x2511U, 0x22e4U, 0x0cc3U, 0x29d4U, 0x0e73U,
	 0x3e36U, 0x3dc4U, 0x1baaU, 0x17a8U, 0x0f60U, 0x2dc3U, 0x2499U, 0x0e16U,
	 0x39e5U, 0x2198U, 0x39fcU, 0x3419U, 0x32aeU, 0x0306U, 0x2d4dU, 0x22ffU,
	 0x3b10U, 0x0a71U, 0x1118U, 0x3665U, 0x28dcU, 0x2fe1U, 0x14a6U, 0x1f5eU,
	 0x0ef1U, 0x07c3U, 0x35e5U, 0x1080U, 0x1f64U, 0x050cU, 0x3a7eU, 0x3dc8U,
	 0x29adU, 0x37fdU, 0x0c46U, 0x2e1fU, 0x2074U, 0x2189U, 0x0999U, 0x345cU,
	 0x069cU, 0x16e9U, 0x35dfU, 0x1de2U, 0x1ef0U, 0x379bU, 0x3830U, 0x2908U,
	 0x305dU, 0x17cbU, 0x2989U, 0x3493U, 0x38b8U, 0x264fU, 0x05e0U, 0x0d10U,
	 0x088dU, 0x22fcU, 0x18d2U, 0x0c8aU, 0x3fecU, 0x002dU, 0x13faU, 0x3b40U,
	 0x080aU, 0x2beaU, 0x0483U, 0x3d20U, 0x1a5aU, 0x3144U, 0x3fadU, 0x25ccU,
	 0x27f2U, 0x023fU, 0x1634U, 0x305eU, 0x1a7aU, 0x15dcU, 0x2ce8U, 0x2a5bU,
	 0x1608U, 0x1ed8U, 0x1405U, 0x0485U, 0x0afdU, 0x0e79U, 0x0f65U, 0x0bc8U,
	 0x1eefU, 0x2eeaU, 0x134fU, 0x02b4U, 0x12b5U, 0x213eU, 0x2181U, 0x0cbbU,
	 0x0053U, 0x02e2U, 0x3e1aU, 0x2101U, 0x2dd5U, 0x28c3U, 0x0167U, 0x0c08U,
	 0x08bcU, 0x02ebU}
}; /* curve_point */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GF_M */
