/*
	GF_M	dimension of the large finite field (GF_M = GF_L*GF_K)
	GF_L	dimension of the small finite field
	GF_K	degree of the large field reduction trinomial
	GF_T	intermediate power of the reduction trinomial
	GF_RP	reduction polynomial for the small field (truncated)
	GF_NZT	element of the large field with nonzero trace
	GF_TM0	size of trace mask
	GF_TM1	1st nonzero element of trace mask
	GF_TM2	2nd nonzero element of trace mask
	EC_B	scalar term of elliptic curve equation (y^2 + xy = x^3 + EC_B)
	EC_COF	cofactor of the selected elliptic curve point G
	EC_H	MQV modulus (ceil (lg(r)/2), where r is the prime order of G)
*/

#ifndef GF_M
#define GF_M		255 /* choose this value from the list below */
#endif /* ?GF_M */

#if GF_M == 24

#define GF_L	      8
#define GF_K	      3
#define GF_T	      1
#define GF_RP	0x001dU
#define GF_NZT	0x0020U
#define GF_TM0	      1
#define GF_TM1	0x0020U
#define EC_B	0x006eU
#define EC_COF	   236U
#define EC_H	     9U

#elif GF_M == 30

#define GF_L	     10
#define GF_K	      3
#define GF_T	      1
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x000cU
#define EC_COF	   976U
#define EC_H	    11U

#elif GF_M == 33

#define GF_L	     11
#define GF_K	      3
#define GF_T	      1
#define GF_RP	0x0005U
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0065U
#define EC_COF	  1964U
#define EC_H	    12U

#elif GF_M == 39

#define GF_L	     13
#define GF_K	      3
#define GF_T	      1
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0001U
#define EC_COF	  8012U
#define EC_H	    14U

#elif GF_M == 40

#define GF_L	      8
#define GF_K	      5
#define GF_T	      2
#define GF_RP	0x001dU
#define GF_NZT	0x0020U
#define GF_TM0	      4
#define GF_TM1	0x0020U
#define GF_TM2	0x0020U
#define EC_B	0x006eU
#define EC_COF	  2596U
#define EC_H	    15U

#elif GF_M == 42

#define GF_L	     14
#define GF_K	      3
#define GF_T	      1
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x026eU
#define EC_COF	 16148U
#define EC_H	    15U

#elif GF_M == 45

#define GF_L	      9
#define GF_K	      5
#define GF_T	      2
#define GF_RP	0x0011U
#define GF_TM0	      4
#define GF_TM1	0x0021U
#define GF_TM2	0x0021U
#define EC_B	0x000bU
#define EC_COF	   492U
#define EC_H	    19U

#elif GF_M == 48

#define GF_L	     16
#define GF_K	      3
#define GF_T	      1
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x0b56U
#define EC_COF	 65036U
#define EC_H	    17U

#elif GF_M == 55

#define GF_L	     11
#define GF_K	      5
#define GF_T	      2
#define GF_RP	0x0005U
#define GF_TM0	      4
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x000eU
#define EC_COF	  1968U
#define EC_H	    23U

#elif GF_M == 56

#define GF_L	      8
#define GF_K	      7
#define GF_T	      1
#define GF_RP	0x001dU
#define GF_NZT	0x0020U
#define GF_TM0	      1
#define GF_TM1	0x0020U
#define EC_B	0x0029U
#define EC_COF	   244U
#define EC_H	    25U

#elif GF_M == 60

#define GF_L	     12
#define GF_K	      5
#define GF_T	      2
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      4
#define GF_TM1	0x0800U
#define GF_TM2	0x0800U
#define EC_B	0x081fU
#define EC_COF	  3996U
#define EC_H	    25U

#elif GF_M == 63

#define GF_L	      9
#define GF_K	      7
#define GF_T	      1
#define GF_RP	0x0011U
#define GF_TM0	      1
#define GF_TM1	0x0021U
#define EC_B	0x002bU
#define EC_COF	   544U
#define EC_H	    27U

#elif GF_M == 65

#define GF_L	     13
#define GF_K	      5
#define GF_T	      2
#define GF_RP	0x001bU
#define GF_TM0	      4
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x01a2U
#define EC_COF	  8024U
#define EC_H	    27U

#elif GF_M == 70

#define GF_L	     10
#define GF_K	      7
#define GF_T	      1
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x009aU
#define EC_COF	  1020U
#define EC_H	    31U

#elif GF_M == 77

#define GF_L	     11
#define GF_K	      7
#define GF_T	      1
#define GF_RP	0x0005U
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0017U
#define EC_COF	  2004U
#define EC_H	    34U

#elif GF_M == 80

#define GF_L	     16
#define GF_K	      5
#define GF_T	      2
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      4
#define GF_TM1	0x2800U
#define GF_TM2	0x2800U
#define EC_B	0x0fadU
#define EC_COF	 65084U
#define EC_H	    33U

#elif GF_M == 84

#define GF_L	     12
#define GF_K	      7
#define GF_T	      1
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x0800U
#define EC_B	0x0801U
#define EC_COF	  3988U
#define EC_H	    37U

#elif GF_M == 91

#define GF_L	     13
#define GF_K	      7
#define GF_T	      1
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x007cU
#define EC_COF	  8040U
#define EC_H	    40U

#elif GF_M == 99

#define GF_L	      9
#define GF_K	     11
#define GF_T	      2
#define GF_RP	0x0011U
#define GF_TM0	     10
#define GF_TM1	0x0021U
#define GF_TM2	0x0021U
#define EC_B	0x000dU
#define EC_COF	   516U
#define EC_H	    45U

#elif GF_M == 105

#define GF_L	     15
#define GF_K	      7
#define GF_T	      1
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x03d1U
#define EC_COF	 32476U
#define EC_H	    46U

#elif GF_M == 110

#define GF_L	     10
#define GF_K	     11
#define GF_T	      2
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	     10
#define GF_TM1	0x0080U
#define GF_TM2	0x0080U
#define EC_B	0x008bU
#define EC_COF	  1028U
#define EC_H	    50U

#elif GF_M == 112

#define GF_L	     16
#define GF_K	      7
#define GF_T	      1
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x0b56U
#define EC_COF	 65036U
#define EC_H	    49U

#elif GF_M == 132

#define GF_L	     12
#define GF_K	     11
#define GF_T	      2
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	     10
#define GF_TM1	0x0800U
#define GF_TM2	0x0800U
#define EC_B	0x0823U
#define EC_COF	  4100U
#define EC_H	    60U

#elif GF_M == 136

#define GF_L	      8
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x001dU
#define GF_NZT	0x0020U
#define GF_TM0	      1
#define GF_TM1	0x0020U
#define EC_B	0x0020U
#define EC_COF	   276U
#define EC_H	    64U

#elif GF_M == 143

#define GF_L	     13
#define GF_K	     11
#define GF_T	      2
#define GF_RP	0x001bU
#define GF_TM0	     10
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x0305U
#define EC_COF	  8032U
#define EC_H	    66U

#elif GF_M == 153

#define GF_L	      9
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x0011U
#define GF_TM0	      1
#define GF_TM1	0x0021U
#define EC_B	0x0013U
#define EC_COF	   500U
#define EC_H	    73U

#elif GF_M == 154

#define GF_L	     14
#define GF_K	     11
#define GF_T	      2
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	     10
#define GF_TM1	0x2a00U
#define GF_TM2	0x2a00U
#define EC_B	0x0092U
#define EC_COF	 16208U
#define EC_H	    71U

#elif GF_M == 165

#define GF_L	     15
#define GF_K	     11
#define GF_T	      2
#define GF_RP	0x0003U
#define GF_TM0	     10
#define GF_TM1	0x0001U
#define GF_TM2	0x0001U
#define EC_B	0x008cU
#define EC_COF	 32520U
#define EC_H	    76U

#elif GF_M == 170

#define GF_L	     10
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x0030U
#define EC_COF	  1016U
#define EC_H	    81U

#elif GF_M == 176

#define GF_L	     16
#define GF_K	     11
#define GF_T	      2
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	     10
#define GF_TM1	0x2800U
#define GF_TM2	0x2800U
#define EC_B	0x001aU
#define EC_COF	65664UL
#define EC_H	    80U

#elif GF_M == 187

#define GF_L	     11
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x0005U
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x003aU
#define EC_COF	  1992U
#define EC_H	    89U

#elif GF_M == 204

#define GF_L	     12
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x0800U
#define EC_B	0x0804U
#define EC_COF	  4060U
#define EC_H	    97U

#elif GF_M == 207

#define GF_L	      9
#define GF_K	     23
#define GF_T	      5
#define GF_RP	0x0011U
#define GF_TM0	      1
#define GF_TM1	0x0021U
#define EC_B	0x009bU
#define EC_COF	   548U
#define EC_H	    99U

#elif GF_M == 221

#define GF_L	     13
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0305U
#define EC_COF	  8032U
#define EC_H	   105U

#elif GF_M == 230

#define GF_L	     10
#define GF_K	     23
#define GF_T	      5
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x000cU
#define EC_COF	135664UL
#define EC_H	   107U

#elif GF_M == 238

#define GF_L	     14
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x011bU
#define EC_COF	 16152U
#define EC_H	   113U

#elif GF_M == 253

#define GF_L	     11
#define GF_K	     23
#define GF_T	      5
#define GF_RP	0x0005U
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x001fU
#define EC_COF	  2036U
#define EC_H	   122U

#elif GF_M == 255

#define GF_L	     15
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x00a1U
#define EC_COF	 32460U
#define EC_H	   121U

#elif GF_M == 261

#define GF_L	      9
#define GF_K	     29
#define GF_T	      2
#define GF_RP	0x0011U
#define GF_TM0	     28
#define GF_TM1	0x0021U
#define GF_TM2	0x0021U
#define EC_B	0x0025U
#define EC_COF	   496U
#define EC_H	   127U

#elif GF_M == 272

#define GF_L	     16
#define GF_K	     17
#define GF_T	      3
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x0803U
#define EC_COF	 65132U
#define EC_H	   129U

#elif GF_M == 276

#define GF_L	     12
#define GF_K	     23
#define GF_T	      5
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x0800U
#define EC_B	0x000cU
#define EC_COF	  4152U
#define EC_H	   132U

#elif GF_M == 279

#define GF_L	      9
#define GF_K	     31
#define GF_T	      3
#define GF_RP	0x0011U
#define GF_TM0	      1
#define GF_TM1	0x0021U
#define EC_B	0x000cU
#define EC_COF	   552U
#define EC_H	   135U

#elif GF_M == 290

#define GF_L	     10
#define GF_K	     29
#define GF_T	      2
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	     28
#define GF_TM1	0x0080U
#define GF_TM2	0x0080U
#define EC_B	0x000cU
#define EC_COF	   976U
#define EC_H	   141U

#elif GF_M == 299

#define GF_L	     13
#define GF_K	     23
#define GF_T	      5
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0214U
#define EC_COF	  8020U
#define EC_H	   144U

#elif GF_M == 310

#define GF_L	     10
#define GF_K	     31
#define GF_T	      3
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x0002U
#define EC_COF	  1024U
#define EC_H	   151U

#elif GF_M == 319

#define GF_L	     11
#define GF_K	     29
#define GF_T	      2
#define GF_RP	0x0005U
#define GF_TM0	     28
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x003aU
#define EC_COF	  1992U
#define EC_H	   155U

#elif GF_M == 322

#define GF_L	     14
#define GF_K	     23
#define GF_T	      5
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x024dU
#define EC_COF	 16220U
#define EC_H	   155U

#elif GF_M == 341

#define GF_L	     11
#define GF_K	     31
#define GF_T	      3
#define GF_RP	0x0005U
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x000eU
#define EC_COF	  1968U
#define EC_H	   166U

#elif GF_M == 345

#define GF_L	     15
#define GF_K	     23
#define GF_T	      5
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x0003U
#define EC_COF	 32532U
#define EC_H	   166U

#elif GF_M == 348

#define GF_L	     12
#define GF_K	     29
#define GF_T	      2
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	     28
#define GF_TM1	0x0800U
#define GF_TM2	0x0800U
#define EC_B	0x0013U
#define EC_COF	  4048U
#define EC_H	   169U

#elif GF_M == 368

#define GF_L	     16
#define GF_K	     23
#define GF_T	      5
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x094cU
#define EC_COF	 65380U
#define EC_H	   177U

#elif GF_M == 372

#define GF_L	     12
#define GF_K	     31
#define GF_T	      3
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x0800U
#define EC_B	0x0007U
#define EC_COF	  4032U
#define EC_H	   181U

#elif GF_M == 377

#define GF_L	     13
#define GF_K	     29
#define GF_T	      2
#define GF_RP	0x001bU
#define GF_TM0	     28
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x0091U
#define EC_COF	  8124U
#define EC_H	   183U

#elif GF_M == 403

#define GF_L	     13
#define GF_K	     31
#define GF_T	      3
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x007cU
#define EC_COF	  8040U
#define EC_H	   196U

#elif GF_M == 406

#define GF_L	     14
#define GF_K	     29
#define GF_T	      2
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	     28
#define GF_TM1	0x2a00U
#define GF_TM2	0x2a00U
#define EC_B	0x0027U
#define EC_COF	 16136U
#define EC_H	   197U

#elif GF_M == 410

#define GF_L	     10
#define GF_K	     41
#define GF_T	      3
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x00abU
#define EC_COF	  1004U
#define EC_H	   201U

#elif GF_M == 423

#define GF_L	      9
#define GF_K	     47
#define GF_T	      5
#define GF_RP	0x0011U
#define GF_TM0	      1
#define GF_TM1	0x0021U
#define EC_B	0x0009U
#define EC_COF	   524U
#define EC_H	   207U

#elif GF_M == 434

#define GF_L	     14
#define GF_K	     31
#define GF_T	      3
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x0043U
#define EC_COF	 16248U
#define EC_H	   211U

#elif GF_M == 435

#define GF_L	     15
#define GF_K	     29
#define GF_T	      2
#define GF_RP	0x0003U
#define GF_TM0	     28
#define GF_TM1	0x0001U
#define GF_TM2	0x0001U
#define EC_B	0x00ccU
#define EC_COF	 32792U
#define EC_H	   210U

#elif GF_M == 451

#define GF_L	     11
#define GF_K	     41
#define GF_T	      3
#define GF_RP	0x0005U
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x006aU
#define EC_COF	176624UL
#define EC_H	   217U

#elif GF_M == 464

#define GF_L	     16
#define GF_K	     29
#define GF_T	      2
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	     28
#define GF_TM1	0x2800U
#define GF_TM2	0x2800U
#define EC_B	0x0846U
#define EC_COF	 65212U
#define EC_H	   225U

#elif GF_M == 465

#define GF_L	     15
#define GF_K	     31
#define GF_T	      3
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x01a5U
#define EC_COF	 32468U
#define EC_H	   226U

#elif GF_M == 470

#define GF_L	     10
#define GF_K	     47
#define GF_T	      5
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x000bU
#define EC_COF	   984U
#define EC_H	   231U

#elif GF_M == 492

#define GF_L	     12
#define GF_K	     41
#define GF_T	      3
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x0800U
#define EC_B	0x0830U
#define EC_COF	  4076U
#define EC_H	   241U

#elif GF_M == 496

#define GF_L	     16
#define GF_K	     31
#define GF_T	      3
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x080bU
#define EC_COF	 65372U
#define EC_H	   241U

#elif GF_M == 517

#define GF_L	     11
#define GF_K	     47
#define GF_T	      5
#define GF_RP	0x0005U
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x001dU
#define EC_COF	558076UL
#define EC_H	   249U

#elif GF_M == 533

#define GF_L	     13
#define GF_K	     41
#define GF_T	      3
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x006aU
#define EC_COF	  8352U
#define EC_H	   260U

#elif GF_M == 564

#define GF_L	     12
#define GF_K	     47
#define GF_T	      5
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x0800U
#define EC_B	0x0800U
#define EC_COF	  4156U
#define EC_H	   276U

#elif GF_M == 568

#define GF_L	      8
#define GF_K	     71
#define GF_T	      6
#define GF_RP	0x001dU
#define GF_NZT	0x0020U
#define GF_TM0	     66
#define GF_TM1	0x0020U
#define GF_TM2	0x0020U
#define EC_B	0x0020U
#define EC_COF	   276U
#define EC_H	   280U

#elif GF_M == 574

#define GF_L	     14
#define GF_K	     41
#define GF_T	      3
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x000eU
#define EC_COF	 16496U
#define EC_H	   280U

#elif GF_M == 611

#define GF_L	     13
#define GF_K	     47
#define GF_T	      5
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x000aU
#define EC_COF	  8176U
#define EC_H	   300U

#elif GF_M == 615

#define GF_L	     15
#define GF_K	     41
#define GF_T	      3
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x05b2U
#define EC_COF	 32408U
#define EC_H	   301U

#elif GF_M == 639

#define GF_L	      9
#define GF_K	     71
#define GF_T	      6
#define GF_RP	0x0011U
#define GF_TM0	     66
#define GF_TM1	0x0021U
#define GF_TM2	0x0021U
#define EC_B	0x0019U
#define EC_COF	   476U
#define EC_H	   316U

#elif GF_M == 656

#define GF_L	     16
#define GF_K	     41
#define GF_T	      3
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x0422U
#define EC_COF	 65080U
#define EC_H	   321U

#elif GF_M == 657

#define GF_L	      9
#define GF_K	     73
#define GF_T	     25
#define GF_RP	0x0011U
#define GF_TM0	      1
#define GF_TM1	0x0021U
#define EC_B	0x0019U
#define EC_COF	   476U
#define EC_H	   325U

#elif GF_M == 705

#define GF_L	     15
#define GF_K	     47
#define GF_T	      5
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x008cU
#define EC_COF	 32520U
#define EC_H	   346U

#elif GF_M == 730

#define GF_L	     10
#define GF_K	     73
#define GF_T	     25
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x0007U
#define EC_COF	919096UL
#define EC_H	   356U

#elif GF_M == 752

#define GF_L	     16
#define GF_K	     47
#define GF_T	      5
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x0a0eU
#define EC_COF	 65108U
#define EC_H	   369U

#elif GF_M == 781

#define GF_L	     11
#define GF_K	     71
#define GF_T	      6
#define GF_RP	0x0005U
#define GF_TM0	     66
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x0009U
#define EC_COF	  2068U
#define EC_H	   385U

#elif GF_M == 904

#define GF_L	      8
#define GF_K	    113
#define GF_T	      9
#define GF_RP	0x001dU
#define GF_NZT	0x0020U
#define GF_TM0	      1
#define GF_TM1	0x0020U
#define EC_B	0x001fU
#define EC_COF	   232U
#define EC_H	   449U

#elif GF_M == 927

#define GF_L	      9
#define GF_K	    103
#define GF_T	      9
#define GF_RP	0x0011U
#define GF_TM0	      1
#define GF_TM1	0x0021U
#define EC_B	0x0002U
#define EC_COF	   512U
#define EC_H	   460U

#elif GF_M == 948

#define GF_L	     12
#define GF_K	     79
#define GF_T	      9
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x0800U
#define EC_B	0x0017U
#define EC_COF	  4096U
#define EC_H	   469U

#elif GF_M == 949

#define GF_L	     13
#define GF_K	     73
#define GF_T	     25
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0006U
#define EC_COF	  8064U
#define EC_H	   469U

#elif GF_M == 979

#define GF_L	     11
#define GF_K	     89
#define GF_T	     38
#define GF_RP	0x0005U
#define GF_TM0	     52
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x0007U
#define EC_COF	367308UL
#define EC_H	   481U

#elif GF_M == 994

#define GF_L	     14
#define GF_K	     71
#define GF_T	      6
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	     66
#define GF_TM1	0x2a00U
#define GF_TM2	0x2a00U
#define EC_B	0x0239U
#define EC_COF	 16316U
#define EC_H	   491U

#elif GF_M == 1022

#define GF_L	     14
#define GF_K	     73
#define GF_T	     25
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x011bU
#define EC_COF	 16152U
#define EC_H	   505U

#elif GF_M == 1027

#define GF_L	     13
#define GF_K	     79
#define GF_T	      9
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0021U
#define EC_COF	  8324U
#define EC_H	   507U

#elif GF_M == 1067

#define GF_L	     11
#define GF_K	     97
#define GF_T	      6
#define GF_RP	0x0005U
#define GF_TM0	     92
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x000fU
#define EC_COF	810676UL
#define EC_H	   524U

#elif GF_M == 1095

#define GF_L	     15
#define GF_K	     73
#define GF_T	     25
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x00e2U
#define EC_COF	29039224UL
#define EC_H	   536U

#elif GF_M == 1136

#define GF_L	     16
#define GF_K	     71
#define GF_T	      6
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	     66
#define GF_TM1	0x2800U
#define GF_TM2	0x2800U
#define EC_B	0x00f1U
#define EC_COF	65648UL
#define EC_H	   560U

#elif GF_M == 1168

#define GF_L	     16
#define GF_K	     73
#define GF_T	     25
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x08b3U
#define EC_COF	 65180U
#define EC_H	   577U

#elif GF_M == 1185

#define GF_L	     15
#define GF_K	     79
#define GF_T	      9
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x0089U
#define EC_COF	 32572U
#define EC_H	   586U

#elif GF_M == 1236

#define GF_L	     12
#define GF_K	    103
#define GF_T	      9
#define GF_RP	0x0053U
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x0800U
#define EC_B	0x0006U
#define EC_COF	  4016U
#define EC_H	   613U

#elif GF_M == 1246

#define GF_L	     14
#define GF_K	     89
#define GF_T	     38
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	     52
#define GF_TM1	0x2a00U
#define GF_TM2	0x2a00U
#define EC_B	0x0222U
#define EC_COF	 16460U
#define EC_H	   616U

#elif GF_M == 1261

#define GF_L	     13
#define GF_K	     97
#define GF_T	      6
#define GF_RP	0x001bU
#define GF_TM0	     92
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x0124U
#define EC_COF	7907824UL
#define EC_H	   620U

#elif GF_M == 1264

#define GF_L	     16
#define GF_K	     79
#define GF_T	      9
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x0805U
#define EC_COF	 65428U
#define EC_H	   625U

#elif GF_M == 1335

#define GF_L	     15
#define GF_K	     89
#define GF_T	     38
#define GF_RP	0x0003U
#define GF_TM0	     52
#define GF_TM1	0x0001U
#define GF_TM2	0x0001U
#define EC_B	0x06cfU
#define EC_COF	 32996U
#define EC_H	   660U

#elif GF_M == 1339

#define GF_L	     13
#define GF_K	    103
#define GF_T	      9
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0008U
#define EC_COF	  8112U
#define EC_H	   664U

#elif GF_M == 1358

#define GF_L	     14
#define GF_K	     97
#define GF_T	      6
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	     92
#define GF_TM1	0x2a00U
#define GF_TM2	0x2a00U
#define EC_B	0x0338U
#define EC_COF	 16172U
#define EC_H	   673U

#elif GF_M == 1424

#define GF_L	     16
#define GF_K	     89
#define GF_T	     38
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	     52
#define GF_TM1	0x2800U
#define GF_TM2	0x2800U
#define EC_B	0x0829U
#define EC_COF	2101761436UL
#define EC_H	   697U

#elif GF_M == 1455

#define GF_L	     15
#define GF_K	     97
#define GF_T	      6
#define GF_RP	0x0003U
#define GF_TM0	     92
#define GF_TM1	0x0001U
#define GF_TM2	0x0001U
#define EC_B	0x01a7U
#define EC_COF	 32564U
#define EC_H	   721U

#elif GF_M == 1469

#define GF_L	     13
#define GF_K	    113
#define GF_T	      9
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x00a3U
#define EC_COF	1824172UL
#define EC_H	   725U

#elif GF_M == 1507

#define GF_L	     11
#define GF_K	    137
#define GF_T	     21
#define GF_RP	0x0005U
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0120U
#define EC_COF	1632832UL
#define EC_H	   744U

#elif GF_M == 1510

#define GF_L	     10
#define GF_K	    151
#define GF_T	      3
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x0002U
#define EC_COF	  1024U
#define EC_H	   751U

#elif GF_M == 1528

#define GF_L	      8
#define GF_K	    191
#define GF_T	      9
#define GF_RP	0x001dU
#define GF_NZT	0x0020U
#define GF_TM0	      1
#define GF_TM1	0x0020U
#define EC_B	0x001fU
#define EC_COF	   232U
#define EC_H	   761U

#elif GF_M == 1545

#define GF_L	     15
#define GF_K	    103
#define GF_T	      9
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x00ccU
#define EC_COF	 32792U
#define EC_H	   765U

#elif GF_M == 1552

#define GF_L	     16
#define GF_K	     97
#define GF_T	      6
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	     92
#define GF_TM1	0x2800U
#define GF_TM2	0x2800U
#define EC_B	0x001aU
#define EC_COF	65664UL
#define EC_H	   768U

#elif GF_M == 1582

#define GF_L	     14
#define GF_K	    113
#define GF_T	      9
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x001fU
#define EC_COF	 16424U
#define EC_H	   784U

#elif GF_M == 1648

#define GF_L	     16
#define GF_K	    103
#define GF_T	      9
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x0b56U
#define EC_COF	 65036U
#define EC_H	   817U

#elif GF_M == 1651

#define GF_L	     13
#define GF_K	    127
#define GF_T	      1
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x0160U
#define EC_COF	  8224U
#define EC_H	   819U

#elif GF_M == 1695

#define GF_L	     15
#define GF_K	    113
#define GF_T	      9
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x01b4U
#define EC_COF	 32976U
#define EC_H	   840U

#elif GF_M == 1737

#define GF_L	      9
#define GF_K	    193
#define GF_T	     15
#define GF_RP	0x0011U
#define GF_TM0	      1
#define GF_TM1	0x0021U
#define EC_B	0x0016U
#define EC_COF	   520U
#define EC_H	   864U

#elif GF_M == 1778

#define GF_L	     14
#define GF_K	    127
#define GF_T	      1
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x0027U
#define EC_COF	 16136U
#define EC_H	   883U

#elif GF_M == 1781

#define GF_L	     13
#define GF_K	    137
#define GF_T	     21
#define GF_RP	0x001bU
#define GF_TM0	      1
#define GF_TM1	0x0201U
#define EC_B	0x000cU
#define EC_COF	  8240U
#define EC_H	   884U

#elif GF_M == 1808

#define GF_L	     16
#define GF_K	    113
#define GF_T	      9
#define GF_RP	0x002dU
#define GF_NZT	0x0800U
#define GF_TM0	      1
#define GF_TM1	0x2800U
#define EC_B	0x0087U
#define EC_COF	65544UL
#define EC_H	   896U

#elif GF_M == 1837

#define GF_L	     11
#define GF_K	    167
#define GF_T	      6
#define GF_RP	0x0005U
#define GF_TM0	    162
#define GF_TM1	0x0201U
#define GF_TM2	0x0201U
#define EC_B	0x0021U
#define EC_COF	  2132U
#define EC_H	   913U

#elif GF_M == 1905

#define GF_L	     15
#define GF_K	    127
#define GF_T	      1
#define GF_RP	0x0003U
#define GF_TM0	      1
#define GF_TM1	0x0001U
#define EC_B	0x00aeU
#define EC_COF	 32616U
#define EC_H	   946U

#elif GF_M == 1910

#define GF_L	     10
#define GF_K	    191
#define GF_T	      9
#define GF_RP	0x0009U
#define GF_NZT	0x0080U
#define GF_TM0	      1
#define GF_TM1	0x0080U
#define EC_B	0x0082U
#define EC_COF	  1076U
#define EC_H	   950U

#elif GF_M == 1918

#define GF_L	     14
#define GF_K	    137
#define GF_T	     21
#define GF_RP	0x002bU
#define GF_NZT	0x0200U
#define GF_TM0	      1
#define GF_TM1	0x2a00U
#define EC_B	0x002dU
#define EC_COF	 16360U
#define EC_H	   953U

#else

#error "The selected GF_M value is not acceptable"

#endif /* GF_M */
