$ save_verify = f$verify(f$integer("0''apache_daemon_verify'"))
$!
$! Master procedure for running the apache executable.  It has 4 modes of
$! operation selected by the value of P1:
$!
$!   "STARTUP"	Create a detached process, if P2 is "SYSTEM", define
$!		apache_root in the system table.  Sys$output for the
$!		created process is apache_root:[logs]apache_daemon.log.
$!
$!   "SHUTDOWN" Send shutdown signal to process identified in
$!		apache_root:[logs]httpd.pid.
$!
$!   "RUN"	Run the program standalone.  Options may be specified
$!		as P2..P8
$!
$!   "RESTART"  Send restart signal to process identified in
$!		apache_root:[logs]httpd.pid.
$!
$ save_defdir = f$environment("DEFAULT")
$ arch = f$getsyi("ARCH_NAME")
$!
$ if P1 .eqs. "STARTUP" then goto start_server
$ if P1 .eqs. "SHUTDOWN" .or. P1 .eqs. "RESTART" then goto kill_server
$!
$ if P1 .eqs. "" 
$ then
$!
$!   See if we are a detached process and change to "RUN" operation.
$!
$    mode = f$mode()
$    write sys$output "Proces mode: ", mode
$    if mode .nes. "INTERACTIVE"
$    then
$       set verify
$	P1 = "RUN"
$	define sys$error sys$output
$    endif
$ endif
$!
$ if P1 .nes. "RUN" 
$ then
$!
$!   Unrecognized qualifier.
$!
$    gosub display_instructions
$    goto restore
$ endif
$!
$! Make sure apache_root is defined
$!
$ gosub get_root
$ if apache_root .eqs. "" then goto restore
$ if f$trnlnm("apache_root") .eqs. ""
$ then
$    define apache_root 'apache_root'/trans=(terminal,conceal) 'apache_secondary_root'
$ endif
$ if f$trnlnm("apache_privileged") .eqs. "" then define apache_privileged -
	"apache_privileged.exe_''arch'"
$!
$! Actually run the server.
$!
$ httpd = "$apache_root:[000000]apache_httpd.exe_" + arch
$ on error then goto restore
$ on control_y then goto restore
$! set watch file/class=(dir,major)
$ define apache apache_root
$ define apache_script "''apache_root_dir'"apache_script.com"
$ set default apache_root:[logs]
$ i = 2
$ args = ""
$ next_p:
$    arg = p'i'
$    if arg .nes. "" then args = args + " ""''arg'"""
$    i = i + 1
$    if i .lt. 9 then goto next_p
$ httpd 'args'
$!
$ restore:
$ set control=y
$! set watch file/class=none
$ set default 'save_defdir'
$ save_verify = f$verify(save_verify)
$ exit
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! This section is executed when P1 == "STARTUP".  Create a detached
$! process running apache_httpd.  Other parameters:
$!    P2	If SYSTEM, create system logical names.
$!    P3	Process quota overrides.
$!
$ start_server:
$!
$! Get location and define apache_root logical.
$!
$ gosub get_root
$ if apache_root .eqs. "" .or. apache_root_dir .eqs. ""
$ then
$	write sys$output "Error determining apache root"
$	goto restore
$ endif
$ table = ""
$ if p2 .eqs. "SYSTEM" then table = "/system/exec"
$ define 'table' apache_root 'apache_root'/trans=(terminal,conceal) -
	'apache_secondary_root'
$!
$! do sanity checks, req_list is list of files that
$! this procedure expects to find in apache_root:[000000] (.exe files
$! have _'arch' appended).
$!
$ req_list = "apache_httpd.exe,apache_script.com,apache_script_control.exe," + -
	"apache_kill.exe"
$ i = 0
$ missing = 0
$ next_required:
$    required = f$element(i,",",req_list)
$    if required .eqs. "," then goto required_done
$    if f$edit(f$parse(required,,,"TYPE","SYNTAX_ONLY"),"UPCASE") .eqs. ".EXE" -
	then required = required + "_" + arch
$    required = f$parse(required,apache_root_dir)
$    if f$search(required) .eqs. ""
$    then
$	write sys$output "Missing required file: ", required
$	missing = missing + 1
$    endif
$    i = i + 1
$    goto next_required
$ required_done:
$ if missing .gt. 0 then goto restore
$!
$! Install images if doing system startup.
$!
$ if p2 .eqs. "SYSTEM"
$ then
$!
$!   main image.
$!
$    iname = "apache_root:[000000]apache_httpd.exe_" + arch
$    verb = "ADD"
$    if f$file(iname,"KNOWN") then verb = "REPLACE"
$    install 'verb' 'iname' /share/open/header
$!
$!   User-written system service to let non-privileged user create
$!   privileged ports.
$!
$    verb = "ADD"
$    iname = "apache_root:[000000]apache_privileged.exe_" + arch
$    if f$search(iname) .nes. ""
$    then
$        if f$file(iname,"KNOWN") then verb = "REPLACE"
$        install 'verb' 'iname' /share/open/head/protect
$!
$!	 Service reads exec mode logical to determine grant capability to user.
$!       The detached process we create will have a different UIC but the
$!	 current process's username (i.e. system).
$!
$	 plv_flags = 3				! socket create + uaf_access
$	 cur_username = f$getjpi("0","USERNAME")
$	 define/system/exec apache_plv_enable_'cur_username' 'plv_flags',80,1023
$    else
$        type sys$input
Warning, the apache_privleged protected image is not present.  Non-privileged
uses cannot listen on ports less than 1024 nor translate /~username for
usernames other than their own.
$    endif
$!
$!   Make qualifiers for run/detached to set privileges and username.
$!
$    gosub find_configured_user
$    write sys$output "Detached process will have UIC of ", conf_user, -
	", edit [conf]httpd.conf to change."
$    uic = "/priv=(noall,tmpmbx,netmbx)/uic=" + conf_user
$ else
$    uic = ""
$ endif
$!
$! Create detached process, note that we can't reference the apache_root
$! logical because it won't be defined in the new process's logical
$! name table.
$!
$ set default 'apache_root_dir'
$ infile = f$parse(apache_root_dir,apache_daemon_proc)
$!
$! set defaults for output file.
$!
$ x_outfile = f$extract(0,f$length(apache_root_dir)-1,apache_root_dir) + -
	".logs]apache_daemon.log"
$!
$ x_ast_limit = f$getjpi("0","ASTLM")
$ x_buffer_limit = f$getjpi("0","BYTLM")
$ x_enqueue_limit = f$getjpi("0","ENQLM")
$ x_wsextent = 30000
$ x_wslimit = 8000
$ x_wsquota = 15000
$ x_file_limit = f$getjpi("0","FILLM")
$ x_bufio = f$getjpi("0","BIOLM")
$ x_dirio = f$getjpi("0","DIOLM")
$ x_page_file = f$getjpi("0","PGFLQUOTA")
$ x_queue_limit = f$getjpi("0","ENQLM")
$ x_subprocess_limit = f$getjpi("0","PRCLM")
$!
$! Let user override defaults.
$!
$ if p3 .nes. "" then gosub get_p3_overrides
$!
$ run/detached sys$system:loginout -
	/input='infile' /output='x_outfile' 'uic' /resource_wait -
	/ast='x_ast_limit /buffer='x_buffer_limit /enqueu='x_enqueue_limit -
	/work='x_wsquota /max='x_wslimit /extent='x_wsextent -
	/file_limit='x_file_limit /io_buf='x_bufio /io_direct='x_dirio -
	/page_file='x_page_file' /enqueue='x_queue_limit -
	/subprocess_limit='x_subprocess_limit !	/authorize
$ set default 'save_defdir'
$ goto restore
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! invoke apache kill program to send signal to apache.  We assume the
$! pid file is apache_root:[logs]httpd.pid
$!
$ kill_server:
$ gosub get_root
$ if apache_root .eqs. "" .or. apache_root_dir .eqs. ""
$ then
$	write sys$output "Error determining apache root"
$	goto restore
$ endif
$ on error then goto restore
$ akill = "$" + apache_root_dir + "apache_kill.exe_" + arch
$ akill 'apache_root'[logs]httpd.pid 'p1'
$ goto restore
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!  Define apache_root logical to be the directory containing this
$!  command procedure.
$!
$!  Inputs:   none
$!  outputs:  apache_root		value for rooted logical.
$!	      apache_root_dir		apache_root with "]" for ".]"
$!	      apache_secondary_root	non-null if apache_base defined.
$!	      apache_daemon_proc
$!
$ get_root:
$ apache_root = ""
$ apache_secondary_root = ""
$ apache_daemon_proc = f$environment("PROCEDURE")
$ gr_i = f$length(apache_daemon_proc) -
	 - f$length(f$parse(apache_daemon_proc,,,"VERSION","SYNTAX_ONLY"))
$ apache_daemon_proc = f$extract(0,gr_i,apache_daemon_proc)
$!
$! Convert [conceal-dir.][dir] to [conceal-dir.dir], trimming extraneous
$! 000000 directory if present.
$!
$ gr_base = f$parse(apache_daemon_proc,,,,"NO_CONCEAL")
$ if f$parse(gr_base,,,"NODE","SYNTAX_ONLY") .nes. "" then return
$ gr_dev = f$parse(gr_base,,,"DEVICE","SYNTAX_ONLY")
$ gr_dir = f$parse(gr_base,,,"DIRECTORY","SYNTAX_ONLY")
$ if gr_dir .eqs. "" then return
$ gr_dir = gr_dir - "][" - "]<" - ">[" - "><"
$ gr_dir = f$extract(0,f$length(gr_dir)-1, gr_dir)
$ gr_tail = f$extract(f$length(gr_dir)-7,7,gr_dir)
$ if gr_tail .eqs. ".000000" then gr_dir = -
	f$extract(0,f$length(gr_dir)-7,gr_dir)
$!
$! enough of this silliness with "<>" brackets, force to square brackets.
$!
$ apache_root_dir = gr_dev + "[" + f$extract(1,f$length(gr_dir),gr_dir) + "]"
$ apache_root = gr_dev + "[" + f$extract(1,f$length(gr_dir),gr_dir) + ".]"
$ gr_secondary = f$trnlnm("APACHE_BASE")
$ if gr_secondary .nes. "" then apache_secondary_root = ",APACHE_BASE:"
$ return
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Scan the apache_root:[conf]httpd.conf file and set the conf_user
$! variable.
$!
$ find_configured_user:
$ conf_user = ""
$ open cfile apache_root:[conf]httpd.conf/error=missing_config_file
$ cu_next_line:
$    read cfile cu_line/error=cu_finish/end=cu_finish
$    if f$extract(0,1,cu_line) .eqs. "" then goto cu_next_line
$    cu_line = f$edit(cu_line,"TRIM,COMPRESS")
$    if cu_line .eqs. "" then goto cu_next_line
$    if f$edit(f$element(0," ",cu_line),"UPCASE") .nes. -
		"USER" then goto cu_next_line
$!   Found the 'user' line, set variable and exit loop
$    conf_user = f$element(1," ", cu_line)
$!
$!
$ cu_finish:
$ close cfile
$ if conf_user .eqs. ""
$ then
$    write sys$output "Warning, no User rule in configuration file"
$    conf_user = f$user()
$ endif
$ return
$!
$ missing_config_file:
$ cstatus = f$message($status)
$ write sys$output "Error opening apache_root:[conf]httpd.conf file: ", cstatus
$ return
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Parse P3 as comma-separated list of keyword=value pairs and set the
$! DCL symbols x_'keyword' to the accompanying value.
$!
$ get_p3_overrides:
$ ov_i = 0
$ next_ov_i:
$    ov_pair = f$element(ov_i,",",P3)
$    ov_i = ov_i + 1
$    if ov_pair .eqs. "," then return
$    ov_keyword = f$element(0,"=",ov_pair)
$    if f$type(x_'ov_keyword') .eqs. ""
$    then
$	write sys$output "Unrecognized override: ", ov_keyword
$	goto next_ov_i
$    endif
$    ov_value = f$element(1,"=",ov_pair)
$    if ov_value .nes. "=" 
$    then
$	if f$edit(ov_keyword,"UPCASE") .eqs. "OUTFILE" then -
		ov_value = f$parse(ov_value,x_outfile)
$	x_'ov_keyword' = ov_value
$    else
$	write sys$output "Syntax error in P3 override list: ", ov_keyword
$    endif
$    goto next_ov_i
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Display instructions for using this procdure.
$!
$ display_instructions:
$ type sys$input
$ deck
This apache_daemon procedure must be invoked with one of the following
as it's first parameter:

   STARTUP
   SHUTDOWN
   RESTART
   RUN

$ eod
$ return
