/*
 * Kill program
 */
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <descrip.h>
#include <jpidef.h>

#define HTTPD_IMAGE "]APACHE_HTTPD."
int LIB$GETJPI(), SYS$FILESCAN();

int main ( int argc, char **argv )
{
    FILE *pidfile;
    int pid, code, i, jpi_code, status, length;
    static char image_name[256];
    static $DESCRIPTOR(image_name_dx, image_name );
    /*
     * Validate arguments.
     */
    if ( argc < 3 ) {
	fprintf(stderr,"Usage: kill pidfile [shutdown|restart]\n");
	return 1;
    }
    code = 0;
    if ( strcmp(argv[2],"shutdown") == 0 ) code = SIGTERM;
    if ( strcmp(argv[2],"restart") == 0 ) code = SIGHUP;
    if ( code == 0 ) {
	fprintf(stderr,"invalid signal name: %s\n", argv[2] );
	return 20;
    }
    /*
     * Read pid file.
     */
    pidfile = fopen ( argv[1], "r" );
    if ( pidfile ) {
	pid = 0;
	fscanf ( pidfile, "%d", &pid );
	fclose ( pidfile );
	if ( pid == 0 ) {
	    fprintf(stderr,"Invalid pid (%x) read from file '%s'\n",
		pid, argv[1] );
	    return 20;
	}
    } else {
	fprintf(stderr,"Error opening pid file '%s'\n", argv[1] );
	return 20;
    }
    /*
     * Verify the pid is running apache_httpd.exe
     */
    jpi_code = JPI$_IMAGNAME;
    length = 0;
    image_name_dx.dsc$w_length--;	/* leave room for null */
    status = LIB$GETJPI ( &jpi_code, &pid, 0, 0, &image_name_dx, &length );
    if ( (status&1) == 0 ) {
	fprintf(stderr,"Error getting process info: %d\n", status );
	return status;
    }
    image_name[length] = '\0';
    for ( i = 0; i < length; i++ ) {
	image_name[i] = toupper(image_name[i]);
	if ( image_name[i] == '>' ) image_name[i] == ']';
    }
    if ( !strstr ( image_name, HTTPD_IMAGE )  ) {
	fprintf(stderr,"Process %x not killed, currently running '%s'\n",
		pid, image_name );
    }
    /*
     * Send signal to process.
     */
    status = kill ( pid, code );
    if ( status < 0 ) fprintf(stderr,
		"error killing process status: %d %d\n", errno, vaxc$errno );
    return 1;
}
