/*
 * Setup program for running scripts.  Functions as either
 * the process manager or as a worker.  The single command line argument
 * is an integer indicating the invocation number for this process
 * (1...) or 0 to indicate this process is to be the manager.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ssdef.h>
#include <descrip.h>
#include <lnmdef.h>

#include "mailbox_set.h"
#include "process_manager.h"

int LIB$SET_SYMBOL(), SYS$TRNLNM(), LIB$GET_SYMBOL(), LIB$SET_LOGICAL();
static char *sym_base[] = { "_OUT", "_IN", "_ERR", "_CMD", "_ENV", (char *) 0};
static int transfer_environment ( char **env );		/* fwd reference */

int main ( int argc, char **argv )
{
    int i, status, mode, length,start, j, table;
    long pid;
    char **env, *req_parm[5], *prefix;
    char command[512];
    static char symname[64];
    static $DESCRIPTOR(symname_dx,symname);
    static $DESCRIPTOR(symval_dx,"");

    mode = (argc > 1) ? atoi(argv[1]) : 0;
    if ( strlen(argv[0]) > sizeof(command)-12 ) return SS$_BADPARAM;
    sprintf ( command, "mcr %s 2", argv[0] );
    strcpy ( command, "@apache_script WORKER APE_" );
    prefix = (argc > 2) ? argv[2] : "APE_";

    if ( mode == 0 ) {
	/*
	 * We were started to be the manager process that launches
         * others.  vms_process_manager_main performs entire function,
	 * it should never return.
	 */
	status = vms_process_manager_main ( command );
	return status;
    }
    /*
     * A non-zero mode means we are an actual script process.
     */
    status = vms_initialize_process_manager ( 2, command, (char *) 0 );
    if ( (status&1) == 0 ) return status;
    /*
     * Wait for client to request something.
     */
#ifdef DEBUG
    printf("waiting for task request, mode: %d\n", mode );
#endif
    status = vms_get_task_request ( (mode == 1) ? 1 : 0, 60,
	req_parm, &env, &pid );
    if ( (status&1) == 0 ) return status;
    /*
     * Convert request arguments to symbols.
     */
    table = 1;			/* local table */
    for ( i = 0; i < 5; i++ ) {
	if ( !req_parm[i] ) continue;
	sprintf( symname, "%s%s", prefix, sym_base[i] );
	symname_dx.dsc$w_length = strlen ( symname );
	symval_dx.dsc$a_pointer = req_parm[i];
	symval_dx.dsc$w_length = strlen(req_parm[i]);
	status = LIB$SET_SYMBOL ( &symname_dx, &symval_dx, &table );
	if ( (status&1) == 0 ) {
	    fprintf(stderr,"Error creating DCL symbol %s: %d\n", symname,
		status );
	    return status;
	}
    }
    /*
     * Convert environment array to symbols.
     */
    status = transfer_environment ( env );
    return 1;
}
/***********************************************************************/
/*
 * Translate a logical name.
 */
static int translate_logical ( char *name, char *table, char *equiv,
	int equiv_size, int *length, int *attributes )
{
    int status, attr;
    static $DESCRIPTOR(name_dx,"");
    static $DESCRIPTOR(table_dx,"");
    struct { short length, code; char *buffer; int *retlen; } item[5];

    name_dx.dsc$a_pointer = name;
    name_dx.dsc$w_length = strlen(name_dx.dsc$a_pointer);
    table_dx.dsc$a_pointer = table;
    table_dx.dsc$w_length = strlen(table_dx.dsc$a_pointer);

    item[0].length = equiv_size-1; item[0].code = LNM$_STRING;
    item[0].buffer = equiv; item[0].retlen = length;
    *length = 0;		/* zero high byte */
    item[1].length = sizeof(attributes);
    item[1].code = LNM$_ATTRIBUTES;
    item[1].buffer = (char *) attributes;
    item[1].retlen = (int *) 0;
    item[2].length = item[2].code = 0;		/* end list */
    attr = LNM$M_CASE_BLIND;

    status = SYS$TRNLNM ( &attr, &table_dx, &name_dx, 0, item );
    if ( (status&1) == 1 ) equiv[*length] = '\0';
    return status;
}
/***********************************************************************/
/* Convert the enviroment array passed from the client into DCL symbols
 * and/or logical names.  If logical name APACHE_ENV exist in the
 * local process logical name directory, then logical names will be created.
 * If a DCL symbol APACHE_ENV exists, then DCL symbols are created in the
 * same table as APACHE_ENV the value of APACHE_ENV is used as a prefix
 * for each symbol created.
 *
 * Note that both a logical name table and DCL symbol exist then
 * both types of variables will be created.
 */
static int transfer_environment ( char **env )
{
    int channel, i, status, code, log_len, logchar, use_log_env, devchar;
    int use_sym_env, prefix_size, prefix_table, ndx;
    char log_name[256];
    static $DESCRIPTOR(name_dx,"");
    static $DESCRIPTOR(value_dx,"");
    static $DESCRIPTOR(table_dx,"APACHE_ENV");
    static char sym_prefix[256];
    static $DESCRIPTOR(sym_prefix_dx,sym_prefix);
    /*
     * determine style of environment variables: logical name or DCL or both
     */
    use_log_env = use_sym_env = 0;
    if ( 1&translate_logical(table_dx.dsc$a_pointer, "LNM$PROCESS_DIRECTORY",
	log_name, sizeof(log_name), &log_len, &logchar ) ) {
	/*
	 * Logical name apache_env exists, see if it is a table.
	 */
	if ( (logchar&LNM$M_TABLE) != 0 ) use_log_env = 1;
    }
    sym_prefix_dx.dsc$w_length = sizeof(sym_prefix)-1;
    prefix_size = prefix_table = 0;
    if ( 1&LIB$GET_SYMBOL( &table_dx, &sym_prefix_dx, &prefix_size,
	&prefix_table ) ) {
	use_sym_env = 1;
	sym_prefix[prefix_size] = '\0';
    }
    /*
     * Convert array.
     */
    for ( ndx = 0; env[ndx]; ndx++ ) {
	char *name, *value;
	/*
	 * Message contains definition for 1 or more environment vars.
	 */
	name = env[ndx];
	/*
	 * Parse the string as 'name=value'
	 */
	value = strchr ( name, '=' );
	if ( value ) {
	    /*
	     * Make string descriptors for name and value.
	     */
	    *value++ = '\0';
	    name_dx.dsc$a_pointer = name;
	    name_dx.dsc$w_length = strlen(name_dx.dsc$a_pointer);
	    value_dx.dsc$a_pointer = value;
	    value_dx.dsc$w_length = strlen(value_dx.dsc$a_pointer);
	    /*
	     * Set string or value as appropriate.
	     */
	    if ( use_log_env && *value ) {
		status = LIB$SET_LOGICAL ( &name_dx, &value_dx,
			&table_dx, 0, 0 );
	    }
	    if ( use_sym_env && 
			((prefix_size+name_dx.dsc$w_length) < 256) ) {
		/*
		 * Construct symbol name as prefix//name.
		 */
		sprintf ( &sym_prefix[prefix_size], "%s", name );
		name_dx.dsc$a_pointer = sym_prefix;
		name_dx.dsc$w_length += prefix_size;
		status = LIB$SET_SYMBOL ( &name_dx, &value_dx, &prefix_table );
	    }
	}
    }
    return 1;
}
