$! This procedure reads the src/configuration to determine which Apache
$! modules the installer wants built into the server file and then
$! builds a C source file, modules.c, with the appropriate references to
$! make those modules part of the executable image.
$!
$! The order that modules appear in the configuration affects the order
$! that apache will call the modules when handling a request (last
$! module named will be first module called).
$!
$! Use the symbols below to define alternate (VMS-specific) modules for
$! standard apache_modules.  The symbols must be defined in sequence
$! submod_1 .. submod_'n'.  Note that a single module may be named more
$! than once, in which case a single AddModule line is effectively
$! replaced by multiple AddModule lines.
$!
$ submod_1 = "modules/standard/mod_cgi.o=os/mod_osuscript.o"
$ submod_2 = "modules/standard/mod_cgi.o=os/mod_cgi_vms.o"
$!
$!!!!!!!!!!!!!!!
$!
$! Read configuration file and produce reference lists.  Symbol reference_'n'
$! is list of modules named by an AddModule rule, symbol preference_'n' is
$! is of modules named by either an AddModule or %Module rule.
$!
$ sv_verify = f$verify(0)
$ n = 0			! prelinked list, reference_{0..n-1}
$ m = 0			! preloaded list, pref_{0..m-1}
$ open/read conf_file [src]configuration.
$ next_conf_line:
$    read conf_file/end=conf_file_eof line
$    line = f$edit(line,"TRIM,COMPRESS")
$    if line .eqs. "" then goto next_conf_line
$    token = f$edit(f$element(0," ", line),"UPCASE")
$    if token .nes. "ADDMODULE" .and. token .nes. "%MODULE" then goto next_conf_line
$!
$    k = 0
$    initial_m = m
$    initial_mpath = f$element(1," ", line)
$ check_next_sub:
$    k = k + 1
$    if f$type(submod_'k') .eqs. "" 
$    then
$	if (m .ne. initial_m) then goto next_conf_line
$	module_path = initial_mpath
$    else
$	if initial_mpath .nes. f$element(0,"=",submod_'k') then goto check_next_sub
$	module_path = f$element(1,"=",submod_'k')
$	write sys$output "Substituting ", module_path, " for ", initial_mpath
$    endif
$!
$    gosub convert_module_path
$    if module_reference .nes. ""
$    then
$	if token .eqs. "ADDMODULE"
$	then
$	    reference_'n' = module_reference
$	    n = n + 1
$	endif
$	preference_'m' = module_reference
$	m = m + 1
$    endif
$    goto check_next_sub
$!
$ conf_file_eof:
$ close conf_file
$ if P1 .nes. "" then show symbol reference_*
$ write sys$output "Found ", n, " AddModule rules in configuration"
$!
$! Create prologue.
$!
$ cfile = "[src]modules.c"
$ create 'cfile'
/*
 * modules.c --- automatically generated by Apache
 * configuration script (config_modules.com).  DO NOT HAND EDIT!!!!!
 */

#include "httpd.h"
#include "http_config.h"

extern module CORE_MODULE;
$ open/append cf 'cfile'
$ i = 0
$ next_extern:
$    if i .ge. m then goto build_prelinked
$    write cf "extern module ", preference_'i', ";"
$    i = i + 1
$    goto next_extern
$!
$ build_prelinked:
$ write cf ""
$ write cf "/*
$ write cf " *  Modules which implicitly form the
$ write cf " *  list of activated modules on startup,
$ write cf " *  i.e. these are the modules which are
$ write cf " *  initially linked into the Apache processing
$ write cf " *  [extendable under run-time via AddModule]
$ write cf " */
$ write cf "module *ap_prelinked_modules[] = {
$ write cf "  &CORE_MODULE,
$ i = 0
$ next_prelink:
$    if i .ge. n then goto build_preloaded
$    write cf "  &", reference_'i', ","
$    i = i + 1
$    goto next_prelink
$!
$ build_preloaded:
$ write cf "  NULL
$ write cf "};
$ write cf "
$ write cf "/*
$ write cf " *  Modules which initially form the
$ write cf " *  list of available modules on startup,
$ write cf " *  i.e. these are the modules which are
$ write cf " *  initially loaded into the Apache process
$ write cf " *  [extendable under run-time via LoadModule]
$ write cf " */
$ write cf "module *ap_preloaded_modules[] = {
$ write cf "  &CORE_MODULE,
$ i = 0
$ next_preload:
$    if i .ge. m then goto preloaded_done
$    write cf "  &", preference_'i', ","
$    i = i + 1
$    goto next_preload
$ preloaded_done:
$ write cf "  NULL
$ write cf "};
$ close cf
$!
$ cleanup:
$ sv_verify = f$verify(sv_verify)
$ exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Convert an AddModule line from the [src]configure. file to a Module
$! name and a reference.   Parameters:
$!
$!    module_path	Object file path (unix .o filename), relative to [src].
$!
$! The symbol module_reference
$!
$! Parse the filename on the AddModule line to get the directory
$!
$ convert_module_path:
$ path_elems = 0
$ parse_path:
$    path_elem_'path_elems' = f$element(path_elems,"/",module_path)
$    if path_elem_'path_elems' .eqs. "/" then goto path_parsed
$    path_elems = path_elems + 1
$    goto parse_path
$ path_parsed:
$ delimiter = "."
$ i = 0
$ obj_dir = "[SRC"
$ if path_elem_0 .EQS. ""
$ then
$    i = 2			! not a relative path.
$    obj_dir = path_elem_1 + ":"
$    delimiter = "["
$ endif
$ build_dir:
$    if i .ge. (path_elems-1) then goto dir_built
$    obj_dir = obj_dir + delimiter + path_elem_'i'
$    lib_name = "LIB" + path_elem_'i' + ".OLB"
$    i = i + 1
$    delimiter = "."
$    goto build_dir
$ dir_built:
$ obj_dir = obj_dir + ".obj]"
$ module_name = f$parse(path_elem_'i',,,"NAME","SYNTAX_ONLY")
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Search library for external name.
$!
$ module_reference = ""		! result external reference name
$ on warning then goto abort_convert
$ library /list=config_modules.tmp 'obj_dir''lib_name'/name/only='module_name'
$ on control_y then goto lf_eof
$ on error then goto lf_eof
$ open lf/read config_modules.tmp
$ state = 0
$ next_lf_line:
$     read lf/end=lf_eof line
$!!     write sys$output line
$     line = f$edit(line,"TRIM")
$     if state .eq. 0
$     then
$	! look for start of module description
$	if ( f$extract(0,7,line) .eqs. "Module " ) then state = 1
$     else
$	! Look for _MODULE, or default to first line
$	if line .eqs. "" then goto lf_eof
$	if state .eq. 1 then module_reference = line
$	state = 2
$	if f$extract(f$length(line)-7,7,line) .eqs. "_MODULE" then -
		module_reference = line
$     endif
$     goto next_lf_line
$ lf_eof:
$ close lf
$ abort_convert:
$ set control_y
$ set on
$ delete config_modules.tmp;
$ return
