!
! Description file for building Apache on VMS
!
! Shorthand targets:
!	all		httpd,script,htpasswd
!	httpd		apache_httd.exe_alpha
!	script		apache_script_control.exe
!	htpasswd	htpasswd.exe
!	build		build_apache_httpd.com
!
.ifdef arch
.else
arch = _alpha
.endif
.ifdef notrace
traceback = /notraceback
.else
traceback = /traceback
.endif

rootdir = [000000]
! macros for directories containing source files, ends in 'dir'
incdir = [src.include]
osdir = [src.os.openvms]
proxydir = [src.modules.proxy]
regexdir = [src.regex]
srcdir = [src]
apdir = [src.ap]
maindir = [src.main]
standarddir = [src.modules.standard]
supportdir = [src.support]

! macros for directories containing object files, ends in 'diro'
osdiro = [src.os.obj]
proxydiro = [src.modules.proxy.obj]
regexdiro = [src.regex.obj]
srcdiro = [src.obj]
apdiro = [src.ap.obj]
maindiro = [src.main.obj]
standarddiro = [src.modules.standard.obj]
supportdiro = [src.support.obj]

! macros for object library filenames end in 'lib'
oslib = [src.os.obj]libos
regexlib = [src.regex.obj]libregex
mainlib = [src.main.obj]libmain
aplib = [src.ap.obj]libap
standardlib = [src.modules.standard.obj]libstandard
proxylib = [src.modules.proxy.obj]libproxy
!
! Ensure libraries exist.
!
.FIRST
    @ if f$search("$(oslib).olb") .eqs. "" then library/create $(oslib).olb
    @ if f$search("$(regexlib).olb") .eqs. "" then library/create $(regexlib).olb
    @ if f$search("$(mainlib).olb") .eqs. "" then library/create $(mainlib).olb
    @ if f$search("$(aplib).olb") .eqs. "" then library/create $(aplib).olb
    @ if f$search("$(standardlib).olb") .eqs. "" then library/create $(standardlib).olb
    @ if f$search("$(proxylib).olb") .eqs. "" then library/create $(proxylib).olb
!
! Main executables.
!
ALL : httpd script htpasswd kill $(rootdir)apache_daemon.com \
	$(rootdir)apache_privileged.exe$(arch) \
	$(rootdir)apache_script.com [conf]httpd.conf [conf]access.conf
   @ write sys$output "all built"

[conf]httpd.conf : [conf]httpd.conf-dist $(osdir)config_httpd.com
   @config_httpd.com

[conf]access.conf : [conf]access.conf-dist
   copy [conf]access.conf-dist [conf]access.conf

$(rootdir)apache_daemon.com : $(osdir)apache_daemon.com
   copy $(osdir)apache_daemon.com $(rootdir)

$(rootdir)apache_script.com : $(osdir)apache_script.com
   copy $(osdir)apache_script.com $(rootdir)

$(rootdir)apache_httpd.exe$(arch),httpd : $(srcdiro)modules.obj \
	$(srcdiro)buildmark.obj os_library regex_library proxy_library \
	main_library ap_library	standard_library
    link $(LINKFLAGS) /exe=$(rootdir)apache_httpd.exe$(arch) -
	/map=[lis]apache_httpd.map/full $(traceback) -
	$(mainlib)/include=http_main/library,-
	$(aplib)/library,$(regexlib)/library,-
	$(srcdiro)buildmark.obj,modules.obj,-
	$(standardlib)/library,$(proxylib)/library,$(oslib)/library

$(srcdir)htpasswd.exe$(arch),htpasswd : $(supportdiro)htpasswd.obj \
	os_library ap_library
    link $(LINKFLAGS) /exe=$(srcdir)htpasswd.exe$(arch) $(traceback) -
	 $(supportdiro)htpasswd.obj,$(oslib)/library,$(aplib)/library

$(supportdiro)htpasswd.obj : $(supportdir)htpasswd.c $(incdir)ap_config.h \
	$(incdir)ap.h $(incdir)ap_md5.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(srcdiro)modules.obj : $(srcdir)modules.c
	cc $(CFLAGS) $(srcdir)modules.c

$(srcdir)modules.c : $(srcdir)configuration.\
	$(incdir)httpd.h $(incdir)http_config.h config_modules.com \
	$(standardlib).olb $(oslib).olb
	@config_modules.com

$(srcdiro)buildmark.obj : $(srcdir)buildmark.c
	cc $(CFLAGS) $(MMS$SOURCE)


build_apache_httpd.com,build : descrip.mms
   @ mms all/from_sources/noaction/out=build_apache_httpd.com

$(rootdir)apache_script_control.exe$(arch),script : \
	$(osdiro)apache_script_control.obj $(oslib)(process_manager,mailbox_set)
   link /exe=$(rootdir)apache_script_control.exe$(arch) \
	$(osdiro)apache_script_control.obj,$(oslib)/library

$(rootdir)apache_kill.exe$(arch),kill : $(osdiro)apache_kill.obj
   link /exe=$(rootdir)apache_kill.exe$(arch) $(osdiro)apache_kill.obj

$(osdiro)apache_kill.obj : $(osdir)apache_kill.c
   cc $(CFLAGS) $(osdir)apache_kill.c

$(rootdir)apache_privileged.exe$(arch),plv : $(osdiro)apache_privileged.obj \
	$(osdir)link_apache_privileged.com $(osdir)apache_privileged.opt
    @$(osdir)link_apache_privileged $(MMS$SOURCE) $(rootdir).exe$(arch)

$(osdiro)apache_privileged.obj : $(osdir)apache_privileged.c
    cc $(CFLAGS) $(MMS$SOURCE)+SYS$LIBRARY:SYS$LIB_C.TLB/LIBRARY

!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! os library contains OS-dependant code.
!
$(oslib).olb,os_library : $(oslib)(process_manager,mailbox_set,crypt,os,os-inline,\
	mod_cgi_vms,mod_osuscript,decnet_io)
    @ write sys$output "$(MMS$TARGET) library up to date."

$(oslib)(process_manager) : $(osdiro)process_manager.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(oslib)(mailbox_set) : $(osdiro)mailbox_set.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(oslib)(crypt) : $(osdiro)crypt.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(oslib)(os) : $(osdiro)os.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(oslib)(os-inline) : $(osdiro)os-inline.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(osdiro)process_manager.obj : $(osdir)process_manager.c process_manager.h \
	mailbox_set.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(osdiro)apache_script_control.obj : $(osdir)apache_script_control.c \
	process_manager.h mailbox_set.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(osdiro)mailbox_set.obj : $(osdir)mailbox_set.c mailbox_set.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(osdiro)crypto.obj : $(osdir)crypt.c
    cc $(CFLAGS) $(MMS$SOURCE)

$(osdiro)os.obj : os.c $(incdir)ap_config.h $(osdir)os.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(osdiro)os-inline.obj : $(osdir)os-inline.c $(incdir)ap_config.h
    cc $(CFLAGS) $(MMS$SOURCE)
!
! Global include files.
!
$(incdir)ap_config.h : $(incdir)ap_mmn.h,$(incdir)ap_config_auto.h\
	$(osdir)os.h $(incdir)ap_ctype.h $(incdir)hsregex.h
    set file/extend=0 $(incdir)ap_config.h	! 'touch' the file.

$(incdir)ap_config_auto.h : $(osdir)config_auto.com sys$library:decc$rtldef.tlb
    @config_auto.com

$(incdir)httpd.h : $(incdir)ap_config.h $(incdir)alloc.h $(incdir)buff.h\
	$(incdir)ap.h $(incdir)util_uri.h
    set file/extend=0 $(incdir)httpd.h

!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! regular expressions.
!
$(regexlib).olb,regex_library : $(regexlib)(regcomp,regexec,regfree,regerror)
    @ write sys$output "$(MMS$TARGET) library up to date."

$(regexlib)(regcomp) : $(regexdiro)regcomp.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(regexlib)(regexec) : $(regexdiro)regexec.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(regexlib)(regfree) : $(regexdiro)regfree.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(regexlib)(regerror) : $(regexdiro)regerror.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(regexdiro)regcomp.obj : $(regexdir)regcomp.c $(incdir)ap_ctype.h $(incdir)hsregex.h \
	$(regexdir)utils.h $(regexdir)regex2.h $(regexdir)cclass.h \
	$(regexdir)cname.h $(regexdir)regcomp.ih 
    cc $(CFLAGS) $(regexdir)regcomp.c

$(regexdiro)regexec.obj : $(regexdir)regexec.c $(incdir)hsregex.h $(incdir)ap_ctype.h \
	$(regexdir)utils.h $(regexdir)regex2.h $(regexdir)engine.c \
	$(regexdir)engine.ih
    cc $(CFLAGS) $(regexdir)regexec.c

$(regexdiro)regfree.obj : $(regexdir)regfree.c $(incdir)hsregex.h $(regexdir)utils.h \
	$(regexdir)regex2.h
    cc $(CFLAGS) $(regexdir)regfree.c

$(regexdiro)regerror.obj : $(regexdir)regerror.c $(incdir)hsregex.h $(regexdir)utils.h \
	$(regexdir)regerror.ih
    cc $(CFLAGS) $(regexdir)regerror.c
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
$(proxylib).olb,proxy_library : $(proxylib)(mod_proxy,proxy_cache,\
	proxy_connect,proxy_ftp,proxy_http,proxy_util)
    @ write sys$output "$(MMS$TARGET) library up to date."

$(proxylib)(mod_proxy) : $(proxydiro)mod_proxy.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(proxylib)(proxy_cache) : $(proxydiro)proxy_cache.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(proxylib)(proxy_connect) : $(proxydiro)proxy_connect.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(proxylib)(proxy_ftp) : $(proxydiro)proxy_ftp.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(proxylib)(proxy_http) : $(proxydiro)proxy_http.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(proxylib)(proxy_util) : $(proxydiro)proxy_util.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(proxydir)mod_proxy.h : $(incdir)httpd.h $(incdir)http_config.h\
	$(incdir)http_config.h $(incdir)http_protocol.h $(incdir)explain.h
    set file/extend=0 $(proxydir)mod_proxy.h

$(proxydiro)mod_proxy.obj : $(proxydir)mod_proxy.c $(proxydir)mod_proxy.h \
	$(incdir)http_log.h $(incdir)http_vhost.h $(incdir)http_request.h
    cc $(CFLAGS) $(proxydir)mod_proxy.c

$(proxydiro)proxy_cache.obj : $(proxydir)proxy_cache.c $(proxydir)mod_proxy.h\
	$(incdir)http_conf_globals.h $(incdir)http_log.h $(incdir)http_main.h\
	$(incdir)util_date.h $(incdir)multithread.h $(incdir)ap_md5.h
    cc $(CFLAGS) $(proxydir)proxy_cache.c

$(proxydiro)proxy_connect.obj : $(proxydir)proxy_connect.c $(proxydir)mod_proxy.h\
	$(incdir)http_log.h $(incdir)http_main.h
    cc $(CFLAGS) $(proxydir)proxy_connect.c

$(proxydiro)proxy_ftp.obj : $(proxydir)proxy_ftp.c $(proxydir)mod_proxy.h\
	$(incdir)http_log.h $(incdir)http_main.h
    cc $(CFLAGS) $(proxydir)proxy_ftp.c

$(proxydiro)proxy_http.obj : $(proxydir)proxy_http.c $(proxydir)mod_proxy.h\
	$(incdir)http_log.h $(incdir)http_main.h $(incdir)http_core.h\
	$(incdir)util_date.h
    cc $(CFLAGS) $(proxydir)proxy_http.c

$(proxydiro)proxy_util.obj : $(proxydir)proxy_util.c $(proxydir)mod_proxy.h\
	$(incdir)http_log.h $(incdir)http_main.h $(incdir)ap_md5.h\
	$(incdir)multithread.h $(incdir)util_uri.h $(incdir)util_date.h
    cc $(CFLAGS) $(proxydir)proxy_util.c
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
$(standardlib).olb,standard_library : $(standardlib)(mod_access,mod_actions,\
	mod_alias,mod_asis,mod_auth,mod_auth_anon,mod_autoindex,mod_cern_meta,\
	mod_digest,mod_dir,mod_env,mod_expires,mod_headers,mod_imap,\
	mod_include,mod_info,mod_log_agent,mod_log_config,mod_log_referer,\
	mod_mime,mod_mime_magic,mod_negotiation,mod_rewrite,mod_setenvif,\
	mod_so,mod_speling,mod_status,mod_unique_id,mod_userdir,mod_usertrack)
    @ write sys$output "$(MMS$TARGET) library up to date."

$(oslib)(mod_osuscript) : $(osdiro)mod_osuscript.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(oslib)(decnet_io) : $(osdiro)decnet_io.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_access) : $(standarddiro)mod_access.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_actions) : $(standarddiro)mod_actions.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_alias) : $(standarddiro)mod_alias.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_asis) : $(standarddiro)mod_asis.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_auth) : $(standarddiro)mod_auth.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_auth_anon) : $(standarddiro)mod_auth_anon.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_autoindex) : $(standarddiro)mod_autoindex.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_cern_meta) : $(standarddiro)mod_cern_meta.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(oslib)(mod_cgi_vms) : $(osdiro)mod_cgi_vms.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_digest) : $(standarddiro)mod_digest.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_dir) : $(standarddiro)mod_dir.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_env) : $(standarddiro)mod_env.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_expires) : $(standarddiro)mod_expires.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_headers) : $(standarddiro)mod_headers.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_image) : $(standarddiro)mod_imap.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_include) : $(standarddiro)mod_include.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_info) : $(standarddiro)mod_info.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_log_agent) : $(standarddiro)mod_log_agent.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_log_config) : $(standarddiro)mod_log_config.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_log_referer) : $(standarddiro)mod_log_referer.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_mime) : $(standarddiro)mod_mime.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_mime_magic) : $(standarddiro)mod_mime_magic.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_negotiation) : $(standarddiro)mod_negotiation.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_rewrite) : $(standarddiro)mod_rewrite.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_setenvif) : $(standarddiro)mod_setenvif.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_so) : $(standarddiro)mod_so.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_speling) : $(standarddiro)mod_speling.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_status) : $(standarddiro)mod_status.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_unique_id) : $(standarddiro)mod_unique_id.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_userdir) : $(standarddiro)mod_userdir.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(standardlib)(mod_usertrack) : $(standarddiro)mod_usertrack.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(osdiro)mod_osuscript.obj : $(osdir)mod_osuscript.c $(osdir)decnet_io.h \
	$(incdir)httpd.h $(incdir)http_config.h $(incdir)http_core.h \
	$(incdir)http_log.h $(incdir)http_main.h $(incdir)http_protocol.h \
	$(incdir)util_script.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(osdiro)decnet_io.obj : $(osdir)decnet_io.c $(osdir)decnet_io.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_access.obj : $(standarddir)mod_access.c $(incdir)httpd.h\
	$(incdir)http_core.h $(incdir)http_config.h $(incdir)http_log.h\
	$(incdir)http_request.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_actions.obj : $(standarddir)mod_actions.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_request.h $(incdir)http_core.h\
	$(incdir)http_protocol.h $(incdir)http_main.h $(incdir)http_log.h\
	$(incdir)util_script.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_alias.obj : $(standarddir)mod_alias.c $(incdir)httpd.h\
	$(incdir)http_config.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_asis.obj : $(standarddir)mod_asis.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_protocol.h $(incdir)http_log.h\
	$(incdir)util_script.h $(incdir)http_main.h $(incdir)http_request.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_auth.obj : $(standarddir)mod_auth.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_protocol.h $(incdir)ap_md5.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_auth_anon.obj : $(standarddir)mod_auth_anon.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_protocol.h $(incdir)http_request.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_autoindex.obj : $(standarddir)mod_autoindex.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_protocol.h $(incdir)http_request.h\
	$(incdir)http_main.h $(incdir)util_script.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_cern_meta.obj : $(standarddir)mod_cern_meta.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)util_script.h $(incdir)http_log.h\
	$(incdir)http_request.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(osdiro)mod_cgi_vms.obj : $(osdir)mod_cgi_vms.c $(incdir)httpd.h\
	$(osdir)process_manager.h $(osdir)mailbox_set.h \
	$(incdir)http_config.h $(incdir)http_request.h\
	$(incdir)http_core.h $(incdir)http_protocol.h $(incdir)http_main.h\
	$(incdir)http_main.h $(incdir)http_log.h $(incdir)util_script.h\
	$(incdir)http_conf_globals.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_digest.obj : $(standarddir)mod_digest.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_protocol.h $(incdir)util_md5.h $(incdir)ap_md5.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_dir.obj : $(standarddir)mod_dir.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_request.h\
	$(incdir)http_protocol.h $(incdir)http_log.h $(incdir)http_main.h\
	$(incdir)util_script.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_env.obj : $(standarddir)mod_env.c $(incdir)httpd.h\
	$(incdir)http_config.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_expires.obj : $(standarddir)mod_expires.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_headers.obj : $(standarddir)mod_headers.c $(incdir)httpd.h\
	$(incdir)http_config.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_imap.obj : $(standarddir)mod_imap.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_request.h $(incdir)http_core.h\
	$(incdir)http_protocol.h $(incdir)http_main.h $(incdir)http_log.h\
	$(incdir)util_script.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_include.obj : $(standarddir)mod_include.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_request.h  $(incdir)http_core.h\
	 $(incdir)http_protocol.h $(incdir)http_log.h $(incdir)http_main.h\
	 $(incdir)util_script.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_info.obj : $(standarddir)mod_info.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	 $(incdir)http_main.h $(incdir)http_protocol.h $(incdir)util_script.h\
	 $(incdir)http_conf_globals.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_log_agent.obj : $(standarddir)mod_log_agent.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_log_config.obj : $(standarddir)mod_log_config.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_log_referer.obj : $(standarddir)mod_log_referer.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_mime.obj : $(standarddir)mod_mime.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_mime_magic.obj : $(standarddir)mod_mime_magic.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_request.h $(incdir)http_core.h\
	$(incdir)http_log.h $(incdir)http_protocol.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_negotation.obj : $(standarddir)mod_negotiation.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_request.h $(incdir)http_core.h\
	$(incdir)http_protocol.h $(incdir)http_log.h $(incdir)util_script.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_rewrite.obj : $(standarddir)mod_rewrite.c $(incdir)httpd.h\
	$(standarddir)mod_rewrite.h $(incdir)http_config.h\
	$(incdir)http_request.h	$(incdir)http_conf_globals.h\
	$(incdir)http_core.h $(incdir)http_log.h $(incdir)http_vhost.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_setenvif.obj : $(standarddir)mod_setenvif.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_so.obj : $(standarddir)mod_so.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_speling.obj : $(standarddir)mod_speling.c $(incdir)httpd.h\
	$(incdir)http_core.h $(incdir)http_config.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_status.obj : $(standarddir)mod_status.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_main.h\
	$(incdir)http_protocol.h $(incdir)http_conf_globals.h\
	$(incdir)util_script.h $(incdir)scoreboard.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_unique_id.obj : $(standarddir)mod_unique_id.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_log.h $(incdir)multithread.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_userdir.obj : $(standarddir)mod_userdir.c $(incdir)httpd.h\
	$(incdir)http_config.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(standarddiro)mod_usertrack.obj : $(standarddir)mod_usertrack.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h
    cc $(CFLAGS) $(MMS$SOURCE)

!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
$(aplib).olb,ap_library : $(aplib)(ap_cpystrn,ap_execve,ap_fnmatch,ap_md5c\
	,ap_signal,ap_slack,ap_snprintf,ap_base64,ap_checkpass,ap_sha1,\
	ap_getpass)
    @ write sys$output "$(MMS$TARGET) library up to date."

$(aplib)(ap_cpystrn) : $(apdiro)ap_cpystrn.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_execve) : $(apdiro)ap_execve.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_fnmatch) : $(apdiro)ap_fnmatch.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_md5c) : $(apdiro)ap_md5c.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_sha1) : $(apdiro)ap_sha1.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_getpass) : $(apdiro)ap_getpass.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_checkpass) : $(apdiro)ap_checkpass.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_signal) : $(apdiro)ap_signal.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_slack) : $(apdiro)ap_slack.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_snprintf) : $(apdiro)ap_snprintf.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(aplib)(ap_base64) : $(apdiro)ap_base64.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(apdiro)ap_cpystrn.obj : $(apdir)ap_cpystrn.c $(incdir)httpd.h
    cc $(CFLAGS) $(apdir)ap_cpystrn.c

$(apdiro)ap_execve.obj : $(apdir)ap_execve.c $(incdir)httpd.h
    cc $(CFLAGS) $(apdir)ap_execve.c

$(apdiro)ap_fnmatch.obj : $(apdir)ap_fnmatch.c $(incdir)fnmatch.h $(incdir)ap_config.h
    cc $(CFLAGS) $(apdir)ap_fnmatch.c

$(apdiro)ap_md5c.obj : $(apdir)ap_md5c.c $(incdir)ap_config.h $(incdir)ap_md5.h\
	$(incdir)ap.h
    cc $(CFLAGS) $(apdir)ap_md5c.c

$(apdiro)ap_sha1.obj : $(apdir)ap_sha1.c $(incdir)ap_config.h \
	$(incdir)ap_sha1.h $(incdir)ap.h
    cc $(CFLAGS) $(apdir)ap_sha1.c

$(apdiro)ap_getpass.obj : $(apdir)ap_getpass.c $(incdir)ap_config.h \
	$(incdir)ap.h
    cc $(CFLAGS) $(apdir)ap_getpass.c

$(apdiro)ap_checkpass.obj : $(apdir)ap_checkpass.c $(incdir)ap_config.h \
	$(incdir)ap_md5.h $(incdir)ap_sha1.h $(incdir)ap.h
    cc $(CFLAGS) $(apdir)ap_checkpass.c

$(apdiro)ap_signal.obj : $(apdir)ap_signal.c $(incdir)httpd.h
    cc $(CFLAGS) $(apdir)ap_signal.c

$(apdiro)ap_slack.obj : $(apdir)ap_slack.c $(incdir)httpd.h $(incdir)http_log.h
    cc $(CFLAGS) $(apdir)ap_slack.c

$(apdiro)ap_snprintf.obj : $(apdir)ap_snprintf.c $(incdir)httpd.h
    cc $(CFLAGS) $(apdir)ap_snprintf.c

$(apdiro)ap_base64.obj : $(apdir)ap_base64.c $(incdir)ap_config.h\
	$(incdir)ap.h
    cc $(CFLAGS) $(apdir)ap_base64.c

!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
$(mainlib).olb,main_library : $(mainlib)(alloc,buff,http_config,http_core,\
	http_log,http_main,http_protocol,http_request,http_vhost,rfc1413,util,\
	util_date,util_md5,util_script,util_uri)
    @ write sys$output "$(MMS$TARGET) library up to date."

$(mainlib)(alloc) : $(maindiro)alloc.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(buff) : $(maindiro)buff.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(http_config) : $(maindiro)http_config.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(http_core) : $(maindiro)http_core.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(http_log) : $(maindiro)http_log.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(http_main) : $(maindiro)http_main.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(http_protocol) : $(maindiro)http_protocol.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(http_request) : $(maindiro)http_request.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(http_vhost) : $(maindiro)http_vhost.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(rfc1413) : $(maindiro)rfc1413.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(util) : $(maindiro)util.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(util_date) : $(maindiro)util_date.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(util_md5) : $(maindiro)util_md5.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(util_script) : $(maindiro)util_script.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(mainlib)(util_uri) : $(maindiro)util_uri.obj
    library/replace $(MMS$TARGET) $(MMS$SOURCE)

$(maindiro)alloc.obj : $(maindir)alloc.c $(incdir)httpd.h\
	$(incdir)multithread.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)buff.obj : $(maindir)buff.c $(incdir)httpd.h\
	$(incdir)http_main.h $(incdir)http_log.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)http_config.obj : $(maindir)http_config.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_request.h $(incdir)http_conf_globals.h\
	$(incdir)http_vhost.h $(incdir)explain.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)http_core.obj : $(maindir)http_core.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_protocol.h $(incdir)http_request.h $(incdir)rfc1413.h\
	$(incdir)http_conf_globals.h $(incdir)http_vhost.h \
	$(incdir)http_main.h $(incdir)util_md5.h $(incdir)ap_md5.h\
	$(incdir)scoreboard.h $(incdir)fnmatch.h $(incdir)ap_config.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)http_log.obj : $(maindir)http_log.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_main.h $(incdir)http_conf_globals.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)http_main.obj : $(maindir)http_main.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_request.h $(incdir)http_conf_globals.h\
	$(incdir)http_vhost.h $(incdir)explain.h $(incdir)http_main.h\
	$(incdir)util_script.h $(incdir)scoreboard.h $(incdir)multithread.h\
	$(incdir)util_uri.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)http_protocol.obj : $(maindir)http_protocol.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_request.h $(incdir)http_conf_globals.h\
	$(incdir)http_vhost.h $(incdir)http_protocol.h $(incdir)http_main.h\
	$(incdir)util_date.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)http_request.obj : $(maindir)http_request.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_core.h $(incdir)http_log.h\
	$(incdir)http_request.h $(incdir)http_conf_globals.h\
	$(incdir)http_vhost.h $(incdir)http_main.h $(incdir)scoreboard.h\
	$(incdir)http_protocol.h $(incdir)fnmatch.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)http_vhost.obj : $(maindir)http_vhost.c $(incdir)httpd.h\
	$(incdir)http_config.h $(incdir)http_log.h\
	$(incdir)http_protocol.h $(incdir)http_conf_globals.h\
	$(incdir)http_vhost.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)rfc1413.obj : $(maindir)rfc1413.c $(incdir)httpd.h\
	$(incdir)http_log.h $(incdir)rfc1413.h $(incdir)http_main.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)util.obj : $(maindir)util.c $(incdir)httpd.h\
	$(incdir)http_log.h $(incdir)http_conf_globals.h $(maindir)test_char.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)util_date.obj : $(maindir)util_date.c $(incdir)httpd.h\
	$(incdir)util_date.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)util_md5.obj : $(maindir)util_md5.c $(incdir)httpd.h\
	$(incdir)util_md5.h $(incdir)ap_md5.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)util_script.obj : $(maindir)util_script.c $(incdir)httpd.h\
	$(incdir)http_log.h $(incdir)http_conf_globals.h $(incdir)util_uri.h\
	$(incdir)uri_delims.h $(incdir)http_config.h $(incdir)http_core.h\
	$(incdir)http_protocol.h $(incdir)http_request.h \
	$(incdir)util_script.h $(incdir)util_date.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(maindiro)util_uri.obj : $(maindir)util_uri.c $(incdir)httpd.h\
	$(incdir)http_log.h $(incdir)http_conf_globals.h $(incdir)util_uri.h\
	$(incdir)uri_delims.h
    cc $(CFLAGS) $(MMS$SOURCE)

!
! Can use gen_test_char unchanged if we redirect sys$output
$(maindir)test_char.h : $(maindir)gen_test_char.exe
    define/user sys$output $(MMS$TARGET)
    mcr $(maindir)gen_test_char $(MMS$TARGET)

$(maindir)gen_test_char.exe : $(maindiro)gen_test_char.obj
    link $(LINKFLAGS) $(MMS$SOURCE)/exe=$(MMS$TARGET)

$(maindiro)gen_test_char.obj : $(maindir)gen_test_char.c $(incdir)httpd.h
    cc $(CFLAGS) $(MMS$SOURCE)

$(incdir)uri_delims.h : $(maindir)gen_uri_delims.exe
    define/user sys$output $(MMS$TARGET)
    mcr $(maindir)gen_uri_delims $(MMS$TARGET)

$(maindir)gen_uri_delims.exe : $(maindiro)gen_uri_delims.obj
    link $(LINKFLAGS) $(MMS$SOURCE)/exe=$(MMS$TARGET)

$(maindiro)gen_uri_delims.obj : $(maindir)gen_uri_delims.c
    cc $(CFLAGS) $(MMS$SOURCE)
