/*
 * Define data structures and function prototypes for managing
 * related groups of mailboxes.
 */
#ifndef VMS_MAILBOX_SET_H
#define VMS_MAILBOX_SET_H 1

typedef struct {
    unsigned short chan;		/* VMS channel */
    unsigned short maxmsg;		/* max message size or zero */
    int unit;				/* Unit number of mailbox (MBAnnn) */
    int fd;				/* C RTL file descriptor or -1 */
    int check;				/* check if true */
    char *fname;			/* Override filename (maxmsg==0) */
    int buflen;				/* Chars last read. */
    int bufpos;				/* current position */
    char *buffer;
} vms_mailbox;

typedef struct vms_async_in_st {
    struct vms_async_in_st *next;
    int status;				/* I/O status for message (EOF,nowriter) */
    int length;				/* message length, -1 for Error (EOF) */
    char data[1];			/* variable allocation */
} vms_async_buf;

typedef struct {
    long task;				/* PID of associated task process */
    vms_mailbox in;			/* Open for read */
    vms_mailbox out;			/* open for write */
    vms_mailbox err;			/* open for read */
    /*
     * following fields are used by AST thread that reads error mailbox.
     */
    int async_err_active;
    struct {
	unsigned short status, count;
	long sender_pid;
    } err_iosb;				/* IOSB for the current async read */
    vms_async_buf *first, *last;	/* aways reading into last buffer */
} vms_mailbox_set;
/*
 * The create_mailbox_set function creates mailboxes and initializes
 * the mailbox_set structure passed to it.  No mailbox will be created
 * if the corresponding message size is zero.  Destroy function only
 * deassigns channels and frees buffers, it does not close open FDs.
 */
int vms_create_mailbox ( int max_msg, int quota, int flags,
	vms_mailbox *mbx );
int vms_create_mailbox_set ( int in_maxmsg, int in_quota, 
	int out_maxmsg, int out_quota, int err_maxmsg, vms_mailbox_set *set );
int vms_destroy_mailbox_set ( vms_mailbox_set *set );
/*
 * Return file descriptor.
 */
int vms_open_mailbox ( vms_mailbox *mbx, int flags );
/*
 * The vms_mailbox_gets function follows the ap_bgets interface, which
 * works more-or-less like fgets except the number of bytes read is the 
 * return value (zero for EOF).  vms_err_mailbox_gets functions the same
 * except uses the err mailbox in the mailbox set.
 */
int vms_mailbox_gets ( char *buf, int bufsize, vms_mailbox *mbx );
int vms_err_mailbox_gets ( char *buf, int bufsize, vms_mailbox_set *set );
int vms_mailbox_buffer ( vms_mailbox *mbx, char **buf, int *buflen );

#endif
