/* ====================================================================
 * Copyright (c) 1998-1999 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group and was originally based
 * on public domain software written at the National Center for
 * Supercomputing Applications, University of Illinois, Urbana-Champaign.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */

#ifndef APACHE_OS_H
#define APACHE_OS_H

#include "ap_config.h"

#define PLATFORM "OpenVMS"

/*
 * This file in included in all Apache source code. It contains definitions
 * of facilities available on _this_ operating system (HAVE_* macros),
 * and prototypes of OS specific functions defined in os.c or os-inline.c
 */

#if !defined(INLINE) && defined(USE_GNU_INLINE)
/* Compiler supports inline, so include the inlineable functions as
 * part of the header
 */
#define INLINE extern ap_inline

INLINE int ap_os_is_path_absolute(const char *file);

#include "os-inline.c"

#else

/* Compiler does not support inline, so prototype the inlineable functions
 * as normal
 */
extern int ap_os_is_path_absolute(const char *file);
#endif

int ap_os_kill(int pid, int sig);

/* Other ap_os_ routines not used by this platform */

#define ap_os_is_filename_valid(f)          (1)

/*
 *  Abstraction layer for loading
 *  Apache modules under run-time via 
 *  dynamic shared object (DSO) mechanism
 */

#ifdef HAVE_DL_H
#include <dl.h>
#endif

/*
 * Do not use native AIX DSO support
 */
#ifdef AIX
#undef HAVE_DLFCN_H
#endif

#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#else
void *dlopen(const char *, int);
int dlclose(void *);
void *dlsym(void *, const char *);
const char *dlerror(void);
#endif

/* probably on an older system that doesn't support RTLD_NOW or RTLD_LAZY.
 * The below define is a lie since we are really doing RTLD_LAZY since the
 * system doesn't support RTLD_NOW.
 */
#ifndef RTLD_NOW
#define RTLD_NOW 1
#endif

#ifndef RTLD_GLOBAL
#define RTLD_GLOBAL 0
#endif

#if (defined(__FreeBSD__) ||\
     defined(__OpenBSD__) ||\
     defined(__NetBSD__)     ) && !defined(__ELF__)
#define DLSYM_NEEDS_UNDERSCORE
#endif

#define     ap_os_dso_handle_t  void *
void        ap_os_dso_init(void);
void *      ap_os_dso_load(const char *);
void        ap_os_dso_unload(void *);
void *      ap_os_dso_sym(void *, const char *);
const char *ap_os_dso_error(void);
#ifdef VMS
/*
 * Extensions to work around problems with installing apache_httpd with
 * privileges.  Instead, we isolate the operations requiring privilege
 * and use a user-written system service to provide those functions.
 */
int vms_bind_privileged_socket ( int s, const void *addr, int size );
void *vms_getpwnam ( const char *username );
/*
 * Extensions for VMS to get around problems with lack of fork().
 */
#define SHARED_SOCKET_MAX_TAG 64
struct vms_shared_socket {
    struct vms_shared_socket *next;	/* pointer to build list */
    char tag[SHARED_SOCKET_MAX_TAG];	/* VMS device */
    int fd;				/* file (socket) descriptor */
    int namelen;
    void *name;				/* socket name, opaque */
};
int vms_create_shared_socket ( int af, int type, int protocol, int port );
int vms_export_shared_sockets ( char *log_name );
int vms_import_shared_socket ( char *log_name, struct vms_shared_socket **list );
int vms_create_child ( char *command, long *pid );
int vms_close_busy_socket ( int sd );

#ifdef waitpid
#undefine waitpid
#endif
#define waitpid vms_wait_for_child_exit
int vms_wait_for_child_exit ( int pid, int *estatus, int flags );
/*
 * Create group global section to work as scoreboard.  Name is 
 * ap_sb_xxxxxxxx where xxxxxxxx is PID of master process.
 */
void *vms_create_scoreboard ( size_t size, int is_master );
/*
 * Define function to convert in place mixed filesystem syntax to
 * unix syntax, i.e. disk:[dir1]/dir2/fname --> /disk/dir1/dir2/fname.
 * This situation arises in handling of ~user in URI paths.
 */
char *vms_fixup_mixed_path ( char *path );
#endif
#endif	/* !APACHE_OS_H */
