$!
$! Define logicals for apache program development under OpenVMS:
$!    apache_root:	Development tree, consists of search list.
$!    apache_base:	Rooted logical for distribution files.
$!    apache_cur:	Rooted logical for updated distribution, order
$!			in search list will cause these to supercede
$!			the base files during builds.
$!
$ usr == "apache_root"			! for / -> /usr fixup done by server
$ httpd == "$apache_root:[000000]apache_httpd.exe_alpha"
$!
$ ! Find the top directory in this tree. Deek around concealed logical names.
$
$ ! This parse may not work with excessively clever and/or ODS-5 directory 
$ ! names.
$
$   this_proc = f$env("PROCEDURE")
$   this_dev = f$parse(this_proc,,, "DEVICE", "NO_CONCEAL, SYNTAX_ONLY")
$   this_dir = f$parse(this_proc,,, "DIRECTORY", "NO_CONCEAL, SYNTAX_ONLY")
$   root = this_dev + this_dir - "][" - "]<" - ">[" - "><"
$   root = f$extract(0,f$locate(".SRC",f$edit(root,"UPCASE")),root)
$   
$   if f$extract(0, 1, this_dir) .eqs. "["
$   then 
$	root = root + ".]"
$   else
$	root = root + ".>"
$   endif
$!
$!  if root is of form disk:[dir1.dir2-X.], trim the -X and make
$!  apache_root a search list.  Otherwise make apache_root, apache_cur
$!  and apache_base all the same.
$!
$   rlen = f$length(root)
$   pos = rlen-2
$   base_logical = ""
$   root2 = root
$trim_cur:
$  pos = pos - 1
$  if pos .le. 0 then goto set_root
$   c = f$extract(pos,1,root)
$   if c .eqs. "." then goto set_root
$   if c .nes. "-" then goto trim_cur
$   root2 = f$extract(0,pos,root) + f$extract(rlen-2,2,root)
$   base_logical = ",APACHE_BASE:"
$   
$set_root:
$   define APACHE_CUR "''root'"/trans=(terminal,conceal)
$   define APACHE_ROOT "''root'"/trans=(term,conceal)'base_logical'
$   define APACHE_BASE "''root2'"/trans=(termin,conceal)
$   sho logical APACHE_root
$ define apache apache_root
$!
$! Define logicals for include lists so we don't requrest /include qualifiers
$! on compiles.
$!
$ define decc$user_include apache_root:[src.include],apache_root:[src.os.openvms]
$ define decc$system_include sys$library,apache_root:[src.os.openvms]
$ if f$trnlnm("usr") .eqs. "" then define usr 'usr'
$ !
$! Sync up directories.
$!
$ if f$search("apache_base:[000000]lis.dir;1") .eqs. "" then -
	create/dir/log apache_base:[lis]/version=4
$ if f$search("apache_base:[src.os]openvms.dir;1") .eqs. "" then -
	create/dir/log apache_base:[src.os.openvms]
$!
$ obj_list = "[src.os],[src.modules.proxy],[src.regex],[src],[src.main]," + -
	"[src.modules.standard],[src.support],[src.ap]"
$ i = 0
$ next_obj_dir:
$    odir = f$element(i,",",obj_list)
$    if odir .eqs. "," then goto next_base_dir
$    i = i + 1
$    if f$search("apache_base:"+odir+"obj.dir;1") .nes. "" then goto next_obj_dir
$    odir = "apache_base:" + f$element(0,"]",odir) + ".obj]"
$    create/dir/log 'odir'/version=3
$    goto next_obj_dir
$!
$ next_base_dir:
$    bdir = f$search("apache_base:[000000...]*.dir;1",1)
$    if bdir .eqs. "" then goto bases_done
$    cdir = f$parse("apache_cur:", bdir,,,"SYNTAX_ONLY")
$    if f$search(cdir,2) .nes. "" then goto next_base_dir
$    cdir = f$element(0,"]",cdir) + "." + f$parse(cdir,,,"NAME") + "]"
$    create/dir/log 'cdir'
$    goto next_base_dir
$ bases_done:
$ exit
