#include <stdio.h>
#include <unistd.h>
#include <stat.h>

#include "process_cache.h"

int main ( int argc, char **argv, char **env )
{
    int status, id, estatus, i;
    long pid;
    vms_mailbox_set set;

    if ( argc < 2 ) {
	for ( i=0; env[i]; i++ ) printf ( "env[%d] = '%s'\n", i, env[i] );
	printf("Specify command to execute as argv[1]\n"); return 1;
    }
    status = vms_create_mailbox_set ( 0, 0, 0, 0, 0, &set );
    if ( (status&1) == 0 ) return status;

    for ( i = 1; i < argc; i++ ) {
        status = vms_create_task ( &set, argv[i], env, &pid );
        printf("Status of create[%d]: %d %x\n", i, status, pid );
        if ( (status&1) == 1 ) {
	    id = vms_wait_for_task_exit ( pid, &estatus, 0 );
	    printf("Wait[%d] result: %x estatus: %d\n", i, id, estatus );
	    /* if ( (i+1) < argc ) sleep(1); */
        }
	if ( id <= 0 ) break;
    }

    for ( i = 0; i < 2; i++ ) {
	id = vms_wait_for_task_exit ( -1, &estatus, 0 );
	printf("extra wait[%d] returned %x %d\n", i, id, estatus );
    }
    sleep(5); sleep(5);
    return status;
}
