/*
* WinfingerPrint 2 Development Code
* Copyright (C) 1999 Kirby Kuehl (vacuum@technotronic.com)
* 
* Contributors:
* vacuum@technotronic.com
* Mike@eEye.com
* hoglund@ieway.com
* napster@napster.com
* Jason_Jordan@omron.com
* sfaust@hartco.com
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 1, or (at your option)
*  any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Link to : netapi32.lib mpr.lib advapi32.lib
*/




#ifndef UNICODE
#define UNICODE
#endif
#include <stdio.h>
#include <windows.h>
#include <lm.h>
#include <stdlib.h>
#include <iostream.h>
#include <memory.h>

#include <string>
using  namespace std;


int diskenum(FILE *,LPWSTR);
int diskenum95(FILE *, LPWSTR);
int querygroup(FILE *, LPTSTR);
int queryuser(FILE *, LPTSTR);
int queryservices(FILE *, LPTSTR);
void UnicodeToAnsi (wchar_t *, char *);
void DisplayUsage (char *);
int NullSession(LPTSTR);
int NullDisconnect(LPTSTR);
int RegConnection(FILE*, LPTSTR);
wstring ErrorHandle();
void getnetwork(LPNETRESOURCE, FILE *);
int winfingerprint(FILE *, LPTSTR);

/** ADDED FUNCTIONS **/
void options_launcher(int ,LPTSTR , FILE *);
void check_options(void);

#define SZ_ENUM_BUF 4096
#define VERSION "Winfingerprint 2.21"
// Uncomment to turn on DEBUGGING
//#define DEBUG
//#define DEBUG2

// I DECIDED TO PUT THE OPTIONS VAR GLOBALY 

/*********************************************
	The options will be split in the bits position
	Bits : 0 -> optdiskenum
		   1 -> optquerygroup
		   2 -> optqueryuser
		   3 -> optqueryservices
		   4 -> optnull
		   5 -> optservername
		   6 -> optreg
		   7 -> optmass
  
  -> Since the output option is not very related
     with the scanning methods and it is not use
     globaly, we take it apart.

**********************************************/

union{
	int value;
	struct{
		unsigned int optdiskenum		: 1;
		unsigned int optquerygroup		: 1;
		unsigned int optqueryuser		: 1;
		unsigned int optqueryservices	: 1;
		unsigned int optnull			: 1;
		unsigned int optservername		: 1;
		unsigned int optreg				: 1;
		unsigned int optmass			: 1;
	}bits;
}options;



int wmain(int argc, wchar_t *argv[], char *newargv[]){

	LPTSTR pszServerName = NULL;
	LPNETRESOURCE cont_obj = NULL; // This is used when optmass is set
	char *filename;
	char opt;
	int output = 0;
	int i;
	int j;
	FILE *stream;

	//initiate the options
	options.value = 0;

	// Fill another argv[] but we use this for getopt()
	for(j = 0; j < argc; j++){
		UnicodeToAnsi (argv[j], newargv[j]);

		#ifdef DEBUG
			printf("--- [#%d : Original Argv[] = %S, NewArgv[] = %s] \n", j, argv[j], newargv[j]);
		#endif
	}

	if (argc <= 1)
		DisplayUsage(newargv[0]);
                                                                                                                                                                                                           
	for(i = 1; i < argc; i++){
		if((strncmp(newargv[i], "-", 1) == 0) || (strncmp(newargv[i], "/", 1) == 0)){

			#ifdef DEBUG
				printf("After strncmp() we have: %s\n", newargv[i]);
			#endif

			newargv[i] += 1;
			opt = (char)newargv[i][0];

			#ifdef DEBUG
				printf("The opt for the switch is: %c\n", opt);
			#endif

			switch(toupper(opt)){

				case 'D': // Enumerate NetBIOS Shares.
					options.value |= 0x01;  //00000001
					break;
				case 'G': // Enumerate Groups.
					options.value |= 0x02;  //00000010
					break;
				case 'U': // Enumerate Users.
					options.value |= 0x04;  //00000100
					break;
				case 'S': // Enumerate Services.
					options.value |= 0x08;  //00001000
					break;
				case 'N':  // Creates Null Session
					options.value |= 0x10;  //00010000
					break;
				case 'T': // Computer name is here.
					if(argv[i + 1] != NULL)
					pszServerName = argv[i + 1];
					options.value |= 0x20;   //00100000
					break;
				case 'R':  // Registry Manipulation
					options.value |= 0x40;   //01000000
					break;
				case 'M':  // 'Network Neighborhood' Scan
					options.value |= 0x80;   //10000000
					break;
				case 'A': // We do all.
					options.value |= 0x4F; //01001111
					break;
				case 'O':  // HTML Output filename
					output = 1;
					filename = newargv[i +1];
					break;
				case 'H': // Show usage.
					DisplayUsage(newargv[0]);
					break;
				case '?': // Show usage.
					DisplayUsage(newargv[0]);
					break;
				default: // We do all.
					DisplayUsage(newargv[0]);
			}
		}
	}
	
	#ifdef DEBUG2
		check_options();
	#endif

	printf("%s by vacuum@technotronic.com & Mike@eEye.com 1999\n", VERSION);
	printf("Brought to another level by sfaust@hartco.com. \n\n");

	if((!options.bits.optmass) && (!options.bits.optservername)){
		fprintf(stderr, "You must specify a 'Network Neighboorhood' scan <-m> or Computername. <-t \\computername>\n");
		exit(1);
	}
	
	if((options.bits.optmass) && (options.bits.optservername)){
		fprintf(stderr, "You specified a 'Network Neighboorhood' scan and a Computername.\nPlease choose one or the other.\n");
		exit(1);
	}

	if(options.bits.optnull && !options.bits.optmass && !options.bits.optservername){
		fprintf(stderr, "You specified a 'Null Session' scan and did not choose a mass scan or a Servername.\nPlease choose one and try again.\n");
		exit(1);
	}

	#ifdef DEBUG2
		check_options();
	#endif

	if(!output)
		filename = "winfingerprint.html";

	if( (stream = fopen(filename, "w" )) == NULL ){
		printf( "The file '%s' was not opened\n",filename);
		exit(1);
	}

	fprintf(stream, "<HTML>\n<HEAD>\n<TITLE>%s output</TITLE>\n</HEAD>\n<BODY>\n", VERSION);
	fprintf(stream,"<CENTER><a href=\"http://www.technotronic.com/winfingerprint/\"><IMG border=0 alt=\"%s\"SRC = \"winfingerprint.jpg\"></a><BR>\n", VERSION);
	fprintf(stream, "by <A HREF = \"mailto:vacuum@technotronic.com\">vacuum@technotronic.com</A>\n");
	fprintf(stream, "<a href=\"aboutwinfingerprint.html\">About %s</a><BR>\n", VERSION);

	printf("Enumerating Available Servers, Please wait ...\n");

	if(options.bits.optmass){
		// Notes :
		// we need to pass a NULL one at first and then collect the servernames
		// 
		getnetwork(cont_obj, stream);
	}
	else{
		options_launcher(winfingerprint(stream, pszServerName), pszServerName, stream);
	}

	// All complete.
	printf("\ndone.\n\n");

	/*
	printf("Open '%s' in your favorite web browser to view results.\n\n", filename);
	printf("%s by vacuum@technotronic.com & Mike@eEye.com 1999\n", VERSION);
	*/

	fprintf(stream,"</CENTER></BODY>\n</HTML>\n");
	fclose(stream);

	return 0;
}

int diskenum(FILE *stream2,LPWSTR computername){

	PSHARE_INFO_502 BufPtr,p;
	NET_API_STATUS res;
	DWORD i;
	DWORD entriesread=0, resume_handle=0, totalentries=0;

	fprintf(stream2,"<p>NetBIOS Share Results:<BR><TABLE BORDER=1 WIDTH =\"600\"\n");
	// Added so it prints the ComputerName not UNC name. Aesthetics.
	// Found out it would die if ONLY -d was called. It is because
	// we set it to do computername + 2 for aesthetics. Therefore, here is the If() to fix it.
	if(computername == NULL)
		fprintf(stream2,"<TR><TD><B>Shares:</B></TD><TD><B>Local Path:</B></TD><TD><B>Uses:</B></TD><TD><B>Descriptor:</B></TD></TR>\n");
	else
		fprintf(stream2,"<TR><TD><B>%S's Shares:</B></TD><TD><B>Local Path:</B></TD><TD><B>Uses:</B></TD><TD><B>Descriptor:</B></TD></TR>\n", computername + 2);

	do{
		res = NetShareEnum(computername,
							 502,
							 (LPBYTE *) &BufPtr,
							 0xFFFFFFFF,
							 &entriesread,
							 &totalentries,
							 &resume_handle);

		if(res == ERROR_SUCCESS || res == ERROR_MORE_DATA){
			p=BufPtr;

			for(i=1;i<=entriesread;i++){
				fprintf(stream2,"<TR><TD>%-20S</TD><TD>%-30S</TD><TD>%-8u</TD>",p->shi502_netname, p->shi502_path, p->shi502_current_uses);

				if (IsValidSecurityDescriptor(p->shi502_security_descriptor))
					fprintf(stream2,"<TD>Yes</TD></TR>\n");
				else
					fprintf(stream2,"<TD>No</TD></TR>\n");

				p++;
			}
			NetApiBufferFree(BufPtr);
			fprintf(stream2,"</TABLE>");
			return(0);
		}
		else {
			fprintf(stream2,"<TR><TD>Share Enumeration Error: %S </B></TD></TR>\n" , ErrorHandle().begin());
			fprintf(stderr,"Share Enumeration Error (%d):\n %S\n" ,GetLastError(), ErrorHandle().begin());
			return(3);      // Return 3 on error so we can run diskenum95()
		}
	}while (res==ERROR_MORE_DATA);

	fprintf(stream2,"</TABLE>");
	return(0);

}

int diskenum95(FILE *stream2,LPTSTR computername){

	PSHARE_INFO_1 BufPtr,p;
	NET_API_STATUS res;
	DWORD i = 0;
	DWORD entriesread=0, resume_handle=0, totalentries=0;

	fprintf(stream2, "<p><TABLE BORDER = 1 WIDTH = \"600\">\n");
	// Added so it prints the ComputerName not UNC name. Aesthetics.
	// Found out it would die if ONLY -d was called. It is because
	// we set it to do computername + 2 for aesthetics. Therefore, here is the If() to fix it.
	if(computername == NULL)
		fprintf(stream2,"<TR><TD><B>Shares:</B></TD><TD><B>Type:</B></TD><TD><B>Comment:</B></TD></TR>\n");
	else
		fprintf(stream2,"<TR><TD><B>%S's Shares:</B></TD><TD><B>Type:</B></TD><TD><B>Comment:</B></TD></TR>\n", computername + 2);

	do{
		res = NetShareEnum(computername,
							 1,
							 (LPBYTE *) &BufPtr,
							 0xFFFFFFFF,
							 &entriesread,
							 &totalentries,
							 &resume_handle);

		if(res == ERROR_SUCCESS || res == ERROR_MORE_DATA){
			p = BufPtr;
			for(i=0;i<entriesread;i++){
				fprintf(stream2,"<TR><TD>%S</TD><TD>%u</TD><TD>%S</TD>",p->shi1_netname, p->shi1_type, p->shi1_remark);
				p++;
			}
			NetApiBufferFree(BufPtr);
		}
		else{
			fprintf(stream2,"<TR><TD>Share Enumeration Error: %S </B></TD></TR>\n" , ErrorHandle().begin());
			fprintf(stderr,"Share Enumeration Error (%d):\n %S\n" ,GetLastError(), ErrorHandle().begin());

			printf("Attempting to obtain NetBIOS shares using lower security setting\n");
			return(-1);
		}
	}while (res==ERROR_MORE_DATA);

	fprintf(stream2,"</TABLE>");
	return(0);
}

int querygroup(FILE *stream3, LPTSTR szServer){

	PNET_DISPLAY_GROUP pBuff, p;
	DWORD res, dwRec, i = 0;

	#ifdef DEBUG
		printf("querygroup(), szServer: [%S]\n", szServer);
	#endif

	do{
		res = NetQueryDisplayInformation(szServer, 3, i, 1000, 25, &dwRec, (PVOID *)&pBuff);

		if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA)){
			#ifdef DEBUG
				printf("dwRec(%d), NET_DISPLAY_GROUP(%d)\n", dwRec, sizeof(NET_DISPLAY_GROUP));
			#endif

			p = pBuff;
			fprintf(stream3, "<p>Group Query Results:<BR><TABLE BORDER=1 WIDTH =\"600\">\n");
			fprintf(stream3, "<TR><TD><b>Name:</B></TD><TD><b>Comment:</b></TD><TD><b>Group ID:</b></TD><TD><b>Attributes:</b></TD></TR>\n");

			for(;dwRec>0;dwRec--){
				fprintf(stream3,"<TR><TD>%S</TD>\n"
					  "<TD>%S</TD>\n"
				"<TD>%u</TD>\n"
					  "<TD>%u</TD>\n"
				"</TR>\n",
				p->grpi3_name,
					  p->grpi3_comment,
				p->grpi3_group_id,
					  p->grpi3_attributes);

				i = p->grpi3_next_index;  //if there is more then set the index
				p++;
			}
			NetApiBufferFree(pBuff);
			fprintf(stream3, "</TABLE>\n");

			return(0);
		}
		else{
			if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA))

			fprintf(stream3,"Group Enumeration Error:(%u)\n %S\n" ,res, ErrorHandle().begin());
			fprintf(stderr,"Group Enumeration Error:(%u)\n %S\n" ,res, ErrorHandle().begin());

			// break;
			return(-1);
		}
	}while (res==ERROR_MORE_DATA);
}

int queryuser(FILE *stream4, LPTSTR szServer){

	PNET_DISPLAY_USER pBuff, p;
	DWORD res, dwRec, i = 0;

	#ifdef DEBUG
		printf("queryuser(), szServer: [%S]\n", szServer);
	#endif

	do{
		res = NetQueryDisplayInformation(szServer, 1, i, 1000, 1000*sizeof(NET_DISPLAY_USER), &dwRec, (PVOID *)&pBuff);
		if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA)){

			#ifdef DEBUG
				printf("dwRec(%d), NET_DISPLAY_USER(%d)\n", dwRec, sizeof(NET_DISPLAY_USER));
			#endif

			p = pBuff;
			fprintf(stream4, "<p>User Query Results:<BR><TABLE BORDER=1 WIDTH =\"600\">\n");
			fprintf(stream4, "<TR><TD><b>Name:</b></TD><TD><b>Comment:</b></TD><TD><b>Full Name:</b></TD><TD><b>User ID:</b></TD></TR>\n");

			for(;dwRec>0;dwRec--){
				fprintf(stream4,
					"<TR><TD>%S</TD>\n"
					"<TD>%S</TD>\n"
					"<TD>%S</TD>\n"
					"<TD>%u</TD>\n"
					"</TR>\n",
					p->usri1_name,
					p->usri1_comment,
					p->usri1_full_name,
					p->usri1_user_id);

				if (p->usri1_flags & UF_SCRIPT)
					fprintf(stream4,"<TR><TD COLSPAN=4>(The logon script executed. This value must be set for LAN Manager 2.0 or Windows NT.)</TD></TR>\n");
				if (p->usri1_flags & UF_ACCOUNTDISABLE)
					fprintf(stream4,"<TR><TD COLSPAN=4>(The user's account is disabled.)</TD></TR>\n");
				if (p->usri1_flags & UF_HOMEDIR_REQUIRED)
					fprintf(stream4,"<TR><TD COLSPAN=4>(The home directory is required. Windows NT ignores this value.)</TD></TR>\n");
				if (p->usri1_flags & UF_PASSWD_NOTREQD)
					fprintf(stream4,"<TR><TD COLSPAN=4>(No password is required.)</TD></TR>\n");
				if (p->usri1_flags & UF_PASSWD_CANT_CHANGE )
					fprintf(stream4,"<TR><TD COLSPAN=4>(The user cannot change the password.)</TD></TR>\n");
				if (p->usri1_flags & UF_LOCKOUT)
					fprintf(stream4,"<TR><TD COLSPAN=4>(The Account is Locked)</TD></TR>\n");
				if (p->usri1_flags & UF_DONT_EXPIRE_PASSWD)
					fprintf(stream4,"<TR><TD COLSPAN=4>(Password does not expire)</TD></TR>\n");

				i = p->usri1_next_index;  //if there is more then set the index
				p++;
			}
			NetApiBufferFree(pBuff);
			fprintf(stream4,"</TABLE>\n");
			return(0);
		}
		else{
			fprintf(stream4,"User Enumeration Error:(%u)\n %S\n",res, ErrorHandle().begin());
			fprintf(stderr, "User Enumeration Error:(%u)\n %S\n" ,res, ErrorHandle().begin());
			// break;
			return(-1);
		}
	}while (res==ERROR_MORE_DATA);
}

int queryservices(FILE *stream5, LPTSTR szServer){

	SC_HANDLE scm;
	BOOL success;
	LPENUM_SERVICE_STATUS status;
	DWORD numServices=0, sizeNeeded=0, resume=0;

	// Open a connection to the SCM
	scm = OpenSCManager(szServer, 0,
						SC_MANAGER_ALL_ACCESS);
	if (!scm){
		printf("Error with OpenSCManager\n");
		return(-1);
	}

	// get the number of bytes to allocate
	// MAKE SURE resume starts at 0
	resume = 0;
	success = EnumServicesStatus(scm,
								SERVICE_WIN32 | SERVICE_DRIVER,
	                            SERVICE_ACTIVE | SERVICE_INACTIVE,
	                            0, 0, &sizeNeeded,
								&numServices, &resume);

	if (GetLastError() != ERROR_MORE_DATA){
		printf("Error with EnumServicesStatus\n");
		return(-1);
	}

	// Allocate space
	status = (LPENUM_SERVICE_STATUS)
	LocalAlloc(LPTR, sizeNeeded);

	#ifdef DEBUG
		printf("sizeNeeded(%d)\n", LocalAlloc(LPTR, sizeNeeded));
	#endif

	// Get the status records. Making an assumption
	// here that no new services get added during
	// the allocation (could lock the database to
	// guarantee that...)
	resume = 0;
	success = EnumServicesStatus(scm,
								 SERVICE_WIN32 | SERVICE_DRIVER,
	                             SERVICE_ACTIVE,
	                             status, sizeNeeded, &sizeNeeded,
	                             &numServices,
								 &resume);
	if (!success){
		printf("Error with EnumServicesStatus\n");
		return(-1);
	}

	DWORD i;
	fprintf(stream5, "<p>Service Enumeration Results:<BR><TABLE BORDER=1 WIDTH =\"600\">\n");

	for (i=0; i < numServices; i++)
		fprintf(stream5,"<TR><TD>%d %S %S</TD></TR>\n",i,status[i].lpServiceName,status[i].lpDisplayName);

	// Clean up
	LocalFree(status);
	CloseServiceHandle(scm);
	fprintf(stream5, "</TABLE>\n");
	return(0);
}

void UnicodeToAnsi (wchar_t *wcs, char *mbs){
	if (wcs)
	wcstombs (mbs, wcs, (wcslen (wcs) + 1) * sizeof (WCHAR));
	else
	*mbs = '\0';
}

int winfingerprint(FILE *stream, LPTSTR pszServerName){

	DWORD dwLevel = 101;
	LPSERVER_INFO_101 pBuf = NULL;
	NET_API_STATUS nStatus;

	nStatus = NetServerGetInfo(pszServerName,
							   dwLevel,
							   (LPBYTE *)&pBuf);


	if (nStatus == NERR_Success){
		fprintf(stream,"<p>SMB Query Results:<BR><TABLE BORDER=1 WIDTH =\"600\">\n");

		if (pBuf->sv101_type & SV_TYPE_DOMAIN_CTRL)
			fprintf(stream,"<TR><TD COLSPAN=5><CENTER><B>%S</B> is a PDC.</CENTER></TD></TR>\n", pBuf->sv101_name);
		else if (pBuf->sv101_type & SV_TYPE_DOMAIN_BAKCTRL)
			fprintf(stream,"<TR><TD COLSPAN=5><CENTER><B>%S</B> is a BDC.</CENTER></TD></TR>\n", pBuf->sv101_name);
		else if (pBuf->sv101_type & SV_TYPE_SERVER_NT )
			fprintf(stream,"<TR><TD COLSPAN=5><CENTER><B>%S</B> is a NT MEMBER SERVER.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type &  SV_TYPE_NT )
			fprintf(stream,"<TR><TD COLSPAN=5><CENTER><B>%S</B> is a NT WORKSTATION.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type & SV_TYPE_SQLSERVER)
			fprintf(stream,"<TR><TD COLSPAN=5><CENTER><B>%S</B> is running SQL.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type &  SV_TYPE_NOVELL )
			fprintf(stream,"<TR><TD COLSPAN=5><CENTER><B>%S</B> is a Novell Netware Server.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type & SV_TYPE_WFW )
			fprintf(stream,"<TR><TD COLSPAN=5><CENTER><B>%S</B> is Windows for Workgroups.</CENTER></TD></TR>\n",pBuf->sv101_name);
		else if (pBuf->sv101_type &  SV_TYPE_WINDOWS )
			fprintf(stream,"<TR><TD COLSPAN=5><CENTER><B>%S</B> is running Windows 9x.</CENTER></TD></TR>\n",pBuf->sv101_name);

		fprintf(stream,"<TR><TD><B>Platform:</B></TD><TD><B>Name:</B></TD>\n");
		fprintf(stream,"<TD><B>Version:</B></TD><TD><B>Type:</B></TD>\n");
		fprintf(stream,"<TD><B>Comment:</B></TD></TR>\n");

		fprintf(stream, "<TR><TD> %d</TD>\n", pBuf->sv101_platform_id);
		fprintf(stream, "<TD>%S</TD>\n", pBuf->sv101_name);
		fprintf(stream, "<TD>%d.%d</TD>\n", pBuf->sv101_version_major, pBuf->sv101_version_minor);
		fprintf(stream, "<TD>%d</TD>\n", pBuf->sv101_type);
		fprintf(stream, "<TD>%S</TD></TR></TABLE>\n", pBuf->sv101_comment);
	}
	
	else{
		fprintf(stream,"User Enumeration Error %d: %S\n" ,nStatus, ErrorHandle().begin());
		fprintf(stderr, "User Enumeration Error %d: %S\n" ,nStatus, ErrorHandle().begin());

		if (pBuf != NULL)
			NetApiBufferFree(pBuf);
		return(-1);
	}

	if (pBuf->sv101_type & (SV_TYPE_NOVELL | SV_TYPE_WFW | SV_TYPE_WINDOWS)){
		fprintf(stream,"Not running Group/User Enumeration. Machine does not support it.<BR>");
		return(5); // Have to flag Windows 9x machines
	}

	if (pBuf != NULL)
		NetApiBufferFree(pBuf);
	return(0);
}

void getnetwork(LPNETRESOURCE cont_obj, FILE *stream){   // the concept is this is null for the first time. Then it is reused.

	HANDLE enumHandle;
	LPNETRESOURCE buffer;
	DWORD bufferSize = 16384;
	DWORD numEntries = 0xFFFFFFFF;
	DWORD result;
	buffer = (LPNETRESOURCE) GlobalAlloc( GPTR, bufferSize);

	result = WNetOpenEnum(
							RESOURCE_GLOBALNET,  // scope of enumeration
							RESOURCETYPE_ANY,    // resource types to list
							0,                   // resource usage to list
							cont_obj,            // pointer to resource structure
							&enumHandle);        // pointer to enumeration handle buffer

	if (result != NO_ERROR){
		printf("WNetOpenEnum Error: %d\n",result);
		return;
	}


	#ifdef DEBUG2
		printf("\n**** WNetOpenEnum was successfull. Going on with WNetEnumResource ...\n");
	#endif

	result = WNetEnumResource(
								enumHandle,                     // handle to enumeration
								&numEntries,                    // pointer to entries to list
								buffer,                         // pointer to buffer for results
								&bufferSize);                   // pointer to buffer size variable

	#ifdef DEBUG2
		printf("\n**** WNetEnumResource returned : %d \n",result);
	#endif

	if (result == NO_ERROR){
	
		#ifdef DEBUG2
				printf("\n**** I'm in ...\n");
				printf("\n**** numEntries = %d \n",numEntries);
		#endif

		for(int i = 0; i < numEntries; i++){
			// if the object is a server
			if( buffer[i].dwDisplayType == RESOURCEDISPLAYTYPE_SERVER){
				printf("\nEnumerating [%S]. . .\n", buffer[i].lpRemoteName + 2);
				options_launcher(winfingerprint(stream, buffer[i].lpRemoteName), buffer[i].lpRemoteName, stream) ;
			}

			// if the object is a container ( and not a server )
			if( (buffer[i].dwUsage & RESOURCEUSAGE_CONTAINER) && (buffer[i].dwDisplayType != RESOURCEDISPLAYTYPE_SERVER) )
				getnetwork(&buffer[i], stream);  // we found a container, we repass it to the filtering function
		}
	}
	GlobalFree(buffer);
	result = WNetCloseEnum(enumHandle);
	if (result != NO_ERROR)
		printf("WNetCloseEnum ERROR: %d\n",result);
}


int NullSession(LPTSTR Server){

	LPCWSTR szIpc = L"\\IPC$";
	WCHAR RemoteResource[UNCLEN + 5 + 1]; // UNC len + \IPC$ + NULL
	DWORD cchServer;

	NET_API_STATUS nas;
	NETRESOURCE     nr;

	cchServer = lstrlenW( Server );
	if(Server[0] != L'\\' && Server[1] != L'\\') {
		//
		// prepend slashes and NULL terminate
		//
		RemoteResource[0] = L'\\';
		RemoteResource[1] = L'\\';
		RemoteResource[2] = L'\0';
	}
	else{
		cchServer -= 2; // drop slashes from count
		RemoteResource[0] = L'\0';
	}
	if(cchServer > CNLEN){
		SetLastError(ERROR_INVALID_COMPUTERNAME);
		printf("Error in Null Session Routine\n");
		return(-1);
	}
	if(lstrcatW(RemoteResource, Server) == NULL)
		printf("Error in Null Session Routine\n");
	if(lstrcatW(RemoteResource, szIpc) == NULL)
		printf("Error in Null Session Routine\n");

	nr.dwType = RESOURCETYPE_ANY;
	nr.lpLocalName = NULL;
	nr.lpProvider = NULL;
	nr.lpRemoteName = (LPTSTR) RemoteResource;

	nas = WNetAddConnection2(&nr, (LPTSTR) L"", (LPTSTR) L"", 0);
	if( nas == NERR_Success ){
		printf("Null IPC$ Session Established [%S].\n",Server +2);
		return(0);}
	else{
		printf("Null Session NOT Established Error: %d.\n", nas);
		return(-1);
	}
}

int RegConnection(FILE *stream2, LPTSTR szServer){

	LONG result;
	HKEY hKey, phkResult;
	DWORD dwType;
	WCHAR lpData[MAX_PATH];
	DWORD dwBufLen;
	TCHAR lpName[1024];
	DWORD lpcbName = 1024;
	FILETIME time;
	DWORD index ;

	result = RegConnectRegistry(szServer,        // address of name of remote computer
								HKEY_LOCAL_MACHINE,  // predefined registry handle
								&hKey);              // address of buffer for remote registry handle

	if (result != ERROR_SUCCESS){
		printf("RegConnectRegistry ERROR: %d\n",result);
		return(-1);
	}
	else
		printf("Registry Connected [%d]\n", szServer +2);

	result = RegOpenKeyEx(hKey,                  // handle to open key
						  L"Software\\Microsoft\\Windows NT\\CurrentVersion",// address of name of subkey to open
						  0,                     // reserved
						  KEY_QUERY_VALUE,       // security access mask
						  &phkResult);           // address of handle to open key

	if (result != ERROR_SUCCESS){
		printf("RegOpenKeyEx ERROR: %d",result);
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
					  NULL,
				      GetLastError(),
					  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
					  (LPTSTR) &result,
					  0,
					  NULL);

		// fprintf(stream2,"RegOpenKeyEx Error: %S\n",  (LPCTSTR)result);
		fprintf(stderr, " %S\n",  (LPCTSTR)result);
		return(-1);
	}
	else{
		//
		// Determine how large of a buffer to allocate.
		//
		result = RegQueryValueEx(phkResult,          // handle to key to query
								 L"CSDVersion",      // address of name of value to query
								 NULL,               // reserved
								 &dwType,            // address of buffer for value type
								 (LPBYTE) lpData,    // address of data buffer
								 &dwBufLen);         // address of data buffer size
		dwBufLen = sizeof(lpData);
	}

	result = RegQueryValueEx(phkResult,          // handle to key to query
					         L"CSDVersion",      // address of name of value to query
							 NULL,               // reserved
							 &dwType,            // address of buffer for value type
		                     (LPBYTE) lpData,    // address of data buffer
		                     &dwBufLen);         // address of data buffer size

	if (result != ERROR_SUCCESS){
		fprintf(stderr, "RegQueryValueEx ERROR %d: %S\n",result, ErrorHandle().begin());
		return(-1);
	}
	else{
		//printf("[%S] %S\n",szServer, lpData);
		fprintf(stream2,"<p> <TABLE BORDER=1 WIDTH =\"600\">\n");
		fprintf(stream2, "<TR><td colspan = \"2\"><b>%S</b> %S</TD></TR>\n",szServer +2, lpData);
		fprintf(stream2, "<TR><TD><B>Hotfix:</B></TD><TD><B>Description</b></TD></TR>\n");
	}

	RegCloseKey(hKey);
	fprintf(stream2, "<BR>Registry Query Results:<BR>\n");
	result = RegConnectRegistry(szServer,            // address of name of remote computer
								HKEY_LOCAL_MACHINE,  // predefined registry handle
								&hKey);              // address of buffer for remote registry handle

	if (result != ERROR_SUCCESS){
		printf("RegConnectRegistry ERROR: %d\n",result);
		return(-1);
	}

	result = RegOpenKeyEx(hKey,                  // handle to open key
						  L"Software\\Microsoft\\Windows NT\\CurrentVersion\\Hotfix",// address of name of subkey to open
						  0,                     // reserved
						  KEY_ENUMERATE_SUB_KEYS,// security access mask
						  &phkResult);           // address of handle to open key

	if (result == ERROR_SUCCESS){
		index = 0;
		lpcbName = sizeof(lpName);

		result = RegEnumKeyEx(phkResult,          // handle to key to enumerate
							  index,              // index of subkey to enumerate
							  lpName,             // address of buffer for subkey name
							  &lpcbName,          // address for size of subkey buffer
							  NULL,               // reserved
							  NULL,               // address of buffer for class string
							  NULL,               // address for size of class buffer
							  &time);

		for(index = 0; result != ERROR_NO_MORE_ITEMS; index++){

			lpcbName = sizeof(lpName);
			result = RegEnumKeyEx(phkResult,          // handle to key to enumerate
								  index,              // index of subkey to enumerate
								  lpName,             // address of buffer for subkey name
								  &lpcbName,          // address for size of subkey buffer
								  NULL,               // reserved
								  NULL,               // address of buffer for class string
								  NULL,               // address for size of class buffer
								  &time);

			if (result == ERROR_NO_MORE_ITEMS){
				RegCloseKey(hKey);
				fprintf(stream2, "</TABLE>\n");
				return(0);
			}
			else{
				HKEY hkey_q;
				int rval;
				DWORD lpType,lpcbData=8192;
				TCHAR result[8192];
				rval=RegOpenKeyEx(phkResult,lpName,0,KEY_READ,&hkey_q);
				rval=RegQueryValueEx(hkey_q,TEXT("Comments"),NULL,&lpType,(LPBYTE) result,&lpcbData);
				fprintf(stream2, "<TR><TD>%S</TD><TD>%S</TD></TR>\n",lpName, result);
			}
		}
		fprintf(stream2, "</TABLE>\n");
		RegCloseKey(hKey);
		return(0);
	}
	return 0;
}

int NullDisconnect(LPTSTR Server)
	{
	LPCWSTR szIpc = L"\\IPC$";
	WCHAR RemoteResource[UNCLEN + 5 + 1]; // UNC len + \IPC$ + NULL
	DWORD cchServer, result;


	cchServer = lstrlenW( Server );
	if(Server[0] != L'\\' && Server[1] != L'\\') {
	//
	// prepend slashes and NULL terminate
	//
	RemoteResource[0] = L'\\';
	RemoteResource[1] = L'\\';
	RemoteResource[2] = L'\0';
	}
	else
	{
	cchServer -= 2; // drop slashes from count
	RemoteResource[0] = L'\0';
	}
	if(cchServer > CNLEN)
	{
	SetLastError(ERROR_INVALID_COMPUTERNAME);
	printf("Error in Null Session Routine\n");
	return(-1);
	}
	if(lstrcatW(RemoteResource, Server) == NULL) printf("Error in Null Session Routine\n");
	if(lstrcatW(RemoteResource, szIpc) == NULL) printf("Error in Null Session Routine\n");

	result = WNetCancelConnection2(
	RemoteResource,  // pointer to resource name to disconnect
	0,    // connection type flags
	1);     // flag for unconditional disconnect

	if(result == NO_ERROR ){
	printf("Null IPC$ Session Terminated [%S].\n",Server +2);
	return(0);}
	else {
	printf("Null Session NOT Terminated Error: %d.\n", result);
	return(-1);}
	}

	wstring ErrorHandle()
	{
	LPVOID lpMsgBuf;

	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
	FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
	NULL,
	GetLastError(),
	MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
	(LPTSTR) &lpMsgBuf,
	0,
	NULL);
	wstring str((LPCTSTR)lpMsgBuf);
	LocalFree(lpMsgBuf);
	return(str);
}

void DisplayUsage (char *arg){

	printf("%s vacuum@technotronic.com & Mike@eEye.com\n\n", VERSION);
	printf("Usage: %s [-t \\\\COMPUTERNAME] [-a -d -g -m -n -o -r -s -u -h]\n", arg);
	printf("NOTE: If no server is supplied (e.g., No '-t') localhost is used.\n");
	printf(" -a Enumerates NetBIOS Shares, Users, Groups, and Services\n");
	printf(" -d Enumerates Shares\n");
	printf(" -g Enumerates Groups\n");
	printf(" -m Scan entire 'Network Neighborhood'\n");
	printf(" -n Establishes Null Session\n");
	printf(" -r Registry Querying\n");
	printf(" -s Enumerates Services\n");
	printf(" -u Enumerates Users\n");
	printf(" -o Output filename 'e.g. myscan.html'\n");
	printf(" -h Shows Usage\n");
	exit(1);
}

void options_launcher(int os_type, LPTSTR server, FILE *stream){

	int rdata;

	switch(os_type){
		case 5:
			// 95, 98, Novell.
			if(options.bits.optnull)
				NullSession(server);
			if(options.bits.optdiskenum)
				diskenum95(stream,server);
			if(options.bits.optnull)
				NullDisconnect(server);
			break;
		case -1:
			// An error occured.
			break;
		case 0:
			// NT box.
			if(options.bits.optnull)
				NullSession(server);
			if(options.bits.optreg)
				RegConnection(stream, server);
			if(options.bits.optdiskenum){
				rdata = diskenum(stream,server);
				// Try to get shres without Administrator access.
				if(rdata == 3)
					diskenum95(stream,server);
			}
			if(options.bits.optquerygroup)
				querygroup(stream,server);
			if(options.bits.optqueryuser)
				queryuser(stream,server);
			if(options.bits.optqueryservices)
				queryservices(stream,server);
			if(options.bits.optnull)
				NullDisconnect(server);
			break;
		default:
			break;
	}
}

//function for used during debug only
void check_options(){

	printf("\n**** Options enabled \n\n");
	printf("Options are : %x \n",options.value);
	fprintf(stdout,"optmass: %d\n",options.bits.optmass);
	fprintf(stdout,"optdiskenum: %d\n",options.bits.optdiskenum);
	fprintf(stdout,"bits: %x\n",options.bits);
	fprintf(stdout,"bits >> 7: %d\n", options.value >> 7);
	fprintf(stdout,"optqueryuser %d\n", options.bits.optquerygroup);
	if(options.bits.optdiskenum)
		printf("Optdiskenum : Enabled \n");
	if(options.bits.optquerygroup)
		printf("Optquerygroup : Enabled \n");
	if(options.bits.optqueryuser)
		printf("Optqueryuser : Enabled \n");
	if(options.bits.optqueryservices)
		printf("Optqueryservices : Enabled \n");
	if(options.bits.optnull)
		printf("Optnull : Enabled \n");
	if(options.bits.optservername)
		printf("Optservername : Enabled \n");
	if(options.bits.optreg)
		printf("Optreg : Enabled \n");
	if(options.bits.optmass)
		printf("Optmass : Enabled \n");
	printf("\n**** END \n");
}

