// TestReplacement.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <wincrypt.h>
#include "..\\ReplaceNsaKey\\ReplaceNsaKey.h"

#define NewProviderName "Cryptonym NSA Replacement Provider"
#define OldProviderName "Microsoft Base Cryptographic Provider v1.0"

#ifdef _DEBUG
#define loadPath	"..\\ReplaceNsaKey\\Debug\\ReplaceNsaKey.dll"
#else
#ifdef NDEBUG
#define loadPath	"..\\ReplaceNsaKey\\Release\\ReplaceNsaKey.dll"
#else 
#error need to define one of _DEBUG or NDEBUG
#endif
#endif


// TODO: get public key in C form from "ResignDll.java"

static const BYTE rsa_N[] = { 0x4D,\
        0xB8,0x60,0xD1,0x3C,0x19,0x9D,0xB4,0x92,\
        0x68,0xFD,0xB9,0xBD,0x25,0x1A,0x90,0xD0,\
        0x17,0x6A,0xE0,0x3B,0xC4,0x37,0x4C,0x91,\
        0x5C,0x53,0x74,0x1A,0xB1,0xF6,0x1A,0xE7,\
        0x34,0x91,0xC6,0x38,0x83,0xE4,0x3F,0x03,\
        0x1E,0x7D,0xFF,0x02,0xE1,0x54,0x73,0xD6,\
        0xE7,0xA7,0x3E,0x8E,0x72,0xA5,0x5F,0x4F,\
        0xF8,0xE0,0xD6,0x43,0xCE,0x8A,0x21,0x65,\
        0x95,0xB9,0x38,0xC3,0xEE,0xB9,0xD7,0xE1,\
        0xA2,0xF0,0x71,0xEB,0xC2,0x5B,0x00,0x7B,\
        0xF2,0x69,0x23,0x58,0x67,0xCD,0x1E,0xFD,\
        0x83,0xF9,0x95,0xDE,0x29,0x9C,0x95,0xB9,\
        0x89,0x3F,0x09,0xEC,0x40,0x4A,0xD3,0x64,\
        0xA8,0x34,0x8B,0xEF,0x91,0x2C,0x83,0xA2,\
        0x19,0xA7,0xEC,0x1E,0x03,0xE9,0xA4,0x92,\
        0x90,0x6A,0xAD,0x42,0x9E,0x6A,0xC9 };

static const BYTE rsa_D[] = { 0x01,\
        0x0B,0x85,0x08,0xE9,0x83,0xE8,0xD0,0x38,\
        0x6C,0x1B,0x35,0x43,0xB7,0xD5,0xF5,0xC7,\
        0xE2,0xF4,0x49,0x07,0x70,0xD8,0xAB,0xE9,\
        0x2A,0xB2,0x1B,0x4F,0xDD,0x28,0x59,0x7A,\
        0xFA,0xAC,0x5A,0x95,0xEE,0xC1,0xEE,0x9D,\
        0xFD,0xD3,0x1E,0x19,0xC0,0x11,0x81,0x02,\
        0xF3,0x52,0x1B,0xAB,0xE6,0x34,0x99,0x6A,\
        0xA2,0x5B,0x61,0x72,0x73,0xB6,0xFC,0x62,\
        0x46,0xBB,0xC9,0xD5,0x8F,0x0C,0xF7,0xA1,\
        0x3C,0x56,0x23,0x1F,0xDB,0xDD,0x21,0x5E,\
        0x98,0x3B,0xCD,0xCE,0x95,0x87,0x4A,0xF9,\
        0x17,0xFC,0x0F,0xC2,0x99,0xB2,0xC0,0x88,\
        0x96,0xA6,0xC1,0x49,0xDC,0x9A,0x1E,0x93,\
        0x9A,0x53,0xD9,0x6D,0xD7,0x40,0xC0,0x78,\
        0xB6,0xA8,0x0E,0x38,0x0C,0x50,0x01,0x40,\
        0x06,0x4E,0x16,0x6D,0x40,0x23,0x67 };

static const BYTE rsa_E[] = { 0x01,0x00,0x01 };


int main(int argc, char* argv[]) {

	BOOL bStatus;
	char *pszStatus;
	HCRYPTPROV hProv1;
	HCRYPTPROV hProv2;
	HCRYPTPROV hProv3;
    CHAR pszMyName1[MAX_PATH];
	pszMyName1[0] = '\0';
    CHAR pszMyName2[MAX_PATH];
	pszMyName2[0] = '\0';
    CHAR pszMyName3[MAX_PATH];
	pszMyName3[0] = '\0';
	
	fprintf(stderr,"using system default NSA key...\n");
	bStatus = CryptAcquireContext(&hProv1,pszMyName1,NewProviderName,001,CRYPT_VERIFYCONTEXT);
	if ( bStatus ) {
		fprintf(stderr,"load of Test CSP succeeded (this result is unexpected)\n");
		return -1;
	} else {
		fprintf(stderr,"load of Test CSP failed (this result is expected)\n");
	}

	HINSTANCE hInstance = LoadLibrary(loadPath);
	if ( !hInstance ) {
		fprintf(stderr,"load of "loadPath" failed (this result is unexpected)\n");
		return -1;
	}
	TypeFnReplaceNsaKey fnReplaceNsaKey = (TypeFnReplaceNsaKey)GetProcAddress(hInstance,"fnReplaceNsaKey");
	const int &iRsaKeySize = (const int &)GetProcAddress(hInstance,"iRsaKeySize");
	if ( sizeof(rsa_N) != iRsaKeySize ) {
		fprintf(stderr,"size of replacement key is wrong (this result is unexpected)\n");
		return -1;
	}
	pszStatus = (*fnReplaceNsaKey)((BYTE *)rsa_N);
	if ( pszStatus ) {
		fprintf(stderr,"error: ");
		fprintf(stderr,pszStatus);
		fprintf(stderr,"\n");
		return -1;
	}
	fprintf(stderr,"NSA key successfully replaced...\n");

	fprintf(stderr,"using new test key...\n");
	bStatus = CryptAcquireContext(&hProv2,pszMyName2,NewProviderName,001,CRYPT_VERIFYCONTEXT);
	if ( bStatus ) {
		fprintf(stderr,"load of Test CSP succeeded (this result is expected)\n");
	} else {
		fprintf(stderr,"load of Test CSP failed (this result is unexpected)\n");
		return -1;
	}

	fprintf(stderr,"verifying MSFT interoperability...\n");
	bStatus = CryptAcquireContext(&hProv3,pszMyName3,OldProviderName,001,CRYPT_VERIFYCONTEXT);
	if ( bStatus ) {
		fprintf(stderr,"concurrent load of MSFT signed CSP succeeded\n");
	} else {
		fprintf(stderr,"concurrent load of MSFT signed CSP failed\n");
		return -1;
	}

	return 0;
}

