/******************************************************************************
 *
 * Copyright (c) 1998,99 by Mindbright Technology AB, Stockholm, Sweden.
 *                 www.mindbright.se, info@mindbright.se
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *****************************************************************************
 * $Author: mats $
 * $Date: 1999/11/26 10:20:55 $
 * $Name: rel1-2pre3 $
 *****************************************************************************/
package mindbright.ssh;

public abstract class SSH2 {

    /* Maximum length of packet payload, including packet type. */
    public static final int MAX_PAYLOAD_LENGTH = 32768;

    /* Packet numbers for the SSH transport layer protocol. */
    public static final int MSG_DISCONNECT      = 1;
    public static final int MSG_IGNORE          = 2;
    public static final int MSG_UNIMPLEMENTED   = 3;
    public static final int MSG_DEBUG           = 4;
    public static final int MSG_SERVICE_REQUEST = 5;
    public static final int MSG_SERVICE_ACCEPT  = 6;

    public static final int MSG_KEXINIT         = 20;
    public static final int MSG_NEWKEYS         = 21;

    /* Numbers 15-19 for KEX packets.  Different KEX methods may reuse
       message numbers in this range. */
    public static final int FIRST_KEX_PACKET    = 30;

    /* Double encrypting key exchange */
    public static final int MSG_KEXDE_HOSTKEY    = 30;
    public static final int MSG_KEXDE_SESSIONKEY = 31;

    /* Diffie-Hellman key exchange */
    public static final int MSG_KEXDH_INIT       = 30;
    public static final int MSG_KEXDH_REPLY      = 31;

    public static final int FIRST_SERVICE_PACKET = 50;


    /* Packet numbers for the SSH userauth protocol. */
    public static final int FIRST_USERAUTH_PACKET = 50;
    public static final int MSG_USERAUTH_REQUEST  = 50;
    public static final int MSG_USERAUTH_FAILURE  = 51;
    public static final int MSG_USERAUTH_SUCCESS  = 52;
    public static final int MSG_USERAUTH_BANNER   = 53;

    public static final int FIRST_USERAUTH_METHOD_PACKET = 60;
    public static final int LAST_USERAUTH_METHOD_PACKET  = 79;
    public static final int LAST_USERAUTH_PACKET         = 79;


    /* Packet numbers for various authentication methods. */
    /* Password authentication */
    public static final int MSG_USERAUTH_PASSWD_CHANGEREQ   = 60;
    public static final int MSG_USERAUTH_PASSWD_CHANGEREPLY = 61;

    /* Challenge-response authentication */
    public static final int MSG_USERAUTH_CHALLENGE          = 60;

    /* SecurID authentication */
    public static final int MSG_USERAUTH_SECURID_PINREQ     = 60;
    public static final int MSG_USERAUTH_SECURID_PINREPLY   = 61;

    /* Public key authentication */
    public static final int MSG_USERAUTH_PK_OK              = 60;


    /* Packet numbers for the SSH connection protocol. */
    public static final int MSG_GLOBAL_REQUEST              = 80;
    public static final int MSG_REQUEST_SUCCESS             = 81;
    public static final int MSG_REQUEST_FAILURE             = 82;
    public static final int MSG_CHANNEL_OPEN                = 90;
    public static final int MSG_CHANNEL_OPEN_CONFIRMATION   = 91;
    public static final int MSG_CHANNEL_OPEN_FAILURE        = 92;
    public static final int MSG_CHANNEL_WINDOW_ADJUST       = 93;
    public static final int MSG_CHANNEL_DATA                = 94;
    public static final int MSG_CHANNEL_EXTENDED_DATA       = 95;
    public static final int MSG_CHANNEL_EOF                 = 96;
    public static final int MSG_CHANNEL_CLOSE               = 97;
    public static final int MSG_CHANNEL_REQUEST             = 98;
    public static final int MSG_CHANNEL_SUCCESS             = 99;
    public static final int MSG_CHANNEL_FAILURE             = 100;

    public static final int MSG_RESERVED                    = 255;

    /* Debug message types */
    public static final int DEBUG_DEBUG   = 0;
    public static final int DEBUG_DISPLAY = 1;

    /* Disconnection reasons */
    public static final int DISCONNECT_HOST_NOT_ALLOWED_TO_CONNECT    = 1;
    public static final int DISCONNECT_PROTOCOL_ERROR                 = 2;
    public static final int DISCONNECT_KEY_EXCHANGE_FAILED            = 3;
    public static final int DISCONNECT_HOST_AUTHENTICATION_FAILED     = 4;
    public static final int DISCONNECT_MAC_ERROR                      = 5;
    public static final int DISCONNECT_COMPRESSION_ERROR              = 6;
    public static final int DISCONNECT_SERVICE_NOT_AVAILABLE          = 7;
    public static final int DISCONNECT_PROTOCOL_VERSION_NOT_SUPPORTED = 8;
    public static final int DISCONNECT_HOST_KEY_NOT_VERIFIABLE        = 9;
    public static final int DISCONNECT_CONNECTION_LOST		      = 10;
    public static final int DISCONNECT_BY_APPLICATION		      = 11;
    public static final int DISCONNECT_AUTHENTICATION_ERROR	      = 12;

    /* Extended channel data types. */
    public static final int EXTENDED_DATA_STDERR = 1;

    /* Channel open result codes. */
    public static final int OPEN_OK                          = 0;
    public static final int OPEN_ADMINISTRATIVELY_PROHIBITED = 1;
    public static final int OPEN_CONNECT_FAILED              = 2;
    public static final int OPEN_UNKNOWN_CHANNEL_TYPE        = 3;
    public static final int OPEN_RESOURCE_SHORTAGE           = 4;

}
