 /*	socket_netlib.c							*/ " /*	V1.5			20-Jan-1995	IfN/Mey			*/ /*+ %  * SOCKETSHR interface for NETLIB V1.   *D  *	Copyright (c) 1994, 1995 by Eckart Meyer <meyer@ifn.ing.tu-bs.de>  *D  * This module provides a socket interface to NETLIB. SOCKETSHR is a/  * shared image providing the socket interface.   *G  * This is the NETLIB implementation of SOCKETSHR (there are others for N  * native UCX, for Mike O'Malley's LIBCMU and the UNIXSHR library for CMU/IP).  *J  * Note: Most of the code here is stolen from Mike O'Malley's LIBCMU. I'veH  *       made the changes to use NETLIB instead of CMU/IP. Some routines&  *	 have been changed, some are added.'  * 	 Mike's copyright is included here:   */  /*> ** 02-Dec-1998	J. Malmberg	Converted for compilation under GCC. **		    *		Added multiple casts and prototypes" **				that ANSI compilers require.0 **		    *		Changed sys$getsyi() to sys$getsyiw()* **				This will prevent problems with some **				versions of OpenVMS.+ **		    *		Changed sys$qio() to not use the * **				default event flag.  See qioef note. **; **		  **** 		BUG when UDP_POLL or TRACE is defined as true. 0 **				getenv() can not be used inside of a loop.0 **				it does a malloc() each time it is called. **@ ** 12-Mar-1999	J. Malmberg	Fix for compilation under DECC.  Some1 **				constants are not defined.  DECC more picky . **				about mixing long and unsigned long than
 **				GCC. **H ** 15-Mar-1999	J. Malmberg	Compilation errors and warnings when TRACE is **				defined and DECC.  */  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++3  * LIBCMU, Copyright (C) 1993,1994 by Mike O'Malley   *@  * This library is free software; you can redistribute it and/or>  * modify it under the terms of the GNU Library General Public?  * License as published by the Free Software Foundation; either C  * version 2 of the License, or (at your option) any later version.   *B  * This library is distributed in the hope that it will be useful,A  * but WITHOUT ANY WARRANTY; without even the implied warranty of D  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU3  * Library General Public License for more details.   *D  * You should have received a copy of the GNU Library General Public=  * License along with this library; if not, write to the Free E  * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   *  */    /*  * Facility:	SOCKETSHR_NETLIB   *2  * Abstract:	Socket interface routines for NETLIB.  *  * Module Description:D  *	This collection of routines provides the standard `C' programming9  *	interface for Matt Madison's NETLIB network transport.   *  * Routine provided:1  *	int socket(int domain, int type, int protocol) 6  *	int bind(int s, struct sockaddr *name, int namelen)9  *	int connect(int s, struct sockaddr *name, int namelen) "  *	int listen (int s, int backlog)9  *	int accept(int s, struct sockaddr *addr, int *addrlen) 1  *	int recv(int s, char *buf, int len, int flags) 5  *	int recvfrom(int s, char *buf, int len, int flags, )  *			struct sockaddr *from, int *fromlen) 1  *	int send(int s, char *msg, int len, int flags) 3  *	int sendto(int s, char *msg, int len, int flags, $  *			struct sockaddr *to, int tolen)  *	int shutdown(int s, int how)   *D  *	int select(int nfds, int *readfds, int *writefds, int *execptfds,  *			struct timeval *timeout)   *>  *	int getsockname(int s, struct sockaddr *name, int *namelen)>  *	int getpeername(int s, struct sockaddr *name, int *namelen)0  *	int getsockopt(int s, int level, int optname,  *			char *optval, int *optlen) 0  *	int setsockopt(int s, int level, int optname,  *			char *optval, int *optlen) +  *	int gethostname(char *name, int namelen) ,  *	struct hostent *gethostbyname(char *name)?  *	struct hostent *gethostbyaddr(char *addr, int len, int type)   *,  *	int ioctl(int s, int request, void *argp))  *	int fcntl(int s, int request, int arg) 3  *	int writev(int s, struct iovec *iov, int iovcnt)   *6  * The following routines also present in the VAXCRTL:  *&  *	int read(int s, char *buf, int len)2  *	int write(int s, char *msg, int len, int flags)  *	int close(int s)   *	FILE *netlib1_fdopen(int s)  *B  * The following routines may be called from outside this library:#  *	short int netlib1_get_sdc(int s) &  *	int *netlib1_stdin_open(char *name)4  *	int netlib1_stdin_read(flags,buf,len,prompt,mask)%  *	int netlib1_get_errno(long status)   *	int isNetlibSocket(int s)!  *	int netlib1_get_fd(FILE *fptr)   *F  * The following routines should not be accessed outside this library:#  *	int netlib1_listen_accept(int s) "  *	int netlib1_queue_listen(int s)  *	void netlib1_read_ast(int s)    *	void netlib1_write_ast(int s)$  *	int netlib1_queue_net_read(int s)?  *	int netlib1_alloc_socket(int domain, int type, int protocol)   * 	int netlib1_assign(int s)  #ifdef UDP_POLL 1  *	int netlib1_check_udp_receive(int s, int flag)  #endif  *  * Acknowledgements::  *	Guidence, concepts, examples derived from the works of:  *		UNIXSHR		- unknown  *		NETLIB		- Matt Madison, RPI   *		LIBCMU		- Mike O'Malley   *  * SOCKETSHR Author:  *	Eckart Meyer "  *	Institute for Telecommunication'  *	Technical University of Braunschweig   *	Schleinitzstr. 23  *	D-38092 Braunschweig 
  *	Germany  *	<meyer@ifn.ing.tu-bs.de>   *  *  * LIBCMU Author: (LIBCMU V1.2) .  *	Mike O'Malley (mlo)				      September 19939  *	Digital Equipment Corp.			Sandia National Laboratories B  *	Digital Consulting	   Scientific Computing Center, User Support  *	Albuquerque, NM;  *      Mike.OMalley@aqo.mts.dec.com			  mlomall@sandia.GOV   *  *      With modifications by:(  *	 Chen He (che) (617)566-0001 Ext.2919  *	 IDX Systems Corp.   *	 he@chen.idx.com   *  */  #ifdef VAXC  #module SOCKETSHR_NETLIB "V1.0"  #endif  =  /* For the DEC C compiler, need to force the old behavior */ < /*--------------------------------------------------------*/ #ifndef _VMS_V6_SOURCE #define _VMS_V6_SOURCE 1 #endif   /*  * Include files  */    /*K  * If not defined types.h will define it for us.  Don't want to handle more )  * than 32 file descriptors at this time.   */  #define FD_SETSIZE 32    #ifdef __GNUC__  #include <fcntl.h>7 		/* Something wrong with bzero in the LIBGCC I have */ 4 #define bzero(__ptr,__cnt) memset((__ptr),0,(__cnt)) #include <strings.h> #endif #include <stdio.h> #include <errno.h> #include <string.h>    #include <netdb.h>   #include <types.h> #include <ctype.h> #include <time.h>    #ifdef __DECC_VER  #ifdef isdigit #undef isdigit #endif #ifdef __ctype #undef __ctype #endif" #define __ctype (*decc$ga___ctype) #pragma __extern_model __save & #pragma __extern_model __strict_refdef extern const char __ctype [];   #pragma __extern_model __restore #define _D 0x4 #define _X 0x40 , #define isdigit(c)	(__ctype [(c)&0177] & _D)   #ifdef isxdigit  #undef isxdigit  #endif2 #define isxdigit(c)	(__ctype [(c)&0177] & (_D|_X))   #endif   #include <file.h>  #include <ioctl.h> #include <socket.h>    /* #include <if.h> */ /**/ #include <in.h>    #include <ssdef.h> #include <descrip.h> #include <lnmdef.h>  #include <msgdef.h>  #include <iodef.h> #include <ttdef.h> #include <tt2def.h>  #include <syidef.h>    #ifndef __DECC_VER #include <malloc.h>  #else  #include <stdlib.h>  #include <fcntl.h> #endif #include <unixio.h> 
 #ifndef FREAD  #define FREAD F_RDLCK  #endif #ifndef FEXLOCK  #define FEXLOCK (00400)  #endif #ifndef FWRITE #define FWRITE F_WRLCK #endif  K  /* VMS System Services and Runtime library prototypes to help optimizer */ J /*----------------------------------------------------------------------*/ unsigned long sys$assign/        (const struct dsc$descriptor_s * devnam,  	unsigned short * chan,  	unsigned long acmode,( 	const struct dsc$descriptor_s * mbxnam, 	unsigned long flags);   unsigned long sys$bintim/        (const struct dsc$descriptor_s * timbuf,  	void * timadr);   unsigned long sys$cantim        (unsigned long reqidt,  	unsigned long acmode);   + unsigned long sys$clref(unsigned long efn);   . unsigned long sys$dassgn(unsigned short chan);   unsigned long sys$getsyiw         (unsigned long efn, 	unsigned long * csidadr, * 	const struct dsc$descriptor_s * nodename, 	void * itmlst, 
 	void * iosb,  	void (* astadr)(),  	unsigned long astprm);   ( unsigned long sys$gettim(void * timadr);   unsigned long sys$qio         (unsigned long efn,9 	unsigned short chan,	/* Docs are wrong, this is right */  	unsigned long func,
 	void * iosb,  	void (* astadr)(),  	...);  C unsigned long sys$readef(unsigned long efn, unsigned long * state);   + unsigned long sys$setef(unsigned long efn);    unsigned long sys$setimr        (unsigned long efn, 	const void * daytim,  	void (* astadr)(),  	unsigned long reqidt, 	unsigned long flags);  , unsigned long sys$waitfr(unsigned long efn);  ? unsigned long sys$wflor(unsigned long efn, unsigned long mask);   5 unsigned long lib$free_ef(const unsigned long * efn); . unsigned long lib$get_ef(unsigned long * efn);0 unsigned long lib$stop(unsigned long cond, ...);   unsigned long str$copy_r(        (struct dsc$descriptor * deststr, 	const unsigned short * srclen,  	const char * srcstr);  8 unsigned long str$free1_dx(struct dsc$descriptor * str); unsigned long str$get1_dx &        (const unsigned short * wrdlen, 	struct dsc$descriptor * str);   /*  * And a NETLIB specific header   */  #include "socket_netlib.h"   /*  * NETLIB specific definitions  */  #define	NET_K_TCP	1  #define	NET_K_UDP	2  #define NET_M_PUSH	1 #define	NET_M_NOTRM	2    int net_assign(void * socket);  int net_deassign(void * socket);@ int net_bind(void * socket, int, unsigned short port, int, int); int net_get_info        (void * socket, 	unsigned long * remaddr,  	int * remport,  	unsigned long * lcladr, 	int * lclport);@ int tcp_connect_addr(void * socket, int * to_addr, int to_port); int udp_send        (void * socket, 	unsigned long to_addr,  	int for_port, 	char * msg,
 	int len); int tcp_send        (void * socket,# 	struct dsc$descriptor * write_dsc,  	int flags,  	IO_Status_Block * iosb, 	void (* astadr)(),  	unsigned long astprm);  int net_get_hostname)        (struct dsc$descriptor * host_dsc,  	int * ret_size);  int net_get_address         (void * ctx, " 	struct dsc$descriptor * host_dsc,
 	int maxaddr,  	struct in_addr * addrs, 	int * ret_size);  int net_addr_to_name        (void * namctx, 	unsigned long laddr, # 	struct dsc$descriptor * host_dsc);  int tcp_disconnect(void * ctx);  int tcp_accept        (void * ctx,  	void * accept_ctx,  	IO_Status_Block * iosb, 	int (* astadr)(), 	unsigned long astprm);  int udp_receive         (void * ctx,  	char * rcvbuf,  	int rcvbufsize, 	unsigned short * byte_count,  	unsigned long * addr, 	unsigned short * port,  	long * timeout, 	IO_Status_Block * iosb, 	void (* astadr)(),  	unsigned long astprm);  int tcp_receive         (void * ctx, " 	struct dsc$descriptor * read_dsc, 	IO_Status_Block * iosb, 	void (* astadr)(),  	unsigned long astprm, 	long * timeout);  /*  * Common include   */  #include "[-]si_socket.h"  #ifdef TRACE4   unsigned long int __ntohl( unsigned long int __n);*   char * __inet_ntoa(struct in_addr __in); #endif   /*  * TRACE  */  /* #undef TRACE */ /**/ # /* #define FTRACE__  stdout */ /**/  #include "[-]si_trace.h"    3 unsigned short int ntohs ( unsigned short int __n); 3 unsigned short int htons ( unsigned short int __n);      /*  * forward declarations   */ # int netlib1_get_errno(long status); G int __trnlnm(char *table, char *name, char *mode, char *buff, int len); ! int netlib1_listen_accept(int s);   int netlib1_queue_listen(int s); void netlib1_read_ast(int s);  void netlib1_write_ast(int s);" int netlib1_queue_net_read(int s);= int netlib1_alloc_socket(int domain, int type, int protocol);  int netlib1_assign(int s); #ifdef UDP_POLL / int netlib1_check_udp_receive(int s, int flag);  #endif! short int netlib1_get_sdc(int s);  int isNetlibSocket(int s); int netlib1_get_fd(FILE *fptr);    FILE *netlib1_fdopen(int s); int netlib1_close(int s); F int netlib1_getsockname(int s, struct sockaddr * name, int * namelen); int netlib1_recvfrom        (int s, 	char * buf,	 	int len,  	int flags,  	struct sockaddr * from, 	int * fromlen); int netlib1_sendto        (int s, 	char * msg,	 	int len,  	int flags,  	struct sockaddr * to, 	int tolen);   #define isSocket isNetlibSocket  #define get_fd netlib1_get_fd    /*  * Global static variables  */    /*$  * Our private file descriptor table  */ ' static struct FD_ENTRY *sd[FD_SETSIZE];    /*2  * for system information call to get MAXBUF size.  */  static int MAXBUF;% static struct ITEM_LIST syinfo[2] = {   	{ 4, SYI$_MAXBUF, &MAXBUF, 0 },! 	{ 0,           0,       0, 0 }};    /*4  * File descriptor mask to keep track of i/o events.  */ . static fd_set sys_validfds;	/* is sd valid		*/4 static fd_set sys_readfds;	/* is sd ready to read	*/6 static fd_set sys_writefds;	/* is sd ready to write */7 static fd_set sys_exceptfds;	/* does sd have an error*/  #ifdef UDP_POLL / static fd_set sys_udpfds;	/* is sd an UDP sd	*/  #endif   #define MAX_INADDR 20     static	struct hostent inet_host;, static	struct in_addr inet_list[MAX_INADDR];, static	struct in_addr *addrlist[MAX_INADDR];B static	char inet_name[128];	/* storage for official name string */ static	char *null_ptr = NULL;    /*7  * Accept event flag so we know when a request comes in   */ " /* static int accept_net_event; */   /*4  * 'NETLIB loaded' flag for the channel number hack.  */ 
 #define CMU 2  static int netlib_loaded = 0;    /*G  * for feof() and ferror() to work we have to set the appropriate flags H  * in the FILE structure. Note these macros depend on the implementationB  * of the structure. However, it seems the _flag item has not beenJ  * modified since ever in VAXC and is still used in the same way in DEC C.  */ N #define SET_FPTR(flg) if (sd[s]->fptr != NULL) (*sd[s]->fptr)->_flag |= (flg);O #define CLR_FPTR(flg) if (sd[s]->fptr != NULL) (*sd[s]->fptr)->_flag &= ~(flg);    /*  * 03-Dec-1998	J. MalmbergB  * Because any call that uses an event flag will set and clear it,C  * Digital support has recommended that event flag 0 not be used in D  * asynchronous routines.  At the best it causes extra CPU overhead,?  * but under some rare conditions a bug could be triggered.  To C  * prevent against this, an event flag will be reserved for the qio   */  static unsigned long qioef = 0;     P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *?  * int netlib1_alloc_socket(int domain, int type, int protocol)   *  * Description: *  *	Internal routine. Allocates the socket.  *  * Returns: N  *  If successful a socket number is returned, otherwise, a -1 is returned and  *  errno is set.   */ . int netlib1_alloc_socket(domain,type,protocol) int domain,type,protocol;  {    int	s;       /*)      * Verify the address family (domain)       */      if ( domain != AF_INET ) { 	/* . 	 * we don't handle any other address formats. 	 */ 	errno = EAFNOSUPPORT; 	return(-1);     }        /*;      * Use the dup() routine to aquire a unique discriptor. #      * Make sure it's in our range.       */ N     /* s = dup(0); */ /* Samba is now sometimes closing 0, breaks this bad! */      s = open("NLA0:", O_RDONLY);     if (s<0) 	return(-1);+     else if ((s < 0) || (s > FD_SETSIZE)) {  	errno = ENFILE;
 	return (-1);      }      FD_SET(s,&sys_validfds);       /*C      * Allocate a file descriptor data structure and initialize it.       */ D     sd[s] = (struct FD_ENTRY *) calloc( 1, sizeof(struct FD_ENTRY));     sd[s]->domain	= domain;      sd[s]->type		= type;       /*1      * If not specified select a default protocol       */ !     if (protocol == IPPROTO_IP) {  	switch(type) {  	    case SOCK_STREAM :   		sd[s]->protocol	= IPPROTO_TCP; 		break; 	    case SOCK_DGRAM :
 	    default:   		sd[s]->protocol	= IPPROTO_UDP; 	}     }      else 	switch(protocol) {  	    case IPPROTO_TCP: 	    case IPPROTO_UDP: 		sd[s]->protocol = protocol;  		break;
 	    default:  		netlib1_close(s);  		errno = EPROTONOSUPPORT;
 		return(-1);V 	}  0     sd[s]->read_dsc.dsc$b_dtype = DSC$K_DTYPE_T;0     sd[s]->read_dsc.dsc$b_class = DSC$K_CLASS_D;%     sd[s]->read_dsc.dsc$w_length = 0;s.     sd[s]->read_dsc.dsc$a_pointer = (char *)0;1     sd[s]->write_dsc.dsc$b_dtype = DSC$K_DTYPE_T;v1     sd[s]->write_dsc.dsc$b_class = DSC$K_CLASS_S;T       /*O      * grab the OpenVMS SYSGEN parameter MAXBUF and set the default buffer sizeL2      * to the minimum of *_SO_RCVBUF_DEF or MAXBUF      *      */c     if (MAXBUF == 0) {6 	vaxc$errno = sys$getsyiw( 0, 0, 0, &syinfo, 0, 0, 0);  	if (vaxc$errno != SS$_NORMAL) { 		netlib1_close(s);e 		errno = EVMSERR;
 		return(-1);	 	} 	MAXBUF -= 128;i     }   '     if (sd[s]->protocol == IPPROTO_TCP)g 	sd[s]->rcvbufsize =; 			MAXBUF < TCP_SO_RCVBUF_DEF ? MAXBUF : TCP_SO_RCVBUF_DEF;s     else 	sd[s]->rcvbufsize =; 			MAXBUF < UDP_SO_RCVBUF_DEF ? MAXBUF : UDP_SO_RCVBUF_DEF;	       /*7      * get and clear an event flag and file descriptor.*      */C     if (sd[s]->ef == 0)s 	lib$get_ef(&sd[s]->ef);     sys$clref(sd[s]->ef);*     FD_CLR(s, &sys_readfds);       /*,      * get file pointer for stream routines.      */i      sd[s]->fptr = fdopen(s,"r");H     (*sd[s]->fptr)->_file = s;	/* backlink, enables standard fileno() */       return(s); }. oP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *  * int netlib1_assign(int s)  *  * Description: 6  *	Internal routine. Assigns a channel to the network.  *  * Returns: P  *  If successful the socket number is returned, otherwise, a -1 is returned and  *  errno is set.B  */C int netlib1_assign(s)b int s; {l $DESCRIPTOR(dev,"NLA0:");s char name[128];o     /*I      * What comes here is really a hack: since NETLIB doesn't give us theaE      * VMS channel number, only a NETLIB internal context pointer, weeE      * allocate a VMS channel, store it away and release the channel. :      * We then *hope* NETLIB will grab the same channel...I      * If this is the first call to NETLIB, one channel is used to accessyL      * the NETLIB shared image. In this case we call net_assign/net_deassignF      * only to bring in the image. I've heard there is an undocumentedF      * system service to load a sharable image, but this works too and      * is only called once.t      *      */*     if (!netlib_loaded) {  	netlib_loaded = 1;g 	net_assign(&sd[s]->ctx); < 	__trnlnm( "LNM$FILE_DEV", "NETLIB_SHR", "USER", name, 128);6 	if (strstr(name, "CMU") != NULL) netlib_loaded = CMU;/ 	DTRACE("  --",0,"NETLIB: %d",netlib_loaded,0);  	net_deassign(&sd[s]->ctx);i     }e  )     sys$assign(&dev, &sd[s]->chan,0,0,0);      sys$dassgn(sd[s]->chan);  )     vaxc$errno = net_assign(&sd[s]->ctx);l#     if (vaxc$errno != SS$_NORMAL) {r 	netlib1_close(s); 	errno = EVMSERR;t 	return(-1);     }n     return(s); }  iP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>n  * #include <socket.h>  *1  * int socket(int domain, int type, int protocol),  *  * Description:r'  *	Creates an endpoint of a connection.t  *H  * domain   - AF_INET is the only address domain supported at this time.'  * type     - SOCK_STREAM or SOCK_DGRAMrM  * protocol - IPPROTO_TCP, IPPROTO_UDP.  If IPPROTO_IP (default) is specified 5  *	      protocol will be chosen that matches `type'.c  *  * Returns:tN  *  If successful a socket number is returned, otherwise, a -1 is returned and  *  errno is set.t  */s( int netlib1_socket(domain,type,protocol) int domain,type,protocol;  {n int	s;       /*      * allocate a socket      */k4      s = netlib1_alloc_socket(domain,type,protocol);       /*-      * assign a channel to the network devicen      */r      s = netlib1_assign(s);aG      STRACE("netlib1_socket",0,s,"returned, chan: %04X",sd[s]->chan,0);       return(s);l }t  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>i  * #include <socket.h>  *6  * int bind(int s, struct sockaddr *name, int namelen)  *  * Description: F  *	binds a name (address/port) to a socket.  Socket (s) must have been  * created with call to socket.1  *$  * s       - valid socket descriptorJ  * name	   - address of sockaddr structure for local host port information2  * namelen - length of the name structure in bytes  *  * Returns:rI  *	0 on success, -1 on error.  Addition error information is specified ini  * the global variable errno.t  */i #ifdef __DECC_VERr!     static int get_random_port();h #endif    int netlib1_bind(s,name,namelen)  int			s;	/* socket to bind to	*/) struct sockaddr		*name;	/* name stuff		*/v( int			namelen;/* length of name stuff	*/ {_ int	status;  /* int	protocol; */e4 struct	sockaddr_in *my = (struct sockaddr_in *)name; /* struct	sockaddr_in tmp; */   5     STRACE("netlib1_bind",0,s,"addr: %08X, port: %d",n1 	ntohl(my->sin_addr.s_addr),ntohs(my->sin_port));      /*)      * Verify the address family (domain)a      */i'     if ( name->sa_family != AF_INET ) {k 	/* . 	 * we don't handle any other address formats. 	 */ 	errno = EAFNOSUPPORT; 	return(-1);     }        /*      * check for valid socket.      */n     if (sd[s] == NULL) { 	errno = EBADF;n 	return(-1);     }2       /*       * see if it's already named      */e!     if (sd[s]->flags & SD_BIND) {M 	errno = EINVAL; 	return(-1);     }        /*      * copy/save sockaddr info..      */      sd[s]->mylen = namelen;g&     memcpy(&sd[s]->my, name, namelen);*     my = (struct sockaddr_in *)&sd[s]->my;       /*H      * If the bind is to a connectionless mode socket (IPPROTO_UDP) then      * OPEN the channel.      */5)     if (sd[s]->protocol == IPPROTO_UDP) {* 	/*c" 	 * Open the communication channel 	 */H 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_UDP, ntohs(my->sin_port),1,1);  	if (vaxc$errno != SS$_NORMAL) {+ 	    errno = netlib1_get_errno(vaxc$errno);- 		/* How to Abort ? */F 	    DTRACE("  --",0,"ERROR status:%08X, errno: %d",vaxc$errno,errno); 	    FD_SET(s,&sys_exceptfds); 	    sys$setef(sd[s]->ef); 	    return(-1); 	}  3 	netlib1_getsockname(s, &sd[s]->my, &sd[s]->mylen); : 	DTRACE("  --",0,"actual port: %d",ntohs(my->sin_port),0);   	FD_SET(s,&sys_writefds);  	FD_CLR(s,&sys_exceptfds);   	sd[s]->flags |= SD_CONNECTED;   	/*p 	 * queue a read to the socket 	 */$ 	status = netlib1_queue_net_read(s); 	if (status != 0)< 	    return(-1);     }e; /*  Michael Stenn's fix to the port allocation bug ..... */i     else {   /* tcp ports */          if (my->sin_port == 0) {              void *socket = NULL;1             unsigned long remadr = 0, lcladr = 0;a(             int remport = 0, lclprt = 0;                net_assign(&socket);2             net_bind(&socket, NET_K_TCP, 0, 0, 0);H             net_get_info (&socket, &remadr, &remport, &lcladr ,&lclprt);#             net_deassign (&socket);i4             if (!lclprt) /* AFAIK only if OpenCMU */                { #ifndef __DECC_VER  		 static int get_random_port(); #endifJ                  my->sin_port = htons (s + get_random_port (30001,65000));                }             else'                  my->sin_port = lclprt;eE             DTRACE("  --",0,"actual port: %d",ntohs(my->sin_port),0);h	         }e  * /*  --- End of Michael Stenn's fix ---- */  0 /* Old code to fake the port number where needed
     else { 	if (my->sin_port == 0) {n(            unsigned int current_time[2];$            sys$gettim(current_time);  E            my->sin_port = htons(current_time[0] % 32767 + 30000 + s);n	         }i */       }p       sd[s]->flags |= SD_BIND;     return(0); }-    B /* Generate a random port number  between min_port and max_port */7 static int get_random_port (int min_port, int max_port)s {e!     unsigned int current_time[2];m     int port = min_port;       if (max_port > min_port) {"         sys$gettim (current_time);8         port += current_time[0] % (max_port - min_port);     }a8     DTRACE("  --",0,"Random port: %d generated",port,0);     return port; }g mP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *9  * int connect(int s, struct sockaddr *name, int namelen)c  *  * Description:i&  *	initiates a connection on a socket.  *$  * s       - valid socket descriptor@  * name	   - pointer to an address structure for the remote port2  * namelen - length of the name structure in bytes  *  * Returns:hI  *	0 on success, -1 on error.  Addition error information is specified inb  * the global variable errno.;  */n# int netlib1_connect(s,name,namelen)e int s; struct sockaddr *name; int namelen; {$ /* int	status; */  int	to_addr, to_port, my_port; struct	sockaddr_in *p;     /*?      * Verify the address family (domain) we are to connect to.d      */g'     if ( name->sa_family != AF_INET ) {t 	/*s. 	 * we don't handle any other address formats. 	 */ 	errno = EAFNOSUPPORT; 	return(-1);     }n       /*      * check for valid socket       */d     if (sd[s] == NULL) { 	errno = EBADF;i 	return(-1);     }s       /*$      * see if it's already connected      */ -     if ((sd[s]->flags & SD_CONNECTED) != 0) {g 	errno = EISCONN;  	return(-1);     }r       /*&      * copy/save remote sockaddr info.      */r     sd[s]->tolen = namelen; &     memcpy(&sd[s]->to, name, namelen);  *     p = (struct sockaddr_in *) &sd[s]->to;!     to_addr = p->sin_addr.s_addr;i!     to_port = ntohs(p->sin_port);N*     p = (struct sockaddr_in *) &sd[s]->my;!     my_port = ntohs(p->sin_port);d=     STRACE("netlib1_connect",0,s,"local port: %d",my_port,0);i     STRACE("netlib1_connect",v8 		0,s,"-- addr: %08X, port: %d",ntohl(to_addr),to_port);     /*,      * Open and connect to the remote system      */,)     if (sd[s]->protocol == IPPROTO_TCP) {t< 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_TCP, my_port,1,1); 	if (vaxc$errno == SS$_NORMAL)C 	    vaxc$errno = tcp_connect_addr(&sd[s]->ctx, &to_addr, to_port);o     }d
     else {< 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_UDP, my_port,0,1);     }e#     if (vaxc$errno != SS$_NORMAL) {c' 	errno = netlib1_get_errno(vaxc$errno);, 	return(-1);     }        /*'      *  Get the real local port number.       */u      if (my_port == 0) {( 	sd[s]->mylen = sizeof(struct sockaddr);1 	netlib1_getsockname(s,&sd[s]->my,&sd[s]->mylen);*      }       /*K      * Now queue a read on the socket.  If the connect failed then the read !      * will also fail right away.o      */ !     if (vaxc$errno == SS$_NORMAL))' 	if ((netlib1_queue_net_read(s)) == -1)  	    return(-1);       /*L      * could there be a timing problem here?  Will the read AST complete (onN      * error) before the next statement?  Lets wait a sec anyway just in case.      */u /*    sleep(1); */ /**/   .     vaxc$errno = sd[s]->read_iosb.iosb_status;       /*<      * 0 = read in progress, 1 = read complete data waiting.      */u1     if ((vaxc$errno != 0) && (vaxc$errno != 1)) {o9 	errno = netlib1_get_errno(sd[s]->read_iosb.iosb_status);B 	FD_SET(s,&sys_exceptfds); 	sys$setef(sd[s]->ef); 	return(-1);     }u       FD_SET(s,&sys_writefds);     FD_CLR(s,&sys_exceptfds);   !     sd[s]->flags |= SD_CONNECTED;t     return(0); }i _P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *"  * int listen (int s, int backlog)  *  * Description: I  *	Sets the maximum limit of outstanding connection requests for a socket   * that is connection-oriented.(  *7  * s	   - a valid socket descriptor of type SOCK_STREAM E  * backlog - maximum number of pending connections that may be queuedh  *  * Returns:oI  *	0 on success, -1 on error.  Addition error information is specified in_  * the global variable errno.i  */a int netlib1_listen(s,backlog)i int s; int backlog; {b struct sockaddr_in *my; :      STRACE("netlib1_listen",0,s,"backlog: %d",backlog,0);     /*      * check for valid socketU      */      if (sd[s] == NULL) { 	errno = EBADF;a 	return(-1);     }n  K     if ((sd[s]->protocol != IPPROTO_TCP) || (sd[s]->type != SOCK_STREAM)) {  	errno = EOPNOTSUPP; 	return(-1);     }n       sd[s]->backlog = backlog;lD     sd[s]->sock_opts |= SO_ACCEPTCONN;	/* socket has had listen() */       /*B      * Allocate an event flag used to signal a blocked accept call      */r' /*    lib$get_ef(&accept_net_event); */e% /*    sys$clref(accept_net_event); */t     sys$clref(sd[s]->ef);c       /*'      * Clear the listen file descriptori      */c     FD_CLR(s,&sys_readfds);g       /*9      * Set socket to passive TCP on specified bound port.f      */i*     my = (struct sockaddr_in *)&sd[s]->my;K     vaxc$errno = net_bind(&sd[s]->ctx, NET_K_TCP, ntohs(my->sin_port),1,0); #     if (vaxc$errno != SS$_NORMAL) {T' 	errno = netlib1_get_errno(vaxc$errno);, 	return(-1);     }      /*      * Queue the socket listen      */i%     if (netlib1_queue_listen(s) == 0)  	return(0);f     else 	return(-1); }d   dP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *9  * int accept(int s, struct sockaddr *addr, int *addrlen)t  *  * Description:s$  *	Accepts a connection on a socket.  *(  * s	   - valid socket that is listeningQ  * addr	   - sockaddr address structure filled with information from the acceptedd  *           connectionc1  * addrlen - length of returned address structures  *  * Returns:cH  *	Nonnegative integer that is the descriptor for the accepted socket orF  * -1 on error.  Addition error information is specified in the global  * variable errno.  */n% int netlib1_accept( s, addr, addrlen)  int	s; struct	sockaddr *addr;
 int	*addrlen;o {  int	ns, status;o struct	backlogEntry *entry;i  H     STRACE("netlib1_accept",0,s,"backlogSize: %d",sd[s]->backlogSize,0);     /*      * check for valid socket       */t     if (sd[s] == NULL) { 	errno = EBADF;c 	return(-1);     }        /*!      * see if socket is listeningd      */_2     if ((sd[s]->sock_opts & SO_ACCEPTCONN) == 0) { 	errno = EBADF;d 	return(-1);     }f       /*      * see if anything is thereg      */) /* CHECK_QUEUE: */     /*2      * check the socket for incomming connections.      */t+     if (!(FD_ISSET(s,&sys_readfds))) { /**/e. /*      if (sd[s]->backlogSize == 0) { */ /**/ 	/*u 	 * block if necessary 	 */+ 	if ((sd[s]->ioctl_opts & O_NDELAY) == 0) {a' /*	    sys$waitfr(accept_net_event); */T 	    sys$waitfr(sd[s]->ef);a 	    /*l& 	     * see if the socket was shutdown 	     */, 	    if ((sd[s]->ioctl_opts & FREAD) != 0) { 		return(0); 	    } 	} 	else {+ 	    errno = EWOULDBLOCK;+ 	    return(-1); 	}     }#       /*      * Clear the event flaga      */e* /*    sys$clref(accept_net_event); */ /**/     sys$clref(sd[s]->ef);a     FD_CLR(s,&sys_readfds);e       /*4      * remove the first entry from the backlog queue      */r      entry = sd[s]->backlogQueue;'     sd[s]->backlogQueue = entry->flink;k       /*7      * save the socket number and free the backlogEntry       */      ns = entry->sock;s     cfree(entry);        /*6      * queue the first read to the accepted connection      */e(     status = netlib1_queue_net_read(ns);     if (status != 0) 	return(-1);       /*:      * fill in addr with the connecting entity information      */u     if (addr != NULL) D     	memcpy (addr,&(sd[ns]->to), (*addrlen < sizeof(struct sockaddr). 				   ? *addrlen : sizeof(struct sockaddr)));       /*,      * give the user a new socket descriptor      */_     return(ns);r }= FP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>a  * #include <socket.h>  *1  * int recv(int s, char *buf, int len, int flags)l  *  * Description:F)  *	Receive bytes from a connected socket.   *!  * s	 - a valid socket descriptor*9  * buf	 - address of buffer to where input data is placed   * len	 - max size of buf *  * flags - 0 or MSG_PEEK may be specified.  *  * Returns:oE  *	Number of bytes read from the socket, -1 on error.  Addition error	9  * information is specified in the global variable errno.c  */t! int netlib1_recv(s,buf,len,flags)  int	s;
 char	*buf; int	len, flags;o { @     STRACE("netlib1_recv",0,s,"len: %d, flags: %08X",len,flags);     /*      * check for valid socket}      */d     if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }s       /*      * Must be connected      */s+     if ((sd[s]->flags & SD_CONNECTED) != 0)$/ 	return(netlib1_recvfrom(s,buf,len,flags,0,0));b
     else { 	errno = EBADF;  	return(-1);     }b }a =P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>z  * #include <socket.h>  *5  * int recvfrom(int s, char *buf, int len, int flags,A)  *			struct sockaddr *from, int *fromlen)   *  * Description:00  *	receives bytes from a socket from any source.  *!  * s	 - a valid socket descriptor-9  * buf	 - address of buffer to where input data is placedo  * len	 - max size of buf>*  * flags - 0 or MSG_PEEK may be specified.M  * from	 - address of sockaddr structure address of the socket which the data_K  *         is received from.  May be specified as 0; no information will bea  *         returned./  * fromlen - length of from structure returned.   *  * Returns:]E  *	Number of bytes read from the socket, -1 on error.  Addition error 9  * information is specified in the global variable errno.   */d2 int netlib1_recvfrom(s,buf,len,flags,from,fromlen) int	s;
 char	*buf; int	len, flags;f struct	sockaddr *from;
 int	*fromlen;* {+ int	size, offset;+ /* struct	sockaddr_in *frm; */ struct	sockaddr_in *rcv;  D     STRACE("netlib1_recvfrom",0,s,"len: %d, flags: %08X",len,flags);     /*      * check for valid socket*      */r     if (sd[s] == NULL) { 	errno = EBADF;s 	return(-1);     }      CLR_FPTR(_IOERR | _IOEOF);       /*+      * make sure the socket is not shutdownS      */e+     if ((sd[s]->ioctl_opts & FREAD) != 0) {* 	errno = EPIPE;i 	goto recvfrom_ioerr;N     }o       /*5      * if the user want's nothing, return immediatelyr      */x     if (len == 0) return(0);   #ifdef UPD_POLLo     /*      * NETLIB prior to V1.7:E      * Since NETLIB's udp_receive does not support AST's, we must tryhG      * to read here with immediate return if nothing has been received.e      */h)     if (sd[s]->protocol == IPPROTO_UDP) {/H 	netlib1_check_udp_receive(s,0);	/* No AST's with UDP, check manually */     }t #endif  
 CHECKforDATA:      /*C      * check for a socket error (if the socket read has completed!)t      */ + /*    if (FD_ISSET(s,&sys_readfds)) */ /**/_,     if (sd[s]->read_iosb.iosb_status != 0) {2 	if (sd[s]->read_iosb.iosb_status != SS$_NORMAL) {= 	    errno = netlib1_get_errno(sd[s]->read_iosb.iosb_status);DD 	    STRACE("netlib1_recvfrom",0,s,"ERROR, status: %08X, errno: %d",& 		sd[s]->read_iosb.iosb_status,errno);, /* sd[s]->read_iosb.iosb_status = 0; */ /**/: 	    if (sd[s]->read_iosb.iosb_status == SS$_LINKDISCON) { 		SET_FPTR(_IOEOF);M 		return(0); 	    } 	    if (errno == ECONNRESET) {( 		SET_FPTR(_IOEOF);u
 		return(-1);  	    } 	    goto recvfrom_ioerr;+ 	}     }+       /*N      * Check the file descriptor for data ready on the socket. Block or return"      * based on data availability.      */,&     if (!(FD_ISSET(s,&sys_readfds))) {$ 	if (sd[s]->ioctl_opts & O_NDELAY) { 	    errno = EWOULDBLOCK;d 	    goto recvfrom_ioerr;h 	} 	else {t #ifdef UDP_POLLR* 	    if (sd[s]->protocol == IPPROTO_UDP) {? 		netlib1_check_udp_receive(s,1);	/* No AST's with UDP, wait */p 	    } #endif 	    sys$waitfr(sd[s]->ef);  	    goto CHECKforDATA;s 	}     }        /*3      * move the from data if the user asked for it.       */s     if (from != NULL) {o- 	rcv = (struct sockaddr_in *)&sd[s]->rcvfrom;t, 	size = (sizeof(struct sockaddr) < *fromlen)) 				? sizeof(struct sockaddr) : *fromlen;s 	memcpy(from, rcv, size);; 	*fromlen = size;a     }        /*A      * data is ready on the socket.  copy it to the users buffer.SJ      * there could be data remaining in the receive buffer from a previousO      * read or more data in the receive buffer than what would fit in the users+      * buffer.      */l8     STRACE("netlib1_recvfrom",0,s,"available: %d bytes",) 					sd[s]->read_iosb.iosb_byte_count,0);*3     size = len < sd[s]->read_iosb.iosb_byte_count ? , 					len : sd[s]->read_iosb.iosb_byte_count;!     offset = sd[s]->rcvbufoffset;   .     memcpy(buf, &sd[s]->rcvbuf[offset], size);       /*N      * if this is just a peek then return without fixing up the byte count and      * offset things.       */s      if ((flags & MSG_PEEK) != 0) 	return (size);n       /*M      * now fix up the byte count in the iosb.  If there is and data left then       * set the offset.      */e-     sd[s]->read_iosb.iosb_byte_count -= size;	0     if (sd[s]->read_iosb.iosb_byte_count == 0) { 	/*n= 	 * The receive buffer has been drained; reset the offset andn 	 * queue another read.o 	 */ 	sd[s]->rcvbufoffset = 0;( 	netlib1_queue_net_read(s);*     }	     else 	sd[s]->rcvbufoffset += size;b       /*G      * return the number of bytes that were copied to the users buffer.t      */ >     STRACE("netlib1_recvfrom",0,s,"returned %d bytes",size,0);     return (size);   recvfrom_ioerr:      SET_FPTR(_IOERR);n     return(-1);o }t  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>   * #include <socket.h>  *1  * int send(int s, char *msg, int len, int flags)*  *  * Description:n5  *	Send bytes through a socket to its connected peer.r  *!  * s	 - a valid socket descriptor .  * buf	 - address of buffer of data to be sent  * len	 - size of bufm*  * flags - 0 or MSG_PEEK may be specified.  *  * Returns:uF  *	Number of bytes written to the socket, -1 on error.  Addition error9  * information is specified in the global variable errno.h  */.! int netlib1_send(s,msg,len,flags)  int	s;
 char	*msg; int	len, flags;e {m@     STRACE("netlib1_send",0,s,"len: %d, flags: %08X",len,flags);     /*      * check for valid socketv      */      if (sd[s] == NULL) { 	errno = EBADF;e 	return(-1);     }	       /*      * Must be connected      */R+     if ((sd[s]->flags & SD_CONNECTED) != 0);- 	return(netlib1_sendto(s,msg,len,flags,0,0));f
     else { 	errno = EBADF;; 	return(-1);     }o }a sP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>s  * #include <socket.h>  *3  * int sendto(int s, char *msg, int len, int flags,/$  *			struct sockaddr *to, int tolen)  *  * Description:_3  *	Send bytes through a socket to any other socket.1  *!  * s	 - a valid socket descriptort.  * buf	 - address of buffer of data to be sent  * len	 - size of buf   * flags - none supported.H  * to	 - address of sockaddr structure which contains the address of the+ 	   socket which the data is to be written. -  * tolen - length of from structure returned.   *  * Returns:oF  *	Number of bytes written to the socket, -1 on error.  Addition error9  * information is specified in the global variable errno.c  */i, int netlib1_sendto(s,msg,len,flags,to,tolen) int	s;
 char	*msg; int	len, flags;_ struct	sockaddr *to;
 int	tolen; {r struct	sockaddr_in *too;" static unsigned long write_ef = 0;  B     STRACE("netlib1_sendto",0,s,"len: %d, flags: %08X",len,flags);     /*      * check for valid socket       */T     if (sd[s] == NULL) { 	errno = EBADF;i 	return(-1);     }      CLR_FPTR(_IOERR | _IOEOF);       /*+      * make sure the socket is not shutdown       */d,     if ((sd[s]->ioctl_opts & FWRITE) != 0) { 	errno = EPIPE;  	goto sendto_ioerr;      }        /*O      * in a UDP environment we could get to this point without actually opening0K      * the communication channel via bind.  It might be cause the user onlyu!      * wants a send only channel.m      */b-     if ((sd[s]->flags & SD_CONNECTED) == 0) {t7 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_UDP, 0, 0,1);n  	if (vaxc$errno != SS$_NORMAL) {+ 	    errno = netlib1_get_errno(vaxc$errno);n 	    goto sendto_ioerr;t 	}     /*'      *  Get the real local port number.       */ /         sd[s]->mylen = sizeof(struct sockaddr); 8         netlib1_getsockname(s,&sd[s]->my,&sd[s]->mylen);   	sd[s]->flags |= SD_CONNECTED;   	FD_SET(s,&sys_writefds);+ 	FD_CLR(s,&sys_exceptfds);     }h       /*/      * check the target domain (address family)t      */      if (to != NULL)   	if (to->sa_family != AF_INET) { 	    errno = EAFNOSUPPORT; 	    goto sendto_ioerr;c 	}       /*"      * record who we sent it to...      */e     if (to != NULL) {* 	sd[s]->tolen = tolen; 	memcpy(&sd[s]->to, to, tolen);R     }h  +     too = (struct sockaddr_in *)&sd[s]->to;   9 /* My CMUIP doesn't like zero length writes... IfN/Mey */      if (len == 0) return(0);       /*-      * get an event flag specific for writing;      */i     if (write_ef == 0) 	lib$get_ef(&write_ef);t       /*<      * Clear the system write ready fds and queue the write.C      * For UDP, NETLIB does not support AST's, so we simply wait...       */s     FD_CLR(s,&sys_writefds);)     if (sd[s]->protocol == IPPROTO_UDP) {P# 	vaxc$errno = udp_send(&sd[s]->ctx, 0 		too->sin_addr.s_addr,	/* address to send to */* 		ntohs(too->sin_port),	/* foreign port */% 		msg,			/* message buffer address */t 		len);			/* message length */, 	sd[s]->write_iosb.iosb_status = vaxc$errno;     }o
     else {& 	sd[s]->write_dsc.dsc$a_pointer = msg;% 	sd[s]->write_dsc.dsc$w_length = len;*# 	vaxc$errno = tcp_send(&sd[s]->ctx, - 		&sd[s]->write_dsc,	/* message descriptor */s/ 		NET_M_NOTRM,		/* flags: don't append CR/LF */-, 		&sd[s]->write_iosb,	/* I/O status block */ 		netlib1_write_ast, s);     }r!     if (vaxc$errno == SS$_NORMAL)t 	return (len);
     else {: 	errno = netlib1_get_errno(sd[s]->write_iosb.iosb_status);I         DTRACE("  --",0,"ERROR status:%08X, errno: %d",vaxc$errno,errno);t     };
 sendto_ioerr:*     SET_FPTR(_IOERR);e     return(-1);  }*  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <socket.h>  *  * int shutdown(int s, int how)v  *  * Description:c6  *	Shuts down all or part of a connection on a socket.  *  * s - a valid socketd  * how - one of:  *	0 - no more receives   *	1 - no more sends   *	2 - no more receives or sends  *  * Returns:$I  *	0 on success, -1 on error.  Addition error information is specified inu  * the global variable errno.o  */  int netlib1_shutdown(s,how)s int s, how;r {   3     STRACE("netlib1_shutdown",0,s,"how: %d",how,0);      if (sd[s] == NULL) { 	errno = EBADF;e 	return(-1);     }e       /*/      * if not connected the no need to shutdowno      */ -     if ((sd[s]->flags & SD_CONNECTED) == 0) {l 	errno = ENOTCONN; 	return(-1);     }r       switch (how) {	 	case 2 :e	 	case 1 :i 		sd[s]->ioctl_opts |= FWRITE; 		if (how != 2) break;	 	case 0 :o 		sd[s]->ioctl_opts |= FREAD;i. 		if ((sd[s]->sock_opts & SO_ACCEPTCONN) != 0), /*		    sys$setef(accept_net_event); */ /**/ 		    sys$setef(sd[s]->ef);*, /*		sys$cancel(sd[s]->chan); 	can't do ?? */ 		break;
 	default : 	    errno = EINVAL; 	    return(-1);     }!     return(0); }n iP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>(  * #include <socket.h>  *D  * int select(int nfds, int *readfds, int *writefds, int *execptfds,  *		struct timeval *timeout)  *  * Description:+H  *	Allows the user to poll or check a group of sockets for I/O activity.M  * It can check what sockets are ready to be read or written, or what sockets   * have a pending exception.  *	  * Notes:aJ  *	This routine (and library) only handles 32 file descriptors max (0-31).M  * The `fd_set' type is long int.  To select on file descriptor 0 (stdin) thesM  * routine netlib1_stdin_open must be used to setup the file descriptor.  See N  * routines netlib1_stdin_open and netlib1_stdin_read for further information.  *-  * nfds		- maximum file descriptor +1 to scan C  * readfds	- address of descriptor bit mask to scan for read events%E  * writefds	- address of descriptor bit mask to scan for write eventsfJ  * exceptfds	- address of descriptor bit mask to scan for exception eventsG  * timeout	- specifies how long to wait for a read, write, or exceptionEA  *		  event.  If timeout argument is NULL select will block until 0  *		  one of the specified descriptors is ready.  *  * Returns:/F  *	Number of socket descriptors ready for I/O or that have exceptions,L  * 0 if the operation timed out, -1 on error.  Addition error information is*  * specified in the global variable errno.  */ ; int netlib1_select(nfds,readfds,writefds,exceptfds,timeout) 	 int	nfds;s$ int	*readfds, *writefds, *exceptfds; struct	timeval *timeout; {c int	i;, int	maxfds, maxfds_mask, ready_fds, all_fds;
 int	readyfds;m   int	block, t[2]; unsigned long timer_ef;T #ifdef UDP_POLL> unsigned long	udp_tick_ef; int	udp_tick_time[2];  #endif char	at[20]; /* char	*p; */ struct	tm *lt;$ struct dsc$descriptor_s ascii_time =) 	{20, DSC$K_DTYPE_T, DSC$K_CLASS_S, at };u   int	ef_mask; #define EF_BASE 32  1     DTRACE("netlib1_select",0,"nfds: %d",nfds,0);+     readyfds = 0;+     FD_ZERO(&ready_fds);     FD_ZERO(&all_fds);     FD_ZERO(&ef_mask);       block = timer_ef = 0;c  5     maxfds = nfds < FD_SETSIZE ? nfds+1 : FD_SETSIZE;D       /*0      * Don't allow more than 32 file descriptors      */i     if (maxfds > 32) { 	errno = EBADF;s         readyfds = -1; 	goto EXIT;      }t       if (maxfds == 32)* 	maxfds_mask = 0xffffffff;
     else { 	maxfds_mask = 0;r 	for (i=0; i < maxfds; i++)s 	    maxfds_mask |= (1<<i);a     }e       /*L      * Clear extranious bits and check for bad file descriptors.  Gather all9      * file descriptor bits into `all_fds' for use later.b      */      if (exceptfds != NULL) { 	*exceptfds &= maxfds_mask;d6 	DTRACE("  --",0,"except fd mask: %08X",*exceptfds,0);; 	if ((*exceptfds & sys_validfds.fds_bits[0]) != *exceptfds)- 	{ 	    /*0< 	     * Set the exceptfds mask to indicate which fd was bad. 	     */, 	    *exceptfds ^= sys_validfds.fds_bits[0]; 	    errno = EBADF;e 	    return(-1); 	} 	all_fds = *exceptfds;     }o       if (writefds != NULL) {{ 	*writefds &= maxfds_mask;4 	DTRACE("  --",0,"write fd mask: %08X",*writefds,0);; 	if ((*writefds & sys_validfds.fds_bits[0]) != *writefds) {c 	    /*n< 	     * Set the exceptfds mask to indicate which fd was bad. 	     */+ 	    *writefds ^= sys_validfds.fds_bits[0];* 	    errno = EBADF;c 	    return(-1); 	} 	all_fds |= *writefds;     }L       if (readfds != NULL) { 	*readfds &= maxfds_mask; 2 	DTRACE("  --",0,"read fd mask: %08X",*readfds,0);9 	if ((*readfds & sys_validfds.fds_bits[0]) != *readfds) {o 	    /*A< 	     * Set the exceptfds mask to indicate which fd was bad. 	     */* 	    *readfds ^= sys_validfds.fds_bits[0]; 	    errno = EBADF;t 	    return(-1); 	} 	all_fds |= *readfds;e     }*  2     DTRACE("  --",0,"all_fd mask %08X",all_fds,0);   #ifdef UDP_POLL*     /**      * NETLIB's lack of UDP receive AST's:      * Setup polling interval.      */u%     if((sys_udpfds & all_fds) != 0) {f! 	    sprintf(at,"0 00:00:01.00");o2 	    p = getenv("SOCKETSHR_UDP_POLLING_INTERVAL");! 	    if (p != NULL) strcpy(at,p);r* 	    ascii_time.dsc$w_length = strlen(at);1 	    i = sys$bintim(&ascii_time, &udp_tick_time);n 	    if (!(i&1)) lib$stop(i);  	    lib$get_ef(&udp_tick_ef);8 	    FD_SET((udp_tick_ef - EF_BASE),(fd_set *)&ef_mask);S DTRACE("netlib1_select",0,"udp_tick_ef=%d, mask=%08X",udp_tick_ef-EF_BASE,ef_mask);l     }z #endif       /*5      * if this is a timed event then setup the timer.       */      if (timeout == NULL)	 	block++;t     else7 	if (timeout->tv_sec != 0  ||  timeout->tv_usec != 0) {+
 	    block++;+ 	    /*+( 	     * setup a timer AST to check later 	     */B 	    if (timeout->tv_sec > 86399) { /* not grater than 24 hours */ 		errno = EINVAL;D 		readyfds = -1; 		goto EXIT; 	    }& 	    lt = localtime(&timeout->tv_sec);0 	    sprintf(at,"0 %02.2d:%02.2d:%02.2d.%02.2d",> 		lt->tm_hour, lt->tm_min, lt->tm_sec, (int)timeout->tv_usec);* 	    ascii_time.dsc$w_length = strlen(at);! 	    sys$bintim(&ascii_time, &t);r 	    lib$get_ef(&timer_ef);A* 	    sys$setimr(timer_ef,&t,0,timer_ef,0);6 	    FD_SET((timer_ef - EF_BASE), (fd_set *)&ef_mask);M DTRACE("netlib1_select",0,"timer-ef=%d, mask=%08X",timer_ef-EF_BASE,ef_mask);_ 	}   CHECK_DESCRIPTORS:8 DTRACE("netlib1_select",0,"check_descriptors loop",0,0);   #ifdef UDP_POLL(     /*"      * NETLIB's lack of UDP AST's:&      * check all UDP file descriptors.      */ /     if((ready_fds = sys_udpfds & all_fds) != 0)= 	for (i=0; i < maxfds; i++)m  	    if (FD_ISSET(i,&ready_fds))! 		netlib1_check_udp_receive(i,0);  #endif       /*!      * exception file descriptors+      */+     if (exceptfds != NULL)> 	if((ready_fds = sys_exceptfds.fds_bits[0] & *exceptfds) != 0) 	    for (i=0; i < maxfds; i++)e( 		if (FD_ISSET(i, (fd_set *)&ready_fds)) 		    readyfds++;*       /*      * write file descriptorsm      */      if (writefds != NULL) < 	if((ready_fds = sys_writefds.fds_bits[0] & *writefds) != 0) 	    for (i=0; i < maxfds; i++)n( 		if (FD_ISSET(i, (fd_set *)&ready_fds)) 		    readyfds++;e     /*      * read file descriptors      */d     if (readfds != NULL) DTRACE("netlib1_select",7 	0,"sys_readfds mask: %08X",sys_readfds.fds_bits[0],0);b: 	if((ready_fds = sys_readfds.fds_bits[0] & *readfds) != 0) 	    for (i=0; i < maxfds; i++) ( 		if (FD_ISSET(i, (fd_set *)&ready_fds)) 		    readyfds++;o     /*!      * See if we'er ready to exite      */a     if (readyfds == 0)
 	if (block) {r 	    if (timer_ef != 0)r( 		if (sys$clref(timer_ef) == SS$_WASSET) 		    goto EXIT; 	    for (i=0; i < maxfds; i++)	( 		if (FD_ISSET(i, (fd_set *)&all_fds)) {8 		    FD_SET((sd[i]->ef - EF_BASE), (fd_set *)&ef_mask);J STRACE("netlib1_select",0,i,"ef=%d, mask=%08X",sd[i]->ef-EF_BASE,ef_mask); 		}e #ifdef UDP_POLL *     	    if((sys_udpfds & all_fds) != 0) { 		sys$clref(udp_tick_ef);PF DTRACE("netlib1_select",0,"sys$wflor, udp_tick_ef: %d",udp_tick_ef,0);@ 	        sys$setimr(udp_tick_ef,&udp_tick_time,0,udp_tick_ef,0); 	    } #endif  < DTRACE("netlib1_select",0,"sys$wflor, mask=%08X",ef_mask,0);  	    sys$wflor(EF_BASE,ef_mask); {* unsigned long mm;0 sys$readef(EF_BASE,&mm);4 DTRACE("netlib1_select",0,"$READEF mask=%08X",mm,0); }e 	    goto CHECK_DESCRIPTORS; 	}   EXIT:s     if (timer_ef != 0) { 	sys$cantim(timer_ef,0); 	lib$free_ef(&timer_ef);     }d #ifdef UDP_POLL      if (udp_tick_ef != 0) {O 	sys$cantim(udp_tick_ef,0);r 	lib$free_ef(&udp_tick_ef);      }e #endif     if (exceptfds != NULL)8 	*exceptfds = (sys_exceptfds.fds_bits[0] & maxfds_mask);     if (writefds != NULL)e6 	*writefds = (sys_writefds.fds_bits[0] & maxfds_mask);     if (readfds != NULL)4 	*readfds = (sys_readfds.fds_bits[0] & maxfds_mask);> DTRACE("netlib1_select",0,"returns: %d fds ready",readyfds,0);     return(readyfds);  }  RP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>s  * #include <socket.h>  *>  * int getsockname(int s, struct sockaddr *name, int *namelen)  *  * Description:_,  *	Returns the name associated with a socket  *#  * s	   - a valid socket descriptor C  * name	   - sockaddr address structure where data is to be written ,  * namelen - number of bytes written to name  *  * Returns:eI  *	0 on success, -1 on error.  Addition error information is specified in(  * the global variable errno.i  */[' int netlib1_getsockname(s,name,namelen)= int	s; struct	sockaddr *name;
 int	*namelen;  {s
 int	ret_size;P struct sockaddr_in loc;r struct sockaddr_in rem; ! struct sockaddr_in *local = &loc;*" struct sockaddr_in *remote = &rem;  struct dsc$descriptor host_dsc => 	{sizeof(inet_name), DSC$K_DTYPE_T, DSC$K_CLASS_S, inet_name};   /* int i; */ /* char buf[1024]; */t! /* unsigned short int iosb[4]; */   " int rport;					/* AH 2-JUN-1997 */" int lport;					/* AH 2-JUN-1997 */  -     STRACE("netlib1_getsockname",0,s,"",0,0);d     /*      * check for valid socketz      */r     if (sd[s] == NULL) { 	errno = EBADF;t 	return(-1);     }k  " /*    local		= &sd[s]->my; */ /**/     local->sin_addr.s_addr = 0;g     local->sin_port    = 0; +     sd[s]->mylen = sizeof(struct sockaddr);e  *     vaxc$errno = net_get_info(&sd[s]->ctx,1 		&remote->sin_addr.s_addr,	/* foreign address */r 		&rport,				/* foreign port */	. 		&local->sin_addr.s_addr,	/* local address */ 		&lport);			/* local port */b    3     remote->sin_port = rport;			/* AH 2-JUN-1997 */n3     local->sin_port  = lport;			/* AH 2-JUN-1997 */b  #     if (vaxc$errno != SS$_NORMAL) { ' 	errno = netlib1_get_errno(vaxc$errno);rI         DTRACE("  --",0,"ERROR status:%08X, errno: %d",vaxc$errno,errno);s     }f
     else {4 #if 0	/* NETLIB Versions before 1.6 have a bug... */ 	if (netlib_loaded == CMU) {0 	    remote->sin_port = htons(remote->sin_port);. 	    local->sin_port = htons(local->sin_port); 	} #endif@ 	((struct sockaddr_in *)&sd[s]->my)->sin_port = local->sin_port;     }h     /*>      * net_get_info does not always give us the local address.:      * if 0 get the address via gethostname/gethostbyname.      */(&     if (local->sin_addr.s_addr == 0) { 	inet_name[0] = '\0';*4 	vaxc$errno = net_get_hostname(&host_dsc,&ret_size); 	inet_name[ret_size] = '\0';>         DTRACE("  --",0,"net_get_hostname: {%s}",inet_name,0);* /*	if (vaxc$errno == SS$_NORMAL) { */ /**/. 	    vaxc$errno = net_get_address(&sd[s]->ctx,( 		&host_dsc,		/* host name descriptor */( 		1,			/* maximum number of addresses */> 		&local->sin_addr,   /* array to be written with addresses */1 		&ret_size);		/* returned number of addresses */pJ             DTRACE("  --",0,"net_get_address: status: %08X",vaxc$errno,0); /*	} */ /**/     }p  &     if (local->sin_addr.s_addr != 0) {6 	((struct sockaddr_in *)&sd[s]->my)->sin_addr.s_addr = 						local->sin_addr.s_addr;R     }u  -     local = (struct sockaddr_in *)&sd[s]->my;         local->sin_family	= AF_INET;  M     STRACE("netlib1_getsockname",0,s,"-- Local  Port: %d, Local  Addr: %08X",f7 	ntohs(local->sin_port),ntohl(local->sin_addr.s_addr));AM     STRACE("netlib1_getsockname",0,s,"-- Remote Port: %d, Remote Addr: %08X",f9 	ntohs(remote->sin_port),ntohl(remote->sin_addr.s_addr));o       /*3      * determine amount of data to return to callere      */ 3     ret_size = (sizeof(struct sockaddr) < *namelen)r) 				? sizeof(struct sockaddr) : *namelen;f     /*      * make the copy      */('     memcpy(name, &sd[s]->my, ret_size);+     *namelen = ret_size;       return(0); }+ +P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>t  * #include <socket.h>  *>  * int getpeername(int s, struct sockaddr *name, int *namelen)  *  * Description: ,  *	Returns the name associated with a socket  *#  * s	   - a valid socket descriptoroC  * name	   - sockaddr address structure where data is to be written-,  * namelen - number of bytes written to name  *  * Returns:eI  *	0 on success, -1 on error.  Addition error information is specified int  * the global variable errno.r  */ ' int netlib1_getpeername(s,name,namelen)  int	s; struct	sockaddr *name;
 int	*namelen;  {c
 int	ret_size;o struct sockaddr_in loc;i struct sockaddr_in rem;g! struct sockaddr_in *local = &loc;*" struct sockaddr_in *remote = &rem;  # int rport;						/* AH 2-JUN-1997 */d# int lport;						/* AH 2-JUN-1997 */e  -     STRACE("netlib1_getpeername",0,s,"",0,0);      /*      * check for valid socket       */k     if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }E   /*     local		= &sd[s]->my; */!      local->sin_family	= AF_INET;*"      remote->sin_family	= AF_INET;,      sd[s]->mylen = sizeof(struct sockaddr);  A 		/* Need to cheat a bit with the port numbers as netlib requires . 		  them to be long words rather than words */+      vaxc$errno = net_get_info(&sd[s]->ctx, 1 		&remote->sin_addr.s_addr,	/* foreign address */b 		&rport,				/* foreign port */n. 		&local->sin_addr.s_addr,	/* local address */ 		&lport);			/* local port */     4      remote->sin_port = rport;			/* AH 2-JUN-1997 */4      local->sin_port  = lport;			/* AH 2-JUN-1997 */  $      if (vaxc$errno != SS$_NORMAL) {' 	errno = netlib1_get_errno(vaxc$errno);hI         DTRACE("  --",0,"ERROR status:%08X, errno: %d",vaxc$errno,errno);s      }      else {e #if 0e 	if (netlib_loaded == CMU) {0 	    remote->sin_port = htons(remote->sin_port);. 	    local->sin_port = htons(local->sin_port); 	} #endif4 	memcpy(&sd[s]->my, local, sizeof(struct sockaddr));      }.      local = (struct sockaddr_in *)&sd[s]->my;  M     STRACE("netlib1_getpeername",0,s,"-- Local  Port: %d, Local  Addr: %08X",*7 	ntohs(local->sin_port),ntohl(local->sin_addr.s_addr));oM     STRACE("netlib1_getpeername",0,s,"-- Remote Port: %d, Remote Addr: %08X", 9 	ntohs(remote->sin_port),ntohl(remote->sin_addr.s_addr));I       /*3      * determine amount of data to return to caller=      */n3     ret_size = (sizeof(struct sockaddr) < *namelen) ) 				? sizeof(struct sockaddr) : *namelen;      /*      * make the copy      */ #     memcpy(name, remote, ret_size);n     *namelen = ret_size;       return(0); }   P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>I  * #include <socket.h>  *0  * int getsockopt(int s, int level, int optname,  *			char *optval, int *optlen)(  *  * Description:r'  *	Returns the options set on a socket.a  *  * Note:B  *	This routine does nothing.  Always returns -1 with errno set to  * ENOPROTOOPT.   *$  * Returns: (if it did do something)I  *	0 on success, -1 on error.  Addition error information is specified ins  * the global variable errno./  */s5 int netlib1_getsockopt(s,level,optname,optval,optlen)e int	s, level, optname;
 char	*optval;I int	*optlen; {/=     STRACE("netlib1_getsockopt",0,s,"optname: %d",optname,0);O     /*      * check for valid socketr      */i     if (sd[s] == NULL) { 	errno = EBADF;; 	return(-1);     }-       /*6      * there are no socket level options at this time.      */r     errno = ENOPROTOOPT;     return(-1);  }*  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>>  * #include <socket.h>  *0  * int setsockopt(int s, int level, int optname,  *			char *optval, int *optlen)c  *(  * Description: (if it did do something)  *	Set the options on a socket.*  *  * Note:B  *	This routine does nothing.  Always returns -1 with errno set to  * ENOPROTOOPT.r  *  * Returns: I  *	0 on success, -1 on error.  Addition error information is specified inl  * the global variable errno.w  */ 5 int netlib1_setsockopt(s,level,optname,optval,optlen)  int	s, level, optname;
 char	*optval;A int	optlen;( {;=     STRACE("netlib1_setsockopt",0,s,"optname: %d",optname,0);d     /*      * check for valid socket       */T     if (sd[s] == NULL) { 	errno = EBADF;1 	return(-1);     }t       /*6      * there are no socket level options at this time.      */o     errno = ENOPROTOOPT;     return(-1);o }  FP /*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int gethostname(char *name, int namelen))  *  * Description:[5  *	Returns the name currently associated to the host.e  *4  * name	   - address of buffer to write name of host"  * namelen - length of name buffer  *  * Returns:+I  *	0 on success, -1 on error.  Addition error information is specified inc  * the global variable errno.f  */n& int netlib1_gethostname(name, namelen) char	*name;t int	namelen; {) int len;  struct dsc$descriptor host_dsc =/ 	{namelen, DSC$K_DTYPE_T, DSC$K_CLASS_S, name};t  +     DTRACE("netlib1_gethostname",0,"",0,0);e2     vaxc$errno = net_get_hostname(&host_dsc,&len);#     if (vaxc$errno != SS$_NORMAL) { ' 	errno = netlib1_get_errno(vaxc$errno);eJ         DTRACE("  --",0,"ERROR status: %08X, errno: %d",vaxc$errno,errno); #if 0r 	return(-1); #endif     }i     name[len] = '\0';uP     DTRACE("netlib1_gethostname",0,"returned hostname: {%s}, len: %d",name,len);     return(0); }   + #if 0	/* no longer used, see [-]READDB.C */fP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *:  * struct servent *getservbyname(char *name, char *proto);  *  * Description:fC  *	returns a servent structure filled in with information about the   * requested service.e  *?  * name  - pointer to character string of service to search for.J  * proto - pointer to character string of protocol type desired (tcp, udp)  *	  * Notes:oH  *	The usual services text file is not supported.  Instead, services areH  * are logical names defined in the system logical name table.  Services(  * logical names are defined as follows:  *<  *	$ DEFINE /SYSTEM INET$SERVICE_service_name_protocol value  *  * Example:eJ  *   To define the service telnet, protocol tcp, port 23 use the following
  * statement:u-  *	$ DEFINE/SYSTEM INET$SERVICE_TELNET_TCP 23f  *  * Returns:	J  *	Returns the address of a servent structure on success, the NULL pointer  * on error (see __trnlnm).n  */_   static struct servent serv;[  2 struct servent *netlib1_getservbyname(name, proto) char	*name;_ char	*proto; {$ char	logical[256]; char	port[16];    5     sprintf(logical,"INET$SERVICE_%s_%s",name,proto);e  G     vaxc$errno = __trnlnm( "LNM$SYSTEM", &logical, "Super", &port, 16);      if (vaxc$errno == 0) { 	serv.s_name = name;" 	serv.s_port = htons(atoi(&port)); 	serv.s_proto = proto;g         DTRACE("netlib1_getservbyname",0,"returned name: %s, port: %d",serv.s_name,ntohs(serv.s_port));f 	return (&serv);     }F     else 	return(NULL); }g  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++8  * struct servent *getservbyport(int port, char *proto);  *  * Description: C  *	returns a servent structure filled in with information about the   * requested port.  *1  * port  - int value of port number to search foreJ  * proto - pointer to character string of protocol type desired (tcp, udp)  *	  * Notes:-H  *	The usual services text file is not supported.  Instead, services areH  * are logical names defined in the system logical name table.  Services(  * logical names are defined as follows:  *=  *	$ DEFINE /SYSTEM INET$SERVICE_port_number_protocol servicee  *  * Example:;J  *   To define the service telnet, protocol tcp, port 23 use the following
  * statement:m-  *	$ DEFINE/SYSTEM INET$SERVICE_23_TCP TELNETr  *  * Returns:(J  *	Returns the address of a servent structure on success, the NULL pointer  * on error (see __trnlnm).a  */i2 struct servent *netlib1_getservbyport(port, proto)	 int	port;t char	*proto; {o char	logical[256]; char	name[32];  5     sprintf(logical,"INET$SERVICE_%d_%s",port,proto);{  G     vaxc$errno = __trnlnm( "LNM$SYSTEM", &logical, "Super", &name, 32);s     if (vaxc$errno == 0) { 	serv.s_name = &name;  	serv.s_port = htons(port);  	serv.s_proto = proto;g         DTRACE("netlib1_getservbyname",0,"returned name: %s, port: %d",serv.s_name,ntohs(serv.s_port));t 	return (&serv);     }a     else 	return(NULL); }  #endif EP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *,  * struct hostent *gethostbyname(char *name)  *  * Description:u;  *	returns the host address associated with the given name.0  *M  * name - pointer to a character string that contains the host/domain name toU  *        search for.   *
  * Return:J  *	Returns the address of a hostent structure on success, the NULL pointerM  * on error.  Additional error information is returned in the global variablep	  * errno.E  */E+ struct hostent *netlib1_gethostbyname(name)t char	*name;_ {%
 void	*namctx;d int	alcount; int	i; unsigned long	laddr;  struct dsc$descriptor host_dsc =& 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};  8     DTRACE("netlib1_gethostbyname",0,"name: %s",name,0);     /*O      * If the first character of the hostname is numeric then quit (must be dot       * notation address).       */   2     if (isdigit(name[0])  ||  strlen(name) == 0) { 	errno = EBADF;r 	return(NULL);     }f       net_assign(&namctx);       i = strlen(name);t6     str$copy_r(&host_dsc, (unsigned short *)&i, name);     alcount = 0; DTRACE("  --",0,"**1**",0,0);,)     vaxc$errno = net_get_address(&namctx,s( 		&host_dsc,		/* host name descriptor */0 		MAX_INADDR,		/* maximum number of addresses */6 		inet_list,		/* array to be written with addresses */0 		&alcount);		/* returned number of addresses */ DTRACE("  --",0,"**2**",0,0);d    #     if (vaxc$errno != SS$_NORMAL) { ' 	errno = netlib1_get_errno(vaxc$errno);_ 	net_deassign(&namctx);o 	return(NULL);     }f       /*D      * Get the official name of the host we just got the address for      */t:     memcpy(&laddr, &inet_list[0], sizeof(struct in_addr));*     vaxc$errno = net_addr_to_name(&namctx, 		laddr,			/* address */5 		&host_dsc);		/* dynamic descriptor for host name */        net_deassign(&namctx);  #     if (vaxc$errno != SS$_NORMAL) {)' 	errno = netlib1_get_errno(vaxc$errno);[ 	return(NULL);     }   C     memcpy(inet_name,host_dsc.dsc$a_pointer,host_dsc.dsc$w_length);s,     inet_name[host_dsc.dsc$w_length] = '\0';  %     inet_host.h_name     = inet_name;t%     inet_host.h_aliases  = &null_ptr;i#     inet_host.h_addrtype = AF_INET; 2     inet_host.h_length   = sizeof(struct in_addr);:     for (i=0; i<alcount; i++) addrlist[i] = &inet_list[i];     addrlist[alcount] = NULL; .     inet_host.h_addr_list = (char **)addrlist;     str$free1_dx(&host_dsc);I     DTRACE("netlib1_gethostbyname",0,"returned name: %s, first addr: %s",*+ 	inet_host.h_name,INTOA(inet_host.h_addr));+     return(&inet_host);_ }  rP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++?  * struct hostent *gethostbyaddr(char *addr, int len, int type)0  *  * Description:i7  *	Return official name of host given the host address.i  *H  * addr - a pointer to a series of bytes in network order specifying the,  *        address of the host to search for.%  * len  - number of bytes in the addr"4  * type - address format. Only AF_INET is supported.  *
  * Return:J  *	Returns the address of a hostent structure on success, the NULL pointerM  * on error.  Additional error information is returned in the global variablek	  * errno.c  */e  4 struct hostent *netlib1_gethostbyaddr(addr,len,type) char	*addr;w int	len, type; {_
 void	*namctx;s  struct dsc$descriptor host_dsc =& 	{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; int	alcount; int	i; unsigned long	laddr;  E     DTRACE("netlib1_gethostbyaddr",0,"addr: %08X",*((long *)addr),0);e     if (type != AF_INET) { 	errno = EAFNOSUPPORT; 	return(NULL);     }i       net_assign(&namctx);  1     memcpy(&laddr, addr, sizeof(struct in_addr));f  *     vaxc$errno = net_addr_to_name(&namctx, 		laddr,			/* address */5 		&host_dsc);		/* dynamic descriptor for host name */        net_deassign(&namctx);  #     if (vaxc$errno != SS$_NORMAL) {x' 	errno = netlib1_get_errno(vaxc$errno);e 	return(NULL);     }s  C     memcpy(inet_name,host_dsc.dsc$a_pointer,host_dsc.dsc$w_length);a,     inet_name[host_dsc.dsc$w_length] = '\0';       alcount = 1;8     memcpy(&inet_list[0], addr, sizeof(struct in_addr));  %     inet_host.h_name     = inet_name;d%     inet_host.h_aliases  = &null_ptr;t#     inet_host.h_addrtype = AF_INET;e2     inet_host.h_length   = sizeof(struct in_addr);:     for (i=0; i<alcount; i++) addrlist[i] = &inet_list[i];     addrlist[alcount] = NULL; .     inet_host.h_addr_list = (char **)addrlist;     str$free1_dx(&host_dsc);C     DTRACE("netlib1_gethostbyaddr",0,"returned name: %s, addr: %s",o+ 	inet_host.h_name,INTOA(inet_host.h_addr));      return(&inet_host);n }e bP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <ioctl.h>t  *,  * int ioctl(int s, int request, char *argp)  *  * Description:   *	control device.  *&  * s       - a valid socket descriptor  * request - one of:*  *		FIOCLEX		- set exclusive use on socket#  *		FIONCLEX	- remove exclusive use )  *		FIONBIO		- set/clear non-blocking i/o4+  *		FIONREAD	- get # bytes ready to be read 5  * argp    - address of buffer for return informationb  *  * Returns:sI  *	0 on success, -1 on error.  Addition error information is specified in   * the global variable errno.r  */( static int sign(val) {a     if (val == 0) return(0);      return( (val > 0) ? 1 : -1); }a  ! int netlib1_ioctl(s,request,argp)n int	s; int	request; void	*argp;  {c /* int	i; */ unsigned long *n;,  :     STRACE("netlib1_ioctl",0,s,"request: %08X",request,0);     /*      * check for valid socket_      */d     if (sd[s] == NULL) { 	errno = EBADF;a 	return(-1);     }e       errno = 0;  *     switch ((request & 0x0000ff00) >> 8) { 	case 't' :	 	case 's' :- 	case 'r' :  	case 'i' :r 	    errno = EIO;  	    break;t 	case 'f' :o  	    n  = (unsigned long *)argp;$ 	    switch (request & 0x000000ff) {6 		case 1 :	/* FIOCLEX - set exclusive use on socket */1 		case 2 :	/* FIONCLEX - remove exclusive use	 */o$ 		    sd[s]->ioctl_opts &= ~FEXLOCK;. 		    sd[s]->ioctl_opts |= FEXLOCK * sign(*n); 		    break;8 		case 126 :	/* FIONBIO - set/clear non-blocking i/o  */% 		    sd[s]->ioctl_opts &= ~O_NDELAY;h/ 		    sd[s]->ioctl_opts |= O_NDELAY * sign(*n);e 		    break;9 		case 127:	/* FIONREAD - get # bytes ready to be read */s 		    /*3 		     * if the socket read blocked return an errore	 		     */ + 		    if ((sd[s]->ioctl_opts & FREAD) != 0)d 			errno = EPIPE;e# 		    if (FD_ISSET(s,&sys_readfds))A) 			*n = sd[s]->read_iosb.iosb_byte_count;a
 		    else
 			*n = 0; 		    break;
 		default: 		    errno = EIO; 		    break; 	    } 	    break;s     }	  "     return ( errno == 0 ? 0 : -1); }i  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <file.h>  *)  * int fcntl(int s, int request, int arg)   *  * Description:g  *	file control.  *&  * s       - a valid socket descriptor  * request - One of:  *		F_GETFL - get file flags  *		F_SETFL - set file flags  * arg     - flags to seta  *  * Returns:r@  *	Value of flags or -1 on error.  Addition error information is*  * specified in the global variable errno.  */l  int netlib1_fcntl(s,request,arg) int s, request, arg; {"E     STRACE("netlib1_fcntl",0,s,"request: %08X, arg: %d",request,arg);E     /*      * check for valid socketo      */e     if (sd[s] == NULL) { 	errno = EBADF;) 	return(-1);     }d       switch (request) { 	case F_GETFL :o 	    return(sd[s]->ioctl_opts);  	case F_SETFL :_ 	    if (arg == O_NDELAY) {r 		sd[s]->ioctl_opts = arg; 		return(0);
             }f 	    return(-1);
 	default : 	    errno = EINVAL; 	    return(-1);     }z }+  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>+  * #include <socket.h>  *&  * int read(int s, char *buf, int len)  *  * Description:e)  *	Receive bytes from a connected socket.a  *"  * s   - a valid socket descriptor8  * buf - address of buffer to where input data is placed  * len - max size of buf  *  * Returns:dE  *	Number of bytes read from the socket, -1 on error.  Addition errort9  * information is specified in the global variable errno.n  */r int netlib1_read(s,buf,len)  int	s;
 char	*buf; int	len; {a0     STRACE("netlib1_read",0,s,"%d bytes",len,0);     /*      * check for valid socketn      */	     if (sd[s] == NULL) { 	errno = EBADF;a 	return(-1);     }s       /*      * Must be connected      */ +     if ((sd[s]->flags & SD_CONNECTED) != 0) + 	return(netlib1_recvfrom(s,buf,len,0,0,0));r
     else { 	errno = EBADF;  	return(-1);     }_ }p nP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include <types.h>E  * #include <socket.h>  *2  * int write(int s, char *msg, int len, int flags)  *  * Description: 5  *	Send bytes through a socket to its connected peer.i  *"  * s   - a valid socket descriptor-  * buf - address of buffer of data to be senti  * len - size of buf  *  * Returns:tF  *	Number of bytes written to the socket, -1 on error.  Addition error9  * information is specified in the global variable errno.e  */o int netlib1_write(s,msg,len) int	s;
 char	*msg; int	len; {t1     STRACE("netlib1_write",0,s,"%d bytes",len,0);      /*      * check for valid socketl      */t     if (sd[s] == NULL) { 	errno = EBADF;  	return(-1);     }R       /*      * Must be connected      */)+     if ((sd[s]->flags & SD_CONNECTED) != 0)X) 	return(netlib1_sendto(s,msg,len,0,0,0)); 
     else { 	errno = EBADF;i 	return(-1);     }  }r tP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int close(int s)m  *  * Description:,7  *	Closes a connection and deletes a socket descriptor.s  *E  * To avoid confusion and link warnings regarding the `close' routine C  * for other file descriptors this routine name is `netlib1_close'.sa  * A "#define close(s) netlib1_close(s)" or direct call to netlib1_close(s) is needed in routines S  * close sockets managed by this library.   If this routine is called with a socketeN  * descriptor that is not managed by this library it will pass that descriptor  * to the system close routine.f  *   * s - an open socket descriptor  *  * Returns: I  *	0 on success, -1 on error.  Addition error information is specified inz  * the global variable errno.*  */+ int netlib1_close(s) int	s; {+ struct	backlogEntry *entry;+  '     STRACE("netlib1_close",0,s,"",0,0);d     /*H      * if this is not one of our channels then pass it on to the systems      * close routine.       */p     if (sd[s] == NULL) 	return(close(s));       /*M      * Verify that the channel is indeed open -- in some cases it may not be.*      */O-     if ((sd[s]->flags & SD_CONNECTED) != 0) {  	/*o$ 	 * close/deallocate the I/O channel 	 */ 	tcp_disconnect(&sd[s]->ctx);e     }        /*'      * Clear all the associated fd bitsv      */e     FD_CLR(s,&sys_validfds);     FD_CLR(s,&sys_readfds);n     FD_CLR(s,&sys_writefds);     FD_CLR(s,&sys_exceptfds);  #ifdef UDP_POLL      FD_CLR(s,&sys_udpfds); #endif       /*:      * free the various resources that we have accumulated      */      if (sd[s]->ef != 0)e 	lib$free_ef(&sd[s]->ef);    #if 0.)     if (sd[s]->protocol == IPPROTO_UDP) {e 	if (sd[s]->rcvbuf != NULL)+ 	    free(sd[s]->rcvbuf);+     }+ #endif.     if (sd[s]->read_dsc.dsc$a_pointer != NULL)  	str$free1_dx(&sd[s]->read_dsc);     /*%      * was this an `accept'ed socket?       */ J     if (sd[s]->listen_socket != 0  &&  sd[sd[s]->listen_socket] != NULL) {) 	sd[sd[s]->listen_socket]->backlogSize--;* 	/* ) 	 * requeue the listen if it was shutdownt 	 */; 	if ((sd[sd[s]->listen_socket]->flags & SD_LISTENING) == 0),0 	    netlib1_queue_listen(sd[s]->listen_socket);     }l       /*9      * purge the listen queue if this was a listen socketl      */o2     if ((sd[s]->sock_opts & SO_ACCEPTCONN) != 0) {& 	while (sd[s]->backlogQueue != NULL) {! 	    entry = sd[s]->backlogQueue;n( 	    sd[s]->backlogQueue = entry->flink; 	    cfree(entry); 	}     }        net_deassign(&sd[s]->ctx);       cfree(sd[s]);      sd[s] = 0;A     close(s);	/* this should free up the duped file descriptor */      return(0); }e nP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * #include "netlib.h"  *&  * int *netlib1_stdin_open(char *name)  *  * Description:tI  *	To have stdin a device that can be selected the descriptor needs to beoM  * allocated within the domain of these routines.  This routine allocates therJ  * file descriptor and returns the address of the FD_ENTRY so the user canO  * control reads/writes and still use select to see if the descriptor is ready.)M  * Optionally the user can use the following routine to queue reads on stdin.{  *L  * name - character string device name of the device to assign a channel to.  *  * Returns: F  *	Address of an FD_ENTRY structure on success, -1 on error.  Addition?  * error information is specified in the global variable errno.T  */" int *netlib1_stdin_open(name)r char	*name;e {o! struct	dsc$descriptor_s dev_name;d       if (sd[0] != NULL) { 	errno = EBADF;E 	return (int *)(-1);     }uC     sd[0] = (struct FD_ENTRY *)calloc( 1, sizeof(struct FD_ENTRY));      FD_CLR(0,&sys_readfds);E     FD_SET(0,&sys_validfds);       /*M      * copy the `name' to the `my' sockaddr area (seems like a logical place)t      */e     if (strlen(name) <= 14) {  	sd[0]->mylen = strlen(name);s 	sd[0]->my.sa_family = 0;w0 	memcpy(&sd[0]->my.sa_data, name, strlen(name));     }*
     else { 	errno = ENAMETOOLONG; 	goto ERROR_RETURN;      }*       /*C      * setup a descriptor for the device and assign a channel to it*      */ *     dev_name.dsc$w_length  = sd[0]->mylen;+     dev_name.dsc$b_dtype   = DSC$K_DTYPE_T;n+     dev_name.dsc$b_class   = DSC$K_CLASS_S;.8     dev_name.dsc$a_pointer = (char *)&sd[0]->my.sa_data;  >     vaxc$errno = sys$assign(&dev_name, &sd[0]->chan, 0, 0, 0);  #     if (vaxc$errno != SS$_NORMAL) {e 	errno = EVMSERR;c 	goto ERROR_RETURN;l     }        lib$get_ef(&sd[0]->ef);T     sys$clref(sd[0]->ef);2     /*L      * return the address of the socket descriptor so the user can play with
      * it.      */o     return((int *)sd[0]);   
 ERROR_RETURN:v     if (sd[0] != NULL) 	cfree(sd[0]);     sd[0] = NULL;r     return((int *)-1); }r ;P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++P  * int netlib1_stdin_read(int flags, char *buf, int len, char *prompt, int mask)  *  * Description:(I  *	queue an i/o to the descriptor described in sd[0].  Since this read is;H  * ment to be used with the select call a non-blocking qio is done.  TheI  * completion routine will set the file descriptor and event flag on read   * completion.  *  * flags  - qio read modifiers&  * buf    - to receive characters read"  * len    - max characters to read"  * prompt - prompt string for read   * mask   - read terminator mask  *  * Returns:a/  *	Status from the SYS$QIO system service call.u  */ 1 int netlib1_stdin_read(flags,buf,len,prompt,mask)o
 int	flags;
 char	*buf; int	len;
 char	*prompt;h	 int	mask;i {o       /*!      * Clear these system things.t      */T     sys$clref(sd[0]->ef);      FD_CLR(0, &sys_readfds);       if (qioef == 0)c 	lib$get_ef(&qioef);       if (prompt != NULL).C 	vaxc$errno = sys$qio(qioef, sd[0]->chan, flags, &sd[0]->read_iosb,  			netlib1_read_ast,0, 			buf, len,$ 			0, mask, prompt, strlen(prompt));     elseC 	vaxc$errno = sys$qio(qioef, sd[0]->chan, flags, &sd[0]->read_iosb,e 			netlib1_read_ast,0, 			buf, len, 			0, 0, 0, 0);*     return(vaxc$errno);s }e dP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int netlib1_get_sdc(int s)l  *  * Description:tD  *	Returns the assigned VMS channel for a particular file descriptor  *   * s - a valid socket descriptor  *  * Returns:rT  *  If successful a VMS i/o channel number is returned otherwise a 0 is returned and  *  errno is set.   *  */r short int netlib1_get_sdc(s) int	s; {p     /*      * check for valid socket.      */e     if (sd[s] == NULL) { 	errno = EBADF;p 	return(0);.     }n     else 	return(sd[s]->chan);e };  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++%  * int netlib1_get_errno(long status)+  *  * Description: &  *	returns best guess value for errno.  *  * status - status codet  *  * Returns:s  *	Returns an errno value.  */* int netlib1_get_errno(status)t long status; {n int netlib1_errno = 0;   #define ERRMAP(vms,unix) \ 	case vms:\r 		netlib1_errno = unix;\ 		break;     /*$      * Choose errno based on status.      */.     switch (status) {r   	ERRMAP(SS$_NORMAL	, 0)l* 	ERRMAP(0		, EVMSERR)	/* use vaxc$errno */8 	ERRMAP(SS$_ABORT	, ECONNABORTED)	/* INETACP has died */5 	ERRMAP(SS$_MEDOFL	, ENETDOWN)	/* INETACP has died */ A 	ERRMAP(SS$_BADPARAM	, EINVAL)	/* parameter not valid for call */,@ 	ERRMAP(SS$_EXQUOTA	, EMSGSIZE)	/* buffer allocation problems */> 	ERRMAP(SS$_INSFMEM	, ENOMEM)	/* buffer allocation problems *// 	ERRMAP(SS$_NOPRIV	, EACCES)	/* no privilege */)9 	ERRMAP(SS$_ACCVIO	, EFAULT)	/* buffer access problems */=C 	ERRMAP(SS$_ILLCNTRFUNC	, EOPNOTSUPP)	/* operation not supported */a= 	ERRMAP(SS$_CONNECFAIL	, ECONNRESET)	/* conn reset by peer */s  	ERRMAP(SS$_DEVINACT	, ENETDOWN)# 	ERRMAP(SS$_DEVNOTMOUNT	, ENETDOWN))@ 	ERRMAP(SS$_DUPLNAM	, EADDRINUSE)	/* bind failed, port in use */1 	ERRMAP(SS$_FILALRACC	, EEXIST)	/* file exists */u8 	ERRMAP(SS$_IVADDR	, EADDRNOTAVAIL)/* invalid address */; 	ERRMAP(SS$_IVBUFLEN	, EINVAL)	/* invalid address buffer */s6 	ERRMAP(SS$_NOLICENSE	, ECONNREFUSED)	/* no license */3 	ERRMAP(SS$_NOLINKS	, ENOTCONN)	/* not connected */v5 	ERRMAP(SS$_NOOPER	, EACCES)	/* OPER priv required */ F 	ERRMAP(SS$_LINKABORT	, ECONNABORTED)	/* software caused conn abort */= 	ERRMAP(SS$_LINKDISCON	, EPIPE)	/* socket closed by remote */eA 	ERRMAP(SS$_PROTOCOL	, EAFNOSUPPORT)	/* TCP/IP and UDP/IP only */	> 	ERRMAP(SS$_REJECT	, ECONNREFUSED)	/* many reasons for this */< 	ERRMAP(SS$_SHUT		, ENETDOWN)	/* network is shutting down */A 	ERRMAP(SS$_SUSPENDED	, EWOULDBLOCK)	/* accept with no request */r: 	ERRMAP(SS$_TIMEOUT	, ETIMEDOUT)	/* operation timed out */@ 	ERRMAP(SS$_TOOMUCHDATA	, EMSGSIZE)	/* IP packet size problem */B 	ERRMAP(SS$_UNREACHABLE	, ENETUNREACH)	/* network not reachable */B 	ERRMAP(SS$_BUFFEROVF	, EMSGSIZE)	/* buffer allocation problems */B 	ERRMAP(SS$_RESULTOVF	, EMSGSIZE)	/* buffer allocation problems */B 	ERRMAP(SS$_NOTNETDEV	, ENOTSOCK)	/* socket op. on a non-socket */? 	ERRMAP(SS$_NOSUCHNODE	, EDESTADDRREQ)	/* dest addr required */e: 	ERRMAP(SS$_RESET	, ENETRESET)	/* network dropped conn. */8 	ERRMAP(SS$_NOSUCHDEV	, ENXIO)	/* no such dev or addr */  	 	default:d  /*		netlib1_errno = EIO; */ /**/ 		netlib1_errno = EVMSERR; /**/+ 	} 	return(netlib1_errno);+ }+ +P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#  * int netlib1_listen_accept(int s)i  *  * Description:eG  *	AST completion routine called when a connection completes on an openw  *	listening socket.  *  * s - valid socket descriptor  *  * Returns:l  *	None.  */  int netlib1_listen_accept(s) int	s;	/* socket descriptor */ {p int	ns;* /* int	tmp; */" struct	backlogEntry *backlogQueue; /* struct	sockaddr_in *to; */i  V     STRACE("netlib1_listen_accept",0,s,"status: %08X",sd[s]->read_iosb.iosb_status,0);     /*,      * check the stats of the completed open      */t5     if (sd[s]->read_iosb.iosb_status != SS$_NORMAL) {  	/*t# 	 * failed; set exceptfds and eventK 	 */ 	FD_SET(s,&sys_exceptfds); 	sys$setef(sd[s]->ef); 	return(SS$_NORMAL);     }"       /*6      * get a new clean socket like the one we have now      */ K     ns = netlib1_alloc_socket(sd[s]->domain, sd[s]->type, sd[s]->protocol);&&     sd[ns]->chan = sd[s]->accept_chan;     sd[ns]->accept_chan = 0;$     sd[ns]->ctx = sd[s]->accept_ctx;     sd[ns]->accept_ctx = 0;	       /*!      * Get connection informationa      */ ,     sd[ns]->tolen = sizeof(struct sockaddr);9     netlib1_getpeername(ns, &sd[ns]->to, &sd[ns]->tolen);)       /*&      * copy the local port information      */.?     memcpy(&sd[ns]->my, &sd[s]->my,   sizeof(struct sockaddr));c       /*)      * Set the bound and connected flags.n      */]-     sd[ns]->flags = (SD_BIND | SD_CONNECTED);s       /*3      * indicate which socket this accept came from.r      */n     sd[ns]->listen_socket = s;       /*'      * switch the assigned I/O channels       */i /*    tmp		 = sd[s]->chan; */ % /*    sd[s]->chan  = sd[ns]->chan; */  /*    sd[ns]->chan = tmp;    */s       /*4      * insert this new socket into the backlog queue      */_&     if (sd[s]->backlogQueue == NULL) { 	sd[s]->backlogQueue =? 		(struct backlogEntry *)calloc(1,sizeof(struct backlogEntry)); $ 	backlogQueue = sd[s]->backlogQueue;     }+
     else {$ 	backlogQueue = sd[s]->backlogQueue;$ 	while (backlogQueue->flink != NULL)( 	    backlogQueue = backlogQueue->flink;. 	backlogQueue->flink = (struct backlogEntry *)) 			calloc(1,sizeof(struct backlogEntry));	$ 	backlogQueue = backlogQueue->flink;     }I     backlogQueue->sock = ns;       /*0      * Increment the count of accepted requests.      */t     sd[s]->backlogSize++;g       /*7      * tell someone how cares that something came in...       */u     FD_SET(s,&sys_readfds); % /*    sys$setef(accept_net_event); */t     sys$setef(sd[s]->ef);        /*      * queue another listen(      */      netlib1_queue_listen(s);       return(SS$_NORMAL);e }b oP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"  * int netlib1_queue_listen(int s)  *  * Description:%1  *	Queue a read that will accept a TCP connectionc  *   * s - a valid socket descriptor  *  * Returns:FI  *	0 on success, -1 on error.  Addition error information is specified inf  * the global variable errno.s  */  int netlib1_queue_listen(s)r+ int	s;	/* socket descriptor to listen on */  {  /* struct	sockaddr_in *my; */;
 /* int ns; */r $DESCRIPTOR(dev,"NLA0:");a  .     STRACE("netlib1_queue_listen",0,s,"",0,0);     /*G      * if reads are shutdown on this socket then don't queue the listen~      */ +     if ((sd[s]->ioctl_opts & FREAD) != 0) {; 	errno = ESHUTDOWN;e 	return(-1);     }e       /*M      * if there are already 'backlog' number of connections then exit withoutoF      * posting the listen.  The close routine will requeue the listen.      */ .     if (sd[s]->backlogSize < sd[s]->backlog) { 	sd[s]->flags |= SD_LISTENING;       /*1      * get a new NETLIB context for accept socketd$      * same hack here as in socket()      */_0 	sys$assign(&dev, &sd[s]->accept_chan, 0, 0, 0);  	sys$dassgn(sd[s]->accept_chan);- 	vaxc$errno = net_assign(&sd[s]->accept_ctx);   	if (vaxc$errno != SS$_NORMAL) {+ 	    errno = netlib1_get_errno(vaxc$errno);  	    return(-1); 	}       /*      * now post the listen      */+ 	vaxc$errno = tcp_accept 		       (&sd[s]->ctx, 			&sd[s]->accept_ctx, 			&sd[s]->read_iosb,r 			netlib1_listen_accept, - 			s);	/* ast completion routine and param */r    	if (vaxc$errno != SS$_NORMAL) {= 	    errno = netlib1_get_errno(sd[s]->read_iosb.iosb_status);  	    return(-1); 	} 	sd[s]->flags |= SD_CONNECTED;     }d
     else { 	sd[s]->flags ^= SD_LISTENING;     }b       return(0); }*  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int netlib1_read_ast(int s)  *  * Description: ?  *	AST read completion routine.  Sets the global sys_readfds toLH  * indicate the socket is ready to read or sys_exceptfds if there was an	  * error.   *  * s - valid socket descriptor  *  * Returns:_  *	Nothing.g  */_ void netlib1_read_ast(s)+ int	s;	/* file descriptor that is ready. */  {r struct sockaddr_in *rcv;  O     STRACE("netlib1_read_ast",0,s,"iosb: %08X",sd[s]->read_iosb.iosb_status,0);++     switch (sd[s]->read_iosb.iosb_status) {+ 	case SS$_NORMAL:t 	    FD_SET(s,&sys_readfds); 	case SS$_ABORT: 	case SS$_CANCEL:  	    /* E 	     * if the status code is SS$_CANCEL or SS$_ABORT then I/O on the*H 	     * channel was cancled.  Don't set the exception flag in this case. 	     */ 	    break;n	 	default:  	    /**2 	     * all other status returns indicate an error 	     */ 	    FD_SET(s,&sys_exceptfds);' 	    FD_SET(s,&sys_readfds);	/* ???? */b     }o         /*I      * check for socket closed by remote. If it was then make if no-read,e      * no-write, and invalid.0      */* /*?  *    if ((sd[s]->read_iosb.X.STATUS & 0x0000ff00) == 0x0600) { )  *	sd[s]->ioctl_opts |= (FREAD & FWRITE);   *	FD_CLR(s,&sys_validfds);d  *    }   */  #ifdef UDP_POLL C     FD_CLR(s,&sys_udpfds);	/* don't wait for UDP read any longer */  #endif)     if (sd[s]->protocol == IPPROTO_UDP) { - 	rcv = (struct sockaddr_in *)&sd[s]->rcvfrom;+& 	rcv->sin_port = htons(rcv->sin_port); 	rcv->sin_family = AF_INET;#/ 	DTRACE("  --",0,"received addr: %s, port: %d",*1 		inet_ntoa(rcv->sin_addr),ntohs(rcv->sin_port));S     }e     /*?      * now set the event flag to signal the read has completed.e      */      sys$setef(sd[s]->ef);o }a    P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++   * void netlib1_write_ast(int s)  *  * Description:iA  *	AST write completion routine.  Sets the global sys_writefds to(N  * indicate the socket is ready to be written or sys_exceptfds if there was an	  * error.,  *  * s - valid socket descriptor  *  * Returns:t  *	Nothing.s  */N void netlib1_write_ast(s)r+ int	s;	/* file descriptor that is ready. */c {e4     if (sd[s]->write_iosb.iosb_status == SS$_NORMAL) 	FD_SET(s,&sys_writefds);d     else 	FD_SET(s,&sys_exceptfds);   }= A #ifdef UDP_POLL;P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *2  * int netlib1_check_udp_receive(int s, int flag);  *  * Description:n   *	Check UDP read on socket `s'.*  * On immediate timeout return SS$_NORMAL;E  * On completion call netlib1_read_ast. This replaced the NETLIB lackh  * of AST's on UDP receive.l  *  * s - valid socket descriptorH  * flag - wait flag: 0 return immediately, 1 wait for something received  *  * Returns:n  *	VMS status.  * the global variable errno.e  */h. int netlib1_check_udp_receive(int s, int wait) {i long timeout[2]; struct sockaddr_in *rcv; struct sockaddr_in *my;e int i;  >     STRACE("netlib1_check_udp_receive",0,s,"wait: %d",wait,0);     /*B      * Check if something has been received already. If so return.      */e>     if (sd[s]->read_iosb.iosb_status != 0) return(SS$_NORMAL);       /*+      * Setup timeout: immediately or never.d      */      if (wait) {  	timeout[0] = 0;A 	timeout[1] = 0xFFF00000;	/* That's 5212 days and a few hours..*/*     } 
     else { 	timeout[0] = -1;s; 	timeout[1] = -1;		/* That's 1 nano-second... immediately*/e     }        /*      * now try to read...       */s     my = &sd[s]->my;     rcv = &sd[s]->rcvfrom;L     DTRACE("  --",0,"rcvbuf=%08X, size=%d",sd[s]->rcvbuf,sd[s]->rcvbufsize);
     i = 0;)     vaxc$errno = udp_receive(&sd[s]->ctx, $ 	sd[s]->rcvbuf,		/* receive buffer*/, 	sd[s]->rcvbufsize,	/* receive buffer size*/8 	&sd[s]->read_iosb.iosb_byte_count,	/* received bytes */! 	&i,			/* receive from address */d) 	&rcv->sin_port,		/* receive from port */r	 	timeout,  	0,a 	0,l	 	0); /**/*     rcv->sin_addr.s_addr = i;l       /*5      * On timeout return normally. iosb is untouched.P      */ $     if (vaxc$errno == SS$_TIMEOUT) {A     DTRACE("  --",0,"UDP read timeout - nothing to receive",0,0);$ /*B  * Here is the next hack: on CMU/IP the UDP socket disappears when@  * the read is cancelled. Just setup a new socket and don't care  * for errors.  */-H 	vaxc$errno = net_bind(&sd[s]->ctx, NET_K_UDP, ntohs(my->sin_port),1,1);  	if (vaxc$errno != SS$_NORMAL) {7 	    DTRACE("  --",0,"ERROR status:%08X",vaxc$errno,0);  	    return(SS$_NORMAL); 	} 	else {e 	    return(SS$_NORMAL); 	}     }        /*E      * Either something has been received or error. In any case, callo)      * the AST-routine and return status.)      */ .     sd[s]->read_iosb.iosb_status = vaxc$errno;     netlib1_read_ast(s);     return(vaxc$errno);e }e #endif	/* UPD_POLL */e tP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  *$  * int netlib1_queue_net_read(int s)  *  * Description:cD  *	Queue a read on socket `s' to be completed by net_read_ast.  ThisL  * routine will also allocate an event flag and receive buffer if necessary.  * #ifdef UDP_POLLpI  * We have some problems with UDP here: NETLIB doesn't support AST's with F  * UDP receive. So we use use a minimum timeout to return immediately. #endif  *  * s - valid socket descriptor  *  * Returns:tI  *	0 on success, -1 on error.  Addition error information is specified ins  * the global variable errno.   */f int netlib1_queue_net_read(s)O int	s; {h long timeout[2]; struct sockaddr_in *rcv;  0     STRACE("netlib1_queue_net_read",0,s,"",0,0);     /*B      * clear event flag and file descriptor for this read request.      */F     sys$clref(sd[s]->ef);s     FD_CLR(s, &sys_readfds);       /**      * Allocate a receive buffer for reads      */*      if (sd[s]->rcvbuf == NULL) { 	vaxc$errno = str$get1_dxd= 	    ((unsigned short *)&sd[s]->rcvbufsize,&sd[s]->read_dsc);=5 /*	sd[s]->rcvbuf = malloc(sd[s]->rcvbufsize); */ /**/r  	if (vaxc$errno != SS$_NORMAL) { /*		How to abort ?	*/  	    errno = ENOBUFS;E 	    return(-1); 	}/ 	sd[s]->rcvbuf = sd[s]->read_dsc.dsc$a_pointer;      }c       sys$clref(sd[s]->ef);c       timeout[0] = 0; E     timeout[1] = 0xFFF00000;		/* That's 5212 days and a few hours..*/y)     sd[s]->read_iosb.iosb_byte_count = 0;a%     sd[s]->read_iosb.iosb_status = 0;eL     DTRACE("  --",0,"rcvbuf=%08X, size=%d",sd[s]->rcvbuf,sd[s]->rcvbufsize);)     if (sd[s]->protocol == IPPROTO_UDP) {  #ifdef UDP_POLL  	FD_SET(s,&sys_udpfds);w- 	vaxc$errno = netlib1_check_udp_receive(s,0);y #elseD- 	rcv = (struct sockaddr_in *)&sd[s]->rcvfrom;C& 	vaxc$errno = udp_receive(&sd[s]->ctx,% 		sd[s]->rcvbuf,		/* receive buffer*/a- 		sd[s]->rcvbufsize,	/* receive buffer size*/09 		&sd[s]->read_iosb.iosb_byte_count,	/* received bytes */E # if 13 		&rcv->sin_addr.s_addr,	/* receive from address */0* 		&rcv->sin_port,		/* receive from port */
 		timeout, 		&sd[s]->read_iosb,< 		netlib1_read_ast, s);	/* AST completion routine and arg */ # else3 		&rcv->sin_addr.s_addr,	/* receive from address */d* 		&rcv->sin_port,		/* receive from port */
 		timeout,	 		0,0,0);) # endif  #endif	/* UDP_POLL */+     }+
     else {& 	vaxc$errno = tcp_receive(&sd[s]->ctx,3 		&sd[s]->read_dsc,	/* receive buffer descriptor */  		&sd[s]->read_iosb,; 		netlib1_read_ast, s,	/* AST completion routine and arg */o 		timeout);n     } V     DTRACE("  --",0,"status=%08X, iosb=%08X",vaxc$errno,sd[s]->read_iosb.iosb_status);!     if (vaxc$errno == SS$_NORMAL)s 	return(0);e
     else {9 	errno = netlib1_get_errno(sd[s]->read_iosb.iosb_status);e 	FD_SET(s,&sys_exceptfds); 	sys$setef(sd[s]->ef); /*		Abort??? */  	return(-1);     }* }o  P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int isNetlibSocket(int s)  *  * Description: K  *	Checks if the socket is a NETLIB socket. If so return 1 if not return 0.n  *   * s - a valid socket descriptor  *  * Returns:*2  *  returns 1 if s is a NETLIB socket otherwise 0.C  *  Caution: Never use TRACE routines here, as this routine is used #  *  by the trace routines themself!t  *  */. int isNetlibSocket(s)( int	s; {]     /*      * check for valid socket.      */a%     return( (sd[s] != NULL) ? 1 : 0);m }  lP /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * int netlib1_get_fd(fptr)s  *  * Description:	)  *	return the socket from a file pointer.e  *  * s - a file pointer+  *  * Returns:+8  *  returns the socket. if no socket is found return -1.C  *  Caution: Never use TRACE routines here, as this routine is usedn#  *  by the trace routines themself!   *  */- int netlib1_get_fd(fptr) FILE	*fptr;r {r int i;      for (i=0;i<FD_SETSIZE;i++) {. 	if (sd[i] != NULL  &&  sd[i]->fptr == fptr) { 	    return(i);  	}     }h     return(-1);e }d )P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  * FILE *netlib1_fdopen(s)  *  * Description:    *      return the file pointer.  *   * s - a valid socket descriptor  *  * Returns:+C  *  returns the file pointer for the socket. if the socket in not a+  *  netlib socket, return NULL.s  *B  * Note that creating more than one file pointer for one socket isF  * not supported! fdopen always returns the same pointer. This pointer?  * is never used for stream I/O, it only identifies the socket.i  */  FILE *netlib1_fdopen(s)r int s; {\(     STRACE("netlib1_fdopen",0,s,"",0,0);     if (sd[s] == NULL) { 	errno = EBADF;s 	return(NULL);     }M@     DTRACE("netlib1_fdopen",0,"return fptr=%08X",sd[s]->fptr,0);     return(sd[s]->fptr); }A h* #if 0	/* This routine is in SI_SOCKET.C */P /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#  * int netlib1_writev(s,iov,iovcnt)I  *  * Description:i   *      return the file pointer.  *   * s - a valid socket descriptor  * iov - IO vector(  * iovcnt - number of elements in vector  *  * Returns:E1  *  returns the number of bytes actually written.L  *B  * Note that creating more than one file pointer for one socket isF  * not supported! fdopen always returns the same pointer. This pointer?  * is never used for stream I/O, it only identifies the socket.A  */A  int netlib1_writev(s,iov,iovcnt) int s; struct iovec *iov; int iovcnt;* {l int i; int k; int cnt = 0;  /     STRACE("writev",0,s,"iovcnt: %d",iovcnt,0);S 	for(i=0;i<iovcnt;i++) {
 /* fprintfP       (stderr,"  %d: len = %d\n{%s}\n",i,iov[i].iov_len,iov[i].iov_base);*/ /**/ 		k = (sd[s] != NULL ?0 			send(s, iov[i].iov_base, iov[i].iov_len, 0) :/ 			write(s, iov[i].iov_base, iov[i].iov_len) );C 		if (k == -1) return(-1); 		cnt += k;  	}
 	return(cnt);K }C #endif