 /*	SI_SOCKET.C  *	V1.5			12-Jan-1995		IfN/Mey  *+   * Here are the entry points.   *A  * Compile this module with /DEFINE=package (e.g. /DEFINE=NETLIB)   *-   */  /*G ** 01-DEC-1998	J. Malmberg	Minor changes so ANSI compilers will accept.  **; **		  **** 		BUG when UDP_POLL or TRACE is defined as true. 0 **				getenv() can not be used inside of a loop.0 **				it does a malloc() each time it is called. **G ** 12-Mar-1999	J. Malmberg	DECC has problem with __inet_ntoa prototype. + **				h_errno defined differently than GCC.  **H ** 15-Mar-1999	J. Malmberg	Compilation errors and warnings when TRACE is **				defined and DECC.  */   /*M  * NOTE: Never include socketshr.h, since we call the original routines here!   */   
 #ifdef LIBCMU  #define isSocket isLibcmuSocket  #define get_fd cmu_get_fd 
 #ifdef __DECC  #define PACK(pack) cmu_ ## pack  #else  #define PACK(pack) cmu_\ pack #endif #endif   #ifdef NETLIB1 #define isSocket isNetlibSocket  #define get_fd netlib1_get_fd  #ifndef VAXC# #define PACK(pack) netlib1_ ## pack  #else  #define PACK(pack) netlib1_\ pack #endif #endif  
 #ifdef UCX /*M  * UCX entry points call the DEC RTL routines directly with a few exceptions.   */  #define isSocket isUCXSocket #define get_fd ucx_get_fd 
 #ifdef __DECC   #define PACK(pack) decc$ ## pack% /* Routines not supported by DEC C */  #define decc$ioctl ucx_ioctl #define decc$fcntl ucx_fcntl #define decc$fdopen ucx_fdopen #else  #define PACK(pack) vaxc$\  pack$ /* Routines not supported by VAXC */ #define vaxc$ioctl ucx_ioctl #define vaxc$fcntl ucx_fcntl #define vaxc$fdopen ucx_fdopenP /* vaxcrtl routines other than socket routines does not have the vaxc$ prefix */ #define vaxc$close close #define vaxc$read read #define vaxc$write write #endif void ucx_socket_fptr(int s); void ucx_close_fptr(int s);  #endif   #ifdef __GNUC__  #include <stddef.h> E /* #do not include <arpa/inet.h>  it maps to DECC$RTL/UCX$RTL Only */ 1 /* Socketshr is now only needed for CMU-IP/VAX */ < /* Here is the stuff that will work from the GCC headers. */ /*8  * Internet address (a structure for historical reasons)  */  struct in_addr {     union { 6 	struct { unsigned char s_b1,s_b2,s_b3,s_b4; } S_un_b;- 	struct { unsigned short s_w1,s_w2; } S_un_w;  	unsigned long S_addr;     } S_un; C #define s_addr	S_un.S_addr	/* can be used for most tcp & ip code */ 1 #define s_host	S_un.S_un_b.s_b2	/* host on imp */ , #define s_net	S_un.S_un_b.s_b1	/* network */( #define s_imp	S_un.S_un_w.s_w2	/* imp */, #define s_impno S_un.S_un_b.s_b4	/* imp # */0 #define s_lh	S_un.S_un_b.s_b3	/* logical host */ }; /*"  * Socket address, internet style.  */  struct sockaddr_in { 	short	sin_family; 	unsigned short sin_port;  	struct	in_addr sin_addr;  	char	sin_zero[8]; }; int inet_addr (char *cp); $ char * inet_ntoa(struct in_addr in);   #include <sys/uio.h> #endif #include <stdio.h> #include <unixio.h>  #include <time.h>  #include <netdb.h> #include <socket.h>  #include <stdlib.h>  #ifndef __GNUC__ #include <in.h>  #endif #include <signal.h>  #include <string.h>  #include <errno.h>   /*  * Common include   */  #include "[-]si_socket.h"   " /* #define FTRACE__ stdout */ /**/ #include "[-]si_trace.h"   int isSocket(int s); int get_fd(FILE *fptr);   ( FILE *PACK(fdopen(int s, char *a_mode));   #ifndef VAXC&  /* GCC and DECC can use prototypes */% /*---------------------------------*/  short int PACK(get_sdc(int s)); 5 int PACK(socket(int domain, int type, int protocol)); ; int PACK(bind(int s, struct sockaddr * name, int namelen)); > int PACK(connect(int s, struct sockaddr * name, int namelen));% int PACK(listen(int s, int backlog)); > int PACK(accept(int s, struct sockaddr * addr, int *addrlen));6 int PACK(recv(int s, char * buf, int len, int flags));9 int PACK(recvfrom(int s, char *buf, int len, int flags, \ ( 	struct sockaddr *from, int * fromlen));5 int PACK(send(int s, char *msg, int len, int flags)); 7 int PACK(sendto(int s, char *msg, int len, int flags, \ " 	struct sockaddr *to, int tolen));# int PACK(shutdown(int s, int how)); 8 int PACK(select(int nfds, int *readfds, int *writefds, \+ 	int *execptfds, struct timeval *timeout)); B int PACK(getsockname(int s, struct sockaddr *name, int *namelen));B int PACK(getpeername(int s, struct sockaddr *name, int *namelen));O int PACK(getsockopt(int s, int level, int optname, char *optval, int *optlen)); N int PACK(setsockopt(int s, int level, int optname, char *optval, int optlen));0 int PACK(gethostname(char * name, int namelen));@ struct servent * socket_getservbyname(char * name, char * prot);= struct servent * socket_getservbyport(int port, char * prot); ) struct servent * socket_getservent(void); 5 struct protoent * socket_getprotobyname(char * name); 4 struct protoent * socket_getprotobynumber(int prot);+ struct protoent * socket_getprotoent(void); % int socket_setprotoent(int stayopen);  int socket_endprotoent(void); 2 struct hostent * PACK(gethostbyname(char * name));E struct hostent * PACK(gethostbyaddr(char * addr, int len, int type)); ( int PACK(read(int s, void *buf, int l));- int PACK(ioctl(int s, long req, void *argp)); ) int PACK(fcntl(int s, int cmd, int arg)); $ int socket_setservent(int stayopen); int socket_endservent(void);* unsigned long inet_addr(const char * str);% unsigned long ntohl(unsigned long x); % unsigned long ntohs(unsigned long x); % unsigned long htonl(unsigned long x); % unsigned long htons(unsigned long x); ! unsigned long PACK(close(int s)); < unsigned long PACK(write(int s, void * buffer, int nbytes));B unsigned long PACK(writeev(int s, struct iovec *iov, int iovcnt)); #endif   #ifndef VAXC #define noshare  #endif   #ifndef __DECC_VER& noshare FILE* ftrace__ = (FILE *)NULL; noshare int trace__ = 0; noshare int h_errno = 0; #endif   #ifdef __DECC_VER ( char * __inet_ntoa(struct in_addr __in); #endif   /*  * Locally used variables.  */ ! static struct sockaddr_in *saddr; ! static struct hostent *inet_host; ! static struct servent *inet_serv; # static struct protoent *inet_proto;    /*.  * Routines used only with the socket library.  */    /*  *	short int si_get_sdc(int s)1  *	int socket(int domain, int type, int protocol) 6  *	int bind(int s, struct sockaddr *name, int namelen)9  *	int connect(int s, struct sockaddr *name, int namelen) "  *	int listen (int s, int backlog)9  *	int accept(int s, struct sockaddr *addr, int *addrlen) 1  *	int recv(int s, char *buf, int len, int flags) 5  *	int recvfrom(int s, char *buf, int len, int flags, )  *			struct sockaddr *from, int *fromlen) 1  *	int send(int s, char *msg, int len, int flags) 3  *	int sendto(int s, char *msg, int len, int flags, $  *			struct sockaddr *to, int tolen)  *	int shutdown(int s, int how)   *D  *	int select(int nfds, int *readfds, int *writefds, int *execptfds,  *			struct timeval *timeout)   *>  *	int getsockname(int s, struct sockaddr *name, int *namelen)>  *	int getpeername(int s, struct sockaddr *name, int *namelen)0  *	int getsockopt(int s, int level, int optname,  *			char *optval, int *optlen) 0  *	int setsockopt(int s, int level, int optname,  *			char *optval, int optlen)  *+  *	int gethostname(char *name, int namelen) 9  *	struct servent *getservbyname(char *name, char *proto) 7  *	struct servent *getservbyport(int port, char *proto) #  *	struct servent *getservent(void)   *	int setservent(int stayopen)   *	int endservent(void) .  *	struct protoent *getprotobyname(char *name)/  *	struct protoent *getprotobynumber(int proto) %  *	struct protoent *getprotoent(void)    *	int setprotoent(int stayopen)  *	int endprotoent(void),  *	struct hostent *gethostbyname(char *name)?  *	struct hostent *gethostbyaddr(char *addr, int len, int type) +  *	struct hostent *gethostent(void)	[dummy] (  *	int sethostent(int stayopen)		[dummy]!  *	int endhostent(void)			[dummy]   */    /*)  * ======================================   * si_get_sdc get VMS channel )  * ======================================   */   	 short int  si_get_sdc(int s)  { ! 	STRACE("si_get_sdc",0,s,"",0,0);  	return( PACK(get_sdc(s)) ); }      /*)  * ====================================== 	  * socket )  * ======================================   */  int - si_socket(int domain, int type, int protocol)  {  	int s; : 	DTRACE("si_socket",0,"domain: %d, type: %d",domain,type);* 	s = PACK(socket(domain, type, protocol));
 #ifdef UCX 	ucx_socket_fptr(s); #endif< 	STRACE("si_socket",0,s,"domain: %d, type: %d",domain,type); 	return(s);  }  /*)  * ======================================   * bind )  * ======================================   */  int 2 si_bind(int s, struct sockaddr *name, int namelen) {  	int i; $ 	saddr = (struct sockaddr_in *)name;+ 	STRACE("si_bind",0,s,"addr: %s, port: %d",  		inet_ntoa(saddr->sin_addr),  			   ntohs(saddr->sin_port));- /*	return( PACK(bind(s, name, namelen)) ); */ " 	i = PACK(bind(s, name, namelen));& 	DTRACE("si_bind",0,"return: %d",i,0); 	return(i);  }  /*)  * ====================================== 
  * connect)  * ======================================   */  int 5 si_connect(int s, struct sockaddr *name, int namelen)  { $ 	saddr = (struct sockaddr_in *)name;. 	STRACE("si_connect",0,s,"addr: %s, port: %d", 		inet_ntoa(saddr->sin_addr),  		ntohs(saddr->sin_port));+ 	return (PACK(connect(s, name, namelen)) );  }  /*)  * ====================================== 	  * listen )  * ======================================   */  int  si_listen (int s, int backlog) { 1 	STRACE("si_listen",0,s,"backlog: %d",backlog,0); $ 	return( PACK(listen(s, backlog)) ); }  /*)  * ====================================== 	  * accept )  * ======================================   */  int 5 si_accept(int s, struct sockaddr *addr, int *addrlen)  {  	int i;   	STRACE("si_accept",0,s,"",0,0);$ 	i = PACK(accept(s, addr, addrlen));$ 	saddr = (struct sockaddr_in *)addr;5 	DTRACE("si_accept",0,"returned: addr: %s, port: %d", 6 		inet_ntoa(saddr->sin_addr), ntohs(saddr->sin_port)); 	return(i);  }  /*)  * ======================================   * recv )  * ======================================   */  int - si_recv(int s, char *buf, int len, int flags)  {  	int i; ( 	STRACE("si_recv",0,s,"%d bytes",len,0);$ 	i = PACK(recv(s, buf, len, flags));. 	DTRACE("si_recv",0,"received: %d bytes",i,0); 	DMPHX(0, buf, i); 	return(i);  }  /*)  * ======================================   * recvfrom )  * ======================================   */  int V si_recvfrom(int s, char *buf, int len, int flags, struct sockaddr *from, int *fromlen) {  	int i; , 	STRACE("si_recvfrom",0,s,"%d bytes",len,0);7 	i = PACK(recvfrom(s, buf, len, flags, from, fromlen));  #ifdef TRACE2 	DTRACE("si_recvfrom",0,"received: %d bytes",i,0);$ 	if (from != (struct sockaddr *)0) {% 		saddr = (struct sockaddr_in *)from; 1 		DTRACE("  --",0,"returned: addr: %s, port: %d", 7 			inet_ntoa(saddr->sin_addr), ntohs(saddr->sin_port));  	} 	DMPHX(0, buf, i); #endif 	return(i);  }  /*)  * ======================================   * send )  * ======================================   */  int - si_send(int s, char *msg, int len, int flags)  { ( 	STRACE("si_send",0,s,"%d bytes",len,0); 	DMPHX(0, msg, len);* 	return( PACK(send(s, msg, len, flags)) ); }  /*)  * ====================================== 	  * sendto )  * ======================================   */  int O si_sendto(int s, char *msg, int len, int flags, struct sockaddr *to, int tolen)  { * 	STRACE("si_sendto",0,s,"%d bytes",len,0); #ifdef TRACE" 	if (to != (struct sockaddr *)0) {# 		saddr = (struct sockaddr_in *)to; + 		DTRACE("  --",0,"To: addr: %s, port: %d",  			inet_ntoa(saddr->sin_addr), 			ntohs(saddr->sin_port));  	} 	DMPHX(0, msg, len); #endif7 	return( PACK(sendto(s, msg, len, flags, to, tolen)) );  }  /*)  * ======================================   * shutdown )  * ======================================   */  int  si_shutdown(int s, int how)  { + 	STRACE("si_shutdown",0,s,"how: %d",how,0); " 	return( PACK(shutdown(s, how)) ); }  /*)  * ====================================== 	  * select )  * ======================================   */  int @ si_select(int nfds, int *readfds, int *writefds, int *execptfds, 			struct timeval *timeout)  {  	DTRACE("si_select",0,"",0,0); 	if (timeout != NULL) { - 		DTRACE("  --",0,"Timeout: %d sec, %d usec", % 			timeout->tv_sec,timeout->tv_usec);  	}E 	return( PACK(select(nfds, readfds, writefds, execptfds, timeout)) );  }  /*)  * ======================================   * getsockname)  * ======================================   */  int : si_getsockname(int s, struct sockaddr *name, int *namelen) {  	int i; % 	STRACE("si_getsockname",0,s,"",0,0); ) 	i = PACK(getsockname(s, name, namelen)); $ 	saddr = (struct sockaddr_in *)name;A 	DTRACE("si_getsockname",0,"-- Local  Port: %d, Local  Addr: %s",  		ntohs(saddr->sin_port),  		inet_ntoa(saddr->sin_addr)); 	return(i);  }  /*)  * ======================================   * getpeername)  * ======================================   */  int : si_getpeername(int s, struct sockaddr *name, int *namelen) {  	int i; % 	STRACE("si_getpeername",0,s,"",0,0); ) 	i = PACK(getpeername(s, name, namelen)); $ 	saddr = (struct sockaddr_in *)name;A 	DTRACE("si_getpeername",0,"-- Remote Port: %d, Remote Addr: %s",  		ntohs(saddr->sin_port),  		inet_ntoa(saddr->sin_addr)); 	return(i);  }  /*)  * ====================================== 
  * getsockopt )  * ======================================   */  int G si_getsockopt(int s, int level, int optname, char *optval, int *optlen)  { 1 	STRACE("si_getsockopt",0,s,"opt: %d",optname,0); ? 	return( PACK(getsockopt(s, level, optname, optval, optlen)) );  }  /*)  * ====================================== 
  * setsockopt )  * ======================================   */  int F si_setsockopt(int s, int level, int optname, char *optval, int optlen) { 1 	STRACE("si_setsockopt",0,s,"opt: %d",optname,0); ? 	return( PACK(setsockopt(s, level, optname, optval, optlen)) );  }  /*)  * ======================================   * gethostname)  * ======================================   */  int ' si_gethostname(char *name, int namelen)  {  	int i; # 	DTRACE("si_gethostname",0,"",0,0); & 	i = PACK(gethostname(name, namelen));7 	DTRACE("si_gethostname",0,"returned name: %s",name,0);  	return(i);  }  /*)  * ======================================   * getservbyname)  * ======================================   */  struct servent *( si_getservbyname(char *name, char *prot) { 1 #if 0 /* !defined(__DECC) && defined(UCX) */ /**/ M /* Here is a very mysterious thing: When calling 'getservbyname' in VAXC/UCX, J  * a any DTRACE in this routine (even after the call) crashes the program.F  * I've not the slightest idea what happens. The work around is not toL  * use any of the trace routines. Another bug is that UCX returns -1 instead!  * of 0 if the name is not found.   */ - 	inet_serv = PACK(getservbyname(name, prot)); H 	if (inet_serv == (struct servent *)-1) inet_serv = (struct servent *)0; #else 0 	DTRACE("si_getservbyname",0,"name: %s",name,0); 	if (prot != NULL) {) 		DTRACE("  --",0,"protocol: %s",prot,0);  	}7 /*	inet_serv = PACK(getservbyname(name, prot)); */ /**/ 3 	inet_serv = socket_getservbyname(name, prot); /**/  #ifdef TRACE( 	if (inet_serv != (struct servent *)0) { 	char **pp; < 		DTRACE("si_getservbyname",0,"returned name: %s, port: %d",/ 			inet_serv->s_name,ntohs(inet_serv->s_port)); A 		DTRACE("  --",0,"returned protocol: %s", inet_serv->s_proto,0); , 		for (pp=inet_serv->s_aliases; *pp; pp++) {& 			DTRACE("  --",0,"alias: %s",*pp,0); 		}  	} #endif #endif 	return(inet_serv);  }  /*)  * ======================================   * getservbyport)  * ======================================   */  struct servent *& si_getservbyport(int port, char *prot) { 0 	DTRACE("si_getservbyport",0,"port: %d",port,0); 	if (prot != NULL) {) 		DTRACE("  --",0,"protocol: %s",prot,0);  	}7 /*	inet_serv = PACK(getservbyport(port, prot)); */ /**/ 3 	inet_serv = socket_getservbyport(port, prot); /**/  #ifdef TRACE+ 	if (inet_serv != (struct servent *)NULL) {  	char **pp; < 		DTRACE("si_getservbyport",0,"returned name: %s, port: %d",/ 			inet_serv->s_name,ntohs(inet_serv->s_port)); A 		DTRACE("  --",0,"returned protocol: %s", inet_serv->s_proto,0);N, 		for (pp=inet_serv->s_aliases; *pp; pp++) {& 			DTRACE("  --",0,"alias: %s",*pp,0); 		}  	} #endif 	return(inet_serv);  }* /*)  * ======================================N
  * getserventl)  * ======================================O  */  struct servent * si_getservent(void)v {c" 	DTRACE("si_getservent",0,"",0,0);! 	inet_serv = socket_getservent();  #ifdef TRACE+ 	if (inet_serv != (struct servent *)NULL) {  	char **pp;t9 		DTRACE("si_getservent",0,"returned name: %s, port: %d", / 			inet_serv->s_name,ntohs(inet_serv->s_port));rA 		DTRACE("  --",0,"returned protocol: %s", inet_serv->s_proto,0);*, 		for (pp=inet_serv->s_aliases; *pp; pp++) {& 			DTRACE("  --",0,"alias: %s",*pp,0); 		}f 	} #endif 	return(inet_serv);m }c /*)  * ====================================== 
  * setserventp)  * ======================================c  */u inta si_setservent(int stayopen)N {I5 	DTRACE("si_setservent",0,"stayopen: %d",stayopen,0);t% 	return(socket_setservent(stayopen));K }c /*)  * ======================================)
  * endserventk)  * ======================================e  */p int  si_endservent(void)i { " 	DTRACE("si_endservent",0,"",0,0); 	return(socket_endservent());t }d /*)  * ======================================n  * getprotobyname#)  * ======================================*  */d struct protoent *x si_getprotobyname(char *name)f {l1 	DTRACE("si_getprotobyname",0,"name: %s",name,0);A3 /*	inet_proto = PACK(getprotobyname(name)); */ /**/V/ 	inet_proto = socket_getprotobyname(name); /**/c #ifdef TRACE- 	if (inet_proto != (struct protoent *)NULL) {r 	char **pp; A 		DTRACE("si_getprotobyname",0,"returned name: %s, protocol: %d",c+ 			inet_proto->p_name,inet_proto->p_proto); - 		for (pp=inet_proto->p_aliases; *pp; pp++) {i& 			DTRACE("  --",0,"alias: %s",*pp,0); 		}  	} #endif 	return(inet_proto); }h /*)  * ======================================o  * getprotobynumbery)  * ======================================M  */V struct protoent *t si_getprotobynumber(int prot)e {C7 	DTRACE("si_getprotobynumber",0,"protocol: %d",prot,0);s5 /*	inet_proto = PACK(getprotobynumber(prot)); */ /**/ 1 	inet_proto = socket_getprotobynumber(prot); /**/_ #ifdef TRACE- 	if (inet_proto != (struct protoent *)NULL) {  	char **pp; C 		DTRACE("si_getprotobynumber",0,"returned name: %s, protocol: %d",&+ 			inet_proto->p_name,inet_proto->p_proto);	- 		for (pp=inet_proto->p_aliases; *pp; pp++) {_& 			DTRACE("  --",0,"alias: %s",*pp,0); 		}_ 	} #endif 	return(inet_proto); }u /*)  * ======================================s  * getprotoent)  * ======================================   */. struct protoent *a si_getprotoent(void) {l# 	DTRACE("si_getprotoent",0,"",0,0);c# 	inet_proto = socket_getprotoent();8 #ifdef TRACE- 	if (inet_proto != (struct protoent *)NULL) {n 	char **pp; > 		DTRACE("si_getprotoent",0,"returned name: %s, protocol: %d",+ 			inet_proto->p_name,inet_proto->p_proto);>- 		for (pp=inet_proto->p_aliases; *pp; pp++) {i& 			DTRACE("  --",0,"alias: %s",*pp,0); 		}c 	} #endif 	return(inet_proto); }  /*)  * ======================================   * setprotoent)  * ======================================o  */  int  si_setprotoent(int stayopen) {s6 	DTRACE("si_setprotoent",0,"stayopen: %d",stayopen,0);& 	return(socket_setprotoent(stayopen)); }C /*)  * ======================================-  * endprotoent)  * ======================================t  */  int  si_endprotoent(void) {n# 	DTRACE("si_endprotoent",0,"",0,0);n 	return(socket_endprotoent()); }t /*)  * ======================================c  * gethostbyname)  * ======================================l  */  struct hostent * si_gethostbyname(char *name) {t0 	DTRACE("si_gethostbyname",0,"name: %s",name,0);' 	inet_host = PACK(gethostbyname(name));  #ifdef TRACE+ 	if (inet_host != (struct hostent *)NULL) {m 	char **pp;e< 		DTRACE("si_gethostbyname",0,"returned name: %s, addr: %s",/ 			inet_host->h_name,INTOA(inet_host->h_addr));a, 		for (pp=inet_host->h_aliases; *pp; pp++) {& 			DTRACE("  --",0,"alias: %s",*pp,0); 		}s 	} #endif 	return(inet_host);  }i /*)  * ======================================o  * gethostbyaddr)  * ======================================t  */e struct hostent */ si_gethostbyaddr(char *addr, int len, int type)e {)= 	DTRACE("si_gethostbyaddr",0,"addr: %08X",*((long *)addr),0);t2 	inet_host = PACK(gethostbyaddr(addr, len, type)); #ifdef TRACE+ 	if (inet_host != (struct hostent *)NULL) {g 	char **pp;a< 		DTRACE("si_gethostbyaddr",0,"returned name: %s, addr: %s",/ 			inet_host->h_name,INTOA(inet_host->h_addr));c, 		for (pp=inet_host->h_aliases; *pp; pp++) {& 			DTRACE("  --",0,"alias: %s",*pp,0); 		}u 	} #endif 	return(inet_host);m }h /*)  * ======================================b
  * gethostentt)  * ======================================i  */  struct hostent * si_gethostent(void)  { 3 	DTRACE("si_gethostent",0,"--not supported--",0,0);h 	return((struct hostent *)0);t }s /*)  * ====================================== 
  * sethostentn)  * ======================================   */i inti si_sethostent(int stayopen)  {nH 	DTRACE("si_sethostent",0,"stayopen: %d, --not supported--",stayopen,0); 	return(0);k }e /*)  * ====================================== 
  * endhostentn)  * ======================================n  */n inth si_endhostent(void)  {i3 	DTRACE("si_endhostent",0,"--not supported--",0,0);n 	return(0);n })   /*!  * Routines shared with unix I/O.i  *  *	int close(int s)s&  *	int read(int s, char *buf, int len)2  *	int write(int s, char *msg, int len, int flags)  */;   /*)  * ======================================f  * si_close_)  * ======================================N  */  intr si_close(int s); {o 	STRACE("si_close",0,s,"",0,0); 
 #ifdef UCX 	ucx_close_fptr(s);_ #endif3 	return( isSocket(s) ? PACK(close(s)) : close(s) );i }e   /*)  * ======================================t  * si_writet)  * ======================================e  */v intt" si_write (int s, void *buf, int l) { ' 	STRACE("si_write",0,s,"%d bytes",l,0);  	DMPHX(0, buf, l);C 	return( isSocket(s) ? PACK(write(s, buf, l)) : write(s, buf, l) );  }    /*)  * ======================================a
  * si_read)  * ======================================   */, intn! si_read (int s, void *buf, int l)  {k 	int i;i& 	STRACE("si_read",0,s,"%d bytes",l,0);- 	if ( !isSocket(s) ) return(read(s, buf, l));n 	i = PACK(read(s, buf, l));cH 	STRACE("si_read",0,s,"return - %d bytes received, errno = %d",i,errno); 	DMPHX(0, buf, i); 	return(i);, }a   /*:  * Routines that should work with non-socket fd's, but are4  * still not present in the RTL (not even in DEC-C).  */i   /*)  * ======================================n  * si_writev)  * ======================================	  */c     int 0 si_writev (int s, struct iovec *iov, int iovcnt) {a 	int i;, 	int k;e
 	int cnt = 0;t    	STRACE("si_writev",0,s,"",0,0); 	for(i=0;i<iovcnt;i++) {P /* fprintf(stderr,"  %d: len = %d\n{%s}\n",i,iov[i].iov_len,iov[i].iov_base); */ 		k = (isSocket(s) ?3 			si_send(s, iov[i].iov_base, iov[i].iov_len, 0) : / 			write(s, iov[i].iov_base, iov[i].iov_len) );  		if (k == -1) return(-1); 		cnt += k;m 	}
 	return(cnt);* }r   /*)  * ======================================   * si_ioctle)  * ======================================(  */t intn% si_ioctl(int s, long req, void *argp)  {t) 	STRACE("ioctl",0,s,"request: %d",req,0); 8 	return( isSocket(s) ? PACK(ioctl(s, req, argp)) : -1 ); }e   /*)  * ======================================)  * si_fcntlr)  * ======================================a  */a intm! si_fcntl(int s, int cmd, int arg)r {a3 	STRACE("si_fcntl",0,s,"cmd: %d, arg: %d",cmd,arg);o7 	return( isSocket(s) ? PACK(fcntl(s, cmd, arg)) : -1 );u }]   /*)  * ======================================   * si_fdopen)  * ======================================   */M FILE * si_fdopen (int s, char *a_mode)= {=- 	STRACE("si_fdopen",0,s,"mode: %s",a_mode,0); E 	return( isSocket(s) ? PACK(fdopen(s, a_mode)) : fdopen(s, a_mode) );  }    /*A  * Now the standard I/O functions. Shared with file standard I/O.=  *  *	int fileno(FILE * fptr)7  *	int fread(char *buf, int nsize, int num, FILE *fptr) 8  *	int fwrite(char *buf, int nsize, int num, FILE *fptr)  *	int fgetc(FILE *fptr).  *	char *fgets(char *buf, int num, FILE *fptr)  *	int fputc(int c, FILE *fptr)R#  *	int fputs(char *buf, FILE *fptr):  *	int fclose(FILE *fptr)(  *	int rewind(FILE *fptr)=  *	int fflush(FILE *fptr) *  *	int fprintf(FILE *fptr, char *fmt, ...)  *@  *	Note that feof() and ferror() are implemented through macros.  */    /*)  * ======================================;  * si_fileno)  * ======================================o  */d intn si_fileno(FILE * fptr) {- 	int s;)# 	FTRACE("si_fileno",0,fptr,"",0,0);e( 	if ( (s=get_fd(fptr)) != -1) return(s); 	return(fileno(fptr)); },   /*)  * =======================================  * si_fread=)  * =======================================  */= int=3 si_fread(char *buf, int nsize, int num, FILE *fptr)t {t 	int s;  	int i;t  < 	FTRACE("si_fread",0,fptr,"%d units of %d bytes",num,nsize);E 	if ( (s=get_fd(fptr)) == -1) return( fread(buf, nsize, num, fptr) );	  	i = si_recv(s,buf,nsize*num,0); 	return( (i>0) ? i : 0 );l })     /*)  * =======================================  * si_fwrite)  * =======================================  */* intn4 si_fwrite(char *buf, int nsize, int num, FILE *fptr) {n 	int s;c 	int i;,  = 	FTRACE("si_fwrite",0,fptr,"%d units of %d bytes",num,nsize);=F 	if ( (s=get_fd(fptr)) == -1) return( fwrite(buf, nsize, num, fptr) );  	i = si_send(s,buf,nsize*num,0); 	return( (i>0) ? i : 0 );k }r /*)  * ======================================s  * si_fgetc,)  * ======================================)  */s int= si_fgetc(FILE *fptr) {d 	int s;C 	char cbuf[1];  " 	FTRACE("si_fgetc",0,fptr,"",0,0);4 	if ( (s=get_fd(fptr)) == -1) return( fgetc(fptr) );2         if (si_recv(s,cbuf,1,0) <= 0) return(EOF); 	return((int)((*cbuf) & 0xFF));= }=   /*)  * ======================================n  * si_fgetsf)  * ======================================C  */_ char *( si_fgets(char *buf, int num, FILE *fptr) {l
 	int s, i; 	char cbuf[1], *t;  0 	FTRACE("si_fgets",0,fptr,"%d bytes max",num,0); /*>  * we need to read a character string from the socket which is=  * terminated by a nl. Do this the hard way by reading 1 char   * at a time and testing it.  */ < 	if ( (s=get_fd(fptr)) == -1) return( fgets(buf,num,fptr) );	 	t = buf;C 	for (i=1;i<num;i++) {! 		if (si_recv(s,cbuf,1,0) <= 0) {s 			return(NULL); 		}, 		*t++ = cbuf[0];f 		if (cbuf[0] == '\n') break;, 	} 	*t = '\0';e
 	return(buf);f }    /*)  * ======================================k  * si_fputcm)  * ======================================p  */% int  si_fputc(int c, FILE *fptr), {o 	int s;>  5 	FTRACE("si_fputc",0,fptr,"char: {%c} (0x%02X)",c,c); 6 	if ( (s=get_fd(fptr)) == -1) return( fputc(c,fptr) );( 	return( si_send(s, (char *)&c, 1, 0) ); }=   /*)  * ======================================e  * si_fputs )  * ======================================0  */D int0 si_fputs(char *buf, FILE *fptr)s {s 	int s;l	 	int num;    	num = strlen(buf);=, 	FTRACE("si_fputs",0,fptr,"%d bytes",num,0);8 	if ( (s=get_fd(fptr)) == -1) return( fputs(buf,fptr) );  	return( si_send(s,buf,num,0) ); }      /*)  * ======================================e  * si_fclose)  * ======================================t  */s intd si_fclose(FILE *fptr)r {  	int s;i  # 	FTRACE("si_fclose",0,fptr,"",0,0);%5 	if ( (s=get_fd(fptr)) == -1) return( fclose(fptr) );s 	return( si_close(s) );  }P   /*)  * ======================================   * si_rewind)  * =======================================  */= int= si_rewind(FILE *fptr)d {  	int s;=  # 	FTRACE("si_rewind",0,fptr,"",0,0); * /* don't do anything if its one of ours */5 	if ( (s=get_fd(fptr)) == -1) return( rewind(fptr) );C 	return(0);  })   /*)  * =======================================  * si_fflush)  * =======================================  */  int  si_fflush(FILE *fptr)s {n 	int s;s  # 	FTRACE("si_fflush",0,fptr,"",0,0);r* /* don't do anything if its one of ours */5 	if ( (s=get_fd(fptr)) == -1) return( fflush(fptr) );- 	return(0);  }s   /*)  * ======================================e
  * si_fprintfr)  * ======================================c  */, intoN si_fprintf(fptr,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16) FILE *fptr;=
 char *format;=K int *a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11,*a12,*a13,*a14,*a15,*a16;e {) 	char buf[1024]; 	int s;_  5 	FTRACE("si_fprintf",0,fptr,"format: {%s}",format,0);, /*C  * this is not pretty but how else can we handle variable number ofmC  * arguments except declare lots of them, no checking is done if we)B  * supply to few. Of course if more than 16 are passed we get into  * awful trouble.=  */= 	if ( (s=get_fd(fptr)) == -1) {=V 		return(fprintf(fptr,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16)); 	}L 	sprintf(buf,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);( 	return( si_send(s,buf,strlen(buf),0) ); }t t /*  * Unsupported functions.s<  * These functions have entry points for future use of them.  *(  *	void signal(int sig, void (*func)() )?  *	int sigvec(int sig, struct sigvec *vec, struct sigvec *ovec)=  *	int alarm(int i)p  */*   /*)  * ======================================n  * si_signal)  * ======================================t  */i void si_signal(sig,func)s int sig; void (*func)();, {n 	DTRACE("si_signal",0,"",0,0); 	signal(sig,func); }p   /*)  * =======================================  * si_sigvec)  * =======================================  */= int= si_sigvec(sig,vec,ovec)i int sig; struct sigvec *vec, *ovec; {, 	DTRACE("si_sigvec",0,"",0,0); 	return(sigvec(sig,vec,ovec)); }d   /*)  * ======================================,  * si_alarmv)  * =======================================  */= int= si_alarm(i)  int i; {a 	DTRACE("si_alarm",0,"",0,0);= 	return(alarm(i)); }n   /*  * Conversion routines.t  *(  *	unsigned long si_inet_addr(char *str)(  *	char *si_inet_ntoa(struct in_addr in)2  *	unsigned long int si_ntohl(unsigned long int x)4  *	unsigned short int si_ntohs(unsigned short int x)2  *	unsigned long int si_htonl(unsigned long int x)4  *	unsigned short int si_htons(unsigned short int x)  */r  
 unsigned longv si_inet_addr(char *str)p {) 	XTRACE("inet_addr",0,"",0,0); 	return( inet_addr(str) ); }r char * si_inet_ntoa(struct in_addr in)g {e
 char * chptr;    	XTRACE("inet_ntoa",0,"",0,0); 	chptr = inet_ntoa(in);  	return chptr; }r unsigned long int  si_ntohl(unsigned long int x). {e 	XTRACE("ntohl",0,"",0,0); 	return( ntohl(x) ); }n unsigned short int si_ntohs(unsigned short int x) {  	XTRACE("ntohs",0,"",0,0); 	return( ntohs(x) ); }e unsigned long intr si_htonl(unsigned long int x)c {e 	XTRACE("htonl",0,"",0,0); 	return( htonl(x) ); }  unsigned short int si_htons(unsigned short int x) {p /* int i; */% 	XTRACE("htons",0,"in: %d %08X",x,x);, 	return( htons(x) ); }P   e #ifdef TRACE static int trace_flag = 0; static char *timestr = NULL;> /************************************************************/ /* trace_open						    */T> /************************************************************/ void _trace_open(char *str)v {_ 	time_t bintim;E	 	char *p;r 	char *logfile = NULL;   	time(&bintim);) 	timestr = ctime(&bintim) + 11;s 	timestr[8] = '\0';R 	if (trace_flag == 0) {*  		p = getenv("SOCKETSHR_DEBUG"); 		if (p != NULL) { 			trace__ = atoi(p);= 		}=" 		p = getenv("SOCKETSHR_LOGFILE"); 		if (p != NULL) { 			logfile = p;= 		}= 		trace_flag = 1;s 	}5 	if ( (trace__ != 0) && (FTRACE__ == (FILE*)NULL) ) {C 		if (logfile != NULL) {! 			ftrace__ = fopen(logfile,"w");) 		}	 		else { 			ftrace__ = stdout;o 		} - 		fprintf(ftrace__,"\nOpened by %s\n\n",str);r 	} }/> /************************************************************/3 /* strace - debug output with socket number		    */ > /************************************************************/G void _strace(char *str, int flag, int s, char *fmt, char *a1, char *a2)E {  	_trace_open(str);@ 	if ( (trace__ > 0 && isSocket(s)) || (trace__ == -1) || flag) {1 		fprintf(FTRACE__,"%s %s: s=%d ",timestr,str,s);0 		fprintf(FTRACE__,fmt,a1,a2); 		fprintf(FTRACE__,"\n");= 	} }=> /************************************************************/2 /* ftrace - debug output with file pointer		    */> /************************************************************/L void _ftrace(char *str, int flag, FILE *fptr, char *fmt, char *a1, char *a2) {U 	_trace_open(str);J 	if ( (trace__ > 0 && (get_fd(fptr) != -1)) || (trace__ == -1) || flag ) {9 		fprintf(FTRACE__,"%s %s: fptr=%08X ",timestr,str,fptr);r 		fprintf(FTRACE__,fmt,a1,a2); 		fprintf(FTRACE__,"\n");s 	} }a> /************************************************************/> /* dtrace - debug output without socket or file pointer ;-) */> /************************************************************/@ void _dtrace(char *str, int flag, char *fmt, char *a1, char *a2) {D 	_trace_open(str);1 	if ( (trace__ > 0) || (trace__ == -1) || flag) {t) 		fprintf(FTRACE__,"%s %s ",timestr,str);= 		fprintf(FTRACE__,fmt,a1,a2); 		fprintf(FTRACE__,"\n");= 	} }= => /************************************************************/> /* dmphx - dump a buffer to the debug log in hex and ascii  */> /************************************************************/ void _dmphx(f,msg,len)= FILE *f;
 char *msg; int len; {p   int i, j;i   unsigned char *v, *w;e     v = w = (unsigned char *)msg;,
   j = len;   while (j>0) {e       if (j>16) i = 16; else i=j;-      for(;i>0;i--,v++) fprintf(f," %02x",*v);m4      if (j<16) for(i=16-j;i>0;i--) fprintf(f,"   ");      fprintf(f,"        ");        if (j>16) i = 16; else i=j;F      for(;i>0;i--,w++) fprintf(f,"%c",(*w>0x1f && *w<0x80)? *w : '.');      fprintf(f,"\n");p
      j -= 16;_   }e }*   #endif	/* TRACE */