/* ----------------------- :                                    */
/*   Original Author       : Unknown 				*/
/*
/* ----------------------- :                                            */
/*   Date of Revision      : 16-JUN-1999                                */
/*   Change Author         : JLAURET                                    */
/*   Purpose of Revision   : Ensured compilation with DECC/VAXC/GNUC	*/
/*                         : Some basic check implemented.		*/
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */



#include <stdio.h>
#include <stdlib.h>
#ifdef VMS
#include <string.h>
#endif



/*
 * Computes the BSD checksum of a file or files.
 */
int main (int argc,char **argv)
{
        register unsigned sum;
        register i, c;
        register FILE *f;
        register long nbytes;
        int     errflg = 0;

        i = 1;
        do {
            if (i < argc) {
#ifdef VMS
		/* VMS is going to complain about those		*/
		if ( strchr(argv[i],'-') == argv[i] ){
			fprintf(stderr,"chksum :: cannot parse %s\n",argv[i]);
			continue;
		}
#endif
                if ((f = fopen(argv[i], "r")) == NULL) {
                    fprintf (stderr, "chksum :: Can't open %s\n", argv[i]);
                    errflg += 10;
                    continue;
                }
            } else {
                f = stdin;
	    }

            sum = 0;
            nbytes = 0;
            while ((c = getc(f)) != EOF) {
                nbytes++;
                if (sum&01)
                    sum = (sum>>1) + 0x8000;
                else
                    sum >>= 1;
                sum += c;
                sum &= 0xFFFF;
            }
            if (ferror (f)) {
                errflg++;
                fprintf (stderr, "chksum: read error on %s\n", argc>1?argv[i]:"-");
            }
            printf ("%05u%6ld %s\n", sum, (nbytes+BUFSIZ-1)/BUFSIZ,argv[i]);
            fclose (f);

        } while (++i < argc);

	/* Here we preserve the spirit of CHKSUM but this will		*/
	/* produce a CLI error message as well				*/
#ifdef VMS
	return (errflg==0?1:errflg);
#else
        return errflg;
#endif
}


